/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.IDSetIterator;
import org.opends.server.backends.jeb.IndexIteratorAllIds;
import org.opends.server.backends.jeb.JebFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryIDSet
implements Iterable<EntryID> {
    private static final String CLASS_NAME = "org.opends.server.backends.jeb.EntryIDSet";
    private long[] values = null;
    private byte[] keyBytes = null;

    public EntryIDSet() {
        this.values = null;
    }

    public EntryIDSet(byte[] byArray, byte[] byArray2) {
        this.keyBytes = byArray;
        if (byArray2 == null) {
            this.values = new long[0];
            return;
        }
        this.values = JebFormat.entryIDListFromDatabase(byArray2);
    }

    EntryIDSet(long[] lArray, int n, int n2) {
        this.values = new long[n2];
        System.arraycopy(lArray, n, this.values, 0, n2);
    }

    public static EntryIDSet unionOfSets(ArrayList<EntryIDSet> arrayList, boolean bl) {
        Object object;
        boolean bl2 = false;
        int n = 0;
        for (EntryIDSet entryIDSet : arrayList) {
            if (!entryIDSet.isDefined()) {
                return new EntryIDSet();
            }
            n += entryIDSet.size();
        }
        Object object2 = new long[n];
        int n2 = 0;
        for (EntryIDSet entryIDSet : arrayList) {
            if (entryIDSet.values.length == 0) continue;
            if (!bl2 && n2 > 0 && entryIDSet.values[0] < object2[n2 - 1]) {
                bl2 = true;
            }
            System.arraycopy(entryIDSet.values, 0, object2, n2, entryIDSet.values.length);
            n2 += entryIDSet.values.length;
        }
        if (bl2) {
            Arrays.sort((long[])object2);
        }
        if (bl) {
            object = new EntryIDSet();
            ((EntryIDSet)object).values = (long[])object2;
            return object;
        }
        object = new long[((Object)object2).length];
        Object object3 = -1L;
        int n3 = 0;
        for (int i = 0; i < ((Object)object2).length; ++i) {
            if (object2[i] == object3) continue;
            int n4 = n3++;
            Object object4 = object2[i];
            object[n4] = object4;
            object3 = object4;
        }
        if (n3 == ((Object)object).length) {
            EntryIDSet entryIDSet = new EntryIDSet();
            entryIDSet.values = (long[])object;
            return entryIDSet;
        }
        return new EntryIDSet((long[])object, 0, n3);
    }

    public int size() {
        if (this.values == null) {
            return Integer.MAX_VALUE;
        }
        return this.values.length;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(16);
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        if (!this.isDefined()) {
            if (this.keyBytes != null) {
                stringBuilder.append("[LIMIT-EXCEEDED]");
            } else {
                stringBuilder.append("[NOT-INDEXED]");
            }
        } else {
            stringBuilder.append("[COUNT:");
            stringBuilder.append(this.size());
            stringBuilder.append("]");
        }
    }

    public boolean isDefined() {
        return this.values != null;
    }

    public byte[] toDatabase() {
        return JebFormat.entryIDListToDatabase(this.values);
    }

    public boolean add(EntryID entryID) {
        if (this.values == null) {
            return false;
        }
        long l = entryID.longValue();
        if (this.values.length == 0) {
            this.values = new long[1];
            this.values[0] = l;
            return true;
        }
        if (l > this.values[this.values.length - 1]) {
            long[] lArray = new long[this.values.length + 1];
            System.arraycopy(this.values, 0, lArray, 0, this.values.length);
            lArray[this.values.length] = l;
            this.values = lArray;
        } else {
            int n = Arrays.binarySearch(this.values, l);
            if (n >= 0) {
                return false;
            }
            n = -(n + 1);
            long[] lArray = new long[this.values.length + 1];
            System.arraycopy(this.values, 0, lArray, 0, n);
            System.arraycopy(this.values, n, lArray, n + 1, this.values.length - n);
            lArray[n] = l;
            this.values = lArray;
        }
        return true;
    }

    public boolean remove(EntryID entryID) {
        if (this.values == null) {
            return false;
        }
        if (this.values.length == 0) {
            return false;
        }
        long l = entryID.longValue();
        int n = Arrays.binarySearch(this.values, l);
        if (n < 0) {
            return false;
        }
        long[] lArray = new long[this.values.length - 1];
        System.arraycopy(this.values, 0, lArray, 0, n);
        System.arraycopy(this.values, n + 1, lArray, n, this.values.length - n - 1);
        this.values = lArray;
        return true;
    }

    public boolean contains(EntryID entryID) {
        if (this.values == null) {
            return true;
        }
        long l = entryID.longValue();
        if (this.values.length == 0) {
            return false;
        }
        if (l > this.values[this.values.length - 1]) {
            return false;
        }
        int n = Arrays.binarySearch(this.values, l);
        return n >= 0;
    }

    public void retainAll(EntryIDSet entryIDSet) {
        if (!this.isDefined()) {
            this.values = entryIDSet.values;
            return;
        }
        if (!entryIDSet.isDefined()) {
            return;
        }
        long[] lArray = this.values;
        long[] lArray2 = entryIDSet.values;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        long[] lArray3 = new long[Math.min(lArray.length, lArray2.length)];
        while (n < lArray.length && n2 < lArray2.length) {
            if (lArray[n] == lArray2[n2]) {
                lArray3[n3] = lArray[n];
                ++n;
                ++n2;
                ++n3;
                continue;
            }
            if (lArray[n] > lArray2[n2]) {
                ++n2;
                continue;
            }
            ++n;
        }
        if (n3 < lArray3.length) {
            long[] lArray4 = new long[n3];
            System.arraycopy(lArray3, 0, lArray4, 0, n3);
            this.values = lArray4;
        } else {
            this.values = lArray3;
        }
    }

    public void addAll(EntryIDSet entryIDSet) {
        int n;
        long[] lArray;
        if (!this.isDefined()) {
            return;
        }
        if (!entryIDSet.isDefined()) {
            this.values = null;
            return;
        }
        long[] lArray2 = this.values;
        long[] lArray3 = entryIDSet.values;
        if (lArray2.length == 0) {
            this.values = lArray3;
            return;
        }
        if (lArray3.length == 0) {
            return;
        }
        if (lArray3[0] > lArray2[lArray2.length - 1]) {
            long[] lArray4 = new long[lArray2.length + lArray3.length];
            System.arraycopy(lArray2, 0, lArray4, 0, lArray2.length);
            System.arraycopy(lArray3, 0, lArray4, lArray2.length, lArray3.length);
            this.values = lArray4;
            return;
        }
        if (lArray2[0] > lArray3[lArray3.length - 1]) {
            long[] lArray5 = new long[lArray2.length + lArray3.length];
            System.arraycopy(lArray3, 0, lArray5, 0, lArray3.length);
            System.arraycopy(lArray2, 0, lArray5, lArray3.length, lArray2.length);
            this.values = lArray5;
            return;
        }
        if (lArray3.length < lArray2.length) {
            lArray = lArray2;
            lArray2 = lArray3;
            lArray3 = lArray;
        }
        lArray = new long[lArray2.length + lArray3.length];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n3 < lArray2.length && n4 < lArray3.length) {
            if (lArray2[n3] < lArray3[n4]) {
                lArray[n2++] = lArray2[n3++];
                continue;
            }
            if (lArray3[n4] < lArray2[n3]) {
                lArray[n2++] = lArray3[n4++];
                continue;
            }
            lArray[n2++] = lArray2[n3];
            ++n3;
            ++n4;
        }
        int n5 = lArray2.length - n3;
        if (n5 > 0) {
            System.arraycopy(lArray2, n3, lArray, n2, n5);
            n2 += n5;
        }
        if ((n = lArray3.length - n4) > 0) {
            System.arraycopy(lArray3, n4, lArray, n2, n);
            n2 += n;
        }
        if (n2 < lArray.length) {
            long[] lArray6 = new long[n2];
            System.arraycopy(lArray, 0, lArray6, 0, n2);
            this.values = lArray6;
        } else {
            this.values = lArray;
        }
    }

    public void deleteAll(EntryIDSet entryIDSet) {
        if (!this.isDefined()) {
            return;
        }
        if (!entryIDSet.isDefined()) {
            this.values = null;
            return;
        }
        long[] lArray = this.values;
        long[] lArray2 = entryIDSet.values;
        if (lArray.length == 0 || lArray2.length == 0) {
            return;
        }
        if (lArray2[0] > lArray[lArray.length - 1]) {
            return;
        }
        if (lArray[0] > lArray2[lArray2.length - 1]) {
            return;
        }
        long[] lArray3 = new long[lArray.length];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n2 < lArray.length && n3 < lArray2.length) {
            if (lArray[n2] < lArray2[n3]) {
                lArray3[n++] = lArray[n2++];
                continue;
            }
            if (lArray2[n3] < lArray[n2]) {
                ++n3;
                continue;
            }
            ++n2;
            ++n3;
        }
        System.arraycopy(lArray, n2, lArray3, n, lArray.length - n2);
        if ((n += lArray.length - n2) < lArray.length) {
            long[] lArray4 = new long[n];
            System.arraycopy(lArray3, 0, lArray4, 0, n);
            this.values = lArray4;
        } else {
            this.values = lArray3;
        }
    }

    @Override
    public Iterator<EntryID> iterator() {
        if (this.values == null) {
            return new IndexIteratorAllIds();
        }
        return new IDSetIterator(this.values);
    }
}

