/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.Transaction;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.Index;
import org.opends.server.protocols.asn1.ASN1OctetString;

public class BufferedIndex {
    private Index index;
    private Transaction txn;
    private HashMap<ASN1OctetString, BufferedValue> values;

    public BufferedIndex(Index index, Transaction transaction) {
        this.index = index;
        this.txn = transaction;
        this.values = new LinkedHashMap<ASN1OctetString, BufferedValue>();
    }

    public EntryIDSet get(byte[] byArray) {
        return this.getCachedValue((byte[])byArray).value;
    }

    private BufferedValue getCachedValue(byte[] byArray) {
        BufferedValue bufferedValue = this.values.get(new ASN1OctetString(byArray));
        if (bufferedValue == null) {
            bufferedValue = new BufferedValue();
            bufferedValue.value = this.index.readKey(new DatabaseEntry(byArray), this.txn, LockMode.RMW);
            bufferedValue.isDirty = false;
            this.values.put(new ASN1OctetString(byArray), bufferedValue);
        }
        return bufferedValue;
    }

    public void insertID(int n, byte[] byArray, EntryID entryID) {
        BufferedValue bufferedValue = this.getCachedValue(byArray);
        EntryIDSet entryIDSet = bufferedValue.value;
        if (entryIDSet.isDefined()) {
            if (n > 0 && entryIDSet.size() >= n) {
                bufferedValue.value = new EntryIDSet();
                bufferedValue.isDirty = true;
            } else {
                bufferedValue.isDirty = entryIDSet.add(entryID);
            }
        }
    }

    public void removeID(byte[] byArray, EntryID entryID) {
        BufferedValue bufferedValue = this.getCachedValue(byArray);
        bufferedValue.isDirty = bufferedValue.value.remove(entryID);
    }

    public void remove(byte[] byArray) {
        BufferedValue bufferedValue = this.getCachedValue(byArray);
        bufferedValue.value = new EntryIDSet(byArray, null);
        bufferedValue.isDirty = true;
    }

    public void flush() throws DatabaseException {
        for (Map.Entry<ASN1OctetString, BufferedValue> entry : this.values.entrySet()) {
            BufferedValue bufferedValue = entry.getValue();
            if (!bufferedValue.isDirty) continue;
            this.index.writeKey(this.txn, new DatabaseEntry(entry.getKey().value()), bufferedValue.value);
            bufferedValue.isDirty = false;
        }
    }

    private class BufferedValue {
        EntryIDSet value;
        boolean isDirty;

        private BufferedValue() {
        }
    }
}

