/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.Mac;
import org.opends.server.api.Backend;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigConstants;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.DNConfigAttribute;
import org.opends.server.core.AddOperation;
import org.opends.server.core.CryptoManager;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.BackupInfo;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.RDN;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaBackend
extends Backend
implements ConfigurableComponent {
    private static final String CLASS_NAME = "org.opends.server.backends.SchemaBackend";
    private ArrayList<Attribute> userDefinedAttributes;
    private HashMap<ObjectClass, String> schemaObjectClasses;
    private DN configEntryDN;
    private DN[] baseDNs;
    private HashSet<String> supportedControls;
    private HashSet<String> supportedFeatures;

    public SchemaBackend() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initializeBackend(ConfigEntry configEntry, DN[] dNArray) throws ConfigException, InitializationException {
        void var4_13;
        assert (Debug.debugEnter(CLASS_NAME, "initializeBackend", String.valueOf(configEntry)));
        if (configEntry == null) {
            int n = 9699366;
            String string = MessageHandler.getMessage(n);
            throw new ConfigException(n, string);
        }
        this.configEntryDN = configEntry.getDN();
        this.userDefinedAttributes = new ArrayList();
        for (List<Attribute> object2 : configEntry.getEntry().getUserAttributes().values()) {
            for (Attribute attribute : object2) {
                if (this.isSchemaConfigAttribute(attribute)) continue;
                this.userDefinedAttributes.add(attribute);
            }
        }
        for (List<Attribute> list : configEntry.getEntry().getOperationalAttributes().values()) {
            for (Attribute attribute : list) {
                if (this.isSchemaConfigAttribute(attribute)) continue;
                this.userDefinedAttributes.add(attribute);
            }
        }
        this.baseDNs = dNArray;
        DirectoryServer.registerPrivateSuffix(dNArray[0], this);
        DirectoryServer.setSchemaDN(dNArray[0]);
        for (int i = 1; i < dNArray.length; ++i) {
            DirectoryServer.registerPrivateSuffix(dNArray[i], this);
        }
        this.schemaObjectClasses = new LinkedHashMap<ObjectClass, String>(3);
        this.schemaObjectClasses.put(DirectoryServer.getTopObjectClass(), "top");
        ObjectClass objectClass = DirectoryServer.getObjectClass("ldapsubentry");
        if (objectClass == null) {
            objectClass = DirectoryServer.getDefaultObjectClass("ldapSubentry");
        }
        this.schemaObjectClasses.put(objectClass, "ldapSubentry");
        ObjectClass objectClass2 = DirectoryServer.getObjectClass("subschema");
        if (objectClass2 == null) {
            ObjectClass objectClass3 = DirectoryServer.getDefaultObjectClass("subschema");
        }
        this.schemaObjectClasses.put((ObjectClass)var4_13, "subschema");
        this.supportedControls = new HashSet(0);
        this.supportedFeatures = new HashSet(0);
        DirectoryServer.registerConfigurableComponent(this);
    }

    @Override
    public void finalizeBackend() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeBackend", new String[0]));
        DirectoryServer.deregisterConfigurableComponent(this);
    }

    private boolean isSchemaConfigAttribute(Attribute attribute) {
        assert (Debug.debugEnter(CLASS_NAME, "isConfigAttribute", String.valueOf(attribute)));
        AttributeType attributeType = attribute.getAttributeType();
        return attributeType.hasName("ds-cfg-schema-entry-dn".toLowerCase()) || attributeType.hasName("ds-cfg-backend-enabled".toLowerCase()) || attributeType.hasName("ds-cfg-backend-class".toLowerCase()) || attributeType.hasName("ds-cfg-backend-id".toLowerCase()) || attributeType.hasName("ds-cfg-backend-base-dn".toLowerCase()) || attributeType.hasName("cn");
    }

    @Override
    public DN[] getBaseDNs() {
        assert (Debug.debugEnter(CLASS_NAME, "getBaseDNs", new String[0]));
        return this.baseDNs;
    }

    @Override
    public boolean isLocal() {
        assert (Debug.debugEnter(CLASS_NAME, "isLocal", new String[0]));
        return true;
    }

    @Override
    public Entry getEntry(DN dN) throws DirectoryException {
        DN[] dNArray;
        assert (Debug.debugEnter(CLASS_NAME, "getEntry", String.valueOf(dN)));
        for (DN dN2 : dNArray = this.baseDNs) {
            if (!dN.equals(dN2)) continue;
            return this.getSchemaEntry(dN);
        }
        return null;
    }

    public Entry getSchemaEntry(DN dN) {
        List<Attribute> list;
        AttributeType attributeType;
        Object object;
        Object object2;
        Object object3;
        assert (Debug.debugEnter(CLASS_NAME, "getSchemaEntry", String.valueOf(dN)));
        LinkedHashMap<AttributeType, List<Attribute>> linkedHashMap = new LinkedHashMap<AttributeType, List<Attribute>>();
        LinkedHashMap<AttributeType, List<Attribute>> linkedHashMap2 = new LinkedHashMap<AttributeType, List<Attribute>>();
        RDN rDN = dN.getRDN();
        if (rDN != null) {
            object3 = rDN.getAttributeNames();
            object2 = rDN.getAttributeTypes();
            object = rDN.getAttributeValues();
            int n = ((AttributeType[])object2).length;
            for (int i = 0; i < n; ++i) {
                LinkedHashSet<AttributeValue> object4 = new LinkedHashSet<AttributeValue>(1);
                object4.add(object[i]);
                attributeType = object2[i];
                list = new Attribute(attributeType, object3[i], object4);
                ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
                arrayList.add((Attribute)((Object)list));
                if (attributeType.isOperational()) {
                    linkedHashMap2.put(attributeType, arrayList);
                    continue;
                }
                linkedHashMap.put(attributeType, arrayList);
            }
        }
        if ((object3 = DirectoryServer.getAttributeType("attributetypes")) == null) {
            object3 = DirectoryServer.getDefaultAttributeType("attributeTypes");
        }
        object2 = DirectoryServer.getAttributeTypeSet();
        object = new Attribute((AttributeType)object3, "attributeTypes", (LinkedHashSet<AttributeValue>)object2);
        ArrayList<AttributeValue[]> arrayList = new ArrayList<AttributeValue[]>(1);
        arrayList.add((AttributeValue[])object);
        linkedHashMap.put((AttributeType)object3, (List<Attribute>)arrayList);
        object3 = DirectoryServer.getAttributeType("objectclasses");
        if (object3 == null) {
            object3 = DirectoryServer.getDefaultAttributeType("objectClasses");
        }
        object2 = DirectoryServer.getObjectClassSet();
        object = new Attribute((AttributeType)object3, "objectClasses", (LinkedHashSet<AttributeValue>)object2);
        arrayList = new ArrayList(1);
        arrayList.add((AttributeValue[])object);
        linkedHashMap.put((AttributeType)object3, (List<Attribute>)arrayList);
        object3 = DirectoryServer.getAttributeType("matchingrules");
        if (object3 == null) {
            object3 = DirectoryServer.getDefaultAttributeType("matchingRules");
        }
        object2 = DirectoryServer.getMatchingRuleSet();
        object = new Attribute((AttributeType)object3, "matchingRules", (LinkedHashSet<AttributeValue>)object2);
        arrayList = new ArrayList(1);
        arrayList.add((AttributeValue[])object);
        linkedHashMap.put((AttributeType)object3, (List<Attribute>)arrayList);
        object3 = DirectoryServer.getAttributeType("ldapsyntaxes");
        if (object3 == null) {
            object3 = DirectoryServer.getDefaultAttributeType("ldapSyntaxes");
        }
        object2 = DirectoryServer.getAttributeSyntaxSet();
        object = new Attribute((AttributeType)object3, "ldapSyntaxes", (LinkedHashSet<AttributeValue>)object2);
        arrayList = new ArrayList(1);
        arrayList.add((AttributeValue[])object);
        linkedHashMap.put((AttributeType)object3, (List<Attribute>)arrayList);
        for (Attribute attribute : this.userDefinedAttributes) {
            attributeType = attribute.getAttributeType();
            if (attributeType.isOperational()) {
                list = linkedHashMap2.get(attributeType);
                if (list == null) {
                    list = new ArrayList<Attribute>();
                    list.add(attribute);
                    linkedHashMap2.put(attributeType, list);
                    continue;
                }
                list.add(attribute);
                continue;
            }
            list = linkedHashMap.get(attributeType);
            if (list == null) {
                list = new ArrayList<Attribute>();
                list.add(attribute);
                linkedHashMap.put(attributeType, list);
                continue;
            }
            list.add(attribute);
        }
        return new Entry(dN, this.schemaObjectClasses, linkedHashMap, linkedHashMap2);
    }

    @Override
    public boolean entryExists(DN dN) throws DirectoryException {
        DN[] dNArray;
        assert (Debug.debugEnter(CLASS_NAME, "entryExists", String.valueOf(dN)));
        for (DN dN2 : dNArray = this.baseDNs) {
            if (!dN.equals(dN2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addEntry(Entry entry, AddOperation addOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "addEntry", String.valueOf(entry), String.valueOf(addOperation)));
        int n = 9633833;
        String string = MessageHandler.getMessage(n, String.valueOf(entry.getDN()));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public void deleteEntry(DN dN, DeleteOperation deleteOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "deleteEntry", String.valueOf(dN), String.valueOf(deleteOperation)));
        int n = 9633834;
        String string = MessageHandler.getMessage(n, String.valueOf(dN));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public void replaceEntry(Entry entry, ModifyOperation modifyOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "replaceEntry", String.valueOf(entry), String.valueOf(modifyOperation)));
        int n = 9633835;
        String string = MessageHandler.getMessage(n, String.valueOf(entry.getDN()), String.valueOf(this.configEntryDN));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public void renameEntry(DN dN, Entry entry, ModifyDNOperation modifyDNOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "renameEntry", String.valueOf(dN), String.valueOf(entry), String.valueOf(modifyDNOperation)));
        int n = 9633836;
        String string = MessageHandler.getMessage(n, String.valueOf(dN));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public void search(SearchOperation searchOperation) throws DirectoryException {
        DN[] dNArray;
        assert (Debug.debugEnter(CLASS_NAME, "search", String.valueOf(searchOperation)));
        DN dN = searchOperation.getBaseDN();
        boolean bl = false;
        for (DN dN2 : dNArray = this.baseDNs) {
            if (!dN2.equals(dN)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            int n = 0x930030;
            String entry = MessageHandler.getMessage(n, searchOperation.getConnectionID(), searchOperation.getOperationID(), String.valueOf(dN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, entry, n);
        }
        SearchScope searchScope = searchOperation.getScope();
        if (searchScope == SearchScope.SINGLE_LEVEL || searchScope == SearchScope.SUBORDINATE_SUBTREE) {
            return;
        }
        Entry entry = this.getSchemaEntry(dN);
        SearchFilter searchFilter = searchOperation.getFilter();
        if (searchFilter.matchesEntry(entry)) {
            searchOperation.returnEntry(entry, null);
        }
    }

    public HashSet<String> getSupportedControls() {
        assert (Debug.debugEnter(CLASS_NAME, "getSupportedControls", new String[0]));
        return this.supportedControls;
    }

    @Override
    public boolean supportsControl(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "supportsControl", String.valueOf(string)));
        return false;
    }

    public HashSet<String> getSupportedFeatures() {
        assert (Debug.debugEnter(CLASS_NAME, "getSupportedFeatures", new String[0]));
        return this.supportedFeatures;
    }

    @Override
    public boolean supportsFeature(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "supportsFeature", String.valueOf(string)));
        return false;
    }

    @Override
    public boolean supportsLDIFExport() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsLDIFExport", new String[0]));
        return true;
    }

    @Override
    public void exportLDIF(ConfigEntry configEntry, DN[] dNArray, LDIFExportConfig lDIFExportConfig) throws DirectoryException {
        LDIFWriter lDIFWriter;
        assert (Debug.debugEnter(CLASS_NAME, "exportLDIF", String.valueOf(lDIFExportConfig)));
        try {
            lDIFWriter = new LDIFWriter(lDIFExportConfig);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "exportLDIF", exception));
            int n = 9699377;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n);
        }
        try {
            lDIFWriter.writeEntry(this.getSchemaEntry(dNArray[0]));
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "exportLDIF", exception));
            int n = 9699373;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n);
        }
        finally {
            block15: {
                try {
                    lDIFWriter.close();
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "exportLDIF", exception)) break block15;
                    throw new AssertionError();
                }
            }
        }
    }

    @Override
    public boolean supportsLDIFImport() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsLDIFImport", new String[0]));
        return false;
    }

    @Override
    public void importLDIF(ConfigEntry configEntry, DN[] dNArray, LDIFImportConfig lDIFImportConfig) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "importLDIF", String.valueOf(lDIFImportConfig)));
        int n = 9699374;
        String string = MessageHandler.getMessage(n);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public boolean supportsBackup() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsBackup", new String[0]));
        return true;
    }

    @Override
    public boolean supportsBackup(BackupConfig backupConfig, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "supportsBackup", new String[0]));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void createBackup(ConfigEntry configEntry, BackupConfig backupConfig) throws DirectoryException {
        void var23_41;
        File[] fileArray;
        Object object;
        OutputStream outputStream;
        int n;
        Object object2;
        assert (Debug.debugEnter(CLASS_NAME, "createBackup", String.valueOf(configEntry), String.valueOf(backupConfig)));
        String string = backupConfig.getBackupID();
        BackupDirectory backupDirectory = backupConfig.getBackupDirectory();
        boolean bl = backupConfig.compressData();
        boolean bl2 = backupConfig.encryptData();
        boolean bl3 = backupConfig.hashData();
        boolean bl4 = backupConfig.signHash();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        CryptoManager cryptoManager = DirectoryServer.getCryptoManager();
        Mac mac = null;
        MessageDigest messageDigest = null;
        String string2 = null;
        String string3 = null;
        if (bl3) {
            if (bl4) {
                string3 = cryptoManager.getPreferredMACAlgorithm();
                hashMap.put("mac_algorithm", string3);
                try {
                    mac = cryptoManager.getPreferredMACProvider();
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "createBackup", exception));
                    int n2 = 9699384;
                    String string4 = MessageHandler.getMessage(n2, string3, StaticUtils.stackTraceToSingleLineString(exception));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string4, n2, exception);
                }
            }
            string2 = cryptoManager.getPreferredMessageDigestAlgorithm();
            hashMap.put("digest_algorithm", string2);
            try {
                messageDigest = cryptoManager.getPreferredMessageDigest();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "createBackup", exception));
                int n3 = 9699385;
                String string5 = MessageHandler.getMessage(n3, string2, StaticUtils.stackTraceToSingleLineString(exception));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string5, n3, exception);
            }
        }
        String string6 = null;
        try {
            string6 = "schema-backup-" + string;
            object2 = new File(backupDirectory.getPath() + File.separator + string6);
            if (((File)object2).exists()) {
                n = 1;
                while (((File)(object2 = new File(backupDirectory.getPath() + File.separator + string6 + "." + n))).exists()) {
                    ++n;
                }
                string6 = string6 + "." + n;
            }
            outputStream = new FileOutputStream((File)object2, false);
            hashMap.put("archive_file", string6);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "createBackup", exception));
            int n4 = 9699386;
            String string7 = MessageHandler.getMessage(n4, String.valueOf(string6), backupDirectory.getPath(), StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string7, n4, exception);
        }
        if (bl2) {
            Cipher cipher;
            object2 = cryptoManager.getPreferredCipherAlgorithm();
            hashMap.put("cipher_algorithm", (String)object2);
            try {
                cipher = cryptoManager.getPreferredCipher(1);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "createBackup", exception));
                int n5 = 9699387;
                String string8 = MessageHandler.getMessage(n5, object2, StaticUtils.stackTraceToSingleLineString(exception));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string8, n5, exception);
            }
            outputStream = new CipherOutputStream(outputStream, cipher);
        }
        object2 = new ZipOutputStream(outputStream);
        n = 9699388;
        String string9 = MessageHandler.getMessage(n, "OpenDS Directory Server", string);
        ((ZipOutputStream)object2).setComment(string9);
        if (bl) {
            ((ZipOutputStream)object2).setLevel(-1);
        } else {
            ((ZipOutputStream)object2).setLevel(0);
        }
        String string10 = DirectoryServer.getServerRoot() + File.separator + ConfigConstants.PATH_SCHEMA_DIR;
        try {
            object = new File(string10);
            fileArray = ((File)object).listFiles();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "createBackup", exception));
            n = 9699389;
            string9 = MessageHandler.getMessage(n, string10, StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string9, n, exception);
        }
        object = new byte[8192];
        for (File file : fileArray) {
            if (!file.isFile()) continue;
            String string4 = file.getName();
            if (bl3) {
                if (bl4) {
                    mac.update(StaticUtils.getBytes(string4));
                } else {
                    messageDigest.update(StaticUtils.getBytes(string4));
                }
            }
            InputStream inputStream = null;
            try {
                int n2;
                ZipEntry zipEntry = new ZipEntry(string4);
                ((ZipOutputStream)object2).putNextEntry(zipEntry);
                inputStream = new FileInputStream(file);
                while ((n2 = inputStream.read((byte[])object)) >= 0) {
                    if (bl3) {
                        if (bl4) {
                            mac.update((byte[])object, 0, n2);
                        } else {
                            messageDigest.update((byte[])object, 0, n2);
                        }
                    }
                    ((ZipOutputStream)object2).write((byte[])object, 0, n2);
                }
                ((ZipOutputStream)object2).closeEntry();
                inputStream.close();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "createBackup", exception));
                try {
                    inputStream.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    ((ZipOutputStream)object2).close();
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                n = 9699390;
                string9 = MessageHandler.getMessage(n, string4, StaticUtils.stackTraceToSingleLineString(exception));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string9, n, exception);
            }
        }
        try {
            ((ZipOutputStream)object2).close();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "createBackup", exception));
            n = 9699391;
            string9 = MessageHandler.getMessage(n, string6, backupDirectory.getPath(), StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string9, n, exception);
        }
        Object var23_39 = null;
        byte[] byArray = null;
        if (bl3) {
            if (bl4) {
                byArray = mac.doFinal();
            } else {
                byte[] byArray2 = messageDigest.digest();
            }
        }
        BackupInfo backupInfo = new BackupInfo(backupDirectory, string, new Date(), false, bl, bl2, (byte[])var23_41, byArray, null, hashMap);
        try {
            backupDirectory.addBackup(backupInfo);
            backupDirectory.writeBackupDirectoryDescriptor();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "createBackup", exception));
            n = 0x940040;
            string9 = MessageHandler.getMessage(n, backupDirectory.getDescriptorPath(), StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string9, n, exception);
        }
    }

    @Override
    public void removeBackup(BackupDirectory backupDirectory, String string) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "removeBackup", String.valueOf(backupDirectory), String.valueOf(string)));
        int n = 9699375;
        String string2 = MessageHandler.getMessage(n);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string2, n);
    }

    @Override
    public boolean supportsRestore() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsRestore", new String[0]));
        return true;
    }

    @Override
    public void restoreBackup(ConfigEntry configEntry, RestoreConfig restoreConfig) throws DirectoryException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        assert (Debug.debugEnter(CLASS_NAME, "restoreBackup", String.valueOf(configEntry), String.valueOf(restoreConfig)));
        BackupDirectory backupDirectory = restoreConfig.getBackupDirectory();
        String string = backupDirectory.getPath();
        String string2 = restoreConfig.getBackupID();
        BackupInfo backupInfo = backupDirectory.getBackupInfo(string2);
        if (backupInfo == null) {
            int n = 9699393;
            String string3 = MessageHandler.getMessage(n, string2, string);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string3, n);
        }
        String string4 = backupInfo.getBackupProperty("archive_file");
        if (string4 == null) {
            int n = 9699394;
            String string5 = MessageHandler.getMessage(n, string2, string);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string5, n);
        }
        File file = new File(string + File.separator + string4);
        try {
            if (!file.exists()) {
                int n = 9699395;
                String string6 = MessageHandler.getMessage(n, string2, file.getPath());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string6, n);
            }
        }
        catch (DirectoryException directoryException) {
            throw directoryException;
        }
        catch (Exception exception) {
            int n = 0x940044;
            String string7 = MessageHandler.getMessage(n, string2, file.getPath(), StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string7, n, exception);
        }
        byte[] byArray = backupInfo.getUnsignedHash();
        MessageDigest messageDigest = null;
        if (byArray != null) {
            object7 = backupInfo.getBackupProperty("digest_algorithm");
            if (object7 == null) {
                int n = 9699397;
                String string8 = MessageHandler.getMessage(n, string2);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string8, n);
            }
            try {
                messageDigest = DirectoryServer.getCryptoManager().getMessageDigest((String)object7);
            }
            catch (Exception exception) {
                int n = 9699398;
                String string9 = MessageHandler.getMessage(n, string2, object7);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string9, n, exception);
            }
        }
        object7 = backupInfo.getSignedHash();
        Mac mac = null;
        if (object7 != null) {
            object6 = backupInfo.getBackupProperty("mac_algorithm");
            if (object6 == null) {
                int n = 9699399;
                String string10 = MessageHandler.getMessage(n, string2);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string10, n);
            }
            try {
                mac = DirectoryServer.getCryptoManager().getMACProvider((String)object6);
            }
            catch (Exception exception) {
                int n = 9699400;
                String string11 = MessageHandler.getMessage(n, string2, object6, file.getPath());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string11, n, exception);
            }
        }
        try {
            object6 = new FileInputStream(file);
        }
        catch (Exception exception) {
            int n = 0x940049;
            String string12 = MessageHandler.getMessage(n, string2, file.getPath(), StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string12, n, exception);
        }
        if (backupInfo.isEncrypted()) {
            object5 = backupInfo.getBackupProperty("cipher_algorithm");
            if (object5 == null) {
                int n = 9699402;
                String string13 = MessageHandler.getMessage(n, string2);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string13, n);
            }
            try {
                object4 = DirectoryServer.getCryptoManager().getCipher((String)object5, 2);
            }
            catch (Exception exception) {
                int n = 9699403;
                String string14 = MessageHandler.getMessage(n, object5, file.getPath(), StaticUtils.stackTraceToSingleLineString(exception));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string14, n, exception);
            }
            object6 = new CipherInputStream((InputStream)object6, (Cipher)object4);
        }
        object5 = new ZipInputStream((InputStream)object6);
        object4 = DirectoryServer.getServerRoot() + File.separator + ConfigConstants.PATH_SCHEMA_DIR;
        File file2 = new File((String)object4);
        Object object8 = null;
        File file3 = null;
        boolean bl = restoreConfig.verifyOnly();
        if (!bl) {
            int n;
            try {
                if (file2.exists()) {
                    object3 = (String)object4 + ".save";
                    object8 = object3;
                    file3 = new File((String)object8);
                    if (file3.exists()) {
                        n = 2;
                        while ((file3 = new File((String)(object8 = (Object)((String)object3 + n)))).exists()) {
                            ++n;
                        }
                    }
                    file2.renameTo(file3);
                }
            }
            catch (Exception exception) {
                int n2 = 9699404;
                String string15 = MessageHandler.getMessage(n2, string2, object4, String.valueOf(object8), StaticUtils.stackTraceToSingleLineString(exception));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string15, n2, exception);
            }
            try {
                file2.mkdirs();
            }
            catch (Exception exception) {
                if (file3 != null) {
                    try {
                        file3.renameTo(file2);
                        n = 9896013;
                        String string16 = MessageHandler.getMessage(n, object4);
                        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string16, n);
                    }
                    catch (Exception exception2) {
                        int n3 = 9699406;
                        String string17 = MessageHandler.getMessage(n3, file3.getPath());
                        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string17, n3);
                    }
                }
                int n4 = 9699407;
                String string18 = MessageHandler.getMessage(n4, string2, object4, StaticUtils.stackTraceToSingleLineString(exception));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string18, n4, exception);
            }
        }
        object3 = new byte[8192];
        while (true) {
            try {
                object2 = ((ZipInputStream)object5).getNextEntry();
            }
            catch (Exception exception) {
                String string19;
                if (file3 != null) {
                    int n = 9699408;
                    string19 = MessageHandler.getMessage(n, file3.getPath());
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string19, n);
                }
                int n = 9699409;
                string19 = MessageHandler.getMessage(n, string2, file.getPath(), StaticUtils.stackTraceToSingleLineString(exception));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string19, n, exception);
            }
            if (object2 == null) break;
            String string20 = ((ZipEntry)object2).getName();
            if (messageDigest != null) {
                messageDigest.update(StaticUtils.getBytes(string20));
            }
            if (mac != null) {
                mac.update(StaticUtils.getBytes(string20));
            }
            object = null;
            if (!bl) {
                String string21 = (String)object4 + File.separator + string20;
                try {
                    object = new FileOutputStream(string21);
                }
                catch (Exception exception) {
                    String string22;
                    int n;
                    if (file3 != null) {
                        n = 9699408;
                        string22 = MessageHandler.getMessage(n, file3.getPath());
                        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string22, n);
                    }
                    n = 9699410;
                    string22 = MessageHandler.getMessage(n, string2, string21, StaticUtils.stackTraceToSingleLineString(exception));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string22, n, exception);
                }
            }
            try {
                int n;
                while ((n = ((FilterInputStream)object5).read((byte[])object3)) >= 0) {
                    if (messageDigest != null) {
                        messageDigest.update((byte[])object3, 0, n);
                    }
                    if (mac != null) {
                        mac.update((byte[])object3, 0, n);
                    }
                    if (object == null) continue;
                    ((OutputStream)object).write((byte[])object3, 0, n);
                }
                if (object == null) continue;
                ((OutputStream)object).close();
            }
            catch (Exception exception) {
                String string23;
                int n;
                if (file3 != null) {
                    n = 9699408;
                    string23 = MessageHandler.getMessage(n, file3.getPath());
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string23, n);
                }
                n = 9699411;
                string23 = MessageHandler.getMessage(n, string2, string20, StaticUtils.stackTraceToSingleLineString(exception));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string23, n, exception);
            }
        }
        try {
            ((ZipInputStream)object5).close();
        }
        catch (Exception exception) {
            int n = 9699412;
            object = MessageHandler.getMessage(n, string2, file.getPath(), StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), (String)object, n, exception);
        }
        if (messageDigest != null) {
            object2 = messageDigest.digest();
            if (Arrays.equals((byte[])object2, byArray)) {
                int n = 9896021;
                object = MessageHandler.getMessage(n);
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, (String)object, n);
            } else {
                if (file3 != null) {
                    int n = 9699408;
                    object = MessageHandler.getMessage(n, file3.getPath());
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, (String)object, n);
                }
                int n = 9699414;
                object = MessageHandler.getMessage(n, string2);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), (String)object, n);
            }
        }
        if (mac != null) {
            object2 = mac.doFinal();
            if (Arrays.equals((byte[])object2, object7)) {
                int n = 9896023;
                object = MessageHandler.getMessage(n);
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, (String)object, n);
            } else {
                if (file3 != null) {
                    int n = 9699408;
                    object = MessageHandler.getMessage(n, file3.getPath());
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, (String)object, n);
                }
                int n = 9699416;
                object = MessageHandler.getMessage(n);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), (String)object, n);
            }
        }
        if (bl) {
            int n = 9896025;
            String string24 = MessageHandler.getMessage(n, string2, string);
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string24, n);
            return;
        }
        if (file3 != null) {
            StaticUtils.recursiveDelete(file3);
        }
        int n = 9896026;
        String string25 = MessageHandler.getMessage(n, string2, string);
        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string25, n);
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        LinkedList<ConfigAttribute> linkedList = new LinkedList<ConfigAttribute>();
        String string = MessageHandler.getMessage(9437223);
        ArrayList<DN> arrayList = new ArrayList<DN>(this.baseDNs.length);
        for (DN dN : this.baseDNs) {
            arrayList.add(dN);
        }
        linkedList.add(new DNConfigAttribute("ds-cfg-schema-entry-dn", string, false, true, false, arrayList));
        return linkedList;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", String.valueOf(configEntry), "java.util.List<String>"));
        boolean bl = true;
        String string = MessageHandler.getMessage(9437223);
        DNConfigAttribute dNConfigAttribute = new DNConfigAttribute("ds-cfg-schema-entry-dn", string, false, true, false);
        try {
            DNConfigAttribute dNConfigAttribute2 = (DNConfigAttribute)configEntry.getConfigAttribute(dNConfigAttribute);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeBackend", exception));
            int n = 9699368;
            String string2 = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            list.add(string2);
            bl = false;
        }
        return bl;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        Object object;
        HashSet<Object> hashSet;
        Object object2;
        assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", String.valueOf(configEntry), String.valueOf(bl)));
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 9437223;
        DNConfigAttribute dNConfigAttribute = new DNConfigAttribute("ds-cfg-schema-entry-dn", MessageHandler.getMessage(n), false, true, false);
        try {
            object2 = (DNConfigAttribute)configEntry.getConfigAttribute(dNConfigAttribute);
            if (object2 == null) {
                hashSet = new HashSet<DN>(1);
                hashSet.add(DN.decode("cn=schema"));
            } else {
                object = ((DNConfigAttribute)object2).activeValues();
                if (object == null || object.isEmpty()) {
                    hashSet = new HashSet(1);
                    hashSet.add(DN.decode("cn=schema"));
                } else {
                    hashSet = new HashSet<DN>((Collection<DN>)object);
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            n = 9699368;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            hashSet = null;
        }
        object2 = new ArrayList();
        for (List collection : configEntry.getEntry().getUserAttributes().values()) {
            for (Attribute dN : collection) {
                if (this.isSchemaConfigAttribute(dN)) continue;
                ((ArrayList)object2).add(dN);
            }
        }
        for (List<Attribute> list : configEntry.getEntry().getOperationalAttributes().values()) {
            for (Attribute attribute : list) {
                if (this.isSchemaConfigAttribute(attribute)) continue;
                ((ArrayList)object2).add(attribute);
            }
        }
        if (resultCode == ResultCode.SUCCESS) {
            object = new DN[hashSet.size()];
            hashSet.toArray((T[])object);
            HashSet<Iterator<Object>> hashSet2 = new HashSet<Iterator<Object>>(this.baseDNs.length);
            for (Iterator<Object> iterator : this.baseDNs) {
                if (hashSet.remove(iterator)) continue;
                hashSet2.add(iterator);
            }
            for (DN dN : hashSet2) {
                try {
                    DirectoryServer.deregisterSuffix(dN);
                    if (!bl) continue;
                    n = 9437234;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                    n = 9699379;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
            }
            this.baseDNs = object;
            for (DN dN : hashSet) {
                try {
                    DirectoryServer.registerPrivateSuffix(dN, this);
                    if (!bl) continue;
                    n = 9437236;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                    n = 9699381;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception)));
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
            }
            this.userDefinedAttributes = object2;
            if (bl) {
                n = 9437238;
                String string = MessageHandler.getMessage(n);
                arrayList.add(string);
            }
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList);
    }
}

