/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opends.server.api.Backend;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.schema.BooleanSyntax;
import org.opends.server.schema.GeneralizedTimeSyntax;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.BackupInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.RDN;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackupBackend
extends Backend
implements ConfigurableComponent {
    private static final String CLASS_NAME = "org.opends.server.backends.BackupBackend";
    private DN configEntryDN;
    private DN backupBaseDN;
    private DN[] baseDNs;
    private Entry backupBaseEntry;
    private HashSet<String> supportedControls;
    private HashSet<String> supportedFeatures;
    private LinkedHashSet<File> backupDirectories;

    public BackupBackend() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public void initializeBackend(ConfigEntry configEntry, DN[] dNArray) throws ConfigException, InitializationException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        assert (Debug.debugEnter(CLASS_NAME, "initializeBackend", String.valueOf(configEntry)));
        if (configEntry == null) {
            int n = 9699499;
            String string = MessageHandler.getMessage(n);
            throw new ConfigException(n, string);
        }
        this.configEntryDN = configEntry.getDN();
        try {
            this.backupBaseDN = DN.decode("cn=backups");
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeBackend", exception));
            int n = 9699500;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        this.baseDNs = new DN[]{this.backupBaseDN};
        int n = 9437357;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-backup-directory", MessageHandler.getMessage(n), true, true, false);
        try {
            object4 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object4 == null) {
                this.backupDirectories = new LinkedHashSet();
            } else {
                object3 = ((StringConfigAttribute)object4).activeValues();
                this.backupDirectories = new LinkedHashSet(object3.size());
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    this.backupDirectories.add(StaticUtils.getFileForPath((String)object));
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeBackend", exception));
            n = 9699502;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        object4 = new LinkedHashMap(2);
        ((HashMap)object4).put(DirectoryServer.getTopObjectClass(), "top");
        object3 = DirectoryServer.getObjectClass("untypedobject", true);
        ((HashMap)object4).put(object3, "untypedObject");
        object2 = new LinkedHashMap(0);
        object = new LinkedHashMap(1);
        AttributeType[] attributeTypeArray = this.backupBaseDN.getRDN().getAttributeTypes();
        AttributeValue[] attributeValueArray = this.backupBaseDN.getRDN().getAttributeValues();
        for (int i = 0; i < attributeTypeArray.length; ++i) {
            LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
            linkedHashSet.add(attributeValueArray[i]);
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
            arrayList.add(new Attribute(attributeTypeArray[i], attributeTypeArray[i].getNameOrOID(), linkedHashSet));
            ((HashMap)object).put(attributeTypeArray[i], arrayList);
        }
        this.backupBaseEntry = new Entry(this.backupBaseDN, (Map<ObjectClass, String>)object4, (Map<AttributeType, List<Attribute>>)object, (Map<AttributeType, List<Attribute>>)object2);
        this.supportedControls = new HashSet(0);
        this.supportedFeatures = new HashSet(0);
        DirectoryServer.registerConfigurableComponent(this);
        DirectoryServer.registerPrivateSuffix(this.backupBaseDN, this);
    }

    @Override
    public void finalizeBackend() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeBackend", new String[0]));
        DirectoryServer.deregisterConfigurableComponent(this);
    }

    @Override
    public DN[] getBaseDNs() {
        assert (Debug.debugEnter(CLASS_NAME, "getBaseDNs", new String[0]));
        return this.baseDNs;
    }

    @Override
    public boolean isLocal() {
        assert (Debug.debugEnter(CLASS_NAME, "isLocal", new String[0]));
        return true;
    }

    @Override
    public Entry getEntry(DN dN) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getEntry", String.valueOf(dN)));
        if (dN == null) {
            int n = 9699503;
            String string = MessageHandler.getMessage(n);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n);
        }
        if (dN.equals(this.backupBaseDN)) {
            return this.backupBaseEntry;
        }
        DN dN2 = dN.getParent();
        if (dN2 == null) {
            int n = 9699504;
            String string = MessageHandler.getMessage(n, String.valueOf(dN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n);
        }
        if (dN2.equals(this.backupBaseDN)) {
            return this.getBackupDirectoryEntry(dN);
        }
        if (this.backupBaseDN.equals(dN2.getParent())) {
            return this.getBackupEntry(dN);
        }
        int n = 9699504;
        String string = MessageHandler.getMessage(n, String.valueOf(dN));
        throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n, this.backupBaseDN, null);
    }

    private Entry getBackupDirectoryEntry(DN dN) throws DirectoryException {
        BackupDirectory backupDirectory;
        assert (Debug.debugEnter(CLASS_NAME, "getBackupDirectoryEntry", String.valueOf(dN)));
        AttributeType attributeType = DirectoryServer.getAttributeType("ds-backup-directory-path", true);
        AttributeValue attributeValue = dN.getRDN().getAttributeValue(attributeType);
        if (attributeValue == null) {
            int n = 9699505;
            String string = MessageHandler.getMessage(n, String.valueOf(dN));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n, this.backupBaseDN, null);
        }
        try {
            backupDirectory = BackupDirectory.readBackupDirectoryDescriptor(attributeValue.getStringValue());
        }
        catch (ConfigException configException) {
            assert (Debug.debugException(CLASS_NAME, "getBackupDirectoryEntry", configException));
            int n = 9699506;
            String string = MessageHandler.getMessage(n, String.valueOf(dN), configException.getMessage());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getBackupDirectoryEntry", exception));
            int n = 9699507;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n);
        }
        LinkedHashMap<ObjectClass, String> linkedHashMap = new LinkedHashMap<ObjectClass, String>(2);
        linkedHashMap.put(DirectoryServer.getTopObjectClass(), "top");
        ObjectClass objectClass = DirectoryServer.getObjectClass("ds-backup-directory", true);
        linkedHashMap.put(objectClass, "ds-backup-directory");
        LinkedHashMap<AttributeType, List<Attribute>> linkedHashMap2 = new LinkedHashMap<AttributeType, List<Attribute>>(0);
        LinkedHashMap<AttributeType, List<Attribute>> linkedHashMap3 = new LinkedHashMap<AttributeType, List<Attribute>>(3);
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
        linkedHashSet.add(attributeValue);
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
        arrayList.add(new Attribute(attributeType, attributeType.getNameOrOID(), linkedHashSet));
        linkedHashMap3.put(attributeType, arrayList);
        attributeType = DirectoryServer.getAttributeType("ds-backup-backend-dn", true);
        linkedHashSet = new LinkedHashSet(1);
        linkedHashSet.add(new AttributeValue(attributeType, backupDirectory.getConfigEntryDN().toString()));
        arrayList = new ArrayList(1);
        arrayList.add(new Attribute(attributeType, attributeType.getNameOrOID(), linkedHashSet));
        linkedHashMap3.put(attributeType, arrayList);
        return new Entry(dN, linkedHashMap, linkedHashMap3, linkedHashMap2);
    }

    private Entry getBackupEntry(DN dN) throws DirectoryException {
        HashMap<String, String> hashMap;
        Object object;
        Object object2;
        BackupDirectory backupDirectory;
        assert (Debug.debugEnter(CLASS_NAME, "getBackupEntry", String.valueOf(dN)));
        AttributeType attributeType = DirectoryServer.getAttributeType("ds-backup-id", true);
        AttributeValue attributeValue = dN.getRDN().getAttributeValue(attributeType);
        if (attributeValue == null) {
            int n = 9699508;
            String string = MessageHandler.getMessage(n, String.valueOf(dN));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
        }
        String string = attributeValue.getStringValue();
        DN dN2 = dN.getParent();
        if (dN2 == null) {
            int n = 9699509;
            String string2 = MessageHandler.getMessage(n, String.valueOf(dN));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string2, n);
        }
        AttributeType attributeType2 = DirectoryServer.getAttributeType("ds-backup-directory-path", true);
        AttributeValue attributeValue2 = dN2.getRDN().getAttributeValue(attributeType2);
        if (attributeValue2 == null) {
            int n = 9699510;
            String string3 = MessageHandler.getMessage(n, String.valueOf(dN));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string3, n);
        }
        try {
            backupDirectory = BackupDirectory.readBackupDirectoryDescriptor(attributeValue2.getStringValue());
        }
        catch (ConfigException configException) {
            assert (Debug.debugException(CLASS_NAME, "getBackupEntry", configException));
            int n = 9699506;
            String string4 = MessageHandler.getMessage(n, configException.getMessage());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string4, n);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getBackupEntry", exception));
            int n = 9699507;
            String string5 = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string5, n);
        }
        BackupInfo backupInfo = backupDirectory.getBackupInfo(string);
        if (backupInfo == null) {
            int n = 9699511;
            String string6 = MessageHandler.getMessage(n, string, backupDirectory.getPath());
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string6, n, dN2, null);
        }
        LinkedHashMap<ObjectClass, String> linkedHashMap = new LinkedHashMap<ObjectClass, String>(3);
        linkedHashMap.put(DirectoryServer.getTopObjectClass(), "top");
        ObjectClass objectClass = DirectoryServer.getObjectClass("ds-backup-info", true);
        linkedHashMap.put(objectClass, "ds-backup-info");
        objectClass = DirectoryServer.getObjectClass("extensibleobject", true);
        linkedHashMap.put(objectClass, "extensibleObject");
        LinkedHashMap<AttributeType, List<Attribute>> linkedHashMap2 = new LinkedHashMap<AttributeType, List<Attribute>>(0);
        LinkedHashMap<AttributeType, List<Attribute>> linkedHashMap3 = new LinkedHashMap<AttributeType, List<Attribute>>();
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
        linkedHashSet.add(attributeValue);
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
        arrayList.add(new Attribute(attributeType, attributeType.getNameOrOID(), linkedHashSet));
        linkedHashMap3.put(attributeType, arrayList);
        backupInfo.getBackupDirectory();
        linkedHashSet = new LinkedHashSet(1);
        linkedHashSet.add(attributeValue2);
        arrayList = new ArrayList(1);
        arrayList.add(new Attribute(attributeType2, attributeType2.getNameOrOID(), linkedHashSet));
        linkedHashMap3.put(attributeType2, arrayList);
        Date date = backupInfo.getBackupDate();
        if (date != null) {
            attributeType2 = DirectoryServer.getAttributeType("ds-backup-date", true);
            linkedHashSet = new LinkedHashSet(1);
            linkedHashSet.add(new AttributeValue(attributeType2, GeneralizedTimeSyntax.format(date)));
            arrayList = new ArrayList(1);
            arrayList.add(new Attribute(attributeType2, attributeType2.getNameOrOID(), linkedHashSet));
            linkedHashMap3.put(attributeType2, arrayList);
        }
        attributeType2 = DirectoryServer.getAttributeType("ds-backup-compressed", true);
        linkedHashSet = new LinkedHashSet(1);
        linkedHashSet.add(BooleanSyntax.createBooleanValue(backupInfo.isCompressed()));
        arrayList = new ArrayList(1);
        arrayList.add(new Attribute(attributeType2, attributeType2.getNameOrOID(), linkedHashSet));
        linkedHashMap3.put(attributeType2, arrayList);
        attributeType2 = DirectoryServer.getAttributeType("ds-backup-encrypted", true);
        linkedHashSet = new LinkedHashSet(1);
        linkedHashSet.add(BooleanSyntax.createBooleanValue(backupInfo.isEncrypted()));
        arrayList = new ArrayList(1);
        arrayList.add(new Attribute(attributeType2, attributeType2.getNameOrOID(), linkedHashSet));
        linkedHashMap3.put(attributeType2, arrayList);
        attributeType2 = DirectoryServer.getAttributeType("ds-backup-incremental", true);
        linkedHashSet = new LinkedHashSet(1);
        linkedHashSet.add(BooleanSyntax.createBooleanValue(backupInfo.isIncremental()));
        arrayList = new ArrayList(1);
        arrayList.add(new Attribute(attributeType2, attributeType2.getNameOrOID(), linkedHashSet));
        linkedHashMap3.put(attributeType2, arrayList);
        HashSet<String> hashSet = backupInfo.getDependencies();
        if (hashSet != null && !hashSet.isEmpty()) {
            attributeType2 = DirectoryServer.getAttributeType("ds-backup-dependency", true);
            linkedHashSet = new LinkedHashSet(hashSet.size());
            object2 = hashSet.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                linkedHashSet.add(new AttributeValue(attributeType2, (String)object));
            }
            arrayList = new ArrayList(1);
            arrayList.add(new Attribute(attributeType2, attributeType2.getNameOrOID(), linkedHashSet));
            linkedHashMap3.put(attributeType2, arrayList);
        }
        if ((object2 = backupInfo.getSignedHash()) != null) {
            attributeType2 = DirectoryServer.getAttributeType("ds-backup-signed-hash", true);
            linkedHashSet = new LinkedHashSet(1);
            linkedHashSet.add(new AttributeValue(attributeType2, (ByteString)new ASN1OctetString((byte[])object2)));
            arrayList = new ArrayList(1);
            arrayList.add(new Attribute(attributeType2, attributeType2.getNameOrOID(), linkedHashSet));
            linkedHashMap3.put(attributeType2, arrayList);
        }
        if ((object = backupInfo.getUnsignedHash()) != null) {
            attributeType2 = DirectoryServer.getAttributeType("ds-backup-unsigned-hash", true);
            linkedHashSet = new LinkedHashSet(1);
            linkedHashSet.add(new AttributeValue(attributeType2, (ByteString)new ASN1OctetString((byte[])object)));
            arrayList = new ArrayList(1);
            arrayList.add(new Attribute(attributeType2, attributeType2.getNameOrOID(), linkedHashSet));
            linkedHashMap3.put(attributeType2, arrayList);
        }
        if ((hashMap = backupInfo.getBackupProperties()) != null && !hashMap.isEmpty()) {
            for (Map.Entry<String, String> entry : hashMap.entrySet()) {
                attributeType2 = DirectoryServer.getAttributeType(StaticUtils.toLowerCase(entry.getKey()), true);
                linkedHashSet = new LinkedHashSet(1);
                linkedHashSet.add(new AttributeValue(attributeType2, entry.getValue()));
                arrayList = new ArrayList(1);
                arrayList.add(new Attribute(attributeType2, attributeType2.getNameOrOID(), linkedHashSet));
                linkedHashMap3.put(attributeType2, arrayList);
            }
        }
        return new Entry(dN, linkedHashMap, linkedHashMap3, linkedHashMap2);
    }

    @Override
    public void addEntry(Entry entry, AddOperation addOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "addEntry", String.valueOf(entry), String.valueOf(addOperation)));
        int n = 9699512;
        String string = MessageHandler.getMessage(n);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public void deleteEntry(DN dN, DeleteOperation deleteOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "deleteEntry", String.valueOf(dN), String.valueOf(deleteOperation)));
        int n = 9699513;
        String string = MessageHandler.getMessage(n);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public void replaceEntry(Entry entry, ModifyOperation modifyOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "replaceEntry", String.valueOf(entry), String.valueOf(modifyOperation)));
        int n = 9699514;
        String string = MessageHandler.getMessage(n);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public void renameEntry(DN dN, Entry entry, ModifyDNOperation modifyDNOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "renameEntry", String.valueOf(dN), String.valueOf(entry), String.valueOf(modifyDNOperation)));
        int n = 9699515;
        String string = MessageHandler.getMessage(n);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public void search(SearchOperation searchOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "search", String.valueOf(searchOperation)));
        DN dN = searchOperation.getBaseDN();
        Entry entry = this.getEntry(dN);
        SearchScope searchScope = searchOperation.getScope();
        SearchFilter searchFilter = searchOperation.getFilter();
        if (this.backupBaseDN.equals(dN)) {
            if ((searchScope == SearchScope.BASE_OBJECT || searchScope == SearchScope.WHOLE_SUBTREE) && searchFilter.matchesEntry(entry)) {
                searchOperation.returnEntry(entry, null);
            }
            if (searchScope != SearchScope.BASE_OBJECT && !this.backupDirectories.isEmpty()) {
                AttributeType attributeType = DirectoryServer.getAttributeType("ds-backup-directory-path", true);
                for (File file : this.backupDirectories) {
                    List<Attribute> list;
                    Entry entry2;
                    DN dN2 = BackupBackend.makeChildDN(this.backupBaseDN, attributeType, file.getAbsolutePath());
                    try {
                        entry2 = this.getBackupDirectoryEntry(dN2);
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "search", exception));
                        continue;
                    }
                    if (searchFilter.matchesEntry(entry2)) {
                        searchOperation.returnEntry(entry2, null);
                    }
                    if (searchScope == SearchScope.SINGLE_LEVEL || (list = entry2.getAttribute(attributeType)) == null || list.isEmpty()) continue;
                    for (AttributeValue attributeValue : list.get(0).getValues()) {
                        try {
                            BackupDirectory backupDirectory = BackupDirectory.readBackupDirectoryDescriptor(attributeValue.getStringValue());
                            AttributeType attributeType2 = DirectoryServer.getAttributeType("ds-backup-id", true);
                            for (String string : backupDirectory.getBackups().keySet()) {
                                DN dN3 = BackupBackend.makeChildDN(dN2, attributeType2, string);
                                Entry entry3 = this.getBackupEntry(dN3);
                                if (!searchFilter.matchesEntry(entry3)) continue;
                                searchOperation.returnEntry(entry3, null);
                            }
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "search", exception));
                        }
                    }
                }
            }
        } else {
            DN dN4 = dN.getParent();
            if (this.backupBaseDN.equals(dN4)) {
                AttributeType attributeType;
                List<Attribute> list;
                Entry entry4 = this.getBackupDirectoryEntry(dN);
                if ((searchScope == SearchScope.BASE_OBJECT || searchScope == SearchScope.WHOLE_SUBTREE) && searchFilter.matchesEntry(entry4)) {
                    searchOperation.returnEntry(entry4, null);
                }
                if (searchScope != SearchScope.BASE_OBJECT && (list = entry4.getAttribute(attributeType = DirectoryServer.getAttributeType("ds-backup-directory-path", true))) != null && !list.isEmpty()) {
                    for (AttributeValue attributeValue : list.get(0).getValues()) {
                        try {
                            BackupDirectory backupDirectory = BackupDirectory.readBackupDirectoryDescriptor(attributeValue.getStringValue());
                            AttributeType attributeType3 = DirectoryServer.getAttributeType("ds-backup-id", true);
                            for (String string : backupDirectory.getBackups().keySet()) {
                                DN dN5 = BackupBackend.makeChildDN(dN, attributeType3, string);
                                Entry entry5 = this.getBackupEntry(dN5);
                                if (!searchFilter.matchesEntry(entry5)) continue;
                                searchOperation.returnEntry(entry5, null);
                            }
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "search", exception));
                        }
                    }
                }
            } else {
                if (dN4 == null || !this.backupBaseDN.equals(dN4.getParent())) {
                    int n = 9699516;
                    String string = MessageHandler.getMessage(n);
                    throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n);
                }
                if (searchScope == SearchScope.BASE_OBJECT || searchScope == SearchScope.WHOLE_SUBTREE) {
                    Entry entry6 = this.getBackupEntry(dN);
                    if (entry6 == null) {
                        int n = 9699516;
                        String string = MessageHandler.getMessage(n);
                        throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n);
                    }
                    if (searchFilter.matchesEntry(entry6)) {
                        searchOperation.returnEntry(entry6, null);
                    }
                }
            }
        }
    }

    public HashSet<String> getSupportedControls() {
        assert (Debug.debugEnter(CLASS_NAME, "getSupportedControls", new String[0]));
        return this.supportedControls;
    }

    @Override
    public boolean supportsControl(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "supportsControl", String.valueOf(string)));
        return false;
    }

    public HashSet<String> getSupportedFeatures() {
        assert (Debug.debugEnter(CLASS_NAME, "getSupportedFeatures", new String[0]));
        return this.supportedFeatures;
    }

    @Override
    public boolean supportsFeature(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "supportsFeature", String.valueOf(string)));
        return false;
    }

    @Override
    public boolean supportsLDIFExport() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsLDIFExport", new String[0]));
        return false;
    }

    @Override
    public void exportLDIF(ConfigEntry configEntry, DN[] dNArray, LDIFExportConfig lDIFExportConfig) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "exportLDIF", String.valueOf(lDIFExportConfig)));
        int n = 9699517;
        String string = MessageHandler.getMessage(n);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public boolean supportsLDIFImport() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsLDIFImport", new String[0]));
        return false;
    }

    @Override
    public void importLDIF(ConfigEntry configEntry, DN[] dNArray, LDIFImportConfig lDIFImportConfig) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "importLDIF", String.valueOf(lDIFImportConfig)));
        int n = 9699518;
        String string = MessageHandler.getMessage(n);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public boolean supportsBackup() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsBackup", new String[0]));
        return false;
    }

    @Override
    public boolean supportsBackup(BackupConfig backupConfig, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "supportsBackup", new String[0]));
        return false;
    }

    @Override
    public void createBackup(ConfigEntry configEntry, BackupConfig backupConfig) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "createBackup", String.valueOf(backupConfig)));
        int n = 9699519;
        String string = MessageHandler.getMessage(n);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public void removeBackup(BackupDirectory backupDirectory, String string) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "removeBackup", String.valueOf(backupDirectory), String.valueOf(string)));
        int n = 9699519;
        String string2 = MessageHandler.getMessage(n);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string2, n);
    }

    @Override
    public boolean supportsRestore() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsRestore", new String[0]));
        return false;
    }

    @Override
    public void restoreBackup(ConfigEntry configEntry, RestoreConfig restoreConfig) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "restoreBackup", String.valueOf(restoreConfig)));
        int n = 9699519;
        String string = MessageHandler.getMessage(n);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        LinkedList<ConfigAttribute> linkedList = new LinkedList<ConfigAttribute>();
        ArrayList<String> arrayList = new ArrayList<String>(this.backupDirectories.size());
        for (File file : this.backupDirectories) {
            arrayList.add(file.getAbsolutePath());
        }
        int n = 9437357;
        linkedList.add(new StringConfigAttribute("ds-cfg-backup-directory", MessageHandler.getMessage(n), true, true, false, arrayList));
        return linkedList;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", String.valueOf(configEntry), "java.util.List<String>"));
        return true;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", String.valueOf(configEntry), String.valueOf(bl)));
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 9437357;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-backup-directory", MessageHandler.getMessage(n), true, true, false);
        try {
            StringConfigAttribute stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (stringConfigAttribute2 == null) {
                this.backupDirectories = new LinkedHashSet();
            } else {
                List<String> list = stringConfigAttribute2.activeValues();
                this.backupDirectories = new LinkedHashSet(list.size());
                for (String string : list) {
                    this.backupDirectories.add(StaticUtils.getFileForPath(string));
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeBackend", exception));
            n = 9699502;
            arrayList.add(MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList);
    }

    public static DN makeChildDN(DN dN, AttributeType attributeType, String string) {
        RDN[] rDNArray = dN.getRDNComponents();
        RDN[] rDNArray2 = new RDN[rDNArray.length + 1];
        AttributeValue attributeValue = new AttributeValue(attributeType, string);
        rDNArray2[0] = new RDN(attributeType, attributeValue);
        System.arraycopy(rDNArray, 0, rDNArray2, 1, rDNArray.length);
        return new DN(rDNArray2);
    }
}

