/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.CancelledOperationException;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.core.LockManager;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.WritabilityMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Backend {
    private static final String CLASS_NAME = "org.opends.server.api.Backend";
    private Backend parentBackend;
    private Backend[] subordinateBackends;
    private boolean isPrivateBackend;
    private String backendID;
    private WritabilityMode writabilityMode;

    protected Backend() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.backendID = null;
        this.parentBackend = null;
        this.subordinateBackends = new Backend[0];
        this.isPrivateBackend = false;
        this.writabilityMode = WritabilityMode.ENABLED;
    }

    public abstract void initializeBackend(ConfigEntry var1, DN[] var2) throws ConfigException, InitializationException;

    public abstract void finalizeBackend();

    public abstract DN[] getBaseDNs();

    public abstract boolean isLocal();

    public abstract Entry getEntry(DN var1) throws DirectoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean entryExists(DN dN) throws DirectoryException {
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "entryExists", String.valueOf(dN)));
        Lock lock = null;
        for (n = 0; n < 3 && (lock = LockManager.lockRead(dN)) == null; ++n) {
        }
        if (lock == null) {
            n = 9764919;
            String string = MessageHandler.getMessage(n, String.valueOf(dN));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n);
        }
        try {
            n = this.getEntry(dN) != null ? 1 : 0;
            return n != 0;
        }
        finally {
            LockManager.unlock(dN, lock);
        }
    }

    public abstract void addEntry(Entry var1, AddOperation var2) throws DirectoryException, CancelledOperationException;

    public abstract void deleteEntry(DN var1, DeleteOperation var2) throws DirectoryException, CancelledOperationException;

    public abstract void replaceEntry(Entry var1, ModifyOperation var2) throws DirectoryException, CancelledOperationException;

    public abstract void renameEntry(DN var1, Entry var2, ModifyDNOperation var3) throws DirectoryException, CancelledOperationException;

    public abstract void search(SearchOperation var1) throws DirectoryException, CancelledOperationException;

    public abstract Set<String> getSupportedControls();

    public abstract boolean supportsControl(String var1);

    public abstract Set<String> getSupportedFeatures();

    public abstract boolean supportsFeature(String var1);

    public abstract boolean supportsLDIFExport();

    public abstract void exportLDIF(ConfigEntry var1, DN[] var2, LDIFExportConfig var3) throws DirectoryException;

    public abstract boolean supportsLDIFImport();

    public abstract void importLDIF(ConfigEntry var1, DN[] var2, LDIFImportConfig var3) throws DirectoryException;

    public abstract boolean supportsBackup();

    public abstract boolean supportsBackup(BackupConfig var1, StringBuilder var2);

    public abstract void createBackup(ConfigEntry var1, BackupConfig var2) throws DirectoryException;

    public abstract void removeBackup(BackupDirectory var1, String var2) throws DirectoryException;

    public abstract boolean supportsRestore();

    public abstract void restoreBackup(ConfigEntry var1, RestoreConfig var2) throws DirectoryException;

    public String getBackendID() {
        assert (Debug.debugEnter(CLASS_NAME, "getBackendID", new String[0]));
        return this.backendID;
    }

    public void setBackendID(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setBackendID", String.valueOf(string)));
        this.backendID = string;
    }

    public boolean isPrivateBackend() {
        assert (Debug.debugEnter(CLASS_NAME, "isPrivateBackend", new String[0]));
        return this.isPrivateBackend;
    }

    public void setPrivateBackend(boolean bl) {
        this.isPrivateBackend = bl;
    }

    public WritabilityMode getWritabilityMode() {
        assert (Debug.debugEnter(CLASS_NAME, "getWritabilityMode", new String[0]));
        return this.writabilityMode;
    }

    public void setWritabilityMode(WritabilityMode writabilityMode) {
        assert (Debug.debugEnter(CLASS_NAME, "setWritabilityMode", String.valueOf((Object)writabilityMode)));
        this.writabilityMode = writabilityMode == null ? WritabilityMode.ENABLED : writabilityMode;
    }

    public Backend getParentBackend() {
        assert (Debug.debugEnter(CLASS_NAME, "getParentBackend", new String[0]));
        return this.parentBackend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParentBackend(Backend backend) {
        assert (Debug.debugEnter(CLASS_NAME, "setParentBackend", String.valueOf(backend)));
        Backend backend2 = this;
        synchronized (backend2) {
            this.parentBackend = backend;
        }
    }

    public Backend[] getSubordinateBackends() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubordinateBackends", new String[0]));
        return this.subordinateBackends;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubordinateBackends(Backend[] backendArray) {
        assert (Debug.debugEnter(CLASS_NAME, "setSubordinateBackends", String.valueOf(backendArray)));
        Backend backend = this;
        synchronized (backend) {
            this.subordinateBackends = backendArray;
        }
    }

    public boolean hasSubSuffix(DN dN) {
        Backend[] backendArray;
        assert (Debug.debugEnter(CLASS_NAME, "hasSubSuffix", String.valueOf(dN)));
        for (Backend backend : backendArray = this.subordinateBackends) {
            for (DN dN2 : backend.getBaseDNs()) {
                if (!dN2.equals(dN)) continue;
                return true;
            }
            if (!backend.hasSubSuffix(dN)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubSuffix(DN dN, DN dN2) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "removeSubSuffix", String.valueOf(dN)));
        Backend backend = this;
        synchronized (backend) {
            boolean bl = false;
            ArrayList<Backend> arrayList = new ArrayList<Backend>(this.subordinateBackends.length);
            for (Backend backend2 : this.subordinateBackends) {
                boolean bl2 = false;
                DN[] dNArray = backend2.getBaseDNs();
                for (int i = 0; i < dNArray.length; ++i) {
                    if (!dNArray[i].equals(dN)) continue;
                    if (dNArray.length > 1) {
                        int n = 9764865;
                        String string = MessageHandler.getMessage(n, String.valueOf(dN));
                        throw new ConfigException(n, string);
                    }
                    bl2 = true;
                    bl = true;
                    break;
                }
                if (bl2) continue;
                if (backend2.hasSubSuffix(dN)) {
                    backend2.removeSubSuffix(dN, dN2);
                    continue;
                }
                arrayList.add(backend2);
            }
            if (bl) {
                Backend[] backendArray = new Backend[arrayList.size()];
                arrayList.toArray(backendArray);
                this.subordinateBackends = backendArray;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubordinateBackend(Backend backend) {
        assert (Debug.debugEnter(CLASS_NAME, "addSubordinateBackend", String.valueOf(backend)));
        Backend backend2 = this;
        synchronized (backend2) {
            Backend[] backendArray = new Backend[this.subordinateBackends.length + 1];
            System.arraycopy(this.subordinateBackends, 0, backendArray, 0, this.subordinateBackends.length);
            backendArray[this.subordinateBackends.length] = backend;
            this.subordinateBackends = backendArray;
        }
    }

    public boolean handlesEntry(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "handlesEntry", String.valueOf(dN)));
        DN[] dNArray = this.getBaseDNs();
        for (int i = 0; i < dNArray.length; ++i) {
            if (!dN.isDescendantOf(dNArray[i])) continue;
            Backend[] backendArray = this.subordinateBackends;
            for (int j = 0; j < backendArray.length; ++j) {
                if (!backendArray[j].handlesEntry(dN)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static final boolean handlesEntry(DN dN, List<DN> list, List<DN> list2) {
        assert (Debug.debugEnter(CLASS_NAME, "handlesEntry", String.valueOf(dN)));
        for (DN dN2 : list) {
            if (!dN.isDescendantOf(dN2)) continue;
            if (list2 == null || list2.isEmpty()) {
                return true;
            }
            boolean bl = false;
            for (DN dN3 : list2) {
                if (!dN.isDescendantOf(dN3)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return true;
        }
        return false;
    }
}

