/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import com.sleepycat.je.JEVersion;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.opends.messages.CoreMessages;
import org.opends.messages.RuntimeMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.util.DynamicConstants;

public class RuntimeInformation {
    private static boolean is64Bit = false;

    public static boolean is64Bit() {
        return is64Bit;
    }

    private static String getInputArguments() {
        int count = 0;
        RuntimeMXBean rtBean = ManagementFactory.getRuntimeMXBean();
        StringBuilder argList = new StringBuilder();
        List<String> jvmArguments = rtBean.getInputArguments();
        if (jvmArguments != null && !jvmArguments.isEmpty()) {
            for (String jvmArg : jvmArguments) {
                if (argList.length() > 0) {
                    argList.append(" ");
                }
                argList.append("\"");
                argList.append(jvmArg);
                argList.append("\"");
                if (++count >= jvmArguments.size()) continue;
                argList.append(",");
            }
        }
        return argList.toString();
    }

    public static void printInfo() {
        System.out.println(CoreMessages.NOTE_VERSION.get(DirectoryServer.getVersionString()));
        System.out.println(CoreMessages.NOTE_BUILD_ID.get(DynamicConstants.BUILD_ID));
        System.out.println(RuntimeMessages.NOTE_JAVA_VERSION.get(System.getProperty("java.version")));
        System.out.println(RuntimeMessages.NOTE_JAVA_VENDOR.get(System.getProperty("java.vendor")));
        System.out.println(RuntimeMessages.NOTE_JVM_VERSION.get(System.getProperty("java.vm.version")));
        System.out.println(RuntimeMessages.NOTE_JVM_VENDOR.get(System.getProperty("java.vm.vendor")));
        System.out.println(RuntimeMessages.NOTE_JAVA_HOME.get(System.getProperty("java.home")));
        System.out.println(RuntimeMessages.NOTE_JAVA_CLASSPATH.get(System.getProperty("java.class.path")));
        System.out.println(RuntimeMessages.NOTE_JE_VERSION.get(JEVersion.CURRENT_VERSION.toString()));
        System.out.println(RuntimeMessages.NOTE_CURRENT_DIRECTORY.get(System.getProperty("user.dir")));
        String installDir = DirectoryServer.getServerRoot();
        try {
            installDir = new File(installDir).getCanonicalPath();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (installDir == null) {
            System.out.println(RuntimeMessages.NOTE_UNKNOWN_INSTALL_DIRECTORY.get());
        } else {
            System.out.println(RuntimeMessages.NOTE_INSTALL_DIRECTORY.get(installDir));
        }
        String instanceDir = DirectoryServer.getInstanceRoot();
        try {
            instanceDir = new File(instanceDir).getCanonicalPath();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (instanceDir == null) {
            System.out.println(RuntimeMessages.NOTE_UNKNOWN_INSTANCE_DIRECTORY.get());
        } else {
            System.out.println(RuntimeMessages.NOTE_INSTANCE_DIRECTORY.get(instanceDir));
        }
        System.out.println(RuntimeMessages.NOTE_OPERATING_SYSTEM.get(System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch")));
        String sunOsArchDataModel = System.getProperty("sun.arch.data.model");
        if (sunOsArchDataModel != null) {
            if (!sunOsArchDataModel.toLowerCase().equals("unknown")) {
                System.out.println(RuntimeMessages.NOTE_JVM_ARCH.get(sunOsArchDataModel + "-bit"));
            }
        } else {
            System.out.println(RuntimeMessages.NOTE_JVM_ARCH.get("unknown"));
        }
        try {
            System.out.println(RuntimeMessages.NOTE_SYSTEM_NAME.get(InetAddress.getLocalHost().getCanonicalHostName()));
        }
        catch (Exception e) {
            System.out.println(RuntimeMessages.NOTE_SYSTEM_NAME.get("Unknown (" + e + ")"));
        }
        System.out.println(RuntimeMessages.NOTE_AVAILABLE_PROCESSORS.get(Runtime.getRuntime().availableProcessors()));
        System.out.println(RuntimeMessages.NOTE_MAX_MEMORY.get(Runtime.getRuntime().maxMemory()));
        System.out.println(RuntimeMessages.NOTE_TOTAL_MEMORY.get(Runtime.getRuntime().totalMemory()));
        System.out.println(RuntimeMessages.NOTE_FREE_MEMORY.get(Runtime.getRuntime().freeMemory()));
    }

    private static long getPhysicalMemorySize() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName oname = new ObjectName("java.lang:type=OperatingSystem");
            if (mbs.isInstanceOf(oname, "com.sun.management.OperatingSystemMXBean")) {
                Long l = (Long)mbs.getAttribute(oname, "TotalPhysicalMemorySize");
                return l;
            }
            return -1L;
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private static String getHostName() {
        String host;
        try {
            host = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception e) {
            host = "Unknown (" + e + ")";
        }
        return host;
    }

    private static String getOSInfo() {
        return System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch");
    }

    private static String getArch() {
        String sunOsArchDataModel = System.getProperty("sun.arch.data.model");
        if (sunOsArchDataModel != null && !sunOsArchDataModel.toLowerCase().equals("unknown")) {
            return sunOsArchDataModel + "-bit";
        }
        return "unknown";
    }

    public static void logInfo() {
        String installDir = DirectoryServer.getServerRoot();
        try {
            installDir = new File(installDir).getCanonicalPath();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (installDir == null) {
            ErrorLogger.logError(RuntimeMessages.NOTE_UNKNOWN_INSTALL_DIRECTORY.get());
        } else {
            ErrorLogger.logError(RuntimeMessages.NOTE_INSTALL_DIRECTORY.get(installDir));
        }
        String instanceDir = DirectoryServer.getInstanceRoot();
        try {
            instanceDir = new File(instanceDir).getCanonicalPath();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (instanceDir == null) {
            ErrorLogger.logError(RuntimeMessages.NOTE_UNKNOWN_INSTANCE_DIRECTORY.get());
        } else {
            ErrorLogger.logError(RuntimeMessages.NOTE_INSTANCE_DIRECTORY.get(instanceDir));
        }
        ErrorLogger.logError(RuntimeMessages.NOTE_JVM_INFO.get(System.getProperty("java.runtime.version"), System.getProperty("java.vendor"), RuntimeInformation.getArch(), Runtime.getRuntime().maxMemory()));
        Long physicalMemorySize = RuntimeInformation.getPhysicalMemorySize();
        if (physicalMemorySize != -1L) {
            ErrorLogger.logError(RuntimeMessages.NOTE_JVM_HOST.get(RuntimeInformation.getHostName(), RuntimeInformation.getOSInfo(), physicalMemorySize, Runtime.getRuntime().availableProcessors()));
        } else {
            ErrorLogger.logError(RuntimeMessages.NOTE_JVM_HOST_WITH_UNKNOWN_PHYSICAL_MEM.get(RuntimeInformation.getHostName(), RuntimeInformation.getOSInfo(), Runtime.getRuntime().availableProcessors()));
        }
        ErrorLogger.logError(RuntimeMessages.NOTE_JVM_ARGS.get(RuntimeInformation.getInputArguments()));
    }

    static {
        String arch = System.getProperty("sun.arch.data.model");
        if (arch != null) {
            try {
                is64Bit = Integer.parseInt(arch) == 64;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

