/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.opends.messages.Message;
import org.opends.messages.UtilityMessages;

public final class Platform {
    private static String pkgPrefix;
    private static final String IBM_SEC = "com.ibm.security";
    private static final String SUN_SEC = "sun.security";
    private static final PlatformIMPL IMPL;

    private Platform() {
    }

    public static void addCertificate(KeyStore ks, String ksType, String ksPath, String alias, char[] pwd, String certPath) throws KeyStoreException {
        IMPL.addCertificate(ks, ksType, ksPath, alias, pwd, certPath);
    }

    public static void deleteAlias(KeyStore ks, String ksPath, String alias, char[] pwd) throws KeyStoreException {
        IMPL.deleteAlias(ks, ksPath, alias, pwd);
    }

    public static void generateSelfSignedCertificate(KeyStore ks, String ksType, String ksPath, String alias, char[] pwd, String dn, int validity) throws KeyStoreException {
        IMPL.generateSelfSignedCertificate(ks, ksType, ksPath, alias, pwd, dn, validity);
    }

    public static void normalize(StringBuilder buffer) {
        IMPL.normalize(buffer);
    }

    public static boolean isVendor(String vendor) {
        String javaVendor = System.getProperty("java.vendor");
        return javaVendor.startsWith(vendor);
    }

    static {
        String vendor = System.getProperty("java.vendor");
        String ver = System.getProperty("java.version");
        if (vendor.startsWith("IBM")) {
            pkgPrefix = IBM_SEC;
            IMPL = ver.startsWith("1.5") ? new IBM5PlatformIMPL() : new DefaultPlatformIMPL();
        } else {
            pkgPrefix = SUN_SEC;
            IMPL = ver.startsWith("1.5") ? new Sun5PlatformIMPL() : new DefaultPlatformIMPL();
        }
    }

    private static class IBM5PlatformIMPL
    extends PlatformIMPL {
        private IBM5PlatformIMPL() {
        }

        public void normalize(StringBuilder buffer) {
        }
    }

    private static class DefaultPlatformIMPL
    extends PlatformIMPL {
        private static final Method NORMALIZE;
        private static final Object FORM_NFKC;

        private DefaultPlatformIMPL() {
        }

        public void normalize(StringBuilder buffer) {
            try {
                String normal = (String)NORMALIZE.invoke(null, buffer, FORM_NFKC);
                buffer.replace(0, buffer.length(), normal);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        static {
            Method normalize = null;
            Object formNFKC = null;
            try {
                Class<?> normalizer = Class.forName("java.text.Normalizer");
                Class<?> normalizerForm = Class.forName("java.text.Normalizer$Form");
                normalize = normalizer.getMethod("normalize", CharSequence.class, normalizerForm);
                formNFKC = normalizerForm.getField("NFKD").get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            NORMALIZE = normalize;
            FORM_NFKC = formNFKC;
        }
    }

    private static class Sun5PlatformIMPL
    extends PlatformIMPL {
        private static final Method NORMALIZE;
        private static final Object FORM_NFKC;

        private Sun5PlatformIMPL() {
        }

        public void normalize(StringBuilder buffer) {
            try {
                String normal = (String)NORMALIZE.invoke(null, buffer.toString(), FORM_NFKC, 0);
                buffer.replace(0, buffer.length(), normal);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        static {
            Method normalize = null;
            Object formNFKC = null;
            try {
                Class<?> normalizer = Class.forName("sun.text.Normalizer");
                formNFKC = normalizer.getField("DECOMP_COMPAT").get(null);
                Class<?> normalizerForm = Class.forName("sun.text.Normalizer$Mode");
                normalize = normalizer.getMethod("normalize", String.class, normalizerForm, Integer.TYPE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            NORMALIZE = normalize;
            FORM_NFKC = formNFKC;
        }
    }

    private static abstract class PlatformIMPL {
        private static final int KEY_SIZE = 1024;
        private static final String KEY_ALGORITHM = "rsa";
        private static final String SIG_ALGORITHM = "SHA1WithRSA";
        private static final int SEC_IN_DAY = 86400;
        private static final String GENERATE_METHOD = "generate";
        private static final String GET_PRIVATE_KEY_METHOD = "getPrivateKey";
        private static final String GET_SELFSIGNED_CERT_METHOD = "getSelfCertificate";
        private static Class<?> certKeyGenClass;
        private static Class<?> X500NameClass;
        private static Constructor<?> certKeyGenCons;
        private static Constructor<?> X500NameCons;

        protected PlatformIMPL() {
        }

        public final void deleteAlias(KeyStore ks, String ksPath, String alias, char[] pwd) throws KeyStoreException {
            try {
                if (ks == null) {
                    Message msg = UtilityMessages.ERR_CERTMGR_KEYSTORE_NONEXISTANT.get();
                    throw new KeyStoreException(msg.toString());
                }
                ks.deleteEntry(alias);
                FileOutputStream fs = new FileOutputStream(ksPath);
                ks.store(fs, pwd);
                fs.close();
            }
            catch (Exception e) {
                Message msg = UtilityMessages.ERR_CERTMGR_DELETE_ALIAS.get(alias, e.getMessage());
                throw new KeyStoreException(msg.toString());
            }
        }

        public final void addCertificate(KeyStore ks, String ksType, String ksPath, String alias, char[] pwd, String certPath) throws KeyStoreException {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X509");
                FileInputStream inStream = new FileInputStream(certPath);
                if (ks == null) {
                    ks = KeyStore.getInstance(ksType);
                    ks.load(null, pwd);
                }
                if (ks.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) {
                    Message msg = UtilityMessages.ERR_CERTMGR_CERT_REPLIES_INVALID.get(alias);
                    throw new KeyStoreException(msg.toString());
                }
                if (ks.containsAlias(alias) && !ks.entryInstanceOf(alias, KeyStore.TrustedCertificateEntry.class)) {
                    Message msg = UtilityMessages.ERR_CERTMGR_ALIAS_INVALID.get(alias);
                    throw new KeyStoreException(msg.toString());
                }
                this.trustedCert(alias, cf, ks, inStream);
                FileOutputStream fileOutStream = new FileOutputStream(ksPath);
                ks.store(fileOutStream, pwd);
                fileOutStream.close();
                ((InputStream)inStream).close();
            }
            catch (Exception e) {
                Message msg = UtilityMessages.ERR_CERTMGR_ADD_CERT.get(alias, e.getMessage());
                throw new KeyStoreException(msg.toString());
            }
        }

        public final KeyStore generateSelfSignedCertificate(KeyStore ks, String ksType, String ksPath, String alias, char[] pwd, String dn, int validity) throws KeyStoreException {
            try {
                if (ks == null) {
                    ks = KeyStore.getInstance(ksType);
                    ks.load(null, pwd);
                } else if (ks.containsAlias(alias)) {
                    Message msg = UtilityMessages.ERR_CERTMGR_ALIAS_ALREADY_EXISTS.get(alias);
                    throw new KeyStoreException(msg.toString());
                }
                Object keypair = certKeyGenCons.newInstance(KEY_ALGORITHM, SIG_ALGORITHM);
                Object subject = X500NameCons.newInstance(dn);
                Method certAndKeyGenGenerate = certKeyGenClass.getMethod(GENERATE_METHOD, Integer.TYPE);
                certAndKeyGenGenerate.invoke(keypair, 1024);
                Method certAndKeyGetPrivateKey = certKeyGenClass.getMethod(GET_PRIVATE_KEY_METHOD, new Class[0]);
                PrivateKey privatevKey = (PrivateKey)certAndKeyGetPrivateKey.invoke(keypair, new Object[0]);
                Certificate[] certificateChain = new Certificate[1];
                Method getSelfCertificate = certKeyGenClass.getMethod(GET_SELFSIGNED_CERT_METHOD, X500NameClass, Long.TYPE);
                int days = validity * 86400;
                certificateChain[0] = (Certificate)getSelfCertificate.invoke(keypair, subject, days);
                ks.setKeyEntry(alias, privatevKey, pwd, certificateChain);
                FileOutputStream fileOutStream = new FileOutputStream(ksPath);
                ks.store(fileOutStream, pwd);
                fileOutStream.close();
            }
            catch (Exception e) {
                Message msg = UtilityMessages.ERR_CERTMGR_GEN_SELF_SIGNED_CERT.get(alias, e.getMessage());
                throw new KeyStoreException(msg.toString());
            }
            return ks;
        }

        private void trustedCert(String alias, CertificateFactory cf, KeyStore ks, InputStream in) throws KeyStoreException {
            try {
                if (ks.containsAlias(alias)) {
                    Message msg = UtilityMessages.ERR_CERTMGR_ALIAS_ALREADY_EXISTS.get(alias);
                    throw new KeyStoreException(msg.toString());
                }
                X509Certificate cert = (X509Certificate)cf.generateCertificate(in);
                if (this.isSelfSigned(cert)) {
                    cert.verify(cert.getPublicKey());
                }
                ks.setCertificateEntry(alias, cert);
            }
            catch (Exception e) {
                Message msg = UtilityMessages.ERR_CERTMGR_TRUSTED_CERT.get(alias, e.getMessage());
                throw new KeyStoreException(msg.toString());
            }
        }

        private boolean isSelfSigned(X509Certificate cert) {
            return ((Object)cert.getSubjectDN()).equals(cert.getIssuerDN());
        }

        public abstract void normalize(StringBuilder var1);

        static {
            String x509pkg = pkgPrefix + ".x509";
            String certAndKeyGen = x509pkg + ".CertAndKeyGen";
            String X500Name2 = x509pkg + ".X500Name";
            try {
                certKeyGenClass = Class.forName(certAndKeyGen);
                X500NameClass = Class.forName(X500Name2);
                certKeyGenCons = certKeyGenClass.getConstructor(String.class, String.class);
                X500NameCons = X500NameClass.getConstructor(String.class);
            }
            catch (ClassNotFoundException e) {
                Message msg = UtilityMessages.ERR_CERTMGR_CLASS_NOT_FOUND.get(e.getMessage());
                throw new ExceptionInInitializerError(msg.toString());
            }
            catch (SecurityException e) {
                Message msg = UtilityMessages.ERR_CERTMGR_SECURITY.get(e.getMessage());
                throw new ExceptionInInitializerError(msg.toString());
            }
            catch (NoSuchMethodException e) {
                Message msg = UtilityMessages.ERR_CERTMGR_NO_METHOD.get(e.getMessage());
                throw new ExceptionInInitializerError(msg.toString());
            }
        }
    }
}

