/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import org.opends.messages.Message;
import org.opends.server.types.IdentifiedException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class LDIFException
extends IdentifiedException {
    private static final long serialVersionUID = 2291731429121120364L;
    private final boolean canContinueReading;
    private final long lineNumber;

    public LDIFException(Message message) {
        super(message);
        this.lineNumber = -1L;
        this.canContinueReading = true;
    }

    public LDIFException(Message message, Throwable cause) {
        super(message, cause);
        this.lineNumber = -1L;
        this.canContinueReading = true;
    }

    public LDIFException(Message message, Number lineNumber, boolean canContinueReading) {
        super(message);
        this.lineNumber = lineNumber.longValue();
        this.canContinueReading = canContinueReading;
    }

    public LDIFException(Message message, Number lineNumber, boolean canContinueReading, Throwable cause) {
        super(message, cause);
        this.lineNumber = lineNumber.longValue();
        this.canContinueReading = canContinueReading;
    }

    public long getLineNumber() {
        return this.lineNumber;
    }

    public boolean canContinueReading() {
        return this.canContinueReading;
    }
}

