/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import org.opends.messages.Message;
import org.opends.messages.UtilityMessages;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.Platform;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class CertificateManager {
    public static final String KEY_STORE_TYPE_JKS = "JKS";
    public static final String KEY_STORE_TYPE_JCEKS = "JCEKS";
    public static final String KEY_STORE_TYPE_PKCS11 = "PKCS11";
    public static final String KEY_STORE_TYPE_PKCS12 = "PKCS12";
    public static final String KEY_STORE_PATH_PKCS11 = "NONE";
    private static final String KEYSTORE_PATH_MSG = "key store path";
    private static final String KEYSTORE_TYPE_MSG = "key store type";
    private static final String KEYSTORE_PWD_MSG = "key store password";
    private static final String SUBJECT_DN_MSG = "subject DN";
    private static final String CERT_ALIAS_MSG = "certificate alias";
    private static final String CERT_REQUEST_FILE_MSG = "certificate request file";
    private KeyStore keyStore;
    private final String keyStorePath;
    private final String keyStoreType;
    private final char[] password;
    private Boolean realAliases;

    public static boolean mayUseCertificateManager() {
        return true;
    }

    public CertificateManager(String keyStorePath, String keyStoreType, String keyStorePassword) throws IllegalArgumentException {
        CertificateManager.ensureValid(keyStorePath, KEYSTORE_PATH_MSG);
        CertificateManager.ensureValid(keyStoreType, KEYSTORE_TYPE_MSG);
        CertificateManager.ensureValid(keyStorePassword, KEYSTORE_PWD_MSG);
        if (keyStoreType.equals(KEY_STORE_TYPE_PKCS11)) {
            if (!keyStorePath.equals(KEY_STORE_PATH_PKCS11)) {
                Message msg = UtilityMessages.ERR_CERTMGR_INVALID_PKCS11_PATH.get(KEY_STORE_PATH_PKCS11);
                throw new IllegalArgumentException(msg.toString());
            }
        } else if (keyStoreType.equals(KEY_STORE_TYPE_JKS) || keyStoreType.equals(KEY_STORE_TYPE_JCEKS) || keyStoreType.equals(KEY_STORE_TYPE_PKCS12)) {
            File keyStoreFile = new File(keyStorePath);
            if (keyStoreFile.exists()) {
                if (!keyStoreFile.isFile()) {
                    Message msg = UtilityMessages.ERR_CERTMGR_INVALID_KEYSTORE_PATH.get(keyStorePath);
                    throw new IllegalArgumentException(msg.toString());
                }
            } else {
                File keyStoreDirectory = keyStoreFile.getParentFile();
                if (keyStoreDirectory == null || !keyStoreDirectory.exists() || !keyStoreDirectory.isDirectory()) {
                    Message msg = UtilityMessages.ERR_CERTMGR_INVALID_PARENT.get(keyStorePath);
                    throw new IllegalArgumentException(msg.toString());
                }
            }
        } else {
            Message msg = UtilityMessages.ERR_CERTMGR_INVALID_STORETYPE.get(KEY_STORE_TYPE_JKS, KEY_STORE_TYPE_JCEKS, KEY_STORE_TYPE_PKCS11, KEY_STORE_TYPE_PKCS12);
            throw new IllegalArgumentException(msg.toString());
        }
        this.keyStorePath = keyStorePath;
        this.keyStoreType = keyStoreType;
        this.password = keyStorePassword.toCharArray();
        this.keyStore = null;
    }

    public boolean aliasInUse(String alias) throws KeyStoreException {
        CertificateManager.ensureValid(alias, CERT_ALIAS_MSG);
        KeyStore keyStore = this.getKeyStore();
        if (keyStore == null) {
            return false;
        }
        return keyStore.containsAlias(alias);
    }

    public String[] getCertificateAliases() throws KeyStoreException {
        Enumeration<String> aliasEnumeration = null;
        KeyStore keyStore = this.getKeyStore();
        if (keyStore == null) {
            return null;
        }
        aliasEnumeration = keyStore.aliases();
        if (aliasEnumeration == null) {
            return new String[0];
        }
        ArrayList<String> aliasList = new ArrayList<String>();
        while (aliasEnumeration.hasMoreElements()) {
            aliasList.add(aliasEnumeration.nextElement());
        }
        String[] aliases = new String[aliasList.size()];
        return aliasList.toArray(aliases);
    }

    public Certificate getCertificate(String alias) throws KeyStoreException {
        CertificateManager.ensureValid(alias, CERT_ALIAS_MSG);
        Certificate cert = null;
        KeyStore ks = this.getKeyStore();
        if (ks == null) {
            Message msg = UtilityMessages.ERR_CERTMGR_KEYSTORE_NONEXISTANT.get();
            throw new KeyStoreException(msg.toString());
        }
        cert = ks.getCertificate(alias);
        return cert;
    }

    public void generateSelfSignedCertificate(String alias, String subjectDN, int validity) throws KeyStoreException, IllegalArgumentException {
        CertificateManager.ensureValid(alias, CERT_ALIAS_MSG);
        CertificateManager.ensureValid(subjectDN, SUBJECT_DN_MSG);
        if (validity <= 0) {
            Message msg = UtilityMessages.ERR_CERTMGR_VALIDITY.get(validity);
            throw new IllegalArgumentException(msg.toString());
        }
        if (this.aliasInUse(alias)) {
            Message msg = UtilityMessages.ERR_CERTMGR_ALIAS_ALREADY_EXISTS.get(alias);
            throw new IllegalArgumentException(msg.toString());
        }
        this.keyStore = null;
        Platform.generateSelfSignedCertificate(this.getKeyStore(), this.keyStoreType, this.keyStorePath, alias, this.password, subjectDN, validity);
    }

    public void addCertificate(String alias, File certificateFile) throws KeyStoreException, IllegalArgumentException {
        CertificateManager.ensureValid(alias, CERT_ALIAS_MSG);
        CertificateManager.ensureFileValid(certificateFile, CERT_REQUEST_FILE_MSG);
        if (!certificateFile.exists() || !certificateFile.isFile()) {
            Message msg = UtilityMessages.ERR_CERTMGR_INVALID_CERT_FILE.get(certificateFile.getAbsolutePath());
            throw new IllegalArgumentException(msg.toString());
        }
        this.keyStore = null;
        Platform.addCertificate(this.getKeyStore(), this.keyStoreType, this.keyStorePath, alias, this.password, certificateFile.getAbsolutePath());
    }

    public void removeCertificate(String alias) throws KeyStoreException, IllegalArgumentException {
        CertificateManager.ensureValid(alias, CERT_ALIAS_MSG);
        if (!this.aliasInUse(alias)) {
            Message msg = UtilityMessages.ERR_CERTMGR_ALIAS_CAN_NOT_DELETE.get(alias);
            throw new IllegalArgumentException(msg.toString());
        }
        this.keyStore = null;
        Platform.deleteAlias(this.getKeyStore(), this.keyStorePath, alias, this.password);
    }

    private KeyStore getKeyStore() throws KeyStoreException {
        if (this.keyStore != null) {
            return this.keyStore;
        }
        FileInputStream keyStoreInputStream = null;
        if (this.keyStoreType.equals(KEY_STORE_TYPE_JKS) || this.keyStoreType.equals(KEY_STORE_TYPE_JCEKS) || this.keyStoreType.equals(KEY_STORE_TYPE_PKCS12)) {
            File keyStoreFile = new File(this.keyStorePath);
            if (!keyStoreFile.exists()) {
                return null;
            }
            try {
                keyStoreInputStream = new FileInputStream(keyStoreFile);
            }
            catch (Exception e) {
                throw new KeyStoreException(String.valueOf(e), e);
            }
        }
        KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
        try {
            keyStore.load(keyStoreInputStream, this.password);
            KeyStore e = this.keyStore = keyStore;
            return e;
        }
        catch (Exception e) {
            throw new KeyStoreException(String.valueOf(e), e);
        }
        finally {
            if (keyStoreInputStream != null) {
                try {
                    keyStoreInputStream.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    public boolean hasRealAliases() throws KeyStoreException {
        if (this.realAliases == null) {
            CertificateManager certManager2;
            String[] aliases2;
            String[] aliases = this.getCertificateAliases();
            this.realAliases = aliases == null || aliases.length == 0 ? Boolean.FALSE : (aliases.length > 1 ? Boolean.TRUE : ((aliases2 = (certManager2 = new CertificateManager(this.keyStorePath, this.keyStoreType, new String(this.password))).getCertificateAliases()) != null && aliases2.length == 1 ? Boolean.valueOf(aliases[0].equalsIgnoreCase(aliases2[0])) : Boolean.FALSE));
        }
        return this.realAliases;
    }

    private static void ensureFileValid(File arg, String msgStr) {
        if (arg == null) {
            Message msg = UtilityMessages.ERR_CERTMGR_FILE_NAME_INVALID.get(msgStr);
            throw new NullPointerException(msg.toString());
        }
    }

    private static void ensureValid(String arg, String msgStr) {
        if (arg == null || arg.length() == 0) {
            Message msg = UtilityMessages.ERR_CERTMGR_VALUE_INVALID.get(msgStr);
            throw new NullPointerException(msg.toString());
        }
    }
}

