/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.IOException;
import java.io.OutputStream;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;

public class RecordingOutputStream
extends OutputStream {
    private boolean enableRecording = false;
    private OutputStream parentStream;
    private ByteStringBuilder buffer;

    public RecordingOutputStream(OutputStream parentStream) {
        this.parentStream = parentStream;
        this.buffer = new ByteStringBuilder(32);
    }

    public void write(int i) throws IOException {
        if (this.enableRecording) {
            this.buffer.append((byte)i);
        }
        this.parentStream.write(i);
    }

    public void write(byte[] bytes) throws IOException {
        if (this.enableRecording) {
            this.buffer.append(bytes);
        }
        this.parentStream.write(bytes);
    }

    public void write(byte[] bytes, int i, int i1) throws IOException {
        if (this.enableRecording) {
            this.buffer.append(bytes, i, i1);
        }
        this.parentStream.write(bytes, i, i1);
    }

    public void flush() throws IOException {
        this.parentStream.flush();
    }

    public void close() throws IOException {
        this.parentStream.close();
    }

    public ByteString getRecordedBytes() {
        return this.buffer.toByteString();
    }

    public void clearRecordedBytes() {
        this.buffer.clear();
    }

    public boolean isRecordingEnabled() {
        return this.enableRecording;
    }

    public void setRecordingEnabled(boolean enabled) {
        this.enableRecording = enabled;
    }
}

