/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.IOException;
import java.util.ArrayList;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.FilterType;
import org.opends.server.types.LDAPException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public abstract class RawFilter {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public static RawFilter create(String filterString) throws LDAPException {
        return LDAPFilter.decode(filterString);
    }

    public static RawFilter create(SearchFilter filter) {
        return new LDAPFilter(filter);
    }

    public static LDAPFilter createANDFilter(ArrayList<RawFilter> filterComponents) {
        return new LDAPFilter(FilterType.AND, filterComponents, null, null, null, null, null, null, null, false);
    }

    public static LDAPFilter createORFilter(ArrayList<RawFilter> filterComponents) {
        return new LDAPFilter(FilterType.OR, filterComponents, null, null, null, null, null, null, null, false);
    }

    public static LDAPFilter createNOTFilter(RawFilter notComponent) {
        return new LDAPFilter(FilterType.NOT, null, notComponent, null, null, null, null, null, null, false);
    }

    public static LDAPFilter createEqualityFilter(String attributeType, ByteString assertionValue) {
        return new LDAPFilter(FilterType.EQUALITY, null, null, attributeType, assertionValue, null, null, null, null, false);
    }

    public static LDAPFilter createSubstringFilter(String attributeType, ByteString subInitialElement, ArrayList<ByteString> subAnyElements, ByteString subFinalElement) {
        return new LDAPFilter(FilterType.SUBSTRING, null, null, attributeType, null, subInitialElement, subAnyElements, subFinalElement, null, false);
    }

    public static LDAPFilter createGreaterOrEqualFilter(String attributeType, ByteString assertionValue) {
        return new LDAPFilter(FilterType.GREATER_OR_EQUAL, null, null, attributeType, assertionValue, null, null, null, null, false);
    }

    public static LDAPFilter createLessOrEqualFilter(String attributeType, ByteString assertionValue) {
        return new LDAPFilter(FilterType.LESS_OR_EQUAL, null, null, attributeType, assertionValue, null, null, null, null, false);
    }

    public static LDAPFilter createPresenceFilter(String attributeType) {
        return new LDAPFilter(FilterType.PRESENT, null, null, attributeType, null, null, null, null, null, false);
    }

    public static LDAPFilter createApproximateFilter(String attributeType, ByteString assertionValue) {
        return new LDAPFilter(FilterType.APPROXIMATE_MATCH, null, null, attributeType, assertionValue, null, null, null, null, false);
    }

    public static LDAPFilter createExtensibleFilter(String matchingRuleID, String attributeType, ByteString assertionValue, boolean dnAttributes) {
        return new LDAPFilter(FilterType.EXTENSIBLE_MATCH, null, null, attributeType, assertionValue, null, null, null, matchingRuleID, dnAttributes);
    }

    public abstract FilterType getFilterType();

    public abstract ArrayList<RawFilter> getFilterComponents();

    public abstract RawFilter getNOTComponent();

    public abstract String getAttributeType();

    public abstract ByteString getAssertionValue();

    public abstract ByteString getSubInitialElement();

    public abstract ArrayList<ByteString> getSubAnyElements();

    public abstract ByteString getSubFinalElement();

    public abstract String getMatchingRuleID();

    public abstract boolean getDNAttributes();

    public void write(ASN1Writer stream) throws IOException {
        FilterType filterType = this.getFilterType();
        switch (filterType) {
            case AND: 
            case OR: {
                stream.writeStartSequence(filterType.getBERType());
                for (RawFilter f : this.getFilterComponents()) {
                    f.write(stream);
                }
                stream.writeEndSequence();
                return;
            }
            case NOT: {
                stream.writeStartSequence(filterType.getBERType());
                this.getNOTComponent().write(stream);
                stream.writeEndSequence();
                return;
            }
            case EQUALITY: 
            case GREATER_OR_EQUAL: 
            case LESS_OR_EQUAL: 
            case APPROXIMATE_MATCH: {
                stream.writeStartSequence(filterType.getBERType());
                stream.writeOctetString(this.getAttributeType());
                stream.writeOctetString(this.getAssertionValue());
                stream.writeEndSequence();
                return;
            }
            case SUBSTRING: {
                ByteString subFinalElement;
                ArrayList<ByteString> subAnyElements;
                stream.writeStartSequence(filterType.getBERType());
                stream.writeOctetString(this.getAttributeType());
                stream.writeStartSequence();
                ByteString subInitialElement = this.getSubInitialElement();
                if (subInitialElement != null) {
                    stream.writeOctetString((byte)-128, subInitialElement);
                }
                if ((subAnyElements = this.getSubAnyElements()) != null && !subAnyElements.isEmpty()) {
                    for (ByteString s : subAnyElements) {
                        stream.writeOctetString((byte)-127, s);
                    }
                }
                if ((subFinalElement = this.getSubFinalElement()) != null) {
                    stream.writeOctetString((byte)-126, subFinalElement);
                }
                stream.writeEndSequence();
                stream.writeEndSequence();
                return;
            }
            case PRESENT: {
                stream.writeOctetString(filterType.getBERType(), this.getAttributeType());
                return;
            }
            case EXTENSIBLE_MATCH: {
                String attributeType;
                stream.writeStartSequence(filterType.getBERType());
                String matchingRuleID = this.getMatchingRuleID();
                if (matchingRuleID != null) {
                    stream.writeOctetString((byte)-127, matchingRuleID);
                }
                if ((attributeType = this.getAttributeType()) != null) {
                    stream.writeOctetString((byte)-126, attributeType);
                }
                stream.writeOctetString((byte)-125, this.getAssertionValue());
                if (this.getDNAttributes()) {
                    stream.writeBoolean((byte)-124, true);
                }
                stream.writeEndSequence();
                return;
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugError("Invalid search filter type: %s", new Object[]{filterType});
        }
    }

    public static LDAPFilter decode(ASN1Reader reader) throws LDAPException {
        byte type;
        try {
            type = reader.peekType();
        }
        catch (Exception e) {
            Message message = ProtocolMessages.ERR_LDAP_FILTER_DECODE_NULL.get();
            throw new LDAPException(2, message);
        }
        switch (type) {
            case -96: 
            case -95: {
                return RawFilter.decodeCompoundFilter(reader);
            }
            case -94: {
                return RawFilter.decodeNotFilter(reader);
            }
            case -93: 
            case -91: 
            case -90: 
            case -88: {
                return RawFilter.decodeAVAFilter(reader);
            }
            case -92: {
                return RawFilter.decodeSubstringFilter(reader);
            }
            case -121: {
                return RawFilter.decodePresenceFilter(reader);
            }
            case -87: {
                return RawFilter.decodeExtensibleMatchFilter(reader);
            }
        }
        Message message = ProtocolMessages.ERR_LDAP_FILTER_DECODE_INVALID_TYPE.get(type);
        throw new LDAPException(2, message);
    }

    private static LDAPFilter decodeCompoundFilter(ASN1Reader reader) throws LDAPException {
        FilterType filterType;
        byte type;
        try {
            type = reader.peekType();
        }
        catch (Exception e) {
            Message message = ProtocolMessages.ERR_LDAP_FILTER_DECODE_NULL.get();
            throw new LDAPException(2, message);
        }
        switch (type) {
            case -96: {
                filterType = FilterType.AND;
                break;
            }
            case -95: {
                filterType = FilterType.OR;
                break;
            }
            default: {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugError("Invalid filter type %x for a compound filter", type);
                }
                filterType = null;
            }
        }
        ArrayList<RawFilter> filterComponents = new ArrayList<RawFilter>();
        try {
            reader.readStartSequence();
            do {
                filterComponents.add(LDAPFilter.decode(reader));
            } while (reader.hasNextElement());
            reader.readEndSequence();
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_FILTER_DECODE_COMPOUND_COMPONENTS.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new LDAPFilter(filterType, filterComponents, null, null, null, null, null, null, null, false);
    }

    private static LDAPFilter decodeNotFilter(ASN1Reader reader) throws LDAPException {
        LDAPFilter notComponent;
        try {
            reader.readStartSequence();
            notComponent = RawFilter.decode(reader);
            reader.readEndSequence();
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_FILTER_DECODE_NOT_COMPONENT.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new LDAPFilter(FilterType.NOT, null, notComponent, null, null, null, null, null, null, false);
    }

    private static LDAPFilter decodeAVAFilter(ASN1Reader reader) throws LDAPException {
        ByteString assertionValue;
        String attributeType;
        FilterType filterType;
        byte type;
        try {
            type = reader.peekType();
        }
        catch (Exception e) {
            Message message = ProtocolMessages.ERR_LDAP_FILTER_DECODE_NULL.get();
            throw new LDAPException(2, message);
        }
        switch (type) {
            case -93: {
                filterType = FilterType.EQUALITY;
                break;
            }
            case -91: {
                filterType = FilterType.GREATER_OR_EQUAL;
                break;
            }
            case -90: {
                filterType = FilterType.LESS_OR_EQUAL;
                break;
            }
            case -88: {
                filterType = FilterType.APPROXIMATE_MATCH;
                break;
            }
            default: {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugError("Invalid filter type %x for a type-and-value filter", type);
                }
                filterType = null;
            }
        }
        try {
            reader.readStartSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_FILTER_DECODE_TV_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            attributeType = reader.readOctetStringAsString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_FILTER_DECODE_TV_TYPE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            assertionValue = reader.readOctetString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_FILTER_DECODE_TV_VALUE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_FILTER_DECODE_TV_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new LDAPFilter(filterType, null, null, attributeType, assertionValue, null, null, null, null, false);
    }

    private static LDAPFilter decodeSubstringFilter(ASN1Reader reader) throws LDAPException {
        String attributeType;
        try {
            reader.readStartSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_FILTER_DECODE_SUBSTRING_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            attributeType = reader.readOctetStringAsString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_FILTER_DECODE_SUBSTRING_TYPE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readStartSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_FILTER_DECODE_SUBSTRING_ELEMENTS.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.peekType();
        }
        catch (Exception e) {
            Message message = ProtocolMessages.ERR_LDAP_FILTER_DECODE_SUBSTRING_NO_SUBELEMENTS.get();
            throw new LDAPException(2, message);
        }
        ByteString subInitialElement = null;
        ByteString subFinalElement = null;
        ArrayList<ByteString> subAnyElements = null;
        try {
            if (reader.hasNextElement() && reader.peekType() == -128) {
                subInitialElement = reader.readOctetString();
            }
            while (reader.hasNextElement() && reader.peekType() == -127) {
                if (subAnyElements == null) {
                    subAnyElements = new ArrayList<ByteString>();
                }
                subAnyElements.add(reader.readOctetString());
            }
            if (reader.hasNextElement() && reader.peekType() == -126) {
                subFinalElement = reader.readOctetString();
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_FILTER_DECODE_SUBSTRING_VALUES.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_FILTER_DECODE_SUBSTRING_ELEMENTS.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_FILTER_DECODE_SUBSTRING_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new LDAPFilter(FilterType.SUBSTRING, null, null, attributeType, null, subInitialElement, subAnyElements, subFinalElement, null, false);
    }

    private static LDAPFilter decodePresenceFilter(ASN1Reader reader) throws LDAPException {
        String attributeType;
        try {
            attributeType = reader.readOctetStringAsString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_FILTER_DECODE_PRESENCE_TYPE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new LDAPFilter(FilterType.PRESENT, null, null, attributeType, null, null, null, null, null, false);
    }

    private static LDAPFilter decodeExtensibleMatchFilter(ASN1Reader reader) throws LDAPException {
        ByteString assertionValue;
        try {
            reader.readStartSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_FILTER_DECODE_EXTENSIBLE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        boolean dnAttributes = false;
        String attributeType = null;
        String matchingRuleID = null;
        try {
            if (reader.peekType() == -127) {
                matchingRuleID = reader.readOctetStringAsString();
            }
            if (matchingRuleID == null || reader.peekType() == -126) {
                attributeType = reader.readOctetStringAsString();
            }
            assertionValue = reader.readOctetString();
            if (reader.hasNextElement() && reader.peekType() == -124) {
                dnAttributes = reader.readBoolean();
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_FILTER_DECODE_EXTENSIBLE_ELEMENTS.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            reader.readEndSequence();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_FILTER_DECODE_EXTENSIBLE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new LDAPFilter(FilterType.EXTENSIBLE_MATCH, null, null, attributeType, assertionValue, null, null, null, matchingRuleID, dnAttributes);
    }

    public abstract SearchFilter toSearchFilter() throws DirectoryException;

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public abstract void toString(StringBuilder var1);

    public static void valueToFilterString(StringBuilder buffer, ByteString value) {
        if (value == null) {
            return;
        }
        buffer.ensureCapacity(buffer.length() + value.length());
        for (int i = 0; i < value.length(); ++i) {
            byte b = value.byteAt(i);
            if ((b & 0x7F) != b || b <= 31 || b == 40 || b == 41 || b == 42 || b == 92 || b == 127) {
                buffer.append("\\");
                buffer.append(StaticUtils.byteToHex(b));
                continue;
            }
            buffer.append((char)b);
        }
    }
}

