/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.List;
import org.opends.messages.Message;
import org.opends.server.types.DN;
import org.opends.server.types.IdentifiedException;
import org.opends.server.types.OpenDsException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.ResultCode;
import org.opends.server.types.StabilityLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class DirectoryException
extends IdentifiedException {
    private static final long serialVersionUID = 2615453139798417203L;
    private final DN matchedDN;
    private final List<String> referralURLs;
    private final ResultCode resultCode;

    public DirectoryException(ResultCode resultCode, Message errorMessage) {
        super(errorMessage);
        this.resultCode = resultCode;
        this.matchedDN = null;
        this.referralURLs = null;
    }

    public DirectoryException(ResultCode resultCode, Message errorMessage, Throwable cause) {
        super(errorMessage, cause);
        this.resultCode = resultCode;
        this.matchedDN = null;
        this.referralURLs = null;
    }

    public DirectoryException(ResultCode resultCode, OpenDsException cause) {
        super(cause.getMessageObject(), (Throwable)cause);
        this.resultCode = resultCode;
        this.matchedDN = null;
        this.referralURLs = null;
    }

    public DirectoryException(ResultCode resultCode, Message errorMessage, DN matchedDN, Throwable cause) {
        super(errorMessage, cause);
        this.resultCode = resultCode;
        this.matchedDN = matchedDN;
        this.referralURLs = null;
    }

    public DirectoryException(ResultCode resultCode, Message errorMessage, DN matchedDN, List<String> referralURLs, Throwable cause) {
        super(errorMessage, cause);
        this.resultCode = resultCode;
        this.matchedDN = matchedDN;
        this.referralURLs = referralURLs;
    }

    public ResultCode getResultCode() {
        return this.resultCode;
    }

    public DN getMatchedDN() {
        return this.matchedDN;
    }

    public List<String> getReferralURLs() {
        return this.referralURLs;
    }
}

