/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.IOException;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=true, mayInvoke=true)
public abstract class Control {
    private boolean isCritical;
    private String oid;

    protected Control(String oid, boolean isCritical) {
        this.oid = oid;
        this.isCritical = isCritical;
    }

    public final String getOID() {
        return this.oid;
    }

    public final boolean isCritical() {
        return this.isCritical;
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public final void write(ASN1Writer writer) throws IOException {
        writer.writeStartSequence();
        writer.writeOctetString(this.getOID());
        if (this.isCritical()) {
            writer.writeBoolean(this.isCritical());
        }
        this.writeValue(writer);
        writer.writeEndSequence();
    }

    protected abstract void writeValue(ASN1Writer var1) throws IOException;

    public void toString(StringBuilder buffer) {
        buffer.append("Control(oid=");
        buffer.append(this.oid);
        buffer.append(",isCritical=");
        buffer.append(this.isCritical);
        buffer.append(")");
    }
}

