/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateValue;
import org.opends.server.types.AttributeType;

public class TemplateLine {
    private AttributeType attributeType;
    private int lineNumber;
    private Tag[] tags;
    private boolean isURL;
    private boolean isBase64;

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean isURL() {
        return this.isURL;
    }

    public boolean isBase64() {
        return this.isBase64;
    }

    public TemplateLine(AttributeType attributeType, int lineNumber, Tag[] tags) {
        this(attributeType, lineNumber, tags, false, false);
    }

    public TemplateLine(AttributeType attributeType, int lineNumber, Tag[] tags, boolean isURL, boolean isBase64) {
        this.attributeType = attributeType;
        this.lineNumber = lineNumber;
        this.tags = tags;
        this.isURL = isURL;
        this.isBase64 = isBase64;
    }

    public TagResult generateLine(TemplateEntry templateEntry) {
        TemplateValue value = new TemplateValue(this);
        for (Tag t : this.tags) {
            TagResult result = t.generateValue(templateEntry, value);
            if (result.keepProcessingLine() && result.keepProcessingEntry() && result.keepProcessingParent() && result.keepProcessingTemplateFile()) continue;
            return result;
        }
        templateEntry.addValue(value);
        return TagResult.SUCCESS_RESULT;
    }
}

