/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsreplication;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ADSContextException;
import org.opends.admin.ads.ReplicaDescriptor;
import org.opends.admin.ads.ServerDescriptor;
import org.opends.admin.ads.SuffixDescriptor;
import org.opends.admin.ads.TopologyCache;
import org.opends.admin.ads.TopologyCacheException;
import org.opends.admin.ads.TopologyCacheFilter;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.admin.ads.util.PreferredConnection;
import org.opends.admin.ads.util.ServerLoader;
import org.opends.guitools.controlpanel.util.ControlPanelLog;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.messages.ToolMessages;
import org.opends.messages.UtilityMessages;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.Constants;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.event.ProgressUpdateEvent;
import org.opends.quicksetup.event.ProgressUpdateListener;
import org.opends.quicksetup.installer.InstallerHelper;
import org.opends.quicksetup.installer.PeerNotFoundException;
import org.opends.quicksetup.installer.offline.OfflineInstaller;
import org.opends.quicksetup.util.PlainTextProgressMessageFormatter;
import org.opends.quicksetup.util.Utils;
import org.opends.server.admin.AttributeTypePropertyDefinition;
import org.opends.server.admin.ClassLoaderProvider;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.DefaultBehaviorException;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.client.ldap.JNDIDirContextAdaptor;
import org.opends.server.admin.client.ldap.LDAPManagementContext;
import org.opends.server.admin.std.client.CryptoManagerCfgClient;
import org.opends.server.admin.std.client.ReplicationDomainCfgClient;
import org.opends.server.admin.std.client.ReplicationServerCfgClient;
import org.opends.server.admin.std.client.ReplicationSynchronizationProviderCfgClient;
import org.opends.server.admin.std.client.RootCfgClient;
import org.opends.server.admin.std.meta.ReplicationDomainCfgDefn;
import org.opends.server.admin.std.meta.ReplicationServerCfgDefn;
import org.opends.server.admin.std.meta.ReplicationSynchronizationProviderCfgDefn;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.replication.plugin.MultimasterReplication;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.ToolConstants;
import org.opends.server.tools.dsreplication.DisableReplicationUserData;
import org.opends.server.tools.dsreplication.EnableReplicationUserData;
import org.opends.server.tools.dsreplication.InitializeAllReplicationUserData;
import org.opends.server.tools.dsreplication.InitializeReplicationUserData;
import org.opends.server.tools.dsreplication.PostExternalInitializationUserData;
import org.opends.server.tools.dsreplication.PreExternalInitializationUserData;
import org.opends.server.tools.dsreplication.ReplicationCliArgumentParser;
import org.opends.server.tools.dsreplication.ReplicationCliException;
import org.opends.server.tools.dsreplication.ReplicationCliReturnCode;
import org.opends.server.tools.dsreplication.ReplicationServerComparator;
import org.opends.server.tools.dsreplication.ReplicationUserData;
import org.opends.server.tools.dsreplication.ServerComparator;
import org.opends.server.tools.dsreplication.StatusReplicationUserData;
import org.opends.server.tools.dsreplication.SuffixComparator;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.types.OpenDsException;
import org.opends.server.util.SetupUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.cli.CLIException;
import org.opends.server.util.cli.CommandBuilder;
import org.opends.server.util.cli.ConsoleApplication;
import org.opends.server.util.cli.LDAPConnectionConsoleInteraction;
import org.opends.server.util.cli.MenuBuilder;
import org.opends.server.util.cli.MenuResult;
import org.opends.server.util.table.TableBuilder;
import org.opends.server.util.table.TextTablePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationCliMain
extends ConsoleApplication {
    private static final String CLASS_NAME = ReplicationCliMain.class.getName();
    public static final String LOG_FILE_PREFIX = "opends-replication-";
    public static final String LOG_FILE_SUFFIX = ".log";
    private boolean forceNonInteractive;
    private static final Logger LOG = Logger.getLogger(ReplicationCliMain.class.getName());
    private boolean useSSL = true;
    private boolean useStartTLS = false;
    private ReplicationCliArgumentParser argParser;
    private FileBasedArgument userProvidedAdminPwdFile;
    private LDAPConnectionConsoleInteraction ci = null;
    private CommandBuilder firstServerCommandBuilder;
    PlainTextProgressMessageFormatter formatter = new PlainTextProgressMessageFormatter();

    public ReplicationCliMain(PrintStream out, PrintStream err, InputStream in) {
        super(in, (OutputStream)out, (OutputStream)err);
    }

    public static void main(String[] args) {
        int retCode = ReplicationCliMain.mainCLI(args, true, System.out, System.err, System.in);
        System.exit(retCode);
    }

    public static int mainCLI(String[] args) {
        return ReplicationCliMain.mainCLI(args, true, System.out, System.err, System.in);
    }

    public static int mainCLI(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream, InputStream inStream) {
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        try {
            ControlPanelLog.initLogFileHandler(File.createTempFile(LOG_FILE_PREFIX, LOG_FILE_SUFFIX));
        }
        catch (Throwable t) {
            System.err.println("Unable to initialize log");
            t.printStackTrace();
        }
        ReplicationCliMain replicationCli = new ReplicationCliMain(out, err, inStream);
        return replicationCli.execute(args, initializeServer);
    }

    public int execute(String[] args, boolean initializeServer) {
        Message message;
        ReplicationCliReturnCode returnValue = ReplicationCliReturnCode.SUCCESSFUL_NOP;
        try {
            this.createArgumenParser();
        }
        catch (ArgumentException ae) {
            message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            this.println(message);
            LOG.log(Level.SEVERE, "Complete error stack:", ae);
            returnValue = ReplicationCliReturnCode.CANNOT_INITIALIZE_ARGS;
        }
        if (returnValue == ReplicationCliReturnCode.SUCCESSFUL_NOP) {
            try {
                this.argParser.getSecureArgsList().initArgumentsWithConfiguration();
            }
            catch (ConfigException ce) {
                // empty catch block
            }
            try {
                this.argParser.parseArguments(args);
            }
            catch (ArgumentException ae) {
                message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
                this.println(message);
                this.println();
                this.println(Message.raw(this.argParser.getUsage(), new Object[0]));
                LOG.log(Level.SEVERE, "Complete error stack:", ae);
                returnValue = ReplicationCliReturnCode.ERROR_USER_DATA;
            }
        }
        if (!this.argParser.usageOrVersionDisplayed()) {
            if (returnValue == ReplicationCliReturnCode.SUCCESSFUL_NOP) {
                MessageBuilder buf = new MessageBuilder();
                this.argParser.validateOptions(buf);
                if (buf.length() > 0) {
                    this.println(buf.toMessage());
                    this.println(Message.raw(this.argParser.getUsage(), new Object[0]));
                    returnValue = ReplicationCliReturnCode.ERROR_USER_DATA;
                }
            }
            if (initializeServer) {
                DirectoryServer.bootstrapClient();
                try {
                    if (!ClassLoaderProvider.getInstance().isEnabled()) {
                        ClassLoaderProvider.getInstance().enable();
                    }
                    ClassPropertyDefinition.setAllowClassValidation(false);
                    AttributeTypePropertyDefinition.setCheckSchema(false);
                }
                catch (InitializationException ie) {
                    this.println(ie.getMessageObject());
                    returnValue = ReplicationCliReturnCode.ERROR_INITIALIZING_ADMINISTRATION_FRAMEWORK;
                }
            }
            if (returnValue == ReplicationCliReturnCode.SUCCESSFUL_NOP) {
                if (this.argParser.getSecureArgsList().bindPasswordFileArg.isPresent()) {
                    try {
                        this.userProvidedAdminPwdFile = new FileBasedArgument("adminPasswordFile", Character.valueOf('j'), "adminPasswordFile", false, false, ToolMessages.INFO_BINDPWD_FILE_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_REPLICATION_ADMIN_BINDPASSWORDFILE.get());
                        this.userProvidedAdminPwdFile.getNameToValueMap().putAll(this.argParser.getSecureArgsList().bindPasswordFileArg.getNameToValueMap());
                    }
                    catch (Throwable t) {
                        throw new IllegalStateException("Unexpected error: " + t, t);
                    }
                }
                this.ci = new LDAPConnectionConsoleInteraction(this, this.argParser.getSecureArgsList());
                this.ci.setDisplayLdapIfSecureParameters(false);
            }
            if (returnValue == ReplicationCliReturnCode.SUCCESSFUL_NOP) {
                File logFile;
                boolean subcommandLaunched = true;
                String subCommand = null;
                if (this.argParser.isEnableReplicationSubcommand()) {
                    returnValue = this.enableReplication();
                    subCommand = "enable";
                } else if (this.argParser.isDisableReplicationSubcommand()) {
                    returnValue = this.disableReplication();
                    subCommand = "disable";
                } else if (this.argParser.isInitializeReplicationSubcommand()) {
                    returnValue = this.initializeReplication();
                    subCommand = "initialize";
                } else if (this.argParser.isInitializeAllReplicationSubcommand()) {
                    returnValue = this.initializeAllReplication();
                    subCommand = "initialize-all";
                } else if (this.argParser.isPreExternalInitializationSubcommand()) {
                    returnValue = this.preExternalInitialization();
                    subCommand = "pre-external-initialization";
                } else if (this.argParser.isPostExternalInitializationSubcommand()) {
                    returnValue = this.postExternalInitialization();
                    subCommand = "post-external-initialization";
                } else if (this.argParser.isStatusReplicationSubcommand()) {
                    returnValue = this.statusReplication();
                    subCommand = "status";
                } else if (this.argParser.isInteractive()) {
                    switch (this.promptForSubcommand()) {
                        case ENABLE: {
                            subCommand = "enable";
                            break;
                        }
                        case DISABLE: {
                            subCommand = "disable";
                            break;
                        }
                        case INITIALIZE: {
                            subCommand = "initialize";
                            break;
                        }
                        case INITIALIZE_ALL: {
                            subCommand = "initialize-all";
                            break;
                        }
                        case PRE_EXTERNAL_INITIALIZATION: {
                            subCommand = "pre-external-initialization";
                            break;
                        }
                        case POST_EXTERNAL_INITIALIZATION: {
                            subCommand = "post-external-initialization";
                            break;
                        }
                        case STATUS: {
                            subCommand = "status";
                            break;
                        }
                        default: {
                            returnValue = ReplicationCliReturnCode.USER_CANCELLED;
                        }
                    }
                    if (subCommand != null) {
                        String[] newArgs = new String[args.length + 1];
                        newArgs[0] = subCommand;
                        for (int i = 0; i < args.length; ++i) {
                            newArgs[i + 1] = args[i];
                        }
                        return this.execute(newArgs, false);
                    }
                } else {
                    this.println(AdminToolMessages.ERR_REPLICATION_VALID_SUBCOMMAND_NOT_FOUND.get("--no-prompt"));
                    this.println(Message.raw(this.argParser.getUsage(), new Object[0]));
                    returnValue = ReplicationCliReturnCode.ERROR_USER_DATA;
                    subcommandLaunched = false;
                }
                if (subcommandLaunched && returnValue == ReplicationCliReturnCode.SUCCESSFUL && this.displayLogFileAtEnd(subCommand) && (logFile = ControlPanelLog.getLogFile()) != null) {
                    this.println();
                    this.println(QuickSetupMessages.INFO_GENERAL_SEE_FOR_DETAILS.get(logFile.getPath()));
                    this.println();
                }
            }
        }
        return returnValue.getReturnCode();
    }

    private void createArgumenParser() throws ArgumentException {
        this.argParser = new ReplicationCliArgumentParser(CLASS_NAME);
        this.argParser.initializeParser(this.getOutputStream());
    }

    private ReplicationCliReturnCode enableReplication() {
        ReplicationCliReturnCode returnValue;
        block5: {
            EnableReplicationUserData uData = new EnableReplicationUserData();
            if (this.argParser.isInteractive()) {
                try {
                    if (this.promptIfRequired(uData)) {
                        returnValue = this.enableReplication(uData);
                        break block5;
                    }
                    returnValue = ReplicationCliReturnCode.USER_CANCELLED;
                }
                catch (ReplicationCliException rce) {
                    returnValue = rce.getErrorCode();
                    this.println();
                    this.println(this.getCriticalExceptionMessage(rce));
                }
            } else {
                this.initializeWithArgParser(uData);
                returnValue = this.enableReplication(uData);
            }
        }
        return returnValue;
    }

    private ReplicationCliReturnCode disableReplication() {
        ReplicationCliReturnCode returnValue;
        block5: {
            DisableReplicationUserData uData = new DisableReplicationUserData();
            if (this.argParser.isInteractive()) {
                try {
                    if (this.promptIfRequired(uData)) {
                        returnValue = this.disableReplication(uData);
                        break block5;
                    }
                    returnValue = ReplicationCliReturnCode.USER_CANCELLED;
                }
                catch (ReplicationCliException rce) {
                    returnValue = rce.getErrorCode();
                    this.println();
                    this.println(this.getCriticalExceptionMessage(rce));
                }
            } else {
                this.initializeWithArgParser(uData);
                returnValue = this.disableReplication(uData);
            }
        }
        return returnValue;
    }

    private ReplicationCliReturnCode initializeAllReplication() {
        ReplicationCliReturnCode returnValue;
        InitializeAllReplicationUserData uData = new InitializeAllReplicationUserData();
        if (this.argParser.isInteractive()) {
            returnValue = this.promptIfRequired(uData) ? this.initializeAllReplication(uData) : ReplicationCliReturnCode.USER_CANCELLED;
        } else {
            this.initializeWithArgParser(uData);
            returnValue = this.initializeAllReplication(uData);
        }
        return returnValue;
    }

    private ReplicationCliReturnCode preExternalInitialization() {
        ReplicationCliReturnCode returnValue;
        PreExternalInitializationUserData uData = new PreExternalInitializationUserData();
        if (this.argParser.isInteractive()) {
            returnValue = this.promptIfRequired(uData) ? this.preExternalInitialization(uData) : ReplicationCliReturnCode.USER_CANCELLED;
        } else {
            this.initializeWithArgParser(uData);
            returnValue = this.preExternalInitialization(uData);
        }
        return returnValue;
    }

    private ReplicationCliReturnCode postExternalInitialization() {
        ReplicationCliReturnCode returnValue;
        PostExternalInitializationUserData uData = new PostExternalInitializationUserData();
        if (this.argParser.isInteractive()) {
            returnValue = this.promptIfRequired(uData) ? this.postExternalInitialization(uData) : ReplicationCliReturnCode.USER_CANCELLED;
        } else {
            this.initializeWithArgParser(uData);
            returnValue = this.postExternalInitialization(uData);
        }
        return returnValue;
    }

    private ReplicationCliReturnCode statusReplication() {
        ReplicationCliReturnCode returnValue;
        block5: {
            StatusReplicationUserData uData = new StatusReplicationUserData();
            if (this.argParser.isInteractive()) {
                try {
                    if (this.promptIfRequired(uData)) {
                        returnValue = this.statusReplication(uData);
                        break block5;
                    }
                    returnValue = ReplicationCliReturnCode.USER_CANCELLED;
                }
                catch (ReplicationCliException rce) {
                    returnValue = rce.getErrorCode();
                    this.println();
                    this.println(this.getCriticalExceptionMessage(rce));
                }
            } else {
                this.initializeWithArgParser(uData);
                returnValue = this.statusReplication(uData);
            }
        }
        return returnValue;
    }

    private ReplicationCliReturnCode initializeReplication() {
        ReplicationCliReturnCode returnValue;
        InitializeReplicationUserData uData = new InitializeReplicationUserData();
        if (this.argParser.isInteractive()) {
            returnValue = this.promptIfRequired(uData) ? this.initializeReplication(uData) : ReplicationCliReturnCode.USER_CANCELLED;
        } else {
            this.initializeWithArgParser(uData);
            returnValue = this.initializeReplication(uData);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean promptIfRequired(EnableReplicationUserData uData) throws ReplicationCliException {
        boolean configureReplicationDomain2;
        boolean configureReplicationDomain1;
        boolean cancelled = false;
        boolean administratorDefined = false;
        this.ci.setUseAdminOrBindDn(true);
        String adminPwd = this.argParser.getBindPasswordAdmin();
        String adminUid = this.argParser.getAdministratorUID();
        String host1 = this.argParser.getHostName1();
        int port1 = this.argParser.getPort1();
        String bindDn1 = this.argParser.getBindDn1();
        String pwd1 = this.argParser.getBindPassword1();
        String pwd = null;
        LinkedHashMap<String, String> pwdFile = null;
        if (this.argParser.bindPassword1Arg.isPresent()) {
            pwd = this.argParser.bindPassword1Arg.getValue();
        } else if (this.argParser.bindPasswordFile1Arg.isPresent()) {
            pwdFile = this.argParser.bindPasswordFile1Arg.getNameToValueMap();
        } else if (bindDn1 == null) {
            pwd = adminPwd;
            if (this.argParser.getSecureArgsList().bindPasswordFileArg.isPresent()) {
                pwdFile = this.argParser.getSecureArgsList().bindPasswordFileArg.getNameToValueMap();
            }
        }
        this.ci.initializeGlobalArguments(host1, port1, adminUid, bindDn1, pwd, pwdFile == null ? null : new LinkedHashMap<String, String>(pwdFile));
        InitialLdapContext ctx1 = null;
        while (ctx1 == null && !cancelled) {
            try {
                this.ci.setHeadingMessage(AdminToolMessages.INFO_REPLICATION_ENABLE_HOST1_CONNECTION_PARAMETERS.get());
                this.ci.run();
                host1 = this.ci.getHostName();
                port1 = this.ci.getPortNumber();
                if (this.ci.getProvidedAdminUID() != null) {
                    adminUid = this.ci.getProvidedAdminUID();
                    if (this.ci.getProvidedBindDN() == null) {
                        adminPwd = this.ci.getBindPassword();
                    }
                }
                bindDn1 = this.ci.getBindDN();
                pwd1 = this.ci.getBindPassword();
                ctx1 = this.createInitialLdapContextInteracting(this.ci);
                if (ctx1 != null) continue;
                cancelled = true;
            }
            catch (ClientException ce) {
                LOG.log(Level.WARNING, "Client exception " + ce);
                this.println();
                this.println(ce.getMessageObject());
                this.println();
                this.ci.resetConnectionArguments();
            }
            catch (ArgumentException ae) {
                LOG.log(Level.WARNING, "Argument exception " + ae);
                this.println();
                this.println(ae.getMessageObject());
                this.println();
                cancelled = true;
            }
        }
        if (!cancelled) {
            uData.setHostName1(host1);
            uData.setPort1(port1);
            uData.setBindDn1(bindDn1);
            uData.setPwd1(pwd1);
        }
        int replicationPort1 = -1;
        boolean secureReplication1 = this.argParser.isSecureReplication1();
        boolean configureReplicationServer1 = !this.argParser.noReplicationServer1Arg.isPresent();
        boolean bl = configureReplicationDomain1 = !this.argParser.onlyReplicationServer1Arg.isPresent();
        if (ctx1 != null) {
            InitialLdapContext[] aux;
            boolean replicationServer1Configured;
            int repPort1 = this.getReplicationPort(ctx1);
            boolean bl2 = replicationServer1Configured = repPort1 > 0;
            if (replicationServer1Configured && !configureReplicationServer1) {
                try {
                    if (!this.askConfirmation(AdminToolMessages.INFO_REPLICATION_SERVER_CONFIGURED_WARNING_PROMPT.get(ConnectionUtils.getHostPort(ctx1), repPort1), false, LOG)) {
                        cancelled = true;
                    }
                }
                catch (CLIException ce) {
                    this.println(ce.getMessageObject());
                    cancelled = true;
                }
            }
            if (!replicationServer1Configured && configureReplicationServer1 && !cancelled && this.argParser.advancedArg.isPresent() && configureReplicationDomain1) {
                try {
                    configureReplicationServer1 = this.askConfirmation(AdminToolMessages.INFO_REPLICATION_ENABLE_REPLICATION_SERVER1_PROMPT.get(), true, LOG);
                }
                catch (CLIException ce) {
                    this.println(ce.getMessageObject());
                    cancelled = true;
                }
            }
            if (!cancelled && !replicationServer1Configured && configureReplicationServer1) {
                boolean tryWithDefault;
                boolean bl3 = tryWithDefault = this.argParser.getReplicationPort1() != -1;
                while (replicationPort1 == -1) {
                    if (tryWithDefault) {
                        replicationPort1 = this.argParser.getReplicationPort1();
                        tryWithDefault = false;
                    } else {
                        replicationPort1 = this.askPort(AdminToolMessages.INFO_REPLICATION_ENABLE_REPLICATIONPORT1_PROMPT.get(), this.argParser.getDefaultReplicationPort1(), LOG);
                        this.println();
                    }
                    if (!this.argParser.skipReplicationPortCheck() && Utils.isLocalHost(host1)) {
                        if (SetupUtils.canUseAsPort(replicationPort1)) continue;
                        this.println();
                        this.println(this.getCannotBindToPortError(replicationPort1));
                        this.println();
                        replicationPort1 = -1;
                        continue;
                    }
                    if (replicationPort1 != port1) continue;
                    this.println();
                    this.println(AdminToolMessages.ERR_REPLICATION_PORT_AND_REPLICATION_PORT_EQUAL.get(host1, String.valueOf(replicationPort1)));
                    this.println();
                    replicationPort1 = -1;
                }
                if (!secureReplication1) {
                    try {
                        secureReplication1 = this.askConfirmation(AdminToolMessages.INFO_REPLICATION_ENABLE_SECURE1_PROMPT.get(String.valueOf(replicationPort1)), false, LOG);
                    }
                    catch (CLIException ce) {
                        this.println(ce.getMessageObject());
                        cancelled = true;
                    }
                    this.println();
                }
            }
            if (!cancelled && configureReplicationDomain1 && configureReplicationServer1 && this.argParser.advancedArg.isPresent()) {
                try {
                    configureReplicationDomain1 = this.askConfirmation(AdminToolMessages.INFO_REPLICATION_ENABLE_REPLICATION_DOMAIN1_PROMPT.get(), true, LOG);
                }
                catch (CLIException ce) {
                    this.println(ce.getMessageObject());
                    cancelled = true;
                }
            }
            cancelled = !this.loadADSAndAcceptCertificates(aux = new InitialLdapContext[]{ctx1}, uData, true);
            ctx1 = aux[0];
            if (!cancelled) {
                administratorDefined |= this.hasAdministrator(ctx1);
                if (uData.getAdminPwd() != null) {
                    adminPwd = uData.getAdminPwd();
                }
            }
        }
        uData.setReplicationPort1(replicationPort1);
        uData.setSecureReplication1(secureReplication1);
        uData.setConfigureReplicationServer1(configureReplicationServer1);
        uData.setConfigureReplicationDomain1(configureReplicationDomain1);
        this.firstServerCommandBuilder = new CommandBuilder(null);
        if (this.mustPrintCommandBuilder()) {
            this.firstServerCommandBuilder.append(this.ci.getCommandBuilder());
        }
        String host2 = null;
        int port2 = -1;
        String bindDn2 = null;
        String pwd2 = null;
        this.ci.resetHeadingDisplayed();
        boolean doNotDisplayFirstError = false;
        if (!cancelled) {
            host2 = this.argParser.getHostName2();
            port2 = this.argParser.getPort2();
            bindDn2 = this.argParser.getBindDn2();
            pwd2 = this.argParser.getBindPassword2();
            pwdFile = null;
            pwd = null;
            if (this.argParser.bindPassword2Arg.isPresent()) {
                pwd = this.argParser.bindPassword2Arg.getValue();
            } else if (this.argParser.bindPasswordFile2Arg.isPresent()) {
                pwdFile = this.argParser.bindPasswordFile2Arg.getNameToValueMap();
            } else if (bindDn2 == null) {
                doNotDisplayFirstError = true;
                pwd = adminPwd;
                if (this.argParser.getSecureArgsList().bindPasswordFileArg.isPresent()) {
                    pwdFile = this.argParser.getSecureArgsList().bindPasswordFileArg.getNameToValueMap();
                }
            }
            this.ci.initializeGlobalArguments(host2, port2, adminUid, bindDn2, pwd, pwdFile == null ? null : new LinkedHashMap<String, String>(pwdFile));
        }
        InitialLdapContext ctx2 = null;
        while (ctx2 == null && !cancelled) {
            try {
                this.ci.setHeadingMessage(AdminToolMessages.INFO_REPLICATION_ENABLE_HOST2_CONNECTION_PARAMETERS.get());
                this.ci.run();
                host2 = this.ci.getHostName();
                port2 = this.ci.getPortNumber();
                if (this.ci.getProvidedAdminUID() != null) {
                    adminUid = this.ci.getProvidedAdminUID();
                    if (this.ci.getProvidedBindDN() == null) {
                        adminPwd = this.ci.getBindPassword();
                    }
                }
                bindDn2 = this.ci.getBindDN();
                pwd2 = this.ci.getBindPassword();
                boolean error = false;
                if (host1.equalsIgnoreCase(host2) && port1 == port2) {
                    port2 = -1;
                    Message message = AdminToolMessages.ERR_REPLICATION_ENABLE_SAME_SERVER_PORT.get(host1, String.valueOf(port1));
                    this.println();
                    this.println(message);
                    this.println();
                    error = true;
                }
                if (error || (ctx2 = this.createInitialLdapContextInteracting(this.ci, true)) != null) continue;
                cancelled = true;
            }
            catch (ClientException ce) {
                LOG.log(Level.WARNING, "Client exception " + ce);
                if (!doNotDisplayFirstError) {
                    this.println();
                    this.println(ce.getMessageObject());
                    this.println();
                    this.ci.resetConnectionArguments();
                    continue;
                }
                this.ci.resetConnectionArguments();
                this.ci.initializeGlobalArguments(host2, port2, null, null, null, null);
            }
            catch (ArgumentException ae) {
                LOG.log(Level.WARNING, "Argument exception " + ae);
                this.println();
                this.println(ae.getMessageObject());
                this.println();
                cancelled = true;
            }
            finally {
                doNotDisplayFirstError = false;
            }
        }
        if (!cancelled) {
            uData.setHostName2(host2);
            uData.setPort2(port2);
            uData.setBindDn2(bindDn2);
            uData.setPwd2(pwd2);
        }
        int replicationPort2 = -1;
        boolean secureReplication2 = this.argParser.isSecureReplication2();
        boolean configureReplicationServer2 = !this.argParser.noReplicationServer2Arg.isPresent();
        boolean bl4 = configureReplicationDomain2 = !this.argParser.onlyReplicationServer2Arg.isPresent();
        if (ctx2 != null) {
            InitialLdapContext[] aux;
            boolean replicationServer2Configured;
            int repPort2 = this.getReplicationPort(ctx2);
            boolean bl5 = replicationServer2Configured = repPort2 > 0;
            if (replicationServer2Configured && !configureReplicationServer2) {
                try {
                    if (!this.askConfirmation(AdminToolMessages.INFO_REPLICATION_SERVER_CONFIGURED_WARNING_PROMPT.get(ConnectionUtils.getHostPort(ctx2), repPort2), false, LOG)) {
                        cancelled = true;
                    }
                }
                catch (CLIException ce) {
                    this.println(ce.getMessageObject());
                    cancelled = true;
                }
            }
            if (!replicationServer2Configured && configureReplicationServer2 && !cancelled) {
                if (this.argParser.advancedArg.isPresent() && configureReplicationDomain2) {
                    try {
                        configureReplicationServer2 = this.askConfirmation(AdminToolMessages.INFO_REPLICATION_ENABLE_REPLICATION_SERVER2_PROMPT.get(), true, LOG);
                    }
                    catch (CLIException ce) {
                        this.println(ce.getMessageObject());
                        cancelled = true;
                    }
                }
                if (!cancelled && !replicationServer2Configured && configureReplicationServer2) {
                    boolean tryWithDefault;
                    boolean bl6 = tryWithDefault = this.argParser.getReplicationPort2() != -1;
                    while (replicationPort2 == -1) {
                        if (tryWithDefault) {
                            replicationPort2 = this.argParser.getReplicationPort2();
                            tryWithDefault = false;
                        } else {
                            replicationPort2 = this.askPort(AdminToolMessages.INFO_REPLICATION_ENABLE_REPLICATIONPORT2_PROMPT.get(), this.argParser.getDefaultReplicationPort2(), LOG);
                            this.println();
                        }
                        if (!this.argParser.skipReplicationPortCheck() && Utils.isLocalHost(host2)) {
                            if (!SetupUtils.canUseAsPort(replicationPort2)) {
                                this.println();
                                this.println(this.getCannotBindToPortError(replicationPort2));
                                this.println();
                                replicationPort2 = -1;
                            }
                        } else if (replicationPort2 == port2) {
                            this.println();
                            this.println(AdminToolMessages.ERR_REPLICATION_PORT_AND_REPLICATION_PORT_EQUAL.get(host2, String.valueOf(replicationPort2)));
                            replicationPort2 = -1;
                        }
                        if (!host1.equalsIgnoreCase(host2) || replicationPort1 <= 0 || replicationPort1 != replicationPort2) continue;
                        this.println();
                        this.println(AdminToolMessages.ERR_REPLICATION_SAME_REPLICATION_PORT.get(String.valueOf(replicationPort2), host1));
                        this.println();
                        replicationPort2 = -1;
                    }
                    if (!secureReplication2) {
                        try {
                            secureReplication2 = this.askConfirmation(AdminToolMessages.INFO_REPLICATION_ENABLE_SECURE2_PROMPT.get(String.valueOf(replicationPort2)), false, LOG);
                        }
                        catch (CLIException ce) {
                            this.println(ce.getMessageObject());
                            cancelled = true;
                        }
                        this.println();
                    }
                }
            }
            if (!cancelled && configureReplicationDomain2 && configureReplicationServer2 && this.argParser.advancedArg.isPresent()) {
                try {
                    configureReplicationDomain2 = this.askConfirmation(AdminToolMessages.INFO_REPLICATION_ENABLE_REPLICATION_DOMAIN2_PROMPT.get(), true, LOG);
                }
                catch (CLIException ce) {
                    this.println(ce.getMessageObject());
                    cancelled = true;
                }
            }
            cancelled = !this.loadADSAndAcceptCertificates(aux = new InitialLdapContext[]{ctx2}, uData, false);
            ctx2 = aux[0];
            if (!cancelled) {
                administratorDefined |= this.hasAdministrator(ctx2);
            }
        }
        uData.setReplicationPort2(replicationPort2);
        uData.setSecureReplication2(secureReplication2);
        uData.setConfigureReplicationServer2(configureReplicationServer2);
        uData.setConfigureReplicationDomain2(configureReplicationDomain2);
        boolean promptedForAdmin = false;
        if (!cancelled && uData.getAdminUid() == null && !administratorDefined) {
            if (adminUid == null) {
                this.println(AdminToolMessages.INFO_REPLICATION_ENABLE_ADMINISTRATOR_MUST_BE_CREATED.get());
                promptedForAdmin = true;
                adminUid = this.askForAdministratorUID(this.argParser.getDefaultAdministratorUID(), LOG);
                this.println();
            }
            uData.setAdminUid(adminUid);
        }
        if (uData.getAdminPwd() == null) {
            uData.setAdminPwd(adminPwd);
        }
        if (!cancelled && uData.getAdminPwd() == null && !administratorDefined) {
            adminPwd = null;
            int nPasswordPrompts = 0;
            while (adminPwd == null) {
                if (nPasswordPrompts > 5) {
                    this.println(UtilityMessages.ERR_CONFIRMATION_TRIES_LIMIT_REACHED.get(5));
                    cancelled = true;
                    break;
                }
                ++nPasswordPrompts;
                if (!promptedForAdmin) {
                    this.println();
                    this.println(AdminToolMessages.INFO_REPLICATION_ENABLE_ADMINISTRATOR_MUST_BE_CREATED.get());
                    this.println();
                }
                while (adminPwd == null) {
                    adminPwd = this.askForAdministratorPwd(LOG);
                    this.println();
                }
                String adminPwdConfirm = null;
                while (adminPwdConfirm == null) {
                    adminPwdConfirm = this.readPassword(AdminToolMessages.INFO_ADMINISTRATOR_PWD_CONFIRM_PROMPT.get(), LOG);
                    this.println();
                }
                if (adminPwd.equals(adminPwdConfirm)) continue;
                this.println();
                this.println(AdminToolMessages.ERR_ADMINISTRATOR_PWD_DO_NOT_MATCH.get());
                this.println();
                adminPwd = null;
            }
            uData.setAdminPwd(adminPwd);
        }
        if (!cancelled) {
            LinkedList<String> suffixes = this.argParser.getBaseDNs();
            this.checkSuffixesForEnableReplication(suffixes, ctx1, ctx2, true, uData);
            cancelled = suffixes.isEmpty();
            uData.setBaseDNs(suffixes);
        }
        if (ctx1 != null) {
            try {
                ctx1.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (ctx2 != null) {
            try {
                ctx2.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        uData.setReplicateSchema(!this.argParser.noSchemaReplication());
        return !cancelled;
    }

    private boolean promptIfRequired(DisableReplicationUserData uData) throws ReplicationCliException {
        boolean cancelled = false;
        String adminPwd = this.argParser.getBindPasswordAdmin();
        String adminUid = this.argParser.getAdministratorUID();
        String bindDn = this.argParser.getBindDNToDisable();
        String host = this.argParser.getHostNameToDisable();
        int port = this.argParser.getPortToDisable();
        InitialLdapContext ctx = null;
        while (ctx == null && !cancelled) {
            try {
                this.ci.setUseAdminOrBindDn(true);
                this.ci.run();
                host = this.ci.getHostName();
                port = this.ci.getPortNumber();
                bindDn = this.ci.getProvidedBindDN();
                adminUid = this.ci.getProvidedAdminUID();
                adminPwd = this.ci.getBindPassword();
                ctx = this.createInitialLdapContextInteracting(this.ci);
                if (ctx != null) continue;
                cancelled = true;
            }
            catch (ClientException ce) {
                LOG.log(Level.WARNING, "Client exception " + ce);
                this.println();
                this.println(ce.getMessageObject());
                this.println();
                this.ci.resetConnectionArguments();
            }
            catch (ArgumentException ae) {
                LOG.log(Level.WARNING, "Argument exception " + ae);
                this.println();
                this.println(ae.getMessageObject());
                this.println();
                cancelled = true;
            }
        }
        if (!cancelled) {
            uData.setHostName(host);
            uData.setPort(port);
            uData.setAdminUid(adminUid);
            uData.setBindDn(bindDn);
            uData.setAdminPwd(adminPwd);
        }
        if (ctx != null && adminUid != null) {
            InitialLdapContext[] aux = new InitialLdapContext[]{ctx};
            cancelled = !this.loadADSAndAcceptCertificates(aux, uData, false);
            ctx = aux[0];
        }
        boolean disableAll = this.argParser.disableAllArg.isPresent();
        boolean disableReplicationServer = this.argParser.disableReplicationServerArg.isPresent();
        if (disableAll || this.argParser.advancedArg.isPresent() && this.argParser.getBaseDNs().isEmpty() && !disableReplicationServer) {
            try {
                disableAll = this.askConfirmation(AdminToolMessages.INFO_REPLICATION_PROMPT_DISABLE_ALL.get(), disableAll, LOG);
            }
            catch (CLIException ce) {
                this.println(ce.getMessageObject());
                cancelled = true;
            }
        }
        int repPort = this.getReplicationPort(ctx);
        if (!disableAll && (this.argParser.advancedArg.isPresent() || disableReplicationServer) && repPort > 0) {
            try {
                disableReplicationServer = this.askConfirmation(AdminToolMessages.INFO_REPLICATION_PROMPT_DISABLE_REPLICATION_SERVER.get(repPort), disableReplicationServer, LOG);
            }
            catch (CLIException ce) {
                this.println(ce.getMessageObject());
                cancelled = true;
            }
        }
        if (disableReplicationServer && repPort < 0) {
            disableReplicationServer = false;
            try {
                cancelled = this.askConfirmation(AdminToolMessages.INFO_REPLICATION_PROMPT_NO_REPLICATION_SERVER_TO_DISABLE.get(ConnectionUtils.getHostPort(ctx)), false, LOG);
            }
            catch (CLIException ce) {
                this.println(ce.getMessageObject());
                cancelled = true;
            }
        }
        if (repPort > 0 && disableAll) {
            disableReplicationServer = true;
        }
        uData.setDisableAll(disableAll);
        uData.setDisableReplicationServer(disableReplicationServer);
        if (!cancelled && !disableAll) {
            LinkedList<String> suffixes = this.argParser.getBaseDNs();
            this.checkSuffixesForDisableReplication(suffixes, ctx, true, !disableReplicationServer, !disableReplicationServer);
            cancelled = suffixes.isEmpty() && !disableReplicationServer;
            uData.setBaseDNs(suffixes);
            if (!uData.disableReplicationServer() && repPort > 0 && this.disableAllBaseDns(ctx, uData) && !this.argParser.advancedArg.isPresent()) {
                try {
                    uData.setDisableReplicationServer(this.askConfirmation(AdminToolMessages.INFO_REPLICATION_DISABLE_ALL_SUFFIXES_DISABLE_REPLICATION_SERVER.get(ConnectionUtils.getHostPort(ctx), repPort), true, LOG));
                }
                catch (CLIException ce) {
                    this.println(ce.getMessageObject());
                    cancelled = true;
                }
            }
        }
        if (!cancelled) {
            boolean disableADS = false;
            boolean disableSchema = false;
            for (String dn : uData.getBaseDNs()) {
                if (Utils.areDnsEqual(ADSContext.getAdministrationSuffixDN(), dn)) {
                    disableADS = true;
                    continue;
                }
                if (!Utils.areDnsEqual("cn=schema", dn)) continue;
                disableSchema = true;
            }
            if (disableADS) {
                this.println();
                try {
                    cancelled = !this.askConfirmation(AdminToolMessages.INFO_REPLICATION_CONFIRM_DISABLE_ADS.get(ADSContext.getAdministrationSuffixDN()), true, LOG);
                }
                catch (CLIException ce) {
                    this.println(ce.getMessageObject());
                    cancelled = true;
                }
                this.println();
            }
            if (disableSchema) {
                this.println();
                try {
                    cancelled = !this.askConfirmation(AdminToolMessages.INFO_REPLICATION_CONFIRM_DISABLE_SCHEMA.get(), true, LOG);
                }
                catch (CLIException ce) {
                    this.println(ce.getMessageObject());
                    cancelled = true;
                }
                this.println();
            }
            if (!disableSchema && !disableADS) {
                this.println();
                try {
                    if (!uData.disableAll() && !uData.getBaseDNs().isEmpty()) {
                        cancelled = !this.askConfirmation(AdminToolMessages.INFO_REPLICATION_CONFIRM_DISABLE_GENERIC.get(), true, LOG);
                    }
                }
                catch (CLIException ce) {
                    this.println(ce.getMessageObject());
                    cancelled = true;
                }
                this.println();
            }
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return !cancelled;
    }

    private boolean promptIfRequired(InitializeAllReplicationUserData uData) {
        boolean cancelled = false;
        String adminPwd = this.argParser.getBindPasswordAdmin();
        String adminUid = this.argParser.getAdministratorUID();
        String host = this.argParser.getHostNameToInitializeAll();
        int port = this.argParser.getPortToInitializeAll();
        InitialContext ctx = null;
        while (ctx == null && !cancelled) {
            try {
                this.ci.setHeadingMessage(AdminToolMessages.INFO_REPLICATION_INITIALIZE_SOURCE_CONNECTION_PARAMETERS.get());
                this.ci.run();
                host = this.ci.getHostName();
                port = this.ci.getPortNumber();
                adminUid = this.ci.getAdministratorUID();
                adminPwd = this.ci.getBindPassword();
                ctx = this.createInitialLdapContextInteracting(this.ci);
                if (ctx != null) continue;
                cancelled = true;
            }
            catch (ClientException ce) {
                LOG.log(Level.WARNING, "Client exception " + ce);
                this.println();
                this.println(ce.getMessageObject());
                this.println();
                this.ci.resetConnectionArguments();
            }
            catch (ArgumentException ae) {
                LOG.log(Level.WARNING, "Argument exception " + ae);
                this.println();
                this.println(ae.getMessageObject());
                this.println();
                cancelled = true;
            }
        }
        if (!cancelled) {
            uData.setHostName(host);
            uData.setPort(port);
            uData.setAdminUid(adminUid);
            uData.setAdminPwd(adminPwd);
        }
        if (!cancelled) {
            LinkedList<String> suffixes = this.argParser.getBaseDNs();
            this.checkSuffixesForInitializeReplication(suffixes, (InitialLdapContext)ctx, true);
            cancelled = suffixes.isEmpty();
            uData.setBaseDNs(suffixes);
        }
        if (!cancelled) {
            boolean initializeADS = false;
            for (String dn : uData.getBaseDNs()) {
                if (!Utils.areDnsEqual(ADSContext.getAdministrationSuffixDN(), dn)) continue;
                initializeADS = true;
            }
            String hostPortSource = ConnectionUtils.getHostPort((InitialLdapContext)ctx);
            if (initializeADS) {
                this.println();
                try {
                    cancelled = !this.askConfirmation(AdminToolMessages.INFO_REPLICATION_CONFIRM_INITIALIZE_ALL_ADS.get(ADSContext.getAdministrationSuffixDN(), hostPortSource), true, LOG);
                }
                catch (CLIException ce) {
                    this.println(ce.getMessageObject());
                    cancelled = true;
                }
                this.println();
            } else {
                this.println();
                try {
                    cancelled = !this.askConfirmation(AdminToolMessages.INFO_REPLICATION_CONFIRM_INITIALIZE_ALL_GENERIC.get(hostPortSource), true, LOG);
                }
                catch (CLIException ce) {
                    this.println(ce.getMessageObject());
                    cancelled = true;
                }
                this.println();
            }
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return !cancelled;
    }

    private boolean promptIfRequired(PreExternalInitializationUserData uData) {
        boolean cancelled = false;
        String adminPwd = this.argParser.getBindPasswordAdmin();
        String adminUid = this.argParser.getAdministratorUID();
        String host = this.argParser.getHostNameToInitializeAll();
        int port = this.argParser.getPortToInitializeAll();
        InitialContext ctx = null;
        while (ctx == null && !cancelled) {
            try {
                this.ci.run();
                host = this.ci.getHostName();
                port = this.ci.getPortNumber();
                adminUid = this.ci.getAdministratorUID();
                adminPwd = this.ci.getBindPassword();
                ctx = this.createInitialLdapContextInteracting(this.ci);
                if (ctx != null) continue;
                cancelled = true;
            }
            catch (ClientException ce) {
                LOG.log(Level.WARNING, "Client exception " + ce);
                this.println();
                this.println(ce.getMessageObject());
                this.println();
                this.ci.resetConnectionArguments();
            }
            catch (ArgumentException ae) {
                LOG.log(Level.WARNING, "Argument exception " + ae);
                this.println();
                this.println(ae.getMessageObject());
                this.println();
                cancelled = true;
            }
        }
        if (!cancelled) {
            boolean localOnly = false;
            if (!this.argParser.isExternalInitializationLocalOnly()) {
                this.println();
                try {
                    localOnly = this.askConfirmation(AdminToolMessages.INFO_REPLICATION_PRE_EXTERNAL_INITIALIZATION_LOCAL_PROMPT.get(ConnectionUtils.getHostPort((InitialLdapContext)ctx)), false, LOG);
                }
                catch (CLIException ce) {
                    this.println(ce.getMessageObject());
                    cancelled = true;
                }
            } else {
                localOnly = true;
            }
            uData.setLocalOnly(localOnly);
            uData.setHostName(host);
            uData.setPort(port);
            uData.setAdminUid(adminUid);
            uData.setAdminPwd(adminPwd);
        }
        if (!cancelled) {
            LinkedList<String> suffixes = this.argParser.getBaseDNs();
            this.checkSuffixesForInitializeReplication(suffixes, (InitialLdapContext)ctx, true);
            cancelled = suffixes.isEmpty();
            uData.setBaseDNs(suffixes);
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return !cancelled;
    }

    private boolean promptIfRequired(PostExternalInitializationUserData uData) {
        boolean cancelled = false;
        String adminPwd = this.argParser.getBindPasswordAdmin();
        String adminUid = this.argParser.getAdministratorUID();
        String host = this.argParser.getHostNameToInitializeAll();
        int port = this.argParser.getPortToInitializeAll();
        InitialContext ctx = null;
        while (ctx == null && !cancelled) {
            try {
                this.ci.run();
                host = this.ci.getHostName();
                port = this.ci.getPortNumber();
                adminUid = this.ci.getAdministratorUID();
                adminPwd = this.ci.getBindPassword();
                ctx = this.createInitialLdapContextInteracting(this.ci);
                if (ctx != null) continue;
                cancelled = true;
            }
            catch (ClientException ce) {
                LOG.log(Level.WARNING, "Client exception " + ce);
                this.println();
                this.println(ce.getMessageObject());
                this.println();
                this.ci.resetConnectionArguments();
            }
            catch (ArgumentException ae) {
                LOG.log(Level.WARNING, "Argument exception " + ae);
                this.println();
                this.println(ae.getMessageObject());
                this.println();
                cancelled = true;
            }
        }
        if (!cancelled) {
            uData.setHostName(host);
            uData.setPort(port);
            uData.setAdminUid(adminUid);
            uData.setAdminPwd(adminPwd);
        }
        if (!cancelled) {
            LinkedList<String> suffixes = this.argParser.getBaseDNs();
            this.checkSuffixesForInitializeReplication(suffixes, (InitialLdapContext)ctx, true);
            cancelled = suffixes.isEmpty();
            uData.setBaseDNs(suffixes);
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return !cancelled;
    }

    private boolean promptIfRequired(StatusReplicationUserData uData) throws ReplicationCliException {
        boolean cancelled = false;
        String adminPwd = this.argParser.getBindPasswordAdmin();
        String adminUid = this.argParser.getAdministratorUID();
        String host = this.argParser.getHostNameToStatus();
        int port = this.argParser.getPortToStatus();
        InitialContext ctx = null;
        while (ctx == null && !cancelled) {
            try {
                this.ci.run();
                host = this.ci.getHostName();
                port = this.ci.getPortNumber();
                adminUid = this.ci.getAdministratorUID();
                adminPwd = this.ci.getBindPassword();
                ctx = this.createInitialLdapContextInteracting(this.ci);
                if (ctx != null) continue;
                cancelled = true;
            }
            catch (ClientException ce) {
                LOG.log(Level.WARNING, "Client exception " + ce);
                this.println();
                this.println(ce.getMessageObject());
                this.println();
                this.ci.resetConnectionArguments();
            }
            catch (ArgumentException ae) {
                LOG.log(Level.WARNING, "Argument exception " + ae);
                this.println();
                this.println(ae.getMessageObject());
                this.println();
                cancelled = true;
            }
        }
        if (!cancelled) {
            uData.setHostName(host);
            uData.setPort(port);
            uData.setAdminUid(adminUid);
            uData.setAdminPwd(adminPwd);
            uData.setScriptFriendly(this.argParser.isScriptFriendly());
        }
        if (ctx != null) {
            InitialLdapContext[] aux = new InitialLdapContext[]{ctx};
            cancelled = !this.loadADSAndAcceptCertificates(aux, uData, false);
            ctx = aux[0];
        }
        if (!cancelled) {
            LinkedList<String> suffixes = this.argParser.getBaseDNs();
            uData.setBaseDNs(suffixes);
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return !cancelled;
    }

    private boolean promptIfRequired(InitializeReplicationUserData uData) {
        boolean cancelled = false;
        String adminPwd = this.argParser.getBindPasswordAdmin();
        String adminUid = this.argParser.getAdministratorUID();
        String hostSource = this.argParser.getHostNameSource();
        int portSource = this.argParser.getPortSource();
        LinkedHashMap<String, String> pwdFile = null;
        if (this.argParser.getSecureArgsList().bindPasswordFileArg.isPresent()) {
            pwdFile = this.argParser.getSecureArgsList().bindPasswordFileArg.getNameToValueMap();
        }
        this.ci.initializeGlobalArguments(hostSource, portSource, adminUid, null, adminPwd, pwdFile == null ? null : new LinkedHashMap<String, String>(pwdFile));
        InitialLdapContext ctxSource = null;
        while (ctxSource == null && !cancelled) {
            try {
                this.ci.setHeadingMessage(AdminToolMessages.INFO_REPLICATION_INITIALIZE_SOURCE_CONNECTION_PARAMETERS.get());
                this.ci.run();
                hostSource = this.ci.getHostName();
                portSource = this.ci.getPortNumber();
                adminUid = this.ci.getAdministratorUID();
                adminPwd = this.ci.getBindPassword();
                ctxSource = this.createInitialLdapContextInteracting(this.ci);
                if (ctxSource != null) continue;
                cancelled = true;
            }
            catch (ClientException ce) {
                LOG.log(Level.WARNING, "Client exception " + ce);
                this.println();
                this.println(ce.getMessageObject());
                this.println();
                this.ci.resetConnectionArguments();
            }
            catch (ArgumentException ae) {
                LOG.log(Level.WARNING, "Argument exception " + ae);
                this.println();
                this.println(ae.getMessageObject());
                this.println();
                cancelled = true;
            }
        }
        if (!cancelled) {
            uData.setHostNameSource(hostSource);
            uData.setPortSource(portSource);
            uData.setAdminUid(adminUid);
            uData.setAdminPwd(adminPwd);
        }
        this.firstServerCommandBuilder = new CommandBuilder(null);
        if (this.mustPrintCommandBuilder()) {
            this.firstServerCommandBuilder.append(this.ci.getCommandBuilder());
        }
        String hostDestination = this.argParser.getHostNameDestination();
        int portDestination = this.argParser.getPortDestination();
        this.ci.initializeGlobalArguments(hostDestination, portDestination, adminUid, null, adminPwd, pwdFile == null ? null : new LinkedHashMap<String, String>(pwdFile));
        InitialContext ctxDestination = null;
        this.ci.resetHeadingDisplayed();
        while (ctxDestination == null && !cancelled) {
            try {
                this.ci.setHeadingMessage(AdminToolMessages.INFO_REPLICATION_INITIALIZE_DESTINATION_CONNECTION_PARAMETERS.get());
                this.ci.run();
                hostDestination = this.ci.getHostName();
                portDestination = this.ci.getPortNumber();
                boolean error = false;
                if (hostSource.equalsIgnoreCase(hostDestination) && portSource == portDestination) {
                    portDestination = -1;
                    Message message = AdminToolMessages.ERR_REPLICATION_INITIALIZE_SAME_SERVER_PORT.get(hostSource, String.valueOf(portSource));
                    this.println();
                    this.println(message);
                    this.println();
                    error = true;
                }
                if (error || (ctxDestination = this.createInitialLdapContextInteracting(this.ci, true)) != null) continue;
                cancelled = true;
            }
            catch (ClientException ce) {
                LOG.log(Level.WARNING, "Client exception " + ce);
                this.println();
                this.println(ce.getMessageObject());
                this.println();
                this.ci.resetConnectionArguments();
            }
            catch (ArgumentException ae) {
                LOG.log(Level.WARNING, "Argument exception " + ae);
                this.println();
                this.println(ae.getMessageObject());
                this.println();
                cancelled = true;
            }
        }
        if (!cancelled) {
            uData.setHostNameDestination(hostDestination);
            uData.setPortDestination(portDestination);
        }
        if (!cancelled) {
            LinkedList<String> suffixes = this.argParser.getBaseDNs();
            this.checkSuffixesForInitializeReplication(suffixes, ctxSource, (InitialLdapContext)ctxDestination, true);
            cancelled = suffixes.isEmpty();
            uData.setBaseDNs(suffixes);
        }
        if (!cancelled) {
            boolean initializeADS = false;
            for (String dn : uData.getBaseDNs()) {
                if (!Utils.areDnsEqual(ADSContext.getAdministrationSuffixDN(), dn)) continue;
                initializeADS = true;
                break;
            }
            String hostPortSource = ConnectionUtils.getHostPort(ctxSource);
            String hostPortDestination = ConnectionUtils.getHostPort((InitialLdapContext)ctxDestination);
            if (initializeADS) {
                this.println();
                try {
                    cancelled = !this.askConfirmation(AdminToolMessages.INFO_REPLICATION_CONFIRM_INITIALIZE_ADS.get(ADSContext.getAdministrationSuffixDN(), hostPortDestination, hostPortSource), true, LOG);
                }
                catch (CLIException ce) {
                    this.println(ce.getMessageObject());
                    cancelled = true;
                }
                this.println();
            } else {
                this.println();
                try {
                    cancelled = !this.askConfirmation(AdminToolMessages.INFO_REPLICATION_CONFIRM_INITIALIZE_GENERIC.get(hostPortDestination, hostPortSource), true, LOG);
                }
                catch (CLIException ce) {
                    this.println(ce.getMessageObject());
                    cancelled = true;
                }
                this.println();
            }
        }
        if (ctxSource != null) {
            try {
                ctxSource.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (ctxDestination != null) {
            try {
                ctxDestination.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return !cancelled;
    }

    private String getValue(String v, String defaultValue) {
        if (v != null) {
            return v;
        }
        return defaultValue;
    }

    private int getValue(int v, int defaultValue) {
        if (v != -1) {
            return v;
        }
        return defaultValue;
    }

    private ApplicationTrustManager getTrustManager() {
        ApplicationTrustManager t;
        Object trust = this.isInteractive() ? ((t = this.ci.getTrustManager()) == null ? null : (t instanceof ApplicationTrustManager ? t : new ApplicationTrustManager(this.ci.getKeyStore()))) : this.argParser.getTrustManager();
        return trust;
    }

    private void initializeWithArgParser(EnableReplicationUserData uData) {
        uData.setBaseDNs(new LinkedList<String>(this.argParser.getBaseDNs()));
        String adminUid = this.getValue(this.argParser.getAdministratorUID(), this.argParser.getDefaultAdministratorUID());
        uData.setAdminUid(adminUid);
        String adminPwd = this.argParser.getBindPasswordAdmin();
        uData.setAdminPwd(adminPwd);
        String host1Name = this.getValue(this.argParser.getHostName1(), this.argParser.getDefaultHostName1());
        uData.setHostName1(host1Name);
        int port1 = this.getValue(this.argParser.getPort1(), this.argParser.getDefaultPort1());
        uData.setPort1(port1);
        String pwd1 = this.argParser.getBindPassword1();
        if (pwd1 == null) {
            uData.setBindDn1(ADSContext.getAdministratorDN(adminUid));
            uData.setPwd1(adminPwd);
        } else {
            try {
                InitialLdapContext ctx = this.createAdministrativeContext(uData.getHostName1(), uData.getPort1(), this.useSSL, this.useStartTLS, ADSContext.getAdministratorDN(adminUid), adminPwd, this.getTrustManager());
                uData.setBindDn1(ADSContext.getAdministratorDN(adminUid));
                uData.setPwd1(adminPwd);
                ctx.close();
            }
            catch (Throwable t) {
                String bindDn = this.getValue(this.argParser.getBindDn1(), this.argParser.getDefaultBindDn1());
                uData.setBindDn1(bindDn);
                uData.setPwd1(pwd1);
            }
        }
        uData.setSecureReplication1(this.argParser.isSecureReplication1());
        String host2Name = this.getValue(this.argParser.getHostName2(), this.argParser.getDefaultHostName2());
        uData.setHostName2(host2Name);
        int port2 = this.getValue(this.argParser.getPort2(), this.argParser.getDefaultPort2());
        uData.setPort2(port2);
        String pwd2 = this.argParser.getBindPassword2();
        if (pwd2 == null) {
            uData.setBindDn2(ADSContext.getAdministratorDN(adminUid));
            uData.setPwd2(adminPwd);
        } else {
            try {
                InitialLdapContext ctx = this.createAdministrativeContext(uData.getHostName2(), uData.getPort2(), this.useSSL, this.useStartTLS, ADSContext.getAdministratorDN(adminUid), adminPwd, this.getTrustManager());
                uData.setBindDn2(ADSContext.getAdministratorDN(adminUid));
                uData.setPwd2(adminPwd);
                ctx.close();
            }
            catch (Throwable t) {
                String bindDn = this.getValue(this.argParser.getBindDn2(), this.argParser.getDefaultBindDn2());
                uData.setBindDn2(bindDn);
                uData.setPwd2(pwd2);
            }
        }
        uData.setSecureReplication2(this.argParser.isSecureReplication2());
        uData.setReplicateSchema(!this.argParser.noSchemaReplication());
        uData.setConfigureReplicationDomain1(!this.argParser.onlyReplicationServer1Arg.isPresent());
        uData.setConfigureReplicationDomain2(!this.argParser.onlyReplicationServer2Arg.isPresent());
        uData.setConfigureReplicationServer1(!this.argParser.noReplicationServer1Arg.isPresent());
        uData.setConfigureReplicationServer2(!this.argParser.noReplicationServer2Arg.isPresent());
        int replicationPort1 = this.getValue(this.argParser.getReplicationPort1(), this.argParser.getDefaultReplicationPort1());
        if (uData.configureReplicationServer1()) {
            uData.setReplicationPort1(replicationPort1);
        }
        int replicationPort2 = this.getValue(this.argParser.getReplicationPort2(), this.argParser.getDefaultReplicationPort2());
        if (uData.configureReplicationServer2()) {
            uData.setReplicationPort2(replicationPort2);
        }
    }

    private void initializeWithArgParser(InitializeReplicationUserData uData) {
        uData.setBaseDNs(new LinkedList<String>(this.argParser.getBaseDNs()));
        String adminUid = this.getValue(this.argParser.getAdministratorUID(), this.argParser.getDefaultAdministratorUID());
        uData.setAdminUid(adminUid);
        String adminPwd = this.argParser.getBindPasswordAdmin();
        uData.setAdminPwd(adminPwd);
        String hostNameSource = this.getValue(this.argParser.getHostNameSource(), this.argParser.getDefaultHostNameSource());
        uData.setHostNameSource(hostNameSource);
        int portSource = this.getValue(this.argParser.getPortSource(), this.argParser.getDefaultPortSource());
        uData.setPortSource(portSource);
        String hostNameDestination = this.getValue(this.argParser.getHostNameDestination(), this.argParser.getDefaultHostNameDestination());
        uData.setHostNameDestination(hostNameDestination);
        int portDestination = this.getValue(this.argParser.getPortDestination(), this.argParser.getDefaultPortDestination());
        uData.setPortDestination(portDestination);
    }

    private void initializeWithArgParser(DisableReplicationUserData uData) {
        uData.setBaseDNs(new LinkedList<String>(this.argParser.getBaseDNs()));
        String adminUid = this.argParser.getAdministratorUID();
        String bindDn = this.argParser.getBindDNToDisable();
        if (bindDn == null && adminUid == null) {
            adminUid = this.argParser.getDefaultAdministratorUID();
            bindDn = ADSContext.getAdministratorDN(adminUid);
        }
        uData.setAdminUid(adminUid);
        uData.setBindDn(bindDn);
        String adminPwd = this.argParser.getBindPasswordAdmin();
        uData.setAdminPwd(adminPwd);
        String hostName = this.getValue(this.argParser.getHostNameToDisable(), this.argParser.getDefaultHostNameToDisable());
        uData.setHostName(hostName);
        int port = this.getValue(this.argParser.getPortToDisable(), this.argParser.getDefaultPortToDisable());
        uData.setPort(port);
        uData.setDisableAll(this.argParser.disableAllArg.isPresent());
        uData.setDisableReplicationServer(this.argParser.disableReplicationServerArg.isPresent());
    }

    private void initializeWithArgParser(InitializeAllReplicationUserData uData) {
        uData.setBaseDNs(new LinkedList<String>(this.argParser.getBaseDNs()));
        String adminUid = this.getValue(this.argParser.getAdministratorUID(), this.argParser.getDefaultAdministratorUID());
        uData.setAdminUid(adminUid);
        String adminPwd = this.argParser.getBindPasswordAdmin();
        uData.setAdminPwd(adminPwd);
        String hostName = this.getValue(this.argParser.getHostNameToInitializeAll(), this.argParser.getDefaultHostNameToInitializeAll());
        uData.setHostName(hostName);
        int port = this.getValue(this.argParser.getPortToInitializeAll(), this.argParser.getDefaultPortToInitializeAll());
        uData.setPort(port);
    }

    private void initializeWithArgParser(PreExternalInitializationUserData uData) {
        uData.setBaseDNs(new LinkedList<String>(this.argParser.getBaseDNs()));
        String adminUid = this.getValue(this.argParser.getAdministratorUID(), this.argParser.getDefaultAdministratorUID());
        uData.setAdminUid(adminUid);
        String adminPwd = this.argParser.getBindPasswordAdmin();
        uData.setAdminPwd(adminPwd);
        String hostName = this.getValue(this.argParser.getHostNameToInitializeAll(), this.argParser.getDefaultHostNameToInitializeAll());
        uData.setHostName(hostName);
        int port = this.getValue(this.argParser.getPortToInitializeAll(), this.argParser.getDefaultPortToInitializeAll());
        uData.setPort(port);
        uData.setLocalOnly(this.argParser.isExternalInitializationLocalOnly());
    }

    private void initializeWithArgParser(PostExternalInitializationUserData uData) {
        uData.setBaseDNs(new LinkedList<String>(this.argParser.getBaseDNs()));
        String adminUid = this.getValue(this.argParser.getAdministratorUID(), this.argParser.getDefaultAdministratorUID());
        uData.setAdminUid(adminUid);
        String adminPwd = this.argParser.getBindPasswordAdmin();
        uData.setAdminPwd(adminPwd);
        String hostName = this.getValue(this.argParser.getHostNameToInitializeAll(), this.argParser.getDefaultHostNameToInitializeAll());
        uData.setHostName(hostName);
        int port = this.getValue(this.argParser.getPortToInitializeAll(), this.argParser.getDefaultPortToInitializeAll());
        uData.setPort(port);
    }

    private void initializeWithArgParser(StatusReplicationUserData uData) {
        uData.setBaseDNs(new LinkedList<String>(this.argParser.getBaseDNs()));
        String adminUid = this.getValue(this.argParser.getAdministratorUID(), this.argParser.getDefaultAdministratorUID());
        uData.setAdminUid(adminUid);
        String adminPwd = this.argParser.getBindPasswordAdmin();
        uData.setAdminPwd(adminPwd);
        String hostName = this.getValue(this.argParser.getHostNameToStatus(), this.argParser.getDefaultHostNameToStatus());
        uData.setHostName(hostName);
        int port = this.getValue(this.argParser.getPortToStatus(), this.argParser.getDefaultPortToStatus());
        uData.setPort(port);
        uData.setScriptFriendly(this.argParser.isScriptFriendly());
    }

    private boolean hasReplicationPort(InitialLdapContext ctx) {
        return this.getReplicationPort(ctx) != -1;
    }

    private int getReplicationPort(InitialLdapContext ctx) {
        int replicationPort = -1;
        try {
            ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
            RootCfgClient root = mCtx.getRootConfiguration();
            ReplicationSynchronizationProviderCfgClient sync = null;
            sync = (ReplicationSynchronizationProviderCfgClient)root.getSynchronizationProvider("Multimaster Synchronization");
            if (sync.hasReplicationServer()) {
                ReplicationServerCfgClient replicationServer = sync.getReplicationServer();
                replicationPort = replicationServer.getReplicationPort();
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Unexpected error retrieving the replication port: " + t, t);
        }
        return replicationPort;
    }

    private boolean loadADSAndAcceptCertificates(InitialLdapContext[] ctx, ReplicationUserData uData, boolean isFirstOrSourceServer) throws ReplicationCliException {
        boolean cancelled;
        block28: {
            cancelled = false;
            boolean triedWithUserProvidedAdmin = false;
            String host = ConnectionUtils.getHostName(ctx[0]);
            int port = ConnectionUtils.getPort(ctx[0]);
            boolean isSSL = ConnectionUtils.isSSL(ctx[0]);
            boolean isStartTLS = ConnectionUtils.isStartTLS(ctx[0]);
            if (this.getTrustManager() == null) {
                this.forceTrustManagerInitialization();
            }
            try {
                ADSContext adsContext = new ADSContext(ctx[0]);
                if (!adsContext.hasAdminData()) break block28;
                boolean reloadTopology = true;
                LinkedList<Message> exceptionMsgs = new LinkedList<Message>();
                block13: while (reloadTopology && !cancelled) {
                    TopologyCache cache = new TopologyCache(adsContext, this.getTrustManager());
                    cache.getFilter().setSearchMonitoringInformation(false);
                    cache.getFilter().setSearchBaseDNInformation(false);
                    cache.setPreferredConnections(PreferredConnection.getPreferredConnections(ctx[0]));
                    cache.reloadTopology();
                    reloadTopology = false;
                    exceptionMsgs.clear();
                    HashSet<TopologyCacheException> exceptions = new HashSet<TopologyCacheException>();
                    Set<ServerDescriptor> servers = cache.getServers();
                    for (ServerDescriptor server : servers) {
                        TopologyCacheException e = server.getLastException();
                        if (e == null) continue;
                        exceptions.add(e);
                    }
                    boolean notGlobalAdministratorError = false;
                    block15: for (TopologyCacheException e : exceptions) {
                        if (notGlobalAdministratorError) continue block13;
                        switch (e.getType()) {
                            case NOT_GLOBAL_ADMINISTRATOR: {
                                notGlobalAdministratorError = true;
                                boolean connected = false;
                                String adminUid = uData.getAdminUid();
                                String adminPwd = uData.getAdminPwd();
                                boolean errorDisplayed = false;
                                while (!connected) {
                                    if (!triedWithUserProvidedAdmin && adminPwd == null) {
                                        adminUid = this.getValue(this.argParser.getAdministratorUID(), this.argParser.getDefaultAdministratorUID());
                                        adminPwd = this.argParser.getBindPasswordAdmin();
                                        triedWithUserProvidedAdmin = true;
                                    }
                                    if (adminPwd == null) {
                                        if (!errorDisplayed) {
                                            this.println();
                                            this.println(QuickSetupMessages.INFO_NOT_GLOBAL_ADMINISTRATOR_PROVIDED.get());
                                            errorDisplayed = true;
                                        }
                                        adminUid = this.askForAdministratorUID(this.argParser.getDefaultAdministratorUID(), LOG);
                                        this.println();
                                        adminPwd = this.askForAdministratorPwd(LOG);
                                        this.println();
                                    }
                                    try {
                                        ctx[0].close();
                                    }
                                    catch (Throwable t) {
                                        // empty catch block
                                    }
                                    try {
                                        ctx[0] = this.createAdministrativeContext(host, port, isSSL, isStartTLS, ADSContext.getAdministratorDN(adminUid), adminPwd, this.getTrustManager());
                                        adsContext = new ADSContext(ctx[0]);
                                        cache = new TopologyCache(adsContext, this.getTrustManager());
                                        cache.getFilter().setSearchMonitoringInformation(false);
                                        cache.getFilter().setSearchBaseDNInformation(false);
                                        cache.setPreferredConnections(PreferredConnection.getPreferredConnections(ctx[0]));
                                        connected = true;
                                    }
                                    catch (Throwable t) {
                                        this.println();
                                        this.println(AdminToolMessages.ERR_ERROR_CONNECTING_TO_SERVER_PROMPT_AGAIN.get(ServerDescriptor.getServerRepresentation(host, port), t.getMessage()));
                                        LOG.log(Level.WARNING, "Complete error stack:", t);
                                        this.println();
                                    }
                                }
                                uData.setAdminUid(adminUid);
                                uData.setAdminPwd(adminPwd);
                                if (uData instanceof EnableReplicationUserData) {
                                    EnableReplicationUserData enableData = (EnableReplicationUserData)uData;
                                    if (isFirstOrSourceServer) {
                                        enableData.setBindDn1(ADSContext.getAdministratorDN(adminUid));
                                        enableData.setPwd1(adminPwd);
                                    } else {
                                        enableData.setBindDn2(ADSContext.getAdministratorDN(adminUid));
                                        enableData.setPwd2(adminPwd);
                                    }
                                }
                                reloadTopology = true;
                                continue block15;
                            }
                            case GENERIC_CREATING_CONNECTION: {
                                if (e.getCause() != null && Utils.isCertificateException(e.getCause())) {
                                    reloadTopology = true;
                                    cancelled = !this.ci.promptForCertificateConfirmation(e.getCause(), e.getTrustManager(), e.getLdapUrl(), true, LOG);
                                    continue block15;
                                }
                                exceptionMsgs.add(Utils.getMessage(e));
                                continue block15;
                            }
                        }
                        exceptionMsgs.add(Utils.getMessage(e));
                    }
                }
                if (exceptionMsgs.size() > 0 && !cancelled) {
                    if (uData instanceof StatusReplicationUserData) {
                        this.println(AdminToolMessages.ERR_REPLICATION_STATUS_READING_REGISTERED_SERVERS.get(Utils.getMessageFromCollection(exceptionMsgs, Constants.LINE_SEPARATOR).toString()));
                        this.println();
                    } else {
                        try {
                            cancelled = !this.askConfirmation(AdminToolMessages.ERR_REPLICATION_READING_REGISTERED_SERVERS_CONFIRM_UPDATE_REMOTE.get(Utils.getMessageFromCollection(exceptionMsgs, Constants.LINE_SEPARATOR).toString()), true, LOG);
                        }
                        catch (CLIException ce) {
                            this.println(ce.getMessageObject());
                            cancelled = true;
                        }
                    }
                }
            }
            catch (ADSContextException ace) {
                LOG.log(Level.SEVERE, "Complete error stack:", ace);
                throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_READING_ADS.get(ace.getMessage()), ReplicationCliReturnCode.ERROR_READING_ADS, ace);
            }
            catch (TopologyCacheException tce) {
                LOG.log(Level.SEVERE, "Complete error stack:", tce);
                throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_READING_ADS.get(tce.getMessage()), ReplicationCliReturnCode.ERROR_READING_TOPOLOGY_CACHE, tce);
            }
        }
        return !cancelled;
    }

    private boolean hasAdministrator(InitialLdapContext ctx) {
        boolean isAdminDefined = false;
        try {
            ADSContext adsContext = new ADSContext(ctx);
            if (adsContext.hasAdminData()) {
                Set<Map<ADSContext.AdministratorProperty, Object>> administrators = adsContext.readAdministratorRegistry();
                isAdminDefined = administrators.size() > 0;
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Unexpected error retrieving the ADS data: " + t, t);
        }
        return isAdminDefined;
    }

    private boolean hasAdministrator(InitialLdapContext ctx, ReplicationUserData uData) {
        boolean isAdminDefined = false;
        String adminUid = uData.getAdminUid();
        try {
            Map<ADSContext.AdministratorProperty, Object> admin;
            String uid;
            ADSContext adsContext = new ADSContext(ctx);
            Set<Map<ADSContext.AdministratorProperty, Object>> administrators = adsContext.readAdministratorRegistry();
            Iterator<Map<ADSContext.AdministratorProperty, Object>> i$ = administrators.iterator();
            while (i$.hasNext() && ((uid = (String)(admin = i$.next()).get((Object)ADSContext.AdministratorProperty.UID)) == null || !(isAdminDefined = uid.equalsIgnoreCase(adminUid) || adminUid == null))) {
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Unexpected error retrieving the ADS data: " + t, t);
        }
        return isAdminDefined;
    }

    private Collection<String> getCommonSuffixes(InitialLdapContext ctx1, InitialLdapContext ctx2, SuffixRelationType type) {
        LinkedList<String> suffixes = new LinkedList<String>();
        try {
            TopologyCacheFilter filter = new TopologyCacheFilter();
            filter.setSearchMonitoringInformation(false);
            ServerDescriptor server1 = ServerDescriptor.createStandalone(ctx1, filter);
            ServerDescriptor server2 = ServerDescriptor.createStandalone(ctx2, filter);
            Set<ReplicaDescriptor> replicas1 = server1.getReplicas();
            Set<ReplicaDescriptor> replicas2 = server2.getReplicas();
            for (ReplicaDescriptor rep1 : replicas1) {
                block10: for (ReplicaDescriptor rep2 : replicas2) {
                    switch (type) {
                        case NOT_REPLICATED: {
                            if (this.areReplicated(rep1, rep2) || !Utils.areDnsEqual(rep1.getSuffix().getDN(), rep2.getSuffix().getDN())) continue block10;
                            suffixes.add(rep1.getSuffix().getDN());
                            continue block10;
                        }
                        case FULLY_REPLICATED: {
                            if (!this.areFullyReplicated(rep1, rep2)) continue block10;
                            suffixes.add(rep1.getSuffix().getDN());
                            continue block10;
                        }
                        case REPLICATED: {
                            if (!this.areReplicated(rep1, rep2)) continue block10;
                            suffixes.add(rep1.getSuffix().getDN());
                            continue block10;
                        }
                        case NOT_FULLY_REPLICATED: {
                            if (this.areFullyReplicated(rep1, rep2) || !Utils.areDnsEqual(rep1.getSuffix().getDN(), rep2.getSuffix().getDN())) continue block10;
                            suffixes.add(rep1.getSuffix().getDN());
                            continue block10;
                        }
                        case ALL: {
                            if (!Utils.areDnsEqual(rep1.getSuffix().getDN(), rep2.getSuffix().getDN())) continue block10;
                            suffixes.add(rep1.getSuffix().getDN());
                            continue block10;
                        }
                    }
                    throw new IllegalStateException("Unknown type: " + (Object)((Object)type));
                }
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Unexpected error retrieving the server configuration: " + t, t);
        }
        return suffixes;
    }

    private boolean areFullyReplicated(ReplicaDescriptor rep1, ReplicaDescriptor rep2) {
        boolean areFullyReplicated = false;
        if (Utils.areDnsEqual(rep1.getSuffix().getDN(), rep2.getSuffix().getDN()) && rep1.isReplicated() && rep2.isReplicated() && rep1.getServer().isReplicationServer() && rep2.getServer().isReplicationServer()) {
            Set<String> servers1 = rep1.getReplicationServers();
            Set<String> servers2 = rep2.getReplicationServers();
            String server1 = rep1.getServer().getReplicationServerHostPort();
            String server2 = rep2.getServer().getReplicationServerHostPort();
            areFullyReplicated = servers1.contains(server2) && servers2.contains(server1);
        }
        return areFullyReplicated;
    }

    private boolean areReplicated(ReplicaDescriptor rep1, ReplicaDescriptor rep2) {
        boolean areReplicated = false;
        if (Utils.areDnsEqual(rep1.getSuffix().getDN(), rep2.getSuffix().getDN()) && rep1.isReplicated() && rep2.isReplicated()) {
            Set<String> servers1 = rep1.getReplicationServers();
            Set<String> servers2 = rep2.getReplicationServers();
            servers1.retainAll(servers2);
            areReplicated = !servers1.isEmpty();
        }
        return areReplicated;
    }

    private Collection<ReplicaDescriptor> getReplicas(InitialLdapContext ctx) {
        LinkedList<ReplicaDescriptor> suffixes = new LinkedList<ReplicaDescriptor>();
        TopologyCacheFilter filter = new TopologyCacheFilter();
        filter.setSearchMonitoringInformation(false);
        try {
            ServerDescriptor server = ServerDescriptor.createStandalone(ctx, filter);
            suffixes.addAll(server.getReplicas());
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Unexpected error retrieving the server configuration: " + t, t);
        }
        return suffixes;
    }

    private ReplicationCliReturnCode enableReplication(EnableReplicationUserData uData) {
        String hostPort;
        ReplicationCliReturnCode returnValue = ReplicationCliReturnCode.SUCCESSFUL_NOP;
        InitialLdapContext ctx1 = null;
        InitialLdapContext ctx2 = null;
        String host1 = uData.getHostName1();
        String host2 = uData.getHostName2();
        int port1 = uData.getPort1();
        int port2 = uData.getPort2();
        LinkedList<Message> errorMessages = new LinkedList<Message>();
        this.printlnProgress();
        this.printProgress(this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_REPLICATION_CONNECTING.get()));
        try {
            ctx1 = this.createAdministrativeContext(host1, port1, this.useSSL, this.useStartTLS, uData.getBindDn1(), uData.getPwd1(), this.getTrustManager());
        }
        catch (NamingException ne) {
            hostPort = ServerDescriptor.getServerRepresentation(host1, port1);
            errorMessages.add(this.getMessageForException(ne, hostPort));
            LOG.log(Level.SEVERE, "Complete error stack:", ne);
        }
        try {
            ctx2 = this.createAdministrativeContext(host2, port2, this.useSSL, this.useStartTLS, uData.getBindDn2(), uData.getPwd2(), this.getTrustManager());
        }
        catch (NamingException ne) {
            hostPort = ServerDescriptor.getServerRepresentation(host2, port2);
            errorMessages.add(this.getMessageForException(ne, hostPort));
            LOG.log(Level.SEVERE, "Complete error stack:", ne);
        }
        if (errorMessages.size() > 0) {
            returnValue = ReplicationCliReturnCode.ERROR_CONNECTING;
        }
        if (errorMessages.isEmpty()) {
            this.printProgress(this.formatter.getFormattedDone());
            this.printlnProgress();
            if (!this.argParser.isInteractive()) {
                boolean checkReplicationPort2;
                int replPort2;
                boolean hasReplicationPort2;
                boolean hasReplicationPort1;
                int replPort1 = this.getReplicationPort(ctx1);
                boolean bl = hasReplicationPort1 = replPort1 > 0;
                if (replPort1 < 0 && uData.configureReplicationServer1()) {
                    replPort1 = uData.getReplicationPort1();
                }
                boolean bl2 = hasReplicationPort2 = (replPort2 = this.getReplicationPort(ctx2)) > 0;
                if (replPort2 < 0 && uData.configureReplicationServer2()) {
                    replPort2 = uData.getReplicationPort2();
                }
                boolean checkReplicationPort1 = replPort1 > 0;
                boolean bl3 = checkReplicationPort2 = replPort2 > 0;
                if (!hasReplicationPort1 && checkReplicationPort1 && !this.argParser.skipReplicationPortCheck() && uData.configureReplicationServer1() && Utils.isLocalHost(host1) && !SetupUtils.canUseAsPort(replPort1)) {
                    errorMessages.add(this.getCannotBindToPortError(replPort1));
                }
                if (!hasReplicationPort2 && checkReplicationPort2 && !this.argParser.skipReplicationPortCheck() && uData.configureReplicationServer2() && Utils.isLocalHost(host2) && !SetupUtils.canUseAsPort(replPort2)) {
                    errorMessages.add(this.getCannotBindToPortError(replPort2));
                }
                if (checkReplicationPort1 && checkReplicationPort2 && replPort1 == replPort2 && host1.equalsIgnoreCase(host2)) {
                    errorMessages.add(AdminToolMessages.ERR_REPLICATION_SAME_REPLICATION_PORT.get(String.valueOf(replPort1), host1));
                }
                if (this.argParser.skipReplicationPortCheck()) {
                    if (checkReplicationPort1 && replPort1 == port1) {
                        errorMessages.add(AdminToolMessages.ERR_REPLICATION_PORT_AND_REPLICATION_PORT_EQUAL.get(host1, String.valueOf(replPort1)));
                    }
                    if (checkReplicationPort2 && replPort2 == port2) {
                        errorMessages.add(AdminToolMessages.ERR_REPLICATION_PORT_AND_REPLICATION_PORT_EQUAL.get(host2, String.valueOf(replPort2)));
                    }
                }
            }
            if (errorMessages.size() > 0) {
                returnValue = ReplicationCliReturnCode.ERROR_USER_DATA;
            }
        }
        if (errorMessages.isEmpty()) {
            LinkedList<String> suffixes = uData.getBaseDNs();
            this.checkSuffixesForEnableReplication(suffixes, ctx1, ctx2, false, uData);
            if (!suffixes.isEmpty()) {
                uData.setBaseDNs(suffixes);
                if (this.mustPrintCommandBuilder()) {
                    try {
                        CommandBuilder commandBuilder = this.createCommandBuilder("enable", uData);
                        this.printCommandBuilder(commandBuilder);
                    }
                    catch (Throwable t) {
                        LOG.log(Level.SEVERE, "Error printing equivalente command-line: " + t, t);
                    }
                }
                if (!this.isInteractive()) {
                    int repPort1 = this.getReplicationPort(ctx1);
                    int repPort2 = this.getReplicationPort(ctx2);
                    if (!uData.configureReplicationServer1() && repPort1 > 0) {
                        this.println(AdminToolMessages.INFO_REPLICATION_SERVER_CONFIGURED_WARNING.get(ConnectionUtils.getHostPort(ctx1), repPort1));
                        this.println();
                    }
                    if (!uData.configureReplicationServer2() && repPort2 > 0) {
                        this.println(AdminToolMessages.INFO_REPLICATION_SERVER_CONFIGURED_WARNING.get(ConnectionUtils.getHostPort(ctx2), repPort2));
                        this.println();
                    }
                }
                try {
                    this.updateConfiguration(ctx1, ctx2, uData);
                    returnValue = ReplicationCliReturnCode.SUCCESSFUL;
                }
                catch (ReplicationCliException rce) {
                    returnValue = rce.getErrorCode();
                    this.println();
                    this.println(this.getCriticalExceptionMessage(rce));
                    LOG.log(Level.SEVERE, "Complete error stack:", rce);
                }
            } else {
                returnValue = ReplicationCliReturnCode.REPLICATION_CANNOT_BE_ENABLED_ON_BASEDN;
            }
        }
        for (Message msg : errorMessages) {
            this.println();
            this.println(msg);
        }
        if (returnValue == ReplicationCliReturnCode.SUCCESSFUL) {
            long time1 = Utils.getServerClock(ctx1);
            long time2 = Utils.getServerClock(ctx2);
            if (time1 != -1L && time2 != -1L && Math.abs(time1 - time2) > 300000L) {
                this.println(QuickSetupMessages.INFO_WARNING_SERVERS_CLOCK_DIFFERENCE.get(ConnectionUtils.getHostPort(ctx1), ConnectionUtils.getHostPort(ctx2), String.valueOf(5)));
            }
            this.printlnProgress();
            this.printProgress(AdminToolMessages.INFO_REPLICATION_POST_ENABLE_INFO.get("dsreplication", "initialize"));
            this.printlnProgress();
        }
        if (ctx1 != null) {
            try {
                ctx1.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (ctx2 != null) {
            try {
                ctx2.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return returnValue;
    }

    private ReplicationCliReturnCode disableReplication(DisableReplicationUserData uData) {
        ReplicationCliReturnCode returnValue = ReplicationCliReturnCode.SUCCESSFUL_NOP;
        InitialLdapContext ctx = null;
        this.printProgress(this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_REPLICATION_CONNECTING.get()));
        String bindDn = uData.getAdminUid() == null ? uData.getBindDn() : ADSContext.getAdministratorDN(uData.getAdminUid());
        try {
            ctx = this.createAdministrativeContext(uData.getHostName(), uData.getPort(), this.useSSL, this.useStartTLS, bindDn, uData.getAdminPwd(), this.getTrustManager());
        }
        catch (NamingException ne) {
            String hostPort = ServerDescriptor.getServerRepresentation(uData.getHostName(), uData.getPort());
            this.println();
            this.println(this.getMessageForException(ne, hostPort));
            LOG.log(Level.SEVERE, "Complete error stack:", ne);
        }
        if (ctx != null) {
            this.printProgress(this.formatter.getFormattedDone());
            this.printlnProgress();
            LinkedList<String> suffixes = uData.getBaseDNs();
            this.checkSuffixesForDisableReplication(suffixes, ctx, false, !uData.disableReplicationServer(), !uData.disableReplicationServer());
            if (!suffixes.isEmpty() || uData.disableReplicationServer() || uData.disableAll()) {
                uData.setBaseDNs(suffixes);
                if (!this.isInteractive()) {
                    boolean hasReplicationPort = this.hasReplicationPort(ctx);
                    if (uData.disableAll() && hasReplicationPort) {
                        uData.setDisableReplicationServer(true);
                    } else if (uData.disableReplicationServer() && !hasReplicationPort && !uData.disableAll()) {
                        uData.setDisableReplicationServer(false);
                        this.println(AdminToolMessages.INFO_REPLICATION_WARNING_NO_REPLICATION_SERVER_TO_DISABLE.get(ConnectionUtils.getHostPort(ctx)));
                        this.println();
                    }
                }
                if (this.mustPrintCommandBuilder()) {
                    try {
                        CommandBuilder commandBuilder = this.createCommandBuilder("disable", uData);
                        this.printCommandBuilder(commandBuilder);
                    }
                    catch (Throwable t) {
                        LOG.log(Level.SEVERE, "Error printing equivalente command-line: " + t, t);
                    }
                }
                if (!this.isInteractive() && !uData.disableReplicationServer() && !uData.disableAll() && this.disableAllBaseDns(ctx, uData) && this.hasReplicationPort(ctx)) {
                    this.println(AdminToolMessages.INFO_REPLICATION_DISABLE_ALL_SUFFIXES_KEEP_REPLICATION_SERVER.get(ConnectionUtils.getHostPort(ctx), this.argParser.disableReplicationServerArg.getLongIdentifier(), this.argParser.disableAllArg.getLongIdentifier()));
                }
                try {
                    this.updateConfiguration(ctx, uData);
                    returnValue = ReplicationCliReturnCode.SUCCESSFUL;
                }
                catch (ReplicationCliException rce) {
                    returnValue = rce.getErrorCode();
                    this.println();
                    this.println(this.getCriticalExceptionMessage(rce));
                    LOG.log(Level.SEVERE, "Complete error stack:", rce);
                }
            } else {
                returnValue = ReplicationCliReturnCode.REPLICATION_CANNOT_BE_DISABLED_ON_BASEDN;
            }
        } else {
            returnValue = ReplicationCliReturnCode.ERROR_CONNECTING;
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return returnValue;
    }

    private ReplicationCliReturnCode statusReplication(StatusReplicationUserData uData) {
        ReplicationCliReturnCode returnValue = ReplicationCliReturnCode.SUCCESSFUL_NOP;
        InitialLdapContext ctx = null;
        try {
            ctx = this.createAdministrativeContext(uData.getHostName(), uData.getPort(), this.useSSL, this.useStartTLS, ADSContext.getAdministratorDN(uData.getAdminUid()), uData.getAdminPwd(), this.getTrustManager());
        }
        catch (NamingException ne) {
            String hostPort = ServerDescriptor.getServerRepresentation(uData.getHostName(), uData.getPort());
            this.println();
            this.println(this.getMessageForException(ne, hostPort));
            LOG.log(Level.SEVERE, "Complete error stack:", ne);
        }
        if (ctx != null) {
            uData.setBaseDNs(uData.getBaseDNs());
            try {
                this.displayStatus(ctx, uData);
                returnValue = ReplicationCliReturnCode.SUCCESSFUL;
            }
            catch (ReplicationCliException rce) {
                returnValue = rce.getErrorCode();
                this.println();
                this.println(this.getCriticalExceptionMessage(rce));
                LOG.log(Level.SEVERE, "Complete error stack:", rce);
            }
        } else {
            returnValue = ReplicationCliReturnCode.ERROR_CONNECTING;
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return returnValue;
    }

    private ReplicationCliReturnCode initializeReplication(InitializeReplicationUserData uData) {
        String hostPort;
        ReplicationCliReturnCode returnValue = ReplicationCliReturnCode.SUCCESSFUL_NOP;
        InitialLdapContext ctxSource = null;
        InitialLdapContext ctxDestination = null;
        try {
            ctxSource = this.createAdministrativeContext(uData.getHostNameSource(), uData.getPortSource(), this.useSSL, this.useStartTLS, ADSContext.getAdministratorDN(uData.getAdminUid()), uData.getAdminPwd(), this.getTrustManager());
        }
        catch (NamingException ne) {
            hostPort = ServerDescriptor.getServerRepresentation(uData.getHostNameSource(), uData.getPortSource());
            this.println();
            this.println(this.getMessageForException(ne, hostPort));
            LOG.log(Level.SEVERE, "Complete error stack:", ne);
        }
        try {
            ctxDestination = this.createAdministrativeContext(uData.getHostNameDestination(), uData.getPortDestination(), this.useSSL, this.useStartTLS, ADSContext.getAdministratorDN(uData.getAdminUid()), uData.getAdminPwd(), this.getTrustManager());
        }
        catch (NamingException ne) {
            hostPort = ServerDescriptor.getServerRepresentation(uData.getHostNameDestination(), uData.getPortDestination());
            this.println();
            this.println(this.getMessageForException(ne, hostPort));
            LOG.log(Level.SEVERE, "Complete error stack:", ne);
        }
        if (ctxSource != null && ctxDestination != null) {
            LinkedList<String> baseDNs = uData.getBaseDNs();
            this.checkSuffixesForInitializeReplication(baseDNs, ctxSource, ctxDestination, false);
            if (!baseDNs.isEmpty()) {
                if (this.mustPrintCommandBuilder()) {
                    try {
                        uData.setBaseDNs(baseDNs);
                        CommandBuilder commandBuilder = this.createCommandBuilder("initialize", uData);
                        this.printCommandBuilder(commandBuilder);
                    }
                    catch (Throwable t) {
                        LOG.log(Level.SEVERE, "Error printing equivalente command-line: " + t, t);
                    }
                }
                for (String baseDN : baseDNs) {
                    try {
                        this.printlnProgress();
                        Message msg = this.formatter.getFormattedProgress(QuickSetupMessages.INFO_PROGRESS_INITIALIZING_SUFFIX.get(baseDN, ConnectionUtils.getHostPort(ctxSource)));
                        this.printProgress(msg);
                        this.printlnProgress();
                        this.initializeSuffix(baseDN, ctxSource, ctxDestination, true);
                        returnValue = ReplicationCliReturnCode.SUCCESSFUL;
                    }
                    catch (ReplicationCliException rce) {
                        this.println();
                        this.println(this.getCriticalExceptionMessage(rce));
                        returnValue = rce.getErrorCode();
                        LOG.log(Level.SEVERE, "Complete error stack:", rce);
                    }
                }
            } else {
                returnValue = ReplicationCliReturnCode.REPLICATION_CANNOT_BE_INITIALIZED_ON_BASEDN;
            }
        } else {
            returnValue = ReplicationCliReturnCode.ERROR_CONNECTING;
        }
        if (ctxSource != null) {
            try {
                ctxSource.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (ctxDestination != null) {
            try {
                ctxDestination.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return returnValue;
    }

    private ReplicationCliReturnCode initializeAllReplication(InitializeAllReplicationUserData uData) {
        ReplicationCliReturnCode returnValue = ReplicationCliReturnCode.SUCCESSFUL_NOP;
        InitialLdapContext ctx = null;
        try {
            ctx = this.createAdministrativeContext(uData.getHostName(), uData.getPort(), this.useSSL, this.useStartTLS, ADSContext.getAdministratorDN(uData.getAdminUid()), uData.getAdminPwd(), this.getTrustManager());
        }
        catch (NamingException ne) {
            String hostPort = ServerDescriptor.getServerRepresentation(uData.getHostName(), uData.getPort());
            this.println();
            this.println(this.getMessageForException(ne, hostPort));
            LOG.log(Level.SEVERE, "Complete error stack:", ne);
        }
        if (ctx != null) {
            LinkedList<String> baseDNs = uData.getBaseDNs();
            this.checkSuffixesForInitializeReplication(baseDNs, ctx, false);
            if (!baseDNs.isEmpty()) {
                if (this.mustPrintCommandBuilder()) {
                    uData.setBaseDNs(baseDNs);
                    try {
                        CommandBuilder commandBuilder = this.createCommandBuilder("initialize-all", uData);
                        this.printCommandBuilder(commandBuilder);
                    }
                    catch (Throwable t) {
                        LOG.log(Level.SEVERE, "Error printing equivalente command-line: " + t, t);
                    }
                }
                for (String baseDN : baseDNs) {
                    try {
                        this.printlnProgress();
                        Message msg = this.formatter.getFormattedProgress(QuickSetupMessages.INFO_PROGRESS_INITIALIZING_SUFFIX.get(baseDN, ConnectionUtils.getHostPort(ctx)));
                        this.printProgress(msg);
                        this.println();
                        this.initializeAllSuffix(baseDN, ctx, true);
                        returnValue = ReplicationCliReturnCode.SUCCESSFUL;
                    }
                    catch (ReplicationCliException rce) {
                        this.println();
                        this.println(this.getCriticalExceptionMessage(rce));
                        returnValue = rce.getErrorCode();
                        LOG.log(Level.SEVERE, "Complete error stack:", rce);
                    }
                }
            } else {
                returnValue = ReplicationCliReturnCode.REPLICATION_CANNOT_BE_INITIALIZED_ON_BASEDN;
            }
        } else {
            returnValue = ReplicationCliReturnCode.ERROR_CONNECTING;
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return returnValue;
    }

    private ReplicationCliReturnCode preExternalInitialization(PreExternalInitializationUserData uData) {
        ReplicationCliReturnCode returnValue = ReplicationCliReturnCode.SUCCESSFUL_NOP;
        InitialLdapContext ctx = null;
        try {
            ctx = this.createAdministrativeContext(uData.getHostName(), uData.getPort(), this.useSSL, this.useStartTLS, ADSContext.getAdministratorDN(uData.getAdminUid()), uData.getAdminPwd(), this.getTrustManager());
        }
        catch (NamingException ne) {
            String hostPort = ServerDescriptor.getServerRepresentation(uData.getHostName(), uData.getPort());
            this.println();
            this.println(this.getMessageForException(ne, hostPort));
            LOG.log(Level.SEVERE, "Complete error stack:", ne);
        }
        if (ctx != null) {
            LinkedList<String> baseDNs = uData.getBaseDNs();
            this.checkSuffixesForInitializeReplication(baseDNs, ctx, false);
            if (!baseDNs.isEmpty()) {
                if (this.mustPrintCommandBuilder()) {
                    uData.setBaseDNs(baseDNs);
                    try {
                        CommandBuilder commandBuilder = this.createCommandBuilder("pre-external-initialization", uData);
                        this.printCommandBuilder(commandBuilder);
                    }
                    catch (Throwable t) {
                        LOG.log(Level.SEVERE, "Error printing equivalente command-line: " + t, t);
                    }
                }
                returnValue = ReplicationCliReturnCode.SUCCESSFUL;
                for (String baseDN : baseDNs) {
                    try {
                        this.printlnProgress();
                        Message msg = this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_PROGRESS_PRE_EXTERNAL_INITIALIZATION.get(baseDN));
                        this.printProgress(msg);
                        this.preExternalInitialization(baseDN, ctx, uData.isLocalOnly(), false);
                        this.printProgress(this.formatter.getFormattedDone());
                        this.printlnProgress();
                    }
                    catch (ReplicationCliException rce) {
                        this.println();
                        this.println(this.getCriticalExceptionMessage(rce));
                        returnValue = rce.getErrorCode();
                        LOG.log(Level.SEVERE, "Complete error stack:", rce);
                    }
                }
                if (uData.isLocalOnly()) {
                    this.printlnProgress();
                    this.printProgress(AdminToolMessages.INFO_PROGRESS_PRE_INITIALIZATION_LOCAL_FINISHED_PROCEDURE.get(ConnectionUtils.getHostPort(ctx), "post-external-initialization"));
                    this.printlnProgress();
                } else {
                    this.printlnProgress();
                    this.printProgress(AdminToolMessages.INFO_PROGRESS_PRE_INITIALIZATION_FINISHED_PROCEDURE.get("post-external-initialization"));
                    this.printlnProgress();
                }
            } else {
                returnValue = ReplicationCliReturnCode.REPLICATION_CANNOT_BE_INITIALIZED_ON_BASEDN;
            }
        } else {
            returnValue = ReplicationCliReturnCode.ERROR_CONNECTING;
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return returnValue;
    }

    private ReplicationCliReturnCode postExternalInitialization(PostExternalInitializationUserData uData) {
        ReplicationCliReturnCode returnValue = ReplicationCliReturnCode.SUCCESSFUL_NOP;
        InitialLdapContext ctx = null;
        try {
            ctx = this.createAdministrativeContext(uData.getHostName(), uData.getPort(), this.useSSL, this.useStartTLS, ADSContext.getAdministratorDN(uData.getAdminUid()), uData.getAdminPwd(), this.getTrustManager());
        }
        catch (NamingException ne) {
            String hostPort = ServerDescriptor.getServerRepresentation(uData.getHostName(), uData.getPort());
            this.println();
            this.println(this.getMessageForException(ne, hostPort));
            LOG.log(Level.SEVERE, "Complete error stack:", ne);
        }
        if (ctx != null) {
            LinkedList<String> baseDNs = uData.getBaseDNs();
            this.checkSuffixesForInitializeReplication(baseDNs, ctx, false);
            if (!baseDNs.isEmpty()) {
                if (this.mustPrintCommandBuilder()) {
                    uData.setBaseDNs(baseDNs);
                    try {
                        CommandBuilder commandBuilder = this.createCommandBuilder("post-external-initialization", uData);
                        this.printCommandBuilder(commandBuilder);
                    }
                    catch (Throwable t) {
                        LOG.log(Level.SEVERE, "Error printing equivalente command-line: " + t, t);
                    }
                }
                returnValue = ReplicationCliReturnCode.SUCCESSFUL;
                for (String baseDN : baseDNs) {
                    try {
                        this.printlnProgress();
                        Message msg = this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_PROGRESS_POST_EXTERNAL_INITIALIZATION.get(baseDN));
                        this.printProgress(msg);
                        this.postExternalInitialization(baseDN, ctx, false);
                        this.printProgress(this.formatter.getFormattedDone());
                        this.printlnProgress();
                    }
                    catch (ReplicationCliException rce) {
                        this.println();
                        this.println(this.getCriticalExceptionMessage(rce));
                        returnValue = rce.getErrorCode();
                        LOG.log(Level.SEVERE, "Complete error stack:", rce);
                    }
                }
                this.printlnProgress();
                this.printProgress(AdminToolMessages.INFO_PROGRESS_POST_INITIALIZATION_FINISHED_PROCEDURE.get());
                this.printlnProgress();
            } else {
                returnValue = ReplicationCliReturnCode.REPLICATION_CANNOT_BE_INITIALIZED_ON_BASEDN;
            }
        } else {
            returnValue = ReplicationCliReturnCode.ERROR_CONNECTING;
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return returnValue;
    }

    private void checkSuffixesForEnableReplication(Collection<String> suffixes, InitialLdapContext ctx1, InitialLdapContext ctx2, boolean interactive, EnableReplicationUserData uData) {
        TreeSet<String> alreadyReplicatedSuffixes;
        TreeSet<String> availableSuffixes;
        if (uData.configureReplicationDomain1() && uData.configureReplicationDomain2()) {
            availableSuffixes = new TreeSet<String>(this.getCommonSuffixes(ctx1, ctx2, SuffixRelationType.NOT_FULLY_REPLICATED));
            alreadyReplicatedSuffixes = new TreeSet<String>(this.getCommonSuffixes(ctx1, ctx2, SuffixRelationType.FULLY_REPLICATED));
        } else if (uData.configureReplicationDomain1()) {
            availableSuffixes = new TreeSet();
            alreadyReplicatedSuffixes = new TreeSet<String>();
            this.updateAvailableAndReplicatedSuffixesForOneDomain(ctx1, ctx2, availableSuffixes, alreadyReplicatedSuffixes);
        } else if (uData.configureReplicationDomain2()) {
            availableSuffixes = new TreeSet();
            alreadyReplicatedSuffixes = new TreeSet();
            this.updateAvailableAndReplicatedSuffixesForOneDomain(ctx2, ctx1, availableSuffixes, alreadyReplicatedSuffixes);
        } else {
            availableSuffixes = new TreeSet();
            alreadyReplicatedSuffixes = new TreeSet();
            this.updateAvailableAndReplicatedSuffixesForNoDomain(ctx1, ctx2, availableSuffixes, alreadyReplicatedSuffixes);
        }
        if (availableSuffixes.size() == 0) {
            this.println();
            if (!uData.configureReplicationDomain1() && !uData.configureReplicationDomain1() && alreadyReplicatedSuffixes.isEmpty()) {
                this.println(AdminToolMessages.ERR_NO_SUFFIXES_AVAILABLE_TO_ENABLE_REPLICATION_NO_DOMAIN.get());
            } else {
                this.println(AdminToolMessages.ERR_NO_SUFFIXES_AVAILABLE_TO_ENABLE_REPLICATION.get());
            }
            LinkedList<String> userProvidedSuffixes = this.argParser.getBaseDNs();
            TreeSet<String> userProvidedReplicatedSuffixes = new TreeSet<String>();
            for (String s1 : userProvidedSuffixes) {
                for (String s2 : alreadyReplicatedSuffixes) {
                    if (!Utils.areDnsEqual(s1, s2)) continue;
                    userProvidedReplicatedSuffixes.add(s1);
                }
            }
            if (userProvidedReplicatedSuffixes.size() > 0) {
                this.println();
                this.println(AdminToolMessages.INFO_ALREADY_REPLICATED_SUFFIXES.get(Utils.getStringFromCollection(userProvidedReplicatedSuffixes, Constants.LINE_SEPARATOR)));
            }
            suffixes.clear();
        } else {
            TreeSet<String> notFound = new TreeSet<String>();
            TreeSet<String> alreadyReplicated = new TreeSet<String>();
            for (String dn : suffixes) {
                boolean found = false;
                for (String dn1 : availableSuffixes) {
                    if (!Utils.areDnsEqual(dn, dn1)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                boolean isReplicated = false;
                for (String s : alreadyReplicatedSuffixes) {
                    if (!Utils.areDnsEqual(s, dn)) continue;
                    isReplicated = true;
                    break;
                }
                if (isReplicated) {
                    alreadyReplicated.add(dn);
                    continue;
                }
                notFound.add(dn);
            }
            suffixes.removeAll(notFound);
            suffixes.removeAll(alreadyReplicated);
            if (notFound.size() > 0) {
                this.println();
                this.println(AdminToolMessages.ERR_REPLICATION_ENABLE_SUFFIXES_NOT_FOUND.get(Utils.getStringFromCollection(notFound, Constants.LINE_SEPARATOR)));
            }
            if (alreadyReplicated.size() > 0) {
                this.println();
                this.println(AdminToolMessages.INFO_ALREADY_REPLICATED_SUFFIXES.get(Utils.getStringFromCollection(alreadyReplicated, Constants.LINE_SEPARATOR)));
            }
            if (interactive) {
                boolean confirmationLimitReached = false;
                while (suffixes.isEmpty()) {
                    boolean noSchemaOrAds = false;
                    for (String s : availableSuffixes) {
                        if (Utils.areDnsEqual(s, ADSContext.getAdministrationSuffixDN()) || Utils.areDnsEqual(s, "cn=schema") || Utils.areDnsEqual(s, "dc=replicationChanges")) continue;
                        noSchemaOrAds = true;
                    }
                    if (!noSchemaOrAds) {
                        this.println();
                        this.println(AdminToolMessages.ERR_NO_SUFFIXES_AVAILABLE_TO_ENABLE_REPLICATION.get());
                        break;
                    }
                    this.println();
                    this.println(AdminToolMessages.ERR_NO_SUFFIXES_SELECTED_TO_REPLICATE.get());
                    for (String dn : availableSuffixes) {
                        if (Utils.areDnsEqual(dn, ADSContext.getAdministrationSuffixDN()) || Utils.areDnsEqual(dn, "cn=schema") || Utils.areDnsEqual(dn, "dc=replicationChanges")) continue;
                        try {
                            if (!this.askConfirmation(AdminToolMessages.INFO_REPLICATION_ENABLE_SUFFIX_PROMPT.get(dn), true, LOG)) continue;
                            suffixes.add(dn);
                        }
                        catch (CLIException ce) {
                            this.println(ce.getMessageObject());
                            confirmationLimitReached = true;
                            break;
                        }
                    }
                    if (!confirmationLimitReached) continue;
                    suffixes.clear();
                    break;
                }
            }
        }
    }

    private void checkSuffixesForDisableReplication(Collection<String> suffixes, InitialLdapContext ctx, boolean interactive, boolean displayErrors, boolean areSuffixRequired) {
        TreeSet<String> availableSuffixes = new TreeSet<String>();
        TreeSet<String> notReplicatedSuffixes = new TreeSet<String>();
        Collection<ReplicaDescriptor> replicas = this.getReplicas(ctx);
        for (ReplicaDescriptor rep : replicas) {
            String dn = rep.getSuffix().getDN();
            if (rep.isReplicated()) {
                availableSuffixes.add(dn);
                continue;
            }
            notReplicatedSuffixes.add(dn);
        }
        if (availableSuffixes.size() == 0) {
            if (displayErrors) {
                this.println();
                this.println(AdminToolMessages.ERR_NO_SUFFIXES_AVAILABLE_TO_DISABLE_REPLICATION.get());
            }
            LinkedList<String> userProvidedSuffixes = this.argParser.getBaseDNs();
            TreeSet<String> userProvidedNotReplicatedSuffixes = new TreeSet<String>();
            for (String s1 : userProvidedSuffixes) {
                for (String s2 : notReplicatedSuffixes) {
                    if (!Utils.areDnsEqual(s1, s2)) continue;
                    userProvidedNotReplicatedSuffixes.add(s1);
                }
            }
            if (userProvidedNotReplicatedSuffixes.size() > 0 && displayErrors) {
                this.println();
                this.println(AdminToolMessages.INFO_ALREADY_NOT_REPLICATED_SUFFIXES.get(Utils.getStringFromCollection(userProvidedNotReplicatedSuffixes, Constants.LINE_SEPARATOR)));
            }
            suffixes.clear();
        } else {
            TreeSet<String> notFound = new TreeSet<String>();
            TreeSet<String> alreadyNotReplicated = new TreeSet<String>();
            for (String dn : suffixes) {
                boolean found = false;
                for (String dn1 : availableSuffixes) {
                    if (!Utils.areDnsEqual(dn, dn1)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                boolean notReplicated = false;
                for (String s : notReplicatedSuffixes) {
                    if (!Utils.areDnsEqual(s, dn)) continue;
                    notReplicated = true;
                    break;
                }
                if (notReplicated) {
                    alreadyNotReplicated.add(dn);
                    continue;
                }
                notFound.add(dn);
            }
            suffixes.removeAll(notFound);
            suffixes.removeAll(alreadyNotReplicated);
            if (notFound.size() > 0 && displayErrors) {
                this.println();
                this.println(AdminToolMessages.ERR_REPLICATION_DISABLE_SUFFIXES_NOT_FOUND.get(Utils.getStringFromCollection(notFound, Constants.LINE_SEPARATOR)));
            }
            if (alreadyNotReplicated.size() > 0 && displayErrors) {
                this.println();
                this.println(AdminToolMessages.INFO_ALREADY_NOT_REPLICATED_SUFFIXES.get(Utils.getStringFromCollection(alreadyNotReplicated, Constants.LINE_SEPARATOR)));
            }
            if (interactive) {
                boolean confirmationLimitReached = false;
                while (suffixes.isEmpty()) {
                    boolean noSchemaOrAds = false;
                    for (String s : availableSuffixes) {
                        if (Utils.areDnsEqual(s, ADSContext.getAdministrationSuffixDN()) || Utils.areDnsEqual(s, "cn=schema") || Utils.areDnsEqual(s, "dc=replicationChanges")) continue;
                        noSchemaOrAds = true;
                    }
                    if (!noSchemaOrAds) {
                        if (!displayErrors) break;
                        this.println();
                        this.println(AdminToolMessages.ERR_NO_SUFFIXES_AVAILABLE_TO_DISABLE_REPLICATION.get());
                        break;
                    }
                    if (areSuffixRequired) {
                        this.println();
                        this.println(AdminToolMessages.ERR_NO_SUFFIXES_SELECTED_TO_DISABLE.get());
                    }
                    for (String dn : availableSuffixes) {
                        if (Utils.areDnsEqual(dn, ADSContext.getAdministrationSuffixDN()) || Utils.areDnsEqual(dn, "cn=schema") || Utils.areDnsEqual(dn, "dc=replicationChanges")) continue;
                        try {
                            if (!this.askConfirmation(AdminToolMessages.INFO_REPLICATION_DISABLE_SUFFIX_PROMPT.get(dn), true, LOG)) continue;
                            suffixes.add(dn);
                        }
                        catch (CLIException ce) {
                            this.println(ce.getMessageObject());
                            confirmationLimitReached = true;
                            break;
                        }
                    }
                    if (confirmationLimitReached) {
                        suffixes.clear();
                        break;
                    }
                    if (areSuffixRequired) continue;
                    break;
                }
            }
        }
    }

    private void checkSuffixesForInitializeReplication(Collection<String> suffixes, InitialLdapContext ctx, boolean interactive) {
        TreeSet<String> availableSuffixes = new TreeSet<String>();
        TreeSet<String> notReplicatedSuffixes = new TreeSet<String>();
        Collection<ReplicaDescriptor> replicas = this.getReplicas(ctx);
        for (ReplicaDescriptor rep : replicas) {
            String dn = rep.getSuffix().getDN();
            if (rep.isReplicated()) {
                availableSuffixes.add(dn);
                continue;
            }
            notReplicatedSuffixes.add(dn);
        }
        if (availableSuffixes.size() == 0) {
            this.println();
            if (this.argParser.isInitializeAllReplicationSubcommand()) {
                this.println(AdminToolMessages.ERR_NO_SUFFIXES_AVAILABLE_TO_INITIALIZE_ALL_REPLICATION.get());
            } else {
                this.println(AdminToolMessages.ERR_NO_SUFFIXES_AVAILABLE_TO_INITIALIZE_LOCAL_REPLICATION.get());
            }
            LinkedList<String> userProvidedSuffixes = this.argParser.getBaseDNs();
            TreeSet<String> userProvidedNotReplicatedSuffixes = new TreeSet<String>();
            for (String s1 : userProvidedSuffixes) {
                for (String s2 : notReplicatedSuffixes) {
                    if (!Utils.areDnsEqual(s1, s2)) continue;
                    userProvidedNotReplicatedSuffixes.add(s1);
                }
            }
            if (userProvidedNotReplicatedSuffixes.size() > 0) {
                this.println();
                this.println(AdminToolMessages.INFO_ALREADY_NOT_REPLICATED_SUFFIXES.get(Utils.getStringFromCollection(userProvidedNotReplicatedSuffixes, Constants.LINE_SEPARATOR)));
            }
            suffixes.clear();
        } else {
            TreeSet<String> notFound = new TreeSet<String>();
            TreeSet<String> alreadyNotReplicated = new TreeSet<String>();
            for (String dn : suffixes) {
                boolean found = false;
                for (String dn1 : availableSuffixes) {
                    if (!Utils.areDnsEqual(dn, dn1)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                boolean notReplicated = false;
                for (String s : notReplicatedSuffixes) {
                    if (!Utils.areDnsEqual(s, dn)) continue;
                    notReplicated = true;
                    break;
                }
                if (notReplicated) {
                    alreadyNotReplicated.add(dn);
                    continue;
                }
                notFound.add(dn);
            }
            suffixes.removeAll(notFound);
            suffixes.removeAll(alreadyNotReplicated);
            if (notFound.size() > 0) {
                this.println();
                this.println(AdminToolMessages.ERR_REPLICATION_INITIALIZE_LOCAL_SUFFIXES_NOT_FOUND.get(Utils.getStringFromCollection(notFound, Constants.LINE_SEPARATOR)));
            }
            if (alreadyNotReplicated.size() > 0) {
                this.println();
                this.println(AdminToolMessages.INFO_ALREADY_NOT_REPLICATED_SUFFIXES.get(Utils.getStringFromCollection(alreadyNotReplicated, Constants.LINE_SEPARATOR)));
            }
            if (interactive) {
                boolean confirmationLimitReached = false;
                while (suffixes.isEmpty()) {
                    boolean noSchemaOrAds = false;
                    for (String s : availableSuffixes) {
                        if (Utils.areDnsEqual(s, ADSContext.getAdministrationSuffixDN()) || Utils.areDnsEqual(s, "cn=schema") || Utils.areDnsEqual(s, "dc=replicationChanges")) continue;
                        noSchemaOrAds = true;
                    }
                    if (!noSchemaOrAds) {
                        this.println();
                        if (this.argParser.isInitializeAllReplicationSubcommand()) {
                            this.println(AdminToolMessages.ERR_NO_SUFFIXES_AVAILABLE_TO_INITIALIZE_ALL_REPLICATION.get());
                            break;
                        }
                        this.println(AdminToolMessages.ERR_NO_SUFFIXES_AVAILABLE_TO_INITIALIZE_LOCAL_REPLICATION.get());
                        break;
                    }
                    this.println();
                    if (this.argParser.isInitializeAllReplicationSubcommand()) {
                        this.println(AdminToolMessages.ERR_NO_SUFFIXES_SELECTED_TO_INITIALIZE_ALL.get());
                    } else if (this.argParser.isPreExternalInitializationSubcommand()) {
                        this.println(AdminToolMessages.ERR_NO_SUFFIXES_SELECTED_TO_PRE_EXTERNAL_INITIALIZATION.get());
                    } else if (this.argParser.isPostExternalInitializationSubcommand()) {
                        this.println(AdminToolMessages.ERR_NO_SUFFIXES_SELECTED_TO_POST_EXTERNAL_INITIALIZATION.get());
                    }
                    for (String dn : availableSuffixes) {
                        boolean addSuffix;
                        if (Utils.areDnsEqual(dn, ADSContext.getAdministrationSuffixDN()) || Utils.areDnsEqual(dn, "cn=schema") || Utils.areDnsEqual(dn, "dc=replicationChanges")) continue;
                        try {
                            addSuffix = this.argParser.isPreExternalInitializationSubcommand() ? this.askConfirmation(AdminToolMessages.INFO_REPLICATION_PRE_EXTERNAL_INITIALIZATION_SUFFIX_PROMPT.get(dn), true, LOG) : (this.argParser.isPostExternalInitializationSubcommand() ? this.askConfirmation(AdminToolMessages.INFO_REPLICATION_POST_EXTERNAL_INITIALIZATION_SUFFIX_PROMPT.get(dn), true, LOG) : this.askConfirmation(AdminToolMessages.INFO_REPLICATION_INITIALIZE_ALL_SUFFIX_PROMPT.get(dn), true, LOG));
                        }
                        catch (CLIException ce) {
                            this.println(ce.getMessageObject());
                            confirmationLimitReached = true;
                            break;
                        }
                        if (!addSuffix) continue;
                        suffixes.add(dn);
                    }
                    if (!confirmationLimitReached) continue;
                    suffixes.clear();
                    break;
                }
            }
        }
    }

    private void checkSuffixesForInitializeReplication(Collection<String> suffixes, InitialLdapContext ctxSource, InitialLdapContext ctxDestination, boolean interactive) {
        TreeSet<String> availableSuffixes = new TreeSet<String>(this.getCommonSuffixes(ctxSource, ctxDestination, SuffixRelationType.REPLICATED));
        if (availableSuffixes.size() == 0) {
            this.println();
            this.println(AdminToolMessages.ERR_NO_SUFFIXES_AVAILABLE_TO_INITIALIZE_REPLICATION.get());
            suffixes.clear();
        } else {
            LinkedList<String> notFound = new LinkedList<String>();
            for (String dn : suffixes) {
                boolean found = false;
                for (String dn1 : availableSuffixes) {
                    if (!Utils.areDnsEqual(dn, dn1)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                notFound.add(dn);
            }
            suffixes.removeAll(notFound);
            if (notFound.size() > 0) {
                this.println();
                this.println(AdminToolMessages.ERR_SUFFIXES_CANNOT_BE_INITIALIZED.get(Utils.getStringFromCollection(notFound, Constants.LINE_SEPARATOR)));
            }
            if (interactive) {
                boolean confirmationLimitReached = false;
                while (suffixes.isEmpty()) {
                    boolean noSchemaOrAds = false;
                    for (String s : availableSuffixes) {
                        if (Utils.areDnsEqual(s, ADSContext.getAdministrationSuffixDN()) || Utils.areDnsEqual(s, "cn=schema") || Utils.areDnsEqual(s, "dc=replicationChanges")) continue;
                        noSchemaOrAds = true;
                    }
                    if (!noSchemaOrAds) {
                        this.println();
                        this.println(AdminToolMessages.ERR_NO_SUFFIXES_AVAILABLE_TO_INITIALIZE_REPLICATION.get());
                        break;
                    }
                    this.println();
                    this.println(AdminToolMessages.ERR_NO_SUFFIXES_SELECTED_TO_INITIALIZE.get());
                    for (String dn : availableSuffixes) {
                        if (Utils.areDnsEqual(dn, ADSContext.getAdministrationSuffixDN()) || Utils.areDnsEqual(dn, "cn=schema") || Utils.areDnsEqual(dn, "dc=replicationChanges")) continue;
                        try {
                            if (!this.askConfirmation(AdminToolMessages.INFO_REPLICATION_INITIALIZE_SUFFIX_PROMPT.get(dn), true, LOG)) continue;
                            suffixes.add(dn);
                        }
                        catch (CLIException ce) {
                            this.println(ce.getMessageObject());
                            confirmationLimitReached = true;
                            break;
                        }
                    }
                    if (!confirmationLimitReached) continue;
                    suffixes.clear();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConfiguration(InitialLdapContext ctx1, InitialLdapContext ctx2, EnableReplicationUserData uData) throws ReplicationCliException {
        ConsoleApplication.PointAdder pointAdder;
        ADSContext adsCtx2;
        ADSContext adsCtx1;
        ServerDescriptor server2;
        ServerDescriptor server1;
        HashMap hmUsedReplicationDomainIds;
        HashSet<Integer> usedReplicationServerIds;
        HashMap hmRepServers;
        LinkedHashSet<String> allRepServers;
        LinkedHashSet<String> twoReplServers;
        block116: {
            twoReplServers = new LinkedHashSet<String>();
            allRepServers = new LinkedHashSet<String>();
            hmRepServers = new HashMap();
            usedReplicationServerIds = new HashSet<Integer>();
            hmUsedReplicationDomainIds = new HashMap();
            TopologyCacheFilter filter = new TopologyCacheFilter();
            filter.setSearchMonitoringInformation(false);
            filter.addBaseDNToSearch(ADSContext.getAdministrationSuffixDN());
            filter.addBaseDNToSearch("cn=schema");
            for (String dn : uData.getBaseDNs()) {
                filter.addBaseDNToSearch(dn);
            }
            try {
                server1 = ServerDescriptor.createStandalone(ctx1, filter);
            }
            catch (NamingException ne) {
                throw new ReplicationCliException(this.getMessageForException(ne, ConnectionUtils.getHostPort(ctx1)), ReplicationCliReturnCode.ERROR_READING_CONFIGURATION, ne);
            }
            try {
                server2 = ServerDescriptor.createStandalone(ctx2, filter);
            }
            catch (NamingException ne) {
                throw new ReplicationCliException(this.getMessageForException(ne, ConnectionUtils.getHostPort(ctx2)), ReplicationCliReturnCode.ERROR_READING_CONFIGURATION, ne);
            }
            adsCtx1 = new ADSContext(ctx1);
            adsCtx2 = new ADSContext(ctx2);
            if (!this.argParser.isInteractive()) {
                LinkedHashSet<Message> messages = new LinkedHashSet<Message>();
                try {
                    TopologyCache cache;
                    LinkedHashSet<PreferredConnection> cnx = new LinkedHashSet<PreferredConnection>();
                    cnx.addAll(PreferredConnection.getPreferredConnections(ctx1));
                    cnx.addAll(PreferredConnection.getPreferredConnections(ctx2));
                    if (adsCtx1.hasAdminData()) {
                        cache = new TopologyCache(adsCtx1, this.getTrustManager());
                        cache.setPreferredConnections(cnx);
                        cache.getFilter().setSearchMonitoringInformation(false);
                        for (String dn : uData.getBaseDNs()) {
                            cache.getFilter().addBaseDNToSearch(dn);
                        }
                        cache.reloadTopology();
                        messages.addAll(cache.getErrorMessages());
                    }
                    if (adsCtx2.hasAdminData()) {
                        cache = new TopologyCache(adsCtx2, this.getTrustManager());
                        cache.setPreferredConnections(cnx);
                        cache.getFilter().setSearchMonitoringInformation(false);
                        for (String dn : uData.getBaseDNs()) {
                            cache.getFilter().addBaseDNToSearch(dn);
                        }
                        cache.reloadTopology();
                        messages.addAll(cache.getErrorMessages());
                    }
                }
                catch (TopologyCacheException tce) {
                    throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_READING_ADS.get(tce.getMessage()), ReplicationCliReturnCode.ERROR_READING_TOPOLOGY_CACHE, tce);
                }
                catch (ADSContextException adce) {
                    throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_READING_ADS.get(adce.getMessage()), ReplicationCliReturnCode.ERROR_READING_ADS, adce);
                }
                if (!messages.isEmpty()) {
                    this.println(AdminToolMessages.ERR_REPLICATION_READING_REGISTERED_SERVERS_WARNING.get(Utils.getMessageFromCollection(messages, Constants.LINE_SEPARATOR).toString()));
                }
            }
            TreeSet<String> baseDNsWithOneReplicationServer = new TreeSet<String>();
            TreeSet<String> baseDNsWithNoReplicationServer = new TreeSet<String>();
            this.updateBaseDnsWithNotEnoughReplicationServer(adsCtx1, adsCtx2, uData, baseDNsWithNoReplicationServer, baseDNsWithOneReplicationServer);
            if (!baseDNsWithNoReplicationServer.isEmpty()) {
                Message errorMsg = AdminToolMessages.ERR_REPLICATION_NO_REPLICATION_SERVER.get(Utils.getStringFromCollection(baseDNsWithNoReplicationServer, Constants.LINE_SEPARATOR));
                throw new ReplicationCliException(errorMsg, ReplicationCliReturnCode.ERROR_USER_DATA, null);
            }
            if (!baseDNsWithOneReplicationServer.isEmpty()) {
                if (this.isInteractive()) {
                    Message confirmMsg = AdminToolMessages.INFO_REPLICATION_ONLY_ONE_REPLICATION_SERVER_CONFIRM.get(Utils.getStringFromCollection(baseDNsWithOneReplicationServer, Constants.LINE_SEPARATOR));
                    try {
                        if (!this.confirmAction(confirmMsg, false)) {
                            throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_USER_CANCELLED.get(), ReplicationCliReturnCode.USER_CANCELLED, null);
                        }
                        break block116;
                    }
                    catch (Throwable t) {
                        throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_USER_CANCELLED.get(), ReplicationCliReturnCode.USER_CANCELLED, t);
                    }
                }
                Message warningMsg = AdminToolMessages.INFO_REPLICATION_ONLY_ONE_REPLICATION_SERVER_WARNING.get(Utils.getStringFromCollection(baseDNsWithOneReplicationServer, Constants.LINE_SEPARATOR));
                this.println(warningMsg);
                this.println();
            }
        }
        InitialLdapContext ctxSource = null;
        InitialLdapContext ctxDestination = null;
        ADSContext adsCtxSource = null;
        boolean adsAlreadyReplicated = false;
        boolean adsMergeDone = false;
        this.printProgress(this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_REPLICATION_ENABLE_UPDATING_ADS_CONTENTS.get()));
        try {
            Set<Map<ADSContext.ServerProperty, Object>> registry1;
            if (adsCtx1.hasAdminData() && adsCtx2.hasAdminData()) {
                registry1 = adsCtx1.readServerRegistry();
                Set<Map<ADSContext.ServerProperty, Object>> registry2 = adsCtx2.readServerRegistry();
                if (registry2.size() <= 1) {
                    if (!this.hasAdministrator(adsCtx1.getDirContext(), uData)) {
                        adsCtx1.createAdministrator(this.getAdministratorProperties(uData));
                    }
                    server2.updateAdsPropertiesWithServerProperties();
                    this.registerServer(adsCtx1, server2.getAdsProperties());
                    if (!ADSContext.isRegistered(server1, registry1)) {
                        server1.updateAdsPropertiesWithServerProperties();
                        this.registerServer(adsCtx1, server1.getAdsProperties());
                    }
                    ctxSource = ctx1;
                    ctxDestination = ctx2;
                    adsCtxSource = adsCtx1;
                } else if (registry1.size() <= 1) {
                    if (!this.hasAdministrator(adsCtx2.getDirContext(), uData)) {
                        adsCtx2.createAdministrator(this.getAdministratorProperties(uData));
                    }
                    server1.updateAdsPropertiesWithServerProperties();
                    this.registerServer(adsCtx2, server1.getAdsProperties());
                    if (!ADSContext.isRegistered(server2, registry2)) {
                        server2.updateAdsPropertiesWithServerProperties();
                        this.registerServer(adsCtx2, server2.getAdsProperties());
                    }
                    ctxSource = ctx2;
                    ctxDestination = ctx1;
                    adsCtxSource = adsCtx2;
                } else if (!this.areEqual(registry1, registry2)) {
                    this.printProgress(this.formatter.getFormattedDone());
                    this.printlnProgress();
                    boolean isFirstSource = this.mergeRegistries(adsCtx1, adsCtx2);
                    ctxSource = isFirstSource ? ctx1 : ctx2;
                    adsMergeDone = true;
                } else {
                    adsAlreadyReplicated = this.isBaseDNReplicated(server1, server2, ADSContext.getAdministrationSuffixDN());
                    if (!adsAlreadyReplicated) {
                        boolean isADS1Replicated = this.isBaseDNReplicated(server1, ADSContext.getAdministrationSuffixDN());
                        boolean isADS2Replicated = this.isBaseDNReplicated(server2, ADSContext.getAdministrationSuffixDN());
                        if (isADS1Replicated && isADS2Replicated) {
                            this.printProgress(this.formatter.getFormattedDone());
                            this.printlnProgress();
                            boolean isFirstSource = this.mergeRegistries(adsCtx1, adsCtx2);
                            ctxSource = isFirstSource ? ctx1 : ctx2;
                            adsMergeDone = true;
                        } else if (isADS1Replicated || !isADS2Replicated) {
                            if (!this.hasAdministrator(adsCtx1.getDirContext(), uData)) {
                                adsCtx1.createAdministrator(this.getAdministratorProperties(uData));
                            }
                            server2.updateAdsPropertiesWithServerProperties();
                            this.registerServer(adsCtx1, server2.getAdsProperties());
                            if (!ADSContext.isRegistered(server1, registry1)) {
                                server1.updateAdsPropertiesWithServerProperties();
                                this.registerServer(adsCtx1, server1.getAdsProperties());
                            }
                            ctxSource = ctx1;
                            ctxDestination = ctx2;
                            adsCtxSource = adsCtx1;
                        } else if (isADS2Replicated) {
                            if (!this.hasAdministrator(adsCtx2.getDirContext(), uData)) {
                                adsCtx2.createAdministrator(this.getAdministratorProperties(uData));
                            }
                            server1.updateAdsPropertiesWithServerProperties();
                            this.registerServer(adsCtx2, server1.getAdsProperties());
                            if (!ADSContext.isRegistered(server2, registry2)) {
                                server2.updateAdsPropertiesWithServerProperties();
                                this.registerServer(adsCtx2, server2.getAdsProperties());
                            }
                            ctxSource = ctx2;
                            ctxDestination = ctx1;
                            adsCtxSource = adsCtx2;
                        }
                    }
                }
            } else if (!adsCtx1.hasAdminData() && adsCtx2.hasAdminData()) {
                if (!this.hasAdministrator(adsCtx2.getDirContext(), uData)) {
                    adsCtx2.createAdministrator(this.getAdministratorProperties(uData));
                }
                server1.updateAdsPropertiesWithServerProperties();
                this.registerServer(adsCtx2, server1.getAdsProperties());
                Set<Map<ADSContext.ServerProperty, Object>> registry2 = adsCtx2.readServerRegistry();
                if (!ADSContext.isRegistered(server2, registry2)) {
                    server2.updateAdsPropertiesWithServerProperties();
                    this.registerServer(adsCtx2, server2.getAdsProperties());
                }
                ctxSource = ctx2;
                ctxDestination = ctx1;
                adsCtxSource = adsCtx2;
            } else if (adsCtx1.hasAdminData() && !adsCtx2.hasAdminData()) {
                if (!this.hasAdministrator(adsCtx1.getDirContext(), uData)) {
                    adsCtx1.createAdministrator(this.getAdministratorProperties(uData));
                }
                server2.updateAdsPropertiesWithServerProperties();
                this.registerServer(adsCtx1, server2.getAdsProperties());
                registry1 = adsCtx1.readServerRegistry();
                if (!ADSContext.isRegistered(server1, registry1)) {
                    server1.updateAdsPropertiesWithServerProperties();
                    this.registerServer(adsCtx1, server1.getAdsProperties());
                }
                ctxSource = ctx1;
                ctxDestination = ctx2;
                adsCtxSource = adsCtx1;
            } else {
                adsCtx1.createAdminData(null);
                if (!this.hasAdministrator(ctx1, uData)) {
                    adsCtx1.createAdministrator(this.getAdministratorProperties(uData));
                }
                server1.updateAdsPropertiesWithServerProperties();
                adsCtx1.registerServer(server1.getAdsProperties());
                server2.updateAdsPropertiesWithServerProperties();
                adsCtx1.registerServer(server2.getAdsProperties());
                ctxSource = ctx1;
                ctxDestination = ctx2;
                adsCtxSource = adsCtx1;
            }
        }
        catch (ADSContextException adce) {
            throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_UPDATING_ADS.get(adce.getMessageObject()), ReplicationCliReturnCode.ERROR_UPDATING_ADS, adce);
        }
        if (!adsAlreadyReplicated && !adsMergeDone) {
            try {
                ServerDescriptor.seedAdsTrustStore(ctxDestination, adsCtxSource.getTrustedCertificates());
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Error seeding truststores: " + t, t);
                String arg = t instanceof OpenDsException ? ((OpenDsException)t).getMessageObject().toString() : t.toString();
                throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_ENABLE_SEEDING_TRUSTSTORE.get(ConnectionUtils.getHostPort(ctxDestination), ConnectionUtils.getHostPort(adsCtxSource.getDirContext()), arg), ReplicationCliReturnCode.ERROR_SEEDING_TRUSTORE, t);
            }
        }
        if (!adsMergeDone) {
            this.printProgress(this.formatter.getFormattedDone());
            this.printlnProgress();
        }
        LinkedList<String> baseDNs = uData.getBaseDNs();
        if (!adsAlreadyReplicated) {
            boolean found = false;
            for (String dn : baseDNs) {
                if (!Utils.areDnsEqual(dn, ADSContext.getAdministrationSuffixDN())) continue;
                found = true;
                break;
            }
            if (!found) {
                baseDNs.add(ADSContext.getAdministrationSuffixDN());
                uData.setBaseDNs(baseDNs);
            }
        }
        if (uData.replicateSchema()) {
            baseDNs = uData.getBaseDNs();
            baseDNs.add("cn=schema");
            uData.setBaseDNs(baseDNs);
        }
        TopologyCache cache1 = null;
        TopologyCache cache2 = null;
        try {
            LinkedHashSet<PreferredConnection> cnx = new LinkedHashSet<PreferredConnection>();
            cnx.addAll(PreferredConnection.getPreferredConnections(ctx1));
            cnx.addAll(PreferredConnection.getPreferredConnections(ctx2));
            if (adsCtx1.hasAdminData()) {
                cache1 = new TopologyCache(adsCtx1, this.getTrustManager());
                cache1.setPreferredConnections(cnx);
                cache1.getFilter().setSearchMonitoringInformation(false);
                for (String dn : uData.getBaseDNs()) {
                    cache1.getFilter().addBaseDNToSearch(dn);
                }
                cache1.reloadTopology();
                usedReplicationServerIds.addAll(this.getReplicationServerIds(cache1));
            }
            if (adsCtx2.hasAdminData()) {
                cache2 = new TopologyCache(adsCtx2, this.getTrustManager());
                cache2.setPreferredConnections(cnx);
                cache2.getFilter().setSearchMonitoringInformation(false);
                for (String dn : uData.getBaseDNs()) {
                    cache2.getFilter().addBaseDNToSearch(dn);
                }
                cache2.reloadTopology();
                usedReplicationServerIds.addAll(this.getReplicationServerIds(cache2));
            }
        }
        catch (ADSContextException adce) {
            throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_READING_ADS.get(adce.getMessage()), ReplicationCliReturnCode.ERROR_READING_ADS, adce);
        }
        catch (TopologyCacheException tce) {
            throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_READING_ADS.get(tce.getMessage()), ReplicationCliReturnCode.ERROR_READING_TOPOLOGY_CACHE, tce);
        }
        if (server1.isReplicationServer()) {
            twoReplServers.add(server1.getReplicationServerHostPort());
            usedReplicationServerIds.add(server1.getReplicationServerId());
        } else if (uData.configureReplicationServer1()) {
            twoReplServers.add(ServerDescriptor.getReplicationServer(ConnectionUtils.getHostName(ctx1), uData.getReplicationPort1()));
        }
        if (server2.isReplicationServer()) {
            twoReplServers.add(server2.getReplicationServerHostPort());
            usedReplicationServerIds.add(server2.getReplicationServerId());
        } else if (uData.configureReplicationServer2()) {
            twoReplServers.add(ServerDescriptor.getReplicationServer(ConnectionUtils.getHostName(ctx2), uData.getReplicationPort2()));
        }
        for (String baseDN : uData.getBaseDNs()) {
            LinkedHashSet<String> repServersForBaseDN = new LinkedHashSet<String>();
            repServersForBaseDN.addAll(this.getReplicationServers(baseDN, cache1, server1));
            repServersForBaseDN.addAll(this.getReplicationServers(baseDN, cache2, server2));
            repServersForBaseDN.addAll(twoReplServers);
            hmRepServers.put(baseDN, repServersForBaseDN);
            HashSet<Integer> ids = new HashSet<Integer>();
            ids.addAll(this.getReplicationDomainIds(baseDN, server1));
            ids.addAll(this.getReplicationDomainIds(baseDN, server2));
            if (cache1 != null) {
                for (ServerDescriptor server : cache1.getServers()) {
                    ids.addAll(this.getReplicationDomainIds(baseDN, server));
                }
            }
            if (cache2 != null) {
                for (ServerDescriptor server : cache2.getServers()) {
                    ids.addAll(this.getReplicationDomainIds(baseDN, server));
                }
            }
            hmUsedReplicationDomainIds.put(baseDN, ids);
        }
        for (LinkedHashSet v : hmRepServers.values()) {
            allRepServers.addAll(v);
        }
        HashSet<String> alreadyConfiguredReplicationServers = new HashSet<String>();
        if (!server1.isReplicationServer() && uData.configureReplicationServer1()) {
            try {
                this.configureAsReplicationServer(ctx1, uData.getReplicationPort1(), uData.isSecureReplication1(), allRepServers, usedReplicationServerIds);
            }
            catch (OpenDsException ode) {
                throw new ReplicationCliException(this.getMessageForReplicationServerException(ode, ConnectionUtils.getHostPort(ctx1)), ReplicationCliReturnCode.ERROR_CONFIGURING_REPLICATIONSERVER, ode);
            }
        }
        if (server1.isReplicationServer()) {
            try {
                this.updateReplicationServer(ctx1, allRepServers);
            }
            catch (OpenDsException ode) {
                throw new ReplicationCliException(this.getMessageForReplicationServerException(ode, ConnectionUtils.getHostPort(ctx1)), ReplicationCliReturnCode.ERROR_CONFIGURING_REPLICATIONSERVER, ode);
            }
            if (this.argParser.replicationPort1Arg.isPresent() && uData.getReplicationPort1() != server1.getReplicationServerPort()) {
                LOG.log(Level.WARNING, "Ignoring provided replication port for first server (already configured with port " + server1.getReplicationServerPort() + ")");
                this.println(AdminToolMessages.WARN_FIRST_REPLICATION_SERVER_ALREADY_CONFIGURED.get(server1.getReplicationServerPort(), uData.getReplicationPort1()));
            }
        }
        alreadyConfiguredReplicationServers.add(server1.getId());
        if (!server2.isReplicationServer() && uData.configureReplicationServer2()) {
            try {
                this.configureAsReplicationServer(ctx2, uData.getReplicationPort2(), uData.isSecureReplication2(), allRepServers, usedReplicationServerIds);
            }
            catch (OpenDsException ode) {
                throw new ReplicationCliException(this.getMessageForReplicationServerException(ode, ConnectionUtils.getHostPort(ctx1)), ReplicationCliReturnCode.ERROR_CONFIGURING_REPLICATIONSERVER, ode);
            }
        }
        if (server2.isReplicationServer()) {
            try {
                this.updateReplicationServer(ctx2, allRepServers);
            }
            catch (OpenDsException ode) {
                throw new ReplicationCliException(this.getMessageForReplicationServerException(ode, ConnectionUtils.getHostPort(ctx1)), ReplicationCliReturnCode.ERROR_CONFIGURING_REPLICATIONSERVER, ode);
            }
            if (this.argParser.replicationPort2Arg.isPresent() && uData.getReplicationPort2() != server2.getReplicationServerPort()) {
                LOG.log(Level.WARNING, "Ignoring provided replication port for second server (already configured with port " + server2.getReplicationServerPort() + ")");
                this.println(AdminToolMessages.WARN_SECOND_REPLICATION_SERVER_ALREADY_CONFIGURED.get(server2.getReplicationServerPort(), uData.getReplicationPort2()));
            }
        }
        alreadyConfiguredReplicationServers.add(server2.getId());
        for (String baseDN : uData.getBaseDNs()) {
            LinkedHashSet repServers = (LinkedHashSet)hmRepServers.get(baseDN);
            Set usedIds = (Set)hmUsedReplicationDomainIds.get(baseDN);
            HashSet<String> alreadyConfiguredServers = new HashSet<String>();
            if (uData.configureReplicationDomain1() || Utils.areDnsEqual(baseDN, ADSContext.getAdministrationSuffixDN())) {
                try {
                    this.configureToReplicateBaseDN(ctx1, baseDN, repServers, usedIds);
                }
                catch (OpenDsException ode) {
                    Message msg = this.getMessageForEnableException(ode, ConnectionUtils.getHostPort(ctx1), baseDN);
                    throw new ReplicationCliException(msg, ReplicationCliReturnCode.ERROR_ENABLING_REPLICATION_ON_BASEDN, ode);
                }
            }
            alreadyConfiguredServers.add(server1.getId());
            if (uData.configureReplicationDomain2() || Utils.areDnsEqual(baseDN, ADSContext.getAdministrationSuffixDN())) {
                try {
                    this.configureToReplicateBaseDN(ctx2, baseDN, repServers, usedIds);
                }
                catch (OpenDsException ode) {
                    Message msg = this.getMessageForEnableException(ode, ConnectionUtils.getHostPort(ctx2), baseDN);
                    throw new ReplicationCliException(msg, ReplicationCliReturnCode.ERROR_ENABLING_REPLICATION_ON_BASEDN, ode);
                }
            }
            alreadyConfiguredServers.add(server2.getId());
            if (cache1 != null) {
                this.configureToReplicateBaseDN(baseDN, repServers, usedIds, cache1, server1, alreadyConfiguredServers, allRepServers, alreadyConfiguredReplicationServers);
            }
            if (cache2 == null) continue;
            this.configureToReplicateBaseDN(baseDN, repServers, usedIds, cache2, server2, alreadyConfiguredServers, allRepServers, alreadyConfiguredReplicationServers);
        }
        if (adsMergeDone) {
            pointAdder = new ConsoleApplication.PointAdder(this);
            this.printProgress(AdminToolMessages.INFO_ENABLE_REPLICATION_INITIALIZING_ADS_ALL.get(ConnectionUtils.getHostPort(ctxSource)));
            pointAdder.start();
            try {
                this.initializeAllSuffix(ADSContext.getAdministrationSuffixDN(), ctxSource, false);
            }
            finally {
                pointAdder.stop();
            }
            this.printProgress(this.formatter.getSpace());
            this.printProgress(this.formatter.getFormattedDone());
            this.printlnProgress();
        } else if (ctxSource != null && ctxDestination != null) {
            this.printProgress(this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_ENABLE_REPLICATION_INITIALIZING_ADS.get(ConnectionUtils.getHostPort(ctxDestination), ConnectionUtils.getHostPort(ctxSource))));
            this.initializeSuffix(ADSContext.getAdministrationSuffixDN(), ctxSource, ctxDestination, false);
            this.printProgress(this.formatter.getFormattedDone());
            this.printlnProgress();
        }
        if (this.mustInitializeSchema(server1, server2, uData)) {
            if (this.argParser.useSecondServerAsSchemaSource()) {
                ctxSource = ctx2;
                ctxDestination = ctx1;
            } else {
                ctxSource = ctx1;
                ctxDestination = ctx2;
            }
            if (adsMergeDone) {
                pointAdder = new ConsoleApplication.PointAdder(this);
                this.printProgress(AdminToolMessages.INFO_ENABLE_REPLICATION_INITIALIZING_SCHEMA.get(ConnectionUtils.getHostPort(ctxDestination), ConnectionUtils.getHostPort(ctxSource)));
                pointAdder.start();
                try {
                    this.initializeAllSuffix("cn=schema", ctxSource, false);
                }
                finally {
                    pointAdder.stop();
                }
                this.printProgress(this.formatter.getSpace());
            } else {
                this.printProgress(this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_ENABLE_REPLICATION_INITIALIZING_SCHEMA.get(ConnectionUtils.getHostPort(ctxDestination), ConnectionUtils.getHostPort(ctxSource))));
                this.initializeSuffix("cn=schema", ctxSource, ctxDestination, false);
            }
            this.printProgress(this.formatter.getFormattedDone());
            this.printlnProgress();
        }
    }

    private void updateConfiguration(InitialLdapContext ctx, DisableReplicationUserData uData) throws ReplicationCliException {
        boolean disableAllBaseDns;
        boolean adsReplicated;
        boolean schemaReplicated;
        boolean forceDisableADS;
        boolean forceDisableSchema;
        boolean disableReplicationServer;
        TopologyCache cache;
        ADSContext adsCtx;
        ServerDescriptor server;
        block81: {
            TopologyCacheFilter filter = new TopologyCacheFilter();
            filter.setSearchMonitoringInformation(false);
            if (!uData.disableAll()) {
                filter.addBaseDNToSearch(ADSContext.getAdministrationSuffixDN());
                for (String dn : uData.getBaseDNs()) {
                    filter.addBaseDNToSearch(dn);
                }
            }
            try {
                server = ServerDescriptor.createStandalone(ctx, filter);
            }
            catch (NamingException ne) {
                throw new ReplicationCliException(this.getMessageForException(ne, ConnectionUtils.getHostPort(ctx)), ReplicationCliReturnCode.ERROR_READING_CONFIGURATION, ne);
            }
            adsCtx = new ADSContext(ctx);
            cache = null;
            boolean tryToUpdateRemote = uData.getAdminUid() != null;
            try {
                if (adsCtx.hasAdminData() && tryToUpdateRemote) {
                    cache = new TopologyCache(adsCtx, this.getTrustManager());
                    cache.setPreferredConnections(PreferredConnection.getPreferredConnections(ctx));
                    cache.getFilter().setSearchMonitoringInformation(false);
                    if (!uData.disableAll()) {
                        for (String dn : uData.getBaseDNs()) {
                            cache.getFilter().addBaseDNToSearch(dn);
                        }
                    }
                    cache.reloadTopology();
                }
            }
            catch (ADSContextException adce) {
                throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_READING_ADS.get(adce.getMessage()), ReplicationCliReturnCode.ERROR_READING_ADS, adce);
            }
            catch (TopologyCacheException tce) {
                throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_READING_ADS.get(tce.getMessage()), ReplicationCliReturnCode.ERROR_READING_TOPOLOGY_CACHE, tce);
            }
            if (!this.argParser.isInteractive()) {
                LinkedHashSet<Message> messages = new LinkedHashSet<Message>();
                if (cache != null) {
                    messages.addAll(cache.getErrorMessages());
                }
                if (!messages.isEmpty()) {
                    this.println(AdminToolMessages.ERR_REPLICATION_READING_REGISTERED_SERVERS_WARNING.get(Utils.getMessageFromCollection(messages, Constants.LINE_SEPARATOR).toString()));
                }
            }
            disableReplicationServer = false;
            if (server.isReplicationServer() && (uData.disableReplicationServer() || uData.disableAll())) {
                disableReplicationServer = true;
            }
            if (cache != null && disableReplicationServer) {
                String arg;
                String replicationServer = server.getReplicationServerHostPort();
                TreeSet<SuffixDescriptor> lastRepServer = new TreeSet<SuffixDescriptor>(new SuffixComparator());
                TreeSet<SuffixDescriptor> beforeLastRepServer = new TreeSet<SuffixDescriptor>(new SuffixComparator());
                for (SuffixDescriptor suffix : cache.getSuffixes()) {
                    Set<String> repServers;
                    if (Utils.areDnsEqual(suffix.getDN(), ADSContext.getAdministrationSuffixDN()) || Utils.areDnsEqual(suffix.getDN(), "cn=schema") || (repServers = suffix.getReplicationServers()).size() > 2) continue;
                    boolean found = false;
                    for (String repServer : repServers) {
                        if (!repServer.equalsIgnoreCase(replicationServer)) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    if (repServers.size() == 2) {
                        beforeLastRepServer.add(suffix);
                        continue;
                    }
                    lastRepServer.add(suffix);
                }
                if (beforeLastRepServer.size() > 0) {
                    LinkedHashSet<String> baseDNs = new LinkedHashSet<String>();
                    for (SuffixDescriptor suffix : beforeLastRepServer) {
                        if (Utils.areDnsEqual(suffix.getDN(), ADSContext.getAdministrationSuffixDN()) || Utils.areDnsEqual(suffix.getDN(), "cn=schema")) continue;
                        baseDNs.add(suffix.getDN());
                    }
                    if (!baseDNs.isEmpty()) {
                        arg = Utils.getStringFromCollection(baseDNs, Constants.LINE_SEPARATOR);
                        if (!this.isInteractive()) {
                            this.println(AdminToolMessages.INFO_DISABLE_REPLICATION_ONE_POINT_OF_FAILURE.get(arg));
                        } else {
                            try {
                                if (!this.askConfirmation(AdminToolMessages.INFO_DISABLE_REPLICATION_ONE_POINT_OF_FAILURE_PROMPT.get(arg), false, LOG)) {
                                    throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_USER_CANCELLED.get(), ReplicationCliReturnCode.USER_CANCELLED, null);
                                }
                            }
                            catch (CLIException ce) {
                                this.println(ce.getMessageObject());
                                throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_USER_CANCELLED.get(), ReplicationCliReturnCode.USER_CANCELLED, null);
                            }
                        }
                    }
                }
                if (lastRepServer.size() > 0) {
                    LinkedHashSet<String> suffixArg = new LinkedHashSet<String>();
                    for (SuffixDescriptor suffix : lastRepServer) {
                        TreeSet<ServerDescriptor> servers;
                        boolean baseDNSpecified = false;
                        for (String baseDN : uData.getBaseDNs()) {
                            if (Utils.areDnsEqual(baseDN, ADSContext.getAdministrationSuffixDN()) || Utils.areDnsEqual(baseDN, "cn=schema") || !Utils.areDnsEqual(baseDN, suffix.getDN())) continue;
                            baseDNSpecified = true;
                            break;
                        }
                        if (!baseDNSpecified) {
                            servers = new TreeSet<ServerDescriptor>(new ServerComparator());
                            for (ReplicaDescriptor replica : suffix.getReplicas()) {
                                servers.add(replica.getServer());
                            }
                            suffixArg.add(ServerDescriptor.getSuffixDisplay(suffix.getDN(), servers));
                            continue;
                        }
                        if (suffix.getReplicas().size() <= 1) continue;
                        servers = new TreeSet<ServerDescriptor>(new ServerComparator());
                        for (ReplicaDescriptor replica : suffix.getReplicas()) {
                            if (replica.getServer().isSameServer(server)) continue;
                            servers.add(replica.getServer());
                        }
                        if (servers.isEmpty()) continue;
                        suffixArg.add(ServerDescriptor.getSuffixDisplay(suffix.getDN(), servers));
                    }
                    if (!suffixArg.isEmpty()) {
                        arg = Utils.getStringFromCollection(suffixArg, Constants.LINE_SEPARATOR);
                        if (!this.isInteractive()) {
                            this.println(AdminToolMessages.INFO_DISABLE_REPLICATION_DISABLE_IN_REMOTE.get(arg));
                        } else {
                            try {
                                if (!this.askConfirmation(AdminToolMessages.INFO_DISABLE_REPLICATION_DISABLE_IN_REMOTE_PROMPT.get(arg), false, LOG)) {
                                    throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_USER_CANCELLED.get(), ReplicationCliReturnCode.USER_CANCELLED, null);
                                }
                            }
                            catch (CLIException ce) {
                                this.println(ce.getMessageObject());
                                throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_USER_CANCELLED.get(), ReplicationCliReturnCode.USER_CANCELLED, null);
                            }
                        }
                    }
                }
            }
            forceDisableSchema = false;
            forceDisableADS = false;
            schemaReplicated = false;
            adsReplicated = false;
            disableAllBaseDns = this.disableAllBaseDns(ctx, uData);
            Collection<ReplicaDescriptor> replicas = this.getReplicas(ctx);
            for (ReplicaDescriptor rep : replicas) {
                String dn = rep.getSuffix().getDN();
                if (!rep.isReplicated()) continue;
                if (Utils.areDnsEqual(ADSContext.getAdministrationSuffixDN(), dn)) {
                    adsReplicated = true;
                    continue;
                }
                if (!Utils.areDnsEqual("cn=schema", dn)) continue;
                schemaReplicated = true;
            }
            if (disableAllBaseDns && (disableReplicationServer || !server.isReplicationServer())) {
                server.updateAdsPropertiesWithServerProperties();
                try {
                    adsCtx.unregisterServer(server.getAdsProperties());
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Throwable t) {}
                }
                catch (ADSContextException adce) {
                    LOG.log(Level.SEVERE, "Error unregistering server: " + server.getAdsProperties(), adce);
                    if (adce.getError() == ADSContextException.ErrorType.NOT_YET_REGISTERED) break block81;
                    throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_UPDATING_ADS.get(adce.getMessageObject()), ReplicationCliReturnCode.ERROR_READING_ADS, adce);
                }
            }
        }
        HashSet<String> suffixesToDisable = new HashSet<String>();
        if (uData.disableAll()) {
            for (ReplicaDescriptor replica : server.getReplicas()) {
                if (!replica.isReplicated()) continue;
                suffixesToDisable.add(replica.getSuffix().getDN());
            }
        } else {
            suffixesToDisable.addAll(uData.getBaseDNs());
            if (disableAllBaseDns && (disableReplicationServer || !server.isReplicationServer())) {
                forceDisableSchema = schemaReplicated;
                forceDisableADS = adsReplicated;
            }
            for (String dn : uData.getBaseDNs()) {
                if (Utils.areDnsEqual(ADSContext.getAdministrationSuffixDN(), dn)) {
                    forceDisableADS = false;
                    continue;
                }
                if (!Utils.areDnsEqual("cn=schema", dn)) continue;
                forceDisableSchema = false;
            }
            if (forceDisableSchema) {
                suffixesToDisable.add("cn=schema");
            }
            if (forceDisableADS) {
                suffixesToDisable.add(ADSContext.getAdministrationSuffixDN());
            }
        }
        String replicationServerHostPort = null;
        if (server.isReplicationServer()) {
            replicationServerHostPort = server.getReplicationServerHostPort();
        }
        boolean replicationServerDisabled = false;
        for (String baseDN : suffixesToDisable) {
            try {
                this.deleteReplicationDomain(ctx, baseDN);
            }
            catch (OpenDsException ode) {
                Message msg = this.getMessageForDisableException(ode, ConnectionUtils.getHostPort(ctx), baseDN);
                throw new ReplicationCliException(msg, ReplicationCliReturnCode.ERROR_DISABLING_REPLICATION_ON_BASEDN, ode);
            }
        }
        if (replicationServerHostPort != null && cache != null) {
            LinkedHashSet<ServerDescriptor> serversToUpdate = new LinkedHashSet<ServerDescriptor>();
            HashSet<String> baseDNsToUpdate = new HashSet<String>(suffixesToDisable);
            for (String baseDN : baseDNsToUpdate) {
                SuffixDescriptor suffix = this.getSuffix(baseDN, cache, server);
                if (suffix == null) continue;
                for (ReplicaDescriptor replica : suffix.getReplicas()) {
                    serversToUpdate.add(replica.getServer());
                }
            }
            if (disableReplicationServer) {
                Set<SuffixDescriptor> suffixes = cache.getSuffixes();
                for (SuffixDescriptor suffix : suffixes) {
                    String repServer;
                    boolean found = false;
                    Iterator<Object> i$ = suffix.getReplicationServers().iterator();
                    while (i$.hasNext() && !(found = (repServer = i$.next()).equalsIgnoreCase(replicationServerHostPort))) {
                    }
                    if (!found) continue;
                    baseDNsToUpdate.add(suffix.getDN());
                    for (ReplicaDescriptor replica : suffix.getReplicas()) {
                        serversToUpdate.add(replica.getServer());
                    }
                }
            }
            String bindDn = ConnectionUtils.getBindDN(ctx);
            String pwd = ConnectionUtils.getBindPassword(ctx);
            for (ServerDescriptor s : serversToUpdate) {
                this.removeReferencesInServer(s, replicationServerHostPort, bindDn, pwd, baseDNsToUpdate, disableReplicationServer, PreferredConnection.getPreferredConnections(ctx));
            }
            if (disableReplicationServer) {
                this.disableReplicationServer(ctx);
                replicationServerDisabled = true;
                try {
                    Thread.sleep(5000L);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        if (disableReplicationServer && !replicationServerDisabled) {
            this.disableReplicationServer(ctx);
            replicationServerDisabled = true;
        }
        if (uData.disableAll()) {
            try {
                this.printProgress(this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_REPLICATION_REMOVE_ADS_CONTENTS.get()));
                adsCtx.removeAdminData();
                String adminBackendName = null;
                for (ReplicaDescriptor replica : server.getReplicas()) {
                    if (!Utils.areDnsEqual(ADSContext.getAdministrationSuffixDN(), replica.getSuffix().getDN())) continue;
                    adminBackendName = replica.getBackendName();
                    break;
                }
                adsCtx.createAdminData(adminBackendName);
                this.printProgress(this.formatter.getFormattedDone());
                this.printlnProgress();
            }
            catch (ADSContextException adce) {
                LOG.log(Level.SEVERE, "Error removing contents of cn=admin data: " + adce, adce);
                throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_UPDATING_ADS.get(adce.getMessageObject()), ReplicationCliReturnCode.ERROR_UPDATING_ADS, adce);
            }
            try {
                this.printProgress(this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_REPLICATION_REMOVE_TRUSTSTORE_CONTENTS.get()));
                ServerDescriptor.cleanAdsTrustStore(adsCtx.getDirContext());
                this.printProgress(this.formatter.getFormattedDone());
                this.printlnProgress();
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Error removing contents of truststore: " + t, t);
                throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_UPDATING_ADS.get(t.toString()), ReplicationCliReturnCode.ERROR_UPDATING_ADS, t);
            }
        }
        if (disableAllBaseDns && (disableReplicationServer || !server.isReplicationServer())) {
            try {
                Set<Map<ADSContext.ServerProperty, Object>> registry = adsCtx.readServerRegistry();
                for (Map<ADSContext.ServerProperty, Object> s : registry) {
                    adsCtx.unregisterServer(s);
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (Throwable t) {}
            }
            catch (ADSContextException adce) {
                LOG.log(Level.WARNING, "Error unregistering server: " + server.getAdsProperties(), adce);
            }
        }
    }

    private void displayStatus(InitialLdapContext ctx, StatusReplicationUserData uData) throws ReplicationCliException {
        ADSContext adsCtx = new ADSContext(ctx);
        boolean somethingDisplayed = false;
        TopologyCache cache = null;
        try {
            cache = new TopologyCache(adsCtx, this.getTrustManager());
            cache.setPreferredConnections(PreferredConnection.getPreferredConnections(ctx));
            for (String dn : uData.getBaseDNs()) {
                cache.getFilter().addBaseDNToSearch(dn);
            }
            cache.reloadTopology();
        }
        catch (TopologyCacheException tce) {
            throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_READING_ADS.get(tce.getMessage()), ReplicationCliReturnCode.ERROR_READING_TOPOLOGY_CACHE, tce);
        }
        if (this.mustPrintCommandBuilder()) {
            try {
                CommandBuilder commandBuilder = this.createCommandBuilder("status", uData);
                this.printCommandBuilder(commandBuilder);
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Error printing equivalente command-line: " + t, t);
            }
        }
        if (!this.argParser.isInteractive()) {
            LinkedHashSet<Message> messages = new LinkedHashSet<Message>();
            if (cache != null) {
                messages.addAll(cache.getErrorMessages());
            }
            if (!messages.isEmpty()) {
                Message msg = AdminToolMessages.ERR_REPLICATION_STATUS_READING_REGISTERED_SERVERS.get(Utils.getMessageFromCollection(messages, Constants.LINE_SEPARATOR).toString());
                this.println(msg);
            }
        }
        LinkedList<String> userBaseDNs = uData.getBaseDNs();
        LinkedList<Set<ReplicaDescriptor>> replicaLists = new LinkedList<Set<ReplicaDescriptor>>();
        boolean oneReplicated = false;
        boolean displayAll = userBaseDNs.isEmpty();
        for (SuffixDescriptor suffix : cache.getSuffixes()) {
            String baseDN;
            String string = suffix.getDN();
            boolean found = displayAll && !Utils.areDnsEqual(string, ADSContext.getAdministrationSuffixDN()) && !Utils.areDnsEqual(string, "cn=schema") && !Utils.areDnsEqual(string, "dc=replicationChanges");
            Iterator i$ = userBaseDNs.iterator();
            while (i$.hasNext() && !(found = Utils.areDnsEqual(baseDN = (String)i$.next(), string))) {
            }
            if (!found) continue;
            boolean replicated = false;
            for (ReplicaDescriptor replicaDescriptor : suffix.getReplicas()) {
                if (!replicaDescriptor.isReplicated()) continue;
                replicated = true;
                break;
            }
            if (replicated) {
                oneReplicated = true;
                replicaLists.add(suffix.getReplicas());
                continue;
            }
            found = false;
            for (Set set : replicaLists) {
                ReplicaDescriptor replica = (ReplicaDescriptor)set.iterator().next();
                if (replica.isReplicated() || !Utils.areDnsEqual(string, replica.getSuffix().getDN())) continue;
                set.addAll(suffix.getReplicas());
                found = true;
                break;
            }
            if (found) continue;
            replicaLists.add(suffix.getReplicas());
        }
        if (!oneReplicated && displayAll) {
            TreeSet<ServerDescriptor> rServers = new TreeSet<ServerDescriptor>(new ReplicationServerComparator());
            for (ServerDescriptor serverDescriptor : cache.getServers()) {
                if (!serverDescriptor.isReplicationServer()) continue;
                rServers.add(serverDescriptor);
            }
            if (!rServers.isEmpty()) {
                this.displayStatus(rServers, uData.isScriptFriendly(), PreferredConnection.getPreferredConnections(ctx));
                somethingDisplayed = true;
            }
        }
        if (!replicaLists.isEmpty()) {
            LinkedList<Set> orderedReplicaLists = new LinkedList<Set>();
            for (Set set : replicaLists) {
                String dn1 = ((ReplicaDescriptor)set.iterator().next()).getSuffix().getDN();
                boolean inserted = false;
                for (int i = 0; i < orderedReplicaLists.size() && !inserted; ++i) {
                    String string = ((ReplicaDescriptor)((Set)orderedReplicaLists.get(i)).iterator().next()).getSuffix().getDN();
                    if (dn1.compareTo(string) >= 0) continue;
                    orderedReplicaLists.add(i, set);
                    inserted = true;
                }
                if (inserted) continue;
                orderedReplicaLists.add(set);
            }
            HashSet<ReplicaDescriptor> replicasWithNoReplicationServer = new HashSet<ReplicaDescriptor>();
            HashSet<ServerDescriptor> hashSet = new HashSet<ServerDescriptor>();
            for (Set replicas : orderedReplicaLists) {
                this.printlnProgress();
                this.displayStatus(replicas, uData.isScriptFriendly(), PreferredConnection.getPreferredConnections(ctx), cache.getServers(), replicasWithNoReplicationServer, hashSet);
                somethingDisplayed = true;
            }
            if (oneReplicated && !uData.isScriptFriendly()) {
                this.printlnProgress();
                this.printProgress(AdminToolMessages.INFO_REPLICATION_STATUS_REPLICATED_LEGEND.get());
                if (!replicasWithNoReplicationServer.isEmpty() || !hashSet.isEmpty()) {
                    this.printlnProgress();
                    this.printProgress(AdminToolMessages.INFO_REPLICATION_STATUS_NOT_A_REPLICATION_SERVER_LEGEND.get());
                    this.printlnProgress();
                    this.printProgress(AdminToolMessages.INFO_REPLICATION_STATUS_NOT_A_REPLICATION_DOMAIN_LEGEND.get());
                }
                this.printlnProgress();
                somethingDisplayed = true;
            }
        }
        if (!somethingDisplayed) {
            if (displayAll) {
                this.printProgress(AdminToolMessages.INFO_REPLICATION_STATUS_NO_REPLICATION_INFORMATION.get());
                this.printlnProgress();
            } else {
                this.printProgress(AdminToolMessages.INFO_REPLICATION_STATUS_NO_BASEDNS.get());
                this.printlnProgress();
            }
        }
    }

    private void displayStatus(Set<ReplicaDescriptor> replicas, boolean scriptFriendly, LinkedHashSet<PreferredConnection> cnx, Set<ServerDescriptor> servers, Set<ReplicaDescriptor> replicasWithNoReplicationServer, Set<ServerDescriptor> serversWithNoReplica) {
        Message v;
        int j;
        boolean isReplicated = false;
        LinkedHashSet<ReplicaDescriptor> orderedReplicas = new LinkedHashSet<ReplicaDescriptor>();
        TreeSet<String> hostPorts = new TreeSet<String>();
        TreeSet<ServerDescriptor> notAddedReplicationServers = new TreeSet<ServerDescriptor>(new ReplicationServerComparator());
        for (ReplicaDescriptor replica : replicas) {
            if (replica.isReplicated()) {
                isReplicated = true;
            }
            hostPorts.add(this.getHostPort(replica.getServer(), cnx));
        }
        for (String hostPort : hostPorts) {
            for (ReplicaDescriptor replica : replicas) {
                if (!this.getHostPort(replica.getServer(), cnx).equals(hostPort)) continue;
                orderedReplicas.add(replica);
            }
        }
        for (ServerDescriptor server : servers) {
            if (!server.isReplicationServer()) continue;
            boolean isDomain = false;
            boolean isRepServer = false;
            String replicationServer = server.getReplicationServerHostPort();
            for (ReplicaDescriptor replica : replicas) {
                if (!isRepServer) {
                    Set<String> repServers = replica.getReplicationServers();
                    for (String repServer : repServers) {
                        if (!replicationServer.equalsIgnoreCase(repServer)) continue;
                        isRepServer = true;
                    }
                }
                if (replica.getServer() == server) {
                    isDomain = true;
                }
                if (!isDomain || !isRepServer) continue;
                break;
            }
            if (isDomain || !isRepServer) continue;
            notAddedReplicationServers.add(server);
        }
        boolean SERVERPORT = false;
        boolean NUMBER_ENTRIES = true;
        int MISSING_CHANGES = 2;
        int AGE_OF_OLDEST_MISSING_CHANGE = 3;
        int REPLICATION_PORT = 4;
        int SECURE = 5;
        Message[] headers = scriptFriendly ? (isReplicated ? new Message[]{AdminToolMessages.INFO_REPLICATION_STATUS_LABEL_SERVERPORT.get(), AdminToolMessages.INFO_REPLICATION_STATUS_LABEL_NUMBER_ENTRIES.get(), AdminToolMessages.INFO_REPLICATION_STATUS_LABEL_MISSING_CHANGES.get(), AdminToolMessages.INFO_REPLICATION_STATUS_LABEL_AGE_OF_OLDEST_MISSING_CHANGE.get(), AdminToolMessages.INFO_REPLICATION_STATUS_LABEL_REPLICATION_PORT.get(), AdminToolMessages.INFO_REPLICATION_STATUS_LABEL_SECURE.get()} : new Message[]{AdminToolMessages.INFO_REPLICATION_STATUS_LABEL_SERVERPORT.get(), AdminToolMessages.INFO_REPLICATION_STATUS_LABEL_NUMBER_ENTRIES.get()}) : (isReplicated ? new Message[]{AdminToolMessages.INFO_REPLICATION_STATUS_HEADER_SERVERPORT.get(), AdminToolMessages.INFO_REPLICATION_STATUS_HEADER_NUMBER_ENTRIES.get(), AdminToolMessages.INFO_REPLICATION_STATUS_HEADER_MISSING_CHANGES.get(), AdminToolMessages.INFO_REPLICATION_STATUS_HEADER_AGE_OF_OLDEST_MISSING_CHANGE.get(), AdminToolMessages.INFO_REPLICATION_STATUS_HEADER_REPLICATION_PORT.get(), AdminToolMessages.INFO_REPLICATION_STATUS_HEADER_SECURE.get()} : new Message[]{AdminToolMessages.INFO_REPLICATION_STATUS_HEADER_SERVERPORT.get(), AdminToolMessages.INFO_REPLICATION_STATUS_HEADER_NUMBER_ENTRIES.get()});
        Message[][] values = new Message[notAddedReplicationServers.size() + orderedReplicas.size()][headers.length];
        int i = 0;
        for (ServerDescriptor server : notAddedReplicationServers) {
            serversWithNoReplica.add(server);
            for (j = 0; j < headers.length; ++j) {
                switch (j) {
                    case 0: {
                        v = Message.raw(this.getHostPort(server, cnx), new Object[0]);
                        break;
                    }
                    case 1: {
                        if (scriptFriendly) {
                            v = AdminToolMessages.INFO_REPLICATION_STATUS_NOT_A_REPLICATION_DOMAIN_LONG.get();
                            break;
                        }
                        v = AdminToolMessages.INFO_REPLICATION_STATUS_NOT_A_REPLICATION_DOMAIN_SHORT.get();
                        break;
                    }
                    case 2: {
                        v = AdminToolMessages.INFO_NOT_APPLICABLE_LABEL.get();
                        break;
                    }
                    case 3: {
                        v = AdminToolMessages.INFO_NOT_APPLICABLE_LABEL.get();
                        break;
                    }
                    case 4: {
                        int replicationPort = server.getReplicationServerPort();
                        if (replicationPort >= 0) {
                            v = Message.raw(String.valueOf(replicationPort), new Object[0]);
                            break;
                        }
                        v = AdminToolMessages.INFO_NOT_AVAILABLE_SHORT_LABEL.get();
                        break;
                    }
                    case 5: {
                        if (server.isReplicationSecure()) {
                            v = AdminToolMessages.INFO_REPLICATION_STATUS_SECURITY_ENABLED.get();
                            break;
                        }
                        v = AdminToolMessages.INFO_REPLICATION_STATUS_SECURITY_DISABLED.get();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown index: " + j);
                    }
                }
                values[i][j] = v;
            }
            ++i;
        }
        for (ReplicaDescriptor replica : orderedReplicas) {
            for (j = 0; j < headers.length; ++j) {
                switch (j) {
                    case 0: {
                        v = Message.raw(this.getHostPort(replica.getServer(), cnx), new Object[0]);
                        break;
                    }
                    case 1: {
                        int nEntries = replica.getEntries();
                        if (nEntries >= 0) {
                            v = Message.raw(String.valueOf(nEntries), new Object[0]);
                            break;
                        }
                        v = AdminToolMessages.INFO_NOT_AVAILABLE_SHORT_LABEL.get();
                        break;
                    }
                    case 2: {
                        int missingChanges = replica.getMissingChanges();
                        if (missingChanges >= 0) {
                            v = Message.raw(String.valueOf(missingChanges), new Object[0]);
                            break;
                        }
                        v = AdminToolMessages.INFO_NOT_AVAILABLE_SHORT_LABEL.get();
                        break;
                    }
                    case 3: {
                        long ageOfOldestMissingChange = replica.getAgeOfOldestMissingChange();
                        if (ageOfOldestMissingChange > 0L) {
                            Date date = new Date(ageOfOldestMissingChange);
                            v = Message.raw(date.toString(), new Object[0]);
                            break;
                        }
                        v = AdminToolMessages.INFO_NOT_AVAILABLE_SHORT_LABEL.get();
                        break;
                    }
                    case 4: {
                        int replicationPort = replica.getServer().getReplicationServerPort();
                        if (!replica.getServer().isReplicationServer()) {
                            v = scriptFriendly ? AdminToolMessages.INFO_REPLICATION_STATUS_NOT_A_REPLICATION_SERVER_LONG.get() : AdminToolMessages.INFO_REPLICATION_STATUS_NOT_A_REPLICATION_SERVER_SHORT.get();
                            replicasWithNoReplicationServer.add(replica);
                            break;
                        }
                        if (replicationPort >= 0) {
                            v = Message.raw(String.valueOf(replicationPort), new Object[0]);
                            break;
                        }
                        v = AdminToolMessages.INFO_NOT_AVAILABLE_SHORT_LABEL.get();
                        break;
                    }
                    case 5: {
                        if (!replica.getServer().isReplicationServer()) {
                            v = AdminToolMessages.INFO_NOT_APPLICABLE_LABEL.get();
                            break;
                        }
                        if (replica.getServer().isReplicationSecure()) {
                            v = AdminToolMessages.INFO_REPLICATION_STATUS_SECURITY_ENABLED.get();
                            break;
                        }
                        v = AdminToolMessages.INFO_REPLICATION_STATUS_SECURITY_DISABLED.get();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown index: " + j);
                    }
                }
                values[i][j] = v;
            }
            ++i;
        }
        String dn = replicas.iterator().next().getSuffix().getDN();
        if (scriptFriendly) {
            Message[] labels = new Message[]{AdminToolMessages.INFO_REPLICATION_STATUS_BASEDN.get(), AdminToolMessages.INFO_REPLICATION_STATUS_IS_REPLICATED.get()};
            Message[] vs = new Message[]{Message.raw(dn, new Object[0]), isReplicated ? AdminToolMessages.INFO_BASEDN_REPLICATED_LABEL.get() : AdminToolMessages.INFO_BASEDN_NOT_REPLICATED_LABEL.get()};
            for (i = 0; i < labels.length; ++i) {
                this.printProgress(Message.raw(labels[i] + " " + vs[i], new Object[0]));
                this.printlnProgress();
            }
            for (i = 0; i < values.length; ++i) {
                this.printProgress(Message.raw("-", new Object[0]));
                this.printlnProgress();
                for (j = 0; j < values[i].length; ++j) {
                    this.printProgress(Message.raw(headers[j] + " " + values[i][j], new Object[0]));
                    this.printlnProgress();
                }
            }
        } else {
            Message msg = isReplicated ? AdminToolMessages.INFO_REPLICATION_STATUS_REPLICATED.get(dn) : AdminToolMessages.INFO_REPLICATION_STATUS_NOT_REPLICATED.get(dn);
            this.printProgressMessageNoWrap(msg);
            this.printlnProgress();
            int length = msg.length();
            StringBuffer buf = new StringBuffer();
            for (i = 0; i < length; ++i) {
                buf.append("=");
            }
            this.printProgressMessageNoWrap(Message.raw(buf.toString(), new Object[0]));
            this.printlnProgress();
            TableBuilder table = new TableBuilder();
            for (i = 0; i < headers.length; ++i) {
                table.appendHeading(headers[i]);
            }
            for (i = 0; i < values.length; ++i) {
                table.startRow();
                for (int j2 = 0; j2 < headers.length; ++j2) {
                    table.appendCell(values[i][j2]);
                }
            }
            TextTablePrinter printer = new TextTablePrinter(this.getOutputStream());
            printer.setColumnSeparator(":");
            table.print(printer);
        }
    }

    private void displayStatus(Set<ServerDescriptor> servers, boolean scriptFriendly, LinkedHashSet<PreferredConnection> cnx) {
        boolean SERVERPORT = false;
        boolean REPLICATION_PORT = true;
        int SECURE = 2;
        Message[] headers = scriptFriendly ? new Message[]{AdminToolMessages.INFO_REPLICATION_STATUS_LABEL_SERVERPORT.get(), AdminToolMessages.INFO_REPLICATION_STATUS_LABEL_REPLICATION_PORT.get(), AdminToolMessages.INFO_REPLICATION_STATUS_LABEL_SECURE.get()} : new Message[]{AdminToolMessages.INFO_REPLICATION_STATUS_HEADER_SERVERPORT.get(), AdminToolMessages.INFO_REPLICATION_STATUS_HEADER_REPLICATION_PORT.get(), AdminToolMessages.INFO_REPLICATION_STATUS_HEADER_SECURE.get()};
        Message[][] values = new Message[servers.size()][headers.length];
        int i = 0;
        for (ServerDescriptor server : servers) {
            for (int j = 0; j < headers.length; ++j) {
                Message v;
                switch (j) {
                    case 0: {
                        v = Message.raw(this.getHostPort(server, cnx), new Object[0]);
                        break;
                    }
                    case 1: {
                        int replicationPort = server.getReplicationServerPort();
                        if (replicationPort >= 0) {
                            v = Message.raw(String.valueOf(replicationPort), new Object[0]);
                            break;
                        }
                        v = AdminToolMessages.INFO_NOT_AVAILABLE_SHORT_LABEL.get();
                        break;
                    }
                    case 2: {
                        if (server.isReplicationSecure()) {
                            v = AdminToolMessages.INFO_REPLICATION_STATUS_SECURITY_ENABLED.get();
                            break;
                        }
                        v = AdminToolMessages.INFO_REPLICATION_STATUS_SECURITY_DISABLED.get();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown index: " + j);
                    }
                }
                values[i][j] = v;
            }
            ++i;
        }
        if (scriptFriendly) {
            this.printProgress(AdminToolMessages.INFO_REPLICATION_STATUS_INDEPENDENT_REPLICATION_SERVERS.get());
            this.printlnProgress();
            for (i = 0; i < values.length; ++i) {
                this.printProgress(Message.raw("-", new Object[0]));
                this.printlnProgress();
                for (int j = 0; j < values[i].length; ++j) {
                    this.printProgress(Message.raw(headers[j] + " " + values[i][j], new Object[0]));
                    this.printlnProgress();
                }
            }
        } else {
            Message msg = AdminToolMessages.INFO_REPLICATION_STATUS_INDEPENDENT_REPLICATION_SERVERS.get();
            this.printProgressMessageNoWrap(msg);
            this.printlnProgress();
            int length = msg.length();
            StringBuffer buf = new StringBuffer();
            for (i = 0; i < length; ++i) {
                buf.append("=");
            }
            this.printProgressMessageNoWrap(Message.raw(buf.toString(), new Object[0]));
            this.printlnProgress();
            TableBuilder table = new TableBuilder();
            for (i = 0; i < headers.length; ++i) {
                table.appendHeading(headers[i]);
            }
            for (i = 0; i < values.length; ++i) {
                table.startRow();
                for (int j = 0; j < headers.length; ++j) {
                    table.appendCell(values[i][j]);
                }
            }
            TextTablePrinter printer = new TextTablePrinter(this.getOutputStream());
            printer.setColumnSeparator(":");
            table.print(printer);
        }
    }

    private LinkedHashSet<String> getReplicationServers(String baseDN, TopologyCache cache, ServerDescriptor server) {
        LinkedHashSet<String> servers = new LinkedHashSet<String>();
        for (ReplicaDescriptor replica : server.getReplicas()) {
            if (!Utils.areDnsEqual(replica.getSuffix().getDN(), baseDN)) continue;
            servers.addAll(replica.getReplicationServers());
            break;
        }
        if (cache != null) {
            Set<SuffixDescriptor> suffixes = cache.getSuffixes();
            for (SuffixDescriptor suffix : suffixes) {
                if (!Utils.areDnsEqual(suffix.getDN(), baseDN)) continue;
                Set<String> s = suffix.getReplicationServers();
                HashSet<String> copy = new HashSet<String>(s);
                copy.retainAll(servers);
                if (!copy.isEmpty()) {
                    servers.addAll(s);
                    break;
                }
                if (!server.isReplicationServer()) continue;
                boolean found = false;
                String repServer = server.getReplicationServerHostPort();
                for (String rS : s) {
                    if (!rS.equalsIgnoreCase(repServer)) continue;
                    servers.addAll(s);
                    found = true;
                    break;
                }
                if (!found) continue;
                break;
            }
        }
        return servers;
    }

    private SuffixDescriptor getSuffix(String baseDN, TopologyCache cache, ServerDescriptor server) {
        SuffixDescriptor returnValue = null;
        String replicationServer = null;
        if (server.isReplicationServer()) {
            replicationServer = server.getReplicationServerHostPort();
        }
        LinkedHashSet<String> servers = new LinkedHashSet<String>();
        for (ReplicaDescriptor replica : server.getReplicas()) {
            if (!Utils.areDnsEqual(replica.getSuffix().getDN(), baseDN)) continue;
            servers.addAll(replica.getReplicationServers());
            break;
        }
        Set<SuffixDescriptor> suffixes = cache.getSuffixes();
        block1: for (SuffixDescriptor suffix : suffixes) {
            if (!Utils.areDnsEqual(suffix.getDN(), baseDN)) continue;
            Set<String> s = suffix.getReplicationServers();
            HashSet<String> copy = new HashSet<String>(s);
            copy.retainAll(servers);
            if (!copy.isEmpty()) {
                returnValue = suffix;
                break;
            }
            if (replicationServer == null) continue;
            for (String repServer : s) {
                if (!repServer.equalsIgnoreCase(replicationServer)) continue;
                returnValue = suffix;
                continue block1;
            }
        }
        return returnValue;
    }

    private Set<Integer> getReplicationDomainIds(String baseDN, ServerDescriptor server) {
        HashSet<Integer> ids = new HashSet<Integer>();
        for (ReplicaDescriptor replica : server.getReplicas()) {
            if (!replica.isReplicated() || !Utils.areDnsEqual(replica.getSuffix().getDN(), baseDN)) continue;
            ids.add(replica.getReplicationId());
            break;
        }
        return ids;
    }

    private void configureAsReplicationServer(InitialLdapContext ctx, int replicationPort, boolean useSecureReplication, LinkedHashSet<String> replicationServers, Set<Integer> usedReplicationServerIds) throws OpenDsException {
        this.printProgress(this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_REPLICATION_ENABLE_CONFIGURING_REPLICATION_SERVER.get(ConnectionUtils.getHostPort(ctx))));
        ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
        RootCfgClient root = mCtx.getRootConfiguration();
        ReplicationSynchronizationProviderCfgClient sync = null;
        try {
            sync = (ReplicationSynchronizationProviderCfgClient)root.getSynchronizationProvider("Multimaster Synchronization");
        }
        catch (ManagedObjectNotFoundException monfe) {
            LOG.log(Level.INFO, "Synchronization server does not exist in " + ConnectionUtils.getHostPort(ctx));
        }
        if (sync == null) {
            ReplicationSynchronizationProviderCfgDefn provider = ReplicationSynchronizationProviderCfgDefn.getInstance();
            sync = root.createSynchronizationProvider(provider, "Multimaster Synchronization", new ArrayList<DefaultBehaviorException>());
            sync.setJavaClass(MultimasterReplication.class.getName());
            sync.setEnabled(Boolean.TRUE);
        } else if (!sync.isEnabled().booleanValue()) {
            sync.setEnabled(Boolean.TRUE);
        }
        sync.commit();
        ReplicationServerCfgClient replicationServer = null;
        boolean mustCommit = false;
        if (!sync.hasReplicationServer()) {
            CryptoManagerCfgClient crypto = root.getCryptoManager();
            if (useSecureReplication != crypto.isSSLEncryption()) {
                crypto.setSSLEncryption(useSecureReplication);
                crypto.commit();
            }
            int id = InstallerHelper.getReplicationId(usedReplicationServerIds);
            usedReplicationServerIds.add(id);
            replicationServer = sync.createReplicationServer(ReplicationServerCfgDefn.getInstance(), new ArrayList<DefaultBehaviorException>());
            replicationServer.setReplicationServerId(id);
            replicationServer.setReplicationPort(replicationPort);
            replicationServer.setReplicationServer(replicationServers);
            mustCommit = true;
        } else {
            replicationServer = sync.getReplicationServer();
            usedReplicationServerIds.add(replicationServer.getReplicationServerId());
            SortedSet<String> servers = replicationServer.getReplicationServer();
            if (servers == null) {
                replicationServer.setReplicationServer(replicationServers);
                mustCommit = true;
            } else if (!this.areReplicationServersEqual(servers, replicationServers)) {
                replicationServer.setReplicationServer(this.mergeReplicationServers(replicationServers, servers));
                mustCommit = true;
            }
        }
        if (mustCommit) {
            replicationServer.commit();
        }
        this.printProgress(this.formatter.getFormattedDone());
        this.printlnProgress();
    }

    private void updateReplicationServer(InitialLdapContext ctx, LinkedHashSet<String> replicationServers) throws OpenDsException {
        this.printProgress(this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_REPLICATION_ENABLE_UPDATING_REPLICATION_SERVER.get(ConnectionUtils.getHostPort(ctx))));
        ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
        RootCfgClient root = mCtx.getRootConfiguration();
        ReplicationSynchronizationProviderCfgClient sync = (ReplicationSynchronizationProviderCfgClient)root.getSynchronizationProvider("Multimaster Synchronization");
        boolean mustCommit = false;
        ReplicationServerCfgClient replicationServer = sync.getReplicationServer();
        SortedSet<String> servers = replicationServer.getReplicationServer();
        if (servers == null) {
            replicationServer.setReplicationServer(replicationServers);
            mustCommit = true;
        } else if (!this.areReplicationServersEqual(servers, replicationServers)) {
            replicationServers.addAll(servers);
            replicationServer.setReplicationServer(this.mergeReplicationServers(replicationServers, servers));
            mustCommit = true;
        }
        if (mustCommit) {
            replicationServer.commit();
        }
        this.printProgress(this.formatter.getFormattedDone());
        this.printlnProgress();
    }

    private Set<Integer> getReplicationServerIds(TopologyCache cache) {
        HashSet<Integer> ids = new HashSet<Integer>();
        for (ServerDescriptor server : cache.getServers()) {
            if (!server.isReplicationServer()) continue;
            ids.add(server.getReplicationServerId());
        }
        return ids;
    }

    private void configureToReplicateBaseDN(InitialLdapContext ctx, String baseDN, LinkedHashSet<String> replicationServers, Set<Integer> usedReplicationDomainIds) throws OpenDsException {
        boolean userSpecifiedAdminBaseDN = false;
        LinkedList<String> l = this.argParser.getBaseDNs();
        if (l != null) {
            for (String dn : l) {
                if (!Utils.areDnsEqual(dn, ADSContext.getAdministrationSuffixDN())) continue;
                userSpecifiedAdminBaseDN = true;
                break;
            }
        }
        if (!userSpecifiedAdminBaseDN && Utils.areDnsEqual(baseDN, ADSContext.getAdministrationSuffixDN())) {
            this.printProgress(this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_REPLICATION_ENABLE_CONFIGURING_ADS.get(ConnectionUtils.getHostPort(ctx))));
        } else {
            this.printProgress(this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_REPLICATION_ENABLE_CONFIGURING_BASEDN.get(baseDN, ConnectionUtils.getHostPort(ctx))));
        }
        ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
        RootCfgClient root = mCtx.getRootConfiguration();
        ReplicationSynchronizationProviderCfgClient sync = (ReplicationSynchronizationProviderCfgClient)root.getSynchronizationProvider("Multimaster Synchronization");
        String[] domainNames = sync.listReplicationDomains();
        if (domainNames == null) {
            domainNames = new String[]{};
        }
        ReplicationDomainCfgClient[] domains = new ReplicationDomainCfgClient[domainNames.length];
        for (int i = 0; i < domains.length; ++i) {
            domains[i] = sync.getReplicationDomain(domainNames[i]);
        }
        ReplicationDomainCfgClient domain = null;
        String domainName = null;
        for (int i = 0; i < domains.length && domain == null; ++i) {
            if (!Utils.areDnsEqual(baseDN, domains[i].getBaseDN().toString())) continue;
            domain = domains[i];
            domainName = domainNames[i];
        }
        boolean mustCommit = false;
        if (domain == null) {
            int domainId = InstallerHelper.getReplicationId(usedReplicationDomainIds);
            usedReplicationDomainIds.add(domainId);
            domainName = InstallerHelper.getDomainName(domainNames, domainId, baseDN);
            domain = sync.createReplicationDomain(ReplicationDomainCfgDefn.getInstance(), domainName, new ArrayList<DefaultBehaviorException>());
            domain.setServerId(domainId);
            domain.setBaseDN(DN.decode(baseDN));
            domain.setReplicationServer(replicationServers);
            mustCommit = true;
        } else {
            SortedSet<String> servers = domain.getReplicationServer();
            if (servers == null) {
                domain.setReplicationServer(servers);
                mustCommit = true;
            } else if (!this.areReplicationServersEqual(servers, replicationServers)) {
                domain.setReplicationServer(this.mergeReplicationServers(replicationServers, servers));
                mustCommit = true;
            }
        }
        if (mustCommit) {
            domain.commit();
        }
        this.printProgress(this.formatter.getFormattedDone());
        this.printlnProgress();
    }

    private void configureToReplicateBaseDN(String baseDN, LinkedHashSet<String> repServers, Set<Integer> usedIds, TopologyCache cache, ServerDescriptor server, Set<String> alreadyConfiguredServers, LinkedHashSet<String> allRepServers, Set<String> alreadyConfiguredReplicationServers) throws ReplicationCliException {
        LOG.log(Level.INFO, "Configuring base DN '" + baseDN + "' the replication servers are " + repServers);
        HashSet<ServerDescriptor> serversToConfigureDomain = new HashSet<ServerDescriptor>();
        HashSet<ServerDescriptor> replicationServersToConfigure = new HashSet<ServerDescriptor>();
        SuffixDescriptor suffix = this.getSuffix(baseDN, cache, server);
        if (suffix != null) {
            for (ReplicaDescriptor replica : suffix.getReplicas()) {
                ServerDescriptor s = replica.getServer();
                if (alreadyConfiguredServers.contains(s.getId())) continue;
                serversToConfigureDomain.add(s);
            }
        }
        for (ServerDescriptor s : cache.getServers()) {
            if (!s.isReplicationServer() || alreadyConfiguredReplicationServers.contains(s.getId())) continue;
            boolean isInTopology = false;
            String repServerID = s.getReplicationServerHostPort();
            for (String rID : repServers) {
                if (!repServerID.equalsIgnoreCase(rID)) continue;
                isInTopology = true;
                break;
            }
            if (!isInTopology) continue;
            replicationServersToConfigure.add(s);
        }
        HashSet<ServerDescriptor> allServers = new HashSet<ServerDescriptor>();
        allServers.addAll(serversToConfigureDomain);
        allServers.addAll(replicationServersToConfigure);
        for (ServerDescriptor s : allServers) {
            String hostPort;
            LOG.log(Level.INFO, "Configuring server " + server.getHostPort(true));
            InitialLdapContext ctx = null;
            try {
                ctx = this.getDirContextForServer(cache, s);
                if (serversToConfigureDomain.contains(s)) {
                    this.configureToReplicateBaseDN(ctx, baseDN, repServers, usedIds);
                }
                if (replicationServersToConfigure.contains(s)) {
                    this.updateReplicationServer(ctx, allRepServers);
                }
            }
            catch (NamingException ne) {
                hostPort = this.getHostPort(s, cache.getPreferredConnections());
                Message msg = this.getMessageForException(ne, hostPort);
                throw new ReplicationCliException(msg, ReplicationCliReturnCode.ERROR_CONNECTING, ne);
            }
            catch (OpenDsException ode) {
                hostPort = this.getHostPort(s, cache.getPreferredConnections());
                Message msg = this.getMessageForEnableException(ode, hostPort, baseDN);
                throw new ReplicationCliException(msg, ReplicationCliReturnCode.ERROR_ENABLING_REPLICATION_ON_BASEDN, ode);
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable t) {}
                }
            }
            alreadyConfiguredServers.add(s.getId());
            alreadyConfiguredReplicationServers.add(s.getId());
        }
    }

    private Map<ADSContext.AdministratorProperty, Object> getAdministratorProperties(ReplicationUserData uData) {
        HashMap<ADSContext.AdministratorProperty, Object> adminProperties = new HashMap<ADSContext.AdministratorProperty, Object>();
        adminProperties.put(ADSContext.AdministratorProperty.UID, uData.getAdminUid());
        adminProperties.put(ADSContext.AdministratorProperty.PASSWORD, uData.getAdminPwd());
        adminProperties.put(ADSContext.AdministratorProperty.DESCRIPTION, QuickSetupMessages.INFO_GLOBAL_ADMINISTRATOR_DESCRIPTION.get().toString());
        return adminProperties;
    }

    private void initializeSuffix(String baseDN, InitialLdapContext ctxSource, InitialLdapContext ctxDestination, boolean displayProgress) throws ReplicationCliException {
        int replicationId = -1;
        try {
            TopologyCacheFilter filter = new TopologyCacheFilter();
            filter.setSearchMonitoringInformation(false);
            filter.addBaseDNToSearch(baseDN);
            ServerDescriptor source = ServerDescriptor.createStandalone(ctxSource, filter);
            for (ReplicaDescriptor replica : source.getReplicas()) {
                if (!Utils.areDnsEqual(replica.getSuffix().getDN(), baseDN)) continue;
                replicationId = replica.getReplicationId();
                break;
            }
        }
        catch (NamingException ne) {
            String hostPort = ConnectionUtils.getHostPort(ctxSource);
            Message msg = this.getMessageForException(ne, hostPort);
            throw new ReplicationCliException(msg, ReplicationCliReturnCode.ERROR_READING_CONFIGURATION, ne);
        }
        if (replicationId == -1) {
            throw new ReplicationCliException(AdminToolMessages.ERR_INITIALIZING_REPLICATIONID_NOT_FOUND.get(ConnectionUtils.getHostPort(ctxSource), baseDN), ReplicationCliReturnCode.REPLICATIONID_NOT_FOUND, null);
        }
        OfflineInstaller installer = new OfflineInstaller();
        installer.setProgressMessageFormatter(this.formatter);
        installer.addProgressUpdateListener(new ProgressUpdateListener(){

            public void progressUpdate(ProgressUpdateEvent ev) {
                Message newLogDetails = ev.getNewLogs();
                if (newLogDetails != null && !newLogDetails.toString().trim().equals("")) {
                    ReplicationCliMain.this.printProgress(newLogDetails);
                    ReplicationCliMain.this.printlnProgress();
                }
            }
        });
        int nTries = 5;
        boolean initDone = false;
        while (!initDone) {
            try {
                installer.initializeSuffix(ctxDestination, replicationId, baseDN, displayProgress, ConnectionUtils.getHostPort(ctxSource));
                initDone = true;
            }
            catch (PeerNotFoundException pnfe) {
                LOG.log(Level.INFO, "Peer could not be found");
                if (nTries == 1) {
                    throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_INITIALIZING_TRIES_COMPLETED.get(pnfe.getMessageObject().toString()), ReplicationCliReturnCode.INITIALIZING_TRIES_COMPLETED, pnfe);
                }
                try {
                    Thread.sleep((5 - nTries) * 3000);
                }
                catch (Throwable t) {}
            }
            catch (ApplicationException ae) {
                throw new ReplicationCliException(ae.getMessageObject(), ReplicationCliReturnCode.ERROR_INITIALIZING_BASEDN_GENERIC, ae);
            }
            --nTries;
        }
    }

    public void initializeAllSuffix(String baseDN, InitialLdapContext ctx, boolean displayProgress) throws ReplicationCliException {
        if (this.argParser == null) {
            try {
                this.createArgumenParser();
            }
            catch (ArgumentException ae) {
                throw new RuntimeException("Error creating argument parser: " + ae, ae);
            }
        }
        int nTries = 5;
        boolean initDone = false;
        while (!initDone) {
            try {
                this.initializeAllSuffixTry(baseDN, ctx, displayProgress);
                this.postPreExternalInitialization(baseDN, ctx, false, displayProgress, false);
                initDone = true;
            }
            catch (PeerNotFoundException pnfe) {
                LOG.log(Level.INFO, "Peer could not be found");
                if (nTries == 1) {
                    throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_INITIALIZING_TRIES_COMPLETED.get(pnfe.getMessageObject().toString()), ReplicationCliReturnCode.INITIALIZING_TRIES_COMPLETED, pnfe);
                }
                try {
                    Thread.sleep((5 - nTries) * 3000);
                }
                catch (Throwable t) {}
            }
            catch (ApplicationException ae) {
                throw new ReplicationCliException(ae.getMessageObject(), ReplicationCliReturnCode.ERROR_INITIALIZING_BASEDN_GENERIC, ae);
            }
            --nTries;
        }
    }

    private void preExternalInitialization(String baseDN, InitialLdapContext ctx, boolean localOnly, boolean displayProgress) throws ReplicationCliException {
        this.postPreExternalInitialization(baseDN, ctx, localOnly, displayProgress, true);
    }

    private void postExternalInitialization(String baseDN, InitialLdapContext ctx, boolean displayProgress) throws ReplicationCliException {
        this.postPreExternalInitialization(baseDN, ctx, false, displayProgress, false);
    }

    private void postPreExternalInitialization(String baseDN, InitialLdapContext ctx, boolean localOnly, boolean displayProgress, boolean isPre) throws ReplicationCliException {
        boolean taskCreated = false;
        int i = 1;
        boolean isOver = false;
        String dn = null;
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute oc = new BasicAttribute("objectclass");
        oc.add("top");
        oc.add("ds-task");
        oc.add("ds-task-reset-generation-id");
        attrs.put(oc);
        attrs.put("ds-task-class-name", "org.opends.server.tasks.SetGenerationIdTask");
        if (isPre) {
            if (!localOnly) {
                attrs.put("ds-task-reset-generation-id-new-value", "-1");
            } else {
                try {
                    attrs.put("ds-task-reset-generation-id-new-value", String.valueOf(this.getReplicationDomainId(ctx, baseDN)));
                }
                catch (NamingException ne) {
                    LOG.log(Level.SEVERE, "Error get replication domain id for base DN " + baseDN + " on server " + ConnectionUtils.getHostPort(ctx), ne);
                    throw new ReplicationCliException(Utils.getThrowableMsg(AdminToolMessages.ERR_LAUNCHING_PRE_EXTERNAL_INITIALIZATION.get(), ne), ReplicationCliReturnCode.ERROR_LAUNCHING_PRE_EXTERNAL_INITIALIZATION, ne);
                }
            }
        }
        attrs.put("ds-task-reset-generation-id-domain-base-dn", baseDN);
        while (!taskCreated) {
            String id = "dsreplication-reset-generation-id-" + i;
            dn = "ds-task-id=" + id + ",cn=Scheduled Tasks,cn=Tasks";
            attrs.put("ds-task-id", id);
            try {
                DirContext dirCtx = ctx.createSubcontext(dn, (Attributes)attrs);
                taskCreated = true;
                LOG.log(Level.INFO, "created task entry: " + attrs);
                dirCtx.close();
            }
            catch (NameAlreadyBoundException x) {
            }
            catch (NamingException ne) {
                LOG.log(Level.SEVERE, "Error creating task " + attrs, ne);
                Message msg = isPre ? AdminToolMessages.ERR_LAUNCHING_PRE_EXTERNAL_INITIALIZATION.get() : AdminToolMessages.ERR_LAUNCHING_POST_EXTERNAL_INITIALIZATION.get();
                ReplicationCliReturnCode code = isPre ? ReplicationCliReturnCode.ERROR_LAUNCHING_PRE_EXTERNAL_INITIALIZATION : ReplicationCliReturnCode.ERROR_LAUNCHING_POST_EXTERNAL_INITIALIZATION;
                throw new ReplicationCliException(Utils.getThrowableMsg(msg, ne), code, ne);
            }
            ++i;
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setCountLimit(1L);
        searchControls.setSearchScope(0);
        String filter = "objectclass=*";
        searchControls.setReturningAttributes(new String[]{"ds-task-log-message", "ds-task-state"});
        String lastLogMsg = null;
        while (!isOver) {
            try {
                Thread.sleep(500L);
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                Message errorMsg;
                String state;
                InstallerHelper helper;
                NamingEnumeration<SearchResult> res = ctx.search(dn, filter, searchControls);
                SearchResult sr = res.next();
                String logMsg = Utils.getFirstValue(sr, "ds-task-log-message");
                if (logMsg != null && !logMsg.equals(lastLogMsg)) {
                    LOG.log(Level.INFO, logMsg);
                    lastLogMsg = logMsg;
                }
                if (!(helper = new InstallerHelper()).isDone(state = Utils.getFirstValue(sr, "ds-task-state")) && !helper.isStoppedByError(state)) continue;
                isOver = true;
                String server = ConnectionUtils.getHostPort(ctx);
                if (lastLogMsg == null) {
                    errorMsg = isPre ? AdminToolMessages.INFO_ERROR_DURING_PRE_EXTERNAL_INITIALIZATION_NO_LOG.get(state, server) : AdminToolMessages.INFO_ERROR_DURING_POST_EXTERNAL_INITIALIZATION_NO_LOG.get(state, server);
                } else {
                    Message message = errorMsg = isPre ? AdminToolMessages.INFO_ERROR_DURING_PRE_EXTERNAL_INITIALIZATION_LOG.get(lastLogMsg, state, server) : AdminToolMessages.INFO_ERROR_DURING_POST_EXTERNAL_INITIALIZATION_LOG.get(lastLogMsg, state, server);
                }
                if (helper.isCompletedWithErrors(state)) {
                    LOG.log(Level.WARNING, "Completed with error: " + errorMsg);
                    this.println(errorMsg);
                    continue;
                }
                if (helper.isSuccessful(state) && !helper.isStoppedByError(state)) continue;
                LOG.log(Level.WARNING, "Error: " + errorMsg);
                ReplicationCliReturnCode code = isPre ? ReplicationCliReturnCode.ERROR_LAUNCHING_PRE_EXTERNAL_INITIALIZATION : ReplicationCliReturnCode.ERROR_LAUNCHING_POST_EXTERNAL_INITIALIZATION;
                throw new ReplicationCliException(errorMsg, code, null);
            }
            catch (NameNotFoundException x) {
                isOver = true;
            }
            catch (NamingException ne) {
                Message msg = isPre ? AdminToolMessages.ERR_POOLING_PRE_EXTERNAL_INITIALIZATION.get() : AdminToolMessages.ERR_POOLING_POST_EXTERNAL_INITIALIZATION.get();
                throw new ReplicationCliException(Utils.getThrowableMsg(msg, ne), ReplicationCliReturnCode.ERROR_CONNECTING, ne);
            }
        }
    }

    public void initializeAllSuffixTry(String baseDN, InitialLdapContext ctx, boolean displayProgress) throws ApplicationException, PeerNotFoundException {
        boolean taskCreated = false;
        int i = 1;
        boolean isOver = false;
        String dn = null;
        String serverDisplay = ConnectionUtils.getHostPort(ctx);
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute oc = new BasicAttribute("objectclass");
        oc.add("top");
        oc.add("ds-task");
        oc.add("ds-task-initialize-remote-replica");
        attrs.put(oc);
        attrs.put("ds-task-class-name", "org.opends.server.tasks.InitializeTargetTask");
        attrs.put("ds-task-initialize-domain-dn", baseDN);
        attrs.put("ds-task-initialize-replica-server-id", "all");
        while (!taskCreated) {
            String id = "dsreplication-initialize" + i;
            dn = "ds-task-id=" + id + ",cn=Scheduled Tasks,cn=Tasks";
            attrs.put("ds-task-id", id);
            try {
                DirContext dirCtx = ctx.createSubcontext(dn, (Attributes)attrs);
                taskCreated = true;
                LOG.log(Level.INFO, "created task entry: " + attrs);
                dirCtx.close();
            }
            catch (NameAlreadyBoundException x) {
                LOG.log(Level.WARNING, "A task with dn: " + dn + " already existed.");
            }
            catch (NamingException ne) {
                LOG.log(Level.SEVERE, "Error creating task " + attrs, ne);
                throw new ApplicationException(ReturnCode.APPLICATION_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_LAUNCHING_INITIALIZATION.get(serverDisplay), ne), ne);
            }
            ++i;
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setCountLimit(1L);
        searchControls.setSearchScope(0);
        String filter = "objectclass=*";
        searchControls.setReturningAttributes(new String[]{"ds-task-unprocessed-entry-count", "ds-task-processed-entry-count", "ds-task-log-message", "ds-task-state"});
        Message lastDisplayedMsg = null;
        String lastLogMsg = null;
        long lastTimeMsgDisplayed = -1L;
        long lastTimeMsgLogged = -1L;
        int totalEntries = 0;
        while (!isOver) {
            try {
                Thread.sleep(500L);
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                String state;
                InstallerHelper helper;
                String logMsg;
                Message msg;
                NamingEnumeration<SearchResult> res = ctx.search(dn, filter, searchControls);
                SearchResult sr = res.next();
                String sProcessed = Utils.getFirstValue(sr, "ds-task-processed-entry-count");
                String sUnprocessed = Utils.getFirstValue(sr, "ds-task-unprocessed-entry-count");
                int processed = -1;
                int unprocessed = -1;
                if (sProcessed != null) {
                    processed = Integer.parseInt(sProcessed);
                }
                if (sUnprocessed != null) {
                    unprocessed = Integer.parseInt(sUnprocessed);
                }
                totalEntries = Math.max(totalEntries, processed + unprocessed);
                if (processed != -1 && unprocessed != -1) {
                    if (processed + unprocessed > 0) {
                        int perc = 100 * processed / (processed + unprocessed);
                        msg = QuickSetupMessages.INFO_INITIALIZE_PROGRESS_WITH_PERCENTAGE.get(sProcessed, String.valueOf(perc));
                    } else {
                        msg = null;
                    }
                } else {
                    msg = processed != -1 ? QuickSetupMessages.INFO_INITIALIZE_PROGRESS_WITH_PROCESSED.get(sProcessed) : (unprocessed != -1 ? QuickSetupMessages.INFO_INITIALIZE_PROGRESS_WITH_UNPROCESSED.get(sUnprocessed) : lastDisplayedMsg);
                }
                if (msg != null) {
                    long minRefreshPeriod;
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - (minRefreshPeriod = totalEntries < 100 ? 0L : (totalEntries < 1000 ? 1000L : (totalEntries < 10000 ? 5000L : 10000L))) > lastTimeMsgLogged) {
                        lastTimeMsgLogged = currentTime;
                        LOG.log(Level.INFO, "Progress msg: " + msg);
                    }
                    if (displayProgress && currentTime - minRefreshPeriod > lastTimeMsgDisplayed && !msg.equals(lastDisplayedMsg)) {
                        this.printProgress(msg);
                        lastDisplayedMsg = msg;
                        this.printlnProgress();
                        lastTimeMsgDisplayed = currentTime;
                    }
                }
                if ((logMsg = Utils.getFirstValue(sr, "ds-task-log-message")) != null && !logMsg.equals(lastLogMsg)) {
                    LOG.log(Level.INFO, logMsg);
                    lastLogMsg = logMsg;
                }
                if (!(helper = new InstallerHelper()).isDone(state = Utils.getFirstValue(sr, "ds-task-state")) && !helper.isStoppedByError(state)) continue;
                isOver = true;
                LOG.log(Level.INFO, "Last task entry: " + sr);
                if (displayProgress && msg != null && !msg.equals(lastDisplayedMsg)) {
                    this.printProgress(msg);
                    lastDisplayedMsg = msg;
                    this.printlnProgress();
                }
                Message errorMsg = lastLogMsg == null ? QuickSetupMessages.INFO_ERROR_DURING_INITIALIZATION_NO_LOG.get(serverDisplay, state, serverDisplay) : QuickSetupMessages.INFO_ERROR_DURING_INITIALIZATION_LOG.get(serverDisplay, lastLogMsg, state, serverDisplay);
                if (helper.isCompletedWithErrors(state)) {
                    LOG.log(Level.WARNING, "Processed errorMsg: " + errorMsg);
                    if (!displayProgress) continue;
                    this.println(errorMsg);
                    continue;
                }
                if (!helper.isSuccessful(state) || helper.isStoppedByError(state)) {
                    LOG.log(Level.WARNING, "Processed errorMsg: " + errorMsg);
                    ApplicationException ae = new ApplicationException(ReturnCode.APPLICATION_ERROR, errorMsg, null);
                    if (lastLogMsg == null || helper.isPeersNotFoundError(lastLogMsg)) {
                        LOG.log(Level.WARNING, "Throwing peer not found error.  Last Log Msg: " + lastLogMsg);
                        throw new PeerNotFoundException(errorMsg);
                    }
                    LOG.log(Level.SEVERE, "Throwing ApplicationException.");
                    throw ae;
                }
                if (displayProgress) {
                    this.printProgress(QuickSetupMessages.INFO_SUFFIX_INITIALIZED_SUCCESSFULLY.get());
                    this.printlnProgress();
                }
                LOG.log(Level.INFO, "Processed msg: " + errorMsg);
                LOG.log(Level.INFO, "Initialization completed successfully.");
            }
            catch (NameNotFoundException x) {
                isOver = true;
                LOG.log(Level.INFO, "Initialization entry not found.");
                if (!displayProgress) continue;
                this.printProgress(QuickSetupMessages.INFO_SUFFIX_INITIALIZED_SUCCESSFULLY.get());
                this.printlnProgress();
            }
            catch (NamingException ne) {
                throw new ApplicationException(ReturnCode.APPLICATION_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_POOLING_INITIALIZATION.get(serverDisplay), ne), ne);
            }
        }
    }

    private void removeReferencesInServer(ServerDescriptor server, String replicationServer, String bindDn, String pwd, Collection<String> baseDNs, boolean updateReplicationServers, LinkedHashSet<PreferredConnection> cnx) throws ReplicationCliException {
        TopologyCacheFilter filter = new TopologyCacheFilter();
        filter.setSearchMonitoringInformation(false);
        filter.setSearchBaseDNInformation(false);
        ServerLoader loader = new ServerLoader(server.getAdsProperties(), bindDn, pwd, this.getTrustManager(), cnx, filter);
        InitialLdapContext ctx = null;
        String lastBaseDN = null;
        String hostPort = null;
        try {
            ctx = loader.createContext();
            hostPort = ConnectionUtils.getHostPort(ctx);
            ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
            RootCfgClient root = mCtx.getRootConfiguration();
            ReplicationSynchronizationProviderCfgClient sync = null;
            try {
                sync = (ReplicationSynchronizationProviderCfgClient)root.getSynchronizationProvider("Multimaster Synchronization");
            }
            catch (ManagedObjectNotFoundException monfe) {
                LOG.log(Level.INFO, "No synchronization found on " + hostPort + ".", monfe);
            }
            if (sync != null) {
                ReplicationServerCfgClient rServerObj;
                SortedSet<String> replServers;
                String[] domainNames = sync.listReplicationDomains();
                if (domainNames != null) {
                    for (int i = 0; i < domainNames.length; ++i) {
                        ReplicationDomainCfgClient domain = sync.getReplicationDomain(domainNames[i]);
                        Iterator<String> i$ = baseDNs.iterator();
                        while (i$.hasNext()) {
                            String baseDN;
                            lastBaseDN = baseDN = i$.next();
                            if (!Utils.areDnsEqual(domain.getBaseDN().toString(), baseDN)) continue;
                            this.printProgress(this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_REPLICATION_REMOVING_REFERENCES_ON_REMOTE.get(baseDN, hostPort)));
                            SortedSet<String> replServers2 = domain.getReplicationServer();
                            if (replServers2 != null) {
                                String replServer = null;
                                for (String o : replServers2) {
                                    if (!replicationServer.equalsIgnoreCase(o)) continue;
                                    replServer = o;
                                    break;
                                }
                                if (replServer != null) {
                                    LOG.log(Level.INFO, "Updating references in domain " + domain.getBaseDN() + " on " + hostPort + ".");
                                    replServers2.remove(replServer);
                                    if (replServers2.size() > 0) {
                                        domain.setReplicationServer(replServers2);
                                        domain.commit();
                                    } else {
                                        sync.removeReplicationDomain(domainNames[i]);
                                        sync.commit();
                                    }
                                }
                            }
                            this.printProgress(this.formatter.getFormattedDone());
                            this.printlnProgress();
                        }
                    }
                }
                if (updateReplicationServers && sync.hasReplicationServer() && (replServers = (rServerObj = sync.getReplicationServer()).getReplicationServer()) != null) {
                    String replServer = null;
                    for (String o : replServers) {
                        if (!replicationServer.equalsIgnoreCase(o)) continue;
                        replServer = o;
                        break;
                    }
                    if (replServer != null) {
                        replServers.remove(replServer);
                        if (replServers.size() > 0) {
                            rServerObj.setReplicationServer(replServers);
                            rServerObj.commit();
                        } else {
                            sync.removeReplicationServer();
                            sync.commit();
                        }
                    }
                }
            }
        }
        catch (NamingException ne) {
            hostPort = this.getHostPort(server, cnx);
            Message msg = this.getMessageForException(ne, hostPort);
            throw new ReplicationCliException(msg, ReplicationCliReturnCode.ERROR_CONNECTING, ne);
        }
        catch (OpenDsException ode) {
            if (lastBaseDN != null) {
                Message msg = this.getMessageForDisableException(ode, hostPort, lastBaseDN);
                throw new ReplicationCliException(msg, ReplicationCliReturnCode.ERROR_DISABLING_REPLICATION_REMOVE_REFERENCE_ON_BASEDN, ode);
            }
            Message msg = AdminToolMessages.ERR_REPLICATION_ERROR_READING_CONFIGURATION.get(hostPort, ode.getMessage());
            throw new ReplicationCliException(msg, ReplicationCliReturnCode.ERROR_CONNECTING, ode);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    private void deleteReplicationDomain(InitialLdapContext ctx, String baseDN) throws ReplicationCliException {
        String hostPort = ConnectionUtils.getHostPort(ctx);
        try {
            String[] domainNames;
            ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
            RootCfgClient root = mCtx.getRootConfiguration();
            ReplicationSynchronizationProviderCfgClient sync = null;
            try {
                sync = (ReplicationSynchronizationProviderCfgClient)root.getSynchronizationProvider("Multimaster Synchronization");
            }
            catch (ManagedObjectNotFoundException monfe) {
                LOG.log(Level.INFO, "No synchronization found on " + hostPort + ".", monfe);
            }
            if (sync != null && (domainNames = sync.listReplicationDomains()) != null) {
                for (int i = 0; i < domainNames.length; ++i) {
                    ReplicationDomainCfgClient domain = sync.getReplicationDomain(domainNames[i]);
                    if (!Utils.areDnsEqual(domain.getBaseDN().toString(), baseDN)) continue;
                    this.printProgress(this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_REPLICATION_DISABLING_BASEDN.get(baseDN, hostPort)));
                    sync.removeReplicationDomain(domainNames[i]);
                    sync.commit();
                    this.printProgress(this.formatter.getFormattedDone());
                    this.printlnProgress();
                }
            }
        }
        catch (OpenDsException ode) {
            Message msg = this.getMessageForDisableException(ode, hostPort, baseDN);
            throw new ReplicationCliException(msg, ReplicationCliReturnCode.ERROR_DISABLING_REPLICATION_REMOVE_REFERENCE_ON_BASEDN, ode);
        }
    }

    private void disableReplicationServer(InitialLdapContext ctx) throws ReplicationCliException {
        String hostPort = ConnectionUtils.getHostPort(ctx);
        try {
            ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
            RootCfgClient root = mCtx.getRootConfiguration();
            ReplicationSynchronizationProviderCfgClient sync = null;
            ReplicationServerCfgClient replicationServer = null;
            try {
                sync = (ReplicationSynchronizationProviderCfgClient)root.getSynchronizationProvider("Multimaster Synchronization");
                if (sync.hasReplicationServer()) {
                    replicationServer = sync.getReplicationServer();
                }
            }
            catch (ManagedObjectNotFoundException monfe) {
                LOG.log(Level.INFO, "No synchronization found on " + hostPort + ".", monfe);
            }
            if (replicationServer != null) {
                String s = String.valueOf(replicationServer.getReplicationPort());
                this.printProgress(this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_REPLICATION_DISABLING_REPLICATION_SERVER.get(s, hostPort)));
                sync.removeReplicationServer();
                sync.commit();
                this.printProgress(this.formatter.getFormattedDone());
                this.printlnProgress();
            }
        }
        catch (OpenDsException ode) {
            throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_DISABLING_REPLICATIONSERVER.get(hostPort), ReplicationCliReturnCode.ERROR_DISABLING_REPLICATION_SERVER, ode);
        }
    }

    private Message getMessageForReplicationServerException(OpenDsException ode, String hostPort) {
        return AdminToolMessages.ERR_REPLICATION_CONFIGURING_REPLICATIONSERVER.get(hostPort);
    }

    private Message getMessageForEnableException(OpenDsException ode, String hostPort, String baseDN) {
        return AdminToolMessages.ERR_REPLICATION_CONFIGURING_BASEDN.get(baseDN, hostPort);
    }

    private Message getMessageForDisableException(OpenDsException ode, String hostPort, String baseDN) {
        return AdminToolMessages.ERR_REPLICATION_CONFIGURING_BASEDN.get(baseDN, hostPort);
    }

    private Message getCannotBindToPortError(int port) {
        Message message = SetupUtils.isPriviledgedPort(port) ? ToolMessages.ERR_INSTALLDS_CANNOT_BIND_TO_PRIVILEGED_PORT.get(port) : ToolMessages.ERR_INSTALLDS_CANNOT_BIND_TO_PORT.get(port);
        return message;
    }

    private boolean areReplicationServersEqual(Set<String> s1, Set<String> s2) {
        HashSet<String> c1 = new HashSet<String>();
        for (String s : s1) {
            c1.add(s.toLowerCase());
        }
        HashSet<String> c2 = new HashSet<String>();
        for (String s : s2) {
            c2.add(s.toLowerCase());
        }
        return ((Object)c1).equals(c2);
    }

    private Set<String> mergeReplicationServers(Set<String> s1, Set<String> s2) {
        HashSet<String> c1 = new HashSet<String>();
        for (String s : s1) {
            c1.add(s.toLowerCase());
        }
        for (String s : s2) {
            c1.add(s.toLowerCase());
        }
        return c1;
    }

    private Message getCriticalExceptionMessage(ReplicationCliException rce) {
        Throwable c;
        MessageBuilder mb = new MessageBuilder();
        mb.append(rce.getMessageObject());
        File logFile = ControlPanelLog.getLogFile();
        if (logFile != null && rce.getErrorCode() != ReplicationCliReturnCode.USER_CANCELLED) {
            mb.append(Constants.LINE_SEPARATOR);
            mb.append(QuickSetupMessages.INFO_GENERAL_SEE_FOR_DETAILS.get(logFile.getPath()));
        }
        if ((c = rce.getCause()) != null) {
            Message msg;
            String s = c instanceof NamingException ? ((NamingException)c).toString(true) : (c instanceof OpenDsException ? ((msg = ((OpenDsException)c).getMessageObject()) != null ? msg.toString() : c.toString()) : c.toString());
            if (mb.toString().indexOf(s) == -1) {
                mb.append(Constants.LINE_SEPARATOR);
                mb.append(AdminToolMessages.INFO_REPLICATION_CRITICAL_ERROR_DETAILS.get(s));
            }
        }
        return mb.toMessage();
    }

    private boolean mustInitializeSchema(ServerDescriptor server1, ServerDescriptor server2, EnableReplicationUserData uData) {
        boolean mustInitializeSchema = false;
        if (!this.argParser.noSchemaReplication()) {
            String id1 = server1.getSchemaReplicationID();
            String id2 = server2.getSchemaReplicationID();
            mustInitializeSchema = id1 != null ? id1.equals(id2) : true;
        }
        if (mustInitializeSchema) {
            mustInitializeSchema = uData.configureReplicationDomain1() && uData.configureReplicationDomain2();
        }
        return mustInitializeSchema;
    }

    private void registerServer(ADSContext adsContext, Map<ADSContext.ServerProperty, Object> serverProperties) throws ADSContextException {
        try {
            adsContext.registerServer(serverProperties);
        }
        catch (ADSContextException ade) {
            if (ade.getError() == ADSContextException.ErrorType.ALREADY_REGISTERED) {
                LOG.log(Level.WARNING, "The server was already registered: " + serverProperties);
                adsContext.unregisterServer(serverProperties);
                adsContext.registerServer(serverProperties);
            }
            throw ade;
        }
    }

    @Override
    public boolean isAdvancedMode() {
        return false;
    }

    @Override
    public boolean isInteractive() {
        if (this.forceNonInteractive) {
            return false;
        }
        return this.argParser.isInteractive();
    }

    @Override
    public boolean isMenuDrivenMode() {
        return true;
    }

    @Override
    public boolean isQuiet() {
        return this.argParser.isQuiet();
    }

    @Override
    public boolean isScriptFriendly() {
        return this.argParser.isScriptFriendly();
    }

    @Override
    public boolean isVerbose() {
        return true;
    }

    private void printProgressMessageNoWrap(Message msg) {
        if (!this.isQuiet()) {
            this.getOutputStream().print(msg.toString());
        }
    }

    private void forceTrustManagerInitialization() {
        this.forceNonInteractive = true;
        try {
            this.ci.initializeTrustManagerIfRequired();
        }
        catch (ArgumentException ae) {
            LOG.log(Level.WARNING, "Error initializing trust store: " + ae, ae);
        }
        this.forceNonInteractive = false;
    }

    private int getReplicationDomainId(InitialLdapContext ctx, String baseDN) throws NamingException {
        int domainId = -1;
        TopologyCacheFilter filter = new TopologyCacheFilter();
        filter.setSearchMonitoringInformation(false);
        filter.addBaseDNToSearch(baseDN);
        ServerDescriptor server = ServerDescriptor.createStandalone(ctx, filter);
        for (ReplicaDescriptor replica : server.getReplicas()) {
            if (!Utils.areDnsEqual(replica.getSuffix().getDN(), baseDN)) continue;
            domainId = replica.getReplicationId();
            break;
        }
        return domainId;
    }

    private boolean areEqual(Set<Map<ADSContext.ServerProperty, Object>> registry1, Set<Map<ADSContext.ServerProperty, Object>> registry2) {
        boolean areEqual;
        boolean bl = areEqual = registry1.size() == registry2.size();
        if (areEqual) {
            HashSet<ADSContext.ServerProperty> propertiesToCompare = new HashSet<ADSContext.ServerProperty>();
            ADSContext.ServerProperty[] properties = ADSContext.ServerProperty.values();
            for (int i = 0; i < properties.length; ++i) {
                if (properties[i].getAttributeSyntax() == ADSContext.ADSPropertySyntax.CERTIFICATE_BINARY) continue;
                propertiesToCompare.add(properties[i]);
            }
            for (Map<ADSContext.ServerProperty, Object> server1 : registry1) {
                boolean found = false;
                for (Map<ADSContext.ServerProperty, Object> server2 : registry2) {
                    found = true;
                    for (ADSContext.ServerProperty prop : propertiesToCompare) {
                        Object v1 = server1.get((Object)prop);
                        Object v2 = server2.get((Object)prop);
                        if (v1 != null) {
                            found = v1.equals(v2);
                        } else if (v2 != null) {
                            found = false;
                        }
                        if (found) continue;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
                if (areEqual = found) continue;
                break;
            }
        }
        return areEqual;
    }

    private boolean disableAllBaseDns(InitialLdapContext ctx, DisableReplicationUserData uData) {
        if (uData.disableAll()) {
            return true;
        }
        boolean returnValue = true;
        Collection<ReplicaDescriptor> replicas = this.getReplicas(ctx);
        HashSet<String> replicatedSuffixes = new HashSet<String>();
        for (ReplicaDescriptor rep : replicas) {
            String dn = rep.getSuffix().getDN();
            if (!rep.isReplicated()) continue;
            replicatedSuffixes.add(dn);
        }
        for (String dn1 : replicatedSuffixes) {
            if (Utils.areDnsEqual(ADSContext.getAdministrationSuffixDN(), dn1) || Utils.areDnsEqual("cn=schema", dn1)) continue;
            boolean found = false;
            for (String dn2 : uData.getBaseDNs()) {
                if (!Utils.areDnsEqual(dn1, dn2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            returnValue = false;
            break;
        }
        return returnValue;
    }

    protected String getHostPort(ServerDescriptor server, Collection<PreferredConnection> cnx) {
        String hostPort = null;
        for (PreferredConnection connection : cnx) {
            String url = connection.getLDAPURL();
            if (url.equals(server.getLDAPURL())) {
                hostPort = server.getHostPort(false);
                continue;
            }
            if (!url.equals(server.getLDAPsURL())) continue;
            hostPort = server.getHostPort(true);
        }
        if (hostPort == null) {
            hostPort = server.getHostPort(true);
        }
        return hostPort;
    }

    private SubcommandChoice promptForSubcommand() {
        SubcommandChoice returnValue;
        MenuBuilder<SubcommandChoice> builder = new MenuBuilder<SubcommandChoice>(this);
        builder.setPrompt(AdminToolMessages.INFO_REPLICATION_SUBCOMMAND_PROMPT.get());
        builder.addCancelOption(false);
        for (SubcommandChoice choice : SubcommandChoice.values()) {
            if (choice == SubcommandChoice.CANCEL) continue;
            builder.addNumberedOption(choice.getPrompt(), MenuResult.success(choice), new Message[0]);
        }
        try {
            MenuResult m = builder.toMenu().run();
            returnValue = m.isSuccess() ? (SubcommandChoice)((Object)m.getValue()) : SubcommandChoice.CANCEL;
        }
        catch (CLIException ce) {
            returnValue = SubcommandChoice.CANCEL;
            LOG.log(Level.WARNING, "Error reading input: " + ce, ce);
        }
        return returnValue;
    }

    private boolean mustPrintCommandBuilder() {
        return this.argParser.isInteractive() && (this.argParser.displayEquivalentArgument.isPresent() || this.argParser.equivalentCommandFileArgument.isPresent());
    }

    private void printCommandBuilder(CommandBuilder commandBuilder) {
        if (this.argParser.displayEquivalentArgument.isPresent()) {
            this.println();
            this.println(AdminToolMessages.INFO_REPLICATION_NON_INTERACTIVE.get(commandBuilder.toString()));
        }
        if (this.argParser.equivalentCommandFileArgument.isPresent()) {
            String file = this.argParser.equivalentCommandFileArgument.getValue();
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(file, true));
                writer.write(SHELL_COMMENT_SEPARATOR + this.getCurrentOperationDateMessage());
                writer.newLine();
                writer.write(commandBuilder.toString());
                writer.newLine();
                writer.newLine();
                writer.flush();
                writer.close();
            }
            catch (IOException ioe) {
                this.println(AdminToolMessages.ERR_REPLICATION_ERROR_WRITING_EQUIVALENT_COMMAND_LINE.get(file, ioe.toString()));
            }
        }
    }

    private CommandBuilder createCommandBuilder(String subcommandName, ReplicationUserData uData) throws ArgumentException {
        String commandName = System.getProperty("org.opends.server.scriptName");
        if (commandName == null) {
            commandName = "dsreplication";
        }
        CommandBuilder commandBuilder = new CommandBuilder(commandName, subcommandName);
        if (subcommandName.equals("enable")) {
            this.updateCommandBuilder(commandBuilder, (EnableReplicationUserData)uData);
        } else if (subcommandName.equals("initialize")) {
            this.updateCommandBuilder(commandBuilder, (InitializeReplicationUserData)uData);
        } else if (this.ci != null && this.ci.getCommandBuilder() != null) {
            CommandBuilder interactionBuilder = this.ci.getCommandBuilder();
            for (Argument arg : interactionBuilder.getArguments()) {
                if (arg.getLongIdentifier().equals("bindPassword")) {
                    StringArgument bindPasswordArg = new StringArgument("adminPassword", Character.valueOf('w'), "adminPassword", false, false, true, ToolMessages.INFO_BINDPWD_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_REPLICATION_ADMIN_BINDPASSWORD.get());
                    bindPasswordArg.addValue(arg.getValue());
                    commandBuilder.addObfuscatedArgument(bindPasswordArg);
                    continue;
                }
                if (arg.getLongIdentifier().equals("bindPasswordFile")) {
                    FileBasedArgument bindPasswordFileArg = new FileBasedArgument("adminPasswordFile", Character.valueOf('j'), "adminPasswordFile", false, false, ToolMessages.INFO_BINDPWD_FILE_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_REPLICATION_ADMIN_BINDPASSWORDFILE.get());
                    bindPasswordFileArg.getNameToValueMap().putAll(((FileBasedArgument)arg).getNameToValueMap());
                    commandBuilder.addArgument(bindPasswordFileArg);
                    continue;
                }
                if (interactionBuilder.isObfuscated(arg)) {
                    commandBuilder.addObfuscatedArgument(arg);
                    continue;
                }
                commandBuilder.addArgument(arg);
            }
        }
        if (subcommandName.equals("disable")) {
            DisableReplicationUserData disableData = (DisableReplicationUserData)uData;
            if (disableData.disableAll()) {
                commandBuilder.addArgument(new BooleanArgument(this.argParser.disableAllArg.getName(), this.argParser.disableAllArg.getShortIdentifier(), this.argParser.disableAllArg.getLongIdentifier(), AdminToolMessages.INFO_DESCRIPTION_DISABLE_ALL.get()));
            } else if (disableData.disableReplicationServer()) {
                commandBuilder.addArgument(new BooleanArgument(this.argParser.disableReplicationServerArg.getName(), this.argParser.disableReplicationServerArg.getShortIdentifier(), this.argParser.disableReplicationServerArg.getLongIdentifier(), AdminToolMessages.INFO_DESCRIPTION_DISABLE_REPLICATION_SERVER.get()));
            }
        }
        this.addGlobalArguments(commandBuilder, uData);
        return commandBuilder;
    }

    private void addGlobalArguments(CommandBuilder commandBuilder, ReplicationUserData uData) throws ArgumentException {
        LinkedList<String> baseDNs = uData.getBaseDNs();
        StringArgument baseDNsArg = new StringArgument("baseDNs", Character.valueOf('b'), "baseDN", false, true, true, ToolMessages.INFO_BASEDN_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_REPLICATION_BASEDNS.get());
        for (String baseDN : baseDNs) {
            baseDNsArg.addValue(baseDN);
        }
        commandBuilder.addArgument(baseDNsArg);
        String[] identifiersToMove = new String[]{"adminUID", "adminPassword", "adminPasswordFile", "saslOption", "trustAll", "trustStorePath", "trustStorePassword", "trustStorePasswordFile", "keyStorePath", "keyStorePassword", "keyStorePasswordFile", "certNickname"};
        ArrayList<Argument> toMoveArgs = new ArrayList<Argument>();
        block1: for (String longID : identifiersToMove) {
            for (Argument arg : commandBuilder.getArguments()) {
                if (!longID.equals(arg.getLongIdentifier())) continue;
                toMoveArgs.add(arg);
                continue block1;
            }
        }
        for (Argument argToMove : toMoveArgs) {
            boolean toObfuscate = commandBuilder.isObfuscated(argToMove);
            commandBuilder.removeArgument(argToMove);
            if (toObfuscate) {
                commandBuilder.addObfuscatedArgument(argToMove);
                continue;
            }
            commandBuilder.addArgument(argToMove);
        }
        if (this.argParser.isVerbose()) {
            commandBuilder.addArgument(new BooleanArgument("verbose", ToolConstants.OPTION_SHORT_VERBOSE, "verbose", ToolMessages.INFO_DESCRIPTION_VERBOSE.get()));
        }
        if (this.argParser.isScriptFriendly()) {
            commandBuilder.addArgument(this.argParser.scriptFriendlyArg);
        }
        commandBuilder.addArgument(this.argParser.noPromptArg);
        if (this.argParser.propertiesFileArgument.isPresent()) {
            commandBuilder.addArgument(this.argParser.propertiesFileArgument);
        }
        if (this.argParser.noPropertiesFileArgument.isPresent()) {
            commandBuilder.addArgument(this.argParser.noPropertiesFileArgument);
        }
    }

    private void updateCommandBuilder(CommandBuilder commandBuilder, EnableReplicationUserData uData) throws ArgumentException {
        boolean adminInformationAdded = false;
        if (this.firstServerCommandBuilder != null) {
            boolean useAdminUID = false;
            for (Argument arg : this.firstServerCommandBuilder.getArguments()) {
                if (!arg.getLongIdentifier().equals("adminUID")) continue;
                useAdminUID = true;
                break;
            }
            boolean forceAddBindDN1 = false;
            boolean forceAddBindPwdFile1 = false;
            if (useAdminUID) {
                String bindDN1 = uData.getBindDn1();
                String adminUID = uData.getAdminUid();
                if (bindDN1 != null && adminUID != null && !Utils.areDnsEqual(ADSContext.getAdministratorDN(adminUID), bindDN1)) {
                    forceAddBindDN1 = true;
                    for (Argument arg : this.firstServerCommandBuilder.getArguments()) {
                        if (!arg.getLongIdentifier().equals("bindPasswordFile")) continue;
                        forceAddBindPwdFile1 = true;
                        break;
                    }
                }
            }
            for (Argument arg : this.firstServerCommandBuilder.getArguments()) {
                if (arg.getLongIdentifier().equals("hostname")) {
                    StringArgument host = new StringArgument("host1", Character.valueOf('h'), "host1", false, false, true, ToolMessages.INFO_HOST_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_HOST1.get());
                    host.addValue(uData.getHostName1());
                    commandBuilder.addArgument(host);
                    continue;
                }
                if (arg.getLongIdentifier().equals("port")) {
                    IntegerArgument port = new IntegerArgument("port1", Character.valueOf('p'), "port1", false, false, true, ToolMessages.INFO_PORT_PLACEHOLDER.get(), 4444, null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_SERVER_PORT1.get());
                    port.addValue(String.valueOf(uData.getPort1()));
                    commandBuilder.addArgument(port);
                    if (!forceAddBindDN1) continue;
                    StringArgument bindDN = new StringArgument("bindDN1", Character.valueOf('D'), "bindDN1", false, false, true, ToolMessages.INFO_BINDDN_PLACEHOLDER.get(), "cn=Directory Manager", null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_BINDDN1.get());
                    bindDN.addValue(uData.getBindDn1());
                    commandBuilder.addArgument(bindDN);
                    if (forceAddBindPwdFile1) {
                        FileBasedArgument bindPasswordFileArg = new FileBasedArgument("bindPasswordFile1", null, "bindPasswordFile1", false, false, ToolMessages.INFO_BINDPWD_FILE_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_BINDPASSWORDFILE1.get());
                        bindPasswordFileArg.getNameToValueMap().put("{password file}", "{password file}");
                        commandBuilder.addArgument(bindPasswordFileArg);
                        continue;
                    }
                    StringArgument bindPasswordArg = new StringArgument("bindPassword1", null, "bindPassword1", false, false, true, ToolMessages.INFO_BINDPWD_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_BINDPASSWORD1.get());
                    bindPasswordArg.addValue(arg.getValue());
                    commandBuilder.addObfuscatedArgument(bindPasswordArg);
                    continue;
                }
                if (arg.getLongIdentifier().equals("bindDN")) {
                    StringArgument bindDN = new StringArgument("bindDN1", Character.valueOf('D'), "bindDN1", false, false, true, ToolMessages.INFO_BINDDN_PLACEHOLDER.get(), "cn=Directory Manager", null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_BINDDN1.get());
                    bindDN.addValue(uData.getBindDn1());
                    commandBuilder.addArgument(bindDN);
                    continue;
                }
                if (arg.getLongIdentifier().equals("bindPassword")) {
                    StringArgument bindPasswordArg;
                    if (useAdminUID) {
                        adminInformationAdded = true;
                        bindPasswordArg = new StringArgument("adminPassword", Character.valueOf('w'), "adminPassword", false, false, true, ToolMessages.INFO_BINDPWD_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_REPLICATION_ADMIN_BINDPASSWORD.get());
                        bindPasswordArg.addValue(arg.getValue());
                        commandBuilder.addObfuscatedArgument(bindPasswordArg);
                        continue;
                    }
                    bindPasswordArg = new StringArgument("bindPassword1", null, "bindPassword1", false, false, true, ToolMessages.INFO_BINDPWD_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_BINDPASSWORD1.get());
                    bindPasswordArg.addValue(arg.getValue());
                    commandBuilder.addObfuscatedArgument(bindPasswordArg);
                    continue;
                }
                if (arg.getLongIdentifier().equals("bindPasswordFile")) {
                    FileBasedArgument bindPasswordFileArg;
                    if (useAdminUID) {
                        bindPasswordFileArg = new FileBasedArgument("adminPasswordFile", Character.valueOf('j'), "adminPasswordFile", false, false, ToolMessages.INFO_BINDPWD_FILE_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_REPLICATION_ADMIN_BINDPASSWORDFILE.get());
                        bindPasswordFileArg.getNameToValueMap().putAll(((FileBasedArgument)arg).getNameToValueMap());
                        commandBuilder.addArgument(bindPasswordFileArg);
                        continue;
                    }
                    bindPasswordFileArg = new FileBasedArgument("bindPasswordFile1", null, "bindPasswordFile1", false, false, ToolMessages.INFO_BINDPWD_FILE_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_BINDPASSWORDFILE1.get());
                    bindPasswordFileArg.getNameToValueMap().putAll(((FileBasedArgument)arg).getNameToValueMap());
                    commandBuilder.addArgument(bindPasswordFileArg);
                    continue;
                }
                if (arg.getLongIdentifier().equals("adminUID")) {
                    adminInformationAdded = true;
                }
                if (this.firstServerCommandBuilder.isObfuscated(arg)) {
                    commandBuilder.addObfuscatedArgument(arg);
                    continue;
                }
                commandBuilder.addArgument(arg);
            }
        }
        if (this.ci != null && this.ci.getCommandBuilder() != null) {
            CommandBuilder interactionBuilder = this.ci.getCommandBuilder();
            boolean useAdminUID = false;
            boolean hasBindDN = false;
            for (Argument arg : interactionBuilder.getArguments()) {
                if (arg.getLongIdentifier().equals("adminUID")) {
                    useAdminUID = true;
                } else if (arg.getLongIdentifier().equals("bindDN")) {
                    hasBindDN = true;
                }
                if (!useAdminUID || !hasBindDN) continue;
                break;
            }
            boolean forceAddBindDN2 = false;
            boolean forceAddBindPwdFile2 = false;
            if (useAdminUID) {
                String bindDN2 = uData.getBindDn2();
                String adminUID = uData.getAdminUid();
                if (bindDN2 != null && adminUID != null && !Utils.areDnsEqual(ADSContext.getAdministratorDN(adminUID), bindDN2)) {
                    forceAddBindDN2 = true;
                    for (Argument arg : interactionBuilder.getArguments()) {
                        if (!arg.getLongIdentifier().equals("bindPasswordFile")) continue;
                        forceAddBindPwdFile2 = true;
                        break;
                    }
                }
            }
            ArrayList<Argument> argsToAnalyze = new ArrayList<Argument>();
            for (Argument arg : interactionBuilder.getArguments()) {
                if (arg.getLongIdentifier().equals("hostname")) {
                    StringArgument host = new StringArgument("host2", Character.valueOf('O'), "host2", false, false, true, ToolMessages.INFO_HOST_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_HOST2.get());
                    host.addValue(uData.getHostName2());
                    commandBuilder.addArgument(host);
                    continue;
                }
                if (arg.getLongIdentifier().equals("port")) {
                    IntegerArgument port = new IntegerArgument("port2", null, "port2", false, false, true, ToolMessages.INFO_PORT_PLACEHOLDER.get(), 4444, null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_SERVER_PORT2.get());
                    port.addValue(String.valueOf(uData.getPort2()));
                    commandBuilder.addArgument(port);
                    if (!forceAddBindDN2) continue;
                    StringArgument bindDN = new StringArgument("bindDN2", Character.valueOf('D'), "bindDN2", false, false, true, ToolMessages.INFO_BINDDN_PLACEHOLDER.get(), "cn=Directory Manager", null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_BINDDN2.get());
                    bindDN.addValue(uData.getBindDn2());
                    commandBuilder.addArgument(bindDN);
                    if (forceAddBindPwdFile2) {
                        FileBasedArgument bindPasswordFileArg = new FileBasedArgument("bindPasswordFile2", null, "bindPasswordFile2", false, false, ToolMessages.INFO_BINDPWD_FILE_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_BINDPASSWORDFILE2.get());
                        bindPasswordFileArg.getNameToValueMap().put("{password file}", "{password file}");
                        commandBuilder.addArgument(bindPasswordFileArg);
                        continue;
                    }
                    StringArgument bindPasswordArg = new StringArgument("bindPassword2", null, "bindPassword2", false, false, true, ToolMessages.INFO_BINDPWD_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_BINDPASSWORD2.get());
                    bindPasswordArg.addValue(arg.getValue());
                    commandBuilder.addObfuscatedArgument(bindPasswordArg);
                    continue;
                }
                if (arg.getLongIdentifier().equals("bindDN")) {
                    StringArgument bindDN = new StringArgument("bindDN2", null, "bindDN2", false, false, true, ToolMessages.INFO_BINDDN_PLACEHOLDER.get(), "cn=Directory Manager", null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_BINDDN2.get());
                    bindDN.addValue(uData.getBindDn2());
                    commandBuilder.addArgument(bindDN);
                    continue;
                }
                if (arg.getLongIdentifier().equals("bindPassword")) {
                    StringArgument bindPasswordArg;
                    if (useAdminUID && !adminInformationAdded) {
                        adminInformationAdded = true;
                        bindPasswordArg = new StringArgument("adminPassword", Character.valueOf('w'), "adminPassword", false, false, true, ToolMessages.INFO_BINDPWD_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_REPLICATION_ADMIN_BINDPASSWORD.get());
                        bindPasswordArg.addValue(arg.getValue());
                        commandBuilder.addObfuscatedArgument(bindPasswordArg);
                        continue;
                    }
                    if (!hasBindDN) continue;
                    bindPasswordArg = new StringArgument("bindPassword2", null, "bindPassword2", false, false, true, ToolMessages.INFO_BINDPWD_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_BINDPASSWORD2.get());
                    bindPasswordArg.addValue(arg.getValue());
                    commandBuilder.addObfuscatedArgument(bindPasswordArg);
                    continue;
                }
                if (arg.getLongIdentifier().equals("bindPasswordFile")) {
                    FileBasedArgument bindPasswordFileArg;
                    if (useAdminUID && !adminInformationAdded) {
                        adminInformationAdded = true;
                        bindPasswordFileArg = new FileBasedArgument("adminPasswordFile", Character.valueOf('j'), "adminPasswordFile", false, false, ToolMessages.INFO_BINDPWD_FILE_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_REPLICATION_ADMIN_BINDPASSWORDFILE.get());
                        bindPasswordFileArg.getNameToValueMap().putAll(((FileBasedArgument)arg).getNameToValueMap());
                        commandBuilder.addArgument(bindPasswordFileArg);
                        continue;
                    }
                    if (!hasBindDN) continue;
                    bindPasswordFileArg = new FileBasedArgument("bindPasswordFile2", null, "bindPasswordFile2", false, false, ToolMessages.INFO_BINDPWD_FILE_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_BINDPASSWORDFILE2.get());
                    bindPasswordFileArg.getNameToValueMap().putAll(((FileBasedArgument)arg).getNameToValueMap());
                    commandBuilder.addArgument(bindPasswordFileArg);
                    continue;
                }
                argsToAnalyze.add(arg);
            }
            for (Argument arg : argsToAnalyze) {
                boolean found = false;
                for (Argument a : commandBuilder.getArguments()) {
                    if (!a.getLongIdentifier().equals(arg.getLongIdentifier())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                if (interactionBuilder.isObfuscated(arg)) {
                    commandBuilder.addObfuscatedArgument(arg);
                    continue;
                }
                commandBuilder.addArgument(arg);
            }
        }
        if (!adminInformationAdded) {
            StringArgument adminUID = new StringArgument("adminUID", Character.valueOf('I'), "adminUID", false, false, true, ToolMessages.INFO_ADMINUID_PLACEHOLDER.get(), "admin", null, AdminToolMessages.INFO_DESCRIPTION_REPLICATION_ADMIN_UID.get("enable"));
            if (uData.getAdminUid() != null) {
                adminUID.addValue(uData.getAdminUid());
                commandBuilder.addArgument(adminUID);
            }
            if (this.userProvidedAdminPwdFile != null) {
                commandBuilder.addArgument(this.userProvidedAdminPwdFile);
            } else {
                StringArgument bindPasswordArg = new StringArgument("adminPassword", Character.valueOf('w'), "adminPassword", false, false, true, ToolMessages.INFO_BINDPWD_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_REPLICATION_ADMIN_BINDPASSWORD.get());
                if (uData.getAdminPwd() != null) {
                    bindPasswordArg.addValue(uData.getAdminPwd());
                    commandBuilder.addObfuscatedArgument(bindPasswordArg);
                }
            }
        }
        if (uData.configureReplicationServer1() && !uData.configureReplicationDomain1()) {
            commandBuilder.addArgument(new BooleanArgument(this.argParser.onlyReplicationServer1Arg.getName(), this.argParser.onlyReplicationServer1Arg.getShortIdentifier(), this.argParser.onlyReplicationServer1Arg.getLongIdentifier(), AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_ONLY_REPLICATION_SERVER1.get()));
        }
        if (!uData.configureReplicationServer1() && uData.configureReplicationDomain1()) {
            commandBuilder.addArgument(new BooleanArgument(this.argParser.noReplicationServer1Arg.getName(), this.argParser.noReplicationServer1Arg.getShortIdentifier(), this.argParser.noReplicationServer1Arg.getLongIdentifier(), AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_NO_REPLICATION_SERVER1.get()));
        }
        if (uData.configureReplicationServer1() && uData.getReplicationPort1() > 0) {
            IntegerArgument replicationPort1 = new IntegerArgument("replicationPort1", Character.valueOf('r'), "replicationPort1", false, false, true, ToolMessages.INFO_PORT_PLACEHOLDER.get(), 8989, null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_PORT1.get());
            replicationPort1.addValue(String.valueOf(uData.getReplicationPort1()));
            commandBuilder.addArgument(replicationPort1);
        }
        if (uData.isSecureReplication1()) {
            commandBuilder.addArgument(new BooleanArgument("secureReplication1", null, "secureReplication1", AdminToolMessages.INFO_DESCRIPTION_ENABLE_SECURE_REPLICATION1.get()));
        }
        if (uData.configureReplicationServer2() && !uData.configureReplicationDomain2()) {
            commandBuilder.addArgument(new BooleanArgument(this.argParser.onlyReplicationServer2Arg.getName(), this.argParser.onlyReplicationServer2Arg.getShortIdentifier(), this.argParser.onlyReplicationServer2Arg.getLongIdentifier(), AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_ONLY_REPLICATION_SERVER2.get()));
        }
        if (!uData.configureReplicationServer2() && uData.configureReplicationDomain2()) {
            commandBuilder.addArgument(new BooleanArgument(this.argParser.noReplicationServer2Arg.getName(), this.argParser.noReplicationServer2Arg.getShortIdentifier(), this.argParser.noReplicationServer2Arg.getLongIdentifier(), AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_NO_REPLICATION_SERVER2.get()));
        }
        if (uData.configureReplicationServer2() && uData.getReplicationPort2() > 0) {
            IntegerArgument replicationPort2 = new IntegerArgument("replicationPort2", Character.valueOf('r'), "replicationPort2", false, false, true, ToolMessages.INFO_PORT_PLACEHOLDER.get(), uData.getReplicationPort2(), null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_PORT2.get());
            replicationPort2.addValue(String.valueOf(uData.getReplicationPort2()));
            commandBuilder.addArgument(replicationPort2);
        }
        if (uData.isSecureReplication2()) {
            commandBuilder.addArgument(new BooleanArgument("secureReplication2", null, "secureReplication2", AdminToolMessages.INFO_DESCRIPTION_ENABLE_SECURE_REPLICATION2.get()));
        }
        if (!uData.replicateSchema()) {
            commandBuilder.addArgument(new BooleanArgument("noschemareplication", null, "noSchemaReplication", AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_NO_SCHEMA_REPLICATION.get()));
        }
        if (this.argParser.skipReplicationPortCheck()) {
            commandBuilder.addArgument(new BooleanArgument("skipportcheck", Character.valueOf('S'), "skipPortCheck", AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_SKIPPORT.get()));
        }
        if (this.argParser.useSecondServerAsSchemaSource()) {
            commandBuilder.addArgument(new BooleanArgument("usesecondserverasschemasource", null, "useSecondServerAsSchemaSource", AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_USE_SECOND_AS_SCHEMA_SOURCE.get("--" + this.argParser.noSchemaReplicationArg.getLongIdentifier())));
        }
    }

    private void updateCommandBuilder(CommandBuilder commandBuilder, InitializeReplicationUserData uData) throws ArgumentException {
        if (this.firstServerCommandBuilder != null) {
            for (Argument arg : this.firstServerCommandBuilder.getArguments()) {
                if (arg.getLongIdentifier().equals("hostname")) {
                    StringArgument host = new StringArgument("hostSource", Character.valueOf('O'), "hostSource", false, false, true, ToolMessages.INFO_HOST_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_INITIALIZE_REPLICATION_HOST_SOURCE.get());
                    host.addValue(uData.getHostNameSource());
                    commandBuilder.addArgument(host);
                    continue;
                }
                if (arg.getLongIdentifier().equals("port")) {
                    IntegerArgument port = new IntegerArgument("portSource", null, "portSource", false, false, true, ToolMessages.INFO_PORT_PLACEHOLDER.get(), 4444, null, AdminToolMessages.INFO_DESCRIPTION_INITIALIZE_REPLICATION_SERVER_PORT_SOURCE.get());
                    port.addValue(String.valueOf(uData.getPortSource()));
                    commandBuilder.addArgument(port);
                    continue;
                }
                if (arg.getLongIdentifier().equals("bindPassword")) {
                    StringArgument bindPasswordArg = new StringArgument("adminPassword", Character.valueOf('w'), "adminPassword", false, false, true, ToolMessages.INFO_BINDPWD_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_REPLICATION_ADMIN_BINDPASSWORD.get());
                    bindPasswordArg.addValue(arg.getValue());
                    commandBuilder.addObfuscatedArgument(bindPasswordArg);
                    continue;
                }
                if (arg.getLongIdentifier().equals("bindPasswordFile")) {
                    FileBasedArgument bindPasswordFileArg = new FileBasedArgument("adminPasswordFile", Character.valueOf('j'), "adminPasswordFile", false, false, ToolMessages.INFO_BINDPWD_FILE_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_REPLICATION_ADMIN_BINDPASSWORDFILE.get());
                    bindPasswordFileArg.getNameToValueMap().putAll(((FileBasedArgument)arg).getNameToValueMap());
                    commandBuilder.addArgument(bindPasswordFileArg);
                    continue;
                }
                if (this.firstServerCommandBuilder.isObfuscated(arg)) {
                    commandBuilder.addObfuscatedArgument(arg);
                    continue;
                }
                commandBuilder.addArgument(arg);
            }
        }
        if (this.ci != null && this.ci.getCommandBuilder() != null) {
            CommandBuilder interactionBuilder = this.ci.getCommandBuilder();
            for (Argument arg : interactionBuilder.getArguments()) {
                if (arg.getLongIdentifier().equals("hostname")) {
                    StringArgument host = new StringArgument("hostDestination", Character.valueOf('O'), "hostDestination", false, false, true, ToolMessages.INFO_HOST_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_INITIALIZE_REPLICATION_HOST_DESTINATION.get());
                    host.addValue(uData.getHostNameDestination());
                    commandBuilder.addArgument(host);
                    continue;
                }
                if (!arg.getLongIdentifier().equals("port")) continue;
                IntegerArgument port = new IntegerArgument("portDestination", null, "portDestination", false, false, true, ToolMessages.INFO_PORT_PLACEHOLDER.get(), 4444, null, AdminToolMessages.INFO_DESCRIPTION_INITIALIZE_REPLICATION_SERVER_PORT_DESTINATION.get());
                port.addValue(String.valueOf(uData.getPortDestination()));
                commandBuilder.addArgument(port);
            }
        }
    }

    private void updateAvailableAndReplicatedSuffixesForOneDomain(InitialLdapContext ctxDomain, InitialLdapContext ctxOther, Collection<String> availableSuffixes, Collection<String> alreadyReplicatedSuffixes) {
        Collection<ReplicaDescriptor> replicas = this.getReplicas(ctxDomain);
        int replicationPort = this.getReplicationPort(ctxOther);
        boolean isReplicationServerConfigured = replicationPort != -1;
        String replicationServer = ServerDescriptor.getReplicationServer(ConnectionUtils.getHostName(ctxOther), replicationPort);
        for (ReplicaDescriptor replica : replicas) {
            if (!isReplicationServerConfigured) {
                if (replica.isReplicated()) {
                    alreadyReplicatedSuffixes.add(replica.getSuffix().getDN());
                }
                availableSuffixes.add(replica.getSuffix().getDN());
            }
            if (!isReplicationServerConfigured) {
                availableSuffixes.add(replica.getSuffix().getDN());
                continue;
            }
            if (!replica.isReplicated()) {
                availableSuffixes.add(replica.getSuffix().getDN());
                continue;
            }
            boolean alreadyReplicated = false;
            Set<String> rServers = replica.getReplicationServers();
            for (String rServer : rServers) {
                if (!replicationServer.equalsIgnoreCase(rServer)) continue;
                alreadyReplicated = true;
            }
            if (alreadyReplicated) {
                alreadyReplicatedSuffixes.add(replica.getSuffix().getDN());
                continue;
            }
            availableSuffixes.add(replica.getSuffix().getDN());
        }
    }

    private void updateAvailableAndReplicatedSuffixesForNoDomain(InitialLdapContext ctx1, InitialLdapContext ctx2, Collection<String> availableSuffixes, Collection<String> alreadyReplicatedSuffixes) {
        block13: {
            Set<SuffixDescriptor> suffixes;
            TopologyCache cache2;
            String replicationServer2;
            block14: {
                TopologyCache cache1;
                String replicationServer1;
                block12: {
                    ADSContext adsContext;
                    int replicationPort1 = this.getReplicationPort(ctx1);
                    boolean isReplicationServer1Configured = replicationPort1 != -1;
                    replicationServer1 = ServerDescriptor.getReplicationServer(ConnectionUtils.getHostName(ctx1), replicationPort1);
                    int replicationPort2 = this.getReplicationPort(ctx2);
                    boolean isReplicationServer2Configured = replicationPort2 != -1;
                    replicationServer2 = ServerDescriptor.getReplicationServer(ConnectionUtils.getHostName(ctx2), replicationPort2);
                    cache1 = null;
                    cache2 = null;
                    if (isReplicationServer1Configured) {
                        try {
                            adsContext = new ADSContext(ctx1);
                            if (adsContext.hasAdminData()) {
                                cache1 = new TopologyCache(adsContext, this.getTrustManager());
                                cache1.getFilter().setSearchMonitoringInformation(false);
                                cache1.setPreferredConnections(PreferredConnection.getPreferredConnections(ctx1));
                                cache1.reloadTopology();
                            }
                        }
                        catch (Throwable t) {
                            LOG.log(Level.WARNING, "Error loading topology cache in " + ConnectionUtils.getLdapUrl(ctx1) + ": " + t, t);
                        }
                    }
                    if (isReplicationServer2Configured) {
                        try {
                            adsContext = new ADSContext(ctx2);
                            if (adsContext.hasAdminData()) {
                                cache2 = new TopologyCache(adsContext, this.getTrustManager());
                                cache2.getFilter().setSearchMonitoringInformation(false);
                                cache2.setPreferredConnections(PreferredConnection.getPreferredConnections(ctx2));
                                cache2.reloadTopology();
                            }
                        }
                        catch (Throwable t) {
                            LOG.log(Level.WARNING, "Error loading topology cache in " + ConnectionUtils.getLdapUrl(ctx2) + ": " + t, t);
                        }
                    }
                    if (cache1 == null || cache2 == null) break block12;
                    this.updateAvailableAndReplicatedSuffixesForNoDomainOneSense(cache1, cache2, replicationServer1, replicationServer2, availableSuffixes, alreadyReplicatedSuffixes);
                    this.updateAvailableAndReplicatedSuffixesForNoDomainOneSense(cache2, cache1, replicationServer2, replicationServer1, availableSuffixes, alreadyReplicatedSuffixes);
                    break block13;
                }
                if (cache1 == null) break block14;
                suffixes = cache1.getSuffixes();
                for (SuffixDescriptor suffix : suffixes) {
                    for (String rServer : suffix.getReplicationServers()) {
                        if (!rServer.equalsIgnoreCase(replicationServer1)) continue;
                        availableSuffixes.add(suffix.getDN());
                    }
                }
                break block13;
            }
            if (cache2 == null) break block13;
            suffixes = cache2.getSuffixes();
            for (SuffixDescriptor suffix : suffixes) {
                for (String rServer : suffix.getReplicationServers()) {
                    if (!rServer.equalsIgnoreCase(replicationServer2)) continue;
                    availableSuffixes.add(suffix.getDN());
                }
            }
        }
    }

    private void updateAvailableAndReplicatedSuffixesForNoDomainOneSense(TopologyCache cache1, TopologyCache cache2, String replicationServer1, String replicationServer2, Collection<String> availableSuffixes, Collection<String> alreadyReplicatedSuffixes) {
        Set<SuffixDescriptor> suffixes = cache1.getSuffixes();
        block0: for (SuffixDescriptor suffix : suffixes) {
            for (String rServer : suffix.getReplicationServers()) {
                if (!rServer.equalsIgnoreCase(replicationServer1)) continue;
                boolean isSecondReplicatedInSameTopology = false;
                boolean isSecondReplicated = false;
                boolean isFirstReplicated = false;
                block2: for (SuffixDescriptor suffix2 : cache2.getSuffixes()) {
                    if (!Utils.areDnsEqual(suffix.getDN(), suffix2.getDN())) continue;
                    for (String rServer2 : suffix2.getReplicationServers()) {
                        if (rServer2.equalsIgnoreCase(replicationServer2)) {
                            isSecondReplicated = true;
                        }
                        if (rServer.equalsIgnoreCase(replicationServer2)) {
                            isFirstReplicated = true;
                        }
                        if (!isFirstReplicated || !isSecondReplicated) continue;
                        isSecondReplicatedInSameTopology = true;
                        break block2;
                    }
                }
                if (!isSecondReplicatedInSameTopology) {
                    availableSuffixes.add(suffix.getDN());
                    continue block0;
                }
                alreadyReplicatedSuffixes.add(suffix.getDN());
                continue block0;
            }
        }
    }

    private void updateBaseDnsWithNotEnoughReplicationServer(ADSContext adsCtx1, ADSContext adsCtx2, EnableReplicationUserData uData, Set<String> baseDNsWithNoReplicationServer, Set<String> baseDNsWithOneReplicationServer) {
        TopologyCache cache;
        if (uData.configureReplicationServer1() && uData.configureReplicationServer2()) {
            return;
        }
        HashSet<SuffixDescriptor> suffixes = new HashSet<SuffixDescriptor>();
        try {
            if (adsCtx1.hasAdminData()) {
                cache = new TopologyCache(adsCtx1, this.getTrustManager());
                cache.getFilter().setSearchMonitoringInformation(false);
                for (String dn : uData.getBaseDNs()) {
                    cache.getFilter().addBaseDNToSearch(dn);
                }
                cache.reloadTopology();
                suffixes.addAll(cache.getSuffixes());
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Error loading topology cache from " + ConnectionUtils.getHostPort(adsCtx1.getDirContext()) + ": " + t, t);
        }
        try {
            if (adsCtx2.hasAdminData()) {
                cache = new TopologyCache(adsCtx2, this.getTrustManager());
                cache.getFilter().setSearchMonitoringInformation(false);
                cache.reloadTopology();
                for (String dn : uData.getBaseDNs()) {
                    cache.getFilter().addBaseDNToSearch(dn);
                }
                suffixes.addAll(cache.getSuffixes());
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Error loading topology cache from " + ConnectionUtils.getHostPort(adsCtx2.getDirContext()) + ": " + t, t);
        }
        int repPort1 = this.getReplicationPort(adsCtx1.getDirContext());
        String repServer1 = ServerDescriptor.getReplicationServer(uData.getHostName1(), repPort1);
        int repPort2 = this.getReplicationPort(adsCtx2.getDirContext());
        String repServer2 = ServerDescriptor.getReplicationServer(uData.getHostName2(), repPort2);
        for (String baseDN : uData.getBaseDNs()) {
            int nReplicationServers = 0;
            for (SuffixDescriptor suffix : suffixes) {
                if (!Utils.areDnsEqual(suffix.getDN(), baseDN)) continue;
                Set<String> replicationServers = suffix.getReplicationServers();
                nReplicationServers += replicationServers.size();
                for (String repServer : replicationServers) {
                    if (uData.configureReplicationServer1() && repServer.equalsIgnoreCase(repServer1)) {
                        --nReplicationServers;
                    }
                    if (!uData.configureReplicationServer2() || !repServer.equalsIgnoreCase(repServer2)) continue;
                    --nReplicationServers;
                }
            }
            if (uData.configureReplicationServer1()) {
                ++nReplicationServers;
            }
            if (uData.configureReplicationServer2()) {
                ++nReplicationServers;
            }
            if (nReplicationServers == 1) {
                baseDNsWithOneReplicationServer.add(baseDN);
                continue;
            }
            if (nReplicationServers != 0) continue;
            baseDNsWithNoReplicationServer.add(baseDN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mergeRegistries(ADSContext adsCtx1, ADSContext adsCtx2) throws ReplicationCliException {
        ConsoleApplication.PointAdder pointAdder = new ConsoleApplication.PointAdder(this);
        try {
            TopologyCache cacheDestination;
            ADSContext adsCtxDestination;
            ADSContext adsCtxSource;
            int nRepServers2;
            int nRepServers1;
            TopologyCache cache2;
            TopologyCache cache1;
            block38: {
                Message msg;
                InitialLdapContext ctxDestination;
                InitialLdapContext ctxSource;
                LinkedHashSet<PreferredConnection> cnx = new LinkedHashSet<PreferredConnection>();
                cnx.addAll(PreferredConnection.getPreferredConnections(adsCtx1.getDirContext()));
                cnx.addAll(PreferredConnection.getPreferredConnections(adsCtx2.getDirContext()));
                cache1 = new TopologyCache(adsCtx1, this.getTrustManager());
                cache1.setPreferredConnections(cnx);
                cache1.getFilter().setSearchBaseDNInformation(false);
                try {
                    cache1.reloadTopology();
                }
                catch (TopologyCacheException te) {
                    LOG.log(Level.SEVERE, "Error reading topology cache of " + ConnectionUtils.getHostPort(adsCtx1.getDirContext()) + " " + te, te);
                    throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_READING_ADS.get(te.getMessageObject()), ReplicationCliReturnCode.ERROR_UPDATING_ADS, te);
                }
                cache2 = new TopologyCache(adsCtx2, this.getTrustManager());
                cache2.setPreferredConnections(cnx);
                cache2.getFilter().setSearchBaseDNInformation(false);
                try {
                    cache2.reloadTopology();
                }
                catch (TopologyCacheException te) {
                    LOG.log(Level.SEVERE, "Error reading topology cache of " + ConnectionUtils.getHostPort(adsCtx2.getDirContext()) + " " + te, te);
                    throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_READING_ADS.get(te.getMessageObject()), ReplicationCliReturnCode.ERROR_UPDATING_ADS, te);
                }
                nRepServers1 = 0;
                for (ServerDescriptor server : cache1.getServers()) {
                    if (!server.isReplicationServer()) continue;
                    ++nRepServers1;
                }
                nRepServers2 = 0;
                for (ServerDescriptor server : cache2.getServers()) {
                    if (!server.isReplicationServer()) continue;
                    ++nRepServers2;
                }
                if (nRepServers1 >= nRepServers2) {
                    ctxSource = adsCtx1.getDirContext();
                    ctxDestination = adsCtx2.getDirContext();
                } else {
                    ctxSource = adsCtx2.getDirContext();
                    ctxDestination = adsCtx1.getDirContext();
                }
                if (this.isInteractive()) {
                    msg = AdminToolMessages.INFO_REPLICATION_MERGING_REGISTRIES_CONFIRMATION.get(ConnectionUtils.getHostPort(ctxSource), ConnectionUtils.getHostPort(ctxDestination), ConnectionUtils.getHostPort(ctxSource), ConnectionUtils.getHostPort(ctxDestination));
                    try {
                        if (!this.askConfirmation(msg, true, LOG)) {
                            throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_USER_CANCELLED.get(), ReplicationCliReturnCode.USER_CANCELLED, null);
                        }
                        break block38;
                    }
                    catch (CLIException ce) {
                        this.println(ce.getMessageObject());
                        throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_USER_CANCELLED.get(), ReplicationCliReturnCode.USER_CANCELLED, null);
                    }
                }
                msg = AdminToolMessages.INFO_REPLICATION_MERGING_REGISTRIES_DESCRIPTION.get(ConnectionUtils.getHostPort(ctxSource), ConnectionUtils.getHostPort(ctxDestination), ConnectionUtils.getHostPort(ctxSource), ConnectionUtils.getHostPort(ctxDestination));
                this.println(msg);
                this.println();
            }
            this.printProgress(AdminToolMessages.INFO_REPLICATION_MERGING_REGISTRIES_PROGRESS.get());
            pointAdder.start();
            LinkedHashSet<Message> cache1Errors = cache1.getErrorMessages();
            if (!cache1Errors.isEmpty()) {
                throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_CANNOT_MERGE_WITH_ERRORS.get(ConnectionUtils.getHostPort(adsCtx1.getDirContext()), Utils.getMessageFromCollection(cache1Errors, Constants.LINE_SEPARATOR)), ReplicationCliReturnCode.ERROR_READING_ADS, null);
            }
            LinkedHashSet<Message> cache2Errors = cache2.getErrorMessages();
            if (!cache2Errors.isEmpty()) {
                throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_CANNOT_MERGE_WITH_ERRORS.get(ConnectionUtils.getHostPort(adsCtx2.getDirContext()), Utils.getMessageFromCollection(cache2Errors, Constants.LINE_SEPARATOR)), ReplicationCliReturnCode.ERROR_READING_ADS, null);
            }
            HashSet<Message> commonRepServerIDErrors = new HashSet<Message>();
            for (ServerDescriptor server1 : cache1.getServers()) {
                if (!server1.isReplicationServer()) continue;
                int replicationID1 = server1.getReplicationServerId();
                boolean found = false;
                for (ServerDescriptor server2 : cache2.getServers()) {
                    int replicationID2;
                    if (!server2.isReplicationServer() || !(found = (replicationID2 = server2.getReplicationServerId()) == replicationID1)) continue;
                    commonRepServerIDErrors.add(AdminToolMessages.ERR_REPLICATION_ENABLE_COMMON_REPLICATION_SERVER_ID_ARG.get(server1.getHostPort(true), server2.getHostPort(true), replicationID1));
                    found = true;
                    break;
                }
                if (!found) continue;
                break;
            }
            HashSet<Message> commonDomainIDErrors = new HashSet<Message>();
            for (SuffixDescriptor suffix1 : cache1.getSuffixes()) {
                block21: for (ReplicaDescriptor replica1 : suffix1.getReplicas()) {
                    if (!replica1.isReplicated()) continue;
                    int domain1 = replica1.getReplicationId();
                    boolean found = false;
                    for (SuffixDescriptor suffix2 : cache2.getSuffixes()) {
                        if (!Utils.areDnsEqual(suffix2.getDN(), replica1.getSuffix().getDN())) continue;
                        for (ReplicaDescriptor replica2 : suffix2.getReplicas()) {
                            int domain2;
                            if (!replica2.isReplicated() || domain1 != (domain2 = replica2.getReplicationId())) continue;
                            commonDomainIDErrors.add(AdminToolMessages.ERR_REPLICATION_ENABLE_COMMON_DOMAIN_ID_ARG.get(replica1.getServer().getHostPort(true), suffix1.getDN(), replica2.getServer().getHostPort(true), suffix2.getDN(), domain1));
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        continue block21;
                    }
                }
            }
            if (!commonRepServerIDErrors.isEmpty() || !commonDomainIDErrors.isEmpty()) {
                MessageBuilder mb = new MessageBuilder();
                if (!commonRepServerIDErrors.isEmpty()) {
                    mb.append(AdminToolMessages.ERR_REPLICATION_ENABLE_COMMON_REPLICATION_SERVER_ID.get(Utils.getMessageFromCollection(commonRepServerIDErrors, Constants.LINE_SEPARATOR)));
                }
                if (!commonDomainIDErrors.isEmpty()) {
                    if (mb.length() > 0) {
                        mb.append(Constants.LINE_SEPARATOR);
                    }
                    mb.append(AdminToolMessages.ERR_REPLICATION_ENABLE_COMMON_DOMAIN_ID.get(Utils.getMessageFromCollection(commonDomainIDErrors, Constants.LINE_SEPARATOR)));
                }
                throw new ReplicationCliException(mb.toMessage(), ReplicationCliReturnCode.REPLICATION_ADS_MERGE_NOT_SUPPORTED, null);
            }
            if (nRepServers1 >= nRepServers2) {
                adsCtxSource = adsCtx1;
                adsCtxDestination = adsCtx2;
                cacheDestination = cache2;
            } else {
                adsCtxSource = adsCtx2;
                adsCtxDestination = adsCtx1;
                cacheDestination = cache1;
            }
            try {
                adsCtxSource.mergeWithRegistry(adsCtxDestination);
            }
            catch (ADSContextException adce) {
                LOG.log(Level.SEVERE, "Error merging registry of " + ConnectionUtils.getHostPort(adsCtxSource.getDirContext()) + " with registry of " + ConnectionUtils.getHostPort(adsCtxDestination.getDirContext()) + " " + adce, adce);
                if (adce.getError() == ADSContextException.ErrorType.ERROR_MERGING) {
                    throw new ReplicationCliException(adce.getMessageObject(), ReplicationCliReturnCode.REPLICATION_ADS_MERGE_NOT_SUPPORTED, adce);
                }
                throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_UPDATING_ADS.get(adce.getMessageObject()), ReplicationCliReturnCode.ERROR_UPDATING_ADS, adce);
            }
            try {
                for (ServerDescriptor server : cacheDestination.getServers()) {
                    if (!server.isReplicationServer()) continue;
                    LOG.log(Level.INFO, "Seeding to replication server on " + server.getHostPort(true) + " with certificates of " + ConnectionUtils.getHostPort(adsCtxSource.getDirContext()));
                    InitialLdapContext ctx = null;
                    try {
                        ctx = this.getDirContextForServer(cacheDestination, server);
                        ServerDescriptor.seedAdsTrustStore(ctx, adsCtxSource.getTrustedCertificates());
                    }
                    finally {
                        if (ctx == null) continue;
                        ctx.close();
                    }
                }
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Error seeding truststore: " + t, t);
                String arg = t instanceof OpenDsException ? ((OpenDsException)t).getMessageObject().toString() : t.toString();
                throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_ENABLE_SEEDING_TRUSTSTORE.get(ConnectionUtils.getHostPort(adsCtx2.getDirContext()), ConnectionUtils.getHostPort(adsCtx1.getDirContext()), arg), ReplicationCliReturnCode.ERROR_SEEDING_TRUSTORE, t);
            }
            pointAdder.stop();
            this.printProgress(this.formatter.getSpace());
            this.printProgress(this.formatter.getFormattedDone());
            this.printlnProgress();
            boolean bl = adsCtxSource == adsCtx1;
            return bl;
        }
        finally {
            pointAdder.stop();
        }
    }

    private InitialLdapContext getDirContextForServer(TopologyCache cache, ServerDescriptor server) throws NamingException {
        String dn = ConnectionUtils.getBindDN(cache.getAdsContext().getDirContext());
        String pwd = ConnectionUtils.getBindPassword(cache.getAdsContext().getDirContext());
        TopologyCacheFilter filter = new TopologyCacheFilter();
        filter.setSearchMonitoringInformation(false);
        filter.setSearchBaseDNInformation(false);
        ServerLoader loader = new ServerLoader(server.getAdsProperties(), dn, pwd, this.getTrustManager(), cache.getPreferredConnections(), filter);
        return loader.createContext();
    }

    private boolean isBaseDNReplicated(ServerDescriptor server, String baseDN) {
        boolean isReplicated = false;
        for (ReplicaDescriptor replica : server.getReplicas()) {
            if (!Utils.areDnsEqual(replica.getSuffix().getDN(), baseDN)) continue;
            isReplicated = replica.isReplicated();
            break;
        }
        return isReplicated;
    }

    private boolean isBaseDNReplicated(ServerDescriptor server1, ServerDescriptor server2, String baseDN) {
        boolean isReplicatedInBoth = false;
        ReplicaDescriptor replica1 = null;
        ReplicaDescriptor replica2 = null;
        for (ReplicaDescriptor replica : server1.getReplicas()) {
            if (!Utils.areDnsEqual(replica.getSuffix().getDN(), baseDN)) continue;
            replica1 = replica;
            break;
        }
        if (replica1 != null && replica1.isReplicated()) {
            block1: for (ReplicaDescriptor replica : server2.getReplicas()) {
                if (!Utils.areDnsEqual(replica.getSuffix().getDN(), baseDN)) continue;
                replica2 = replica;
                if (!replica2.isReplicated()) break;
                Set<String> replServers1 = replica1.getSuffix().getReplicationServers();
                Set<String> replServers2 = replica1.getSuffix().getReplicationServers();
                for (String replServer1 : replServers1) {
                    for (String replServer2 : replServers2) {
                        if (!replServer1.equalsIgnoreCase(replServer2)) continue;
                        isReplicatedInBoth = true;
                        break;
                    }
                    if (!isReplicatedInBoth) continue;
                    break block1;
                }
            }
        }
        return isReplicatedInBoth;
    }

    private boolean displayLogFileAtEnd(String subCommand) {
        String[] subCommands;
        for (String sub : subCommands = new String[]{"enable", "disable", "initialize-all", "initialize"}) {
            if (!sub.equals(subCommand)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SuffixRelationType {
        NOT_REPLICATED,
        FULLY_REPLICATED,
        REPLICATED,
        NOT_FULLY_REPLICATED,
        ALL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SubcommandChoice {
        ENABLE(AdminToolMessages.INFO_REPLICATION_ENABLE_MENU_PROMPT.get()),
        DISABLE(AdminToolMessages.INFO_REPLICATION_DISABLE_MENU_PROMPT.get()),
        INITIALIZE(AdminToolMessages.INFO_REPLICATION_INITIALIZE_MENU_PROMPT.get()),
        INITIALIZE_ALL(AdminToolMessages.INFO_REPLICATION_INITIALIZE_ALL_MENU_PROMPT.get()),
        PRE_EXTERNAL_INITIALIZATION(AdminToolMessages.INFO_REPLICATION_PRE_EXTERNAL_INITIALIZATION_MENU_PROMPT.get()),
        POST_EXTERNAL_INITIALIZATION(AdminToolMessages.INFO_REPLICATION_POST_EXTERNAL_INITIALIZATION_MENU_PROMPT.get()),
        STATUS(AdminToolMessages.INFO_REPLICATION_STATUS_MENU_PROMPT.get()),
        CANCEL(null);

        private Message prompt;

        private SubcommandChoice(Message prompt) {
            this.prompt = prompt;
        }

        Message getPrompt() {
            return this.prompt;
        }
    }
}

