/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opends.messages.DSConfigMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.AbsoluteInheritedDefaultBehaviorProvider;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.AggregationPropertyDefinition;
import org.opends.server.admin.AliasDefaultBehaviorProvider;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.DefaultBehaviorProviderVisitor;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.EnumPropertyDefinition;
import org.opends.server.admin.IllegalPropertyValueException;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyDefinitionUsageBuilder;
import org.opends.server.admin.PropertyDefinitionVisitor;
import org.opends.server.admin.PropertyIsMandatoryException;
import org.opends.server.admin.PropertyIsReadOnlyException;
import org.opends.server.admin.PropertyIsSingleValuedException;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.RelativeInheritedDefaultBehaviorProvider;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.UnknownPropertyDefinitionException;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.dsconfig.ArgumentExceptionFactory;
import org.opends.server.tools.dsconfig.CreateSubCommandHandler;
import org.opends.server.tools.dsconfig.HelpSubCommandHandler;
import org.opends.server.tools.dsconfig.PropertyEditorModification;
import org.opends.server.tools.dsconfig.PropertyValuePrinter;
import org.opends.server.util.Validator;
import org.opends.server.util.cli.CLIException;
import org.opends.server.util.cli.ConsoleApplication;
import org.opends.server.util.cli.HelpCallback;
import org.opends.server.util.cli.Menu;
import org.opends.server.util.cli.MenuBuilder;
import org.opends.server.util.cli.MenuCallback;
import org.opends.server.util.cli.MenuResult;
import org.opends.server.util.table.TableBuilder;
import org.opends.server.util.table.TextTablePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PropertyValueEditor {
    private static final int MULTI_COLUMN_THRESHOLD = 8;
    private final ConsoleApplication app;
    private final ManagementContext context;
    private final List<PropertyEditorModification<?>> mods = new ArrayList();
    private boolean isLastChoiceReset;

    private static void displayPropertyHeader(ConsoleApplication app, PropertyDefinition<?> pd) {
        app.println();
        app.println();
        app.println(DSConfigMessages.INFO_EDITOR_HEADING_CONFIGURE_PROPERTY.get(pd.getName()));
        app.println();
        app.println(pd.getSynopsis(), 4);
        if (pd.getDescription() != null) {
            app.println();
            app.println(pd.getDescription(), 4);
        }
    }

    private static <T> void displayPropertySyntax(ConsoleApplication app, PropertyDefinition<T> d) throws IllegalArgumentException {
        PropertyDefinitionUsageBuilder b = new PropertyDefinitionUsageBuilder(true);
        TableBuilder builder = new TableBuilder();
        builder.startRow();
        builder.appendCell(DSConfigMessages.INFO_EDITOR_HEADING_SYNTAX.get());
        builder.appendCell(b.getUsage(d));
        TextTablePrinter printer = new TextTablePrinter(app.getErrorStream());
        printer.setDisplayHeadings(false);
        printer.setIndentWidth(4);
        printer.setColumnWidth(1, 0);
        builder.print(printer);
    }

    private static <T> void displayPropertyValues(ConsoleApplication app, PropertyDefinition<T> pd, Collection<T> values) throws IllegalArgumentException {
        TableBuilder builder = new TableBuilder();
        PropertyValuePrinter valuePrinter = new PropertyValuePrinter(null, null, false);
        int sz = values.size();
        boolean useMultipleColumns = sz >= 8;
        int rows = sz;
        if (useMultipleColumns) {
            rows /= 2;
            rows += sz % 2;
        }
        ArrayList<T> vl = new ArrayList<T>(values);
        int i = 0;
        int j = rows;
        while (i < rows) {
            builder.startRow();
            builder.appendCell("*)");
            builder.appendCell(valuePrinter.print(pd, vl.get(i)));
            if (useMultipleColumns && j < sz) {
                builder.appendCell();
                builder.appendCell("*)");
                builder.appendCell(valuePrinter.print(pd, vl.get(j)));
            }
            ++i;
            ++j;
        }
        TextTablePrinter printer = new TextTablePrinter(app.getErrorStream());
        printer.setDisplayHeadings(false);
        printer.setIndentWidth(4);
        printer.setColumnWidth(1, 0);
        if (useMultipleColumns) {
            printer.setColumnWidth(2, 2);
            printer.setColumnWidth(4, 0);
        }
        builder.print(printer);
    }

    private static <T> Message getPropertyValues(PropertyDefinition<T> pd, Collection<T> values) {
        if (values.isEmpty()) {
            DefaultBehaviorQuery<T> query = DefaultBehaviorQuery.query(pd);
            Message content = query.getAliasDescription();
            if (content == null) {
                return Message.raw("-", new Object[0]);
            }
            return content;
        }
        PropertyValuePrinter printer = new PropertyValuePrinter(null, null, false);
        MessageBuilder builder = new MessageBuilder();
        boolean isFirst = true;
        for (T value : values) {
            if (!isFirst) {
                builder.append(", ");
            }
            builder.append(printer.print(pd, value));
            isFirst = false;
        }
        return builder.toMessage();
    }

    private static <T> Message getPropertyValues(PropertyDefinition<T> pd, ManagedObject<?> mo) {
        SortedSet<T> values = mo.getPropertyValues(pd);
        return PropertyValueEditor.getPropertyValues(pd, values);
    }

    private static <T> SortedSet<T> readPropertyValues(ConsoleApplication app, ManagedObjectDefinition<?, ?> d, PropertyDefinition<T> pd) throws CLIException {
        TreeSet<T> values = new TreeSet<T>(pd);
        PropertyValueEditor.readPropertyValues(app, d, pd, values);
        return values;
    }

    private static <T> void readPropertyValues(ConsoleApplication app, ManagedObjectDefinition<?, ?> d, PropertyDefinition<T> pd, SortedSet<T> values) throws CLIException {
        T value;
        String s;
        Message prompt;
        if (values.isEmpty()) {
            while (true) {
                try {
                    prompt = pd.hasOption(PropertyOption.MANDATORY) ? DSConfigMessages.INFO_EDITOR_PROMPT_READ_FIRST_VALUE.get(pd.getName()) : DSConfigMessages.INFO_EDITOR_PROMPT_READ_FIRST_VALUE_OPTIONAL.get(pd.getName());
                    app.println();
                    s = app.readLineOfInput(prompt);
                    if (s.trim().length() == 0 && !pd.hasOption(PropertyOption.MANDATORY)) {
                        return;
                    }
                    value = pd.decodeValue(s);
                    if (values.contains(value)) {
                        app.println();
                        app.println(DSConfigMessages.ERR_EDITOR_READ_FIRST_DUPLICATE.get(s));
                        break;
                    }
                    values.add(value);
                }
                catch (IllegalPropertyValueStringException e) {
                    app.println();
                    app.println(ArgumentExceptionFactory.adaptPropertyException(e, d).getMessageObject());
                    continue;
                }
                break;
            }
        }
        if (pd.hasOption(PropertyOption.MULTI_VALUED)) {
            while (true) {
                try {
                    while (true) {
                        prompt = DSConfigMessages.INFO_EDITOR_PROMPT_READ_NEXT_VALUE.get(pd.getName());
                        app.println();
                        s = app.readLineOfInput(prompt);
                        if (s.trim().length() == 0) {
                            return;
                        }
                        value = pd.decodeValue(s);
                        if (values.contains(value)) {
                            app.println();
                            app.println(DSConfigMessages.ERR_EDITOR_READ_NEXT_DUPLICATE.get(s));
                            continue;
                        }
                        values.add(value);
                    }
                }
                catch (IllegalPropertyValueStringException e) {
                    app.println();
                    app.println(ArgumentExceptionFactory.adaptPropertyException(e, d).getMessageObject());
                    app.println();
                    continue;
                }
                break;
            }
        }
    }

    public PropertyValueEditor(ConsoleApplication app, ManagementContext context) {
        this.app = app;
        this.context = context;
    }

    public MenuResult<Void> edit(ManagedObject<?> mo, Collection<PropertyDefinition<?>> c, boolean isCreate) throws CLIException {
        MenuResult result;
        block9: {
            for (PropertyDefinition<?> pd : c) {
                MandatoryPropertyInitializer mpi;
                MenuResult<Void> result2;
                if (!pd.hasOption(PropertyOption.MANDATORY) || !mo.getPropertyValues(pd).isEmpty() || (result2 = (mpi = new MandatoryPropertyInitializer(mo, pd)).invoke(this.app)).isSuccess()) continue;
                return result2;
            }
            do {
                MenuBuilder<Boolean> builder = new MenuBuilder<Boolean>(this.app);
                Message ufn = mo.getManagedObjectDefinition().getUserFriendlyName();
                builder.setPrompt(DSConfigMessages.INFO_EDITOR_HEADING_CONFIGURE_COMPONENT.get(ufn));
                Message heading1 = DSConfigMessages.INFO_DSCFG_HEADING_PROPERTY_NAME.get();
                Message heading2 = DSConfigMessages.INFO_DSCFG_HEADING_PROPERTY_VALUE.get();
                builder.setColumnHeadings(heading1, heading2);
                builder.setColumnWidths(null, 0);
                for (PropertyDefinition<?> pd : c) {
                    boolean isReadOnly = false;
                    if (pd.hasOption(PropertyOption.MONITORING)) {
                        isReadOnly = true;
                    }
                    if (!isCreate && pd.hasOption(PropertyOption.READ_ONLY)) {
                        isReadOnly = true;
                    }
                    PropertyDefinitionVisitor callback = pd.hasOption(PropertyOption.MULTI_VALUED) ? (isReadOnly ? new ReadOnlyPropertyViewer(mo, pd) : new MultiValuedPropertyEditor(mo, pd)) : (isReadOnly ? new ReadOnlyPropertyViewer(mo, pd) : new SingleValuedPropertyEditor(mo, pd));
                    Message values = PropertyValueEditor.getPropertyValues(pd, mo);
                    builder.addNumberedOption(Message.raw("%s", pd.getName()), (MenuCallback<Boolean>)((Object)callback), new Message[]{values});
                }
                ComponentHelpCallback helpCallback = new ComponentHelpCallback(mo, c);
                builder.addHelpOption(helpCallback);
                if (isCreate) {
                    builder.addCharOption(DSConfigMessages.INFO_EDITOR_OPTION_FINISH_KEY.get(), DSConfigMessages.INFO_EDITOR_OPTION_FINISH_CREATE_COMPONENT.get(ufn), MenuResult.success(true));
                } else {
                    builder.addCharOption(DSConfigMessages.INFO_EDITOR_OPTION_FINISH_KEY.get(), DSConfigMessages.INFO_EDITOR_OPTION_FINISH_MODIFY_COMPONENT.get(ufn), MenuResult.success(true));
                }
                builder.setDefault(DSConfigMessages.INFO_EDITOR_OPTION_FINISH_KEY.get(), MenuResult.success(true));
                if (this.app.isMenuDrivenMode()) {
                    builder.addCancelOption(false);
                }
                builder.addQuitOption();
                this.app.println();
                this.app.println();
                Menu menu = builder.toMenu();
                result = menu.run();
                if (!result.isSuccess()) break block9;
            } while (!((Boolean)result.getValue()).booleanValue());
            return MenuResult.success();
        }
        if (result.isCancel()) {
            return MenuResult.cancel();
        }
        return MenuResult.quit();
    }

    private <T> void registerModification(PropertyDefinition<T> pd, SortedSet<T> newValues, SortedSet<T> previousValues) {
        if (this.isLastChoiceReset) {
            this.registerResetModification(pd, previousValues);
        } else if (!newValues.equals(previousValues)) {
            if (newValues.containsAll(previousValues)) {
                this.registerAddModification(pd, newValues, previousValues);
            } else if (previousValues.containsAll(newValues)) {
                this.registerRemoveModification(pd, newValues, previousValues);
            } else {
                this.registerSetModification(pd, newValues, previousValues);
            }
        }
    }

    private <T> void registerResetModification(PropertyDefinition<T> pd, SortedSet<T> previousValues) {
        TreeSet<T> originalValues;
        PropertyEditorModification<?> mod = this.getModification(pd);
        if (mod != null) {
            originalValues = new TreeSet<T>(pd);
            this.castAndAddValues(originalValues, mod.getOriginalValues(), pd);
            this.removeModification(mod);
        } else {
            originalValues = new TreeSet<T>(previousValues);
        }
        this.addModification(PropertyEditorModification.createResetModification(pd, originalValues));
    }

    private <T> void registerSetModification(PropertyDefinition<T> pd, SortedSet<T> newValues, SortedSet<T> previousValues) {
        TreeSet<T> originalValues;
        PropertyEditorModification<?> mod = this.getModification(pd);
        if (mod != null) {
            originalValues = new TreeSet<T>(pd);
            this.castAndAddValues(originalValues, mod.getOriginalValues(), pd);
            this.removeModification(mod);
        } else {
            originalValues = new TreeSet<T>(previousValues);
        }
        this.addModification(PropertyEditorModification.createSetModification(pd, newValues, originalValues));
    }

    private <T> void registerAddModification(PropertyDefinition<T> pd, SortedSet<T> newValues, SortedSet<T> previousValues) {
        PropertyEditorModification<T> newMod;
        PropertyEditorModification<?> mod = this.getModification(pd);
        if (mod != null) {
            TreeSet<T> originalValues = new TreeSet<T>(pd);
            this.castAndAddValues(originalValues, mod.getOriginalValues(), pd);
            if (mod.getType() == PropertyEditorModification.Type.ADD) {
                TreeSet<T> addedValues = new TreeSet<T>(newValues);
                addedValues.removeAll(originalValues);
                newMod = PropertyEditorModification.createAddModification(pd, addedValues, originalValues);
            } else {
                newMod = PropertyEditorModification.createSetModification(pd, new TreeSet<T>(newValues), originalValues);
            }
            this.removeModification(mod);
        } else {
            TreeSet<T> originalValues = new TreeSet<T>(previousValues);
            TreeSet<T> addedValues = new TreeSet<T>(newValues);
            addedValues.removeAll(originalValues);
            newMod = PropertyEditorModification.createAddModification(pd, addedValues, originalValues);
        }
        this.addModification(newMod);
    }

    private <T> void registerRemoveModification(PropertyDefinition<T> pd, SortedSet<T> newValues, SortedSet<T> previousValues) {
        PropertyEditorModification<T> newMod;
        PropertyEditorModification<?> mod = this.getModification(pd);
        if (mod != null) {
            TreeSet<T> originalValues = new TreeSet<T>(pd);
            this.castAndAddValues(originalValues, mod.getOriginalValues(), pd);
            if (newValues.isEmpty()) {
                newMod = PropertyEditorModification.createRemoveModification(pd, originalValues, originalValues);
            } else if (mod.getType() == PropertyEditorModification.Type.REMOVE) {
                TreeSet<T> removedValues = new TreeSet<T>(originalValues);
                removedValues.removeAll(newValues);
                newMod = PropertyEditorModification.createRemoveModification(pd, removedValues, originalValues);
            } else {
                newMod = PropertyEditorModification.createSetModification(pd, new TreeSet<T>(newValues), originalValues);
            }
            this.removeModification(mod);
        } else {
            TreeSet<T> originalValues = new TreeSet<T>(previousValues);
            TreeSet<T> removedValues = new TreeSet<T>(originalValues);
            removedValues.removeAll(newValues);
            newMod = PropertyEditorModification.createRemoveModification(pd, removedValues, originalValues);
        }
        this.addModification(newMod);
    }

    public Collection<PropertyEditorModification<?>> getModifications() {
        return this.mods;
    }

    public void resetModifications() {
        this.mods.clear();
    }

    private <T> void addModification(PropertyEditorModification<T> mod) {
        this.mods.add(mod);
    }

    private <T> boolean removeModification(PropertyEditorModification<T> mod) {
        return this.mods.remove(mod);
    }

    private <T> PropertyEditorModification<?> getModification(PropertyDefinition<T> pd) {
        PropertyEditorModification<?> mod = null;
        for (PropertyEditorModification<?> m : this.mods) {
            if (!pd.equals(m.getPropertyDefinition())) continue;
            mod = m;
            break;
        }
        return mod;
    }

    private <T> void castAndAddValues(Collection<T> destination, Collection<?> source, PropertyDefinition<T> pd) throws ClassCastException {
        for (Object o : source) {
            destination.add(pd.castValue(o));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SingleValuedPropertyEditor
    extends PropertyDefinitionVisitor<MenuResult<Boolean>, Void>
    implements MenuCallback<Boolean> {
        private CLIException e = null;
        private final ManagedObject<?> mo;
        private final PropertyDefinition<?> pd;

        private SingleValuedPropertyEditor(ManagedObject<?> mo, PropertyDefinition<?> pd) {
            Validator.ensureTrue(!pd.hasOption(PropertyOption.MULTI_VALUED));
            this.mo = mo;
            this.pd = pd;
        }

        @Override
        public MenuResult<Boolean> invoke(ConsoleApplication app) throws CLIException {
            PropertyValueEditor.displayPropertyHeader(app, this.pd);
            MenuResult<Boolean> result = this.pd.accept(this, null);
            if (this.e != null) {
                throw this.e;
            }
            return result;
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> MenuResult<Boolean> visitAggregation(AggregationPropertyDefinition<C, S> d, Void p) {
            MenuBuilder builder = new MenuBuilder(PropertyValueEditor.this.app);
            builder.setMultipleColumnThreshold(8);
            builder.setPrompt(DSConfigMessages.INFO_EDITOR_PROMPT_MODIFY_MENU.get(d.getName()));
            DefaultBehaviorQuery<String> query = DefaultBehaviorQuery.query(d);
            SortedSet<String> currentValues = this.mo.getPropertyValues(d);
            SortedSet<String> defaultValues = this.mo.getPropertyDefaultValues(d);
            String currentValue = currentValues.isEmpty() ? null : currentValues.first();
            String defaultValue = defaultValues.isEmpty() ? null : defaultValues.first();
            Message option = this.getKeepDefaultValuesMenuOption(d);
            builder.addNumberedOption(option, MenuResult.cancel(), new Message[0]);
            builder.setDefault(Message.raw("1", new Object[0]), MenuResult.cancel());
            TreeSet<String> values = new TreeSet<String>(d);
            ManagedObjectPath<?, ?> path = d.getParentPath();
            InstantiableRelationDefinition<C, S> rd = d.getRelationDefinition();
            try {
                values.addAll(Arrays.asList(PropertyValueEditor.this.context.listManagedObjects(path, rd)));
            }
            catch (AuthorizationException e) {
                this.e = new CLIException(e.getMessageObject());
                return MenuResult.quit();
            }
            catch (ManagedObjectNotFoundException e) {
                this.e = new CLIException(e.getMessageObject());
                return MenuResult.cancel();
            }
            catch (CommunicationException e) {
                this.e = new CLIException(e.getMessageObject());
                return MenuResult.quit();
            }
            Message ufn = rd.getUserFriendlyName();
            for (String value : values) {
                if (currentValue != null && d.compare(value, currentValue) == 0) continue;
                Message svalue = PropertyValueEditor.getPropertyValues(d, Collections.singleton(value));
                option = value.equals(defaultValue) && query.isDefined() ? DSConfigMessages.INFO_EDITOR_OPTION_CHANGE_TO_DEFAULT_COMPONENT.get(ufn, svalue) : DSConfigMessages.INFO_EDITOR_OPTION_CHANGE_TO_COMPONENT.get(ufn, svalue);
                builder.addNumberedOption(option, MenuResult.success(value), new Message[0]);
            }
            CreateComponentCallback callback = new CreateComponentCallback(d);
            builder.addNumberedOption(DSConfigMessages.INFO_EDITOR_OPTION_CREATE_A_NEW_COMPONENT.get(ufn), callback, new Message[0]);
            if (this.mo.isPropertyPresent(d) && !query.isDefined() && (option = this.getResetToDefaultValuesMenuOption(d)) != null) {
                builder.addNumberedOption(option, MenuResult.success(), new Message[0]);
            }
            return this.runMenu(d, builder);
        }

        @Override
        public MenuResult<Boolean> visitBoolean(BooleanPropertyDefinition d, Void p) {
            Message svalue;
            MenuBuilder builder = new MenuBuilder(PropertyValueEditor.this.app);
            builder.setPrompt(DSConfigMessages.INFO_EDITOR_PROMPT_MODIFY_MENU.get(d.getName()));
            DefaultBehaviorQuery<Boolean> query = DefaultBehaviorQuery.query(d);
            SortedSet<Boolean> currentValues = this.mo.getPropertyValues(d);
            SortedSet<Boolean> defaultValues = this.mo.getPropertyDefaultValues(d);
            Boolean currentValue = currentValues.isEmpty() ? null : currentValues.first();
            Boolean defaultValue = defaultValues.isEmpty() ? null : defaultValues.first();
            Message option = this.getKeepDefaultValuesMenuOption(d);
            builder.addNumberedOption(option, MenuResult.cancel(), new Message[0]);
            builder.setDefault(Message.raw("1", new Object[0]), MenuResult.cancel());
            if (currentValue == null || !currentValue.booleanValue()) {
                svalue = PropertyValueEditor.getPropertyValues(d, Collections.singleton(true));
                option = defaultValue != null && defaultValue == true ? DSConfigMessages.INFO_EDITOR_OPTION_CHANGE_TO_DEFAULT_VALUE.get(svalue) : DSConfigMessages.INFO_EDITOR_OPTION_CHANGE_TO_VALUE.get(svalue);
                builder.addNumberedOption(option, MenuResult.success(true), new Message[0]);
            }
            if (currentValue == null || currentValue.booleanValue()) {
                svalue = PropertyValueEditor.getPropertyValues(d, Collections.singleton(false));
                option = defaultValue != null && defaultValue == false ? DSConfigMessages.INFO_EDITOR_OPTION_CHANGE_TO_DEFAULT_VALUE.get(svalue) : DSConfigMessages.INFO_EDITOR_OPTION_CHANGE_TO_VALUE.get(svalue);
                builder.addNumberedOption(option, MenuResult.success(false), new Message[0]);
            }
            if (this.mo.isPropertyPresent(d) && !query.isDefined() && (option = this.getResetToDefaultValuesMenuOption(d)) != null) {
                builder.addNumberedOption(option, MenuResult.success(), new Message[0]);
            }
            return this.runMenu(d, builder);
        }

        @Override
        public <E extends Enum<E>> MenuResult<Boolean> visitEnum(EnumPropertyDefinition<E> d, Void p) {
            MenuBuilder builder = new MenuBuilder(PropertyValueEditor.this.app);
            builder.setMultipleColumnThreshold(8);
            builder.setPrompt(DSConfigMessages.INFO_EDITOR_PROMPT_MODIFY_MENU.get(d.getName()));
            DefaultBehaviorQuery<E> query = DefaultBehaviorQuery.query(d);
            SortedSet<E> currentValues = this.mo.getPropertyValues(d);
            SortedSet<E> defaultValues = this.mo.getPropertyDefaultValues(d);
            Enum currentValue = currentValues.isEmpty() ? null : (Enum)currentValues.first();
            Enum defaultValue = defaultValues.isEmpty() ? null : (Enum)defaultValues.first();
            Message option = this.getKeepDefaultValuesMenuOption(d);
            builder.addNumberedOption(option, MenuResult.cancel(), new Message[0]);
            builder.setDefault(Message.raw("1", new Object[0]), MenuResult.cancel());
            TreeSet<E> values = new TreeSet<E>(d);
            values.addAll(EnumSet.allOf(d.getEnumClass()));
            for (Enum value : values) {
                if (value.equals(currentValue) && query.isDefined()) continue;
                Message svalue = PropertyValueEditor.getPropertyValues(d, Collections.singleton(value));
                option = value.equals(defaultValue) && query.isDefined() ? DSConfigMessages.INFO_EDITOR_OPTION_CHANGE_TO_DEFAULT_VALUE.get(svalue) : DSConfigMessages.INFO_EDITOR_OPTION_CHANGE_TO_VALUE.get(svalue);
                builder.addNumberedOption(option, MenuResult.success(value), new Message[0]);
            }
            if (this.mo.isPropertyPresent(d) && !query.isDefined() && (option = this.getResetToDefaultValuesMenuOption(d)) != null) {
                builder.addNumberedOption(option, MenuResult.success(), new Message[0]);
            }
            return this.runMenu(d, builder);
        }

        @Override
        public <T> MenuResult<Boolean> visitUnknown(final PropertyDefinition<T> d, Void p) {
            PropertyValueEditor.this.app.println();
            PropertyValueEditor.displayPropertySyntax(PropertyValueEditor.this.app, d);
            MenuBuilder builder = new MenuBuilder(PropertyValueEditor.this.app);
            builder.setPrompt(DSConfigMessages.INFO_EDITOR_PROMPT_MODIFY_MENU.get(d.getName()));
            Message option = this.getKeepDefaultValuesMenuOption(d);
            builder.addNumberedOption(option, MenuResult.cancel(), new Message[0]);
            builder.setDefault(Message.raw("1", new Object[0]), MenuResult.cancel());
            builder.addNumberedOption(DSConfigMessages.INFO_EDITOR_OPTION_CHANGE_VALUE.get(), new MenuCallback<T>(){

                @Override
                public MenuResult<T> invoke(ConsoleApplication app) throws CLIException {
                    app.println();
                    SortedSet values = PropertyValueEditor.readPropertyValues(app, SingleValuedPropertyEditor.this.mo.getManagedObjectDefinition(), d);
                    return MenuResult.success(values);
                }
            }, new Message[0]);
            if (this.mo.isPropertyPresent(d) && (option = this.getResetToDefaultValuesMenuOption(d)) != null) {
                builder.addNumberedOption(option, MenuResult.success(), new Message[0]);
            }
            return this.runMenu(d, builder);
        }

        private <T> Message getKeepDefaultValuesMenuOption(PropertyDefinition<T> pd) {
            DefaultBehaviorQuery<T> query = DefaultBehaviorQuery.query(pd);
            SortedSet<T> currentValues = this.mo.getPropertyValues(pd);
            SortedSet<T> defaultValues = this.mo.getPropertyDefaultValues(pd);
            if (query.isDefined() && currentValues.equals(defaultValues)) {
                Message svalue = PropertyValueEditor.getPropertyValues(pd, currentValues);
                return DSConfigMessages.INFO_EDITOR_OPTION_KEEP_DEFAULT_VALUE.get(svalue);
            }
            if (this.mo.isPropertyPresent(pd)) {
                Message svalue = PropertyValueEditor.getPropertyValues(pd, currentValues);
                return DSConfigMessages.INFO_EDITOR_OPTION_KEEP_VALUE.get(svalue);
            }
            if (query.isAlias()) {
                return DSConfigMessages.INFO_EDITOR_OPTION_KEEP_DEFAULT_ALIAS.get(query.getAliasDescription());
            }
            if (query.isInherited()) {
                if (defaultValues.isEmpty()) {
                    if (query.getAliasDescription() != null) {
                        return DSConfigMessages.INFO_EDITOR_OPTION_KEEP_DEFAULT_INHERITED_ALIAS.get(query.getAliasDescription());
                    }
                    return DSConfigMessages.INFO_EDITOR_OPTION_KEEP_DEFAULT_INHERITED_ALIAS_UNDEFINED.get();
                }
                Message svalue = PropertyValueEditor.getPropertyValues(pd, defaultValues);
                return DSConfigMessages.INFO_EDITOR_OPTION_KEEP_INHERITED_DEFAULT_VALUE.get(svalue);
            }
            return DSConfigMessages.INFO_EDITOR_OPTION_LEAVE_UNDEFINED.get();
        }

        private <T> Message getResetToDefaultValuesMenuOption(PropertyDefinition<T> pd) {
            DefaultBehaviorQuery<T> query = DefaultBehaviorQuery.query(pd);
            SortedSet<T> currentValues = this.mo.getPropertyValues(pd);
            SortedSet<T> defaultValues = this.mo.getPropertyDefaultValues(pd);
            boolean isMandatory = pd.hasOption(PropertyOption.MANDATORY);
            if (!isMandatory && query.isAlias()) {
                return DSConfigMessages.INFO_EDITOR_OPTION_RESET_DEFAULT_ALIAS.get(query.getAliasDescription());
            }
            if (query.isDefined()) {
                if (!currentValues.equals(defaultValues)) {
                    Message svalue = PropertyValueEditor.getPropertyValues(pd, defaultValues);
                    return DSConfigMessages.INFO_EDITOR_OPTION_RESET_DEFAULT_VALUE.get(svalue);
                }
                return null;
            }
            if (!isMandatory && query.isInherited()) {
                if (defaultValues.isEmpty()) {
                    if (query.getAliasDescription() != null) {
                        return DSConfigMessages.INFO_EDITOR_OPTION_RESET_DEFAULT_INHERITED_ALIAS.get(query.getAliasDescription());
                    }
                    return DSConfigMessages.INFO_EDITOR_OPTION_RESET_DEFAULT_INHERITED_ALIAS_UNDEFINED.get();
                }
                Message svalue = PropertyValueEditor.getPropertyValues(pd, defaultValues);
                return DSConfigMessages.INFO_EDITOR_OPTION_RESET_INHERITED_DEFAULT_VALUE.get(svalue);
            }
            if (!isMandatory && query.isUndefined()) {
                return DSConfigMessages.INFO_EDITOR_OPTION_LEAVE_UNDEFINED.get();
            }
            return null;
        }

        private <T> MenuResult<Boolean> runMenu(PropertyDefinition<T> d, MenuBuilder<T> builder) throws IllegalPropertyValueException, PropertyIsSingleValuedException, PropertyIsReadOnlyException, PropertyIsMandatoryException, IllegalArgumentException {
            MenuResult<T> result;
            builder.addHelpOption(new PropertyHelpCallback(this.mo.getManagedObjectDefinition(), d));
            builder.addQuitOption();
            Menu<T> menu = builder.toMenu();
            try {
                PropertyValueEditor.this.app.println();
                result = menu.run();
            }
            catch (CLIException e) {
                this.e = e;
                return null;
            }
            if (result.isSuccess()) {
                Collection<T> newValues = result.getValues();
                TreeSet<T> oldValues = new TreeSet<T>(this.mo.getPropertyValues(d));
                this.mo.setPropertyValues(d, newValues);
                if (newValues.size() > 0) {
                    PropertyValueEditor.this.isLastChoiceReset = false;
                } else {
                    PropertyValueEditor.this.isLastChoiceReset = true;
                }
                PropertyValueEditor.this.registerModification(d, new TreeSet<T>(newValues), oldValues);
                PropertyValueEditor.this.app.println();
                PropertyValueEditor.this.app.pressReturnToContinue();
                return MenuResult.success(false);
            }
            if (result.isCancel()) {
                PropertyValueEditor.this.app.println();
                PropertyValueEditor.this.app.pressReturnToContinue();
                return MenuResult.success(false);
            }
            return MenuResult.quit();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ReadOnlyPropertyViewer
    extends PropertyDefinitionVisitor<MenuResult<Boolean>, Void>
    implements MenuCallback<Boolean> {
        private CLIException e = null;
        private final ManagedObject<?> mo;
        private final PropertyDefinition<?> pd;

        private ReadOnlyPropertyViewer(ManagedObject<?> mo, PropertyDefinition<?> pd) {
            this.mo = mo;
            this.pd = pd;
        }

        @Override
        public MenuResult<Boolean> invoke(ConsoleApplication app) throws CLIException {
            MenuResult<Boolean> result = this.pd.accept(this, null);
            if (this.e != null) {
                throw this.e;
            }
            return result;
        }

        @Override
        public <T> MenuResult<Boolean> visitUnknown(PropertyDefinition<T> pd, Void p) {
            boolean result;
            SortedSet<T> values = this.mo.getPropertyValues(pd);
            PropertyValueEditor.this.app.println();
            PropertyValueEditor.this.app.println();
            switch (values.size()) {
                case 0: {
                    DefaultBehaviorQuery<T> query = DefaultBehaviorQuery.query(pd);
                    Message aliasDescription = query.getAliasDescription();
                    if (aliasDescription == null) {
                        PropertyValueEditor.this.app.println(DSConfigMessages.INFO_EDITOR_HEADING_READ_ONLY_ALIAS_UNDEFINED.get(pd.getName()));
                        break;
                    }
                    PropertyValueEditor.this.app.println(DSConfigMessages.INFO_EDITOR_HEADING_READ_ONLY_ALIAS.get(pd.getName(), aliasDescription));
                    break;
                }
                case 1: {
                    Message svalue = PropertyValueEditor.getPropertyValues(pd, this.mo);
                    PropertyValueEditor.this.app.println(DSConfigMessages.INFO_EDITOR_HEADING_READ_ONLY_VALUE.get(pd.getName(), svalue));
                    break;
                }
                default: {
                    PropertyValueEditor.this.app.println(DSConfigMessages.INFO_EDITOR_HEADING_READ_ONLY_VALUES.get(pd.getName()));
                    PropertyValueEditor.this.app.println();
                    PropertyValueEditor.displayPropertyValues(PropertyValueEditor.this.app, pd, values);
                }
            }
            PropertyValueEditor.this.app.println();
            try {
                result = PropertyValueEditor.this.app.confirmAction(DSConfigMessages.INFO_EDITOR_PROMPT_READ_ONLY.get(), false);
            }
            catch (CLIException e) {
                this.e = e;
                return null;
            }
            if (result) {
                PropertyValueEditor.this.app.println();
                HelpSubCommandHandler.displayVerboseSingleProperty(PropertyValueEditor.this.app, this.mo.getManagedObjectDefinition(), pd.getName());
                PropertyValueEditor.this.app.println();
                PropertyValueEditor.this.app.pressReturnToContinue();
            }
            return MenuResult.again();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PropertyHelpCallback
    implements HelpCallback {
        private final ManagedObjectDefinition<?, ?> d;
        private final PropertyDefinition<?> pd;

        private PropertyHelpCallback(ManagedObjectDefinition<?, ?> d, PropertyDefinition<?> pd) {
            this.d = d;
            this.pd = pd;
        }

        @Override
        public void display(ConsoleApplication app) {
            app.println();
            HelpSubCommandHandler.displayVerboseSingleProperty(app, this.d, this.pd.getName());
            app.println();
            app.pressReturnToContinue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MultiValuedPropertyEditor
    extends PropertyDefinitionVisitor<MenuResult<Boolean>, Void>
    implements MenuCallback<Boolean> {
        private CLIException e = null;
        private final ManagedObject<?> mo;
        private final PropertyDefinition<?> pd;

        private MultiValuedPropertyEditor(ManagedObject<?> mo, PropertyDefinition<?> pd) {
            Validator.ensureTrue(pd.hasOption(PropertyOption.MULTI_VALUED));
            this.mo = mo;
            this.pd = pd;
        }

        @Override
        public MenuResult<Boolean> invoke(ConsoleApplication app) throws CLIException {
            PropertyValueEditor.displayPropertyHeader(app, this.pd);
            MenuResult<Boolean> result = this.pd.accept(this, null);
            if (this.e != null) {
                throw this.e;
            }
            return result;
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> MenuResult<Boolean> visitAggregation(final AggregationPropertyDefinition<C, S> d, Void p) {
            MenuCallback<Boolean> removeCallback;
            MenuCallback<Boolean> addCallback;
            MenuResult<Boolean> result;
            SortedSet<String> defaultValues = this.mo.getPropertyDefaultValues(d);
            SortedSet<String> oldValues = this.mo.getPropertyValues(d);
            final SortedSet<String> currentValues = this.mo.getPropertyValues(d);
            final InstantiableRelationDefinition<C, S> rd = d.getRelationDefinition();
            final Message ufpn = rd.getUserFriendlyPluralName();
            boolean isFirst = true;
            do {
                if (!isFirst) {
                    PropertyValueEditor.this.app.println();
                    PropertyValueEditor.this.app.println(DSConfigMessages.INFO_EDITOR_HEADING_CONFIGURE_PROPERTY_CONT.get(d.getName()));
                } else {
                    isFirst = false;
                }
                if (currentValues.size() > 1) {
                    PropertyValueEditor.this.app.println();
                    PropertyValueEditor.this.app.println(DSConfigMessages.INFO_EDITOR_HEADING_COMPONENT_SUMMARY.get(d.getName(), ufpn));
                    PropertyValueEditor.this.app.println();
                    PropertyValueEditor.displayPropertyValues(PropertyValueEditor.this.app, d, currentValues);
                }
                final TreeSet<String> values = new TreeSet<String>(d);
                ManagedObjectPath<?, ?> path = d.getParentPath();
                try {
                    values.addAll(Arrays.asList(PropertyValueEditor.this.context.listManagedObjects(path, rd)));
                }
                catch (AuthorizationException e) {
                    this.e = new CLIException(e.getMessageObject());
                    return MenuResult.quit();
                }
                catch (ManagedObjectNotFoundException e) {
                    this.e = new CLIException(e.getMessageObject());
                    return MenuResult.cancel();
                }
                catch (CommunicationException e) {
                    this.e = new CLIException(e.getMessageObject());
                    return MenuResult.quit();
                }
                addCallback = null;
                values.removeAll(currentValues);
                if (!values.isEmpty()) {
                    addCallback = new MenuCallback<Boolean>(){

                        @Override
                        public MenuResult<Boolean> invoke(ConsoleApplication app) throws CLIException {
                            MenuBuilder<Object> builder = new MenuBuilder<Object>(app);
                            builder.setPrompt(DSConfigMessages.INFO_EDITOR_PROMPT_SELECT_COMPONENTS_ADD.get(ufpn));
                            builder.setAllowMultiSelect(true);
                            builder.setMultipleColumnThreshold(8);
                            for (String value : values) {
                                Message svalue = PropertyValueEditor.getPropertyValues(d, Collections.singleton(value));
                                builder.addNumberedOption(svalue, MenuResult.success(value), new Message[0]);
                            }
                            CreateComponentCallback callback = new CreateComponentCallback(d);
                            builder.addNumberedOption(DSConfigMessages.INFO_EDITOR_OPTION_CREATE_A_NEW_COMPONENT.get(rd.getUserFriendlyName()), callback, new Message[0]);
                            if (values.size() > 1) {
                                builder.addNumberedOption(DSConfigMessages.INFO_EDITOR_OPTION_ADD_ALL_COMPONENTS.get(ufpn), MenuResult.success(values), new Message[0]);
                            }
                            builder.addHelpOption(new PropertyHelpCallback(MultiValuedPropertyEditor.this.mo.getManagedObjectDefinition(), d));
                            builder.addCancelOption(true);
                            builder.addQuitOption();
                            app.println();
                            app.println();
                            Menu menu = builder.toMenu();
                            MenuResult result = menu.run();
                            if (result.isSuccess()) {
                                Collection addedValues = result.getValues();
                                currentValues.addAll(addedValues);
                                PropertyValueEditor.this.isLastChoiceReset = false;
                                app.println();
                                app.pressReturnToContinue();
                                return MenuResult.success(false);
                            }
                            if (result.isCancel()) {
                                app.println();
                                app.pressReturnToContinue();
                                return MenuResult.success(false);
                            }
                            return MenuResult.quit();
                        }
                    };
                }
                removeCallback = new MenuCallback<Boolean>(){

                    @Override
                    public MenuResult<Boolean> invoke(ConsoleApplication app) throws CLIException {
                        MenuBuilder<String> builder = new MenuBuilder<String>(app);
                        builder.setPrompt(DSConfigMessages.INFO_EDITOR_PROMPT_SELECT_COMPONENTS_REMOVE.get(ufpn));
                        builder.setAllowMultiSelect(true);
                        builder.setMultipleColumnThreshold(8);
                        for (String value : currentValues) {
                            Message svalue = PropertyValueEditor.getPropertyValues(d, Collections.singleton(value));
                            builder.addNumberedOption(svalue, MenuResult.success(value), new Message[0]);
                        }
                        builder.addHelpOption(new PropertyHelpCallback(MultiValuedPropertyEditor.this.mo.getManagedObjectDefinition(), d));
                        builder.addCancelOption(true);
                        builder.addQuitOption();
                        app.println();
                        app.println();
                        Menu menu = builder.toMenu();
                        MenuResult result = menu.run();
                        if (result.isSuccess()) {
                            Collection removedValues = result.getValues();
                            currentValues.removeAll(removedValues);
                            PropertyValueEditor.this.isLastChoiceReset = false;
                            app.println();
                            app.pressReturnToContinue();
                            return MenuResult.success(false);
                        }
                        if (result.isCancel()) {
                            app.println();
                            app.pressReturnToContinue();
                            return MenuResult.success(false);
                        }
                        return MenuResult.quit();
                    }
                };
            } while ((result = this.runMenu(d, PropertyValueEditor.this.app, defaultValues, oldValues, currentValues, addCallback, removeCallback)).isAgain());
            return result;
        }

        @Override
        public <T extends Enum<T>> MenuResult<Boolean> visitEnum(final EnumPropertyDefinition<T> d, Void p) {
            MenuCallback<Boolean> removeCallback;
            MenuCallback<Boolean> addCallback;
            MenuResult<Boolean> result;
            SortedSet<T> defaultValues = this.mo.getPropertyDefaultValues(d);
            SortedSet<T> oldValues = this.mo.getPropertyValues(d);
            final SortedSet<T> currentValues = this.mo.getPropertyValues(d);
            boolean isFirst = true;
            do {
                if (!isFirst) {
                    PropertyValueEditor.this.app.println();
                    PropertyValueEditor.this.app.println(DSConfigMessages.INFO_EDITOR_HEADING_CONFIGURE_PROPERTY_CONT.get(d.getName()));
                } else {
                    isFirst = false;
                }
                if (currentValues.size() > 1) {
                    PropertyValueEditor.this.app.println();
                    PropertyValueEditor.this.app.println(DSConfigMessages.INFO_EDITOR_HEADING_VALUES_SUMMARY.get(d.getName()));
                    PropertyValueEditor.this.app.println();
                    PropertyValueEditor.displayPropertyValues(PropertyValueEditor.this.app, d, currentValues);
                }
                addCallback = null;
                final EnumSet<T> values = EnumSet.allOf(d.getEnumClass());
                values.removeAll(currentValues);
                if (!values.isEmpty()) {
                    addCallback = new MenuCallback<Boolean>(){

                        @Override
                        public MenuResult<Boolean> invoke(ConsoleApplication app) throws CLIException {
                            MenuBuilder<Object> builder = new MenuBuilder<Object>(app);
                            builder.setPrompt(DSConfigMessages.INFO_EDITOR_PROMPT_SELECT_VALUES_ADD.get());
                            builder.setAllowMultiSelect(true);
                            builder.setMultipleColumnThreshold(8);
                            for (Enum value : values) {
                                Message svalue = PropertyValueEditor.getPropertyValues(d, Collections.singleton(value));
                                builder.addNumberedOption(svalue, MenuResult.success(value), new Message[0]);
                            }
                            if (values.size() > 1) {
                                builder.addNumberedOption(DSConfigMessages.INFO_EDITOR_OPTION_ADD_ALL_VALUES.get(), MenuResult.success(values), new Message[0]);
                            }
                            builder.addHelpOption(new PropertyHelpCallback(MultiValuedPropertyEditor.this.mo.getManagedObjectDefinition(), d));
                            builder.addCancelOption(true);
                            builder.addQuitOption();
                            app.println();
                            app.println();
                            Menu menu = builder.toMenu();
                            MenuResult result = menu.run();
                            if (result.isSuccess()) {
                                Collection addedValues = result.getValues();
                                currentValues.addAll(addedValues);
                                PropertyValueEditor.this.isLastChoiceReset = false;
                                app.println();
                                app.pressReturnToContinue();
                                return MenuResult.success(false);
                            }
                            if (result.isCancel()) {
                                app.println();
                                app.pressReturnToContinue();
                                return MenuResult.success(false);
                            }
                            return MenuResult.quit();
                        }
                    };
                }
                removeCallback = new MenuCallback<Boolean>(){

                    @Override
                    public MenuResult<Boolean> invoke(ConsoleApplication app) throws CLIException {
                        MenuBuilder<Enum> builder = new MenuBuilder<Enum>(app);
                        builder.setPrompt(DSConfigMessages.INFO_EDITOR_PROMPT_SELECT_VALUES_REMOVE.get());
                        builder.setAllowMultiSelect(true);
                        builder.setMultipleColumnThreshold(8);
                        for (Enum value : currentValues) {
                            Message svalue = PropertyValueEditor.getPropertyValues(d, Collections.singleton(value));
                            builder.addNumberedOption(svalue, MenuResult.success(value), new Message[0]);
                        }
                        builder.addHelpOption(new PropertyHelpCallback(MultiValuedPropertyEditor.this.mo.getManagedObjectDefinition(), d));
                        builder.addCancelOption(true);
                        builder.addQuitOption();
                        app.println();
                        app.println();
                        Menu menu = builder.toMenu();
                        MenuResult result = menu.run();
                        if (result.isSuccess()) {
                            Collection removedValues = result.getValues();
                            currentValues.removeAll(removedValues);
                            PropertyValueEditor.this.isLastChoiceReset = false;
                            app.println();
                            app.pressReturnToContinue();
                            return MenuResult.success(false);
                        }
                        if (result.isCancel()) {
                            app.println();
                            app.pressReturnToContinue();
                            return MenuResult.success(false);
                        }
                        return MenuResult.quit();
                    }
                };
            } while ((result = this.runMenu(d, PropertyValueEditor.this.app, defaultValues, oldValues, currentValues, addCallback, removeCallback)).isAgain());
            return result;
        }

        @Override
        public <T> MenuResult<Boolean> visitUnknown(final PropertyDefinition<T> d, Void p) {
            MenuCallback<Boolean> removeCallback;
            MenuCallback<Boolean> addCallback;
            MenuResult<Boolean> result;
            PropertyValueEditor.this.app.println();
            PropertyValueEditor.displayPropertySyntax(PropertyValueEditor.this.app, d);
            SortedSet<T> defaultValues = this.mo.getPropertyDefaultValues(d);
            SortedSet<T> oldValues = this.mo.getPropertyValues(d);
            final SortedSet<T> currentValues = this.mo.getPropertyValues(d);
            boolean isFirst = true;
            do {
                if (!isFirst) {
                    PropertyValueEditor.this.app.println();
                    PropertyValueEditor.this.app.println(DSConfigMessages.INFO_EDITOR_HEADING_CONFIGURE_PROPERTY_CONT.get(d.getName()));
                } else {
                    isFirst = false;
                }
                if (currentValues.size() > 1) {
                    PropertyValueEditor.this.app.println();
                    PropertyValueEditor.this.app.println(DSConfigMessages.INFO_EDITOR_HEADING_VALUES_SUMMARY.get(d.getName()));
                    PropertyValueEditor.this.app.println();
                    PropertyValueEditor.displayPropertyValues(PropertyValueEditor.this.app, d, currentValues);
                }
                addCallback = new MenuCallback<Boolean>(){

                    @Override
                    public MenuResult<Boolean> invoke(ConsoleApplication app) throws CLIException {
                        app.println();
                        TreeSet previousValues = new TreeSet(currentValues);
                        PropertyValueEditor.readPropertyValues(app, MultiValuedPropertyEditor.this.mo.getManagedObjectDefinition(), d, currentValues);
                        TreeSet addedValues = new TreeSet(currentValues);
                        addedValues.removeAll(previousValues);
                        PropertyValueEditor.this.isLastChoiceReset = false;
                        return MenuResult.success(false);
                    }
                };
                removeCallback = new MenuCallback<Boolean>(){

                    @Override
                    public MenuResult<Boolean> invoke(ConsoleApplication app) throws CLIException {
                        MenuBuilder builder = new MenuBuilder(app);
                        builder.setPrompt(DSConfigMessages.INFO_EDITOR_PROMPT_SELECT_VALUES_REMOVE.get());
                        builder.setAllowMultiSelect(true);
                        builder.setMultipleColumnThreshold(8);
                        for (Object value : currentValues) {
                            Message svalue = PropertyValueEditor.getPropertyValues(d, Collections.singleton(value));
                            builder.addNumberedOption(svalue, MenuResult.success(value), new Message[0]);
                        }
                        builder.addHelpOption(new PropertyHelpCallback(MultiValuedPropertyEditor.this.mo.getManagedObjectDefinition(), d));
                        builder.addCancelOption(true);
                        builder.addQuitOption();
                        app.println();
                        app.println();
                        Menu menu = builder.toMenu();
                        MenuResult result = menu.run();
                        if (result.isSuccess()) {
                            Collection removedValues = result.getValues();
                            currentValues.removeAll(removedValues);
                            PropertyValueEditor.this.isLastChoiceReset = false;
                            app.println();
                            app.pressReturnToContinue();
                            return MenuResult.success(false);
                        }
                        if (result.isCancel()) {
                            app.println();
                            app.pressReturnToContinue();
                            return MenuResult.success(false);
                        }
                        return MenuResult.quit();
                    }
                };
            } while ((result = this.runMenu(d, PropertyValueEditor.this.app, defaultValues, oldValues, currentValues, addCallback, removeCallback)).isAgain());
            return result;
        }

        private <T> Message getKeepDefaultValuesMenuOption(PropertyDefinition<T> pd, SortedSet<T> defaultValues, SortedSet<T> oldValues, SortedSet<T> currentValues) {
            DefaultBehaviorQuery<T> query = DefaultBehaviorQuery.query(pd);
            boolean isModified = !currentValues.equals(oldValues);
            boolean isDefault = currentValues.equals(defaultValues);
            if (isModified) {
                switch (currentValues.size()) {
                    case 0: {
                        if (query.isAlias()) {
                            return DSConfigMessages.INFO_EDITOR_OPTION_USE_DEFAULT_ALIAS.get(query.getAliasDescription());
                        }
                        if (query.isInherited()) {
                            if (query.getAliasDescription() != null) {
                                return DSConfigMessages.INFO_EDITOR_OPTION_USE_DEFAULT_INHERITED_ALIAS.get(query.getAliasDescription());
                            }
                            return DSConfigMessages.INFO_EDITOR_OPTION_USE_DEFAULT_INHERITED_ALIAS_UNDEFINED.get();
                        }
                        return DSConfigMessages.INFO_EDITOR_OPTION_LEAVE_UNDEFINED.get();
                    }
                    case 1: {
                        Message svalue = PropertyValueEditor.getPropertyValues(pd, currentValues);
                        if (isDefault) {
                            if (query.isInherited()) {
                                return DSConfigMessages.INFO_EDITOR_OPTION_USE_INHERITED_DEFAULT_VALUE.get(svalue);
                            }
                            return DSConfigMessages.INFO_EDITOR_OPTION_USE_DEFAULT_VALUE.get(svalue);
                        }
                        return DSConfigMessages.INFO_EDITOR_OPTION_USE_VALUE.get(svalue);
                    }
                }
                if (isDefault) {
                    if (query.isInherited()) {
                        return DSConfigMessages.INFO_EDITOR_OPTION_USE_INHERITED_DEFAULT_VALUES.get();
                    }
                    return DSConfigMessages.INFO_EDITOR_OPTION_USE_DEFAULT_VALUES.get();
                }
                return DSConfigMessages.INFO_EDITOR_OPTION_USE_VALUES.get();
            }
            switch (currentValues.size()) {
                case 0: {
                    if (query.isAlias()) {
                        return DSConfigMessages.INFO_EDITOR_OPTION_KEEP_DEFAULT_ALIAS.get(query.getAliasDescription());
                    }
                    if (query.isInherited()) {
                        if (query.getAliasDescription() != null) {
                            return DSConfigMessages.INFO_EDITOR_OPTION_KEEP_DEFAULT_INHERITED_ALIAS.get(query.getAliasDescription());
                        }
                        return DSConfigMessages.INFO_EDITOR_OPTION_KEEP_DEFAULT_INHERITED_ALIAS_UNDEFINED.get();
                    }
                    return DSConfigMessages.INFO_EDITOR_OPTION_LEAVE_UNDEFINED.get();
                }
                case 1: {
                    Message svalue = PropertyValueEditor.getPropertyValues(pd, currentValues);
                    if (isDefault) {
                        if (query.isInherited()) {
                            return DSConfigMessages.INFO_EDITOR_OPTION_KEEP_INHERITED_DEFAULT_VALUE.get(svalue);
                        }
                        return DSConfigMessages.INFO_EDITOR_OPTION_KEEP_DEFAULT_VALUE.get(svalue);
                    }
                    return DSConfigMessages.INFO_EDITOR_OPTION_KEEP_VALUE.get(svalue);
                }
            }
            if (isDefault) {
                if (query.isInherited()) {
                    return DSConfigMessages.INFO_EDITOR_OPTION_KEEP_INHERITED_DEFAULT_VALUES.get();
                }
                return DSConfigMessages.INFO_EDITOR_OPTION_KEEP_DEFAULT_VALUES.get();
            }
            return DSConfigMessages.INFO_EDITOR_OPTION_KEEP_VALUES.get();
        }

        private <T> Message getResetToDefaultValuesMenuOption(PropertyDefinition<T> pd, SortedSet<T> defaultValues, SortedSet<T> currentValues) {
            DefaultBehaviorQuery<T> query = DefaultBehaviorQuery.query(pd);
            boolean isMandatory = pd.hasOption(PropertyOption.MANDATORY);
            if (!isMandatory && query.isAlias()) {
                return DSConfigMessages.INFO_EDITOR_OPTION_RESET_DEFAULT_ALIAS.get(query.getAliasDescription());
            }
            if (query.isDefined()) {
                if (!currentValues.equals(defaultValues)) {
                    Message svalue = PropertyValueEditor.getPropertyValues(pd, defaultValues);
                    if (defaultValues.size() > 1) {
                        return DSConfigMessages.INFO_EDITOR_OPTION_RESET_DEFAULT_VALUES.get(svalue);
                    }
                    return DSConfigMessages.INFO_EDITOR_OPTION_RESET_DEFAULT_VALUE.get(svalue);
                }
                return null;
            }
            if (!isMandatory && query.isInherited()) {
                if (defaultValues.isEmpty()) {
                    if (query.getAliasDescription() != null) {
                        return DSConfigMessages.INFO_EDITOR_OPTION_RESET_DEFAULT_INHERITED_ALIAS.get(query.getAliasDescription());
                    }
                    return DSConfigMessages.INFO_EDITOR_OPTION_RESET_DEFAULT_INHERITED_ALIAS_UNDEFINED.get();
                }
                Message svalue = PropertyValueEditor.getPropertyValues(pd, defaultValues);
                if (defaultValues.size() > 1) {
                    return DSConfigMessages.INFO_EDITOR_OPTION_RESET_INHERITED_DEFAULT_VALUES.get(svalue);
                }
                return DSConfigMessages.INFO_EDITOR_OPTION_RESET_INHERITED_DEFAULT_VALUE.get(svalue);
            }
            if (!isMandatory && query.isUndefined()) {
                return DSConfigMessages.INFO_EDITOR_OPTION_LEAVE_UNDEFINED.get();
            }
            return null;
        }

        private <T> MenuResult<Boolean> runMenu(PropertyDefinition<T> d, ConsoleApplication app, final SortedSet<T> defaultValues, final SortedSet<T> oldValues, final SortedSet<T> currentValues, MenuCallback<Boolean> addCallback, MenuCallback<Boolean> removeCallback) {
            MenuResult result;
            MenuCallback<Boolean> callback;
            MenuBuilder builder = new MenuBuilder(app);
            builder.setPrompt(DSConfigMessages.INFO_EDITOR_PROMPT_MODIFY_MENU.get(d.getName()));
            if (!d.hasOption(PropertyOption.MANDATORY) || !currentValues.isEmpty()) {
                MenuResult<Object> result2 = !oldValues.equals(currentValues) ? MenuResult.success(true) : MenuResult.cancel();
                Message option = this.getKeepDefaultValuesMenuOption(d, defaultValues, oldValues, currentValues);
                builder.addNumberedOption(option, result2, new Message[0]);
                builder.setDefault(Message.raw("1", new Object[0]), result2);
            }
            if (addCallback != null) {
                int i = builder.addNumberedOption(DSConfigMessages.INFO_EDITOR_OPTION_ADD_ONE_OR_MORE_VALUES.get(), addCallback, new Message[0]);
                if (d.hasOption(PropertyOption.MANDATORY) && currentValues.isEmpty()) {
                    builder.setDefault(Message.raw("%d", i), addCallback);
                }
            }
            if (!currentValues.isEmpty()) {
                builder.addNumberedOption(DSConfigMessages.INFO_EDITOR_OPTION_REMOVE_ONE_OR_MORE_VALUES.get(), removeCallback, new Message[0]);
            }
            Message resetOption = null;
            if (!currentValues.equals(defaultValues)) {
                resetOption = this.getResetToDefaultValuesMenuOption(d, defaultValues, currentValues);
            }
            if (!(currentValues.isEmpty() || resetOption != null && defaultValues.isEmpty())) {
                callback = new MenuCallback<Boolean>(){

                    @Override
                    public MenuResult<Boolean> invoke(ConsoleApplication app) throws CLIException {
                        PropertyValueEditor.this.isLastChoiceReset = false;
                        currentValues.clear();
                        app.println();
                        app.pressReturnToContinue();
                        return MenuResult.success(false);
                    }
                };
                builder.addNumberedOption(DSConfigMessages.INFO_EDITOR_OPTION_REMOVE_ALL_VALUES.get(), callback, new Message[0]);
            }
            if (resetOption != null) {
                callback = new MenuCallback<Boolean>(){

                    @Override
                    public MenuResult<Boolean> invoke(ConsoleApplication app) throws CLIException {
                        currentValues.clear();
                        currentValues.addAll(defaultValues);
                        PropertyValueEditor.this.isLastChoiceReset = true;
                        app.println();
                        app.pressReturnToContinue();
                        return MenuResult.success(false);
                    }
                };
                builder.addNumberedOption(resetOption, callback, new Message[0]);
            }
            if (!oldValues.equals(currentValues)) {
                callback = new MenuCallback<Boolean>(){

                    @Override
                    public MenuResult<Boolean> invoke(ConsoleApplication app) throws CLIException {
                        currentValues.clear();
                        currentValues.addAll(oldValues);
                        PropertyValueEditor.this.isLastChoiceReset = false;
                        app.println();
                        app.pressReturnToContinue();
                        return MenuResult.success(false);
                    }
                };
                builder.addNumberedOption(DSConfigMessages.INFO_EDITOR_OPTION_REVERT_CHANGES.get(), callback, new Message[0]);
            }
            builder.addHelpOption(new PropertyHelpCallback(this.mo.getManagedObjectDefinition(), d));
            builder.addQuitOption();
            Menu menu = builder.toMenu();
            try {
                app.println();
                result = menu.run();
            }
            catch (CLIException e) {
                this.e = e;
                return null;
            }
            if (result.isSuccess()) {
                if (((Boolean)result.getValue()).booleanValue()) {
                    this.mo.setPropertyValues(d, currentValues);
                    PropertyValueEditor.this.registerModification(d, currentValues, oldValues);
                    app.println();
                    app.pressReturnToContinue();
                    return MenuResult.success(false);
                }
                app.println();
                return MenuResult.again();
            }
            if (result.isCancel()) {
                app.println();
                app.pressReturnToContinue();
                return MenuResult.success(false);
            }
            return MenuResult.quit();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MandatoryPropertyInitializer
    extends PropertyDefinitionVisitor<MenuResult<Void>, Void>
    implements MenuCallback<Void> {
        private CLIException e = null;
        private final ManagedObject<?> mo;
        private final PropertyDefinition<?> pd;

        private MandatoryPropertyInitializer(ManagedObject<?> mo, PropertyDefinition<?> pd) {
            this.mo = mo;
            this.pd = pd;
        }

        @Override
        public MenuResult<Void> invoke(ConsoleApplication app) throws CLIException {
            PropertyValueEditor.displayPropertyHeader(app, this.pd);
            MenuResult<Void> result = this.pd.accept(this, null);
            if (this.e != null) {
                throw this.e;
            }
            return result;
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> MenuResult<Void> visitAggregation(AggregationPropertyDefinition<C, S> d, Void p) {
            MenuBuilder<String> builder = new MenuBuilder<String>(PropertyValueEditor.this.app);
            builder.setMultipleColumnThreshold(8);
            InstantiableRelationDefinition<C, S> rd = d.getRelationDefinition();
            if (d.hasOption(PropertyOption.MULTI_VALUED)) {
                builder.setPrompt(DSConfigMessages.INFO_EDITOR_PROMPT_SELECT_COMPONENT_MULTI.get(rd.getUserFriendlyPluralName(), d.getName()));
                builder.setAllowMultiSelect(true);
            } else {
                builder.setPrompt(DSConfigMessages.INFO_EDITOR_PROMPT_SELECT_COMPONENT_SINGLE.get(rd.getUserFriendlyName(), d.getName()));
            }
            TreeSet<String> values = new TreeSet<String>(d);
            ManagedObjectPath<?, ?> path = d.getParentPath();
            try {
                values.addAll(Arrays.asList(PropertyValueEditor.this.context.listManagedObjects(path, rd)));
            }
            catch (AuthorizationException e) {
                this.e = new CLIException(e.getMessageObject());
                return MenuResult.quit();
            }
            catch (ManagedObjectNotFoundException e) {
                this.e = new CLIException(e.getMessageObject());
                return MenuResult.cancel();
            }
            catch (CommunicationException e) {
                this.e = new CLIException(e.getMessageObject());
                return MenuResult.quit();
            }
            for (String value : values) {
                Message option = PropertyValueEditor.getPropertyValues(d, Collections.singleton(value));
                builder.addNumberedOption(option, MenuResult.success(value), new Message[0]);
            }
            CreateComponentCallback callback = new CreateComponentCallback(d);
            builder.addNumberedOption(DSConfigMessages.INFO_EDITOR_OPTION_CREATE_A_NEW_COMPONENT.get(rd.getUserFriendlyName()), callback, new Message[0]);
            builder.addHelpOption(new PropertyHelpCallback(this.mo.getManagedObjectDefinition(), d));
            if (PropertyValueEditor.this.app.isMenuDrivenMode()) {
                builder.addCancelOption(true);
            }
            builder.addQuitOption();
            Menu menu = builder.toMenu();
            try {
                PropertyValueEditor.this.app.println();
                MenuResult result = menu.run();
                if (result.isQuit()) {
                    return MenuResult.quit();
                }
                if (result.isCancel()) {
                    return MenuResult.cancel();
                }
                Collection newValues = result.getValues();
                TreeSet<String> oldValues = new TreeSet<String>(this.mo.getPropertyValues(d));
                this.mo.setPropertyValues(d, newValues);
                PropertyValueEditor.this.isLastChoiceReset = false;
                PropertyValueEditor.this.registerModification(d, new TreeSet(newValues), oldValues);
                return MenuResult.success();
            }
            catch (CLIException e) {
                this.e = e;
                return MenuResult.cancel();
            }
        }

        @Override
        public MenuResult<Void> visitBoolean(BooleanPropertyDefinition d, Void p) {
            MenuBuilder<Boolean> builder = new MenuBuilder<Boolean>(PropertyValueEditor.this.app);
            builder.setPrompt(DSConfigMessages.INFO_EDITOR_PROMPT_SELECT_VALUE_SINGLE.get(d.getName()));
            builder.addNumberedOption(DSConfigMessages.INFO_VALUE_TRUE.get(), MenuResult.success(true), new Message[0]);
            builder.addNumberedOption(DSConfigMessages.INFO_VALUE_FALSE.get(), MenuResult.success(false), new Message[0]);
            builder.addHelpOption(new PropertyHelpCallback(this.mo.getManagedObjectDefinition(), d));
            if (PropertyValueEditor.this.app.isMenuDrivenMode()) {
                builder.addCancelOption(true);
            }
            builder.addQuitOption();
            Menu menu = builder.toMenu();
            try {
                PropertyValueEditor.this.app.println();
                MenuResult result = menu.run();
                if (result.isQuit()) {
                    return MenuResult.quit();
                }
                if (result.isCancel()) {
                    return MenuResult.cancel();
                }
                Collection newValues = result.getValues();
                TreeSet<Boolean> oldValues = new TreeSet<Boolean>(this.mo.getPropertyValues(d));
                this.mo.setPropertyValues(d, newValues);
                PropertyValueEditor.this.isLastChoiceReset = false;
                PropertyValueEditor.this.registerModification(d, new TreeSet(newValues), oldValues);
                return MenuResult.success();
            }
            catch (CLIException e) {
                this.e = e;
                return MenuResult.cancel();
            }
        }

        @Override
        public <E extends Enum<E>> MenuResult<Void> visitEnum(EnumPropertyDefinition<E> d, Void x) {
            MenuBuilder<Enum> builder = new MenuBuilder<Enum>(PropertyValueEditor.this.app);
            builder.setMultipleColumnThreshold(8);
            if (d.hasOption(PropertyOption.MULTI_VALUED)) {
                builder.setPrompt(DSConfigMessages.INFO_EDITOR_PROMPT_SELECT_VALUE_MULTI.get(d.getName()));
                builder.setAllowMultiSelect(true);
            } else {
                builder.setPrompt(DSConfigMessages.INFO_EDITOR_PROMPT_SELECT_VALUE_SINGLE.get(d.getName()));
            }
            TreeSet<E> values = new TreeSet<E>(d);
            values.addAll(EnumSet.allOf(d.getEnumClass()));
            for (Enum value : values) {
                Message option = PropertyValueEditor.getPropertyValues(d, Collections.singleton(value));
                builder.addNumberedOption(option, MenuResult.success(value), new Message[0]);
            }
            builder.addHelpOption(new PropertyHelpCallback(this.mo.getManagedObjectDefinition(), d));
            if (PropertyValueEditor.this.app.isMenuDrivenMode()) {
                builder.addCancelOption(true);
            }
            builder.addQuitOption();
            Menu menu = builder.toMenu();
            try {
                PropertyValueEditor.this.app.println();
                MenuResult result = menu.run();
                if (result.isQuit()) {
                    return MenuResult.quit();
                }
                if (result.isCancel()) {
                    return MenuResult.cancel();
                }
                Collection newValues = result.getValues();
                TreeSet<E> oldValues = new TreeSet<E>(this.mo.getPropertyValues(d));
                this.mo.setPropertyValues(d, newValues);
                PropertyValueEditor.this.isLastChoiceReset = false;
                PropertyValueEditor.this.registerModification(d, new TreeSet(newValues), oldValues);
                return MenuResult.success();
            }
            catch (CLIException e) {
                this.e = e;
                return MenuResult.cancel();
            }
        }

        @Override
        public <T> MenuResult<Void> visitUnknown(PropertyDefinition<T> d, Void p) throws UnknownPropertyDefinitionException {
            PropertyValueEditor.this.app.println();
            PropertyValueEditor.displayPropertySyntax(PropertyValueEditor.this.app, d);
            try {
                SortedSet values = PropertyValueEditor.readPropertyValues(PropertyValueEditor.this.app, this.mo.getManagedObjectDefinition(), d);
                TreeSet<T> oldValues = new TreeSet<T>(this.mo.getPropertyValues(d));
                this.mo.setPropertyValues(d, values);
                PropertyValueEditor.this.isLastChoiceReset = false;
                PropertyValueEditor.this.registerModification(d, values, oldValues);
                return MenuResult.success();
            }
            catch (CLIException e) {
                this.e = e;
                return MenuResult.cancel();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultBehaviorQuery<T> {
        private final Message aliasDescription;
        private final Type type;

        public static <T> DefaultBehaviorQuery<T> query(PropertyDefinition<T> pd) {
            DefaultBehaviorProviderVisitor visitor = new DefaultBehaviorProviderVisitor<T, DefaultBehaviorQuery<T>, PropertyDefinition<T>>(){

                @Override
                public DefaultBehaviorQuery<T> visitAbsoluteInherited(AbsoluteInheritedDefaultBehaviorProvider<T> d, PropertyDefinition<T> p) {
                    AbstractManagedObjectDefinition<?, ?> mod = d.getManagedObjectDefinition();
                    String propertyName = d.getPropertyName();
                    PropertyDefinition<?> pd2 = mod.getPropertyDefinition(propertyName);
                    DefaultBehaviorQuery<?> query = DefaultBehaviorQuery.query(pd2);
                    return new DefaultBehaviorQuery(Type.INHERITED, query.getAliasDescription());
                }

                @Override
                public DefaultBehaviorQuery<T> visitAlias(AliasDefaultBehaviorProvider<T> d, PropertyDefinition<T> p) {
                    return new DefaultBehaviorQuery(Type.ALIAS, d.getSynopsis());
                }

                @Override
                public DefaultBehaviorQuery<T> visitDefined(DefinedDefaultBehaviorProvider<T> d, PropertyDefinition<T> p) {
                    return new DefaultBehaviorQuery(Type.DEFINED, null);
                }

                @Override
                public DefaultBehaviorQuery<T> visitRelativeInherited(RelativeInheritedDefaultBehaviorProvider<T> d, PropertyDefinition<T> p) {
                    AbstractManagedObjectDefinition<?, ?> mod = d.getManagedObjectDefinition();
                    String propertyName = d.getPropertyName();
                    PropertyDefinition<?> pd2 = mod.getPropertyDefinition(propertyName);
                    DefaultBehaviorQuery<?> query = DefaultBehaviorQuery.query(pd2);
                    return new DefaultBehaviorQuery(Type.INHERITED, query.getAliasDescription());
                }

                @Override
                public DefaultBehaviorQuery<T> visitUndefined(UndefinedDefaultBehaviorProvider<T> d, PropertyDefinition<T> p) {
                    return new DefaultBehaviorQuery(Type.UNDEFINED, null);
                }
            };
            return (DefaultBehaviorQuery)pd.getDefaultBehaviorProvider().accept(visitor, pd);
        }

        private DefaultBehaviorQuery(Type type, Message aliasDescription) {
            this.type = type;
            this.aliasDescription = aliasDescription;
        }

        public Message getAliasDescription() {
            return this.aliasDescription;
        }

        public boolean isAlias() {
            return this.type == Type.ALIAS;
        }

        public boolean isDefined() {
            return this.type == Type.DEFINED;
        }

        public boolean isInherited() {
            return this.type == Type.INHERITED;
        }

        public boolean isUndefined() {
            return this.type == Type.UNDEFINED;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Type {
            ALIAS,
            DEFINED,
            INHERITED,
            UNDEFINED;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComponentHelpCallback
    implements HelpCallback {
        private final ManagedObject<?> mo;
        private final Collection<PropertyDefinition<?>> properties;

        private ComponentHelpCallback(ManagedObject<?> mo, Collection<PropertyDefinition<?>> c) {
            this.mo = mo;
            this.properties = c;
        }

        @Override
        public void display(ConsoleApplication app) {
            app.println();
            HelpSubCommandHandler.displaySingleComponent(app, this.mo.getManagedObjectDefinition(), this.properties);
            app.println();
            app.pressReturnToContinue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CreateComponentCallback<C extends ConfigurationClient, S extends Configuration>
    implements MenuCallback<String> {
        private final AggregationPropertyDefinition<C, S> pd;

        private CreateComponentCallback(AggregationPropertyDefinition<C, S> pd) {
            this.pd = pd;
        }

        @Override
        public MenuResult<String> invoke(ConsoleApplication app) throws CLIException {
            try {
                ManagedObject<?> parent;
                InstantiableRelationDefinition<C, S> rd = this.pd.getRelationDefinition();
                ManagedObjectPath<?, ?> path = this.pd.getParentPath();
                Message ufn = rd.getUserFriendlyName();
                try {
                    parent = PropertyValueEditor.this.context.getManagedObject(path);
                }
                catch (AuthorizationException e) {
                    Message msg = DSConfigMessages.ERR_DSCFG_ERROR_CREATE_AUTHZ.get(ufn);
                    throw new ClientException(50, msg);
                }
                catch (DefinitionDecodingException e) {
                    Message pufn = path.getManagedObjectDefinition().getUserFriendlyName();
                    Message msg = DSConfigMessages.ERR_DSCFG_ERROR_GET_PARENT_DDE.get(pufn, pufn, pufn);
                    throw new ClientException(80, msg);
                }
                catch (ManagedObjectDecodingException e) {
                    Message pufn = path.getManagedObjectDefinition().getUserFriendlyName();
                    Message msg = DSConfigMessages.ERR_DSCFG_ERROR_GET_PARENT_MODE.get(pufn);
                    throw new ClientException(80, msg, e);
                }
                catch (CommunicationException e) {
                    Message msg = DSConfigMessages.ERR_DSCFG_ERROR_CREATE_CE.get(ufn, e.getMessage());
                    throw new ClientException(81, msg);
                }
                catch (ManagedObjectNotFoundException e) {
                    Message pufn = path.getManagedObjectDefinition().getUserFriendlyName();
                    Message msg = DSConfigMessages.ERR_DSCFG_ERROR_GET_PARENT_MONFE.get(pufn);
                    if (app.isInteractive()) {
                        app.println();
                        app.printVerboseMessage(msg);
                        return MenuResult.cancel();
                    }
                    throw new ClientException(32, msg);
                }
                app.println();
                app.println();
                return CreateSubCommandHandler.createManagedObject(app, PropertyValueEditor.this.context, parent, rd);
            }
            catch (ClientException e) {
                app.println();
                app.println(e.getMessageObject());
                app.println();
                app.pressReturnToContinue();
                return MenuResult.cancel();
            }
        }
    }
}

