/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.cli.ConsoleApplication;

public class WaitForFileDelete
extends ConsoleApplication {
    private static final String CLASS_NAME = "org.opends.server.tools.WaitForFileDelete";
    public static final int EXIT_CODE_SUCCESS = 0;
    public static final int EXIT_CODE_INTERNAL_ERROR = 1;
    public static final int EXIT_CODE_TIMEOUT = 2;

    public WaitForFileDelete(PrintStream out, PrintStream err, InputStream in) {
        super(in, (OutputStream)out, (OutputStream)err);
    }

    public static void main(String[] args) {
        int retCode = WaitForFileDelete.mainCLI(args, true, System.out, System.err, System.in);
        System.exit(retCode);
    }

    public static int mainCLI(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream, InputStream inStream) {
        int exitCode;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        try {
            WaitForFileDelete wffd = new WaitForFileDelete(out, err, System.in);
            exitCode = wffd.mainWait(args);
            if (exitCode != 0) {
                exitCode = StaticUtils.filterExitCode(exitCode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            exitCode = 1;
        }
        return exitCode;
    }

    private int mainWait(String[] args) {
        long stopWaitingTime;
        BooleanArgument showUsage = null;
        IntegerArgument timeout = null;
        StringArgument logFilePath = null;
        StringArgument targetFilePath = null;
        StringArgument outputFilePath = null;
        BooleanArgument useLastKnownGoodConfig = null;
        BooleanArgument quietMode = null;
        Message toolDescription = ToolMessages.INFO_WAIT4DEL_TOOL_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser(CLASS_NAME, toolDescription, false);
        try {
            targetFilePath = new StringArgument("targetfile", Character.valueOf('f'), "targetFile", true, false, true, ToolMessages.INFO_PATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_WAIT4DEL_DESCRIPTION_TARGET_FILE.get());
            argParser.addArgument(targetFilePath);
            logFilePath = new StringArgument("logfile", Character.valueOf('l'), "logFile", false, false, true, ToolMessages.INFO_PATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_WAIT4DEL_DESCRIPTION_LOG_FILE.get());
            argParser.addArgument(logFilePath);
            outputFilePath = new StringArgument("outputfile", Character.valueOf('o'), "outputFile", false, false, true, ToolMessages.INFO_PATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_WAIT4DEL_DESCRIPTION_OUTPUT_FILE.get());
            argParser.addArgument(outputFilePath);
            timeout = new IntegerArgument("timeout", Character.valueOf('t'), "timeout", true, false, true, ToolMessages.INFO_SECONDS_PLACEHOLDER.get(), DirectoryServer.DEFAULT_TIMEOUT, null, true, 0, false, 0, ToolMessages.INFO_WAIT4DEL_DESCRIPTION_TIMEOUT.get());
            argParser.addArgument(timeout);
            useLastKnownGoodConfig = new BooleanArgument("lastknowngoodconfig", Character.valueOf('L'), "useLastKnownGoodConfig", CoreMessages.INFO_DSCORE_DESCRIPTION_LASTKNOWNGOODCFG.get());
            argParser.addArgument(useLastKnownGoodConfig);
            quietMode = new BooleanArgument("quiet", Character.valueOf('Q'), "quiet", ToolMessages.INFO_DESCRIPTION_QUIET.get());
            argParser.addArgument(quietMode);
            showUsage = new BooleanArgument("help", Character.valueOf('H'), "help", ToolMessages.INFO_WAIT4DEL_DESCRIPTION_HELP.get());
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            this.println(message);
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            this.println(message);
            this.println(Message.raw(argParser.getUsage(), new Object[0]));
            return 1;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        File targetFile = new File(targetFilePath.getValue());
        if (!targetFile.exists()) {
            return 0;
        }
        long logFileOffset = 0L;
        RandomAccessFile logFile = null;
        if (logFilePath.isPresent()) {
            try {
                File f = new File(logFilePath.getValue());
                if (f.exists()) {
                    logFile = new RandomAccessFile(f, "r");
                    logFileOffset = logFile.length();
                    logFile.seek(logFileOffset);
                }
            }
            catch (Exception e) {
                Message message = ToolMessages.WARN_WAIT4DEL_CANNOT_OPEN_LOG_FILE.get(logFilePath.getValue(), String.valueOf(e));
                this.println(message);
                logFile = null;
            }
        }
        RandomAccessFile outputFile = null;
        long outputFileOffset = 0L;
        if (logFile != null && outputFilePath.isPresent()) {
            try {
                File f = new File(outputFilePath.getValue());
                if (f.exists()) {
                    outputFile = new RandomAccessFile(f, "rw");
                    outputFileOffset = outputFile.length();
                    outputFile.seek(outputFileOffset);
                }
            }
            catch (Exception e) {
                Message message = ToolMessages.WARN_WAIT4DEL_CANNOT_OPEN_OUTPUT_FILE.get(outputFilePath.getValue(), String.valueOf(e));
                this.println(message);
                outputFile = null;
            }
        }
        try {
            long timeoutMillis = 1000L * (long)Integer.parseInt(timeout.getValue());
            stopWaitingTime = timeoutMillis > 0L ? System.currentTimeMillis() + timeoutMillis : Long.MAX_VALUE;
        }
        catch (Exception e) {
            stopWaitingTime = System.currentTimeMillis() + 60000L;
        }
        byte[] logBuffer = new byte[8192];
        while (System.currentTimeMillis() < stopWaitingTime) {
            if (logFile != null) {
                try {
                    while (logFile.length() > logFileOffset) {
                        int bytesRead = logFile.read(logBuffer);
                        if (bytesRead <= 0) continue;
                        if (outputFile == null) {
                            this.getOutputStream().write(logBuffer, 0, bytesRead);
                            this.getOutputStream().flush();
                        } else {
                            outputFile.write(logBuffer, 0, bytesRead);
                        }
                        logFileOffset += (long)bytesRead;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!targetFile.exists()) break;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ie) {}
        }
        if (outputFile != null) {
            try {
                outputFile.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (targetFile.exists()) {
            this.println(ToolMessages.ERR_TIMEOUT_DURING_STARTUP.get(Integer.parseInt(timeout.getValue()), timeout.getLongIdentifier()));
            return 2;
        }
        return 0;
    }

    public boolean isAdvancedMode() {
        return false;
    }

    public boolean isInteractive() {
        return false;
    }

    public boolean isMenuDrivenMode() {
        return false;
    }

    public boolean isQuiet() {
        return false;
    }

    public boolean isScriptFriendly() {
        return false;
    }

    public boolean isVerbose() {
        return false;
    }
}

