/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.config.ConfigException;
import org.opends.server.core.CoreConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.TextErrorLogPublisher;
import org.opends.server.loggers.TextWriter;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.TextDebugLogPublisher;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.tasks.RestoreTask;
import org.opends.server.tools.BackendToolUtils;
import org.opends.server.tools.tasks.TaskTool;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.BackupInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.types.RawAttribute;
import org.opends.server.types.RestoreConfig;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.LDAPConnectionArgumentParser;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.cli.CLIException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestoreDB
extends TaskTool {
    private BooleanArgument displayUsage = null;
    private BooleanArgument listBackups = null;
    private BooleanArgument verifyOnly = null;
    private StringArgument backupIDString = null;
    private StringArgument configClass = null;
    private StringArgument configFile = null;
    private StringArgument backupDirectory = null;

    public static void main(String[] args) {
        int retCode = RestoreDB.mainRestoreDB(args, true, System.out, System.err);
        if (retCode != 0) {
            System.exit(StaticUtils.filterExitCode(retCode));
        }
    }

    public static int mainRestoreDB(String[] args) {
        return RestoreDB.mainRestoreDB(args, true, System.out, System.err);
    }

    public static int mainRestoreDB(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        RestoreDB tool = new RestoreDB();
        return tool.process(args, initializeServer, outStream, errStream);
    }

    private int process(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        LDAPConnectionArgumentParser argParser = this.createArgParser("org.opends.server.tools.RestoreDB", ToolMessages.INFO_RESTOREDB_TOOL_DESCRIPTION.get());
        try {
            this.configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", true, false, true, ToolMessages.INFO_CONFIGCLASS_PLACEHOLDER.get(), ConfigFileHandler.class.getName(), null, ToolMessages.INFO_DESCRIPTION_CONFIG_CLASS.get());
            this.configClass.setHidden(true);
            argParser.addArgument(this.configClass);
            this.configFile = new StringArgument("configfile", Character.valueOf('f'), "configFile", true, false, true, ToolMessages.INFO_CONFIGFILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_CONFIG_FILE.get());
            this.configFile.setHidden(true);
            argParser.addArgument(this.configFile);
            this.backupIDString = new StringArgument("backupid", Character.valueOf('I'), "backupID", false, false, true, ToolMessages.INFO_BACKUPID_PLACEHOLDER.get(), null, null, ToolMessages.INFO_RESTOREDB_DESCRIPTION_BACKUP_ID.get());
            argParser.addArgument(this.backupIDString);
            this.backupDirectory = new StringArgument("backupdirectory", Character.valueOf('d'), "backupDirectory", true, false, true, ToolMessages.INFO_BACKUPDIR_PLACEHOLDER.get(), null, null, ToolMessages.INFO_RESTOREDB_DESCRIPTION_BACKUP_DIR.get());
            argParser.addArgument(this.backupDirectory);
            this.listBackups = new BooleanArgument("listbackups", Character.valueOf('l'), "listBackups", ToolMessages.INFO_RESTOREDB_DESCRIPTION_LIST_BACKUPS.get());
            argParser.addArgument(this.listBackups);
            this.verifyOnly = new BooleanArgument("verifyonly", Character.valueOf('n'), "dry-run", ToolMessages.INFO_RESTOREDB_DESCRIPTION_VERIFY_ONLY.get());
            argParser.addArgument(this.verifyOnly);
            this.displayUsage = new BooleanArgument("help", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_USAGE.get());
            argParser.addArgument(this.displayUsage);
            argParser.setUsageArgument(this.displayUsage);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            argParser.getArguments().initArgumentsWithConfiguration();
        }
        catch (ConfigException ce) {
            // empty catch block
        }
        try {
            argParser.parseArguments(args);
            this.validateTaskArgs();
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 1;
        }
        catch (CLIException ce) {
            err.println(StaticUtils.wrapText(ce.getMessageObject(), ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        if (this.listBackups.isPresent() && argParser.connectionArgumentsPresent()) {
            Message message = ToolMessages.ERR_LDAP_CONN_INCOMPATIBLE_ARGS.get(this.listBackups.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        return this.process(argParser, initializeServer, out, err);
    }

    @Override
    public void addTaskAttributes(List<RawAttribute> attributes) {
        ArrayList<ByteString> values;
        if (this.backupDirectory.getValue() != null && !this.backupDirectory.getValue().equals(this.backupDirectory.getDefaultValue())) {
            values = new ArrayList<ByteString>(1);
            values.add(ByteString.valueOf(this.backupDirectory.getValue()));
            attributes.add(new LDAPAttribute("ds-backup-directory-path", values));
        }
        if (this.backupIDString.getValue() != null && !this.backupIDString.getValue().equals(this.backupIDString.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf(this.backupIDString.getValue()));
            attributes.add(new LDAPAttribute("ds-backup-id", values));
        }
        if (this.verifyOnly.getValue() != null && !this.verifyOnly.getValue().equals(this.verifyOnly.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf(this.verifyOnly.getValue()));
            attributes.add(new LDAPAttribute("ds-task-restore-verify-only", values));
        }
    }

    @Override
    public String getTaskObjectclass() {
        return "ds-task-restore";
    }

    @Override
    public Class getTaskClass() {
        return RestoreTask.class;
    }

    @Override
    protected int processLocal(boolean initializeServer, PrintStream out, PrintStream err) {
        Message message;
        StringBuilder failureReason;
        String lockFile;
        BackupDirectory backupDir;
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        if (initializeServer) {
            try {
                DirectoryServer.bootstrapClient();
                DirectoryServer.initializeJMX();
            }
            catch (Exception e) {
                Message message2 = ToolMessages.ERR_SERVER_BOOTSTRAP_ERROR.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeConfiguration(this.configClass.getValue(), this.configFile.getValue());
            }
            catch (InitializationException ie) {
                Message message3 = ToolMessages.ERR_CANNOT_LOAD_CONFIG.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message4 = ToolMessages.ERR_CANNOT_LOAD_CONFIG.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeSchema();
            }
            catch (ConfigException ce) {
                Message message5 = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(ce.getMessage());
                err.println(StaticUtils.wrapText(message5, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                Message message6 = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message6, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message7 = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message7, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                CoreConfigManager coreConfigManager = new CoreConfigManager();
                coreConfigManager.initializeCoreConfig();
            }
            catch (ConfigException ce) {
                Message message8 = ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(ce.getMessage());
                err.println(StaticUtils.wrapText(message8, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                Message message9 = ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message9, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message10 = ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message10, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeCryptoManager();
            }
            catch (ConfigException ce) {
                Message message11 = ToolMessages.ERR_CANNOT_INITIALIZE_CRYPTO_MANAGER.get(ce.getMessage());
                err.println(StaticUtils.wrapText(message11, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                Message message12 = ToolMessages.ERR_CANNOT_INITIALIZE_CRYPTO_MANAGER.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message12, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message13 = ToolMessages.ERR_CANNOT_INITIALIZE_CRYPTO_MANAGER.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message13, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                TextErrorLogPublisher errorLogPublisher = TextErrorLogPublisher.getStartupTextErrorPublisher(new TextWriter.STREAM(out));
                TextDebugLogPublisher debugLogPublisher = TextDebugLogPublisher.getStartupTextDebugPublisher(new TextWriter.STREAM(out));
                ErrorLogger.addErrorLogPublisher(errorLogPublisher);
                DebugLogger.addDebugLogPublisher(debugLogPublisher);
            }
            catch (Exception e) {
                err.println("Error installing the custom error logger: " + StaticUtils.stackTraceToSingleLineString(e));
            }
        }
        try {
            backupDir = BackupDirectory.readBackupDirectoryDescriptor(this.backupDirectory.getValue());
        }
        catch (Exception e) {
            Message message14 = ToolMessages.ERR_RESTOREDB_CANNOT_READ_BACKUP_DIRECTORY.get(this.backupDirectory.getValue(), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(message14);
            return 1;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z");
        if (this.listBackups.isPresent()) {
            for (BackupInfo backupInfo : backupDir.getBackups().values()) {
                Message message15 = ToolMessages.INFO_RESTOREDB_LIST_BACKUP_ID.get(backupInfo.getBackupID());
                out.println(message15);
                message15 = ToolMessages.INFO_RESTOREDB_LIST_BACKUP_DATE.get(dateFormat.format(backupInfo.getBackupDate()));
                out.println(message15);
                message15 = ToolMessages.INFO_RESTOREDB_LIST_INCREMENTAL.get(String.valueOf(backupInfo.isIncremental()));
                out.println(message15);
                message15 = ToolMessages.INFO_RESTOREDB_LIST_COMPRESSED.get(String.valueOf(backupInfo.isCompressed()));
                out.println(message15);
                message15 = ToolMessages.INFO_RESTOREDB_LIST_ENCRYPTED.get(String.valueOf(backupInfo.isEncrypted()));
                out.println(message15);
                byte[] hash = backupInfo.getUnsignedHash();
                message15 = ToolMessages.INFO_RESTOREDB_LIST_HASHED.get(String.valueOf(hash != null));
                out.println(message15);
                byte[] signature = backupInfo.getSignedHash();
                message15 = ToolMessages.INFO_RESTOREDB_LIST_SIGNED.get(String.valueOf(signature != null));
                out.println(message15);
                StringBuilder dependencyList = new StringBuilder();
                HashSet<String> dependencyIDs = backupInfo.getDependencies();
                if (!dependencyIDs.isEmpty()) {
                    Iterator<String> iterator = dependencyIDs.iterator();
                    dependencyList.append(iterator.next());
                    while (iterator.hasNext()) {
                        dependencyList.append(", ");
                        dependencyList.append(iterator.next());
                    }
                } else {
                    dependencyList.append("none");
                }
                message15 = ToolMessages.INFO_RESTOREDB_LIST_DEPENDENCIES.get(dependencyList.toString());
                out.println(message15);
                out.println();
            }
            return 0;
        }
        BackupInfo backupInfo = backupDir.getLatestBackup();
        if (backupInfo == null) {
            Message message16 = ToolMessages.ERR_RESTOREDB_NO_BACKUPS_IN_DIRECTORY.get(this.backupDirectory.getValue());
            ErrorLogger.logError(message16);
            return 1;
        }
        String backupID = backupInfo.getBackupID();
        if (this.backupIDString.isPresent() && (backupInfo = backupDir.getBackupInfo(backupID = this.backupIDString.getValue())) == null) {
            Message message17 = ToolMessages.ERR_RESTOREDB_INVALID_BACKUP_ID.get(backupID, this.backupDirectory.getValue());
            ErrorLogger.logError(message17);
            return 1;
        }
        if (backupInfo.isEncrypted() || null != backupInfo.getSignedHash()) {
            Message message18 = ToolMessages.ERR_RESTOREDB_ENCRYPT_OR_SIGN_REQUIRES_ONLINE.get();
            ErrorLogger.logError(message18);
            return 1;
        }
        DN configEntryDN = backupDir.getConfigEntryDN();
        ArrayList<Backend> backendList = new ArrayList<Backend>();
        ArrayList<BackendCfg> entryList = new ArrayList<BackendCfg>();
        ArrayList<List<DN>> dnList = new ArrayList<List<DN>>();
        BackendToolUtils.getBackends(backendList, entryList, dnList);
        Backend backend = null;
        int numBackends = backendList.size();
        for (int i = 0; i < numBackends; ++i) {
            Backend b = backendList.get(i);
            BackendCfg e = entryList.get(i);
            if (!e.dn().equals(configEntryDN)) continue;
            backend = b;
            break;
        }
        if (backend == null) {
            Message message19 = ToolMessages.ERR_RESTOREDB_NO_BACKENDS_FOR_DN.get(this.backupDirectory.getValue(), configEntryDN.toString());
            ErrorLogger.logError(message19);
            return 1;
        }
        if (!backend.supportsRestore()) {
            Message message20 = ToolMessages.ERR_RESTOREDB_CANNOT_RESTORE.get(backend.getBackendID());
            ErrorLogger.logError(message20);
            return 1;
        }
        RestoreConfig restoreConfig = new RestoreConfig(backupDir, backupID, this.verifyOnly.isPresent());
        try {
            lockFile = LockFileManager.getBackendLockFileName(backend);
            failureReason = new StringBuilder();
            if (!LockFileManager.acquireExclusiveLock(lockFile, failureReason)) {
                Message message21 = ToolMessages.ERR_RESTOREDB_CANNOT_LOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                ErrorLogger.logError(message21);
                return 1;
            }
        }
        catch (Exception e) {
            message = ToolMessages.ERR_RESTOREDB_CANNOT_LOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(message);
            return 1;
        }
        try {
            backend.restoreBackup(restoreConfig);
        }
        catch (DirectoryException de) {
            message = ToolMessages.ERR_RESTOREDB_ERROR_DURING_BACKUP.get(backupID, backupDir.getPath(), de.getMessageObject());
            ErrorLogger.logError(message);
        }
        catch (Exception e) {
            message = ToolMessages.ERR_RESTOREDB_ERROR_DURING_BACKUP.get(backupID, backupDir.getPath(), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(message);
        }
        try {
            lockFile = LockFileManager.getBackendLockFileName(backend);
            failureReason = new StringBuilder();
            if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                Message message22 = ToolMessages.WARN_RESTOREDB_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                ErrorLogger.logError(message22);
            }
        }
        catch (Exception e) {
            message = ToolMessages.WARN_RESTOREDB_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(message);
        }
        return 0;
    }

    @Override
    public String getTaskId() {
        if (this.backupIDString != null) {
            return this.backupIDString.getValue();
        }
        return null;
    }
}

