/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.controls.PasswordPolicyErrorType;
import org.opends.server.controls.PasswordPolicyResponseControl;
import org.opends.server.controls.PasswordPolicyWarningType;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.ldap.ExtendedRequestProtocolOp;
import org.opends.server.protocols.ldap.ExtendedResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.protocols.ldap.UnbindRequestProtocolOp;
import org.opends.server.tools.LDAPConnection;
import org.opends.server.tools.LDAPConnectionException;
import org.opends.server.tools.LDAPConnectionOptions;
import org.opends.server.tools.LDAPReader;
import org.opends.server.tools.LDAPToolUtils;
import org.opends.server.tools.LDAPWriter;
import org.opends.server.tools.SSLConnectionFactory;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.EmbeddedUtils;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

public class LDAPPasswordModify {
    private static final String CLASS_NAME = "org.opends.server.tools.LDAPPasswordModify";

    public static void main(String[] args) {
        int returnCode = LDAPPasswordModify.mainPasswordModify(args, true, System.out, System.err);
        if (returnCode != 0) {
            System.exit(StaticUtils.filterExitCode(returnCode));
        }
    }

    public static int mainPasswordModify(String[] args) {
        return LDAPPasswordModify.mainPasswordModify(args, true, System.out, System.err);
    }

    public static int mainPasswordModify(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        ByteString responseValue;
        List<Control> responseControls;
        String pw;
        String dn;
        int port;
        StringArgument controlStr;
        FileBasedArgument sslTrustStorePINFile;
        StringArgument sslTrustStorePIN;
        StringArgument sslTrustStore;
        FileBasedArgument sslKeyStorePINFile;
        StringArgument sslKeyStorePIN;
        StringArgument sslKeyStore;
        BooleanArgument sslBlindTrust;
        FileBasedArgument currentPWFile;
        StringArgument currentPW;
        FileBasedArgument newPWFile;
        StringArgument newPW;
        BooleanArgument provideDNForAuthzID;
        StringArgument authzID;
        FileBasedArgument bindPWFile;
        StringArgument bindPW;
        StringArgument bindDN;
        BooleanArgument useStartTLS;
        BooleanArgument useSSL;
        IntegerArgument ldapPort;
        StringArgument ldapHost;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        StringArgument certNickname = null;
        Message toolDescription = ToolMessages.INFO_LDAPPWMOD_TOOL_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser(CLASS_NAME, toolDescription, false);
        try {
            StringArgument propertiesFileArgument = new StringArgument("propertiesFilePath", null, "propertiesFilePath", false, false, true, ToolMessages.INFO_PROP_FILE_PATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_PROP_FILE_PATH.get());
            argParser.addArgument(propertiesFileArgument);
            argParser.setFilePropertiesArgument(propertiesFileArgument);
            BooleanArgument noPropertiesFileArgument = new BooleanArgument("noPropertiesFileArgument", null, "noPropertiesFile", ToolMessages.INFO_DESCRIPTION_NO_PROP_FILE.get());
            argParser.addArgument(noPropertiesFileArgument);
            argParser.setNoPropertiesFileArgument(noPropertiesFileArgument);
            ldapHost = new StringArgument("ldaphost", Character.valueOf('h'), "hostname", false, false, true, ToolMessages.INFO_HOST_PLACEHOLDER.get(), "127.0.0.1", null, ToolMessages.INFO_LDAPPWMOD_DESCRIPTION_HOST.get());
            ldapHost.setPropertyName("hostname");
            argParser.addArgument(ldapHost);
            ldapPort = new IntegerArgument("ldapport", Character.valueOf('p'), "port", false, false, true, ToolMessages.INFO_PORT_PLACEHOLDER.get(), 389, null, true, 1, true, 65535, ToolMessages.INFO_LDAPPWMOD_DESCRIPTION_PORT.get());
            ldapPort.setPropertyName("port");
            argParser.addArgument(ldapPort);
            useSSL = new BooleanArgument("usessl", Character.valueOf('Z'), "useSSL", ToolMessages.INFO_LDAPPWMOD_DESCRIPTION_USE_SSL.get());
            useSSL.setPropertyName("useSSL");
            argParser.addArgument(useSSL);
            useStartTLS = new BooleanArgument("usestarttls", Character.valueOf('q'), "useStartTLS", ToolMessages.INFO_LDAPPWMOD_DESCRIPTION_USE_STARTTLS.get());
            useStartTLS.setPropertyName("useStartTLS");
            argParser.addArgument(useStartTLS);
            bindDN = new StringArgument("binddn", Character.valueOf('D'), "bindDN", false, false, true, ToolMessages.INFO_BINDDN_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDAPPWMOD_DESCRIPTION_BIND_DN.get());
            bindDN.setPropertyName("bindDN");
            argParser.addArgument(bindDN);
            bindPW = new StringArgument("bindpw", Character.valueOf('w'), "bindPassword", false, false, true, ToolMessages.INFO_BINDPWD_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDAPPWMOD_DESCRIPTION_BIND_PW.get());
            bindPW.setPropertyName("bindPassword");
            argParser.addArgument(bindPW);
            bindPWFile = new FileBasedArgument("bindpwfile", Character.valueOf('j'), "bindPasswordFile", false, false, ToolMessages.INFO_BINDPWD_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDAPPWMOD_DESCRIPTION_BIND_PW_FILE.get());
            bindPWFile.setPropertyName("bindPasswordFile");
            argParser.addArgument(bindPWFile);
            authzID = new StringArgument("authzid", Character.valueOf('a'), "authzID", false, false, true, ToolMessages.INFO_PROXYAUTHID_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDAPPWMOD_DESCRIPTION_AUTHZID.get());
            authzID.setPropertyName("authzID");
            argParser.addArgument(authzID);
            provideDNForAuthzID = new BooleanArgument("providednforauthzid", Character.valueOf('A'), "provideDNForAuthzID", ToolMessages.INFO_LDAPPWMOD_DESCRIPTION_PROVIDE_DN_FOR_AUTHZID.get());
            provideDNForAuthzID.setPropertyName("provideDNForAuthzID");
            argParser.addArgument(provideDNForAuthzID);
            newPW = new StringArgument("newpw", Character.valueOf('n'), "newPassword", false, false, true, ToolMessages.INFO_NEW_PASSWORD_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDAPPWMOD_DESCRIPTION_NEWPW.get());
            newPW.setPropertyName("newPassword");
            argParser.addArgument(newPW);
            newPWFile = new FileBasedArgument("newpwfile", Character.valueOf('N'), "newPasswordFile", false, false, ToolMessages.INFO_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDAPPWMOD_DESCRIPTION_NEWPWFILE.get());
            newPWFile.setPropertyName("newPasswordFile");
            argParser.addArgument(newPWFile);
            currentPW = new StringArgument("currentpw", Character.valueOf('c'), "currentPassword", false, false, true, ToolMessages.INFO_CURRENT_PASSWORD_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDAPPWMOD_DESCRIPTION_CURRENTPW.get());
            currentPW.setPropertyName("currentPassword");
            argParser.addArgument(currentPW);
            currentPWFile = new FileBasedArgument("currentpwfile", Character.valueOf('C'), "currentPasswordFile", false, false, ToolMessages.INFO_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDAPPWMOD_DESCRIPTION_CURRENTPWFILE.get());
            currentPWFile.setPropertyName("currentPasswordFile");
            argParser.addArgument(currentPWFile);
            sslBlindTrust = new BooleanArgument("blindtrust", Character.valueOf('X'), "trustAll", ToolMessages.INFO_LDAPPWMOD_DESCRIPTION_BLIND_TRUST.get());
            sslBlindTrust.setPropertyName("trustAll");
            argParser.addArgument(sslBlindTrust);
            sslKeyStore = new StringArgument("keystorepath", Character.valueOf('K'), "keyStorePath", false, false, true, ToolMessages.INFO_KEYSTOREPATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDAPPWMOD_DESCRIPTION_KEYSTORE.get());
            sslKeyStore.setPropertyName("keyStorePath");
            argParser.addArgument(sslKeyStore);
            sslKeyStorePIN = new StringArgument("keystorepassword", Character.valueOf('W'), "keyStorePassword", false, false, true, ToolMessages.INFO_KEYSTORE_PWD_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDAPPWMOD_DESCRIPTION_KEYSTORE_PIN.get());
            sslKeyStorePIN.setPropertyName("keyStorePassword");
            argParser.addArgument(sslKeyStorePIN);
            sslKeyStorePINFile = new FileBasedArgument("keystorepasswordfile", Character.valueOf('u'), "keyStorePasswordFile", false, false, ToolMessages.INFO_KEYSTORE_PWD_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDAPPWMOD_DESCRIPTION_KEYSTORE_PINFILE.get());
            sslKeyStorePINFile.setPropertyName("keyStorePasswordFile");
            argParser.addArgument(sslKeyStorePINFile);
            certNickname = new StringArgument("certnickname", null, "certNickname", false, false, true, ToolMessages.INFO_NICKNAME_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_CERT_NICKNAME.get());
            certNickname.setPropertyName("certNickname");
            argParser.addArgument(certNickname);
            sslTrustStore = new StringArgument("truststorepath", Character.valueOf('P'), "trustStorePath", false, false, true, ToolMessages.INFO_TRUSTSTOREPATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDAPPWMOD_DESCRIPTION_TRUSTSTORE.get());
            sslTrustStore.setPropertyName("trustStorePath");
            argParser.addArgument(sslTrustStore);
            sslTrustStorePIN = new StringArgument("truststorepassword", null, "trustStorePassword", false, false, true, ToolMessages.INFO_TRUSTSTORE_PWD_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDAPPWMOD_DESCRIPTION_TRUSTSTORE_PIN.get());
            sslTrustStorePIN.setPropertyName("trustStorePassword");
            argParser.addArgument(sslTrustStorePIN);
            sslTrustStorePINFile = new FileBasedArgument("truststorepasswordfile", Character.valueOf('U'), "trustStorePasswordFile", false, false, ToolMessages.INFO_TRUSTSTORE_PWD_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDAPPWMOD_DESCRIPTION_TRUSTSTORE_PINFILE.get());
            sslTrustStorePINFile.setPropertyName("trustStorePasswordFile");
            argParser.addArgument(sslTrustStorePINFile);
            controlStr = new StringArgument("control", Character.valueOf('J'), "control", false, true, true, ToolMessages.INFO_LDAP_CONTROL_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_CONTROLS.get());
            controlStr.setPropertyName("control");
            argParser.addArgument(controlStr);
            BooleanArgument showUsage = new BooleanArgument("help", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_USAGE.get());
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage, out);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 89;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        if (bindPW.isPresent() && bindPWFile.isPresent()) {
            Message message = ToolMessages.ERR_LDAPPWMOD_CONFLICTING_ARGS.get(bindPW.getLongIdentifier(), bindPWFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        if (newPW.isPresent() && newPWFile.isPresent()) {
            Message message = ToolMessages.ERR_LDAPPWMOD_CONFLICTING_ARGS.get(newPW.getLongIdentifier(), newPWFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        if (currentPW.isPresent() && currentPWFile.isPresent()) {
            Message message = ToolMessages.ERR_LDAPPWMOD_CONFLICTING_ARGS.get(currentPW.getLongIdentifier(), currentPWFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        if (useSSL.isPresent() && useStartTLS.isPresent()) {
            Message message = ToolMessages.ERR_LDAPPWMOD_CONFLICTING_ARGS.get(useSSL.getLongIdentifier(), useStartTLS.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        if (sslKeyStorePIN.isPresent() && sslKeyStorePINFile.isPresent()) {
            Message message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(sslKeyStorePIN.getLongIdentifier(), sslKeyStorePINFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        if (sslTrustStorePIN.isPresent() && sslTrustStorePINFile.isPresent()) {
            Message message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(sslTrustStorePIN.getLongIdentifier(), sslTrustStorePINFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        if (bindDN.isPresent()) {
            if (!bindPW.isPresent() && !bindPWFile.isPresent()) {
                Message message = ToolMessages.ERR_LDAPPWMOD_BIND_DN_AND_PW_MUST_BE_TOGETHER.get();
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                err.println(argParser.getUsage());
                return 89;
            }
        } else {
            if (bindPW.isPresent() || bindPWFile.isPresent()) {
                Message message = ToolMessages.ERR_LDAPPWMOD_BIND_DN_AND_PW_MUST_BE_TOGETHER.get();
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                err.println(argParser.getUsage());
                return 89;
            }
            if (provideDNForAuthzID.isPresent()) {
                Message message = ToolMessages.ERR_LDAPPWMOD_DEPENDENT_ARGS.get(provideDNForAuthzID.getLongIdentifier(), bindDN.getLongIdentifier());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                err.println(argParser.getUsage());
                return 89;
            }
            if (!authzID.isPresent() || !currentPW.isPresent() && !currentPWFile.isPresent()) {
                Message message = ToolMessages.ERR_LDAPPWMOD_ANON_REQUIRES_AUTHZID_AND_CURRENTPW.get();
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                err.println(argParser.getUsage());
                return 89;
            }
        }
        String host = ldapHost.getValue();
        try {
            port = ldapPort.getIntValue();
        }
        catch (Exception e) {
            err.println(e);
            return 89;
        }
        ArrayList<Control> controls = new ArrayList<Control>();
        if (controlStr.isPresent()) {
            for (String ctrlString : controlStr.getValues()) {
                LDAPControl ctrl = LDAPToolUtils.getControl(ctrlString, err);
                if (ctrl == null) {
                    Message message = ToolMessages.ERR_TOOL_INVALID_CONTROL_STRING.get(ctrlString);
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    err.println(argParser.getUsage());
                    return 89;
                }
                controls.add(ctrl);
            }
        }
        if (initializeServer) {
            EmbeddedUtils.initializeForClientUse();
        }
        AtomicInteger nextMessageID = new AtomicInteger(1);
        LDAPConnectionOptions connectionOptions = new LDAPConnectionOptions();
        connectionOptions.setUseSSL(useSSL.isPresent());
        connectionOptions.setStartTLS(useStartTLS.isPresent());
        connectionOptions.setVersionNumber(3);
        if (connectionOptions.useSSL() || connectionOptions.useStartTLS()) {
            String keyPIN = null;
            if (sslKeyStorePIN.isPresent()) {
                keyPIN = sslKeyStorePIN.getValue();
            } else if (sslKeyStorePINFile.isPresent()) {
                keyPIN = sslKeyStorePINFile.getValue();
            }
            String trustPIN = null;
            if (sslTrustStorePIN.isPresent()) {
                trustPIN = sslTrustStorePIN.getValue();
            } else if (sslTrustStorePINFile.isPresent()) {
                trustPIN = sslTrustStorePINFile.getValue();
            }
            try {
                String clientAlias = certNickname.isPresent() ? certNickname.getValue() : null;
                SSLConnectionFactory sslConnectionFactory = new SSLConnectionFactory();
                sslConnectionFactory.init(sslBlindTrust.isPresent(), sslKeyStore.getValue(), keyPIN, clientAlias, sslTrustStore.getValue(), trustPIN);
                connectionOptions.setSSLConnectionFactory(sslConnectionFactory);
            }
            catch (Exception e) {
                Message message = ToolMessages.ERR_LDAPPWMOD_ERROR_INITIALIZING_SSL.get(String.valueOf(e));
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 89;
            }
        }
        LDAPConnection connection = new LDAPConnection(host, port, connectionOptions, out, err);
        if (bindPW.isPresent()) {
            dn = bindDN.getValue();
            pw = bindPW.getValue();
        } else if (bindPWFile.isPresent()) {
            dn = bindDN.getValue();
            pw = bindPWFile.getValue();
        } else {
            dn = null;
            pw = null;
        }
        try {
            connection.connectToHost(dn, pw, nextMessageID);
        }
        catch (LDAPConnectionException lce) {
            Message message = ToolMessages.ERR_LDAPPWMOD_CANNOT_CONNECT.get(lce.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return lce.getResultCode();
        }
        LDAPReader reader = connection.getLDAPReader();
        LDAPWriter writer = connection.getLDAPWriter();
        ByteStringBuilder builder = new ByteStringBuilder();
        ASN1Writer asn1Writer = ASN1.getWriter(builder);
        try {
            asn1Writer.writeStartSequence();
            if (authzID.isPresent()) {
                asn1Writer.writeOctetString((byte)-128, authzID.getValue());
            } else if (provideDNForAuthzID.isPresent()) {
                asn1Writer.writeOctetString((byte)-128, "dn:" + dn);
            }
            if (currentPW.isPresent()) {
                asn1Writer.writeOctetString((byte)-127, currentPW.getValue());
            } else if (currentPWFile.isPresent()) {
                asn1Writer.writeOctetString((byte)-127, currentPWFile.getValue());
            } else if (provideDNForAuthzID.isPresent()) {
                asn1Writer.writeOctetString((byte)-127, pw);
            }
            if (newPW.isPresent()) {
                asn1Writer.writeOctetString((byte)-126, newPW.getValue());
            } else if (newPWFile.isPresent()) {
                asn1Writer.writeOctetString((byte)-126, newPWFile.getValue());
            }
            asn1Writer.writeEndSequence();
        }
        catch (Exception e) {
            err.println(e);
        }
        ExtendedRequestProtocolOp extendedRequest = new ExtendedRequestProtocolOp("1.3.6.1.4.1.4203.1.11.1", builder.toByteString());
        LDAPMessage requestMessage = new LDAPMessage(nextMessageID.getAndIncrement(), extendedRequest, controls);
        try {
            writer.writeMessage(requestMessage);
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_LDAPPWMOD_CANNOT_SEND_PWMOD_REQUEST.get(String.valueOf(e));
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            try {
                requestMessage = new LDAPMessage(nextMessageID.getAndIncrement(), new UnbindRequestProtocolOp());
                writer.writeMessage(requestMessage);
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                reader.close();
                writer.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            return 1;
        }
        LDAPMessage responseMessage = null;
        try {
            responseMessage = reader.readMessage();
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_LDAPPWMOD_CANNOT_READ_PWMOD_RESPONSE.get(String.valueOf(e));
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            try {
                requestMessage = new LDAPMessage(nextMessageID.getAndIncrement(), new UnbindRequestProtocolOp());
                writer.writeMessage(requestMessage);
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                reader.close();
                writer.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            return 1;
        }
        ExtendedResponseProtocolOp extendedResponse = responseMessage.getExtendedResponseProtocolOp();
        int resultCode = extendedResponse.getResultCode();
        if (resultCode != 0) {
            DN matchedDN;
            Message message = ToolMessages.ERR_LDAPPWMOD_FAILED.get(resultCode);
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            Message errorMessage = extendedResponse.getErrorMessage();
            if (errorMessage != null && errorMessage.length() > 0) {
                message = ToolMessages.ERR_LDAPPWMOD_FAILURE_ERROR_MESSAGE.get(errorMessage);
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            }
            if ((matchedDN = extendedResponse.getMatchedDN()) != null) {
                message = ToolMessages.ERR_LDAPPWMOD_FAILURE_MATCHED_DN.get(matchedDN.toString());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            }
            try {
                requestMessage = new LDAPMessage(nextMessageID.getAndIncrement(), new UnbindRequestProtocolOp());
                writer.writeMessage(requestMessage);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                reader.close();
                writer.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            return resultCode;
        }
        Message message = ToolMessages.INFO_LDAPPWMOD_SUCCESSFUL.get();
        out.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
        Message additionalInfo = extendedResponse.getErrorMessage();
        if (additionalInfo != null && additionalInfo.length() > 0) {
            message = ToolMessages.INFO_LDAPPWMOD_ADDITIONAL_INFO.get(additionalInfo);
            out.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
        }
        if ((responseControls = responseMessage.getControls()) != null) {
            for (Control c : responseControls) {
                if (!c.getOID().equals("1.3.6.1.4.1.42.2.27.8.5.1")) continue;
                try {
                    PasswordPolicyErrorType pwPolicyErrorType;
                    PasswordPolicyResponseControl pwPolicyControl = PasswordPolicyResponseControl.DECODER.decode(c.isCritical(), ((LDAPControl)c).getValue());
                    PasswordPolicyWarningType pwPolicyWarningType = pwPolicyControl.getWarningType();
                    if (pwPolicyWarningType != null) {
                        Message message2 = ToolMessages.INFO_LDAPPWMOD_PWPOLICY_WARNING.get(pwPolicyWarningType.toString(), pwPolicyControl.getWarningValue());
                        out.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
                    }
                    if ((pwPolicyErrorType = pwPolicyControl.getErrorType()) == null) continue;
                    Message message3 = ToolMessages.INFO_LDAPPWMOD_PWPOLICY_ERROR.get(pwPolicyErrorType.toString());
                    out.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
                }
                catch (Exception e) {
                    Message message4 = ToolMessages.ERR_LDAPPWMOD_CANNOT_DECODE_PWPOLICY_CONTROL.get(String.valueOf(e));
                    err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
                }
            }
        }
        if ((responseValue = extendedResponse.getValue()) != null) {
            Message message5;
            try {
                ASN1Reader asn1Reader = ASN1.getReader(responseValue);
                asn1Reader.readStartSequence();
                while (asn1Reader.hasNextElement()) {
                    if (asn1Reader.peekType() == -128) {
                        message5 = ToolMessages.INFO_LDAPPWMOD_GENERATED_PASSWORD.get(asn1Reader.readOctetStringAsString());
                        out.println(StaticUtils.wrapText(message5, ServerConstants.MAX_LINE_WIDTH));
                        continue;
                    }
                    message5 = ToolMessages.ERR_LDAPPWMOD_UNRECOGNIZED_VALUE_TYPE.get(asn1Reader.readOctetStringAsString());
                    err.println(StaticUtils.wrapText(message5, ServerConstants.MAX_LINE_WIDTH));
                }
                asn1Reader.readEndSequence();
            }
            catch (Exception e) {
                message5 = ToolMessages.ERR_LDAPPWMOD_COULD_NOT_DECODE_RESPONSE_VALUE.get(String.valueOf(e));
                err.println(StaticUtils.wrapText(message5, ServerConstants.MAX_LINE_WIDTH));
                try {
                    requestMessage = new LDAPMessage(nextMessageID.getAndIncrement(), new UnbindRequestProtocolOp());
                    writer.writeMessage(requestMessage);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    reader.close();
                    writer.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                return 1;
            }
        }
        try {
            requestMessage = new LDAPMessage(nextMessageID.getAndIncrement(), new UnbindRequestProtocolOp());
            writer.writeMessage(requestMessage);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            reader.close();
            writer.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return 0;
    }
}

