/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.servicetag;

import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.opends.messages.Message;
import org.opends.messages.ServiceTagMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.servicetag.Registry;
import org.opends.server.servicetag.ServiceTag;
import org.opends.server.servicetag.ServiceTagAlreadyExistsException;
import org.opends.server.servicetag.ServiceTagDoesNotExistException;
import org.opends.server.servicetag.ServiceTagException;
import org.opends.server.servicetag.SwordFishIDParser;
import org.opends.server.servicetag.SwordFishIdConfiguration;
import org.opends.server.servicetag.SystemEnvironment;
import org.opends.server.types.DebugLogLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceTagRegistration {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static ServiceTagRegistration registrationService = null;
    private SwordFishIdConfiguration configurationService = SwordFishIdConfiguration.getService();
    private Registry registry = null;

    private ServiceTagRegistration() {
        if (Registry.isSupported()) {
            this.registry = Registry.getSystemRegistry();
        }
    }

    public static ServiceTagRegistration getRegistrationService() {
        if (registrationService == null) {
            registrationService = new ServiceTagRegistration();
        }
        return registrationService;
    }

    public boolean isCommonRegistrationSupported() {
        return Registry.isSupported();
    }

    public void registerServiceTag(ServiceTag svcTag) throws ServiceTagException, IllegalArgumentException, ServiceTagAlreadyExistsException {
        if (!this.isCommonRegistrationSupported()) {
            throw new ServiceTagException(ServiceTagMessages.WARN_REGISTRY_NOT_SUPPORTED.get());
        }
        if (svcTag == null) {
            throw new IllegalArgumentException(ServiceTagMessages.WARN_PARAMETER_CANNOT_BE_NULL.get("svcTag").toString());
        }
        try {
            if (this.registry.existServiceTag(svcTag.getProductURN(), svcTag.getProductDefinedInstanceID())) {
                throw new ServiceTagAlreadyExistsException(ServiceTagMessages.WARN_SERVICETAG_ALREADY_EXIST.get());
            }
            this.registry.addServiceTag(svcTag);
        }
        catch (IOException ex) {
            throw new ServiceTagException(ServiceTagMessages.WARN_SERVICETAG_CANNOT_BE_REGISTERED.get(svcTag.getProductName(), svcTag.getProductURN(), svcTag.getProductDefinedInstanceID()));
        }
    }

    public Set<ServiceTag> registerServiceTags(String source) throws ServiceTagException, IllegalArgumentException {
        if (!this.isCommonRegistrationSupported()) {
            throw new ServiceTagException(ServiceTagMessages.WARN_REGISTRY_NOT_SUPPORTED.get());
        }
        if (source == null || source.length() == 0) {
            throw new IllegalArgumentException(ServiceTagMessages.WARN_PARAMETER_CANNOT_BE_NULL.get("source").toString());
        }
        HashSet<ServiceTag> errors = new HashSet<ServiceTag>();
        Set<SwordFishIDParser> parsers = this.configurationService.getParsers();
        if (parsers.isEmpty()) {
            throw new ServiceTagException(ServiceTagMessages.WARN_NO_SERVICETAG_TO_REGISTER.get());
        }
        ServiceTag svcTag = null;
        for (SwordFishIDParser parser : parsers) {
            svcTag = ServiceTag.newInstance(parser, source, DirectoryServer.getServerRoot());
            try {
                this.registerServiceTag(svcTag);
            }
            catch (Exception ex) {
                if (!DebugLogger.debugEnabled()) continue;
                Message message = ServiceTagMessages.WARN_SERVICETAG_CANNOT_BE_REGISTERED.get(svcTag.getProductName(), svcTag.getProductURN(), svcTag.getProductDefinedInstanceID());
                TRACER.debugWarning(message.toString());
            }
        }
        return errors;
    }

    public void deleteServiceTag(ServiceTag svcTag) throws IllegalArgumentException, ServiceTagException, ServiceTagDoesNotExistException {
        if (!this.isCommonRegistrationSupported()) {
            throw new ServiceTagException(ServiceTagMessages.WARN_REGISTRY_NOT_SUPPORTED.get());
        }
        if (svcTag == null) {
            throw new IllegalArgumentException(ServiceTagMessages.WARN_PARAMETER_CANNOT_BE_NULL.get("svcTag").toString());
        }
        try {
            if (!this.registry.existServiceTag(svcTag.getProductURN(), svcTag.getProductDefinedInstanceID())) {
                throw new ServiceTagDoesNotExistException(ServiceTagMessages.WARN_SERVICETAG_DOESNOT_EXIST.get());
            }
            this.registry.removeServiceTag(svcTag.getInstanceURN());
        }
        catch (IOException ex) {
            throw new ServiceTagException(ServiceTagMessages.WARN_NO_SERVICETAG_TO_REMOVE.get());
        }
    }

    private Set<ServiceTag> deleteServiceTags() throws ServiceTagException {
        if (!this.isCommonRegistrationSupported()) {
            throw new ServiceTagException(ServiceTagMessages.WARN_REGISTRY_NOT_SUPPORTED.get());
        }
        Set<SwordFishIDParser> parsers = this.configurationService.getParsers();
        if (parsers.isEmpty()) {
            throw new ServiceTagException(ServiceTagMessages.WARN_NO_SERVICETAG_TO_REMOVE.get());
        }
        HashSet<ServiceTag> errors = new HashSet<ServiceTag>();
        for (SwordFishIDParser parser : parsers) {
            Set<ServiceTag> removeTags = null;
            try {
                removeTags = this.registry.findServiceTags(parser.getSwordFishID());
                if (removeTags == null || removeTags.isEmpty()) {
                    throw new ServiceTagException(ServiceTagMessages.WARN_NO_SERVICETAG_TO_REMOVE.get());
                }
            }
            catch (Exception ex) {
                throw new ServiceTagException(ServiceTagMessages.WARN_NO_SERVICETAG_TO_REMOVE.get());
            }
            for (ServiceTag svcTag : removeTags) {
                try {
                    this.deleteServiceTag(svcTag);
                }
                catch (Exception ex) {
                    errors.add(svcTag);
                }
            }
        }
        return errors;
    }

    public ServiceTag registerServiceTag(String source, Properties properties) throws ServiceTagException, IllegalArgumentException, ServiceTagAlreadyExistsException {
        if (source == null || source.length() == 0) {
            throw new IllegalArgumentException(ServiceTagMessages.WARN_PARAMETER_CANNOT_BE_NULL.get("source").toString());
        }
        if (properties == null) {
            throw new IllegalArgumentException(ServiceTagMessages.WARN_PARAMETER_CANNOT_BE_NULL.get("properties").toString());
        }
        if (!properties.containsKey("org.opends.server.servicetag.productname")) {
            throw new IllegalArgumentException(ServiceTagMessages.WARN_BAD_PROPERTIES.get("org.opends.server.servicetag.productname").toString());
        }
        String productName = properties.getProperty("org.opends.server.servicetag.productname");
        if (!properties.containsKey("org.opends.server.servicetag.version")) {
            throw new IllegalArgumentException(ServiceTagMessages.WARN_BAD_PROPERTIES.get("org.opends.server.servicetag.version").toString());
        }
        String productVersion = properties.getProperty("org.opends.server.servicetag.version");
        if (!properties.containsKey("org.opends.server.servicetag.uuid")) {
            throw new IllegalArgumentException(ServiceTagMessages.WARN_BAD_PROPERTIES.get("org.opends.server.servicetag.uuid").toString());
        }
        String productURN = properties.getProperty("org.opends.server.servicetag.uuid");
        if (!properties.containsKey("org.opends.server.servicetag.parent")) {
            throw new IllegalArgumentException(ServiceTagMessages.WARN_BAD_PROPERTIES.get("org.opends.server.servicetag.parent").toString());
        }
        String productParent = properties.getProperty("org.opends.server.servicetag.parent");
        if (!properties.containsKey("org.opends.server.servicetag.parenturn")) {
            throw new IllegalArgumentException(ServiceTagMessages.WARN_BAD_PROPERTIES.get("org.opends.server.servicetag.parenturn").toString());
        }
        String productParentURN = properties.getProperty("org.opends.server.servicetag.parenturn");
        ServiceTag svcTag = ServiceTag.newInstance(productName, productVersion, productURN, productParent, productParentURN, DirectoryServer.getServerRoot(), "org.opends.server.servicetag.vendor", SystemEnvironment.getSystemEnvironment().getOsArchitecture(), "Global", source);
        this.registerServiceTag(svcTag);
        return svcTag;
    }

    public static void main(String[] args) {
        block12: {
            String source = "Manual";
            boolean delete = false;
            boolean register = false;
            int count = 0;
            while (count < args.length) {
                String arg = args[count];
                if (arg.trim().length() == 0) {
                    ++count;
                    continue;
                }
                if (arg.equals("-delete")) {
                    delete = true;
                } else if (arg.equals("-register")) {
                    register = true;
                }
                ++count;
            }
            if (!register && !delete) {
                ServiceTagRegistration.usage();
                return;
            }
            ServiceTagRegistration service = ServiceTagRegistration.getRegistrationService();
            if (delete) {
                try {
                    service.deleteServiceTags();
                }
                catch (ServiceTagException ex) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.WARNING, ex);
                    }
                    break block12;
                }
            }
            try {
                service.registerServiceTags(source);
            }
            catch (Exception ex) {
                if (!DebugLogger.debugEnabled()) break block12;
                TRACER.debugCaught(DebugLogLevel.WARNING, ex);
            }
        }
        System.exit(0);
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.print("    " + ServiceTagRegistration.class.getName());
        System.out.println(" [-delete|-register|-help]");
        System.out.println("       to delete/register a OpenDS ServiceTags");
        System.out.println("");
        System.out.println("Options:");
        System.out.println("    -delete  : to delete the OpenDS ServiceTags");
        System.out.println("    -register: to register the OpenDS ServiceTags");
        System.out.println("    -help    : to print this help message");
    }
}

