/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Collection;
import java.util.Collections;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.schema.UserPasswordSyntax;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UserPasswordExactEqualityMatchingRule
extends EqualityMatchingRule {
    @Override
    public Collection<String> getAllNames() {
        return Collections.singleton(this.getName());
    }

    @Override
    public String getName() {
        return "ds-mr-user-password-exact";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.26027.1.4.2";
    }

    @Override
    public String getDescription() {
        return "user password exact matching rule";
    }

    @Override
    public String getSyntaxOID() {
        return "1.3.6.1.4.1.26027.1.3.1";
    }

    @Override
    public ByteString normalizeValue(ByteSequence value) throws DirectoryException {
        if (UserPasswordSyntax.isEncoded(value)) {
            StringBuilder builder = new StringBuilder(value.length());
            int closingBracePos = -1;
            for (int i = 1; i < value.length(); ++i) {
                if (value.byteAt(i) != 125) continue;
                closingBracePos = i;
                break;
            }
            ByteSequence seq1 = value.subSequence(0, closingBracePos + 1);
            ByteSequence seq2 = value.subSequence(closingBracePos + 1, value.length());
            StaticUtils.toLowerCase(seq1, builder, false);
            builder.append(seq2);
            return ByteString.valueOf(builder.toString());
        }
        return value.toByteString();
    }
}

