/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.service;

import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.service.ReplicationDomain;
import org.opends.server.util.StaticUtils;

public class ListenerThread
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ReplicationDomain repDomain;
    private boolean shutdown = false;
    private boolean done = false;

    public ListenerThread(ReplicationDomain repDomain) {
        super("Replication Listener for server id " + repDomain.getServerId() + " and domain " + repDomain.getServiceID());
        this.repDomain = repDomain;
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public void run() {
        UpdateMsg updateMsg = null;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Replication Listener thread starting.");
        }
        while (!this.shutdown) {
            try {
                while (!this.shutdown && (updateMsg = this.repDomain.receive()) != null) {
                    if (!this.repDomain.processUpdate(updateMsg)) continue;
                    this.repDomain.processUpdateDoneSynchronous(updateMsg);
                }
                if (updateMsg != null) continue;
                this.shutdown = true;
            }
            catch (Exception e) {
                Message message = ReplicationMessages.ERR_EXCEPTION_RECEIVING_REPLICATION_MESSAGE.get(StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
            }
        }
        this.done = true;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Replication Listener thread stopping.");
        }
    }

    public void waitForShutdown() {
        try {
            int FACTOR = 40;
            int n = 0;
            while (!this.done && this.isAlive()) {
                Thread.sleep(50L);
                if (++n < FACTOR) continue;
                TRACER.debugInfo("Interrupting listener thread for dn " + this.repDomain.getServiceID() + " in DS " + this.repDomain.getServerId());
                this.interrupt();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

