/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.io.IOException;
import java.net.SocketException;
import java.util.NoSuchElementException;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.protocol.ProtocolSession;
import org.opends.server.replication.protocol.StopMsg;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.server.ReplicationServerDomain;
import org.opends.server.replication.server.ServerHandler;
import org.opends.server.util.StaticUtils;

public class ServerWriter
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ProtocolSession session;
    private ServerHandler handler;
    private ReplicationServerDomain replicationServerDomain;
    private short protocolVersion = (short)-1;

    public ServerWriter(ProtocolSession session, int serverId, ServerHandler handler, ReplicationServerDomain replicationServerDomain) {
        super("Replication Writer Thread for handler of " + handler.toString() + " in " + replicationServerDomain);
        this.session = session;
        this.handler = handler;
        this.replicationServerDomain = replicationServerDomain;
        this.protocolVersion = handler.getProtocolVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Message errMessage = null;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo(this.getName() + " starting");
        }
        try {
            while (true) {
                UpdateMsg update;
                if ((update = this.replicationServerDomain.take(this.handler)) == null) {
                    errMessage = Message.raw("Connection closure: null update returned by domain.", new Object[0]);
                    return;
                }
                if (this.handler.isDataServer()) {
                    ServerStatus dsStatus = this.handler.getStatus();
                    if (dsStatus == ServerStatus.BAD_GEN_ID_STATUS || dsStatus == ServerStatus.FULL_UPDATE_STATUS) {
                        long referenceGenerationId = this.replicationServerDomain.getGenerationId();
                        if (dsStatus == ServerStatus.BAD_GEN_ID_STATUS) {
                            ErrorLogger.logError(ReplicationMessages.ERR_IGNORING_UPDATE_TO_DS_BADGENID.get(Integer.toString(this.replicationServerDomain.getReplicationServer().getServerId()), this.replicationServerDomain.getBaseDn(), update.getChangeNumber().toString(), Integer.toString(this.handler.getServerId()), Long.toString(this.handler.getGenerationId()), Long.toString(referenceGenerationId)));
                        }
                        if (dsStatus != ServerStatus.FULL_UPDATE_STATUS) continue;
                        ErrorLogger.logError(ReplicationMessages.ERR_IGNORING_UPDATE_TO_DS_FULLUP.get(Integer.toString(this.replicationServerDomain.getReplicationServer().getServerId()), this.replicationServerDomain.getBaseDn(), update.getChangeNumber().toString(), Integer.toString(this.handler.getServerId())));
                        continue;
                    }
                } else {
                    long referenceGenerationId = this.replicationServerDomain.getGenerationId();
                    if (referenceGenerationId != this.handler.getGenerationId() || referenceGenerationId == -1L || this.handler.getGenerationId() == -1L) {
                        ErrorLogger.logError(ReplicationMessages.ERR_IGNORING_UPDATE_TO_RS.get(Integer.toString(this.replicationServerDomain.getReplicationServer().getServerId()), this.replicationServerDomain.getBaseDn(), update.getChangeNumber().toString(), Integer.toString(this.handler.getServerId()), Long.toString(this.handler.getGenerationId()), Long.toString(referenceGenerationId)));
                        continue;
                    }
                }
                this.session.publish(update, this.protocolVersion);
                continue;
                break;
            }
        }
        catch (NoSuchElementException e) {
            errMessage = ReplicationMessages.ERR_SERVER_BADLY_DISCONNECTED.get(this.handler.toString(), Integer.toString(this.replicationServerDomain.getReplicationServer().getServerId()));
            ErrorLogger.logError(errMessage);
            return;
        }
        catch (SocketException e) {
            errMessage = ReplicationMessages.ERR_SERVER_BADLY_DISCONNECTED.get(this.handler.toString(), Integer.toString(this.replicationServerDomain.getReplicationServer().getServerId()));
            ErrorLogger.logError(errMessage);
            return;
        }
        catch (Exception e) {
            errMessage = ReplicationMessages.ERR_WRITER_UNEXPECTED_EXCEPTION.get(this.handler.toString() + " " + StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(errMessage);
            return;
        }
        finally {
            if (this.protocolVersion >= 4) {
                try {
                    this.session.publish(new StopMsg());
                }
                catch (IOException ioe) {}
            }
            try {
                this.session.close();
            }
            catch (IOException e) {}
            this.replicationServerDomain.stopServer(this.handler, false);
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo(this.getName() + " stopped " + errMessage);
            }
        }
    }
}

