/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.io.IOException;
import java.net.SocketException;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PersistentSearch;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.protocol.DoneMsg;
import org.opends.server.replication.protocol.ECLUpdateMsg;
import org.opends.server.replication.protocol.ProtocolSession;
import org.opends.server.replication.server.ECLServerHandler;
import org.opends.server.replication.server.ReplicationServerDomain;
import org.opends.server.replication.server.ServerWriter;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.util.StaticUtils;
import org.opends.server.workflowelement.externalchangelog.ECLSearchOperation;
import org.opends.server.workflowelement.externalchangelog.ECLWorkflowElement;

public class ECLServerWriter
extends ServerWriter {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ProtocolSession session;
    private ECLServerHandler handler;
    private ReplicationServerDomain replicationServerDomain;
    private short protocolVersion = (short)-1;
    private boolean suspended;
    private boolean shutdown;
    private PersistentSearch mypsearch;

    public ECLServerWriter(ProtocolSession session, ECLServerHandler handler, ReplicationServerDomain replicationServerDomain) {
        super(session, -1, handler, replicationServerDomain);
        this.setName("Replication ECL Writer Thread for operation " + handler.getOperationId());
        this.session = session;
        this.handler = handler;
        this.replicationServerDomain = replicationServerDomain;
        this.protocolVersion = handler.getProtocolVersion();
        this.suspended = false;
        this.shutdown = false;
        ECLWorkflowElement wfe = (ECLWorkflowElement)DirectoryServer.getWorkflowElement("EXTERNAL CHANGE LOG");
        for (PersistentSearch psearch : wfe.getPersistentSearches()) {
            if (!psearch.getSearchOperation().toString().equals(handler.getOperationId())) continue;
            this.mypsearch = psearch;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void suspendWriter() {
        ECLServerWriter eCLServerWriter = this;
        synchronized (eCLServerWriter) {
            this.suspended = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resumeWriter() {
        ECLServerWriter eCLServerWriter = this;
        synchronized (eCLServerWriter) {
            this.suspended = false;
        }
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Message errMessage = null;
        try {
            while (true) {
                if (this.suspended && !this.shutdown) {
                    ECLServerWriter eCLServerWriter = this;
                    synchronized (eCLServerWriter) {
                        this.wait();
                    }
                }
                if (this.shutdown) {
                    return;
                }
                this.doIt();
                if (this.shutdown) {
                    return;
                }
                this.suspendWriter();
                continue;
                break;
            }
        }
        catch (SocketException e) {
            errMessage = ReplicationMessages.ERR_SERVER_BADLY_DISCONNECTED.get(this.handler.toString(), "for operation " + this.handler.getOperationId());
            ErrorLogger.logError(errMessage);
            return;
        }
        catch (Exception e) {
            errMessage = ReplicationMessages.ERR_WRITER_UNEXPECTED_EXCEPTION.get(this.handler.toString() + " " + StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(errMessage);
            return;
        }
        finally {
            if (this.session != null) {
                try {
                    this.session.close();
                }
                catch (IOException iOException) {}
            }
            if (this.replicationServerDomain != null) {
                this.replicationServerDomain.stopServer(this.handler, false);
            }
        }
    }

    public void doIt() throws IOException, InterruptedException {
        ECLUpdateMsg update = null;
        while (true) {
            if (this.shutdown) {
                return;
            }
            if (this.suspended) {
                return;
            }
            if (update == null) {
                try {
                    this.handler.refreshEligibleCN();
                    update = this.handler.takeECLUpdate();
                }
                catch (DirectoryException de) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
            }
            if (update == null) {
                if (this.handler.getSearchPhase() != 1 && this.session != null) {
                    this.session.publish(new DoneMsg(this.handler.getReplicationServerId(), this.handler.getServerId()), this.protocolVersion);
                }
                if (this.handler.isPersistent() == 1) break;
                Thread.sleep(200L);
                continue;
            }
            this.publish(update, this.protocolVersion);
            update = null;
        }
    }

    public synchronized void shutdownWriter() {
        this.shutdown = true;
        this.notify();
    }

    private void publish(ECLUpdateMsg msg, short reqProtocolVersion) throws IOException {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo(this.getName() + " publishes msg=[" + msg.toString() + "]");
        }
        if (this.session != null) {
            this.session.publish(msg, this.protocolVersion);
        } else if (this.mypsearch != null) {
            try {
                Entry eclEntry = ECLSearchOperation.createEntryFromMsg(msg);
                this.mypsearch.processAdd(eclEntry, -1L);
            }
            catch (Exception e) {
                Message errMessage = ReplicationMessages.ERR_WRITER_UNEXPECTED_EXCEPTION.get(this.handler.toString() + " " + StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(errMessage);
                this.mypsearch.cancel();
            }
        }
    }
}

