/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockConflictException;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ReplicationMessages;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.server.DraftCNDB;
import org.opends.server.replication.server.DraftCNDbIterator;
import org.opends.server.replication.server.ReplicationDbEnv;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.replication.server.ReplicationServerDomain;
import org.opends.server.types.Attribute;
import org.opends.server.types.Attributes;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;

public class DraftCNDbHandler
implements Runnable {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    static int NO_KEY = 0;
    private DraftCNDB db;
    private int firstkey = NO_KEY;
    private int lastkey = NO_KEY;
    private DbMonitorProvider dbMonitor = new DbMonitorProvider();
    private boolean shutdown = false;
    private boolean trimDone = false;
    private DirectoryThread thread = null;
    private ReplicationServer replicationServer;
    private static final int DEADLOCK_RETRIES = 10;
    private long trimage;
    private ReentrantLock lock = new ReentrantLock();

    public DraftCNDbHandler(ReplicationServer replicationServer, ReplicationDbEnv dbenv) throws DatabaseException {
        this.replicationServer = replicationServer;
        this.trimage = replicationServer.getTrimage();
        this.db = new DraftCNDB(replicationServer, dbenv);
        this.firstkey = this.db.readFirstDraftCN();
        this.lastkey = this.db.readLastDraftCN();
        this.thread = new DirectoryThread(this, "Replication DraftCN db ");
        this.thread.start();
        DirectoryServer.deregisterMonitorProvider(this.dbMonitor.getMonitorInstanceName());
        DirectoryServer.registerMonitorProvider(this.dbMonitor);
    }

    public synchronized void add(int key, String value, String serviceID, ChangeNumber cn) {
        this.db.addEntry(key, value, serviceID, cn);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In DraftCNDbhandler.add, added:  key=" + key + " value=" + value + " serviceID=" + serviceID + " cn=" + cn);
        }
    }

    public int getFirstKey() {
        return this.db.readFirstDraftCN();
    }

    public int getLastKey() {
        return this.db.readLastDraftCN();
    }

    public long count() {
        return this.db.count();
    }

    public DraftCNDB.DraftCNDBCursor getReadCursor(int key) {
        try {
            return this.db.openReadCursor(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void releaseReadCursor(DraftCNDB.DraftCNDBCursor cursor) {
        try {
            cursor.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DraftCNDbIterator generateIterator(int startDraftCN) throws DatabaseException, Exception {
        DraftCNDbIterator it = new DraftCNDbIterator(this.db, startDraftCN);
        return it;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        DraftCNDbHandler draftCNDbHandler = this;
        synchronized (draftCNDbHandler) {
            this.notifyAll();
        }
        draftCNDbHandler = this;
        synchronized (draftCNDbHandler) {
            while (!this.trimDone) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
        }
        this.db.shutdown();
        DirectoryServer.deregisterMonitorProvider(this.dbMonitor.getMonitorInstanceName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DraftCNDbHandler draftCNDbHandler;
        while (!this.shutdown) {
            try {
                this.trim();
                draftCNDbHandler = this;
                synchronized (draftCNDbHandler) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            catch (Exception end) {
                MessageBuilder mb = new MessageBuilder();
                mb.append(ReplicationMessages.ERR_EXCEPTION_CHANGELOG_TRIM_FLUSH.get());
                mb.append(StaticUtils.stackTraceToSingleLineString(end));
                ErrorLogger.logError(mb.toMessage());
                if (this.replicationServer == null) break;
                this.replicationServer.shutdown();
                break;
            }
        }
        draftCNDbHandler = this;
        synchronized (draftCNDbHandler) {
            this.trimDone = true;
            this.notifyAll();
        }
    }

    public void trim() throws DatabaseException, Exception {
        if (this.trimage == 0L) {
            return;
        }
        this.clear(null);
    }

    public void clear(String serviceIDToClear) throws DatabaseException, Exception {
        if (this.count() == 0L) {
            return;
        }
        int size = 0;
        int tries = 0;
        boolean finished = false;
        boolean done = false;
        ChangeNumber crossDomainEligibleCN = this.replicationServer.getEligibleCN();
        while (tries++ < 10 && !done) {
            DraftCNDB.DraftCNDBCursor cursor = this.db.openDeleteCursor();
            try {
                while (size < 5000 && !finished) {
                    if (!cursor.next()) {
                        finished = true;
                        continue;
                    }
                    ChangeNumber cn = cursor.currentChangeNumber();
                    String serviceID = cursor.currentServiceID();
                    if (serviceIDToClear != null && serviceIDToClear.equalsIgnoreCase(serviceID)) {
                        ++size;
                        cursor.delete();
                        continue;
                    }
                    ReplicationServerDomain domain = this.replicationServer.getReplicationServerDomain(serviceID, false);
                    if (domain == null) {
                        ++size;
                        cursor.delete();
                        continue;
                    }
                    ServerState startSS = domain.getStartState();
                    ServerState endSS = domain.getEligibleState(crossDomainEligibleCN);
                    ChangeNumber fcn = startSS.getMaxChangeNumber(cn.getServerId());
                    ChangeNumber lcn = endSS.getMaxChangeNumber(cn.getServerId());
                    if (!cn.older(fcn).booleanValue() && !cn.newer(lcn)) continue;
                    ++size;
                    cursor.delete();
                }
                cursor.close();
                done = true;
            }
            catch (LockConflictException e) {
                cursor.abort();
                if (tries != 10) continue;
                this.shutdown = true;
                throw e;
            }
            catch (DatabaseException e) {
                this.shutdown = true;
                cursor.abort();
                throw e;
            }
        }
    }

    public String toString() {
        return "draftCNdb: " + this.firstkey + " " + this.lastkey;
    }

    public void setPurgeDelay(long delay) {
        this.trimage = delay;
    }

    public void clear() throws DatabaseException, Exception {
        this.db.clear();
        this.firstkey = this.db.readFirstDraftCN();
        this.lastkey = this.db.readLastDraftCN();
    }

    public boolean hasLock() {
        return this.lock.getHoldCount() > 0;
    }

    public void lock() throws InterruptedException {
        this.lock.lockInterruptibly();
    }

    public void release() {
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(int key) {
        String value = null;
        DraftCNDB.DraftCNDBCursor draftCNDBCursor = null;
        try {
            draftCNDBCursor = this.db.openReadCursor(key);
            value = draftCNDBCursor.currentValue();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In DraftCNDbHandler.getGeneralizedState, read:  key=" + key + " genServerState returned is null" + " first=" + this.db.readFirstDraftCN() + " last=" + this.db.readLastDraftCN() + " count=" + this.db.count() + " exception" + e + " " + e.getMessage());
            }
            String string = null;
            return string;
        }
        finally {
            if (draftCNDBCursor != null) {
                draftCNDBCursor.close();
            }
        }
        return value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DbMonitorProvider
    extends MonitorProvider<MonitorProviderCfg> {
        private DbMonitorProvider() {
            super("ReplicationServer DraftCN Database");
        }

        public ArrayList<Attribute> getMonitorData() {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            attributes.add(Attributes.create("first-draft-changenumber", Integer.toString(DraftCNDbHandler.this.db.readFirstDraftCN())));
            attributes.add(Attributes.create("last-draft-changenumber", Integer.toString(DraftCNDbHandler.this.db.readLastDraftCN())));
            attributes.add(Attributes.create("count", Long.toString(DraftCNDbHandler.this.count())));
            return attributes;
        }

        @Override
        public String getMonitorInstanceName() {
            return "ReplicationServer DraftCN database ";
        }

        @Override
        public long getUpdateInterval() {
            return 0L;
        }

        @Override
        public void initializeMonitorProvider(MonitorProviderCfg configuration) throws ConfigException, InitializationException {
        }

        @Override
        public void updateMonitorData() {
        }
    }
}

