/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.replication.protocol.AckMsg;
import org.opends.server.replication.protocol.AddMsg;
import org.opends.server.replication.protocol.ChangeStatusMsg;
import org.opends.server.replication.protocol.ChangeTimeHeartbeatMsg;
import org.opends.server.replication.protocol.DeleteMsg;
import org.opends.server.replication.protocol.DoneMsg;
import org.opends.server.replication.protocol.ECLUpdateMsg;
import org.opends.server.replication.protocol.EntryMsg;
import org.opends.server.replication.protocol.ErrorMsg;
import org.opends.server.replication.protocol.HeartbeatMsg;
import org.opends.server.replication.protocol.InitializeRequestMsg;
import org.opends.server.replication.protocol.InitializeTargetMsg;
import org.opends.server.replication.protocol.ModifyDNMsg;
import org.opends.server.replication.protocol.ModifyMsg;
import org.opends.server.replication.protocol.MonitorMsg;
import org.opends.server.replication.protocol.MonitorRequestMsg;
import org.opends.server.replication.protocol.NotSupportedOldVersionPDUException;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.ReplServerStartDSMsg;
import org.opends.server.replication.protocol.ReplServerStartMsg;
import org.opends.server.replication.protocol.ResetGenerationIdMsg;
import org.opends.server.replication.protocol.ServerStartECLMsg;
import org.opends.server.replication.protocol.ServerStartMsg;
import org.opends.server.replication.protocol.StartECLSessionMsg;
import org.opends.server.replication.protocol.StartSessionMsg;
import org.opends.server.replication.protocol.StopMsg;
import org.opends.server.replication.protocol.TopologyMsg;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.protocol.WindowMsg;
import org.opends.server.replication.protocol.WindowProbeMsg;

public abstract class ReplicationMsg {
    static final byte MSG_TYPE_MODIFY_V1 = 1;
    static final byte MSG_TYPE_ADD_V1 = 2;
    static final byte MSG_TYPE_DELETE_V1 = 3;
    static final byte MSG_TYPE_MODIFYDN_V1 = 4;
    static final byte MSG_TYPE_SERVER_START_V1 = 6;
    static final byte MSG_TYPE_REPL_SERVER_START_V1 = 7;
    static final byte MSG_TYPE_REPL_SERVER_INFO_V1 = 16;
    static final byte MSG_TYPE_ACK = 5;
    static final byte MSG_TYPE_WINDOW = 8;
    static final byte MSG_TYPE_HEARTBEAT = 9;
    static final byte MSG_TYPE_INITIALIZE_REQUEST = 10;
    static final byte MSG_TYPE_INITIALIZE_TARGET = 11;
    static final byte MSG_TYPE_ENTRY = 12;
    static final byte MSG_TYPE_DONE = 13;
    static final byte MSG_TYPE_ERROR = 14;
    static final byte MSG_TYPE_WINDOW_PROBE = 15;
    static final byte MSG_TYPE_RESET_GENERATION_ID = 17;
    static final byte MSG_TYPE_REPL_SERVER_MONITOR_REQUEST = 18;
    static final byte MSG_TYPE_REPL_SERVER_MONITOR = 19;
    static final byte MSG_TYPE_SERVER_START = 20;
    static final byte MSG_TYPE_REPL_SERVER_START = 21;
    static final byte MSG_TYPE_MODIFY = 22;
    static final byte MSG_TYPE_ADD = 23;
    static final byte MSG_TYPE_DELETE = 24;
    static final byte MSG_TYPE_MODIFYDN = 25;
    static final byte MSG_TYPE_TOPOLOGY = 26;
    static final byte MSG_TYPE_START_SESSION = 27;
    static final byte MSG_TYPE_CHANGE_STATUS = 28;
    static final byte MSG_TYPE_GENERIC_UPDATE = 29;
    static final byte MSG_TYPE_START_ECL = 30;
    static final byte MSG_TYPE_START_ECL_SESSION = 31;
    static final byte MSG_TYPE_ECL_UPDATE = 32;
    static final byte MSG_TYPE_CT_HEARTBEAT = 33;
    static final byte MSG_TYPE_REPL_SERVER_START_DS = 34;
    static final byte MSG_TYPE_STOP = 35;

    public abstract byte[] getBytes() throws UnsupportedEncodingException;

    public byte[] getBytes(short reqProtocolVersion) throws UnsupportedEncodingException {
        if (reqProtocolVersion == ProtocolVersion.getCurrentVersion()) {
            return this.getBytes();
        }
        throw new UnsupportedEncodingException(this.getClass().getSimpleName() + " PDU does not support requested protocol version serialization: " + reqProtocolVersion);
    }

    public static ReplicationMsg generateMsg(byte[] buffer, short version) throws DataFormatException, UnsupportedEncodingException, NotSupportedOldVersionPDUException {
        ReplicationMsg msg = null;
        switch (buffer[0]) {
            case 6: {
                throw new NotSupportedOldVersionPDUException("Server Start", 1, buffer[0]);
            }
            case 16: {
                throw new NotSupportedOldVersionPDUException("Replication Server Info", 1, buffer[0]);
            }
            case 22: {
                msg = new ModifyMsg(buffer);
                break;
            }
            case 1: {
                msg = ModifyMsg.createV1(buffer);
                break;
            }
            case 2: 
            case 23: {
                msg = new AddMsg(buffer);
                break;
            }
            case 3: 
            case 24: {
                msg = new DeleteMsg(buffer);
                break;
            }
            case 4: 
            case 25: {
                msg = new ModifyDNMsg(buffer);
                break;
            }
            case 5: {
                msg = new AckMsg(buffer);
                break;
            }
            case 20: {
                msg = new ServerStartMsg(buffer);
                break;
            }
            case 7: 
            case 21: {
                msg = new ReplServerStartMsg(buffer);
                break;
            }
            case 8: {
                msg = new WindowMsg(buffer);
                break;
            }
            case 9: {
                msg = new HeartbeatMsg(buffer);
                break;
            }
            case 10: {
                msg = new InitializeRequestMsg(buffer);
                break;
            }
            case 11: {
                msg = new InitializeTargetMsg(buffer);
                break;
            }
            case 12: {
                msg = new EntryMsg(buffer);
                break;
            }
            case 13: {
                msg = new DoneMsg(buffer);
                break;
            }
            case 14: {
                msg = new ErrorMsg(buffer);
                break;
            }
            case 17: {
                msg = new ResetGenerationIdMsg(buffer);
                break;
            }
            case 15: {
                msg = new WindowProbeMsg(buffer);
                break;
            }
            case 26: {
                msg = new TopologyMsg(buffer, version);
                break;
            }
            case 18: {
                msg = new MonitorRequestMsg(buffer);
                break;
            }
            case 19: {
                msg = new MonitorMsg(buffer, version);
                break;
            }
            case 27: {
                msg = new StartSessionMsg(buffer, version);
                break;
            }
            case 28: {
                msg = new ChangeStatusMsg(buffer);
                break;
            }
            case 29: {
                msg = new UpdateMsg(buffer);
                break;
            }
            case 30: {
                msg = new ServerStartECLMsg(buffer);
                break;
            }
            case 31: {
                msg = new StartECLSessionMsg(buffer);
                break;
            }
            case 32: {
                msg = new ECLUpdateMsg(buffer);
                break;
            }
            case 33: {
                msg = new ChangeTimeHeartbeatMsg(buffer);
                break;
            }
            case 34: {
                msg = new ReplServerStartDSMsg(buffer);
                break;
            }
            case 35: {
                msg = new StopMsg(buffer);
                break;
            }
            default: {
                throw new DataFormatException("received message with unknown type");
            }
        }
        return msg;
    }

    protected static int addByteArray(byte[] tail, byte[] resultByteArray, int pos) {
        int i = 0;
        while (i < tail.length) {
            resultByteArray[pos] = tail[i];
            ++i;
            ++pos;
        }
        resultByteArray[pos++] = 0;
        return pos;
    }

    protected int getNextLength(byte[] in, int pos) throws DataFormatException {
        int offset = pos;
        int length = 0;
        while (in[offset++] != 0) {
            if (offset >= in.length) {
                throw new DataFormatException("byte[] is not a valid msg");
            }
            ++length;
        }
        return length;
    }
}

