/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.replication.common.AssuredMode;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.AddMsg;
import org.opends.server.replication.protocol.DeleteMsg;
import org.opends.server.replication.protocol.ModifyDNMsg;
import org.opends.server.replication.protocol.ModifyMsg;
import org.opends.server.replication.protocol.OperationContext;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.Attribute;
import org.opends.server.types.ByteSequenceReader;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.LDAPException;
import org.opends.server.types.RawAttribute;
import org.opends.server.types.operation.PostOperationAddOperation;
import org.opends.server.types.operation.PostOperationDeleteOperation;
import org.opends.server.types.operation.PostOperationModifyDNOperation;
import org.opends.server.types.operation.PostOperationModifyOperation;
import org.opends.server.types.operation.PostOperationOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LDAPUpdateMsg
extends UpdateMsg {
    protected String dn = null;
    protected String uniqueId;
    protected byte[] bytes = null;
    protected byte[] encodedEclIncludes = new byte[0];

    public LDAPUpdateMsg() {
    }

    public LDAPUpdateMsg(OperationContext ctx, String dn) {
        this.protocolVersion = ProtocolVersion.getCurrentVersion();
        this.changeNumber = ctx.getChangeNumber();
        this.uniqueId = ctx.getEntryUid();
        this.dn = dn;
    }

    public LDAPUpdateMsg(ChangeNumber cn, String entryUUID, String dn) {
        this.protocolVersion = ProtocolVersion.getCurrentVersion();
        this.changeNumber = cn;
        this.uniqueId = entryUUID;
        this.dn = dn;
    }

    public static LDAPUpdateMsg generateMsg(PostOperationOperation op) {
        LDAPUpdateMsg msg = null;
        switch (op.getOperationType()) {
            case MODIFY: {
                msg = new ModifyMsg((PostOperationModifyOperation)op);
                break;
            }
            case ADD: {
                msg = new AddMsg((PostOperationAddOperation)op);
                break;
            }
            case DELETE: {
                msg = new DeleteMsg((PostOperationDeleteOperation)op);
                break;
            }
            case MODIFY_DN: {
                msg = new ModifyDNMsg((PostOperationModifyDNOperation)op);
            }
        }
        return msg;
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public AbstractOperation createOperation(InternalClientConnection conn) throws LDAPException, ASN1Exception, DataFormatException {
        return this.createOperation(conn, this.dn);
    }

    public abstract AbstractOperation createOperation(InternalClientConnection var1, String var2) throws LDAPException, ASN1Exception, DataFormatException;

    public void encode() throws UnsupportedEncodingException {
        this.bytes = this.getBytes();
    }

    @Override
    public byte[] encodeHeader(byte type, int additionalLength, short version) throws UnsupportedEncodingException {
        byte[] byteDn = this.dn.getBytes("UTF-8");
        byte[] changeNumberByte = this.getChangeNumber().toString().getBytes("UTF-8");
        byte[] byteEntryuuid = this.getUniqueId().getBytes("UTF-8");
        int length = 8 + changeNumberByte.length + byteDn.length + byteEntryuuid.length + additionalLength;
        byte[] encodedMsg = new byte[length];
        encodedMsg[0] = type;
        encodedMsg[1] = (byte)version;
        int pos = 2;
        pos = LDAPUpdateMsg.addByteArray(changeNumberByte, encodedMsg, pos);
        pos = LDAPUpdateMsg.addByteArray(byteDn, encodedMsg, pos);
        pos = LDAPUpdateMsg.addByteArray(byteEntryuuid, encodedMsg, pos);
        encodedMsg[pos++] = this.assuredFlag ? (byte)1 : 0;
        encodedMsg[pos++] = this.assuredMode.getValue();
        encodedMsg[pos++] = this.safeDataLevel;
        return encodedMsg;
    }

    public byte[] encodeHeader_V1(byte type, int additionalLength) throws UnsupportedEncodingException {
        byte[] byteDn = this.dn.getBytes("UTF-8");
        byte[] changeNumberByte = this.getChangeNumber().toString().getBytes("UTF-8");
        byte[] byteEntryuuid = this.getUniqueId().getBytes("UTF-8");
        int length = 5 + changeNumberByte.length + byteDn.length + byteEntryuuid.length + additionalLength;
        byte[] encodedMsg = new byte[length];
        encodedMsg[0] = type;
        int pos = 1;
        pos = LDAPUpdateMsg.addByteArray(changeNumberByte, encodedMsg, pos);
        encodedMsg[pos++] = this.assuredFlag ? (byte)1 : 0;
        pos = LDAPUpdateMsg.addByteArray(byteDn, encodedMsg, pos);
        pos = LDAPUpdateMsg.addByteArray(byteEntryuuid, encodedMsg, pos);
        return encodedMsg;
    }

    @Override
    public byte[] getBytes() throws UnsupportedEncodingException {
        if (this.bytes == null) {
            this.bytes = this.getBytes_V4();
        }
        return this.bytes;
    }

    @Override
    public byte[] getBytes(short reqProtocolVersion) throws UnsupportedEncodingException {
        if (reqProtocolVersion == 1) {
            return this.getBytes_V1();
        }
        if (reqProtocolVersion <= 3) {
            return this.getBytes_V23();
        }
        if (this.bytes == null) {
            this.bytes = this.getBytes_V4();
        }
        return this.bytes;
    }

    public abstract byte[] getBytes_V1() throws UnsupportedEncodingException;

    public abstract byte[] getBytes_V23() throws UnsupportedEncodingException;

    public abstract byte[] getBytes_V4() throws UnsupportedEncodingException;

    private static byte[] encodeAttributes(List<Attribute> attributes) {
        if (attributes == null) {
            return new byte[0];
        }
        try {
            ByteStringBuilder byteBuilder = new ByteStringBuilder();
            ASN1Writer writer = ASN1.getWriter(byteBuilder);
            for (Attribute a : attributes) {
                new LDAPAttribute(a).write(writer);
            }
            return byteBuilder.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public int decodeHeader(byte[] types, byte[] encodedMsg) throws DataFormatException {
        boolean foundMatchingType = false;
        for (int i = 0; i < types.length; ++i) {
            if (types[i] != encodedMsg[0]) continue;
            foundMatchingType = true;
            break;
        }
        if (!foundMatchingType) {
            throw new DataFormatException("byte[] is not a valid update msg: " + encodedMsg[0]);
        }
        if (encodedMsg[0] == 2 || encodedMsg[0] == 3 || encodedMsg[0] == 4 || encodedMsg[0] == 1) {
            return this.decodeHeader_V1(encodedMsg);
        }
        this.protocolVersion = encodedMsg[1];
        try {
            int pos = 2;
            int length = this.getNextLength(encodedMsg, pos);
            String changenumberStr = new String(encodedMsg, pos, length, "UTF-8");
            pos += length + 1;
            this.changeNumber = new ChangeNumber(changenumberStr);
            length = this.getNextLength(encodedMsg, pos);
            this.dn = new String(encodedMsg, pos, length, "UTF-8");
            pos += length + 1;
            length = this.getNextLength(encodedMsg, pos);
            this.uniqueId = new String(encodedMsg, pos, length, "UTF-8");
            pos += length + 1;
            this.assuredFlag = encodedMsg[pos++] == 1;
            this.assuredMode = AssuredMode.valueOf(encodedMsg[pos++]);
            this.safeDataLevel = encodedMsg[pos++];
            return pos;
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
        catch (IllegalArgumentException e) {
            throw new DataFormatException(e.getMessage());
        }
    }

    public int decodeHeader_V1(byte[] encodedMsg) throws DataFormatException {
        if (encodedMsg[0] != 2 && encodedMsg[0] != 3 && encodedMsg[0] != 4 && encodedMsg[0] != 1) {
            throw new DataFormatException("byte[] is not a valid update msg: expected a V1 PDU, received: " + encodedMsg[0]);
        }
        this.protocolVersion = 1;
        try {
            int pos = 1;
            int length = this.getNextLength(encodedMsg, pos);
            String changenumberStr = new String(encodedMsg, pos, length, "UTF-8");
            pos += length + 1;
            this.changeNumber = new ChangeNumber(changenumberStr);
            this.assuredFlag = encodedMsg[pos++] == 1;
            length = this.getNextLength(encodedMsg, pos);
            this.dn = new String(encodedMsg, pos, length, "UTF-8");
            pos += length + 1;
            length = this.getNextLength(encodedMsg, pos);
            this.uniqueId = new String(encodedMsg, pos, length, "UTF-8");
            return pos += length + 1;
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    @Override
    public abstract int size();

    protected int headerSize() {
        return 100;
    }

    public void setEclIncludes(List<Attribute> entryAttrs) {
        this.encodedEclIncludes = LDAPUpdateMsg.encodeAttributes(entryAttrs);
    }

    public ArrayList<RawAttribute> getEclIncludes() {
        try {
            return this.decodeRawAttributes(this.encodedEclIncludes);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ArrayList<RawAttribute> decodeRawAttributes(byte[] in) throws LDAPException, ASN1Exception {
        ArrayList<RawAttribute> rattr = new ArrayList<RawAttribute>();
        try {
            ByteSequenceReader reader = ByteString.wrap(in).asReader();
            ASN1Reader asn1Reader = ASN1.getReader(reader);
            while (asn1Reader.hasNextElement()) {
                rattr.add(LDAPAttribute.decode(asn1Reader));
            }
            return rattr;
        }
        catch (Exception e) {
            return null;
        }
    }

    public ArrayList<Attribute> decodeAttributes(byte[] in) throws LDAPException, ASN1Exception {
        ArrayList<Attribute> lattr = new ArrayList<Attribute>();
        try {
            ByteSequenceReader reader = ByteString.wrap(in).asReader();
            ASN1Reader asn1Reader = ASN1.getReader(reader);
            while (asn1Reader.hasNextElement()) {
                lattr.add(LDAPAttribute.decode(asn1Reader).toAttribute());
            }
            return lattr;
        }
        catch (Exception e) {
            return null;
        }
    }
}

