/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.IOException;
import org.opends.messages.ReplicationMessages;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.protocol.ProtocolSession;
import org.opends.server.replication.protocol.StopMsg;
import org.opends.server.util.StaticUtils;

public class HeartbeatMonitor
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ProtocolSession session;
    private long heartbeatInterval;
    private boolean shutdown = false;
    private boolean sendStopBeforeClose = false;

    public HeartbeatMonitor(String threadName, ProtocolSession session, long heartbeatInterval, boolean sendStopBeforeClose) {
        super(threadName);
        this.session = session;
        this.heartbeatInterval = heartbeatInterval;
        this.sendStopBeforeClose = sendStopBeforeClose;
    }

    public void shutdown() {
        this.shutdown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block17: {
            boolean gotOneFailure = false;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo(this + " is starting, expected interval is " + this.heartbeatInterval);
            }
            block9: while (true) {
                try {
                    while (!this.shutdown) {
                        long lastReceiveTime;
                        long now = System.currentTimeMillis();
                        if (now > (lastReceiveTime = this.session.getLastReceiveTime()) + this.heartbeatInterval) {
                            if (gotOneFailure) {
                                ErrorLogger.logError(ReplicationMessages.NOTE_HEARTBEAT_FAILURE.get(HeartbeatMonitor.currentThread().getName()));
                                if (this.sendStopBeforeClose) {
                                    try {
                                        this.session.publish(new StopMsg());
                                    }
                                    catch (IOException ioe) {
                                        // empty catch block
                                    }
                                }
                                this.session.close();
                                break block17;
                            }
                            gotOneFailure = true;
                        } else {
                            gotOneFailure = false;
                        }
                        try {
                            Thread.sleep(this.heartbeatInterval);
                            continue block9;
                        }
                        catch (InterruptedException e) {
                        }
                    }
                    break block17;
                }
                catch (IOException iOException) {
                    break block17;
                }
            }
            finally {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Heartbeat monitor is exiting." + StaticUtils.stackTraceToSingleLineString(new Exception()));
                }
            }
        }
    }
}

