/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.ReplicationMsg;

public class ChangeTimeHeartbeatMsg
extends ReplicationMsg {
    private final ChangeNumber changeNumber;

    public ChangeTimeHeartbeatMsg() {
        this.changeNumber = new ChangeNumber(0L, 0, 0);
    }

    public ChangeTimeHeartbeatMsg(ChangeNumber cn) {
        this.changeNumber = cn;
    }

    public ChangeNumber getChangeNumber() {
        return this.changeNumber;
    }

    public byte[] encode() throws UnsupportedEncodingException {
        byte[] changeNumberByte = this.getChangeNumber().toString().getBytes("UTF-8");
        int length = changeNumberByte.length;
        byte[] encodedMsg = new byte[length];
        ChangeTimeHeartbeatMsg.addByteArray(changeNumberByte, encodedMsg, 0);
        return encodedMsg;
    }

    public ChangeTimeHeartbeatMsg(byte[] in) throws DataFormatException {
        try {
            if (in[0] != 33) {
                throw new DataFormatException("byte[] is not a valid CT_HEARTBEAT msg");
            }
            int pos = 1;
            int length = this.getNextLength(in, pos);
            String changenumberStr = new String(in, pos, length, "UTF-8");
            this.changeNumber = new ChangeNumber(changenumberStr);
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
        catch (IllegalArgumentException e) {
            throw new DataFormatException(e.getMessage());
        }
    }

    public byte[] getBytes() throws UnsupportedEncodingException {
        try {
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            oStream.write(33);
            byte[] changeNumberByte = this.changeNumber.toString().getBytes("UTF-8");
            oStream.write(changeNumberByte);
            oStream.write(0);
            return oStream.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }
}

