/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.CheckedOutputStream;
import java.util.zip.DataFormatException;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ReplicationMessages;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.ReplicationDomainCfgDefn;
import org.opends.server.admin.std.server.ExternalChangelogDomainCfg;
import org.opends.server.admin.std.server.ReplicationDomainCfg;
import org.opends.server.admin.std.server.SynchronizationProviderCfg;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.SynchronizationProvider;
import org.opends.server.backends.jeb.BackendImpl;
import org.opends.server.backends.task.Task;
import org.opends.server.config.ConfigException;
import org.opends.server.controls.SubtreeDeleteControl;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyDNOperationBasis;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.ModifyOperationBasis;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchListener;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.replication.common.AssuredMode;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ChangeNumberGenerator;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.common.StatusMachineEvent;
import org.opends.server.replication.plugin.ExternalChangelogDomain;
import org.opends.server.replication.plugin.FakeDelOperation;
import org.opends.server.replication.plugin.FakeOperation;
import org.opends.server.replication.plugin.GenerationIdChecksum;
import org.opends.server.replication.plugin.Historical;
import org.opends.server.replication.plugin.MultimasterReplication;
import org.opends.server.replication.plugin.PendingChanges;
import org.opends.server.replication.plugin.PersistentServerState;
import org.opends.server.replication.plugin.RemotePendingChanges;
import org.opends.server.replication.plugin.ReplLDIFOutputStream;
import org.opends.server.replication.plugin.UpdateToReplay;
import org.opends.server.replication.protocol.AddContext;
import org.opends.server.replication.protocol.AddMsg;
import org.opends.server.replication.protocol.DeleteContext;
import org.opends.server.replication.protocol.DeleteMsg;
import org.opends.server.replication.protocol.LDAPUpdateMsg;
import org.opends.server.replication.protocol.ModifyContext;
import org.opends.server.replication.protocol.ModifyDNMsg;
import org.opends.server.replication.protocol.ModifyDnContext;
import org.opends.server.replication.protocol.ModifyMsg;
import org.opends.server.replication.protocol.OperationContext;
import org.opends.server.replication.protocol.ProtocolSession;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.service.ReplicationBroker;
import org.opends.server.replication.service.ReplicationDomain;
import org.opends.server.replication.service.ReplicationMonitor;
import org.opends.server.tasks.TaskUtils;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.Attributes;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.LDAPException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.Operation;
import org.opends.server.types.RDN;
import org.opends.server.types.RawModification;
import org.opends.server.types.ResultCode;
import org.opends.server.types.Schema;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.types.SearchScope;
import org.opends.server.types.SynchronizationProviderResult;
import org.opends.server.types.operation.PluginOperation;
import org.opends.server.types.operation.PostOperationAddOperation;
import org.opends.server.types.operation.PostOperationDeleteOperation;
import org.opends.server.types.operation.PostOperationModifyDNOperation;
import org.opends.server.types.operation.PostOperationModifyOperation;
import org.opends.server.types.operation.PostOperationOperation;
import org.opends.server.types.operation.PreOperationAddOperation;
import org.opends.server.types.operation.PreOperationDeleteOperation;
import org.opends.server.types.operation.PreOperationModifyDNOperation;
import org.opends.server.types.operation.PreOperationModifyOperation;
import org.opends.server.types.operation.PreOperationOperation;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.workflowelement.externalchangelog.ECLWorkflowElement;
import org.opends.server.workflowelement.localbackend.LocalBackendModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPReplicationDomain
extends ReplicationDomain
implements ConfigurationChangeListener<ReplicationDomainCfg>,
AlertGenerator {
    private static final String CLASS_NAME = "org.opends.server.replication.plugin.LDAPReplicationDomain";
    public static final String DS_SYNC_CONFLICT = "ds-sync-conflict";
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final BlockingQueue<UpdateToReplay> updateToReplayQueue;
    private final AtomicInteger numResolvedNamingConflicts = new AtomicInteger();
    private final AtomicInteger numResolvedModifyConflicts = new AtomicInteger();
    private final AtomicInteger numUnresolvedNamingConflicts = new AtomicInteger();
    private final int debugCount = 0;
    private final PersistentServerState state;
    private int numReplayedPostOpCalled = 0;
    private long generationId = -1L;
    private boolean generationIdSavedStatus = false;
    private final ChangeNumberGenerator generator;
    private final PendingChanges pendingChanges;
    private final RemotePendingChanges remotePendingChanges;
    private final int serverId;
    private final DN baseDn;
    private boolean shutdown = false;
    private final InternalClientConnection conn = InternalClientConnection.getRootConnection();
    private boolean solveConflictFlag = true;
    private boolean disabled = false;
    private boolean stateSavingDisabled = false;
    private final TreeMap<ChangeNumber, FakeOperation> replayOperations = new TreeMap();
    private ReplicationDomainCfgDefn.IsolationPolicy isolationpolicy;
    private final DN configDn;
    private ExternalChangelogDomain eclDomain;
    private boolean done = true;
    private ServerStateFlush flushThread;
    protected static final String REPLICATION_GENERATION_ID = "ds-sync-generation-id";
    public static final String REPLICATION_FRACTIONAL_INCLUDE = "ds-sync-fractional-include";
    public static final String REPLICATION_FRACTIONAL_EXCLUDE = "ds-sync-fractional-exclude";
    private FractionalConfig fractionalConfig = null;
    private static final String[] FRACTIONAL_PROHIBITED_ATTRIBUTES = new String[]{"objectClass", "2.5.4.0"};
    private boolean force_bad_data_set = false;
    private boolean followImport = true;
    private int importErrorMessageId = -1;
    public static final int IMPORT_ERROR_MESSAGE_BAD_REMOTE = 1;
    public static final int IMPORT_ERROR_MESSAGE_REMOTE_IS_FRACTIONAL = 2;
    private static final int FRACTIONAL_HAS_FRACTIONAL_FILTERED_ATTRIBUTES = 1;
    private static final int FRACTIONAL_HAS_NO_FRACTIONAL_FILTERED_ATTRIBUTES = 2;
    private static final int FRACTIONAL_BECOME_NO_OP = 3;

    public LDAPReplicationDomain(ReplicationDomainCfg configuration, BlockingQueue<UpdateToReplay> updateToReplayQueue) throws ConfigException {
        super(configuration.getBaseDN().toNormalizedString(), configuration.getServerId());
        long heartbeatInterval = 0L;
        SortedSet<String> replicationServers = configuration.getReplicationServer();
        this.serverId = configuration.getServerId();
        this.baseDn = configuration.getBaseDN();
        int window = configuration.getWindowSize();
        heartbeatInterval = configuration.getHeartbeatInterval();
        this.isolationpolicy = configuration.getIsolationPolicy();
        this.configDn = configuration.dn();
        this.updateToReplayQueue = updateToReplayQueue;
        this.readAssuredConfig(configuration, false);
        this.fractionalConfig = new FractionalConfig(this.baseDn);
        this.readFractionalConfig(configuration, false);
        this.setGroupId((byte)configuration.getGroupId());
        this.setURLs(configuration.getReferralsUrl());
        this.createECLDomainCfg(configuration);
        this.solveConflictFlag = this.baseDn.compareTo(DirectoryServer.getSchemaDN()) == 0 ? false : configuration.isSolveConflicts();
        Backend backend = LDAPReplicationDomain.retrievesBackend(this.baseDn);
        if (backend == null) {
            throw new ConfigException(ReplicationMessages.ERR_SEARCHING_DOMAIN_BACKEND.get(this.baseDn.toNormalizedString()));
        }
        try {
            this.generationId = this.loadGenerationId();
        }
        catch (DirectoryException e) {
            ErrorLogger.logError(ReplicationMessages.ERR_LOADING_GENERATION_ID.get(this.baseDn.toNormalizedString(), e.getLocalizedMessage()));
        }
        this.state = new PersistentServerState(this.baseDn, this.serverId, this.getServerState());
        Long compatGenId = this.state.checkRUVCompat();
        if (compatGenId != null) {
            this.generationId = compatGenId;
            this.saveGenerationId(this.generationId);
        }
        this.generator = this.getGenerator();
        this.pendingChanges = new PendingChanges(this.generator, this);
        this.startPublishService(replicationServers, window, heartbeatInterval, configuration.getChangetimeHeartbeatInterval());
        this.remotePendingChanges = new RemotePendingChanges(this.getServerState());
        configuration.addChangeListener(this);
        DirectoryServer.registerAlertGenerator(this);
    }

    private void readAssuredConfig(ReplicationDomainCfg configuration, boolean allowReconnection) {
        boolean needReconnection = false;
        byte newSdLevel = (byte)configuration.getAssuredSdLevel();
        if (this.isAssured() && this.getAssuredMode() == AssuredMode.SAFE_DATA_MODE && newSdLevel != this.getAssuredSdLevel()) {
            needReconnection = true;
        }
        ReplicationDomainCfgDefn.AssuredType newAssuredType = configuration.getAssuredType();
        switch (newAssuredType) {
            case NOT_ASSURED: {
                if (!this.isAssured()) break;
                needReconnection = true;
                break;
            }
            case SAFE_DATA: {
                if (this.isAssured() && (!this.isAssured() || this.getAssuredMode() != AssuredMode.SAFE_READ_MODE)) break;
                needReconnection = true;
                break;
            }
            case SAFE_READ: {
                if (this.isAssured() && (!this.isAssured() || this.getAssuredMode() != AssuredMode.SAFE_DATA_MODE)) break;
                needReconnection = true;
            }
        }
        if (needReconnection && allowReconnection) {
            this.disableService();
        }
        switch (newAssuredType) {
            case NOT_ASSURED: {
                this.setAssured(false);
                break;
            }
            case SAFE_DATA: {
                this.setAssured(true);
                this.setAssuredMode(AssuredMode.SAFE_DATA_MODE);
                break;
            }
            case SAFE_READ: {
                this.setAssured(true);
                this.setAssuredMode(AssuredMode.SAFE_READ_MODE);
            }
        }
        this.setAssuredSdLevel(newSdLevel);
        this.setAssuredTimeout(configuration.getAssuredTimeout());
        if (needReconnection && allowReconnection) {
            this.enableService();
        }
    }

    public void setImportErrorMessageId(int importErrorMessageId) {
        this.importErrorMessageId = importErrorMessageId;
    }

    public void setFollowImport(boolean followImport) {
        this.followImport = followImport;
    }

    private void readFractionalConfig(ReplicationDomainCfg configuration, boolean allowReconnection) {
        int newFractionalMode;
        FractionalConfig newFractionalConfig = null;
        try {
            newFractionalConfig = FractionalConfig.toFractionalConfig(configuration);
        }
        catch (ConfigException e) {
            Message message = ReplicationMessages.NOTE_ERR_FRACTIONAL.get(this.baseDn.toString(), e.getLocalizedMessage());
            ErrorLogger.logError(message);
            return;
        }
        boolean needReconnection = false;
        try {
            needReconnection = !FractionalConfig.isFractionalConfigEquivalent(this.fractionalConfig, newFractionalConfig);
        }
        catch (ConfigException e) {
            Message message = ReplicationMessages.NOTE_ERR_FRACTIONAL.get(this.baseDn.toString(), e.getLocalizedMessage());
            ErrorLogger.logError(message);
            return;
        }
        if (needReconnection && allowReconnection) {
            this.disableService();
        }
        this.fractionalConfig.setFractional((newFractionalMode = newFractionalConfig.fractionalConfigToInt()) != 0);
        if (this.fractionalConfig.isFractional()) {
            if (newFractionalMode == 1) {
                this.fractionalConfig.setFractionalExclusive(true);
            } else {
                this.fractionalConfig.setFractionalExclusive(false);
            }
            this.fractionalConfig.setFractionalSpecificClassesAttributes(newFractionalConfig.getFractionalSpecificClassesAttributes());
            this.fractionalConfig.setFractionalAllClassesAttributes(newFractionalConfig.fractionalAllClassesAttributes);
        } else {
            this.fractionalConfig.setFractionalExclusive(true);
            this.fractionalConfig.setFractionalSpecificClassesAttributes(new HashMap<String, List<String>>());
            this.fractionalConfig.setFractionalAllClassesAttributes(new ArrayList<String>());
        }
        if (needReconnection && allowReconnection) {
            this.enableService();
        }
    }

    private boolean isBackendFractionalConfigConsistent() {
        Attribute inclAttr;
        Attribute exclAttr;
        AttributeType synchronizationGenIDType;
        List<Attribute> attrs;
        LinkedList<SearchResultEntry> result;
        LDAPFilter filter;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Attempt to read the potential fractional config in domain root entry " + this.baseDn.toString());
        }
        ByteString asn1BaseDn = ByteString.valueOf(this.baseDn.toString());
        boolean found = false;
        try {
            filter = LDAPFilter.decode("objectclass=*");
        }
        catch (LDAPException e) {
            return false;
        }
        InternalSearchOperation search = null;
        LinkedHashSet<String> attributes = new LinkedHashSet<String>(1);
        attributes.add(REPLICATION_GENERATION_ID);
        attributes.add(REPLICATION_FRACTIONAL_EXCLUDE);
        attributes.add(REPLICATION_FRACTIONAL_INCLUDE);
        search = this.conn.processSearch(asn1BaseDn, SearchScope.BASE_OBJECT, DereferencePolicy.DEREF_ALWAYS, 0, 0, false, filter, attributes);
        if (search.getResultCode() != ResultCode.SUCCESS && search.getResultCode() != ResultCode.NO_SUCH_OBJECT) {
            Message message = ReplicationMessages.ERR_SEARCHING_GENERATION_ID.get(search.getResultCode().getResultCodeName() + " " + search.getErrorMessage(), this.baseDn.toString());
            ErrorLogger.logError(message);
            return false;
        }
        SearchResultEntry resultEntry = null;
        if (search.getResultCode() == ResultCode.SUCCESS && (resultEntry = (result = search.getSearchEntries()).getFirst()) != null && (attrs = resultEntry.getAttribute(synchronizationGenIDType = DirectoryServer.getAttributeType(REPLICATION_GENERATION_ID))) != null) {
            Attribute attr = attrs.get(0);
            if (attr.size() > 1) {
                Message message = ReplicationMessages.ERR_LOADING_GENERATION_ID.get(this.baseDn.toString(), "#Values=" + attr.size() + " Must be exactly 1 in entry " + resultEntry.toLDIFString());
                ErrorLogger.logError(message);
            } else if (attr.size() == 1) {
                found = true;
            }
        }
        if (!found) {
            return !this.fractionalConfig.isFractional();
        }
        AttributeValueStringIterator exclIt = null;
        AttributeType fractionalExcludeType = DirectoryServer.getAttributeType(REPLICATION_FRACTIONAL_EXCLUDE);
        List<Attribute> exclAttrs = resultEntry.getAttribute(fractionalExcludeType);
        if (exclAttrs != null && (exclAttr = exclAttrs.get(0)) != null) {
            exclIt = new AttributeValueStringIterator(exclAttr.iterator());
        }
        AttributeValueStringIterator inclIt = null;
        AttributeType fractionalIncludeType = DirectoryServer.getAttributeType(REPLICATION_FRACTIONAL_INCLUDE);
        List<Attribute> inclAttrs = resultEntry.getAttribute(fractionalIncludeType);
        if (inclAttrs != null && (inclAttr = inclAttrs.get(0)) != null) {
            inclIt = new AttributeValueStringIterator(inclAttr.iterator());
        }
        return LDAPReplicationDomain.isFractionalConfigConsistent(this.fractionalConfig, exclIt, inclIt);
    }

    static boolean isFractionalConfigConsistent(FractionalConfig fractionalConfig, Iterator<String> exclIt, Iterator<String> inclIt) {
        HashMap<String, List<String>> storedFractionalSpecificClassesAttributes = new HashMap<String, List<String>>();
        ArrayList<String> storedFractionalAllClassesAttributes = new ArrayList<String>();
        int storedFractionalMode = 0;
        try {
            storedFractionalMode = FractionalConfig.parseFractionalConfig(exclIt, inclIt, storedFractionalSpecificClassesAttributes, storedFractionalAllClassesAttributes);
        }
        catch (ConfigException e) {
            Message message = ReplicationMessages.NOTE_ERR_FRACTIONAL.get(fractionalConfig.getBaseDn().toString(), e.getLocalizedMessage());
            ErrorLogger.logError(message);
            return false;
        }
        FractionalConfig storedFractionalConfig = new FractionalConfig(fractionalConfig.getBaseDn());
        storedFractionalConfig.setFractional(storedFractionalMode != 0);
        if (storedFractionalConfig.isFractional()) {
            if (storedFractionalMode == 1) {
                storedFractionalConfig.setFractionalExclusive(true);
            } else {
                storedFractionalConfig.setFractionalExclusive(false);
            }
        }
        storedFractionalConfig.setFractionalSpecificClassesAttributes(storedFractionalSpecificClassesAttributes);
        storedFractionalConfig.setFractionalAllClassesAttributes(storedFractionalAllClassesAttributes);
        try {
            return FractionalConfig.isFractionalConfigEquivalent(fractionalConfig, storedFractionalConfig);
        }
        catch (ConfigException e) {
            Message message = ReplicationMessages.NOTE_ERR_FRACTIONAL.get(fractionalConfig.getBaseDn().toString(), e.getLocalizedMessage());
            ErrorLogger.logError(message);
            return false;
        }
    }

    private static boolean isAttributeListEquivalent(List<String> attributes1, List<String> attributes2) throws ConfigException {
        if (attributes1.size() != attributes2.size()) {
            return false;
        }
        Schema schema = DirectoryServer.getSchema();
        for (String attributName1 : attributes1) {
            AttributeType attributeType1 = schema.getAttributeType(attributName1);
            if (attributeType1 == null) {
                throw new ConfigException(ReplicationMessages.NOTE_ERR_FRACTIONAL_CONFIG_UNKNOWN_ATTRIBUTE_TYPE.get(attributName1));
            }
            boolean foundAttribute = false;
            for (String attributName2 : attributes2) {
                AttributeType attributeType2 = schema.getAttributeType(attributName2);
                if (attributeType2 == null) {
                    throw new ConfigException(ReplicationMessages.NOTE_ERR_FRACTIONAL_CONFIG_UNKNOWN_ATTRIBUTE_TYPE.get(attributName2));
                }
                if (!attributeType1.equals(attributeType2)) continue;
                foundAttribute = true;
                break;
            }
            if (foundAttribute) continue;
            return false;
        }
        return true;
    }

    private static void isFractionalConfigAcceptable(ReplicationDomainCfg configuration) throws ConfigException {
        FractionalConfig newFractionalConfig = FractionalConfig.toFractionalConfig(configuration);
        if (!newFractionalConfig.isFractional()) {
            return;
        }
        Map<String, List<String>> newFractionalSpecificClassesAttributes = newFractionalConfig.getFractionalSpecificClassesAttributes();
        List<String> newFractionalAllClassesAttributes = newFractionalConfig.getFractionalAllClassesAttributes();
        Schema schema = DirectoryServer.getSchema();
        int fractionalMode = newFractionalConfig.fractionalConfigToInt();
        for (String className : newFractionalSpecificClassesAttributes.keySet()) {
            ObjectClass fractionalClass = schema.getObjectClass(className.toLowerCase());
            if (fractionalClass == null) {
                throw new ConfigException(ReplicationMessages.NOTE_ERR_FRACTIONAL_CONFIG_UNKNOWN_OBJECT_CLASS.get(className));
            }
            boolean isExtensibleObjectClass = className.equalsIgnoreCase("extensibleObject");
            List<String> attributes = newFractionalSpecificClassesAttributes.get(className);
            for (String attrName : attributes) {
                if (LDAPReplicationDomain.isFractionalProhibitedAttr(attrName)) {
                    throw new ConfigException(ReplicationMessages.NOTE_ERR_FRACTIONAL_CONFIG_PROHIBITED_ATTRIBUTE.get(attrName));
                }
                AttributeType attributeType = schema.getAttributeType(attrName);
                if (attributeType != null) {
                    if (isExtensibleObjectClass || fractionalMode != 1 || fractionalClass.isOptional(attributeType)) continue;
                    throw new ConfigException(ReplicationMessages.NOTE_ERR_FRACTIONAL_CONFIG_NOT_OPTIONAL_ATTRIBUTE.get(attrName, className));
                }
                throw new ConfigException(ReplicationMessages.NOTE_ERR_FRACTIONAL_CONFIG_UNKNOWN_ATTRIBUTE_TYPE.get(attrName));
            }
        }
        for (String attrName : newFractionalAllClassesAttributes) {
            if (LDAPReplicationDomain.isFractionalProhibitedAttr(attrName)) {
                throw new ConfigException(ReplicationMessages.NOTE_ERR_FRACTIONAL_CONFIG_PROHIBITED_ATTRIBUTE.get(attrName));
            }
            if (schema.getAttributeType(attrName) != null) continue;
            throw new ConfigException(ReplicationMessages.NOTE_ERR_FRACTIONAL_CONFIG_UNKNOWN_ATTRIBUTE_TYPE.get(attrName));
        }
    }

    private static boolean isFractionalProhibitedAttr(String attr) {
        for (String forbiddenAttr : FRACTIONAL_PROHIBITED_ATTRIBUTES) {
            if (!forbiddenAttr.equalsIgnoreCase(attr)) continue;
            return true;
        }
        return false;
    }

    public boolean fractionalFilterOperation(PreOperationAddOperation addOperation, boolean performFiltering) {
        return LDAPReplicationDomain.fractionalRemoveAttributesFromEntry(this.fractionalConfig, addOperation.getEntryDN().getRDN(), addOperation.getObjectClasses(), addOperation.getUserAttributes(), performFiltering);
    }

    public boolean fractionalFilterOperation(PreOperationModifyDNOperation modifyDNOperation, boolean performFiltering) {
        boolean inconsistentOperation = false;
        if (performFiltering && modifyDNOperation.deleteOldRDN()) {
            return true;
        }
        Entry concernedEntry = modifyDNOperation.getOriginalEntry();
        List<String> fractionalConcernedAttributes = LDAPReplicationDomain.createFractionalConcernedAttrList(this.fractionalConfig, concernedEntry.getObjectClasses().keySet());
        boolean fractionalExclusive = this.fractionalConfig.isFractionalExclusive();
        if (fractionalExclusive && fractionalConcernedAttributes.size() == 0) {
            return false;
        }
        RDN rdn = modifyDNOperation.getEntryDN().getRDN();
        RDN newRdn = modifyDNOperation.getNewRDN();
        for (int i = 0; i < rdn.getNumValues(); ++i) {
            boolean attributeToBeFiltered;
            AttributeType attributeType = rdn.getAttributeType(i);
            boolean found = false;
            for (String attrTypeStr : fractionalConcernedAttributes) {
                AttributeType attributeTypeFromList = DirectoryServer.getAttributeType(attrTypeStr);
                if (!attributeTypeFromList.equals(attributeType)) continue;
                found = true;
                break;
            }
            boolean bl = attributeToBeFiltered = fractionalExclusive && found || !fractionalExclusive && !found;
            if (!attributeToBeFiltered || newRdn.hasAttributeType(attributeType) || modifyDNOperation.deleteOldRDN()) continue;
            Modification modification = new Modification(ModificationType.DELETE, Attributes.empty(attributeType));
            modifyDNOperation.addModification(modification);
            inconsistentOperation = true;
        }
        return inconsistentOperation;
    }

    static boolean fractionalRemoveAttributesFromEntry(FractionalConfig fractionalConfig, RDN entryRdn, Map<ObjectClass, String> classes, Map<AttributeType, List<Attribute>> attributesMap, boolean performFiltering) {
        boolean hasSomeAttributesToFilter = false;
        List<String> fractionalConcernedAttributes = LDAPReplicationDomain.createFractionalConcernedAttrList(fractionalConfig, classes.keySet());
        boolean fractionalExclusive = fractionalConfig.isFractionalExclusive();
        if (fractionalExclusive && fractionalConcernedAttributes.size() == 0) {
            return false;
        }
        Set<ObjectClass> entryClasses = classes.keySet();
        Iterator<AttributeType> attributeTypes = attributesMap.keySet().iterator();
        ArrayList newRdnAttrLists = new ArrayList();
        ArrayList<AttributeType> rdnAttrTypes = new ArrayList<AttributeType>();
        while (attributeTypes.hasNext()) {
            AttributeType attributeType = attributeTypes.next();
            boolean isMandatoryAttribute = false;
            for (ObjectClass objectClass : entryClasses) {
                if (!objectClass.isRequired(attributeType)) continue;
                isMandatoryAttribute = true;
                break;
            }
            if (isMandatoryAttribute) continue;
            String attributeName = attributeType.getPrimaryName();
            String attributeOid = attributeType.getOID();
            if (attributeName != null && LDAPReplicationDomain.isFractionalProhibitedAttr(attributeName) || LDAPReplicationDomain.isFractionalProhibitedAttr(attributeOid)) continue;
            boolean foundAttribute = fractionalConcernedAttributes.contains(attributeName.toLowerCase());
            if (!foundAttribute) {
                foundAttribute = fractionalConcernedAttributes.contains(attributeOid);
            }
            if ((!foundAttribute || !fractionalExclusive) && (foundAttribute || fractionalExclusive)) continue;
            if (performFiltering) {
                if (entryRdn.hasAttributeType(attributeType)) {
                    AttributeValue rdnAttributeValue = entryRdn.getAttributeValue(attributeType);
                    List<Attribute> attrList = attributesMap.get(attributeType);
                    Iterator<Attribute> attrIt = attrList.iterator();
                    AttributeValue sameAttrValue = null;
                    while (attrIt.hasNext()) {
                        Attribute attr = attrIt.next();
                        if (attr.contains(rdnAttributeValue)) {
                            for (AttributeValue attrValue : attr) {
                                if (((Object)rdnAttributeValue).equals(attrValue)) {
                                    sameAttrValue = attrValue;
                                    continue;
                                }
                                hasSomeAttributesToFilter = true;
                            }
                            continue;
                        }
                        hasSomeAttributesToFilter = true;
                    }
                    if (sameAttrValue == null) continue;
                    ArrayList<Attribute> newRdnAttrList = new ArrayList<Attribute>();
                    AttributeBuilder attrBuilder = new AttributeBuilder(attributeType);
                    attrBuilder.add(sameAttrValue);
                    newRdnAttrList.add(attrBuilder.toAttribute());
                    newRdnAttrLists.add(newRdnAttrList);
                    rdnAttrTypes.add(attributeType);
                    continue;
                }
                attributeTypes.remove();
                hasSomeAttributesToFilter = true;
                continue;
            }
            return true;
        }
        int index = 0;
        for (index = 0; index < rdnAttrTypes.size(); ++index) {
            attributesMap.put((AttributeType)rdnAttrTypes.get(index), (List<Attribute>)newRdnAttrLists.get(index));
        }
        return hasSomeAttributesToFilter;
    }

    private static List<String> createFractionalConcernedAttrList(FractionalConfig fractionalConfig, Set<ObjectClass> entryObjectClasses) {
        ArrayList<String> fractionalConcernedAttributes = new ArrayList<String>();
        List<String> fractionalAllClassesAttributes = fractionalConfig.getFractionalAllClassesAttributes();
        Map<String, List<String>> fractionalSpecificClassesAttributes = fractionalConfig.getFractionalSpecificClassesAttributes();
        Set<String> fractionalClasses = fractionalSpecificClassesAttributes.keySet();
        for (ObjectClass entryObjectClass : entryObjectClasses) {
            for (String fractionalClass : fractionalClasses) {
                if (!entryObjectClass.hasNameOrOID(fractionalClass.toLowerCase())) continue;
                List<String> attrList = fractionalSpecificClassesAttributes.get(fractionalClass);
                for (String attr : attrList) {
                    if (fractionalConcernedAttributes.contains(attr)) continue;
                    fractionalConcernedAttributes.add(attr);
                }
            }
        }
        for (String attr : fractionalAllClassesAttributes) {
            if (fractionalConcernedAttributes.contains(attr)) continue;
            fractionalConcernedAttributes.add(attr);
        }
        return fractionalConcernedAttributes;
    }

    public int fractionalFilterOperation(PreOperationModifyOperation modifyOperation, boolean performFiltering) {
        int result = 2;
        Entry modifiedEntry = modifyOperation.getCurrentEntry();
        List<String> fractionalConcernedAttributes = LDAPReplicationDomain.createFractionalConcernedAttrList(this.fractionalConfig, modifiedEntry.getObjectClasses().keySet());
        boolean fractionalExclusive = this.fractionalConfig.isFractionalExclusive();
        if (fractionalExclusive && fractionalConcernedAttributes.size() == 0) {
            return 2;
        }
        DN entryToModifyDn = modifyOperation.getEntryDN();
        Entry entryToModify = null;
        try {
            entryToModify = DirectoryServer.getEntry(entryToModifyDn);
        }
        catch (DirectoryException e) {
            Message message = ReplicationMessages.NOTE_ERR_FRACTIONAL.get(this.baseDn.toString(), e.getLocalizedMessage());
            ErrorLogger.logError(message);
            return 2;
        }
        Set<ObjectClass> entryClasses = entryToModify.getObjectClasses().keySet();
        List<Modification> mods = modifyOperation.getModifications();
        Iterator<Modification> modsIt = mods.iterator();
        while (modsIt.hasNext()) {
            Modification mod = modsIt.next();
            Attribute attr = mod.getAttribute();
            AttributeType attrType = attr.getAttributeType();
            if (attrType.isOperational()) continue;
            boolean isMandatoryAttribute = false;
            for (ObjectClass objectClass : entryClasses) {
                if (!objectClass.isRequired(attrType)) continue;
                isMandatoryAttribute = true;
                break;
            }
            if (isMandatoryAttribute) continue;
            String attributeName = attrType.getPrimaryName();
            String attributeOid = attrType.getOID();
            if (attributeName != null && LDAPReplicationDomain.isFractionalProhibitedAttr(attributeName) || LDAPReplicationDomain.isFractionalProhibitedAttr(attributeOid)) continue;
            boolean foundAttribute = fractionalConcernedAttributes.contains(attributeName.toLowerCase());
            if (!foundAttribute) {
                foundAttribute = fractionalConcernedAttributes.contains(attributeOid);
            }
            if ((!foundAttribute || !fractionalExclusive) && (foundAttribute || fractionalExclusive)) continue;
            if (performFiltering) {
                modsIt.remove();
                result = 1;
                if (mods.size() != 0) continue;
                return 3;
            }
            return 1;
        }
        return result;
    }

    @Override
    protected byte[] receiveEntryBytes() {
        if (this.followImport) {
            return super.receiveEntryBytes();
        }
        Message msg = null;
        switch (this.importErrorMessageId) {
            case 1: {
                msg = ReplicationMessages.NOTE_ERR_FULL_UPDATE_IMPORT_FRACTIONAL_BAD_REMOTE.get(this.baseDn.toString(), Integer.toString(this.ieContext.getImportSource()));
                break;
            }
            case 2: {
                msg = ReplicationMessages.NOTE_ERR_FULL_UPDATE_IMPORT_FRACTIONAL_REMOTE_IS_FRACTIONAL.get(this.baseDn.toString(), Integer.toString(this.ieContext.getImportSource()));
            }
        }
        this.ieContext.setException(new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, msg));
        return null;
    }

    @Override
    protected void initializeRemote(int target, int requestorID, Task initTask) throws DirectoryException {
        if (target == -2 && this.fractionalConfig.isFractional()) {
            Message msg = ReplicationMessages.NOTE_ERR_FRACTIONAL_FORBIDDEN_FULL_UPDATE_FRACTIONAL.get(this.baseDn.toString(), Integer.toString(this.getServerId()));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, msg);
        }
        super.initializeRemote(target, requestorID, initTask);
    }

    public DN getBaseDN() {
        return this.baseDn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynchronizationProviderResult handleConflictResolution(PreOperationDeleteOperation deleteOperation) {
        if (!deleteOperation.isSynchronizationOperation() && !this.brokerIsConnected(deleteOperation)) {
            Message msg = ReplicationMessages.ERR_REPLICATION_COULD_NOT_CONNECT.get(this.baseDn.toString());
            return new SynchronizationProviderResult.StopProcessing(ResultCode.UNWILLING_TO_PERFORM, msg);
        }
        DeleteContext ctx = (DeleteContext)deleteOperation.getAttachment("replicationContext");
        Entry deletedEntry = deleteOperation.getEntryToDelete();
        if (ctx != null) {
            String modifiedEntryUUID;
            String operationEntryUUID = ctx.getEntryUid();
            if (!operationEntryUUID.equals(modifiedEntryUUID = Historical.getEntryUuid(deletedEntry))) {
                return new SynchronizationProviderResult.StopProcessing(ResultCode.NO_SUCH_OBJECT, null);
            }
        } else {
            ChangeNumber changeNumber = this.generateChangeNumber(deleteOperation);
            String modifiedEntryUUID = Historical.getEntryUuid(deletedEntry);
            ctx = new DeleteContext(changeNumber, modifiedEntryUUID);
            deleteOperation.setAttachment("replicationContext", ctx);
            TreeMap<ChangeNumber, FakeOperation> treeMap = this.replayOperations;
            synchronized (treeMap) {
                int size = this.replayOperations.size();
                if (size >= 10000) {
                    this.replayOperations.remove(this.replayOperations.firstKey());
                }
                this.replayOperations.put(changeNumber, new FakeDelOperation(deleteOperation.getEntryDN().toString(), changeNumber, modifiedEntryUUID));
            }
        }
        return new SynchronizationProviderResult.ContinueProcessing();
    }

    public SynchronizationProviderResult handleConflictResolution(PreOperationAddOperation addOperation) {
        if (!addOperation.isSynchronizationOperation() && !this.brokerIsConnected(addOperation)) {
            Message msg = ReplicationMessages.ERR_REPLICATION_COULD_NOT_CONNECT.get(this.baseDn.toString());
            return new SynchronizationProviderResult.StopProcessing(ResultCode.UNWILLING_TO_PERFORM, msg);
        }
        if (this.fractionalConfig.isFractional()) {
            if (addOperation.isSynchronizationOperation()) {
                this.fractionalFilterOperation(addOperation, true);
            } else if (this.fractionalFilterOperation(addOperation, false)) {
                StringBuilder sb = new StringBuilder();
                addOperation.toString(sb);
                Message msg = ReplicationMessages.NOTE_ERR_FRACTIONAL_FORBIDDEN_OPERATION.get(this.baseDn.toString(), sb.toString());
                return new SynchronizationProviderResult.StopProcessing(ResultCode.UNWILLING_TO_PERFORM, msg);
            }
        }
        if (addOperation.isSynchronizationOperation()) {
            AddContext ctx = (AddContext)addOperation.getAttachment("replicationContext");
            String uuid = ctx.getEntryUid();
            if (this.findEntryDN(uuid) != null) {
                return new SynchronizationProviderResult.StopProcessing(ResultCode.CANCELED, null);
            }
            String parentUid = ctx.getParentUid();
            if (parentUid != null) {
                DN parentDnFromCtx = this.findEntryDN(ctx.getParentUid());
                if (parentDnFromCtx == null) {
                    return new SynchronizationProviderResult.StopProcessing(ResultCode.NO_SUCH_OBJECT, null);
                }
                DN entryDN = addOperation.getEntryDN();
                DN parentDnFromEntryDn = entryDN.getParentDNInSuffix();
                if (parentDnFromEntryDn != null && !parentDnFromCtx.equals(parentDnFromEntryDn)) {
                    return new SynchronizationProviderResult.StopProcessing(ResultCode.NO_SUCH_OBJECT, null);
                }
            }
        }
        return new SynchronizationProviderResult.ContinueProcessing();
    }

    private boolean brokerIsConnected(PreOperationOperation op) {
        if (this.isolationpolicy.equals((Object)ReplicationDomainCfgDefn.IsolationPolicy.ACCEPT_ALL_UPDATES)) {
            return true;
        }
        if (this.isolationpolicy.equals((Object)ReplicationDomainCfgDefn.IsolationPolicy.REJECT_ALL_UPDATES)) {
            return !this.hasConnectionError();
        }
        return true;
    }

    public SynchronizationProviderResult handleConflictResolution(PreOperationModifyDNOperation modifyDNOperation) {
        ModifyDnContext ctx;
        if (!modifyDNOperation.isSynchronizationOperation() && !this.brokerIsConnected(modifyDNOperation)) {
            Message msg = ReplicationMessages.ERR_REPLICATION_COULD_NOT_CONNECT.get(this.baseDn.toString());
            return new SynchronizationProviderResult.StopProcessing(ResultCode.UNWILLING_TO_PERFORM, msg);
        }
        if (this.fractionalConfig.isFractional()) {
            if (modifyDNOperation.isSynchronizationOperation()) {
                this.fractionalFilterOperation(modifyDNOperation, true);
            } else if (this.fractionalFilterOperation(modifyDNOperation, false)) {
                StringBuilder sb = new StringBuilder();
                modifyDNOperation.toString(sb);
                Message msg = ReplicationMessages.NOTE_ERR_FRACTIONAL_FORBIDDEN_OPERATION.get(this.baseDn.toString(), sb.toString());
                return new SynchronizationProviderResult.StopProcessing(ResultCode.UNWILLING_TO_PERFORM, msg);
            }
        }
        if ((ctx = (ModifyDnContext)modifyDNOperation.getAttachment("replicationContext")) != null) {
            String newParentId;
            String modifiedEntryUUID = Historical.getEntryUuid(modifyDNOperation.getOriginalEntry());
            if (!modifiedEntryUUID.equals(ctx.getEntryUid())) {
                return new SynchronizationProviderResult.StopProcessing(ResultCode.NO_SUCH_OBJECT, null);
            }
            if (modifyDNOperation.getNewSuperior() != null && (newParentId = LDAPReplicationDomain.findEntryId(modifyDNOperation.getNewSuperior())) != null && ctx.getNewParentId() != null && !newParentId.equals(ctx.getNewParentId())) {
                return new SynchronizationProviderResult.StopProcessing(ResultCode.NO_SUCH_OBJECT, null);
            }
            Historical hist = Historical.load(modifyDNOperation.getOriginalEntry());
            if (hist.AddedOrRenamedAfter(ctx.getChangeNumber())) {
                return new SynchronizationProviderResult.StopProcessing(ResultCode.SUCCESS, null);
            }
        } else {
            ChangeNumber changeNumber = this.generateChangeNumber(modifyDNOperation);
            String newParentId = null;
            if (modifyDNOperation.getNewSuperior() != null) {
                newParentId = LDAPReplicationDomain.findEntryId(modifyDNOperation.getNewSuperior());
            }
            Entry modifiedEntry = modifyDNOperation.getOriginalEntry();
            String modifiedEntryUUID = Historical.getEntryUuid(modifiedEntry);
            ctx = new ModifyDnContext(changeNumber, modifiedEntryUUID, newParentId);
            modifyDNOperation.setAttachment("replicationContext", ctx);
        }
        return new SynchronizationProviderResult.ContinueProcessing();
    }

    public SynchronizationProviderResult handleConflictResolution(PreOperationModifyOperation modifyOperation) {
        if (!modifyOperation.isSynchronizationOperation() && !this.brokerIsConnected(modifyOperation)) {
            Message msg = ReplicationMessages.ERR_REPLICATION_COULD_NOT_CONNECT.get(this.baseDn.toString());
            return new SynchronizationProviderResult.StopProcessing(ResultCode.UNWILLING_TO_PERFORM, msg);
        }
        if (this.fractionalConfig.isFractional()) {
            if (modifyOperation.isSynchronizationOperation()) {
                if (this.fractionalFilterOperation(modifyOperation, true) == 3) {
                    return new SynchronizationProviderResult.StopProcessing(ResultCode.SUCCESS, null);
                }
            } else {
                switch (this.fractionalFilterOperation(modifyOperation, false)) {
                    case 2: {
                        break;
                    }
                    case 1: {
                        StringBuilder sb = new StringBuilder();
                        modifyOperation.toString(sb);
                        Message msg = ReplicationMessages.NOTE_ERR_FRACTIONAL_FORBIDDEN_OPERATION.get(this.baseDn.toString(), sb.toString());
                        return new SynchronizationProviderResult.StopProcessing(ResultCode.UNWILLING_TO_PERFORM, msg);
                    }
                }
            }
        }
        ModifyContext ctx = (ModifyContext)modifyOperation.getAttachment("replicationContext");
        Entry modifiedEntry = modifyOperation.getModifiedEntry();
        if (ctx == null) {
            ChangeNumber changeNumber = this.generateChangeNumber(modifyOperation);
            String modifiedEntryUUID = Historical.getEntryUuid(modifiedEntry);
            if (modifiedEntryUUID == null) {
                modifiedEntryUUID = modifyOperation.getEntryDN().toString();
            }
            ctx = new ModifyContext(changeNumber, modifiedEntryUUID);
            modifyOperation.setAttachment("replicationContext", ctx);
        } else {
            String modifiedEntryUUID = ctx.getEntryUid();
            String currentEntryUUID = Historical.getEntryUuid(modifiedEntry);
            if (currentEntryUUID != null && !currentEntryUUID.equals(modifiedEntryUUID)) {
                return new SynchronizationProviderResult.StopProcessing(ResultCode.NO_SUCH_OBJECT, null);
            }
            Historical historicalInformation = Historical.load(modifiedEntry);
            modifyOperation.setAttachment("ds-synch-historical", historicalInformation);
            if (historicalInformation.replayOperation(modifyOperation, modifiedEntry)) {
                this.numResolvedModifyConflicts.incrementAndGet();
            }
            if (modifyOperation.getModifications().isEmpty()) {
                return new SynchronizationProviderResult.StopProcessing(ResultCode.SUCCESS, null);
            }
        }
        return new SynchronizationProviderResult.ContinueProcessing();
    }

    public void doPreOperation(PreOperationAddOperation addOperation) {
        AddContext ctx = new AddContext(this.generateChangeNumber(addOperation), Historical.getEntryUuid(addOperation), LDAPReplicationDomain.findEntryId(addOperation.getEntryDN().getParentDNInSuffix()));
        addOperation.setAttachment("replicationContext", ctx);
        Historical.generateState(addOperation);
    }

    public void synchronize(PostOperationOperation op) {
        ResultCode result = op.getResultCode();
        if (result == ResultCode.SUCCESS && op.isSynchronizationOperation()) {
            ++this.numReplayedPostOpCalled;
        }
        LDAPUpdateMsg msg = null;
        ChangeNumber curChangeNumber = OperationContext.getChangeNumber(op);
        if (result == ResultCode.SUCCESS && !op.isSynchronizationOperation() && (msg = LDAPUpdateMsg.generateMsg(op)) == null) {
            this.pendingChanges.remove(curChangeNumber);
            Message message = ReplicationMessages.ERR_UNKNOWN_TYPE.get(op.getOperationType().toString());
            ErrorLogger.logError(message);
            return;
        }
        if (result == ResultCode.SUCCESS) {
            block16: {
                try {
                    if (op.isSynchronizationOperation()) {
                        this.remotePendingChanges.commit(curChangeNumber);
                        break block16;
                    }
                    try {
                        this.addEntryAttributesForCL(msg, op);
                    }
                    catch (Exception e) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    this.prepareWaitForAckIfAssuredEnabled(msg);
                    try {
                        msg.encode();
                    }
                    catch (UnsupportedEncodingException e) {
                        // empty catch block
                    }
                    this.pendingChanges.commitAndPushCommittedChanges(curChangeNumber, msg);
                }
                catch (NoSuchElementException e) {
                    Message message = ReplicationMessages.ERR_OPERATION_NOT_FOUND_IN_PENDING.get(curChangeNumber.toString(), op.toString());
                    ErrorLogger.logError(message);
                    return;
                }
            }
            if (!this.generationIdSavedStatus) {
                this.saveGenerationId(this.generationId);
            }
            if (!op.isSynchronizationOperation()) {
                try {
                    this.waitForAckIfAssuredEnabled(msg);
                }
                catch (TimeoutException ex) {
                    Message errorMsg = ReplicationMessages.NOTE_DS_ACK_TIMEOUT.get(this.getServiceID(), Long.toString(this.getAssuredTimeout()), msg.toString());
                    ErrorLogger.logError(errorMsg);
                }
            }
        } else if (!op.isSynchronizationOperation() && curChangeNumber != null) {
            this.pendingChanges.remove(curChangeNumber);
            this.pendingChanges.pushCommittedChanges();
        }
    }

    public int getPendingUpdatesCount() {
        if (this.pendingChanges != null) {
            return this.pendingChanges.size();
        }
        return 0;
    }

    public int getNumReplayedPostOpCalled() {
        return this.numReplayedPostOpCalled;
    }

    public int getDebugCount() {
        return 0;
    }

    public void delete() {
        this.shutdown();
        this.removeECLDomainCfg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown = true;
        if (this.flushThread != null) {
            ServerStateFlush serverStateFlush = this.flushThread;
            synchronized (serverStateFlush) {
                this.flushThread.notify();
            }
        }
        DirectoryServer.deregisterAlertGenerator(this);
        this.stopDomain();
        try {
            while (!this.done) {
                Thread.sleep(50L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void replay(LDAPUpdateMsg msg) {
        op = null;
        done = false;
        dependency = false;
        changeNumber = null;
        retryCount = 10;
        do {
            replayErrorMsg = null;
            try {
                op = msg.createOperation(this.conn);
                dependency = this.remotePendingChanges.checkDependencies(op, msg);
                while (!dependency && !done && retryCount-- > 0) {
                    op.setInternalOperation(true);
                    op.setSynchronizationOperation(true);
                    changeNumber = OperationContext.getChangeNumber(op);
                    op.run();
                    result = op.getResultCode();
                    if (result != ResultCode.SUCCESS) {
                        if (op instanceof ModifyOperation) {
                            newOp /* !! */  = (ModifyOperation)op;
                            dependency = this.remotePendingChanges.checkDependencies(newOp /* !! */ );
                            modifyMsg = (ModifyMsg)msg;
                            done = this.solveNamingConflict(newOp /* !! */ , modifyMsg);
                        } else if (op instanceof DeleteOperation) {
                            newOp /* !! */  = (DeleteOperation)op;
                            dependency = this.remotePendingChanges.checkDependencies((DeleteOperation)newOp /* !! */ );
                            done = this.solveNamingConflict((DeleteOperation)newOp /* !! */ , msg);
                        } else if (op instanceof AddOperation) {
                            newOp /* !! */  = (AddOperation)op;
                            addMsg = (AddMsg)msg;
                            dependency = this.remotePendingChanges.checkDependencies((AddOperation)newOp /* !! */ );
                            done = this.solveNamingConflict((AddOperation)newOp /* !! */ , addMsg);
                        } else if (op instanceof ModifyDNOperationBasis) {
                            newOp /* !! */  = (ModifyDNOperationBasis)op;
                            done = this.solveNamingConflict((ModifyDNOperation)newOp /* !! */ , msg);
                        } else {
                            done = true;
                        }
                        if (done) {
                            this.updateError(changeNumber);
                            continue;
                        }
                        op = msg.createOperation(this.conn);
                        if (!(op instanceof DeleteOperation)) continue;
                        op.addRequestControl(new SubtreeDeleteControl(false));
                        continue;
                    }
                    done = true;
                }
                if (!done && !dependency) {
                    message = ReplicationMessages.ERR_LOOP_REPLAYING_OPERATION.get(op.toString(), op.getErrorMessage().toString());
                    ErrorLogger.logError(message);
                    this.numUnresolvedNamingConflicts.incrementAndGet();
                    replayErrorMsg = message.toString();
                    this.updateError(changeNumber);
                }
                ** if (dependency) goto lbl-1000
            }
            catch (ASN1Exception e) {
                message = ReplicationMessages.ERR_EXCEPTION_DECODING_OPERATION.get(String.valueOf(msg) + StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                replayErrorMsg = message.toString();
                ** if (dependency) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    this.processUpdateDone(msg, replayErrorMsg);
                }
lbl-1000:
                // 2 sources

                {
                }
                catch (LDAPException e) {
                    message = ReplicationMessages.ERR_EXCEPTION_DECODING_OPERATION.get(String.valueOf(msg) + StaticUtils.stackTraceToSingleLineString(e));
                    ErrorLogger.logError(message);
                    replayErrorMsg = message.toString();
                    ** if (dependency) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        this.processUpdateDone(msg, replayErrorMsg);
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                    catch (DataFormatException e) {
                        message = ReplicationMessages.ERR_EXCEPTION_DECODING_OPERATION.get(String.valueOf(msg) + StaticUtils.stackTraceToSingleLineString(e));
                        ErrorLogger.logError(message);
                        replayErrorMsg = message.toString();
                        ** if (dependency) goto lbl-1000
lbl-1000:
                        // 1 sources

                        {
                            this.processUpdateDone(msg, replayErrorMsg);
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                        catch (Exception e) {
                            try {
                                if (changeNumber != null) {
                                    message = ReplicationMessages.ERR_EXCEPTION_REPLAYING_OPERATION.get(StaticUtils.stackTraceToSingleLineString(e), op.toString());
                                    ErrorLogger.logError(message);
                                    replayErrorMsg = message.toString();
                                    this.updateError(changeNumber);
                                } else {
                                    message = ReplicationMessages.ERR_EXCEPTION_DECODING_OPERATION.get(String.valueOf(msg) + StaticUtils.stackTraceToSingleLineString(e));
                                    ErrorLogger.logError(message);
                                    replayErrorMsg = message.toString();
                                }
                                ** if (dependency) goto lbl-1000
                            }
                            catch (Throwable var11_15) {
                                if (!dependency) {
                                    this.processUpdateDone(msg, replayErrorMsg);
                                }
                                throw var11_15;
                            }
lbl-1000:
                            // 1 sources

                            {
                                this.processUpdateDone(msg, replayErrorMsg);
                            }
lbl-1000:
                            // 2 sources

                            {
                            }
                        }
                    }
                }
            }
lbl-1000:
            // 1 sources

            {
                this.processUpdateDone(msg, replayErrorMsg);
            }
lbl-1000:
            // 2 sources

            {
            }
            msg = this.remotePendingChanges.getNextUpdate();
            done = false;
            dependency = false;
            changeNumber = null;
            retryCount = 10;
        } while (msg != null);
    }

    public void updateError(ChangeNumber changeNumber) {
        this.remotePendingChanges.commit(changeNumber);
    }

    private ChangeNumber generateChangeNumber(PluginOperation operation) {
        return this.pendingChanges.putLocalOperation(operation);
    }

    static String findEntryId(DN dn) {
        if (dn == null) {
            return null;
        }
        try {
            SearchResultEntry resultEntry;
            LinkedList<SearchResultEntry> result;
            InternalClientConnection conn = InternalClientConnection.getRootConnection();
            LinkedHashSet<String> attrs = new LinkedHashSet<String>(1);
            attrs.add("entryuuid");
            InternalSearchOperation search = conn.processSearch(dn, SearchScope.BASE_OBJECT, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, SearchFilter.createFilterFromString("objectclass=*"), attrs);
            if (search.getResultCode() == ResultCode.SUCCESS && !(result = search.getSearchEntries()).isEmpty() && (resultEntry = result.getFirst()) != null) {
                return Historical.getEntryUuid(resultEntry);
            }
        }
        catch (DirectoryException directoryException) {
            // empty catch block
        }
        return null;
    }

    private DN findEntryDN(String uuid) {
        try {
            SearchResultEntry resultEntry;
            LinkedList<SearchResultEntry> result;
            InternalSearchOperation search = this.conn.processSearch(this.baseDn, SearchScope.WHOLE_SUBTREE, SearchFilter.createFilterFromString("entryuuid=" + uuid));
            if (search.getResultCode() == ResultCode.SUCCESS && !(result = search.getSearchEntries()).isEmpty() && (resultEntry = result.getFirst()) != null) {
                return resultEntry.getDN();
            }
        }
        catch (DirectoryException directoryException) {
            // empty catch block
        }
        return null;
    }

    private boolean solveNamingConflict(ModifyOperation op, ModifyMsg msg) {
        ResultCode result = op.getResultCode();
        ModifyContext ctx = (ModifyContext)op.getAttachment("replicationContext");
        String entryUid = ctx.getEntryUid();
        if (result == ResultCode.NO_SUCH_OBJECT) {
            DN newdn = this.findEntryDN(entryUid);
            if (newdn != null) {
                msg.setDn(newdn.toString());
                this.numResolvedNamingConflicts.incrementAndGet();
                return false;
            }
            this.numResolvedNamingConflicts.incrementAndGet();
            return true;
        }
        if (result == ResultCode.NOT_ALLOWED_ON_RDN) {
            DN currentDN = this.findEntryDN(entryUid);
            RDN currentRDN = null;
            if (currentDN == null) {
                this.numResolvedNamingConflicts.incrementAndGet();
                return true;
            }
            currentRDN = currentDN.getRDN();
            List<Modification> mods = op.getModifications();
            for (Modification mod : mods) {
                AttributeType modAttrType = mod.getAttribute().getAttributeType();
                if (mod.getModificationType() != ModificationType.DELETE && mod.getModificationType() != ModificationType.REPLACE || !currentRDN.hasAttributeType(modAttrType)) continue;
                mod.setModificationType(ModificationType.REPLACE);
                Attribute newAttribute = mod.getAttribute();
                AttributeBuilder attrBuilder = newAttribute == null ? new AttributeBuilder(modAttrType) : new AttributeBuilder(newAttribute);
                attrBuilder.add(currentRDN.getAttributeValue(modAttrType));
                mod.setAttribute(attrBuilder.toAttribute());
            }
            msg.setMods(mods);
            this.numResolvedNamingConflicts.incrementAndGet();
            return false;
        }
        Message message = ReplicationMessages.ERR_ERROR_REPLAYING_OPERATION.get(op.toString(), ctx.getChangeNumber().toString(), result.toString(), op.getErrorMessage().toString());
        ErrorLogger.logError(message);
        return true;
    }

    private boolean solveNamingConflict(DeleteOperation op, LDAPUpdateMsg msg) {
        ResultCode result = op.getResultCode();
        DeleteContext ctx = (DeleteContext)op.getAttachment("replicationContext");
        String entryUid = ctx.getEntryUid();
        if (result == ResultCode.NO_SUCH_OBJECT) {
            DN currentDn = this.findEntryDN(entryUid);
            if (currentDn == null) {
                this.numResolvedNamingConflicts.incrementAndGet();
                return true;
            }
            msg.setDn(currentDn.toString());
            this.numResolvedNamingConflicts.incrementAndGet();
            return false;
        }
        if (result == ResultCode.NOT_ALLOWED_ON_NONLEAF) {
            if (this.findAndRenameChild(entryUid, op.getEntryDN(), op)) {
                this.numUnresolvedNamingConflicts.incrementAndGet();
            }
            return false;
        }
        Message message = ReplicationMessages.ERR_ERROR_REPLAYING_OPERATION.get(op.toString(), ctx.getChangeNumber().toString(), result.toString(), op.getErrorMessage().toString());
        ErrorLogger.logError(message);
        return true;
    }

    private boolean solveNamingConflict(ModifyDNOperation op, LDAPUpdateMsg msg) throws Exception {
        ResultCode result = op.getResultCode();
        ModifyDnContext ctx = (ModifyDnContext)op.getAttachment("replicationContext");
        String entryUid = ctx.getEntryUid();
        String newSuperiorID = ctx.getNewParentId();
        DN currentDN = this.findEntryDN(entryUid);
        DN entryDN = op.getEntryDN();
        DN newSuperior = null;
        RDN newRDN = op.getNewRDN();
        newSuperior = newSuperiorID != null ? this.findEntryDN(newSuperiorID) : entryDN.getParent();
        if (newSuperior == null) {
            this.markConflictEntry(op, currentDN, currentDN.getParent().concat(newRDN));
            this.numUnresolvedNamingConflicts.incrementAndGet();
            return true;
        }
        DN newDN = newSuperior.concat(newRDN);
        if (currentDN == null) {
            this.numResolvedNamingConflicts.incrementAndGet();
            return true;
        }
        if (newDN.equals(currentDN)) {
            this.numResolvedNamingConflicts.incrementAndGet();
            return true;
        }
        if (result == ResultCode.NO_SUCH_OBJECT || result == ResultCode.UNWILLING_TO_PERFORM || result == ResultCode.OBJECTCLASS_VIOLATION) {
            ModifyDNMsg modifyDnMsg = (ModifyDNMsg)msg;
            msg.setDn(currentDN.toString());
            modifyDnMsg.setNewSuperior(newSuperior.toString());
            this.numResolvedNamingConflicts.incrementAndGet();
            return false;
        }
        if (result == ResultCode.ENTRY_ALREADY_EXISTS) {
            ModifyDNMsg modifyDnMsg = (ModifyDNMsg)msg;
            this.markConflictEntry(op, op.getEntryDN(), newDN);
            modifyDnMsg.setNewRDN(this.generateConflictRDN(entryUid, modifyDnMsg.getNewRDN()));
            modifyDnMsg.setNewSuperior(newSuperior.toString());
            this.numUnresolvedNamingConflicts.incrementAndGet();
            return false;
        }
        Message message = ReplicationMessages.ERR_ERROR_REPLAYING_OPERATION.get(op.toString(), ctx.getChangeNumber().toString(), result.toString(), op.getErrorMessage().toString());
        ErrorLogger.logError(message);
        return true;
    }

    private boolean solveNamingConflict(AddOperation op, AddMsg msg) throws Exception {
        ResultCode result = op.getResultCode();
        AddContext ctx = (AddContext)op.getAttachment("replicationContext");
        String entryUid = ctx.getEntryUid();
        String parentUniqueId = ctx.getParentUid();
        if (result == ResultCode.NO_SUCH_OBJECT) {
            if (parentUniqueId == null) {
                return true;
            }
            DN parentDn = this.findEntryDN(parentUniqueId);
            if (parentDn == null) {
                this.addConflict(msg);
                msg.setDn(this.generateConflictRDN(entryUid, op.getEntryDN().getRDN().toString()) + "," + this.baseDn);
                msg.setParentUid(null);
                this.numUnresolvedNamingConflicts.incrementAndGet();
                return false;
            }
            RDN entryRdn = DN.decode(msg.getDn()).getRDN();
            msg.setDn(entryRdn + "," + parentDn);
            this.numResolvedNamingConflicts.incrementAndGet();
            return false;
        }
        if (result == ResultCode.ENTRY_ALREADY_EXISTS) {
            if (this.findEntryDN(entryUid) != null) {
                return true;
            }
            this.addConflict(msg);
            msg.setDn(this.generateConflictRDN(entryUid, msg.getDn()));
            this.numUnresolvedNamingConflicts.incrementAndGet();
            return false;
        }
        Message message = ReplicationMessages.ERR_ERROR_REPLAYING_OPERATION.get(op.toString(), ctx.getChangeNumber().toString(), result.toString(), op.getErrorMessage().toString());
        ErrorLogger.logError(message);
        return true;
    }

    private boolean findAndRenameChild(String entryUid, DN entryDN, Operation conflictOp) {
        boolean conflict = false;
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        DeleteContext ctx = (DeleteContext)conflictOp.getAttachment("replicationContext");
        ChangeNumber cn = null;
        if (ctx != null) {
            cn = ctx.getChangeNumber();
        }
        try {
            LinkedHashSet<String> attrs = new LinkedHashSet<String>(1);
            attrs.add("entryuuid");
            attrs.add("ds-sync-hist");
            SearchFilter ALLMATCH = SearchFilter.createFilterFromString("(objectClass=*)");
            InternalSearchOperation op = conn.processSearch(entryDN, SearchScope.SINGLE_LEVEL, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, ALLMATCH, attrs);
            if (op.getResultCode() == ResultCode.SUCCESS) {
                LinkedList<SearchResultEntry> entries = op.getSearchEntries();
                if (entries != null) {
                    for (SearchResultEntry entry : entries) {
                        Historical hist;
                        if (cn == null || !(hist = Historical.load(entry)).AddedOrRenamedAfter(cn)) continue;
                        conflict = true;
                        this.markConflictEntry(conflictOp, entry.getDN(), entryDN);
                        this.renameConflictEntry(conflictOp, entry.getDN(), Historical.getEntryUuid(entry));
                    }
                }
            } else {
                MessageBuilder mb = new MessageBuilder();
                mb.append(ReplicationMessages.ERR_CANNOT_RENAME_CONFLICT_ENTRY.get());
                mb.append(String.valueOf(entryDN));
                mb.append(" ");
                mb.append(String.valueOf(conflictOp));
                mb.append(" ");
                mb.append(String.valueOf((Object)op.getResultCode()));
                ErrorLogger.logError(mb.toMessage());
            }
        }
        catch (DirectoryException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_EXCEPTION_RENAME_CONFLICT_ENTRY.get());
            mb.append(String.valueOf(entryDN));
            mb.append(" ");
            mb.append(String.valueOf(conflictOp));
            mb.append(" ");
            mb.append(e.getLocalizedMessage());
            ErrorLogger.logError(mb.toMessage());
        }
        return conflict;
    }

    private void renameConflictEntry(Operation conflictOp, DN dn, String uid) {
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        ModifyDNOperation newOp = conn.processModifyDN(dn, this.generateDeleteConflictDn(uid, dn), false, this.baseDn);
        if (newOp.getResultCode() != ResultCode.SUCCESS) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_CANNOT_RENAME_CONFLICT_ENTRY.get());
            mb.append(String.valueOf(dn));
            mb.append(" ");
            mb.append(String.valueOf(conflictOp));
            mb.append(" ");
            mb.append(String.valueOf((Object)newOp.getResultCode()));
            ErrorLogger.logError(mb.toMessage());
        }
    }

    private void markConflictEntry(Operation op, DN currentDN, DN conflictDN) {
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        AttributeType attrType = DirectoryServer.getAttributeType(DS_SYNC_CONFLICT, true);
        Attribute attr = Attributes.create(attrType, AttributeValues.create(attrType, conflictDN.toString()));
        ArrayList<Modification> mods = new ArrayList<Modification>();
        Modification mod = new Modification(ModificationType.REPLACE, attr);
        mods.add(mod);
        ModifyOperation newOp = conn.processModify(currentDN, mods);
        if (newOp.getResultCode() != ResultCode.SUCCESS) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_CANNOT_ADD_CONFLICT_ATTRIBUTE.get());
            mb.append(String.valueOf(op));
            mb.append(" ");
            mb.append(String.valueOf((Object)newOp.getResultCode()));
            ErrorLogger.logError(mb.toMessage());
        }
        Message alertMessage = ReplicationMessages.NOTE_UNRESOLVED_CONFLICT.get(conflictDN.toString());
        DirectoryServer.sendAlertNotification(this, "org.opends.server.replication.UnresolvedConflict", alertMessage);
    }

    private void addConflict(AddMsg msg) throws ASN1Exception {
        Message alertMessage = ReplicationMessages.NOTE_UNRESOLVED_CONFLICT.get(msg.getDn());
        DirectoryServer.sendAlertNotification(this, "org.opends.server.replication.UnresolvedConflict", alertMessage);
        msg.addAttribute(DS_SYNC_CONFLICT, msg.getDn());
    }

    private String generateConflictRDN(String entryUid, String rdn) {
        return "entryuuid=" + entryUid + "+" + rdn;
    }

    private RDN generateDeleteConflictDn(String entryUid, DN dn) {
        String newRDN = "entryuuid=" + entryUid + "+" + dn.getRDN();
        RDN rdn = null;
        try {
            rdn = RDN.decode(newRDN);
        }
        catch (DirectoryException e) {
            // empty catch block
        }
        return rdn;
    }

    public int getNumResolvedModifyConflicts() {
        return this.numResolvedModifyConflicts.get();
    }

    public int getNumResolvedNamingConflicts() {
        return this.numResolvedNamingConflicts.get();
    }

    public int getNumUnresolvedNamingConflicts() {
        return this.numUnresolvedNamingConflicts.get();
    }

    public boolean solveConflict() {
        return this.solveConflictFlag;
    }

    public void disable() {
        this.state.save();
        this.state.clearInMemory();
        this.disabled = true;
        this.disableService();
    }

    protected void loadDataState() throws DirectoryException {
        Long compatGenId = null;
        this.state.clearInMemory();
        this.state.loadState();
        compatGenId = this.state.checkRUVCompat();
        this.generator.adjust(this.state.getMaxChangeNumber(this.serverId));
        if (compatGenId != null) {
            this.generationId = compatGenId;
            this.saveGenerationId(this.generationId);
        } else {
            this.generationId = this.loadGenerationId();
        }
    }

    public void enable() {
        try {
            this.loadDataState();
        }
        catch (Exception e) {
            ErrorLogger.logError(ReplicationMessages.ERR_LOADING_GENERATION_ID.get(this.baseDn.toNormalizedString(), e.getLocalizedMessage()));
            return;
        }
        this.enableService();
        this.disabled = false;
    }

    public long computeGenerationId() throws DirectoryException {
        long genId = this.exportBackend(null, true);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Computed generationId: generationId=" + genId);
        }
        return genId;
    }

    @Override
    public long getGenerationID() {
        return this.generationId;
    }

    public ResultCode saveGenerationId(long generationId) {
        ByteString asn1BaseDn = ByteString.valueOf(this.baseDn.toString());
        ArrayList<ByteString> values = new ArrayList<ByteString>();
        ByteString value = ByteString.valueOf(Long.toString(generationId));
        values.add(value);
        LDAPAttribute attr = new LDAPAttribute(REPLICATION_GENERATION_ID, values);
        LDAPModification mod = new LDAPModification(ModificationType.REPLACE, attr);
        ArrayList<RawModification> mods = new ArrayList<RawModification>(1);
        mods.add(mod);
        ModifyOperationBasis op = new ModifyOperationBasis((ClientConnection)this.conn, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), asn1BaseDn, mods);
        op.setInternalOperation(true);
        op.setSynchronizationOperation(true);
        op.setDontSynchronize(true);
        op.run();
        ResultCode result = op.getResultCode();
        if (result != ResultCode.SUCCESS) {
            this.generationIdSavedStatus = false;
            if (result != ResultCode.NO_SUCH_OBJECT) {
                Message message = ReplicationMessages.ERR_UPDATING_GENERATION_ID.get(op.getResultCode().getResultCodeName() + " " + op.getErrorMessage(), this.baseDn.toString());
                ErrorLogger.logError(message);
            }
        } else {
            this.generationIdSavedStatus = true;
        }
        return result;
    }

    public long loadGenerationId() throws DirectoryException {
        AttributeType synchronizationGenIDType;
        List<Attribute> attrs;
        LinkedList<SearchResultEntry> result;
        LDAPFilter filter;
        long generationId = -1L;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Attempt to read generation ID from DB " + this.baseDn.toString());
        }
        ByteString asn1BaseDn = ByteString.valueOf(this.baseDn.toString());
        boolean found = false;
        try {
            filter = LDAPFilter.decode("objectclass=*");
        }
        catch (LDAPException e) {
            return -1L;
        }
        InternalSearchOperation search = null;
        LinkedHashSet<String> attributes = new LinkedHashSet<String>(1);
        attributes.add(REPLICATION_GENERATION_ID);
        search = this.conn.processSearch(asn1BaseDn, SearchScope.BASE_OBJECT, DereferencePolicy.DEREF_ALWAYS, 0, 0, false, filter, attributes);
        if (search.getResultCode() != ResultCode.SUCCESS && search.getResultCode() != ResultCode.NO_SUCH_OBJECT) {
            Message message = ReplicationMessages.ERR_SEARCHING_GENERATION_ID.get(search.getResultCode().getResultCodeName() + " " + search.getErrorMessage(), this.baseDn.toString());
            ErrorLogger.logError(message);
        }
        SearchResultEntry resultEntry = null;
        if (search.getResultCode() == ResultCode.SUCCESS && (resultEntry = (result = search.getSearchEntries()).getFirst()) != null && (attrs = resultEntry.getAttribute(synchronizationGenIDType = DirectoryServer.getAttributeType(REPLICATION_GENERATION_ID))) != null) {
            Attribute attr = attrs.get(0);
            if (attr.size() > 1) {
                Message message = ReplicationMessages.ERR_LOADING_GENERATION_ID.get(this.baseDn.toString(), "#Values=" + attr.size() + " Must be exactly 1 in entry " + resultEntry.toLDIFString());
                ErrorLogger.logError(message);
            } else if (attr.size() == 1) {
                found = true;
                try {
                    generationId = Long.decode(((Object)attr.iterator().next()).toString());
                }
                catch (Exception e) {
                    Message message = ReplicationMessages.ERR_LOADING_GENERATION_ID.get(this.baseDn.toString(), e.getLocalizedMessage());
                    ErrorLogger.logError(message);
                }
            }
        }
        if (!found) {
            generationId = this.computeGenerationId();
            this.saveGenerationId(generationId);
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Generation ID created for domain base DN=" + this.baseDn.toString() + " generationId=" + generationId);
            }
        } else {
            this.generationIdSavedStatus = true;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Generation ID successfully read from domain base DN=" + this.baseDn + " generationId=" + generationId);
            }
        }
        return generationId;
    }

    public void backupStart() {
        this.state.save();
    }

    public void backupEnd() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearJEBackend(boolean createBaseEntry, String beID, String dn) throws Exception {
        BackendImpl backend = (BackendImpl)DirectoryServer.getBackend(beID);
        TaskUtils.disableBackend(beID);
        try {
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.acquireExclusiveLock(lockFile, failureReason)) {
                throw new RuntimeException(failureReason.toString());
            }
            try {
                backend.clearBackend();
            }
            finally {
                LockFileManager.releaseLock(lockFile, failureReason);
            }
        }
        finally {
            TaskUtils.enableBackend(beID);
        }
        if (createBaseEntry) {
            DN baseDN = DN.decode(dn);
            Entry e = StaticUtils.createEntry(baseDN);
            backend = (BackendImpl)DirectoryServer.getBackend(beID);
            backend.addEntry(e, null);
        }
    }

    @Override
    protected void exportBackend(OutputStream output) throws DirectoryException {
        this.exportBackend(output, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long exportBackend(OutputStream output, boolean checksumOutput) throws DirectoryException {
        OutputStream os;
        long genID = 0L;
        Backend backend = LDAPReplicationDomain.retrievesBackend(this.baseDn);
        long bec = backend.numSubordinates(this.baseDn, true) + 1L;
        long entryCount = bec < 1000L ? bec : 1000L;
        try {
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.acquireSharedLock(lockFile, failureReason)) {
                Message message = ToolMessages.ERR_LDIFEXPORT_CANNOT_LOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                ErrorLogger.logError(message);
                throw new DirectoryException(ResultCode.OTHER, message, null);
            }
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_LDIFEXPORT_CANNOT_LOCK_BACKEND.get(backend.getBackendID(), e.getLocalizedMessage());
            ErrorLogger.logError(message);
            throw new DirectoryException(ResultCode.OTHER, message, null);
        }
        ReplLDIFOutputStream ros = null;
        if (checksumOutput) {
            ros = new ReplLDIFOutputStream(this, entryCount);
            os = new CheckedOutputStream(ros, new GenerationIdChecksum());
            try {
                os.write(Long.toString(backend.numSubordinates(this.baseDn, true) + 1L).getBytes());
            }
            catch (Exception e) {}
        } else {
            os = output;
        }
        LDIFExportConfig exportConfig = new LDIFExportConfig(os);
        ArrayList<DN> includeBranches = new ArrayList<DN>(1);
        includeBranches.add(this.baseDn);
        exportConfig.setIncludeBranches(includeBranches);
        if (checksumOutput) {
            String[] includeAttributeStrings = new String[]{"objectclass", "sn", "cn", "entryuuid"};
            HashSet<AttributeType> includeAttributes = new HashSet<AttributeType>();
            for (String attrName : includeAttributeStrings) {
                AttributeType attrType = DirectoryServer.getAttributeType(attrName);
                if (attrType == null) {
                    attrType = DirectoryServer.getDefaultAttributeType(attrName);
                }
                includeAttributes.add(attrType);
            }
            exportConfig.setIncludeAttributes(includeAttributes);
        }
        try {
            Message message;
            try {
                backend.exportLDIF(exportConfig);
            }
            catch (DirectoryException de) {
                block22: {
                    block23: {
                        block21: {
                            if (ros == null || ros.getNumExportedEntries() < entryCount) break block21;
                            Object var22_25 = null;
                            exportConfig.close();
                            if (!checksumOutput) break block22;
                            break block23;
                        }
                        message = ToolMessages.ERR_LDIFEXPORT_ERROR_DURING_EXPORT.get(de.getMessageObject());
                        ErrorLogger.logError(message);
                        throw new DirectoryException(ResultCode.OTHER, message, null);
                    }
                    genID = ((CheckedOutputStream)os).getChecksum().getValue();
                }
                try {
                    String lockFile = LockFileManager.getBackendLockFileName(backend);
                    StringBuilder failureReason = new StringBuilder();
                    if (LockFileManager.releaseLock(lockFile, failureReason)) return genID;
                    Message message2 = ToolMessages.WARN_LDIFEXPORT_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                    ErrorLogger.logError(message2);
                    throw new DirectoryException(ResultCode.OTHER, message2, null);
                }
                catch (Exception e) {
                    Message message3 = ToolMessages.WARN_LDIFEXPORT_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(e));
                    ErrorLogger.logError(message3);
                    throw new DirectoryException(ResultCode.OTHER, message3, null);
                }
            }
            catch (Exception e) {
                message = ToolMessages.ERR_LDIFEXPORT_ERROR_DURING_EXPORT.get(StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                throw new DirectoryException(ResultCode.OTHER, message, null);
            }
            Object var22_24 = null;
            exportConfig.close();
            if (checksumOutput) {
                genID = ((CheckedOutputStream)os).getChecksum().getValue();
            }
        }
        catch (Throwable throwable) {
            Object var22_26 = null;
            exportConfig.close();
            if (checksumOutput) {
                genID = ((CheckedOutputStream)os).getChecksum().getValue();
            }
            try {}
            catch (Exception e) {
                Message message3 = ToolMessages.WARN_LDIFEXPORT_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message3);
                throw new DirectoryException(ResultCode.OTHER, message3, null);
            }
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (LockFileManager.releaseLock(lockFile, failureReason)) throw throwable;
            Message message2 = ToolMessages.WARN_LDIFEXPORT_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
            ErrorLogger.logError(message2);
            throw new DirectoryException(ResultCode.OTHER, message2, null);
        }
        try {}
        catch (Exception e) {
            Message message3 = ToolMessages.WARN_LDIFEXPORT_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message3);
            throw new DirectoryException(ResultCode.OTHER, message3, null);
        }
        String lockFile = LockFileManager.getBackendLockFileName(backend);
        StringBuilder failureReason = new StringBuilder();
        if (LockFileManager.releaseLock(lockFile, failureReason)) return genID;
        Message message2 = ToolMessages.WARN_LDIFEXPORT_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
        ErrorLogger.logError(message2);
        throw new DirectoryException(ResultCode.OTHER, message2, null);
    }

    protected static Backend retrievesBackend(DN baseDn) {
        return DirectoryServer.getBackend(baseDn);
    }

    private void preBackendImport(Backend backend) throws Exception {
        this.stateSavingDisabled = true;
        TaskUtils.disableBackend(backend.getBackendID());
        String lockFile = LockFileManager.getBackendLockFileName(backend);
        StringBuilder failureReason = new StringBuilder();
        if (!LockFileManager.acquireExclusiveLock(lockFile, failureReason)) {
            Message message = ReplicationMessages.ERR_INIT_CANNOT_LOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
            ErrorLogger.logError(message);
            throw new DirectoryException(ResultCode.OTHER, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importBackend(InputStream input) throws DirectoryException {
        LDIFImportConfig importConfig = null;
        DirectoryException de = null;
        Backend backend = LDAPReplicationDomain.retrievesBackend(this.baseDn);
        try {
            if (!backend.supportsLDIFImport()) {
                Message message = ReplicationMessages.ERR_INIT_IMPORT_NOT_SUPPORTED.get(backend.getBackendID().toString());
                ErrorLogger.logError(message);
                de = new DirectoryException(ResultCode.OTHER, message);
            } else {
                importConfig = new LDIFImportConfig(input);
                ArrayList<DN> includeBranches = new ArrayList<DN>();
                includeBranches.add(this.baseDn);
                importConfig.setIncludeBranches(includeBranches);
                importConfig.setAppendToExistingData(false);
                importConfig.setSkipDNValidation(true);
                importConfig.setInvokeImportPlugins(true);
                this.importErrorMessageId = -1;
                this.followImport = true;
                importConfig.writeRejectedEntries(StaticUtils.getFileForPath("logs" + File.separator + "replInitRejectedEntries").getAbsolutePath(), ExistingFileBehavior.OVERWRITE);
                this.preBackendImport(backend);
                backend.importLDIF(importConfig);
                this.stateSavingDisabled = false;
            }
        }
        catch (Exception e) {
            de = new DirectoryException(ResultCode.OTHER, Message.raw(e.getLocalizedMessage(), new Object[0]));
        }
        finally {
            block17: {
                if (importConfig != null) {
                    importConfig.close();
                    this.closeBackendImport(backend);
                    backend = LDAPReplicationDomain.retrievesBackend(this.baseDn);
                }
                try {
                    this.loadDataState();
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("After import, the replication plugin restarts connections to all RSs to provide new generation ID=" + this.generationId);
                    }
                }
                catch (DirectoryException fe) {
                    if (de != null) break block17;
                    de = fe;
                }
            }
        }
        if (de != null) {
            throw de;
        }
    }

    protected void closeBackendImport(Backend backend) throws DirectoryException {
        StringBuilder failureReason;
        String lockFile = LockFileManager.getBackendLockFileName(backend);
        if (!LockFileManager.releaseLock(lockFile, failureReason = new StringBuilder())) {
            Message message = ToolMessages.WARN_LDIFIMPORT_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
            ErrorLogger.logError(message);
            throw new DirectoryException(ResultCode.OTHER, message);
        }
        TaskUtils.enableBackend(backend.getBackendID());
    }

    public static LDAPReplicationDomain retrievesReplicationDomain(DN baseDn) throws DirectoryException {
        LDAPReplicationDomain replicationDomain = null;
        DirectoryServer.getSynchronizationProviders();
        for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
            if (!(provider instanceof MultimasterReplication)) {
                Message message = ReplicationMessages.ERR_INVALID_PROVIDER.get();
                throw new DirectoryException(ResultCode.OTHER, message);
            }
            LDAPReplicationDomain sdomain = MultimasterReplication.findDomain(baseDn, null);
            if (sdomain == null) break;
            if (replicationDomain != null) {
                Message message = ReplicationMessages.ERR_MULTIPLE_MATCHING_DOMAIN.get();
                throw new DirectoryException(ResultCode.OTHER, message);
            }
            replicationDomain = sdomain;
        }
        if (replicationDomain == null) {
            throw new DirectoryException(ResultCode.OTHER, ReplicationMessages.ERR_NO_MATCHING_DOMAIN.get(String.valueOf(baseDn)));
        }
        return replicationDomain;
    }

    public Backend getBackend() {
        return LDAPReplicationDomain.retrievesBackend(this.baseDn);
    }

    public void synchronizeModifications(List<Modification> modifications) {
        ModifyOperationBasis opBasis = new ModifyOperationBasis((ClientConnection)InternalClientConnection.getRootConnection(), InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), null, DirectoryServer.getSchemaDN(), modifications);
        LocalBackendModifyOperation op = new LocalBackendModifyOperation(opBasis);
        ChangeNumber cn = this.generateChangeNumber(op);
        ModifyContext ctx = new ModifyContext(cn, "schema");
        op.setAttachment("replicationContext", ctx);
        op.setResultCode(ResultCode.SUCCESS);
        this.synchronize(op);
    }

    public static boolean isConfigurationAcceptable(ReplicationDomainCfg configuration, List<Message> unacceptableReasons) {
        DN dn = configuration.getBaseDN();
        LDAPReplicationDomain domain = MultimasterReplication.findDomain(dn, null);
        if (domain != null && domain.baseDn.equals(dn)) {
            Message message = ReplicationMessages.ERR_SYNC_INVALID_DN.get();
            unacceptableReasons.add(message);
            return false;
        }
        if (LDAPReplicationDomain.retrievesBackend(dn) == null) {
            Message message = ReplicationMessages.ERR_UNKNOWN_DN.get(dn.toString());
            unacceptableReasons.add(message);
            return false;
        }
        try {
            LDAPReplicationDomain.isFractionalConfigAcceptable(configuration);
        }
        catch (ConfigException e) {
            unacceptableReasons.add(e.getMessageObject());
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(ReplicationDomainCfg configuration) {
        this.isolationpolicy = configuration.getIsolationPolicy();
        this.changeConfig(configuration.getReplicationServer(), configuration.getWindowSize(), configuration.getHeartbeatInterval(), (byte)configuration.getGroupId());
        this.readAssuredConfig(configuration, true);
        this.readFractionalConfig(configuration, true);
        this.solveConflictFlag = this.baseDn.compareTo(DirectoryServer.getSchemaDN()) == 0 ? false : configuration.isSolveConflicts();
        try {
            this.createECLDomainCfg(configuration);
        }
        catch (Exception e) {
            return new ConfigChangeResult(ResultCode.OTHER, false);
        }
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(ReplicationDomainCfg configuration, List<Message> unacceptableReasons) {
        if (this.importInProgress() || this.exportInProgress()) {
            unacceptableReasons.add(ReplicationMessages.NOTE_ERR_CANNOT_CHANGE_CONFIG_DURING_TOTAL_UPDATE.get());
            return false;
        }
        try {
            LDAPReplicationDomain.isFractionalConfigAcceptable(configuration);
        }
        catch (ConfigException e) {
            unacceptableReasons.add(e.getMessageObject());
            return false;
        }
        return true;
    }

    @Override
    public LinkedHashMap<String, String> getAlerts() {
        LinkedHashMap<String, String> alerts = new LinkedHashMap<String, String>();
        alerts.put("org.opends.server.replication.UnresolvedConflict", "This alert type will be used to notify administrators if the  multimaster replication cannot resolve automatically a conflict.");
        return alerts;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public DN getComponentEntryDN() {
        return this.configDn;
    }

    public void start() {
        this.flushThread = new ServerStateFlush();
        this.flushThread.start();
        this.startListenService();
    }

    public void removeECLDomainCfg() {
        try {
            DN eclConfigEntryDN = DN.decode("cn=external changeLog," + this.configDn);
            if (DirectoryServer.getConfigHandler().entryExists(eclConfigEntryDN)) {
                DirectoryServer.getConfigHandler().deleteEntry(eclConfigEntryDN, null);
            }
        }
        catch (Exception e) {
            TRACER.debugCaught(DebugLogLevel.ERROR, e);
            MessageBuilder mb = new MessageBuilder();
            mb.append(e.getMessage());
            Message msg = ReplicationMessages.ERR_CHECK_CREATE_REPL_BACKEND_FAILED.get(mb.toString());
            ErrorLogger.logError(msg);
        }
    }

    public void createECLDomainCfg(ReplicationDomainCfg configuration) throws ConfigException {
        try {
            ExternalChangelogDomainCfg eclDomCfg = null;
            if (DirectoryServer.getConfigHandler().entryExists(this.configDn)) {
                try {
                    eclDomCfg = configuration.getExternalChangelogDomain();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (eclDomCfg == null) {
                    DN eclConfigEntryDN = DN.decode("cn=external changelog," + this.configDn);
                    if (!DirectoryServer.getConfigHandler().entryExists(eclConfigEntryDN)) {
                        String ldif = LDAPReplicationDomain.makeLdif("dn: cn=external changelog," + this.configDn, "objectClass: top", "objectClass: ds-cfg-external-changelog-domain", "cn: external changelog", "ds-cfg-enabled: " + !this.getBackend().isPrivateBackend());
                        LDIFImportConfig ldifImportConfig = new LDIFImportConfig(new StringReader(ldif));
                        LDIFReader reader = new LDIFReader(ldifImportConfig);
                        Entry eclEntry = reader.readEntry();
                        DirectoryServer.getConfigHandler().addEntry(eclEntry, null);
                        ldifImportConfig.close();
                    }
                }
            }
            eclDomCfg = configuration.getExternalChangelogDomain();
            this.eclDomain = new ExternalChangelogDomain(this, eclDomCfg);
        }
        catch (Exception de) {
            throw new ConfigException(ReplicationMessages.NOTE_ERR_UNABLE_TO_ENABLE_ECL.get("Replication Domain on" + this.baseDn, de.getMessage() + " " + de.getCause().getMessage()), (Throwable)de);
        }
    }

    private static String makeLdif(String ... lines) {
        StringBuilder buffer = new StringBuilder();
        for (String line : lines) {
            buffer.append(line).append(ServerConstants.EOL);
        }
        buffer.append(ServerConstants.EOL);
        return buffer.toString();
    }

    @Override
    public void sessionInitiated(ServerStatus initStatus, ServerState replicationServerState, long generationID, ProtocolSession session) {
        Message message;
        this.force_bad_data_set = !this.isBackendFractionalConfigConsistent();
        super.sessionInitiated(initStatus, replicationServerState, generationID, session);
        if (!this.getBackend().isPrivateBackend()) {
            try {
                ECLWorkflowElement wfe = (ECLWorkflowElement)DirectoryServer.getWorkflowElement("EXTERNAL CHANGE LOG");
                if (wfe != null) {
                    wfe.getReplicationServer().enableECL();
                }
            }
            catch (DirectoryException de) {
                message = ReplicationMessages.NOTE_ERR_UNABLE_TO_ENABLE_ECL.get("Replication Domain on" + this.baseDn, de.getMessage() + " " + de.getCause().getMessage());
                ErrorLogger.logError(message);
            }
        }
        if (this.force_bad_data_set) {
            this.setNewStatus(StatusMachineEvent.TO_BAD_GEN_ID_STATUS_EVENT);
            this.broker.signalStatusChange(this.status);
            Message message2 = ReplicationMessages.NOTE_FRACTIONAL_BAD_DATA_SET_NEED_RESYNC.get(this.baseDn.toString());
            ErrorLogger.logError(message2);
            return;
        }
        try {
            ChangeNumber ourMaxChangeNumber;
            ChangeNumber replServerMaxChangeNumber = replicationServerState.getMaxChangeNumber(this.serverId);
            if (replServerMaxChangeNumber != null && replServerMaxChangeNumber.getSeqnum() != 0 && (ourMaxChangeNumber = this.state.getMaxChangeNumber(this.serverId)) != null && !ourMaxChangeNumber.olderOrEqual(replServerMaxChangeNumber).booleanValue()) {
                this.pendingChanges.setRecovering(true);
                this.broker.setRecoveryRequired(true);
                new RSUpdater(replServerMaxChangeNumber).start();
            }
        }
        catch (Exception e) {
            message = ReplicationMessages.ERR_PUBLISHING_FAKE_OPS.get(this.baseDn.toNormalizedString(), e.getLocalizedMessage() + StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buildAndPublishMissingChanges(ChangeNumber startingChangeNumber, ReplicationBroker session) throws Exception {
        InternalSearchOperation op;
        TreeMap<ChangeNumber, FakeOperation> treeMap = this.replayOperations;
        synchronized (treeMap) {
            Iterator<ChangeNumber> it = this.replayOperations.keySet().iterator();
            while (it.hasNext() && it.next().olderOrEqual(startingChangeNumber).booleanValue()) {
                it.remove();
            }
        }
        ChangeNumber lastRetrievedChange = null;
        ChangeNumber currentStartChangeNumber = startingChangeNumber;
        do {
            lastRetrievedChange = null;
            long missingChangesDelta = currentStartChangeNumber.getTime() + 10000L;
            ChangeNumber endChangeNumber = new ChangeNumber(missingChangesDelta, -1, this.serverId);
            ScanSearchListener listener = new ScanSearchListener(currentStartChangeNumber, endChangeNumber);
            op = LDAPReplicationDomain.searchForChangedEntries(this.baseDn, currentStartChangeNumber, endChangeNumber, listener);
            LinkedList<FakeOperation> opsToSend = new LinkedList<FakeOperation>();
            TreeMap<ChangeNumber, FakeOperation> treeMap2 = this.replayOperations;
            synchronized (treeMap2) {
                FakeOperation fakeOp;
                Iterator<FakeOperation> itOp = this.replayOperations.values().iterator();
                while (itOp.hasNext() && (fakeOp = itOp.next()).getChangeNumber().olderOrEqual(endChangeNumber).booleanValue() && this.state.cover(fakeOp.getChangeNumber())) {
                    lastRetrievedChange = fakeOp.getChangeNumber();
                    opsToSend.add(fakeOp);
                    itOp.remove();
                }
            }
            for (FakeOperation opToSend : opsToSend) {
                session.publishRecovery(opToSend.generateMessage());
            }
            opsToSend.clear();
            currentStartChangeNumber = lastRetrievedChange != null ? lastRetrievedChange : endChangeNumber;
        } while (this.pendingChanges.RecoveryUntil(lastRetrievedChange) && op.getResultCode().equals((Object)ResultCode.SUCCESS));
        return op.getResultCode().equals((Object)ResultCode.SUCCESS);
    }

    public static InternalSearchOperation searchForChangedEntries(DN baseDn, ChangeNumber fromChangeNumber, ChangeNumber lastChangeNumber, InternalSearchListener resultListener) throws Exception {
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        Integer serverId = fromChangeNumber.getServerId();
        String maxValueForId = lastChangeNumber == null ? "ffffffffffffffff" + String.format("%04x", serverId) + "ffffffff" : lastChangeNumber.toString();
        LDAPFilter filter = LDAPFilter.decode("(&(ds-sync-hist>=dummy:" + fromChangeNumber + ")(" + "ds-sync-hist" + "<=dummy:" + maxValueForId + "))");
        LinkedHashSet<String> attrs = new LinkedHashSet<String>(1);
        attrs.add("ds-sync-hist");
        attrs.add("entryuuid");
        attrs.add("*");
        return conn.processSearch(ByteString.valueOf(baseDn.toString()), SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, filter, attrs, resultListener);
    }

    public static InternalSearchOperation searchForChangedEntries(DN baseDn, ChangeNumber fromChangeNumber, InternalSearchListener resultListener) throws Exception {
        return LDAPReplicationDomain.searchForChangedEntries(baseDn, fromChangeNumber, null, resultListener);
    }

    @Override
    public long countEntries() throws DirectoryException {
        Backend backend = LDAPReplicationDomain.retrievesBackend(this.baseDn);
        if (!backend.supportsLDIFExport()) {
            Message message = ReplicationMessages.ERR_INIT_EXPORT_NOT_SUPPORTED.get(backend.getBackendID().toString());
            ErrorLogger.logError(message);
            throw new DirectoryException(ResultCode.OTHER, message);
        }
        return backend.numSubordinates(this.baseDn, true) + 1L;
    }

    @Override
    public boolean processUpdate(UpdateMsg updateMsg) {
        if (this.force_bad_data_set) {
            return false;
        }
        if (updateMsg instanceof LDAPUpdateMsg) {
            LDAPUpdateMsg msg = (LDAPUpdateMsg)updateMsg;
            this.remotePendingChanges.putRemoteUpdate(msg);
            UpdateToReplay updateToReplay = new UpdateToReplay(msg, this);
            this.updateToReplayQueue.offer(updateToReplay);
            return false;
        }
        return true;
    }

    @Override
    public Collection<Attribute> getAdditionalMonitoring() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        ReplicationMonitor.addMonitorData(attributes, "pending-updates", this.getPendingUpdatesCount());
        ReplicationMonitor.addMonitorData(attributes, "replayed-updates-ok", this.getNumReplayedPostOpCalled());
        ReplicationMonitor.addMonitorData(attributes, "resolved-modify-conflicts", this.getNumResolvedModifyConflicts());
        ReplicationMonitor.addMonitorData(attributes, "resolved-naming-conflicts", this.getNumResolvedNamingConflicts());
        ReplicationMonitor.addMonitorData(attributes, "unresolved-naming-conflicts", this.getNumUnresolvedNamingConflicts());
        ReplicationMonitor.addMonitorData(attributes, "remote-pending-changes-size", this.remotePendingChanges.getQueueSize());
        return attributes;
    }

    public int decodeSource(String sourceString) throws DirectoryException {
        int source = 0;
        Exception cause = null;
        try {
            source = Integer.decode(sourceString);
            if (source >= -1 && source != this.serverId) {
                return source;
            }
        }
        catch (Exception e) {
            cause = e;
        }
        ResultCode resultCode = ResultCode.OTHER;
        Message message = ReplicationMessages.ERR_INVALID_IMPORT_SOURCE.get();
        if (cause != null) {
            throw new DirectoryException(resultCode, message, cause);
        }
        throw new DirectoryException(resultCode, message);
    }

    private void addEntryAttributesForCL(UpdateMsg msg, PostOperationOperation op) throws DirectoryException {
        String[] entryAttributeNames = this.getEclInclude().toArray(new String[0]);
        ArrayList<Attribute> newattrs = new ArrayList<Attribute>();
        if (op instanceof PostOperationDeleteOperation) {
            Iterator<Attribute> i$;
            Entry entry = null;
            PostOperationDeleteOperation delOp = (PostOperationDeleteOperation)op;
            entry = delOp.getEntryToDelete();
            for (String name : entryAttributeNames) {
                AttributeType atype = DirectoryServer.getAttributeType(name);
                List<Attribute> attrs = entry.getAttribute(atype);
                if (attrs == null) continue;
                for (Attribute a : attrs) {
                    newattrs.add(a);
                }
            }
            ((DeleteMsg)msg).setEclIncludes(newattrs);
            AttributeType atype = DirectoryServer.getAttributeType("modifiersname");
            List<Attribute> attrs = entry.getAttribute(atype);
            if (attrs != null && (i$ = attrs.iterator()).hasNext()) {
                Attribute a = i$.next();
                ((DeleteMsg)msg).setInitiatorsName(((Object)a.iterator().next()).toString());
            }
        } else if (op instanceof PostOperationModifyOperation) {
            Entry entry = null;
            PostOperationModifyOperation modOp = (PostOperationModifyOperation)op;
            entry = modOp.getCurrentEntry();
            for (String name : entryAttributeNames) {
                AttributeType atype = DirectoryServer.getAttributeType(name);
                List<Attribute> attrs = entry.getAttribute(atype);
                for (Attribute a : attrs) {
                    newattrs.add(a);
                }
            }
            ((ModifyMsg)msg).setEclIncludes(newattrs);
        } else if (op instanceof PostOperationModifyDNOperation) {
            Entry entry = null;
            PostOperationModifyDNOperation modDNOp = (PostOperationModifyDNOperation)op;
            entry = modDNOp.getOriginalEntry();
            for (String name : entryAttributeNames) {
                AttributeType atype = DirectoryServer.getAttributeType(name);
                List<Attribute> attrs = entry.getAttribute(atype);
                for (Attribute a : attrs) {
                    newattrs.add(a);
                }
            }
            ((ModifyDNMsg)msg).setEclIncludes(newattrs);
        } else if (op instanceof PostOperationAddOperation) {
            Entry entry = null;
            PostOperationAddOperation addOp = (PostOperationAddOperation)op;
            entry = addOp.getEntryToAdd();
            for (String name : entryAttributeNames) {
                AttributeType atype = DirectoryServer.getAttributeType(name);
                List<Attribute> attrs = entry.getAttribute(atype);
                if (attrs == null) continue;
                for (Attribute a : attrs) {
                    newattrs.add(a);
                }
            }
            ((AddMsg)msg).setEclIncludes(newattrs);
        }
    }

    FractionalConfig getFractionalConfig() {
        return this.fractionalConfig;
    }

    public boolean isECLEnabled() {
        return this.eclDomain.isEnabled();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FractionalConfig {
        private boolean fractional = false;
        private boolean fractionalExclusive = true;
        private Map<String, List<String>> fractionalSpecificClassesAttributes = new HashMap<String, List<String>>();
        private List<String> fractionalAllClassesAttributes = new ArrayList<String>();
        private DN baseDn = null;
        static final int NOT_FRACTIONAL = 0;
        static final int EXCLUSIVE_FRACTIONAL = 1;
        static final int INCLUSIVE_FRACTIONAL = 2;

        FractionalConfig(DN baseDn) {
            this.baseDn = baseDn;
        }

        boolean isFractional() {
            return this.fractional;
        }

        void setFractional(boolean fractional) {
            this.fractional = fractional;
        }

        boolean isFractionalExclusive() {
            return this.fractionalExclusive;
        }

        void setFractionalExclusive(boolean fractionalExclusive) {
            this.fractionalExclusive = fractionalExclusive;
        }

        Map<String, List<String>> getFractionalSpecificClassesAttributes() {
            return this.fractionalSpecificClassesAttributes;
        }

        void setFractionalSpecificClassesAttributes(Map<String, List<String>> fractionalSpecificClassesAttributes) {
            this.fractionalSpecificClassesAttributes = fractionalSpecificClassesAttributes;
        }

        List<String> getFractionalAllClassesAttributes() {
            return this.fractionalAllClassesAttributes;
        }

        void setFractionalAllClassesAttributes(List<String> fractionalAllClassesAttributes) {
            this.fractionalAllClassesAttributes = fractionalAllClassesAttributes;
        }

        DN getBaseDn() {
            return this.baseDn;
        }

        static FractionalConfig toFractionalConfig(ReplicationDomainCfg configuration) throws ConfigException {
            Iterator<String> exclIt = null;
            SortedSet<String> fractionalExclude = configuration.getFractionalExclude();
            if (fractionalExclude != null) {
                exclIt = fractionalExclude.iterator();
            }
            Iterator<String> inclIt = null;
            SortedSet<String> fractionalInclude = configuration.getFractionalInclude();
            if (fractionalInclude != null) {
                inclIt = fractionalInclude.iterator();
            }
            HashMap<String, List<String>> newFractionalSpecificClassesAttributes = new HashMap<String, List<String>>();
            ArrayList<String> newFractionalAllClassesAttributes = new ArrayList<String>();
            int newFractionalMode = FractionalConfig.parseFractionalConfig(exclIt, inclIt, newFractionalSpecificClassesAttributes, newFractionalAllClassesAttributes);
            FractionalConfig result = new FractionalConfig(configuration.getBaseDN());
            switch (newFractionalMode) {
                case 0: {
                    result.setFractional(false);
                    result.setFractionalExclusive(true);
                    break;
                }
                case 1: 
                case 2: {
                    result.setFractional(true);
                    if (newFractionalMode == 1) {
                        result.setFractionalExclusive(true);
                        break;
                    }
                    result.setFractionalExclusive(false);
                }
            }
            result.setFractionalSpecificClassesAttributes(newFractionalSpecificClassesAttributes);
            result.setFractionalAllClassesAttributes(newFractionalAllClassesAttributes);
            return result;
        }

        private static int parseFractionalConfig(Iterator<String> exclIt, Iterator<String> inclIt, Map<String, List<String>> fractionalSpecificClassesAttributes, List<String> fractionalAllClassesAttributes) throws ConfigException {
            int fractional_mode = 0;
            Iterator<String> fracConfIt = null;
            if (exclIt != null && exclIt.hasNext()) {
                if (inclIt != null && inclIt.hasNext()) {
                    throw new ConfigException(ReplicationMessages.NOTE_ERR_FRACTIONAL_CONFIG_BOTH_MODES.get());
                }
                fractional_mode = 1;
                fracConfIt = exclIt;
            } else if (inclIt != null && inclIt.hasNext()) {
                fractional_mode = 2;
                fracConfIt = inclIt;
            } else {
                return 0;
            }
            while (fracConfIt.hasNext()) {
                String fractCfgStr = fracConfIt.next();
                StringTokenizer st = new StringTokenizer(fractCfgStr, ":");
                int nTokens = st.countTokens();
                if (nTokens < 2) {
                    throw new ConfigException(ReplicationMessages.NOTE_ERR_FRACTIONAL_CONFIG_WRONG_FORMAT.get(fractCfgStr));
                }
                String classNameLower = st.nextToken().toLowerCase();
                boolean allClasses = classNameLower.equals("*");
                String attributes = st.nextToken();
                st = new StringTokenizer(attributes, ",");
                while (st.hasMoreTokens()) {
                    String attrNameLower = st.nextToken().toLowerCase();
                    if (allClasses) {
                        if (fractionalAllClassesAttributes.contains(attrNameLower)) continue;
                        fractionalAllClassesAttributes.add(attrNameLower);
                        continue;
                    }
                    List<String> attrList = fractionalSpecificClassesAttributes.get(classNameLower);
                    if (attrList != null) {
                        if (attrList.contains(attrNameLower)) continue;
                        attrList.add(attrNameLower);
                        continue;
                    }
                    attrList = new ArrayList<String>();
                    attrList.add(attrNameLower);
                    fractionalSpecificClassesAttributes.put(classNameLower, attrList);
                }
            }
            return fractional_mode;
        }

        int fractionalConfigToInt() {
            int fractionalMode = -1;
            fractionalMode = this.fractional ? (this.fractionalExclusive ? 1 : 2) : 0;
            return fractionalMode;
        }

        static boolean isFractionalConfigEquivalent(FractionalConfig fractionalConfig1, FractionalConfig fractionalConfig2) throws ConfigException {
            List<String> allClassesAttributes2;
            if (!fractionalConfig1.getBaseDn().equals(fractionalConfig2.getBaseDn())) {
                return false;
            }
            if (fractionalConfig1.isFractional() != fractionalConfig2.isFractional() || fractionalConfig1.isFractionalExclusive() != fractionalConfig2.isFractionalExclusive()) {
                return false;
            }
            List<String> allClassesAttributes1 = fractionalConfig1.getFractionalAllClassesAttributes();
            if (!LDAPReplicationDomain.isAttributeListEquivalent(allClassesAttributes1, allClassesAttributes2 = fractionalConfig2.getFractionalAllClassesAttributes())) {
                return false;
            }
            Map<String, List<String>> specificClassesAttributes1 = fractionalConfig1.getFractionalSpecificClassesAttributes();
            Map<String, List<String>> specificClassesAttributes2 = fractionalConfig2.getFractionalSpecificClassesAttributes();
            if (specificClassesAttributes1.size() != specificClassesAttributes2.size()) {
                return false;
            }
            Schema schema = DirectoryServer.getSchema();
            for (String className1 : specificClassesAttributes1.keySet()) {
                ObjectClass objectClass1 = schema.getObjectClass(className1);
                if (objectClass1 == null) {
                    throw new ConfigException(ReplicationMessages.NOTE_ERR_FRACTIONAL_CONFIG_UNKNOWN_OBJECT_CLASS.get(className1));
                }
                boolean foundClass = false;
                for (String className2 : specificClassesAttributes2.keySet()) {
                    List<String> attributes2;
                    ObjectClass objectClass2 = schema.getObjectClass(className2);
                    if (objectClass2 == null) {
                        throw new ConfigException(ReplicationMessages.NOTE_ERR_FRACTIONAL_CONFIG_UNKNOWN_OBJECT_CLASS.get(className2));
                    }
                    if (!objectClass1.equals(objectClass2)) continue;
                    foundClass = true;
                    List<String> attributes1 = specificClassesAttributes1.get(className1);
                    if (LDAPReplicationDomain.isAttributeListEquivalent(attributes1, attributes2 = specificClassesAttributes2.get(className2))) break;
                    return false;
                }
                if (foundClass) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttributeValueStringIterator
    implements Iterator<String> {
        private Iterator<AttributeValue> attrValIt = null;

        public AttributeValueStringIterator(Iterator<AttributeValue> attrValIt) {
            this.attrValIt = attrValIt;
        }

        @Override
        public boolean hasNext() {
            return this.attrValIt.hasNext();
        }

        @Override
        public String next() {
            return this.attrValIt.next().getValue().toString();
        }

        @Override
        public void remove() {
            this.attrValIt.remove();
        }
    }

    private class RSUpdater
    extends DirectoryThread {
        private ChangeNumber startChangeNumber;

        protected RSUpdater(ChangeNumber replServerMaxChangeNumber) {
            super("Replication Server Updater for server id " + LDAPReplicationDomain.this.serverId + " and domain " + LDAPReplicationDomain.this.baseDn.toString());
            this.startChangeNumber = replServerMaxChangeNumber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block9: {
                Message message = ReplicationMessages.DEBUG_GOING_TO_SEARCH_FOR_CHANGES.get();
                ErrorLogger.logError(message);
                try {
                    if (LDAPReplicationDomain.this.buildAndPublishMissingChanges(this.startChangeNumber, LDAPReplicationDomain.this.broker)) {
                        message = ReplicationMessages.DEBUG_CHANGES_SENT.get();
                        ErrorLogger.logError(message);
                        TreeMap treeMap = LDAPReplicationDomain.this.replayOperations;
                        synchronized (treeMap) {
                            LDAPReplicationDomain.this.replayOperations.clear();
                            break block9;
                        }
                    }
                    message = ReplicationMessages.ERR_CANNOT_RECOVER_CHANGES.get(LDAPReplicationDomain.this.baseDn.toNormalizedString());
                    ErrorLogger.logError(message);
                }
                catch (Exception e) {
                    message = ReplicationMessages.ERR_CANNOT_RECOVER_CHANGES.get(LDAPReplicationDomain.this.baseDn.toNormalizedString());
                    ErrorLogger.logError(message);
                }
                finally {
                    LDAPReplicationDomain.this.broker.setRecoveryRequired(false);
                }
            }
        }
    }

    private class ServerStateFlush
    extends DirectoryThread {
        protected ServerStateFlush() {
            super("Replication State Saver for server id " + LDAPReplicationDomain.this.serverId + " and domain " + LDAPReplicationDomain.this.baseDn.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LDAPReplicationDomain.this.done = false;
            while (!LDAPReplicationDomain.this.shutdown) {
                try {
                    ServerStateFlush serverStateFlush = this;
                    synchronized (serverStateFlush) {
                        this.wait(1000L);
                        if (!LDAPReplicationDomain.this.disabled && !LDAPReplicationDomain.this.stateSavingDisabled) {
                            LDAPReplicationDomain.this.state.save();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            LDAPReplicationDomain.this.state.save();
            LDAPReplicationDomain.this.done = true;
        }
    }

    private class ScanSearchListener
    implements InternalSearchListener {
        private ChangeNumber startingChangeNumber = null;
        private ChangeNumber endChangeNumber = null;

        public ScanSearchListener(ChangeNumber startingChangeNumber, ChangeNumber endChangeNumber) {
            this.startingChangeNumber = startingChangeNumber;
            this.endChangeNumber = endChangeNumber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleInternalSearchEntry(InternalSearchOperation searchOperation, SearchResultEntry searchEntry) throws DirectoryException {
            Iterable<FakeOperation> updates = Historical.generateFakeOperations(searchEntry);
            for (FakeOperation op : updates) {
                ChangeNumber cn = op.getChangeNumber();
                if (!cn.newer(this.startingChangeNumber) || !cn.older(this.endChangeNumber).booleanValue()) continue;
                TreeMap treeMap = LDAPReplicationDomain.this.replayOperations;
                synchronized (treeMap) {
                    LDAPReplicationDomain.this.replayOperations.put(cn, op);
                }
            }
        }

        public void handleInternalSearchReference(InternalSearchOperation searchOperation, SearchResultReference searchReference) throws DirectoryException {
        }
    }
}

