/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.util.Collection;
import java.util.Collections;
import org.opends.server.api.AbstractMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.replication.plugin.MultimasterReplication;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoricalCsnOrderingMatchingRule
extends AbstractMatchingRule
implements OrderingMatchingRule {
    private static final long serialVersionUID = -3424403930225609943L;

    @Override
    public int compareValues(ByteSequence value1, ByteSequence value2) {
        String[] token1 = ((Object)value1).toString().split(":", 3);
        String[] token2 = ((Object)value2).toString().split(":", 3);
        if (token1[1] == null || token2[1] == null) {
            return -1;
        }
        return token1[1].compareTo(token2[1]);
    }

    @Override
    public Collection<String> getAllNames() {
        return Collections.singleton(this.getName());
    }

    @Override
    public String getName() {
        return "historicalCsnOrderingMatch";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.26027.1.4.4";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getSyntaxOID() {
        return "1.3.6.1.4.1.26027.1.3.5";
    }

    @Override
    public ByteString normalizeValue(ByteSequence value) {
        String[] token = ((Object)value).toString().split(":", 3);
        String timestamp = token[1].substring(0, 16);
        String serverId = token[1].substring(16, 20);
        String seqNumber = token[1].substring(20, 28);
        if (MultimasterReplication.isLocalServerId(Integer.parseInt(serverId, 16))) {
            return ByteString.valueOf(serverId + timestamp + seqNumber);
        }
        return ByteString.valueOf("0");
    }

    @Override
    public int compare(byte[] b1, byte[] b2) {
        int minLength = Math.min(b1.length, b2.length);
        for (int i = 0; i < minLength; ++i) {
            if (b1[i] == b2[i]) continue;
            if (b1[i] < b2[i]) {
                return -1;
            }
            if (b1[i] <= b2[i]) continue;
            return 1;
        }
        if (b1.length == b2.length) {
            return 0;
        }
        if (b1.length < b2.length) {
            return -1;
        }
        return 1;
    }
}

