/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.plugin.AttributeInfo;
import org.opends.server.replication.plugin.HistKey;
import org.opends.server.replication.plugin.ValueInfo;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttrInfoSingle
extends AttributeInfo {
    private ChangeNumber deleteTime = null;
    private ChangeNumber addTime = null;
    private AttributeValue value = null;

    @Override
    public ChangeNumber getDeleteTime() {
        return this.deleteTime;
    }

    @Override
    public ArrayList<ValueInfo> getValuesInfo() {
        if (this.addTime == null) {
            return new ArrayList<ValueInfo>();
        }
        ArrayList<ValueInfo> values = new ArrayList<ValueInfo>();
        values.add(new ValueInfo(this.value, this.addTime, null));
        return values;
    }

    @Override
    public void processLocalOrNonConflictModification(ChangeNumber changeNumber, Modification mod) {
        AttributeValue newValue = null;
        Attribute modAttr = mod.getAttribute();
        if (modAttr != null && !modAttr.isEmpty()) {
            newValue = modAttr.iterator().next();
        }
        switch (mod.getModificationType()) {
            case DELETE: {
                this.deleteTime = changeNumber;
                this.value = newValue;
                break;
            }
            case ADD: {
                this.addTime = changeNumber;
                this.value = newValue;
                break;
            }
            case REPLACE: {
                this.deleteTime = newValue == null ? changeNumber : (this.addTime = changeNumber);
                this.value = newValue;
                break;
            }
        }
    }

    @Override
    public boolean replayOperation(Iterator<Modification> modsIterator, ChangeNumber changeNumber, Entry modifiedEntry, Modification mod) {
        boolean conflict = false;
        AttributeValue newValue = null;
        Attribute modAttr = mod.getAttribute();
        if (modAttr != null && !modAttr.isEmpty()) {
            newValue = modAttr.iterator().next();
        }
        switch (mod.getModificationType()) {
            case DELETE: {
                if (changeNumber.newer(this.addTime) && (newValue == null || newValue != null && ((Object)newValue).equals(this.value) || this.value == null)) {
                    AttributeType type;
                    if (changeNumber.newer(this.deleteTime)) {
                        this.deleteTime = changeNumber;
                    }
                    if (!modifiedEntry.hasAttribute(type = modAttr.getAttributeType())) {
                        conflict = true;
                        modsIterator.remove();
                        break;
                    }
                    if (newValue == null || modifiedEntry.hasValue(type, modAttr.getOptions(), newValue)) break;
                    conflict = true;
                    modsIterator.remove();
                    break;
                }
                conflict = true;
                modsIterator.remove();
                break;
            }
            case ADD: {
                if (changeNumber.newerOrEquals(this.deleteTime) && changeNumber.older(this.addTime).booleanValue()) {
                    conflict = true;
                    mod.setModificationType(ModificationType.REPLACE);
                    this.addTime = changeNumber;
                    this.value = newValue;
                    break;
                }
                if (changeNumber.newerOrEquals(this.deleteTime) && (this.addTime == null || this.addTime.older(this.deleteTime).booleanValue())) {
                    this.addTime = changeNumber;
                    this.value = newValue;
                    break;
                }
                conflict = true;
                modsIterator.remove();
                break;
            }
            case REPLACE: {
                if (changeNumber.older(this.deleteTime).booleanValue() && changeNumber.older(this.deleteTime).booleanValue()) {
                    conflict = true;
                    modsIterator.remove();
                    break;
                }
                if (newValue == null) {
                    this.value = newValue;
                    this.deleteTime = changeNumber;
                    break;
                }
                this.addTime = changeNumber;
                this.value = newValue;
                this.deleteTime = changeNumber;
                break;
            }
        }
        return conflict;
    }

    @Override
    public void load(HistKey histKey, AttributeValue value, ChangeNumber cn) {
        switch (histKey) {
            case ADD: {
                this.addTime = cn;
                this.value = value;
                break;
            }
            case DEL: {
                this.deleteTime = cn;
                if (value == null) break;
                this.value = value;
                break;
            }
            case REPL: {
                this.addTime = this.deleteTime = cn;
                if (value == null) break;
                this.value = value;
                break;
            }
            case DELATTR: {
                this.deleteTime = cn;
            }
        }
    }
}

