/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.UserDefinedVirtualAttributeCfg;
import org.opends.server.api.VirtualAttributeProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.plugin.MultimasterReplication;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.VirtualAttributeRule;
import org.opends.server.workflowelement.externalchangelog.ECLWorkflowElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LastChangeNumberVirtualAttributeProvider
extends VirtualAttributeProvider<UserDefinedVirtualAttributeCfg>
implements ConfigurationChangeListener<UserDefinedVirtualAttributeCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    @Override
    public void initializeVirtualAttributeProvider(UserDefinedVirtualAttributeCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public void finalizeVirtualAttributeProvider() {
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    @Override
    public Set<AttributeValue> getValues(Entry entry, VirtualAttributeRule rule) {
        Set<AttributeValue> values = new HashSet<AttributeValue>();
        String last = "0";
        try {
            if (!entry.getDN().equals(DN.decode(""))) {
                return values;
            }
            ECLWorkflowElement eclwe = (ECLWorkflowElement)DirectoryServer.getWorkflowElement("EXTERNAL CHANGE LOG");
            if (eclwe != null) {
                ArrayList<String> excludedDomains = MultimasterReplication.getECLDisabledDomains();
                if (!excludedDomains.contains("cn=changelog")) {
                    excludedDomains.add("cn=changelog");
                }
                ReplicationServer rs = eclwe.getReplicationServer();
                rs.disableEligibility(excludedDomains);
                int[] limits = rs.getECLDraftCNLimits(rs.getEligibleCN(), excludedDomains);
                last = String.valueOf(limits[1]);
            }
        }
        catch (Exception e) {
            TRACER.debugCaught(DebugLogLevel.ERROR, e);
        }
        AttributeValue value = AttributeValues.create(ByteString.valueOf(last), ByteString.valueOf(last));
        values = Collections.singleton(value);
        return values;
    }

    @Override
    public boolean isSearchable(VirtualAttributeRule rule, SearchOperation searchOperation) {
        return false;
    }

    @Override
    public void processSearch(VirtualAttributeRule rule, SearchOperation searchOperation) {
        searchOperation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(UserDefinedVirtualAttributeCfg configuration, List<Message> unacceptableReasons) {
        return false;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(UserDefinedVirtualAttributeCfg configuration) {
        return new ConfigChangeResult(ResultCode.OTHER, false);
    }
}

