/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.monitors;

import java.util.ArrayList;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.ParallelWorkQueue;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.Attributes;
import org.opends.server.types.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelWorkQueueMonitor
extends MonitorProvider<MonitorProviderCfg> {
    public static final String ATTR_CURRENT_BACKLOG = "currentRequestBacklog";
    public static final String ATTR_AVERAGE_BACKLOG = "averageRequestBacklog";
    public static final String ATTR_MAX_BACKLOG = "maxRequestBacklog";
    public static final String ATTR_OPS_SUBMITTED = "requestsSubmitted";
    private int maxBacklog;
    private long numPolls;
    private long totalBacklog;
    private ParallelWorkQueue workQueue;

    public ParallelWorkQueueMonitor(ParallelWorkQueue workQueue) {
        super("Work Queue Monitor Provider");
        this.workQueue = workQueue;
    }

    @Override
    public void initializeMonitorProvider(MonitorProviderCfg configuration) throws ConfigException, InitializationException {
        this.maxBacklog = 0;
        this.totalBacklog = 0L;
        this.numPolls = 0L;
    }

    @Override
    public String getMonitorInstanceName() {
        return "Work Queue";
    }

    @Override
    public long getUpdateInterval() {
        return 10000L;
    }

    @Override
    public void updateMonitorData() {
        int backlog = this.workQueue.size();
        this.totalBacklog += (long)backlog;
        ++this.numPolls;
        if (backlog > this.maxBacklog) {
            this.maxBacklog = backlog;
        }
    }

    public ArrayList<Attribute> getMonitorData() {
        int backlog = this.workQueue.size();
        this.totalBacklog += (long)backlog;
        ++this.numPolls;
        if (backlog > this.maxBacklog) {
            this.maxBacklog = backlog;
        }
        long averageBacklog = (long)(1.0 * (double)this.totalBacklog / (double)this.numPolls);
        long opsSubmitted = this.workQueue.getOpsSubmitted();
        ArrayList<Attribute> monitorAttrs = new ArrayList<Attribute>();
        AttributeSyntax integerSyntax = DirectoryServer.getDefaultIntegerSyntax();
        AttributeType attrType = DirectoryServer.getDefaultAttributeType(ATTR_CURRENT_BACKLOG, integerSyntax);
        monitorAttrs.add(Attributes.create(attrType, String.valueOf(backlog)));
        attrType = DirectoryServer.getDefaultAttributeType(ATTR_AVERAGE_BACKLOG, integerSyntax);
        monitorAttrs.add(Attributes.create(attrType, String.valueOf(averageBacklog)));
        attrType = DirectoryServer.getDefaultAttributeType(ATTR_MAX_BACKLOG, integerSyntax);
        monitorAttrs.add(Attributes.create(attrType, String.valueOf(this.maxBacklog)));
        attrType = DirectoryServer.getDefaultAttributeType(ATTR_OPS_SUBMITTED, integerSyntax);
        monitorAttrs.add(Attributes.create(attrType, String.valueOf(opsSubmitted)));
        return monitorAttrs;
    }
}

