/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.monitors;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.TransactionStats;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.MonitorProvider;
import org.opends.server.backends.jeb.RootContainer;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.Attributes;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseEnvironmentMonitor
extends MonitorProvider<MonitorProviderCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private String name;
    private RootContainer rootContainer;

    public DatabaseEnvironmentMonitor(String name, RootContainer rootContainer) {
        super(name + " Monitor Provider");
        this.name = name;
        this.rootContainer = rootContainer;
    }

    @Override
    public void initializeMonitorProvider(MonitorProviderCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public String getMonitorInstanceName() {
        return this.name;
    }

    @Override
    public long getUpdateInterval() {
        return 0L;
    }

    @Override
    public void updateMonitorData() {
    }

    private void addAttributesForStatsObject(ArrayList<Attribute> monitorAttrs, Object stats, String attrPrefix) {
        Method[] methods;
        Class<?> c = stats.getClass();
        for (Method method : methods = c.getMethods()) {
            Class<?> returnType;
            if (!method.getName().startsWith("get") || !(returnType = method.getReturnType()).equals(Integer.TYPE) && !returnType.equals(Long.TYPE)) continue;
            AttributeSyntax integerSyntax = DirectoryServer.getDefaultIntegerSyntax();
            String attrName = attrPrefix + method.getName().substring(3);
            try {
                Object statValue = method.invoke(stats, new Object[0]);
                AttributeType attrType = DirectoryServer.getDefaultAttributeType(attrName, integerSyntax);
                monitorAttrs.add(Attributes.create(attrType, String.valueOf(statValue)));
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    public ArrayList<Attribute> getMonitorData() {
        EnvironmentStats environmentStats = null;
        TransactionStats transactionStats = null;
        StatsConfig statsConfig = new StatsConfig();
        try {
            environmentStats = this.rootContainer.getEnvironmentStats(statsConfig);
            transactionStats = this.rootContainer.getEnvironmentTransactionStats(statsConfig);
        }
        catch (DatabaseException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return null;
        }
        ArrayList<Attribute> monitorAttrs = new ArrayList<Attribute>();
        String jeVersion = JEVersion.CURRENT_VERSION.getVersionString();
        AttributeType versionType = DirectoryServer.getDefaultAttributeType("JEVersion");
        monitorAttrs.add(Attributes.create(versionType, jeVersion));
        this.addAttributesForStatsObject(monitorAttrs, environmentStats, "Environment");
        this.addAttributesForStatsObject(monitorAttrs, transactionStats, "Transaction");
        return monitorAttrs;
    }
}

