/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.SaslException;
import org.ietf.jgss.GSSException;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.GSSAPISASLMechanismHandlerCfgDefn;
import org.opends.server.admin.std.server.GSSAPISASLMechanismHandlerCfg;
import org.opends.server.admin.std.server.SASLMechanismHandlerCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.IdentityMapper;
import org.opends.server.api.SASLMechanismHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.BindOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.SASLContext;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GSSAPISASLMechanismHandler
extends SASLMechanismHandler<GSSAPISASLMechanismHandlerCfg>
implements ConfigurationChangeListener<GSSAPISASLMechanismHandlerCfg>,
CallbackHandler {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN configEntryDN;
    private GSSAPISASLMechanismHandlerCfg configuration;
    private IdentityMapper<?> identityMapper;
    private HashMap<String, String> saslProps;
    private String serverFQDN;
    private LoginContext loginContext;

    @Override
    public void initializeSASLMechanismHandler(GSSAPISASLMechanismHandlerCfg configuration) throws ConfigException, InitializationException {
        try {
            this.initialize(configuration);
            DirectoryServer.registerSASLMechanismHandler("GSSAPI", this);
            configuration.addGSSAPIChangeListener(this);
            this.configuration = configuration;
            Message msg = ExtensionMessages.INFO_GSSAPI_STARTED.get();
            ErrorLogger.logError(msg);
        }
        catch (UnknownHostException unhe) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, unhe);
            }
            Message message = ExtensionMessages.ERR_SASL_CANNOT_GET_SERVER_FQDN.get(String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(unhe));
            throw new InitializationException(message, (Throwable)unhe);
        }
        catch (IOException ioe) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ioe);
            }
            Message message = ExtensionMessages.ERR_SASLGSSAPI_CANNOT_CREATE_JAAS_CONFIG.get(StaticUtils.getExceptionMessage(ioe));
            throw new InitializationException(message, (Throwable)ioe);
        }
        catch (LoginException le) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, le);
            }
            Message message = ExtensionMessages.ERR_SASLGSSAPI_CANNOT_CREATE_LOGIN_CONTEXT.get(StaticUtils.getExceptionMessage(le));
            throw new InitializationException(message, (Throwable)le);
        }
    }

    private void getKdcRealm(GSSAPISASLMechanismHandlerCfg configuration) throws InitializationException {
        String kdcAddress = configuration.getKdcAddress();
        String realm = configuration.getRealm();
        if (kdcAddress != null && realm == null || kdcAddress == null && realm != null) {
            Message message = ExtensionMessages.ERR_SASLGSSAPI_KDC_REALM_NOT_DEFINED.get();
            throw new InitializationException(message);
        }
        if (kdcAddress != null && realm != null) {
            System.setProperty("java.security.krb5.kdc", kdcAddress);
            System.setProperty("java.security.krb5.realm", realm);
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
    }

    private String getFQDN(GSSAPISASLMechanismHandlerCfg configuration) throws UnknownHostException {
        String serverName = configuration.getServerFqdn();
        if (serverName == null) {
            serverName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        return serverName;
    }

    private void login() throws LoginException {
        this.loginContext = new LoginContext(GSSAPISASLMechanismHandler.class.getName(), this);
        this.loginContext.login();
    }

    private void logout() {
        block2: {
            try {
                this.loginContext.logout();
            }
            catch (LoginException e) {
                if (!DebugLogger.debugEnabled()) break block2;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    private String configureLoginConfFile(GSSAPISASLMechanismHandlerCfg configuration) throws IOException, InitializationException {
        File keyTabFile;
        File tempFile = File.createTempFile("login", "conf");
        String configFileName = tempFile.getAbsolutePath();
        tempFile.deleteOnExit();
        BufferedWriter w = new BufferedWriter(new FileWriter(tempFile, false));
        w.write(this.getClass().getName() + " {");
        w.newLine();
        w.write("  com.sun.security.auth.module.Krb5LoginModule required storeKey=true useKeyTab=true doNotPrompt=true ");
        String keyTabFilePath = configuration.getKeytab();
        if (keyTabFilePath == null) {
            String home = System.getProperty("user.home");
            String sep = System.getProperty("file.separator");
            keyTabFilePath = home + sep + "krb5.keytab";
        }
        if (!(keyTabFile = new File(keyTabFilePath)).exists()) {
            Message msg = ExtensionMessages.ERR_SASL_GSSAPI_KEYTAB_INVALID.get(keyTabFilePath);
            throw new InitializationException(msg);
        }
        w.write("keyTab=\"" + keyTabFile + "\" ");
        StringBuilder principal = new StringBuilder();
        String principalName = configuration.getPrincipalName();
        String realm = configuration.getRealm();
        if (principalName != null) {
            principal.append("principal=\"" + principalName);
        } else {
            principal.append("principal=\"ldap/" + this.serverFQDN);
        }
        if (realm != null) {
            principal.append("@" + realm);
        }
        w.write(principal.toString());
        Message msg = ExtensionMessages.INFO_GSSAPI_PRINCIPAL_NAME.get(principal.toString());
        ErrorLogger.logError(msg);
        w.write("\";");
        w.newLine();
        w.write("};");
        w.newLine();
        w.flush();
        w.close();
        return configFileName;
    }

    @Override
    public void finalizeSASLMechanismHandler() {
        this.logout();
        if (this.configuration != null) {
            this.configuration.removeGSSAPIChangeListener(this);
        }
        DirectoryServer.deregisterSASLMechanismHandler("GSSAPI");
        this.clearProperties();
        Message msg = ExtensionMessages.INFO_GSSAPI_STOPPED.get();
        ErrorLogger.logError(msg);
    }

    private void clearProperties() {
        System.clearProperty("java.security.krb5.kdc");
        System.clearProperty("java.security.krb5.realm");
        System.clearProperty("java.security.auth.login.config");
        System.clearProperty("javax.security.auth.useSubjectCredsOnly");
    }

    @Override
    public void processSASLBind(BindOperation bindOp) {
        ClientConnection clientConnection = bindOp.getClientConnection();
        if (clientConnection == null) {
            Message message = ExtensionMessages.ERR_SASLGSSAPI_NO_CLIENT_CONNECTION.get();
            bindOp.setAuthFailureReason(message);
            bindOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
            return;
        }
        ClientConnection clientConn = bindOp.getClientConnection();
        SASLContext saslContext = (SASLContext)clientConn.getSASLAuthStateInfo();
        if (saslContext == null) {
            try {
                if (clientConn.isSecure()) {
                    HashMap<String, String> secProps = new HashMap<String, String>(this.saslProps);
                    int maxBuf = clientConn.getAppBufferSize();
                    secProps.put("javax.security.sasl.maxbuffer", Integer.toString(maxBuf));
                    saslContext = SASLContext.createSASLContext(secProps, this.serverFQDN, "GSSAPI", this.identityMapper);
                } else {
                    saslContext = SASLContext.createSASLContext(this.saslProps, this.serverFQDN, "GSSAPI", this.identityMapper);
                }
            }
            catch (SaslException ex) {
                GSSException gex;
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ex);
                }
                Message msg = (gex = (GSSException)ex.getCause()) != null ? ExtensionMessages.ERR_SASL_CONTEXT_CREATE_ERROR.get("GSSAPI", GSSAPISASLMechanismHandler.getGSSExceptionMessage(gex)) : ExtensionMessages.ERR_SASL_CONTEXT_CREATE_ERROR.get("GSSAPI", StaticUtils.getExceptionMessage(ex));
                clientConn.setSASLAuthStateInfo(null);
                bindOp.setAuthFailureReason(msg);
                bindOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                return;
            }
        }
        saslContext.performAuthentication(this.loginContext, bindOp);
    }

    public static Message getGSSExceptionMessage(GSSException gex) {
        MessageBuilder message = new MessageBuilder();
        message.append("major code (" + Integer.valueOf(gex.getMajor()).toString() + ") " + gex.getMajorString());
        if (gex.getMinor() != 0) {
            message.append(", minor code (" + Integer.valueOf(gex.getMinor()).toString() + ") " + gex.getMinorString());
        }
        return message.toMessage();
    }

    public Entry getUserForAuthzID(BindOperation bindOperation, String authzID) throws DirectoryException {
        return this.identityMapper.getEntryForID(authzID);
    }

    @Override
    public boolean isPasswordBased(String mechanism) {
        return false;
    }

    @Override
    public boolean isSecure(String mechanism) {
        return true;
    }

    @Override
    public boolean isConfigurationAcceptable(SASLMechanismHandlerCfg configuration, List<Message> unacceptableReasons) {
        GSSAPISASLMechanismHandlerCfg newConfig = (GSSAPISASLMechanismHandlerCfg)configuration;
        return this.isConfigurationChangeAcceptable(newConfig, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(GSSAPISASLMechanismHandlerCfg newConfiguration, List<Message> unacceptableReasons) {
        boolean returnCode = true;
        boolean newStateEnabled = newConfiguration.isEnabled();
        boolean oldStateEnabled = false;
        if (this.configuration != null) {
            oldStateEnabled = this.configuration.isEnabled();
        }
        if (newStateEnabled) {
            try {
                if (oldStateEnabled) {
                    this.finalizeSASLMechanismHandler();
                }
                this.initialize(newConfiguration);
                this.finalizeSASLMechanismHandler();
            }
            catch (InitializationException ex) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ex);
                }
                Message message = ex.getMessageObject();
                unacceptableReasons.add(message);
                this.clearProperties();
                returnCode = false;
            }
            catch (UnknownHostException ex) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ex);
                }
                Message message = ExtensionMessages.ERR_SASL_CANNOT_GET_SERVER_FQDN.get(String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(ex));
                unacceptableReasons.add(message);
                this.clearProperties();
                returnCode = false;
            }
            catch (IOException ex) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ex);
                }
                Message message = ExtensionMessages.ERR_SASLGSSAPI_CANNOT_CREATE_JAAS_CONFIG.get(StaticUtils.getExceptionMessage(ex));
                unacceptableReasons.add(message);
                this.clearProperties();
                returnCode = false;
            }
            catch (LoginException ex) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ex);
                }
                Message message = ExtensionMessages.ERR_SASLGSSAPI_CANNOT_CREATE_LOGIN_CONTEXT.get(StaticUtils.getExceptionMessage(ex));
                unacceptableReasons.add(message);
                this.clearProperties();
                returnCode = false;
            }
        } else if (oldStateEnabled) {
            this.finalizeSASLMechanismHandler();
        }
        return returnCode;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(GSSAPISASLMechanismHandlerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private void initialize(GSSAPISASLMechanismHandlerCfg config) throws UnknownHostException, IOException, LoginException, InitializationException {
        this.configEntryDN = config.dn();
        DN identityMapperDN = config.getIdentityMapperDN();
        this.identityMapper = DirectoryServer.getIdentityMapper(identityMapperDN);
        this.serverFQDN = this.getFQDN(config);
        Message msg = ExtensionMessages.INFO_GSSAPI_SERVER_FQDN.get(this.serverFQDN);
        ErrorLogger.logError(msg);
        this.saslProps = new HashMap();
        this.saslProps.put("javax.security.sasl.qop", this.getQOP(config));
        this.saslProps.put("javax.security.sasl.reuse", "false");
        String configFileName = this.configureLoginConfFile(config);
        System.setProperty("java.security.auth.login.config", configFileName);
        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
        this.getKdcRealm(config);
        this.login();
    }

    private String getQOP(GSSAPISASLMechanismHandlerCfg configuration) {
        GSSAPISASLMechanismHandlerCfgDefn.QualityOfProtection QOP = configuration.getQualityOfProtection();
        if (QOP.equals((Object)GSSAPISASLMechanismHandlerCfgDefn.QualityOfProtection.CONFIDENTIALITY)) {
            return "auth-conf";
        }
        if (QOP.equals((Object)GSSAPISASLMechanismHandlerCfgDefn.QualityOfProtection.INTEGRITY)) {
            return "auth-int";
        }
        return "auth";
    }
}

