/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.Base64PasswordStorageSchemeCfg;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Base64PasswordStorageScheme
extends PasswordStorageScheme<Base64PasswordStorageSchemeCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    @Override
    public void initializePasswordStorageScheme(Base64PasswordStorageSchemeCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public String getStorageSchemeName() {
        return "BASE64";
    }

    @Override
    public ByteString encodePassword(ByteSequence plaintext) throws DirectoryException {
        return ByteString.valueOf(Base64.encode(plaintext));
    }

    @Override
    public ByteString encodePasswordWithScheme(ByteSequence plaintext) throws DirectoryException {
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        buffer.append("BASE64");
        buffer.append('}');
        buffer.append(Base64.encode(plaintext));
        return ByteString.valueOf(buffer.toString());
    }

    @Override
    public boolean passwordMatches(ByteSequence plaintextPassword, ByteSequence storedPassword) {
        String userString = Base64.encode(plaintextPassword);
        String storedString = ((Object)storedPassword).toString();
        return userString.equals(storedString);
    }

    @Override
    public boolean isReversible() {
        return true;
    }

    @Override
    public ByteString getPlaintextValue(ByteSequence storedPassword) throws DirectoryException {
        try {
            return ByteString.wrap(Base64.decode(((Object)storedPassword).toString()));
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_BASE64_DECODE_STORED_PASSWORD.get(((Object)storedPassword).toString(), String.valueOf(e));
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message, e);
        }
    }

    @Override
    public boolean supportsAuthPasswordSyntax() {
        return false;
    }

    @Override
    public ByteString encodeAuthPassword(ByteSequence plaintext) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_DOES_NOT_SUPPORT_AUTH_PASSWORD.get(this.getStorageSchemeName());
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean authPasswordMatches(ByteSequence plaintextPassword, String authInfo, String authValue) {
        return false;
    }

    @Override
    public ByteString getAuthPasswordPlaintextValue(String authInfo, String authValue) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_DOES_NOT_SUPPORT_AUTH_PASSWORD.get(this.getStorageSchemeName());
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean isStorageSchemeSecure() {
        return false;
    }
}

