/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.AESPasswordStorageSchemeCfg;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.CryptoManager;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.Base64;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AESPasswordStorageScheme
extends PasswordStorageScheme<AESPasswordStorageSchemeCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private CryptoManager cryptoManager;

    @Override
    public void initializePasswordStorageScheme(AESPasswordStorageSchemeCfg configuration) throws ConfigException, InitializationException {
        this.cryptoManager = DirectoryServer.getCryptoManager();
    }

    @Override
    public String getStorageSchemeName() {
        return "AES";
    }

    @Override
    public ByteString encodePassword(ByteSequence plaintext) throws DirectoryException {
        try {
            byte[] plaintextBytes = plaintext.toByteArray();
            byte[] encodedBytes = this.cryptoManager.encrypt("AES/CFB/NoPadding", 128, plaintextBytes);
            return ByteString.valueOf(Base64.encode(encodedBytes));
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message m = ExtensionMessages.ERR_PWSCHEME_CANNOT_ENCRYPT.get("AES", StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), m, e);
        }
    }

    @Override
    public ByteString encodePasswordWithScheme(ByteSequence plaintext) throws DirectoryException {
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        buffer.append("AES");
        buffer.append('}');
        try {
            byte[] plaintextBytes = plaintext.toByteArray();
            byte[] encodedBytes = this.cryptoManager.encrypt("AES/CFB/NoPadding", 128, plaintextBytes);
            buffer.append(Base64.encode(encodedBytes));
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message m = ExtensionMessages.ERR_PWSCHEME_CANNOT_ENCRYPT.get("AES", StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), m, e);
        }
        return ByteString.valueOf(buffer.toString());
    }

    @Override
    public boolean passwordMatches(ByteSequence plaintextPassword, ByteSequence storedPassword) {
        try {
            ByteString decryptedPassword = ByteString.wrap(this.cryptoManager.decrypt(Base64.decode(((Object)storedPassword).toString())));
            return ((Object)plaintextPassword).equals(decryptedPassword);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return false;
        }
    }

    @Override
    public boolean isReversible() {
        return true;
    }

    @Override
    public ByteString getPlaintextValue(ByteSequence storedPassword) throws DirectoryException {
        try {
            byte[] decryptedPassword = this.cryptoManager.decrypt(Base64.decode(((Object)storedPassword).toString()));
            return ByteString.wrap(decryptedPassword);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message m = ExtensionMessages.ERR_PWSCHEME_CANNOT_DECRYPT.get("AES", StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), m, e);
        }
    }

    @Override
    public boolean supportsAuthPasswordSyntax() {
        return false;
    }

    @Override
    public ByteString encodeAuthPassword(ByteSequence plaintext) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_DOES_NOT_SUPPORT_AUTH_PASSWORD.get(this.getStorageSchemeName());
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean authPasswordMatches(ByteSequence plaintextPassword, String authInfo, String authValue) {
        return false;
    }

    @Override
    public ByteString getAuthPasswordPlaintextValue(String authInfo, String authValue) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_DOES_NOT_SUPPORT_AUTH_PASSWORD.get(this.getStorageSchemeName());
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean isStorageSchemeSecure() {
        return true;
    }
}

