/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core.networkgroups;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import org.opends.server.admin.std.meta.NetworkGroupCfgDefn;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.networkgroups.ConnectionCriteria;
import org.opends.server.types.AuthenticationType;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProtocolConnectionCriteria
implements ConnectionCriteria {
    private final Set<NetworkGroupCfgDefn.AllowedProtocol> protocols;

    public ProtocolConnectionCriteria(Collection<NetworkGroupCfgDefn.AllowedProtocol> protocols) {
        this.protocols = EnumSet.copyOf(protocols);
    }

    @Override
    public boolean matches(ClientConnection connection) {
        String protocolName = connection.getConnectionHandler().getProtocol();
        for (NetworkGroupCfgDefn.AllowedProtocol protocol : this.protocols) {
            switch (protocol) {
                case LDAP: {
                    if (!protocolName.equals("LDAP")) break;
                    return true;
                }
                case LDAPS: {
                    if (!protocolName.equals("LDAP+SSL")) break;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean willMatchAfterBind(ClientConnection connection, DN bindDN, AuthenticationType authType, boolean isSecure) {
        return this.matches(connection);
    }
}

