/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core.networkgroups;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.networkgroups.NetworkGroup;
import org.opends.server.core.networkgroups.RequestFilteringPolicyStatistics;
import org.opends.server.core.networkgroups.ResourceLimitsPolicyStatistics;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.types.Attribute;
import org.opends.server.types.Attributes;
import org.opends.server.types.InitializationException;
import org.opends.server.types.SearchScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkGroupStatistics
extends MonitorProvider<MonitorProviderCfg> {
    private final String instanceName;
    private final NetworkGroup networkGroup;
    private AtomicLong abandonRequests = new AtomicLong(0L);
    private AtomicLong addRequests = new AtomicLong(0L);
    private AtomicLong bindRequests = new AtomicLong(0L);
    private AtomicLong compareRequests = new AtomicLong(0L);
    private AtomicLong deleteRequests = new AtomicLong(0L);
    private AtomicLong extendedRequests = new AtomicLong(0L);
    private AtomicLong modifyRequests = new AtomicLong(0L);
    private AtomicLong modifyDNRequests = new AtomicLong(0L);
    private AtomicLong searchOneRequests = new AtomicLong(0L);
    private AtomicLong searchSubRequests = new AtomicLong(0L);
    private AtomicLong unbindRequests = new AtomicLong(0L);

    public NetworkGroupStatistics(NetworkGroup networkGroup) {
        super(networkGroup.getID());
        this.instanceName = networkGroup.getID();
        this.networkGroup = networkGroup;
        DirectoryServer.registerMonitorProvider(this);
    }

    public void finalizeStatistics() {
        DirectoryServer.deregisterMonitorProvider(this.getMonitorInstanceName());
    }

    public void updateMessageRead(LDAPMessage message) {
        switch (message.getProtocolOp().getType()) {
            case 80: {
                this.abandonRequests.getAndIncrement();
                break;
            }
            case 104: {
                this.addRequests.getAndIncrement();
                break;
            }
            case 96: {
                this.bindRequests.getAndIncrement();
                break;
            }
            case 110: {
                this.compareRequests.getAndIncrement();
                break;
            }
            case 74: {
                this.deleteRequests.getAndIncrement();
                break;
            }
            case 119: {
                this.extendedRequests.getAndIncrement();
                break;
            }
            case 102: {
                this.modifyRequests.getAndIncrement();
                break;
            }
            case 108: {
                this.modifyDNRequests.getAndIncrement();
                break;
            }
            case 99: {
                SearchScope scope = message.getSearchRequestProtocolOp().getScope();
                if (scope == SearchScope.BASE_OBJECT || scope == SearchScope.SINGLE_LEVEL) {
                    this.searchOneRequests.getAndIncrement();
                    break;
                }
                this.searchSubRequests.getAndIncrement();
                break;
            }
            case 66: {
                this.unbindRequests.getAndIncrement();
            }
        }
    }

    @Override
    public void initializeMonitorProvider(MonitorProviderCfg configuration) throws ConfigException, InitializationException {
        Message message = ProtocolMessages.ERR_LDAP_STATS_INVALID_MONITOR_INITIALIZATION.get(String.valueOf(configuration.dn()));
        throw new ConfigException(message);
    }

    @Override
    public String getMonitorInstanceName() {
        return this.instanceName + ",cn=Network Groups";
    }

    @Override
    public long getUpdateInterval() {
        return -1L;
    }

    @Override
    public void updateMonitorData() {
    }

    @Override
    public List<Attribute> getMonitorData() {
        ResourceLimitsPolicyStatistics rlpStatistics;
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        RequestFilteringPolicyStatistics rfpStatistics = this.networkGroup.getRequestFilteringPolicyStatistics();
        if (rfpStatistics != null) {
            attrs.add(Attributes.create("ds-mon-rejected-attributes-total-count", String.valueOf(rfpStatistics.getRejectedAttributes())));
            attrs.add(Attributes.create("ds-mon-rejected-operations-total-count", String.valueOf(rfpStatistics.getRejectedOperations())));
            attrs.add(Attributes.create("ds-mon-rejected-search-scopes-total-count", String.valueOf(rfpStatistics.getRejectedScopes())));
            attrs.add(Attributes.create("ds-mon-rejected-subtrees-total-count", String.valueOf(rfpStatistics.getRejectedSubtrees())));
        }
        if ((rlpStatistics = this.networkGroup.getResourceLimitsPolicyStatistics()) != null) {
            attrs.add(Attributes.create("ds-mon-client-connection-count", String.valueOf(rlpStatistics.getClientConnections())));
            attrs.add(Attributes.create("ds-mon-client-connection-max-count", String.valueOf(rlpStatistics.getMaxClientConnections())));
            attrs.add(Attributes.create("ds-mon-client-connection-total-count", String.valueOf(rlpStatistics.getTotalClientConnections())));
        }
        attrs.add(Attributes.create("ds-mon-abandon-operations-total-count", String.valueOf(this.abandonRequests.get())));
        attrs.add(Attributes.create("ds-mon-add-operations-total-count", String.valueOf(this.addRequests.get())));
        attrs.add(Attributes.create("ds-mon-bind-operations-total-count", String.valueOf(this.bindRequests.get())));
        attrs.add(Attributes.create("ds-mon-compare-operations-total-count", String.valueOf(this.compareRequests.get())));
        attrs.add(Attributes.create("ds-mon-delete-operations-total-count", String.valueOf(this.deleteRequests.get())));
        attrs.add(Attributes.create("ds-mon-extended-operations-total-count", String.valueOf(this.extendedRequests.get())));
        attrs.add(Attributes.create("ds-mon-mod-operations-total-count", String.valueOf(this.modifyRequests.get())));
        attrs.add(Attributes.create("ds-mon-moddn-operations-total-count", String.valueOf(this.modifyDNRequests.get())));
        attrs.add(Attributes.create("ds-mon-searchonelevel-operations-total-count", String.valueOf(this.searchOneRequests.get())));
        attrs.add(Attributes.create("ds-mon-searchsubtree-operations-total-count", String.valueOf(this.searchSubRequests.get())));
        attrs.add(Attributes.create("ds-mon-unbind-operations-total-count", String.valueOf(this.unbindRequests.get())));
        attrs.add(Attributes.create("ds-mon-discarded-referrals-total-count", "Not implemented"));
        attrs.add(Attributes.create("ds-mon-forwarded-referrals-total-count", "Not implemented"));
        attrs.add(Attributes.create("ds-mon-followed-referrals-total-count", "Not implemented"));
        attrs.add(Attributes.create("ds-mon-failed-referrals-total-count", "Not implemented"));
        attrs.add(Attributes.create("ds-mon-violations-schema-total-count", "Not implemented"));
        attrs.add(Attributes.create("ds-mon-persistent-searchs-count", "Not implemented"));
        return attrs;
    }
}

