/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import java.util.SortedMap;
import java.util.TreeMap;
import org.opends.messages.CoreMessages;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.std.server.WorkflowCfg;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.Workflow;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;
import org.opends.server.util.Validator;
import org.opends.server.workflowelement.ObservableWorkflowElementState;
import org.opends.server.workflowelement.WorkflowElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowImpl
implements Workflow,
Observer {
    private final String workflowID;
    private WorkflowElement<?> rootWorkflowElement = null;
    private String rootWorkflowElementID = null;
    private final DN baseDN;
    private boolean isPrivate = false;
    private static TreeMap<String, Workflow> registeredWorkflows = new TreeMap();
    private static Object registeredWorkflowsLock = new Object();
    private int referenceCounter = 0;
    private Object referenceCounterLock = new Object();

    public WorkflowImpl(String workflowId, DN baseDN, String rootWorkflowElementID, WorkflowElement<?> rootWorkflowElement) {
        this.workflowID = workflowId;
        this.baseDN = baseDN;
        this.rootWorkflowElement = rootWorkflowElement;
        if (this.rootWorkflowElement != null) {
            this.isPrivate = rootWorkflowElement.isPrivate();
            this.rootWorkflowElementID = rootWorkflowElementID;
            WorkflowElement.registereForStateUpdate(rootWorkflowElement, null, this);
        } else {
            WorkflowElement.registereForStateUpdate(null, rootWorkflowElementID, this);
        }
    }

    public void finalizeWorkflow() {
    }

    @Override
    public DN getBaseDN() {
        return this.baseDN;
    }

    public String getWorkflowId() {
        return this.workflowID;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    @Override
    public void execute(Operation operation) throws CanceledOperationException {
        if (this.rootWorkflowElement != null) {
            this.rootWorkflowElement.execute(operation);
        } else {
            operation.setResultCode(ResultCode.OPERATIONS_ERROR);
            MessageBuilder message = new MessageBuilder(CoreMessages.ERR_ROOT_WORKFLOW_ELEMENT_NOT_DEFINED.get(this.workflowID));
            operation.setErrorMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register() throws DirectoryException {
        Validator.ensureNotNull(this.workflowID);
        Object object = registeredWorkflowsLock;
        synchronized (object) {
            if (registeredWorkflows.containsKey(this.workflowID)) {
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_REGISTER_WORKFLOW_ALREADY_EXISTS.get(this.workflowID));
            }
            TreeMap<String, Workflow> newRegisteredWorkflows = new TreeMap<String, Workflow>((SortedMap<String, Workflow>)registeredWorkflows);
            newRegisteredWorkflows.put(this.workflowID, this);
            registeredWorkflows = newRegisteredWorkflows;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister() {
        Validator.ensureNotNull(this.workflowID);
        WorkflowElement.deregistereForStateUpdate(null, this.rootWorkflowElementID, this);
        Object object = registeredWorkflowsLock;
        synchronized (object) {
            TreeMap<String, Workflow> newWorkflows = new TreeMap<String, Workflow>((SortedMap<String, Workflow>)registeredWorkflows);
            newWorkflows.remove(this.workflowID);
            registeredWorkflows = newWorkflows;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkflowImpl deregister(String workflowID) {
        WorkflowImpl workflowToDeregister = null;
        Object object = registeredWorkflowsLock;
        synchronized (object) {
            if (registeredWorkflows.containsKey(workflowID)) {
                workflowToDeregister = (WorkflowImpl)registeredWorkflows.get(workflowID);
                workflowToDeregister.deregister();
            }
        }
        return workflowToDeregister;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterAllOnShutdown() {
        Object object = registeredWorkflowsLock;
        synchronized (object) {
            registeredWorkflows = new TreeMap();
        }
    }

    public static Workflow getWorkflow(String workflowID) {
        return registeredWorkflows.get(workflowID);
    }

    public static Collection<Workflow> getWorkflows() {
        return registeredWorkflows.values();
    }

    WorkflowElement<?> getRootWorkflowElement() {
        return this.rootWorkflowElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetConfig() {
        Object object = registeredWorkflowsLock;
        synchronized (object) {
            registeredWorkflows = new TreeMap();
        }
    }

    public void updateConfig(WorkflowCfg configuration) {
        String rootWorkflowElementID = configuration.getWorkflowElement();
        WorkflowElement rootWorkflowElement = DirectoryServer.getWorkflowElement(rootWorkflowElementID);
        String previousRootWorkflowElement = this.rootWorkflowElementID;
        WorkflowElement.deregistereForStateUpdate(null, previousRootWorkflowElement, this);
        this.rootWorkflowElementID = rootWorkflowElementID;
        if (rootWorkflowElement == null) {
            WorkflowElement.registereForStateUpdate(null, rootWorkflowElementID, this);
            rootWorkflowElement = null;
        } else {
            this.rootWorkflowElement = rootWorkflowElement;
            WorkflowElement.registereForStateUpdate(rootWorkflowElement, null, this);
        }
    }

    @Override
    public void update(Observable observable, Object arg) {
        if (observable instanceof ObservableWorkflowElementState) {
            ObservableWorkflowElementState weState = (ObservableWorkflowElementState)observable;
            this.updateRootWorkflowElementState(weState);
        }
    }

    public String toString() {
        String id = "Workflow " + this.workflowID;
        return id;
    }

    private void updateRootWorkflowElementState(ObservableWorkflowElementState weState) {
        WorkflowElement<?> we = weState.getObservedWorkflowElement();
        String newWorkflowElementID = we.getWorkflowElementID();
        if (!this.rootWorkflowElementID.equalsIgnoreCase(newWorkflowElementID)) {
            return;
        }
        if (weState.workflowElementIsEnabled()) {
            this.rootWorkflowElement = weState.getObservedWorkflowElement();
            WorkflowElement.registereForStateUpdate(this.rootWorkflowElement, null, this);
            WorkflowElement.deregistereForStateUpdate(null, this.rootWorkflowElementID, this);
        } else {
            WorkflowElement.registereForStateUpdate(null, this.rootWorkflowElement.getWorkflowElementID(), this);
            this.rootWorkflowElement = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementReferenceCounter() {
        Object object = this.referenceCounterLock;
        synchronized (object) {
            ++this.referenceCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementReferenceCounter() {
        Object object = this.referenceCounterLock;
        synchronized (object) {
            if (this.referenceCounter == 0) {
                throw new AssertionError((Object)("Reference counter of the workflow " + this.workflowID + " is already set to 0, cannot decrement it anymore"));
            }
            --this.referenceCounter;
        }
    }

    public int getReferenceCounter() {
        return this.referenceCounter;
    }
}

