/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.LogRetentionPolicyCfgDefn;
import org.opends.server.admin.std.server.LogRetentionPolicyCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.RetentionPolicy;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogRetentionPolicyConfigManager
implements ConfigurationAddListener<LogRetentionPolicyCfg>,
ConfigurationDeleteListener<LogRetentionPolicyCfg>,
ConfigurationChangeListener<LogRetentionPolicyCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public void initializeLogRetentionPolicyConfig() throws ConfigException, InitializationException {
        ServerManagementContext context = ServerManagementContext.getInstance();
        RootCfg root = context.getRootConfiguration();
        root.addLogRetentionPolicyAddListener(this);
        root.addLogRetentionPolicyDeleteListener(this);
        for (String name : root.listLogRetentionPolicies()) {
            LogRetentionPolicyCfg config = root.getLogRetentionPolicy(name);
            RetentionPolicy RetentionPolicy2 = this.getRetentionPolicy(config);
            DirectoryServer.registerRetentionPolicy(config.dn(), RetentionPolicy2);
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(LogRetentionPolicyCfg configuration, List<Message> unacceptableReasons) {
        return this.isJavaClassAcceptable(configuration, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(LogRetentionPolicyCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(LogRetentionPolicyCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        try {
            RetentionPolicy RetentionPolicy2 = this.getRetentionPolicy(config);
            DirectoryServer.registerRetentionPolicy(config.dn(), RetentionPolicy2);
        }
        catch (ConfigException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            messages.add(e.getMessageObject());
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            messages.add(ConfigMessages.ERR_CONFIG_RETENTION_POLICY_CANNOT_CREATE_POLICY.get(String.valueOf(config.dn().toString()), StaticUtils.stackTraceToSingleLineString(e)));
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(LogRetentionPolicyCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        RetentionPolicy policy = DirectoryServer.getRetentionPolicy(config.dn());
        if (policy != null) {
            DirectoryServer.deregisterRetentionPolicy(config.dn());
        } else {
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(LogRetentionPolicyCfg configuration, List<Message> unacceptableReasons) {
        return this.isJavaClassAcceptable(configuration, unacceptableReasons);
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(LogRetentionPolicyCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        RetentionPolicy policy = DirectoryServer.getRetentionPolicy(configuration.dn());
        String className = configuration.getJavaClass();
        if (!className.equals(policy.getClass().getName())) {
            adminActionRequired = true;
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private boolean isJavaClassAcceptable(LogRetentionPolicyCfg config, List<Message> unacceptableReasons) {
        Class<RetentionPolicy> theClass;
        String className = config.getJavaClass();
        LogRetentionPolicyCfgDefn d = LogRetentionPolicyCfgDefn.getInstance();
        ClassPropertyDefinition pd = d.getJavaClassPropertyDefinition();
        try {
            theClass = pd.loadClass(className, RetentionPolicy.class);
            theClass.newInstance();
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_RETENTION_POLICY_INVALID_CLASS.get(className, config.dn().toString(), String.valueOf(e));
            unacceptableReasons.add(message);
            return false;
        }
        try {
            theClass.getMethod("initializeLogRetentionPolicy", config.configurationClass());
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_RETENTION_POLICY_INVALID_CLASS.get(className, config.dn().toString(), String.valueOf(e));
            unacceptableReasons.add(message);
            return false;
        }
        return true;
    }

    private RetentionPolicy getRetentionPolicy(LogRetentionPolicyCfg config) throws ConfigException {
        RetentionPolicy RetentionPolicy2;
        String className = config.getJavaClass();
        LogRetentionPolicyCfgDefn d = LogRetentionPolicyCfgDefn.getInstance();
        ClassPropertyDefinition pd = d.getJavaClassPropertyDefinition();
        try {
            Class<RetentionPolicy> theClass = pd.loadClass(className, RetentionPolicy.class);
            RetentionPolicy2 = theClass.newInstance();
            Method method = theClass.getMethod("initializeLogRetentionPolicy", config.configurationClass());
            method.invoke((Object)RetentionPolicy2, config);
        }
        catch (InvocationTargetException ite) {
            Throwable e = ite.getTargetException();
            Message message = ConfigMessages.ERR_CONFIG_RETENTION_POLICY_INVALID_CLASS.get(className, config.dn().toString(), StaticUtils.stackTraceToSingleLineString(e));
            throw new ConfigException(message, e);
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_RETENTION_POLICY_INVALID_CLASS.get(className, config.dn().toString(), String.valueOf(e));
            throw new ConfigException(message, (Throwable)e);
        }
        return RetentionPolicy2;
    }
}

