/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.io.IOException;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class VLVResponseControl
extends Control {
    public static final ControlDecoder<VLVResponseControl> DECODER = new Decoder();
    private ByteString contextID;
    private int contentCount;
    private int targetPosition;
    private int vlvResultCode;

    public VLVResponseControl(int targetPosition, int contentCount, int vlvResultCode) {
        this(false, targetPosition, contentCount, vlvResultCode, null);
    }

    public VLVResponseControl(boolean isCritical, int targetPosition, int contentCount, int vlvResultCode, ByteString contextID) {
        super("2.16.840.1.113730.3.4.10", isCritical);
        this.targetPosition = targetPosition;
        this.contentCount = contentCount;
        this.vlvResultCode = vlvResultCode;
        this.contextID = contextID;
    }

    public int getTargetPosition() {
        return this.targetPosition;
    }

    public int getContentCount() {
        return this.contentCount;
    }

    public int getVLVResultCode() {
        return this.vlvResultCode;
    }

    public ByteString getContextID() {
        return this.contextID;
    }

    protected void writeValue(ASN1Writer writer) throws IOException {
        writer.writeStartSequence((byte)4);
        writer.writeStartSequence();
        writer.writeInteger(this.targetPosition);
        writer.writeInteger(this.contentCount);
        writer.writeEnumerated(this.vlvResultCode);
        if (this.contextID != null) {
            writer.writeOctetString(this.contextID);
        }
        writer.writeEndSequence();
        writer.writeEndSequence();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("VLVResponseControl(targetPosition=");
        buffer.append(this.targetPosition);
        buffer.append(", contentCount=");
        buffer.append(this.contentCount);
        buffer.append(", vlvResultCode=");
        buffer.append(this.vlvResultCode);
        if (this.contextID != null) {
            buffer.append(", contextID=");
            buffer.append(this.contextID);
        }
        buffer.append(")");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Decoder
    implements ControlDecoder<VLVResponseControl> {
        private Decoder() {
        }

        @Override
        public VLVResponseControl decode(boolean isCritical, ByteString value) throws DirectoryException {
            if (value == null) {
                Message message = ProtocolMessages.INFO_VLVRES_CONTROL_NO_VALUE.get();
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            ASN1Reader reader = ASN1.getReader(value);
            try {
                reader.readStartSequence();
                int targetPosition = (int)reader.readInteger();
                int contentCount = (int)reader.readInteger();
                int vlvResultCode = (int)reader.readInteger();
                ByteString contextID = null;
                if (reader.hasNextElement()) {
                    contextID = reader.readOctetString();
                }
                return new VLVResponseControl(isCritical, targetPosition, contentCount, vlvResultCode, contextID);
            }
            catch (Exception e) {
                Message message = ProtocolMessages.INFO_VLVRES_CONTROL_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, e);
            }
        }

        @Override
        public String getOID() {
            return "2.16.840.1.113730.3.4.10";
        }
    }
}

