/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPPostReadRequestControl
extends Control {
    public static final ControlDecoder<LDAPPostReadRequestControl> DECODER = new Decoder();
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private boolean returnAllOperationalAttrs;
    private boolean returnAllUserAttrs;
    private Set<String> rawAttributes;
    private Set<AttributeType> requestedAttributes;

    public LDAPPostReadRequestControl(boolean isCritical, Set<String> rawAttributes) {
        super("1.3.6.1.1.13.2", isCritical);
        this.rawAttributes = rawAttributes == null ? new LinkedHashSet<String>(0) : rawAttributes;
        this.requestedAttributes = null;
        this.returnAllOperationalAttrs = false;
        this.returnAllUserAttrs = false;
    }

    public LDAPPostReadRequestControl(String oid, boolean isCritical, Set<String> rawAttributes) {
        super(oid, isCritical);
        this.rawAttributes = rawAttributes == null ? new LinkedHashSet<String>(0) : rawAttributes;
        this.requestedAttributes = null;
        this.returnAllOperationalAttrs = false;
        this.returnAllUserAttrs = false;
    }

    @Override
    public void writeValue(ASN1Writer writer) throws IOException {
        writer.writeStartSequence((byte)4);
        writer.writeStartSequence();
        if (this.rawAttributes != null) {
            for (String attr : this.rawAttributes) {
                writer.writeOctetString(attr);
            }
        }
        writer.writeEndSequence();
        writer.writeEndSequence();
    }

    public Set<String> getRawAttributes() {
        return this.rawAttributes;
    }

    public Set<AttributeType> getRequestedAttributes() {
        if (this.requestedAttributes == null) {
            this.returnAllOperationalAttrs = false;
            this.returnAllUserAttrs = this.rawAttributes.size() == 0;
            this.requestedAttributes = new LinkedHashSet<AttributeType>(this.rawAttributes.size());
            for (String attr : this.rawAttributes) {
                if ((attr = attr.toLowerCase()).equals("*")) {
                    this.returnAllUserAttrs = true;
                    continue;
                }
                if (attr.equals("+")) {
                    this.returnAllOperationalAttrs = true;
                    continue;
                }
                if (attr.startsWith("@")) {
                    String ocName = attr.substring(1);
                    ObjectClass oc = DirectoryServer.getObjectClass(ocName);
                    if (oc == null) continue;
                    this.requestedAttributes.addAll(oc.getOptionalAttributeChain());
                    this.requestedAttributes.addAll(oc.getRequiredAttributeChain());
                    continue;
                }
                AttributeType at = DirectoryServer.getAttributeType(attr);
                if (at == null) {
                    at = DirectoryServer.getDefaultAttributeType(attr);
                }
                this.requestedAttributes.add(at);
            }
        }
        return this.requestedAttributes;
    }

    public boolean returnAllUserAttributes() {
        if (this.requestedAttributes == null) {
            this.getRequestedAttributes();
        }
        return this.returnAllUserAttrs;
    }

    public boolean returnAllOperationalAttributes() {
        if (this.requestedAttributes == null) {
            this.getRequestedAttributes();
        }
        return this.returnAllOperationalAttrs;
    }

    public boolean allowsAttribute(AttributeType attrType) {
        if (this.requestedAttributes == null) {
            this.getRequestedAttributes();
        }
        if (this.requestedAttributes.contains(attrType)) {
            return true;
        }
        if (attrType.isOperational()) {
            return this.returnAllOperationalAttrs;
        }
        return this.returnAllUserAttrs;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("LDAPPostReadRequestControl(criticality=");
        buffer.append(this.isCritical());
        buffer.append(",attrs=\"");
        if (!this.rawAttributes.isEmpty()) {
            Iterator<String> iterator = this.rawAttributes.iterator();
            buffer.append(iterator.next());
            while (iterator.hasNext()) {
                buffer.append(",");
                buffer.append(iterator.next());
            }
        }
        buffer.append("\")");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Decoder
    implements ControlDecoder<LDAPPostReadRequestControl> {
        private Decoder() {
        }

        @Override
        public LDAPPostReadRequestControl decode(boolean isCritical, ByteString value) throws DirectoryException {
            if (value == null) {
                Message message = ProtocolMessages.ERR_POSTREADREQ_NO_CONTROL_VALUE.get();
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            ASN1Reader reader = ASN1.getReader(value);
            LinkedHashSet<String> rawAttributes = new LinkedHashSet<String>();
            try {
                reader.readStartSequence();
                while (reader.hasNextElement()) {
                    rawAttributes.add(reader.readOctetStringAsString());
                }
                reader.readEndSequence();
            }
            catch (Exception ae) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ae);
                }
                Message message = ProtocolMessages.ERR_POSTREADREQ_CANNOT_DECODE_VALUE.get(ae.getMessage());
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, ae);
            }
            return new LDAPPostReadRequestControl(isCritical, rawAttributes);
        }

        @Override
        public String getOID() {
            return "1.3.6.1.1.13.2";
        }
    }
}

