/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.io.IOException;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.controls.PersistentSearchChangeType;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class EntryChangeNotificationControl
extends Control {
    public static final ControlDecoder<EntryChangeNotificationControl> DECODER = new Decoder();
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN previousDN;
    private long changeNumber;
    private PersistentSearchChangeType changeType;

    public EntryChangeNotificationControl(boolean isCritical, PersistentSearchChangeType changeType, long changeNumber) {
        super("2.16.840.1.113730.3.4.7", isCritical);
        this.changeType = changeType;
        this.changeNumber = changeNumber;
        this.previousDN = null;
    }

    public EntryChangeNotificationControl(boolean isCritical, PersistentSearchChangeType changeType, DN previousDN, long changeNumber) {
        super("2.16.840.1.113730.3.4.7", isCritical);
        this.changeType = changeType;
        this.previousDN = previousDN;
        this.changeNumber = changeNumber;
    }

    public EntryChangeNotificationControl(PersistentSearchChangeType changeType, long changeNumber) {
        this(false, changeType, changeNumber);
    }

    public EntryChangeNotificationControl(PersistentSearchChangeType changeType, DN previousDN, long changeNumber) {
        this(false, changeType, previousDN, changeNumber);
    }

    public void writeValue(ASN1Writer writer) throws IOException {
        writer.writeStartSequence((byte)4);
        writer.writeStartSequence();
        writer.writeEnumerated(this.changeType.intValue());
        if (this.previousDN != null) {
            writer.writeOctetString(this.previousDN.toString());
        }
        if (this.changeNumber > 0L) {
            writer.writeInteger(this.changeNumber);
        }
        writer.writeEndSequence();
        writer.writeEndSequence();
    }

    public PersistentSearchChangeType getChangeType() {
        return this.changeType;
    }

    public DN getPreviousDN() {
        return this.previousDN;
    }

    public long getChangeNumber() {
        return this.changeNumber;
    }

    public void toString(StringBuilder buffer) {
        buffer.append("EntryChangeNotificationControl(changeType=");
        buffer.append(this.changeType.toString());
        if (this.previousDN != null) {
            buffer.append(",previousDN=\"");
            buffer.append(this.previousDN.toString());
            buffer.append("\"");
        }
        if (this.changeNumber > 0L) {
            buffer.append(",changeNumber=");
            buffer.append(this.changeNumber);
        }
        buffer.append(")");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Decoder
    implements ControlDecoder<EntryChangeNotificationControl> {
        private Decoder() {
        }

        @Override
        public EntryChangeNotificationControl decode(boolean isCritical, ByteString value) throws DirectoryException {
            PersistentSearchChangeType changeType;
            if (value == null) {
                Message message = ProtocolMessages.ERR_ECN_NO_CONTROL_VALUE.get();
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            DN previousDN = null;
            long changeNumber = -1L;
            ASN1Reader reader = ASN1.getReader(value);
            try {
                reader.readStartSequence();
                int changeTypeValue = (int)reader.readInteger();
                changeType = PersistentSearchChangeType.valueOf(changeTypeValue);
                if (reader.hasNextElement() && reader.peekType() == 4) {
                    if (changeType != PersistentSearchChangeType.MODIFY_DN) {
                        Message message = ProtocolMessages.ERR_ECN_ILLEGAL_PREVIOUS_DN.get(String.valueOf((Object)changeType));
                        throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                    }
                    previousDN = DN.decode(reader.readOctetStringAsString());
                }
                if (reader.hasNextElement() && reader.peekType() == 2) {
                    changeNumber = reader.readInteger();
                }
            }
            catch (DirectoryException de) {
                throw de;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_ECN_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, e);
            }
            return new EntryChangeNotificationControl(isCritical, changeType, previousDN, changeNumber);
        }

        @Override
        public String getOID() {
            return "2.16.840.1.113730.3.4.7";
        }
    }
}

