/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb.importLDIF;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.opends.messages.JebMessages;
import org.opends.messages.Message;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.DN2ID;
import org.opends.server.backends.jeb.DN2URI;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.ID2Entry;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.VLVIndex;
import org.opends.server.backends.jeb.importLDIF.Importer;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Suffix {
    private final List<DN> includeBranches;
    private final List<DN> excludeBranches;
    private final DN baseDN;
    private final EntryContainer srcEntryContainer;
    private EntryContainer entryContainer;
    private final Object synchObject = new Object();
    private static final int PARENT_ID_SET_SIZE = 16384;
    private ConcurrentHashMap<DN, CountDownLatch> pendingMap = new ConcurrentHashMap();
    private Set<DN> parentSet = new HashSet<DN>(16384);
    private DN parentDN;
    private ArrayList<EntryID> IDs;

    private Suffix(EntryContainer entryContainer, EntryContainer srcEntryContainer, List<DN> includeBranches, List<DN> excludeBranches) throws InitializationException, ConfigException {
        this.entryContainer = entryContainer;
        this.srcEntryContainer = srcEntryContainer;
        this.baseDN = entryContainer.getBaseDN();
        this.includeBranches = includeBranches == null ? new ArrayList<DN>(0) : includeBranches;
        this.excludeBranches = excludeBranches == null ? new ArrayList<DN>(0) : excludeBranches;
    }

    public static Suffix createSuffixContext(EntryContainer entryContainer, EntryContainer srcEntryContainer, List<DN> includeBranches, List<DN> excludeBranches) throws InitializationException, ConfigException {
        return new Suffix(entryContainer, srcEntryContainer, includeBranches, excludeBranches);
    }

    public DN2ID getDN2ID() {
        return this.entryContainer.getDN2ID();
    }

    public ID2Entry getID2Entry() {
        return this.entryContainer.getID2Entry();
    }

    public DN2URI getDN2URI() {
        return this.entryContainer.getDN2URI();
    }

    public EntryContainer getEntryContainer() {
        return this.entryContainer;
    }

    public Map<AttributeType, AttributeIndex> getAttrIndexMap() {
        return this.entryContainer.getAttributeIndexMap();
    }

    private void assureNotPending(DN parentDN) throws InterruptedException {
        CountDownLatch l = this.pendingMap.get(parentDN);
        if (l != null) {
            l.await();
        }
    }

    public void addPending(DN dn) {
        this.pendingMap.putIfAbsent(dn, new CountDownLatch(1));
    }

    public void removePending(DN dn) {
        CountDownLatch l = this.pendingMap.remove(dn);
        if (l != null) {
            l.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParentProcessed(DN dn, Importer.DNCache dnCache, boolean clearedBackend) throws DatabaseException, InterruptedException {
        Object object = this.synchObject;
        synchronized (object) {
            if (this.parentSet.contains(dn)) {
                return true;
            }
        }
        try {
            this.assureNotPending(dn);
        }
        catch (InterruptedException e) {
            Message message = JebMessages.ERR_JEB_IMPORT_LDIF_PENDING_ERR.get(e.getMessage());
            ErrorLogger.logError(message);
            throw e;
        }
        boolean parentThere = dnCache.contains(dn);
        if (!parentThere && !clearedBackend && this.getDN2ID().get(null, dn, LockMode.DEFAULT) != null) {
            parentThere = true;
        }
        if (parentThere) {
            Object object2 = this.synchObject;
            synchronized (object2) {
                if (this.parentSet.size() >= 16384) {
                    Iterator<DN> iterator = this.parentSet.iterator();
                    iterator.next();
                    iterator.remove();
                }
                this.parentSet.add(dn);
            }
        }
        return parentThere;
    }

    public void setIndexesTrusted() throws DatabaseException {
        this.entryContainer.getID2Children().setTrusted(null, true);
        this.entryContainer.getID2Subtree().setTrusted(null, true);
        for (AttributeIndex attributeIndex : this.entryContainer.getAttributeIndexes()) {
            Collection<Index> sharedIndexes;
            Map<String, Collection<Index>> exIndexes;
            Index index = attributeIndex.getEqualityIndex();
            if (index != null) {
                index.setTrusted(null, true);
            }
            if ((index = attributeIndex.getPresenceIndex()) != null) {
                index.setTrusted(null, true);
            }
            if ((index = attributeIndex.getSubstringIndex()) != null) {
                index.setTrusted(null, true);
            }
            if ((index = attributeIndex.getOrderingIndex()) != null) {
                index.setTrusted(null, true);
            }
            if ((index = attributeIndex.getApproximateIndex()) != null) {
                index.setTrusted(null, true);
            }
            if ((exIndexes = attributeIndex.getExtensibleIndexes()).isEmpty()) continue;
            Collection<Index> subIndexes = attributeIndex.getExtensibleIndexes().get("substring");
            if (subIndexes != null) {
                for (Index subIndex : subIndexes) {
                    subIndex.setTrusted(null, true);
                }
            }
            if ((sharedIndexes = attributeIndex.getExtensibleIndexes().get("shared")) == null) continue;
            for (Index sharedIndex : sharedIndexes) {
                sharedIndex.setTrusted(null, true);
            }
        }
        for (VLVIndex vlvIdx : this.entryContainer.getVLVIndexes()) {
            vlvIdx.setTrusted(null, true);
        }
    }

    public DN getParentDN() {
        return this.parentDN;
    }

    public void setParentDN(DN parentDN) {
        this.parentDN = parentDN;
    }

    public ArrayList<EntryID> getIDs() {
        return this.IDs;
    }

    public void setIDs(ArrayList<EntryID> IDs) {
        this.IDs = IDs;
    }

    public EntryContainer getSrcEntryContainer() {
        return this.srcEntryContainer;
    }

    public List<DN> getIncludeBranches() {
        return this.includeBranches;
    }

    public List<DN> getExcludeBranches() {
        return this.excludeBranches;
    }

    public DN getBaseDN() {
        return this.baseDN;
    }
}

