/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb.importLDIF;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.util.PackedInteger;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.opends.messages.Category;
import org.opends.messages.JebMessages;
import org.opends.messages.Message;
import org.opends.messages.Severity;
import org.opends.server.admin.std.meta.LocalDBIndexCfgDefn;
import org.opends.server.admin.std.server.LocalDBBackendCfg;
import org.opends.server.admin.std.server.LocalDBIndexCfg;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.DN2ID;
import org.opends.server.backends.jeb.DN2URI;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.EnvManager;
import org.opends.server.backends.jeb.ID2Entry;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.JebFormat;
import org.opends.server.backends.jeb.RebuildConfig;
import org.opends.server.backends.jeb.RootContainer;
import org.opends.server.backends.jeb.VLVIndex;
import org.opends.server.backends.jeb.importLDIF.ImportIDSet;
import org.opends.server.backends.jeb.importLDIF.IndexBuffer;
import org.opends.server.backends.jeb.importLDIF.Suffix;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LDIFImportResult;
import org.opends.server.util.DynamicConstants;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Importer {
    private static final int TIMER_INTERVAL = 10000;
    static final int KB = 1024;
    private static final int MB = 0x100000;
    private static final String DEFAULT_TMP_DIR = "import-tmp";
    private static final String TMPENV_DIR = "tmp-env";
    private static final int MAX_DB_CACHE_SIZE = 0x800000;
    private static final int MAX_DB_LOG_SIZE = 0xA00000;
    private static final int MIN_DB_CACHE_SIZE = 0x400000;
    private static final int READER_WRITER_BUFFER_SIZE = 0x100000;
    private static final int MIN_DB_CACHE_MEMORY = 0x1200000;
    private static final int BYTE_BUFFER_CAPACITY = 128;
    private static final int MAX_BUFFER_SIZE = 0x6400000;
    private static final int MIN_BUFFER_SIZE = 8192;
    private static final int MIN_READ_AHEAD_CACHE_SIZE = 2048;
    private static final int JVM_MEM_PCT = 45;
    private static final int TMPENV_MEM_PCT = 50;
    private static final int SMALL_HEAP_SIZE = 0x10000000;
    private static AttributeType dnType;
    private static final IndexBuffer.DNComparator dnComparator;
    private static final IndexBuffer.IndexComparator indexComparator;
    private final AtomicInteger bufferCount = new AtomicInteger(0);
    private final AtomicLong importCount = new AtomicLong(0L);
    private int bufferSize;
    private final File tempDir;
    private final int indexCount;
    private int threadCount;
    private final boolean skipDNValidation;
    private final TmpEnv tmpEnv;
    private RootContainer rootContainer;
    private final LDIFImportConfig importConfiguration;
    private LDIFReader reader;
    private int migratedCount;
    private long tmpEnvCacheSize = 0L;
    private long dbCacheSize = 0x800000L;
    private long dbLogBufSize = 0xA00000L;
    private ExecutorService bufferSortService;
    private ExecutorService scratchFileWriterService;
    private final BlockingQueue<IndexBuffer> freeBufferQueue = new LinkedBlockingQueue<IndexBuffer>();
    private final Map<IndexKey, BlockingQueue<IndexBuffer>> indexKeyQueMap = new ConcurrentHashMap<IndexKey, BlockingQueue<IndexBuffer>>();
    private final List<IndexManager> indexMgrList = new LinkedList<IndexManager>();
    private final List<IndexManager> DNIndexMgrList = new LinkedList<IndexManager>();
    private final List<Future<?>> scratchFileWriterFutures;
    private final List<ScratchFileWriterTask> scratchFileWriterList;
    private final Map<DN, Suffix> dnSuffixMap = new LinkedHashMap<DN, Suffix>();
    private final ConcurrentHashMap<Integer, DatabaseContainer> idContainerMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, EntryContainer> idECMap = new ConcurrentHashMap();
    private final Object synObj = new Object();
    private final RebuildIndexManager rebuildManager;
    private boolean clearedBackend = false;
    private volatile boolean isPhaseOneCanceled = false;
    private int phaseOneBufferCount;

    private Importer(RebuildConfig rebuildConfig, LocalDBBackendCfg cfg, EnvironmentConfig envConfig) throws IOException, InitializationException, JebException, ConfigException {
        this.importConfiguration = null;
        this.tmpEnv = null;
        this.threadCount = 1;
        this.rebuildManager = new RebuildIndexManager(rebuildConfig, cfg);
        this.indexCount = this.rebuildManager.getIndexCount();
        this.scratchFileWriterList = new ArrayList<ScratchFileWriterTask>(this.indexCount);
        this.scratchFileWriterFutures = new CopyOnWriteArrayList();
        File parentDir = rebuildConfig.getTmpDirectory() == null ? StaticUtils.getFileForPath(DEFAULT_TMP_DIR) : StaticUtils.getFileForPath(rebuildConfig.getTmpDirectory());
        this.tempDir = new File(parentDir, cfg.getBackendId());
        if (!this.tempDir.exists() && !this.tempDir.mkdirs()) {
            Message message = JebMessages.ERR_JEB_IMPORT_CREATE_TMPDIR_ERROR.get(String.valueOf(this.tempDir));
            throw new IOException(message.toString());
        }
        if (this.tempDir.listFiles() != null) {
            for (File f : this.tempDir.listFiles()) {
                f.delete();
            }
        }
        this.skipDNValidation = true;
        if (envConfig != null) {
            this.initializeDBEnv(envConfig);
        }
    }

    private Importer(LDIFImportConfig importConfiguration, LocalDBBackendCfg localDBBackendCfg, EnvironmentConfig envConfig) throws IOException, InitializationException, DatabaseException {
        this.rebuildManager = null;
        this.importConfiguration = importConfiguration;
        this.threadCount = importConfiguration.getThreadCount() == 0 ? Runtime.getRuntime().availableProcessors() * 2 : importConfiguration.getThreadCount();
        this.indexCount = localDBBackendCfg.listLocalDBIndexes().length + 2;
        if (!importConfiguration.appendToExistingData() && (importConfiguration.clearBackend() || localDBBackendCfg.getBaseDN().size() <= 1)) {
            this.clearedBackend = true;
        }
        this.scratchFileWriterList = new ArrayList<ScratchFileWriterTask>(this.indexCount);
        this.scratchFileWriterFutures = new CopyOnWriteArrayList();
        File parentDir = importConfiguration.getTmpDirectory() == null ? StaticUtils.getFileForPath(DEFAULT_TMP_DIR) : StaticUtils.getFileForPath(importConfiguration.getTmpDirectory());
        this.tempDir = new File(parentDir, localDBBackendCfg.getBackendId());
        if (!this.tempDir.exists() && !this.tempDir.mkdirs()) {
            Message message = JebMessages.ERR_JEB_IMPORT_CREATE_TMPDIR_ERROR.get(String.valueOf(this.tempDir));
            throw new IOException(message.toString());
        }
        if (this.tempDir.listFiles() != null) {
            for (File f : this.tempDir.listFiles()) {
                f.delete();
            }
        }
        this.skipDNValidation = importConfiguration.getSkipDNValidation();
        this.initializeDBEnv(envConfig);
        if (!this.skipDNValidation) {
            File p = StaticUtils.getFileForPath(localDBBackendCfg.getDBDirectory());
            File envPath = new File(p, TMPENV_DIR);
            envPath.mkdirs();
            this.tmpEnv = new TmpEnv(envPath);
        } else {
            this.tmpEnv = null;
        }
    }

    public static Importer getInstance(LDIFImportConfig importCfg, LocalDBBackendCfg localDBBackendCfg, EnvironmentConfig envCfg) throws IOException, InitializationException {
        return new Importer(importCfg, localDBBackendCfg, envCfg);
    }

    public static synchronized Importer getInstance(RebuildConfig rebuildCfg, LocalDBBackendCfg localDBBackendCfg, EnvironmentConfig envCfg) throws IOException, InitializationException, JebException, ConfigException {
        return new Importer(rebuildCfg, localDBBackendCfg, envCfg);
    }

    private void adjustBufferSize(long availMem) {
        int oldThreadCount = this.threadCount;
        while (this.threadCount > 0) {
            this.phaseOneBufferCount = 2 * (this.indexCount * this.threadCount);
            this.bufferSize = (int)(availMem / (long)this.phaseOneBufferCount);
            if (this.bufferSize >= 8192) break;
            --this.threadCount;
        }
        Message message = JebMessages.NOTE_JEB_IMPORT_ADJUST_THREAD_COUNT.get(oldThreadCount, this.threadCount);
        ErrorLogger.logError(message);
    }

    private boolean getBufferSizes(long availMem) {
        boolean maxBuf = false;
        this.bufferSize = (int)(availMem / (long)this.phaseOneBufferCount);
        if (this.bufferSize >= 8192) {
            if (this.bufferSize > 0x6400000) {
                this.bufferSize = 0x6400000;
                maxBuf = true;
            }
        } else if (this.bufferSize < 8192) {
            this.adjustBufferSize(availMem);
        }
        return maxBuf;
    }

    public static Suffix getMatchSuffix(DN dn, Map<DN, Suffix> map) {
        Suffix suffix = null;
        DN nodeDN = dn;
        while (suffix == null && nodeDN != null) {
            suffix = map.get(nodeDN);
            if (suffix != null) continue;
            nodeDN = nodeDN.getParentDNInSuffix();
        }
        return suffix;
    }

    private long getTmpEnvironmentMemory(long availableMemoryImport) {
        int tmpMemPct = 50;
        this.tmpEnvCacheSize = availableMemoryImport * (long)tmpMemPct / 100L;
        availableMemoryImport -= this.tmpEnvCacheSize;
        if (!this.clearedBackend) {
            long additionalDBCache = this.tmpEnvCacheSize * 85L / 100L;
            this.tmpEnvCacheSize -= additionalDBCache;
            this.dbCacheSize += additionalDBCache;
        }
        return availableMemoryImport;
    }

    private void adjustTmpEnvironmentMemory(long availableMemoryImport) {
        long additionalMem = availableMemoryImport - (long)(this.phaseOneBufferCount * 0x6400000);
        if (additionalMem > 0L) {
            this.tmpEnvCacheSize += additionalMem;
            if (!this.clearedBackend) {
                long additionalDBCache = this.tmpEnvCacheSize * 85L / 100L;
                this.tmpEnvCacheSize -= additionalDBCache;
                this.dbCacheSize += additionalDBCache;
            }
        }
    }

    private long defaultMemoryCalc(long availMem) throws InitializationException {
        long bufMem = 0L;
        if (availMem < 0x1600000L) {
            long minCacheSize = 0x400000L;
            if (System.getProperty("org.opends.server.RunningUnitTests") != null) {
                minCacheSize = 512000L;
            }
            this.dbCacheSize = minCacheSize;
            this.tmpEnvCacheSize = minCacheSize;
            this.dbLogBufSize = 0L;
            bufMem = availMem - 2L * minCacheSize;
            if (bufMem < 0L || bufMem < (long)(2 * this.indexCount * 8192)) {
                Message message = JebMessages.ERR_IMPORT_LDIF_LACK_MEM.get(availMem, 2 * this.indexCount * 8192 + 0x800000);
                throw new InitializationException(message);
            }
        } else {
            bufMem = this.getTmpEnvironmentMemory(availMem);
        }
        return bufMem;
    }

    private long skipDNValidationCalc(long availMem) throws InitializationException {
        long bufMem = availMem;
        if (availMem < 0x1200000L) {
            long minCacheSize = 0x400000L;
            if (System.getProperty("org.opends.server.RunningUnitTests") != null) {
                minCacheSize = 512000L;
            }
            this.dbCacheSize = minCacheSize;
            this.dbLogBufSize = 0L;
            bufMem = availMem - minCacheSize;
            if (bufMem < 0L || bufMem < (long)(2 * this.indexCount * 8192)) {
                Message message = JebMessages.ERR_IMPORT_LDIF_LACK_MEM.get(availMem, 2 * this.indexCount * 8192 + 0x400000);
                throw new InitializationException(message);
            }
        }
        return bufMem;
    }

    private void initializeDBEnv(EnvironmentConfig envConfig) throws InitializationException {
        this.phaseOneBufferCount = 2 * (this.indexCount * this.threadCount);
        Runtime runTime = Runtime.getRuntime();
        long totFreeMemory = runTime.freeMemory() + (runTime.maxMemory() - runTime.totalMemory());
        int importMemPct = 55;
        if (totFreeMemory <= 0x10000000L) {
            importMemPct -= 15;
        }
        if (this.rebuildManager != null) {
            importMemPct -= 15;
        }
        long phaseOneBufferMemory = 0L;
        phaseOneBufferMemory = !this.skipDNValidation ? this.defaultMemoryCalc(totFreeMemory * (long)importMemPct / 100L) : this.skipDNValidationCalc(totFreeMemory * (long)importMemPct / 100L);
        boolean maxBuffers = this.getBufferSizes(phaseOneBufferMemory);
        if (!this.skipDNValidation && maxBuffers) {
            this.adjustTmpEnvironmentMemory(phaseOneBufferMemory);
        }
        Message message = JebMessages.NOTE_JEB_IMPORT_LDIF_TOT_MEM_BUF.get(phaseOneBufferMemory, this.phaseOneBufferCount);
        ErrorLogger.logError(message);
        if (this.tmpEnvCacheSize > 0L) {
            message = JebMessages.NOTE_JEB_IMPORT_LDIF_TMP_ENV_MEM.get(this.tmpEnvCacheSize);
            ErrorLogger.logError(message);
        }
        envConfig.setConfigParam("je.env.runCleaner", "true");
        envConfig.setConfigParam("je.maxMemory", Long.toString(this.dbCacheSize));
        message = JebMessages.NOTE_JEB_IMPORT_LDIF_DB_MEM_BUF_INFO.get(this.dbCacheSize, this.bufferSize);
        ErrorLogger.logError(message);
        if (this.dbLogBufSize > 0L) {
            envConfig.setConfigParam("je.log.totalBufferBytes", Long.toString(0xA00000L));
            message = JebMessages.NOTE_JEB_IMPORT_LDIF_LOG_BYTES.get(0xA00000);
            ErrorLogger.logError(message);
        }
    }

    private void initializeIndexBuffers() {
        for (int i = 0; i < this.phaseOneBufferCount; ++i) {
            IndexBuffer b = IndexBuffer.createIndexBuffer(this.bufferSize);
            this.freeBufferQueue.add(b);
        }
    }

    private void initializeSuffixes() throws DatabaseException, JebException, ConfigException, InitializationException {
        for (EntryContainer ec : this.rootContainer.getEntryContainers()) {
            Suffix suffix = this.getSuffix(ec);
            if (suffix == null) continue;
            this.dnSuffixMap.put(ec.getBaseDN(), suffix);
            this.generateIndexID(suffix);
        }
    }

    private void generateIndexID(Suffix suffix) {
        for (Map.Entry<AttributeType, AttributeIndex> mapEntry : suffix.getAttrIndexMap().entrySet()) {
            Collection<Index> sharedIndexes;
            Map<String, Collection<Index>> extensibleMap;
            int id;
            AttributeIndex attributeIndex = mapEntry.getValue();
            Index container = attributeIndex.getEqualityIndex();
            if (container != null) {
                id = System.identityHashCode(container);
                this.idContainerMap.putIfAbsent(id, container);
            }
            if ((container = attributeIndex.getPresenceIndex()) != null) {
                id = System.identityHashCode(container);
                this.idContainerMap.putIfAbsent(id, container);
            }
            if ((container = attributeIndex.getSubstringIndex()) != null) {
                id = System.identityHashCode(container);
                this.idContainerMap.putIfAbsent(id, container);
            }
            if ((container = attributeIndex.getOrderingIndex()) != null) {
                id = System.identityHashCode(container);
                this.idContainerMap.putIfAbsent(id, container);
            }
            if ((container = attributeIndex.getApproximateIndex()) != null) {
                id = System.identityHashCode(container);
                this.idContainerMap.putIfAbsent(id, container);
            }
            if ((extensibleMap = attributeIndex.getExtensibleIndexes()).isEmpty()) continue;
            Collection<Index> subIndexes = attributeIndex.getExtensibleIndexes().get("substring");
            if (subIndexes != null) {
                for (Index subIndex : subIndexes) {
                    int id2 = System.identityHashCode(subIndex);
                    this.idContainerMap.putIfAbsent(id2, subIndex);
                }
            }
            if ((sharedIndexes = attributeIndex.getExtensibleIndexes().get("shared")) == null) continue;
            for (Index sharedIndex : sharedIndexes) {
                int id3 = System.identityHashCode(sharedIndex);
                this.idContainerMap.putIfAbsent(id3, sharedIndex);
            }
        }
    }

    private Suffix getSuffix(EntryContainer entryContainer) throws DatabaseException, JebException, ConfigException, InitializationException {
        DN baseDN = entryContainer.getBaseDN();
        EntryContainer sourceEntryContainer = null;
        ArrayList<DN> includeBranches = new ArrayList<DN>();
        ArrayList<DN> excludeBranches = new ArrayList<DN>();
        if (!this.importConfiguration.appendToExistingData() && !this.importConfiguration.clearBackend()) {
            for (DN dn : this.importConfiguration.getExcludeBranches()) {
                if (baseDN.equals(dn)) {
                    return null;
                }
                if (!baseDN.isAncestorOf(dn)) continue;
                excludeBranches.add(dn);
            }
            if (!this.importConfiguration.getIncludeBranches().isEmpty()) {
                for (DN dn : this.importConfiguration.getIncludeBranches()) {
                    if (!baseDN.isAncestorOf(dn)) continue;
                    includeBranches.add(dn);
                }
                if (includeBranches.isEmpty()) {
                    return null;
                }
                Iterator includeBranchIterator = includeBranches.iterator();
                while (includeBranchIterator.hasNext()) {
                    DN includeDN = (DN)includeBranchIterator.next();
                    boolean keep = true;
                    for (DN dn : includeBranches) {
                        if (dn.equals(includeDN) || !dn.isAncestorOf(includeDN)) continue;
                        keep = false;
                        break;
                    }
                    if (keep) continue;
                    includeBranchIterator.remove();
                }
                Iterator excludeBranchIterator = excludeBranches.iterator();
                while (excludeBranchIterator.hasNext()) {
                    DN excludeDN = (DN)excludeBranchIterator.next();
                    boolean keep = false;
                    for (DN includeDN : includeBranches) {
                        if (!includeDN.isAncestorOf(excludeDN)) continue;
                        keep = true;
                        break;
                    }
                    if (keep) continue;
                    excludeBranchIterator.remove();
                }
                if (includeBranches.size() == 1 && excludeBranches.size() == 0 && ((DN)includeBranches.get(0)).equals(baseDN)) {
                    entryContainer.lock();
                    entryContainer.clear();
                    entryContainer.unlock();
                } else {
                    sourceEntryContainer = entryContainer;
                    entryContainer = this.rootContainer.openEntryContainer(baseDN, baseDN.toNormalizedString() + "_importTmp");
                }
            }
        }
        return Suffix.createSuffixContext(entryContainer, sourceEntryContainer, includeBranches, excludeBranches);
    }

    public void rebuildIndexes(RootContainer rootContainer) throws ConfigException, InitializationException, IOException, JebException, DatabaseException, InterruptedException, ExecutionException {
        this.rootContainer = rootContainer;
        long startTime = System.currentTimeMillis();
        this.rebuildManager.initialize();
        this.rebuildManager.printStartMessage();
        this.rebuildManager.rebuldIndexes();
        this.tempDir.delete();
        this.rebuildManager.printStopMessage(startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDIFImportResult processImport(RootContainer rootContainer) throws ConfigException, InitializationException, IOException, JebException, DatabaseException, InterruptedException, ExecutionException {
        this.rootContainer = rootContainer;
        this.reader = new LDIFReader(this.importConfiguration, rootContainer, 0x100000);
        try {
            Message message = JebMessages.NOTE_JEB_IMPORT_STARTING.get(DirectoryServer.getVersionString(), DynamicConstants.BUILD_ID, DynamicConstants.REVISION_NUMBER);
            ErrorLogger.logError(message);
            message = JebMessages.NOTE_JEB_IMPORT_THREAD_COUNT.get(this.threadCount);
            ErrorLogger.logError(message);
            this.initializeSuffixes();
            long startTime = System.currentTimeMillis();
            this.phaseOne();
            long phaseOneFinishTime = System.currentTimeMillis();
            if (!this.skipDNValidation) {
                this.tmpEnv.shutdown();
            }
            if (this.isPhaseOneCanceled) {
                throw new InterruptedException("Import processing canceled.");
            }
            long phaseTwoTime = System.currentTimeMillis();
            this.phaseTwo();
            long phaseTwoFinishTime = System.currentTimeMillis();
            this.setIndexesTrusted();
            this.switchContainers();
            this.tempDir.delete();
            long finishTime = System.currentTimeMillis();
            long importTime = finishTime - startTime;
            float rate = 0.0f;
            message = JebMessages.NOTE_JEB_IMPORT_PHASE_STATS.get(importTime / 1000L, (phaseOneFinishTime - startTime) / 1000L, (phaseTwoFinishTime - phaseTwoTime) / 1000L);
            ErrorLogger.logError(message);
            if (importTime > 0L) {
                rate = 1000.0f * (float)this.reader.getEntriesRead() / (float)importTime;
            }
            message = JebMessages.NOTE_JEB_IMPORT_FINAL_STATUS.get(this.reader.getEntriesRead(), this.importCount.get(), this.reader.getEntriesIgnored(), this.reader.getEntriesRejected(), this.migratedCount, importTime / 1000L, Float.valueOf(rate));
            ErrorLogger.logError(message);
        }
        finally {
            this.reader.close();
        }
        return new LDIFImportResult(this.reader.getEntriesRead(), this.reader.getEntriesRejected(), this.reader.getEntriesIgnored());
    }

    private void switchContainers() throws DatabaseException, JebException, InitializationException {
        for (Suffix suffix : this.dnSuffixMap.values()) {
            DN baseDN = suffix.getBaseDN();
            EntryContainer entryContainer = suffix.getSrcEntryContainer();
            if (entryContainer == null) continue;
            EntryContainer needRegisterContainer = this.rootContainer.unregisterEntryContainer(baseDN);
            if (needRegisterContainer != needRegisterContainer) {
                this.rootContainer.registerEntryContainer(baseDN, needRegisterContainer);
                continue;
            }
            needRegisterContainer.lock();
            needRegisterContainer.close();
            needRegisterContainer.delete();
            needRegisterContainer.unlock();
            EntryContainer newEC = suffix.getEntryContainer();
            newEC.lock();
            newEC.setDatabasePrefix(baseDN.toNormalizedString());
            newEC.unlock();
            this.rootContainer.registerEntryContainer(baseDN, newEC);
        }
    }

    private void setIndexesTrusted() throws JebException {
        try {
            for (Suffix s : this.dnSuffixMap.values()) {
                s.setIndexesTrusted();
            }
        }
        catch (DatabaseException ex) {
            Message message = JebMessages.NOTE_JEB_IMPORT_LDIF_TRUSTED_FAILED.get(ex.getMessage());
            throw new JebException(message);
        }
    }

    private void phaseOne() throws InterruptedException, ExecutionException {
        int i;
        this.initializeIndexBuffers();
        FirstPhaseProgressTask progressTask = new FirstPhaseProgressTask();
        Timer timer = new Timer();
        timer.scheduleAtFixedRate((TimerTask)progressTask, 10000L, 10000L);
        this.scratchFileWriterService = Executors.newFixedThreadPool(2 * this.indexCount);
        this.bufferSortService = Executors.newFixedThreadPool(this.threadCount);
        ExecutorService execService = Executors.newFixedThreadPool(this.threadCount);
        ArrayList<ImportTask> tasks = new ArrayList<ImportTask>(this.threadCount);
        tasks.add(new MigrateExistingTask());
        List results = execService.invokeAll(tasks);
        for (Future future : results) {
            if (future.isDone()) continue;
            future.get();
        }
        tasks.clear();
        results.clear();
        if (this.importConfiguration.appendToExistingData() && this.importConfiguration.replaceExistingEntries()) {
            for (i = 0; i < this.threadCount; ++i) {
                tasks.add(new AppendReplaceTask());
            }
        } else {
            for (i = 0; i < this.threadCount; ++i) {
                tasks.add(new ImportTask());
            }
        }
        results = execService.invokeAll(tasks);
        for (Future future : results) {
            if (future.isDone()) continue;
            future.get();
        }
        tasks.clear();
        results.clear();
        tasks.add(new MigrateExcludedTask());
        results = execService.invokeAll(tasks);
        for (Future future : results) {
            if (future.isDone()) continue;
            future.get();
        }
        this.stopScratchFileWriters();
        for (Future<Object> future : this.scratchFileWriterFutures) {
            if (future.isDone()) continue;
            future.get();
        }
        this.scratchFileWriterList.clear();
        this.scratchFileWriterFutures.clear();
        this.indexKeyQueMap.clear();
        execService.shutdown();
        this.freeBufferQueue.clear();
        this.bufferSortService.shutdown();
        this.scratchFileWriterService.shutdown();
        timer.cancel();
    }

    private void phaseTwo() throws InterruptedException, JebException, ExecutionException {
        SecondPhaseProgressTask progress2Task = new SecondPhaseProgressTask(this.reader.getEntriesRead());
        Timer timer2 = new Timer();
        timer2.scheduleAtFixedRate((TimerTask)progress2Task, 10000L, 10000L);
        this.processIndexFiles();
        timer2.cancel();
    }

    private int getBufferCount(int dbThreads) {
        int buffers = 0;
        LinkedList<IndexManager> totList = new LinkedList<IndexManager>(this.DNIndexMgrList);
        totList.addAll(this.indexMgrList);
        Collections.sort(totList, Collections.reverseOrder());
        int limit = Math.min(dbThreads, totList.size());
        for (int i = 0; i < limit; ++i) {
            buffers += ((IndexManager)totList.get(i)).getBufferList().size();
        }
        return buffers;
    }

    private void processIndexFiles() throws InterruptedException, JebException, ExecutionException {
        if (this.bufferCount.get() == 0) {
            return;
        }
        int dbThreads = Runtime.getRuntime().availableProcessors();
        if (dbThreads < 4) {
            dbThreads = 4;
        }
        int readAheadSize = this.cacheSizeFromFreeMemory(this.getBufferCount(dbThreads));
        LinkedList<Future<Void>> futures = new LinkedList<Future<Void>>();
        ExecutorService dbService = Executors.newFixedThreadPool(dbThreads);
        for (IndexManager indexManager : this.DNIndexMgrList) {
            futures.add(dbService.submit(new IndexDBWriteTask(indexManager, readAheadSize)));
        }
        for (IndexManager indexManager : this.indexMgrList) {
            futures.add(dbService.submit(new IndexDBWriteTask(indexManager, readAheadSize)));
        }
        for (Future future : futures) {
            if (future.isDone()) continue;
            future.get();
        }
        dbService.shutdown();
    }

    private int cacheSizeFromFreeMemory(int buffers) {
        long availableMemory;
        int averageBufferSize;
        int cacheSize;
        Runtime runTime = Runtime.getRuntime();
        runTime.gc();
        runTime.gc();
        long freeMemory = runTime.freeMemory();
        long maxMemory = runTime.maxMemory();
        long totMemory = runTime.totalMemory();
        long totFreeMemory = freeMemory + (maxMemory - totMemory);
        int importMemPct = 55;
        if (totFreeMemory <= 0x10000000L) {
            importMemPct -= 35;
        }
        if ((cacheSize = Math.max(2048, averageBufferSize = (int)((availableMemory = totFreeMemory * (long)importMemPct / 100L) / (long)buffers))) > this.bufferSize) {
            cacheSize = this.bufferSize;
        }
        Message message = JebMessages.NOTE_JEB_IMPORT_LDIF_PHASE_TWO_MEM_REPORT.get(availableMemory, cacheSize, buffers);
        ErrorLogger.logError(message);
        return cacheSize;
    }

    private void stopScratchFileWriters() {
        IndexBuffer indexBuffer = IndexBuffer.createIndexBuffer(0);
        for (ScratchFileWriterTask task : this.scratchFileWriterList) {
            task.queue.add(indexBuffer);
        }
    }

    static /* synthetic */ int access$2700(Importer x0) {
        return x0.bufferSize;
    }

    static {
        dnComparator = new IndexBuffer.DNComparator();
        indexComparator = new IndexBuffer.IndexComparator();
        dnType = DirectoryServer.getAttributeType("dn");
        if (dnType == null) {
            dnType = DirectoryServer.getDefaultAttributeType("dn");
        }
    }

    public class DefaultExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        public void uncaughtException(Thread t, Throwable e) {
            Message message = JebMessages.ERR_JEB_IMPORT_UNCAUGHT_EXCEPTION.get(e.getMessage());
            ErrorLogger.logError(message);
            e.printStackTrace();
            System.exit(1);
        }
    }

    public final class TmpEnv
    implements DNCache {
        private String envPath;
        private Environment environment;
        private static final String DB_NAME = "dn_cache";
        private Database dnCache;
        private static final long FNV_INIT = -3750763034362895579L;
        private static final long FNV_PRIME = 1099511628211L;

        public TmpEnv(File envPath) throws DatabaseException {
            EnvironmentConfig envConfig = new EnvironmentConfig();
            envConfig.setConfigParam("je.env.runCleaner", "true");
            envConfig.setReadOnly(false);
            envConfig.setAllowCreate(true);
            envConfig.setTransactional(false);
            envConfig.setConfigParam("je.env.isLocking", "true");
            envConfig.setConfigParam("je.env.runCheckpointer", "false");
            envConfig.setConfigParam("je.evictor.lruOnly", "false");
            envConfig.setConfigParam("je.evictor.nodesPerScan", "128");
            envConfig.setConfigParam("je.maxMemory", Long.toString(Importer.this.tmpEnvCacheSize));
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setAllowCreate(true);
            dbConfig.setTransactional(false);
            dbConfig.setTemporary(true);
            this.environment = new Environment(envPath, envConfig);
            this.dnCache = this.environment.openDatabase(null, DB_NAME, dbConfig);
            this.envPath = envPath.getPath();
        }

        private byte[] hashCode(byte[] b) {
            long hash = -3750763034362895579L;
            for (int i = 0; i < b.length; ++i) {
                hash ^= (long)b[i];
                hash *= 1099511628211L;
            }
            return JebFormat.entryIDToDatabase(hash);
        }

        public void shutdown() throws JebException {
            this.dnCache.close();
            this.environment.close();
            EnvManager.removeFiles(this.envPath);
        }

        public boolean insert(DN dn, DatabaseEntry val, DatabaseEntry key) throws JebException {
            byte[] dnBytes = StaticUtils.getBytes(dn.toNormalizedString());
            int len = PackedInteger.getWriteIntLength((int)dnBytes.length);
            byte[] dataBytes = new byte[dnBytes.length + len];
            int pos = PackedInteger.writeInt((byte[])dataBytes, (int)0, (int)dnBytes.length);
            System.arraycopy(dnBytes, 0, dataBytes, pos, dnBytes.length);
            val.setData(dataBytes);
            key.setData(this.hashCode(dnBytes));
            return this.insert(key, val, dnBytes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean insert(DatabaseEntry key, DatabaseEntry val, byte[] dnBytes) throws JebException {
            boolean inserted = true;
            Cursor cursor = null;
            try {
                cursor = this.dnCache.openCursor(null, CursorConfig.DEFAULT);
                OperationStatus status = cursor.putNoOverwrite(key, val);
                if (status == OperationStatus.KEYEXIST) {
                    DatabaseEntry dns = new DatabaseEntry();
                    inserted = false;
                    status = cursor.getSearchKey(key, dns, LockMode.RMW);
                    if (status == OperationStatus.NOTFOUND) {
                        Message message = Message.raw(Category.JEB, Severity.SEVERE_ERROR, "Search DN cache failed.", new Object[0]);
                        throw new JebException(message);
                    }
                    if (!this.isDNMatched(dns, dnBytes)) {
                        this.addDN(dns, cursor, dnBytes);
                        inserted = true;
                    }
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            return inserted;
        }

        private void addDN(DatabaseEntry val, Cursor cursor, byte[] dnBytes) throws JebException {
            int pos = 0;
            byte[] bytes = val.getData();
            int pLen = PackedInteger.getWriteIntLength((int)dnBytes.length);
            int totLen = bytes.length + (pLen + dnBytes.length);
            byte[] newRec = new byte[totLen];
            System.arraycopy(bytes, 0, newRec, 0, bytes.length);
            pos = bytes.length;
            pos = PackedInteger.writeInt((byte[])newRec, (int)pos, (int)dnBytes.length);
            System.arraycopy(dnBytes, 0, newRec, pos, dnBytes.length);
            DatabaseEntry newVal = new DatabaseEntry(newRec);
            OperationStatus status = cursor.putCurrent(newVal);
            if (status != OperationStatus.SUCCESS) {
                Message message = Message.raw(Category.JEB, Severity.SEVERE_ERROR, "Add of DN to DN cache failed.", new Object[0]);
                throw new JebException(message);
            }
        }

        private boolean isDNMatched(DatabaseEntry dns, byte[] dnBytes) {
            int pLen;
            int len = 0;
            byte[] bytes = dns.getData();
            for (int pos = 0; pos < dns.getData().length; pos += pLen + len) {
                pLen = PackedInteger.getReadIntLength((byte[])bytes, (int)pos);
                len = PackedInteger.readInt((byte[])bytes, (int)pos);
                if (dnComparator.compare(bytes, pos + pLen, len, dnBytes, dnBytes.length) != 0) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(DN dn) {
            boolean dnExists = false;
            Cursor cursor = null;
            DatabaseEntry key = new DatabaseEntry();
            byte[] dnBytes = StaticUtils.getBytes(dn.toNormalizedString());
            key.setData(this.hashCode(dnBytes));
            try {
                cursor = this.dnCache.openCursor(null, CursorConfig.DEFAULT);
                DatabaseEntry dns = new DatabaseEntry();
                OperationStatus status = cursor.getSearchKey(key, dns, LockMode.DEFAULT);
                if (status == OperationStatus.SUCCESS) {
                    dnExists = this.isDNMatched(dns, dnBytes);
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            return dnExists;
        }

        public EnvironmentStats getEnvironmentStats(StatsConfig statsConfig) throws DatabaseException {
            return this.environment.getStats(statsConfig);
        }
    }

    public static interface DNCache {
        public boolean contains(DN var1) throws DatabaseException;
    }

    public class IndexKey {
        private final AttributeType attributeType;
        private final ImportIndexType indexType;
        private final int entryLimit;

        IndexKey(AttributeType attributeType, ImportIndexType indexType, int entryLimit) {
            this.attributeType = attributeType;
            this.indexType = indexType;
            this.entryLimit = entryLimit;
        }

        public boolean equals(Object obj) {
            IndexKey oKey;
            return obj instanceof IndexKey && this.attributeType.equals((oKey = (IndexKey)obj).getAttributeType()) && this.indexType.equals((Object)oKey.getIndexType());
        }

        public int hashCode() {
            return this.attributeType.hashCode() + this.indexType.hashCode();
        }

        public AttributeType getAttributeType() {
            return this.attributeType;
        }

        public ImportIndexType getIndexType() {
            return this.indexType;
        }

        public String getName() {
            return this.attributeType.getPrimaryName() + "." + StaticUtils.toLowerCase(this.indexType.name());
        }

        public int getEntryLimit() {
            return this.entryLimit;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImportIndexType {
        DN,
        EQUALITY,
        PRESENCE,
        SUBSTRING,
        ORDERING,
        APPROXIMATE,
        EX_SUBSTRING,
        EX_SHARED,
        VLV;

    }

    public class EntryInformation {
        private EntryID entryID;
        private Suffix suffix;

        public Suffix getSuffix() {
            return this.suffix;
        }

        public void setSuffix(Suffix suffix) {
            this.suffix = suffix;
        }

        public void setEntryID(EntryID entryID) {
            this.entryID = entryID;
        }

        public EntryID getEntryID() {
            return this.entryID;
        }
    }

    class SecondPhaseProgressTask
    extends TimerTask {
        private long previousCount = 0L;
        private long previousTime = System.currentTimeMillis();
        private EnvironmentStats previousStats;
        private boolean evicting = false;
        private long latestCount;

        public SecondPhaseProgressTask(long latestCount) {
            this.latestCount = latestCount;
            try {
                this.previousStats = Importer.this.rootContainer.getEnvironmentStats(new StatsConfig());
            }
            catch (DatabaseException e) {
                throw new RuntimeException(e);
            }
        }

        public void run() {
            long deltaCount = this.latestCount - this.previousCount;
            long latestTime = System.currentTimeMillis();
            long deltaTime = latestTime - this.previousTime;
            if (deltaTime == 0L) {
                return;
            }
            try {
                Runtime runTime = Runtime.getRuntime();
                long freeMemory = runTime.freeMemory() / 0x100000L;
                EnvironmentStats environmentStats = Importer.this.rootContainer.getEnvironmentStats(new StatsConfig());
                long nCacheMiss = environmentStats.getNCacheMiss() - this.previousStats.getNCacheMiss();
                float cacheMissRate = 0.0f;
                if (deltaCount > 0L) {
                    cacheMissRate = (float)nCacheMiss / (float)deltaCount;
                }
                Message message = JebMessages.NOTE_JEB_IMPORT_CACHE_AND_MEMORY_REPORT.get(freeMemory, Float.valueOf(cacheMissRate));
                ErrorLogger.logError(message);
                long evictPasses = environmentStats.getNEvictPasses();
                long evictNodes = environmentStats.getNNodesExplicitlyEvicted();
                long evictBinsStrip = environmentStats.getNBINsStripped();
                long cleanerRuns = environmentStats.getNCleanerRuns();
                long cleanerDeletions = environmentStats.getNCleanerDeletions();
                long cleanerEntriesRead = environmentStats.getNCleanerEntriesRead();
                long cleanerINCleaned = environmentStats.getNINsCleaned();
                long checkPoints = environmentStats.getNCheckpoints();
                if (evictPasses != 0L) {
                    if (!this.evicting) {
                        this.evicting = true;
                    }
                    message = JebMessages.NOTE_JEB_IMPORT_LDIF_EVICTION_DETECTED_STATS.get(evictPasses, evictNodes, evictBinsStrip);
                    ErrorLogger.logError(message);
                }
                if (cleanerRuns != 0L) {
                    message = JebMessages.NOTE_JEB_IMPORT_LDIF_CLEANER_STATS.get(cleanerRuns, cleanerDeletions, cleanerEntriesRead, cleanerINCleaned);
                    ErrorLogger.logError(message);
                }
                if (checkPoints > 1L) {
                    message = JebMessages.NOTE_JEB_IMPORT_LDIF_BUFFER_CHECKPOINTS.get(checkPoints);
                    ErrorLogger.logError(message);
                }
                this.previousStats = environmentStats;
            }
            catch (DatabaseException e) {
                // empty catch block
            }
            this.previousCount = this.latestCount;
            this.previousTime = latestTime;
            for (IndexManager indexMgrDN : Importer.this.DNIndexMgrList) {
                indexMgrDN.printStats(deltaTime);
            }
            for (IndexManager indexMgr : Importer.this.indexMgrList) {
                indexMgr.printStats(deltaTime);
            }
        }
    }

    private final class FirstPhaseProgressTask
    extends TimerTask {
        private long previousCount = 0L;
        private long previousTime = System.currentTimeMillis();
        private EnvironmentStats previousStats;
        private boolean evicting = false;
        private long evictionEntryCount = 0L;

        public FirstPhaseProgressTask() {
            try {
                this.previousStats = Importer.this.rootContainer.getEnvironmentStats(new StatsConfig());
            }
            catch (DatabaseException e) {
                throw new RuntimeException(e);
            }
        }

        public void run() {
            long latestCount = Importer.this.reader.getEntriesRead() + 0L;
            long deltaCount = latestCount - this.previousCount;
            long latestTime = System.currentTimeMillis();
            long deltaTime = latestTime - this.previousTime;
            if (deltaTime == 0L) {
                return;
            }
            long entriesRead = Importer.this.reader.getEntriesRead();
            long entriesIgnored = Importer.this.reader.getEntriesIgnored();
            long entriesRejected = Importer.this.reader.getEntriesRejected();
            float rate = 1000.0f * (float)deltaCount / (float)deltaTime;
            Message message = JebMessages.NOTE_JEB_IMPORT_PROGRESS_REPORT.get(entriesRead, entriesIgnored, entriesRejected, 0, Float.valueOf(rate));
            ErrorLogger.logError(message);
            try {
                Runtime runTime = Runtime.getRuntime();
                long freeMemory = runTime.freeMemory() / 0x100000L;
                EnvironmentStats environmentStats = Importer.this.skipDNValidation ? Importer.this.rootContainer.getEnvironmentStats(new StatsConfig()) : Importer.this.tmpEnv.getEnvironmentStats(new StatsConfig());
                long nCacheMiss = environmentStats.getNCacheMiss() - this.previousStats.getNCacheMiss();
                float cacheMissRate = 0.0f;
                if (deltaCount > 0L) {
                    cacheMissRate = (float)nCacheMiss / (float)deltaCount;
                }
                message = JebMessages.NOTE_JEB_IMPORT_CACHE_AND_MEMORY_REPORT.get(freeMemory, Float.valueOf(cacheMissRate));
                ErrorLogger.logError(message);
                long evictPasses = environmentStats.getNEvictPasses();
                long evictNodes = environmentStats.getNNodesExplicitlyEvicted();
                long evictBinsStrip = environmentStats.getNBINsStripped();
                long cleanerRuns = environmentStats.getNCleanerRuns();
                long cleanerDeletions = environmentStats.getNCleanerDeletions();
                long cleanerEntriesRead = environmentStats.getNCleanerEntriesRead();
                long cleanerINCleaned = environmentStats.getNINsCleaned();
                long checkPoints = environmentStats.getNCheckpoints();
                if (evictPasses != 0L) {
                    if (!this.evicting) {
                        this.evicting = true;
                        this.evictionEntryCount = Importer.this.reader.getEntriesRead();
                        message = JebMessages.NOTE_JEB_IMPORT_LDIF_EVICTION_DETECTED.get(this.evictionEntryCount);
                        ErrorLogger.logError(message);
                    }
                    message = JebMessages.NOTE_JEB_IMPORT_LDIF_EVICTION_DETECTED_STATS.get(evictPasses, evictNodes, evictBinsStrip);
                    ErrorLogger.logError(message);
                }
                if (cleanerRuns != 0L) {
                    message = JebMessages.NOTE_JEB_IMPORT_LDIF_CLEANER_STATS.get(cleanerRuns, cleanerDeletions, cleanerEntriesRead, cleanerINCleaned);
                    ErrorLogger.logError(message);
                }
                if (checkPoints > 1L) {
                    message = JebMessages.NOTE_JEB_IMPORT_LDIF_BUFFER_CHECKPOINTS.get(checkPoints);
                    ErrorLogger.logError(message);
                }
                this.previousStats = environmentStats;
            }
            catch (DatabaseException e) {
                // empty catch block
            }
            this.previousCount = latestCount;
            this.previousTime = latestTime;
        }
    }

    class RebuildFirstPhaseProgressTask
    extends TimerTask {
        private long previousProcessed = 0L;
        private long previousTime = System.currentTimeMillis();
        private EnvironmentStats prevEnvStats;

        public RebuildFirstPhaseProgressTask() throws DatabaseException {
            this.prevEnvStats = Importer.this.rootContainer.getEnvironmentStats(new StatsConfig());
        }

        public void run() {
            long latestTime = System.currentTimeMillis();
            long deltaTime = latestTime - this.previousTime;
            if (deltaTime == 0L) {
                return;
            }
            long entriesProcessed = Importer.this.rebuildManager.getEntriesProcess();
            long deltaCount = entriesProcessed - this.previousProcessed;
            float rate = 1000.0f * (float)deltaCount / (float)deltaTime;
            float completed = 0.0f;
            if (Importer.this.rebuildManager.getTotEntries() > 0L) {
                completed = 100.0f * (float)entriesProcessed / (float)Importer.this.rebuildManager.getTotEntries();
            }
            Message message = JebMessages.NOTE_JEB_REBUILD_PROGRESS_REPORT.get(Float.valueOf(completed), entriesProcessed, Importer.this.rebuildManager.getTotEntries(), Float.valueOf(rate));
            ErrorLogger.logError(message);
            try {
                Runtime runtime = Runtime.getRuntime();
                long freeMemory = runtime.freeMemory() / 0x100000L;
                EnvironmentStats envStats = Importer.this.rootContainer.getEnvironmentStats(new StatsConfig());
                long nCacheMiss = envStats.getNCacheMiss() - this.prevEnvStats.getNCacheMiss();
                float cacheMissRate = 0.0f;
                if (deltaCount > 0L) {
                    cacheMissRate = (float)nCacheMiss / (float)deltaCount;
                }
                message = JebMessages.NOTE_JEB_REBUILD_CACHE_AND_MEMORY_REPORT.get(freeMemory, Float.valueOf(cacheMissRate));
                ErrorLogger.logError(message);
                this.prevEnvStats = envStats;
            }
            catch (DatabaseException e) {
                // empty catch block
            }
            this.previousProcessed = entriesProcessed;
            this.previousTime = latestTime;
        }
    }

    class RebuildIndexManager
    extends ImportTask {
        private final RebuildConfig rebuildConfig;
        private final LocalDBBackendCfg cfg;
        private final Map<IndexKey, Index> indexMap;
        private final Map<IndexKey, Collection<Index>> extensibleIndexMap;
        private final List<VLVIndex> vlvIndexes;
        private DN2ID dn2id;
        private DN2URI dn2uri;
        private long totalEntries;
        private final AtomicLong entriesProcessed;
        private Suffix suffix;
        private final boolean rebuildAll;
        private EntryContainer entryContainer;

        public RebuildIndexManager(RebuildConfig rebuildConfig, LocalDBBackendCfg cfg) {
            this.indexMap = new LinkedHashMap<IndexKey, Index>();
            this.extensibleIndexMap = new LinkedHashMap<IndexKey, Collection<Index>>();
            this.vlvIndexes = new LinkedList<VLVIndex>();
            this.dn2id = null;
            this.dn2uri = null;
            this.totalEntries = 0L;
            this.entriesProcessed = new AtomicLong(0L);
            this.suffix = null;
            this.rebuildConfig = rebuildConfig;
            this.cfg = cfg;
            this.rebuildAll = rebuildConfig.isRebuildAll();
        }

        public void initialize() throws ConfigException, InitializationException {
            this.entryContainer = Importer.this.rootContainer.getEntryContainer(this.rebuildConfig.getBaseDN());
            this.suffix = Suffix.createSuffixContext(this.entryContainer, null, null, null);
            if (this.suffix == null) {
                Message msg = JebMessages.ERR_JEB_REBUILD_SUFFIX_ERROR.get(this.rebuildConfig.getBaseDN().toString());
                throw new InitializationException(msg);
            }
        }

        public void printStartMessage() throws DatabaseException {
            StringBuilder sb = new StringBuilder();
            ArrayList<String> rebuildList = this.rebuildConfig.getRebuildList();
            for (String index : rebuildList) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(index);
            }
            this.totalEntries = this.suffix.getID2Entry().getRecordCount();
            Message message = JebMessages.NOTE_JEB_REBUILD_START.get(sb.toString(), this.totalEntries);
            if (this.rebuildAll) {
                message = JebMessages.NOTE_JEB_REBUILD_ALL_START.get(this.totalEntries);
            }
            ErrorLogger.logError(message);
        }

        public void printStopMessage(long startTime) {
            long finishTime = System.currentTimeMillis();
            long totalTime = finishTime - startTime;
            float rate = 0.0f;
            if (totalTime > 0L) {
                rate = 1000.0f * (float)this.entriesProcessed.get() / (float)totalTime;
            }
            Message message = JebMessages.NOTE_JEB_REBUILD_FINAL_STATUS.get(this.entriesProcessed.get(), totalTime / 1000L, Float.valueOf(rate));
            ErrorLogger.logError(message);
        }

        public Void call() throws Exception {
            ID2Entry id2entry = this.entryContainer.getID2Entry();
            Cursor cursor = id2entry.openCursor(null, CursorConfig.READ_COMMITTED);
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            LockMode lockMode = LockMode.DEFAULT;
            try {
                OperationStatus status = cursor.getFirst(key, data, lockMode);
                while (status == OperationStatus.SUCCESS) {
                    if (Importer.this.isPhaseOneCanceled) {
                        return null;
                    }
                    EntryID entryID = new EntryID(key);
                    Entry entry = ID2Entry.entryFromDatabase(ByteString.wrap(data.getData()), this.entryContainer.getRootContainer().getCompressedSchema());
                    this.processEntry(entry, entryID);
                    this.entriesProcessed.getAndIncrement();
                    status = cursor.getNext(key, data, lockMode);
                }
                this.flushIndexBuffers();
                cursor.close();
            }
            catch (Exception e) {
                Message message = JebMessages.ERR_JEB_IMPORT_LDIF_REBUILD_INDEX_TASK_ERR.get(e.getMessage());
                ErrorLogger.logError(message);
                Importer.this.isPhaseOneCanceled = true;
                throw e;
            }
            return null;
        }

        public void rebuldIndexes() throws DatabaseException, InterruptedException, ExecutionException, JebException {
            this.phaseOne();
            if (Importer.this.isPhaseOneCanceled) {
                throw new InterruptedException("Rebuild Index canceled.");
            }
            this.phaseTwo();
            if (this.rebuildAll) {
                this.setAllIndexesTrusted();
            } else {
                this.setRebuildListIndexesTrusted();
            }
        }

        private void setRebuildListIndexesTrusted() throws JebException {
            try {
                if (this.dn2id != null) {
                    EntryContainer ec = this.suffix.getEntryContainer();
                    ec.getID2Children().setTrusted(null, true);
                    ec.getID2Subtree().setTrusted(null, true);
                }
                if (!this.indexMap.isEmpty()) {
                    for (Map.Entry entry : this.indexMap.entrySet()) {
                        Index index = (Index)entry.getValue();
                        index.setTrusted(null, true);
                    }
                }
                if (!this.vlvIndexes.isEmpty()) {
                    for (VLVIndex vLVIndex : this.vlvIndexes) {
                        vLVIndex.setTrusted(null, true);
                    }
                }
                if (!this.extensibleIndexMap.isEmpty()) {
                    Collection<Index> collection;
                    Collection<Index> subIndexes = this.extensibleIndexMap.get("substring");
                    if (subIndexes != null) {
                        for (Index subIndex : subIndexes) {
                            subIndex.setTrusted(null, true);
                        }
                    }
                    if ((collection = this.extensibleIndexMap.get("shared")) != null) {
                        for (Index sharedIndex : collection) {
                            sharedIndex.setTrusted(null, true);
                        }
                    }
                }
            }
            catch (DatabaseException ex) {
                Message message = JebMessages.NOTE_JEB_IMPORT_LDIF_TRUSTED_FAILED.get(ex.getMessage());
                throw new JebException(message);
            }
        }

        private void setAllIndexesTrusted() throws JebException {
            try {
                this.suffix.setIndexesTrusted();
            }
            catch (DatabaseException ex) {
                Message message = JebMessages.NOTE_JEB_IMPORT_LDIF_TRUSTED_FAILED.get(ex.getMessage());
                throw new JebException(message);
            }
        }

        private void phaseOne() throws DatabaseException, InterruptedException, ExecutionException {
            if (this.rebuildAll) {
                this.clearAllIndexes();
            } else {
                this.clearRebuildListIndexes();
            }
            Importer.this.initializeIndexBuffers();
            RebuildFirstPhaseProgressTask progressTask = new RebuildFirstPhaseProgressTask();
            Timer timer = new Timer();
            timer.scheduleAtFixedRate((TimerTask)progressTask, 10000L, 10000L);
            Importer.this.scratchFileWriterService = Executors.newFixedThreadPool(2 * Importer.this.indexCount);
            Importer.this.bufferSortService = Executors.newFixedThreadPool(Importer.this.threadCount);
            ExecutorService rebuildIndexService = Executors.newFixedThreadPool(Importer.this.threadCount);
            ArrayList<RebuildIndexManager> tasks = new ArrayList<RebuildIndexManager>(Importer.this.threadCount);
            for (int i = 0; i < Importer.this.threadCount; ++i) {
                tasks.add(this);
            }
            List results = rebuildIndexService.invokeAll(tasks);
            for (Future<Object> result : results) {
                if (result.isDone()) continue;
                result.get();
            }
            Importer.this.stopScratchFileWriters();
            for (Future<Object> result : Importer.this.scratchFileWriterFutures) {
                if (result.isDone()) continue;
                result.get();
            }
            tasks.clear();
            results.clear();
            rebuildIndexService.shutdown();
            Importer.this.freeBufferQueue.clear();
            Importer.this.bufferSortService.shutdown();
            Importer.this.scratchFileWriterService.shutdown();
            timer.cancel();
        }

        private void phaseTwo() throws InterruptedException, JebException, ExecutionException {
            SecondPhaseProgressTask progressTask = new SecondPhaseProgressTask(this.entriesProcessed.get());
            Timer timer2 = new Timer();
            timer2.scheduleAtFixedRate((TimerTask)progressTask, 10000L, 10000L);
            Importer.this.processIndexFiles();
            timer2.cancel();
        }

        private int getIndexCount() throws ConfigException, JebException {
            int indexCount = !this.rebuildAll ? this.getRebuildListIndexCount(this.cfg) : this.getAllIndexesCount(this.cfg);
            return indexCount;
        }

        private int getAllIndexesCount(LocalDBBackendCfg cfg) {
            int indexCount = cfg.listLocalDBIndexes().length;
            indexCount += cfg.listLocalDBVLVIndexes().length;
            return indexCount += 4;
        }

        private int getRebuildListIndexCount(LocalDBBackendCfg cfg) throws JebException, ConfigException {
            int indexCount = 0;
            ArrayList<String> rebuildList = this.rebuildConfig.getRebuildList();
            if (!rebuildList.isEmpty()) {
                for (String index : rebuildList) {
                    Message msg;
                    String lowerName = index.toLowerCase();
                    if (lowerName.equals("dn2id")) {
                        indexCount += 3;
                        continue;
                    }
                    if (lowerName.equals("dn2uri")) {
                        ++indexCount;
                        continue;
                    }
                    if (lowerName.startsWith("vlv.")) {
                        if (lowerName.length() < 5) {
                            msg = JebMessages.ERR_JEB_VLV_INDEX_NOT_CONFIGURED.get(lowerName);
                            throw new JebException(msg);
                        }
                        ++indexCount;
                        continue;
                    }
                    if (lowerName.equals("id2subtree") || lowerName.equals("id2children")) {
                        msg = JebMessages.ERR_JEB_ATTRIBUTE_INDEX_NOT_CONFIGURED.get(index);
                        throw new JebException(msg);
                    }
                    String[] attrIndexParts = lowerName.split("\\.");
                    if (attrIndexParts.length <= 0 || attrIndexParts.length > 3) {
                        Message msg2 = JebMessages.ERR_JEB_ATTRIBUTE_INDEX_NOT_CONFIGURED.get(index);
                        throw new JebException(msg2);
                    }
                    AttributeType attrType = DirectoryServer.getAttributeType(attrIndexParts[0]);
                    if (attrType == null) {
                        Message msg3 = JebMessages.ERR_JEB_ATTRIBUTE_INDEX_NOT_CONFIGURED.get(index);
                        throw new JebException(msg3);
                    }
                    if (attrIndexParts.length != 1) {
                        if (attrIndexParts.length == 2) {
                            if (attrIndexParts[1].equals("presence")) {
                                ++indexCount;
                                continue;
                            }
                            if (attrIndexParts[1].equals("equality")) {
                                ++indexCount;
                                continue;
                            }
                            if (attrIndexParts[1].equals("substring")) {
                                ++indexCount;
                                continue;
                            }
                            if (attrIndexParts[1].equals("ordering")) {
                                ++indexCount;
                                continue;
                            }
                            if (attrIndexParts[1].equals("approximate")) {
                                ++indexCount;
                                continue;
                            }
                            Message msg4 = JebMessages.ERR_JEB_ATTRIBUTE_INDEX_NOT_CONFIGURED.get(index);
                            throw new JebException(msg4);
                        }
                        boolean found = false;
                        String s = attrIndexParts[1] + "." + attrIndexParts[2];
                        for (String idx : cfg.listLocalDBIndexes()) {
                            LocalDBIndexCfg indexCfg = cfg.getLocalDBIndex(idx);
                            if (indexCfg.getIndexType().contains((Object)LocalDBIndexCfgDefn.IndexType.EXTENSIBLE)) {
                                SortedSet<String> extensibleRules = indexCfg.getIndexExtensibleMatchingRule();
                                for (String exRule : extensibleRules) {
                                    if (!exRule.equalsIgnoreCase(s)) continue;
                                    found = true;
                                    break;
                                }
                            }
                            if (found) break;
                        }
                        if (!found) {
                            Message msg5 = JebMessages.ERR_JEB_ATTRIBUTE_INDEX_NOT_CONFIGURED.get(index);
                            throw new JebException(msg5);
                        }
                        ++indexCount;
                        continue;
                    }
                    for (String idx : cfg.listLocalDBIndexes()) {
                        if (!idx.equalsIgnoreCase(index)) continue;
                        LocalDBIndexCfg indexCfg = cfg.getLocalDBIndex(idx);
                        if (indexCfg.getIndexType().contains((Object)LocalDBIndexCfgDefn.IndexType.EQUALITY)) {
                            ++indexCount;
                        }
                        if (indexCfg.getIndexType().contains((Object)LocalDBIndexCfgDefn.IndexType.ORDERING)) {
                            ++indexCount;
                        }
                        if (indexCfg.getIndexType().contains((Object)LocalDBIndexCfgDefn.IndexType.PRESENCE)) {
                            ++indexCount;
                        }
                        if (indexCfg.getIndexType().contains((Object)LocalDBIndexCfgDefn.IndexType.SUBSTRING)) {
                            ++indexCount;
                        }
                        if (indexCfg.getIndexType().contains((Object)LocalDBIndexCfgDefn.IndexType.APPROXIMATE)) {
                            ++indexCount;
                        }
                        if (!indexCfg.getIndexType().contains((Object)LocalDBIndexCfgDefn.IndexType.EXTENSIBLE)) continue;
                        SortedSet<String> extensibleRules = indexCfg.getIndexExtensibleMatchingRule();
                        boolean shared = false;
                        for (String exRule : extensibleRules) {
                            if (exRule.endsWith(".sub")) {
                                ++indexCount;
                                continue;
                            }
                            if (shared) continue;
                            shared = true;
                            ++indexCount;
                        }
                    }
                }
            }
            return indexCount;
        }

        private void clearRebuildListIndexes() throws DatabaseException {
            ArrayList<String> rebuildList = this.rebuildConfig.getRebuildList();
            if (!rebuildList.isEmpty()) {
                block0: for (String index : rebuildList) {
                    String lowerName = index.toLowerCase();
                    if (lowerName.equals("dn2id")) {
                        this.clearDN2IDIndexes();
                        continue;
                    }
                    if (lowerName.equals("dn2uri")) {
                        this.clearDN2URI();
                        continue;
                    }
                    if (lowerName.startsWith("vlv.")) {
                        this.clearVLVIndex(lowerName.substring(4));
                        continue;
                    }
                    String[] attrIndexParts = lowerName.split("\\.");
                    AttributeType attrType = DirectoryServer.getAttributeType(attrIndexParts[0]);
                    AttributeIndex attrIndex = this.entryContainer.getAttributeIndex(attrType);
                    if (attrIndexParts.length != 1) {
                        Collection<Index> sharedIndexes;
                        Collection<Index> subIndexes;
                        IndexKey indexKey;
                        Index partialAttrIndex;
                        if (attrIndexParts[1].equals("presence")) {
                            partialAttrIndex = attrIndex.getPresenceIndex();
                            int id = System.identityHashCode(partialAttrIndex);
                            Importer.this.idContainerMap.putIfAbsent(id, partialAttrIndex);
                            this.entryContainer.clearDatabase(partialAttrIndex);
                            indexKey = new IndexKey(attrType, ImportIndexType.PRESENCE, partialAttrIndex.getIndexEntryLimit());
                            this.indexMap.put(indexKey, partialAttrIndex);
                            continue;
                        }
                        if (attrIndexParts[1].equals("equality")) {
                            partialAttrIndex = attrIndex.getEqualityIndex();
                            int id = System.identityHashCode(partialAttrIndex);
                            Importer.this.idContainerMap.putIfAbsent(id, partialAttrIndex);
                            this.entryContainer.clearDatabase(partialAttrIndex);
                            indexKey = new IndexKey(attrType, ImportIndexType.EQUALITY, partialAttrIndex.getIndexEntryLimit());
                            this.indexMap.put(indexKey, partialAttrIndex);
                            continue;
                        }
                        if (attrIndexParts[1].equals("substring")) {
                            partialAttrIndex = attrIndex.getSubstringIndex();
                            int id = System.identityHashCode(partialAttrIndex);
                            Importer.this.idContainerMap.putIfAbsent(id, partialAttrIndex);
                            this.entryContainer.clearDatabase(partialAttrIndex);
                            indexKey = new IndexKey(attrType, ImportIndexType.SUBSTRING, partialAttrIndex.getIndexEntryLimit());
                            this.indexMap.put(indexKey, partialAttrIndex);
                            continue;
                        }
                        if (attrIndexParts[1].equals("ordering")) {
                            partialAttrIndex = attrIndex.getOrderingIndex();
                            int id = System.identityHashCode(partialAttrIndex);
                            Importer.this.idContainerMap.putIfAbsent(id, partialAttrIndex);
                            this.entryContainer.clearDatabase(partialAttrIndex);
                            indexKey = new IndexKey(attrType, ImportIndexType.ORDERING, partialAttrIndex.getIndexEntryLimit());
                            this.indexMap.put(indexKey, partialAttrIndex);
                            continue;
                        }
                        if (attrIndexParts[1].equals("approximate")) {
                            partialAttrIndex = attrIndex.getApproximateIndex();
                            int id = System.identityHashCode(partialAttrIndex);
                            Importer.this.idContainerMap.putIfAbsent(id, partialAttrIndex);
                            this.entryContainer.clearDatabase(partialAttrIndex);
                            indexKey = new IndexKey(attrType, ImportIndexType.APPROXIMATE, partialAttrIndex.getIndexEntryLimit());
                            this.indexMap.put(indexKey, partialAttrIndex);
                            continue;
                        }
                        String dbPart = "shared";
                        if (attrIndexParts[2].startsWith("sub")) {
                            dbPart = "substring";
                        }
                        StringBuilder nameBldr = new StringBuilder();
                        nameBldr.append(this.entryContainer.getDatabasePrefix());
                        nameBldr.append("_");
                        nameBldr.append(attrIndexParts[0]);
                        nameBldr.append(".");
                        nameBldr.append(attrIndexParts[1]);
                        nameBldr.append(".");
                        nameBldr.append(dbPart);
                        String indexName = nameBldr.toString();
                        Map<String, Collection<Index>> extensibleMap = attrIndex.getExtensibleIndexes();
                        if (extensibleMap.isEmpty() || (subIndexes = attrIndex.getExtensibleIndexes().get("substring")) == null) continue;
                        for (Index subIndex : subIndexes) {
                            String name = subIndex.getName();
                            if (!name.equalsIgnoreCase(indexName)) continue;
                            this.entryContainer.clearDatabase(subIndex);
                            int id = System.identityHashCode(subIndex);
                            Importer.this.idContainerMap.putIfAbsent(id, subIndex);
                            ArrayList<Index> substring = new ArrayList<Index>();
                            substring.add(subIndex);
                            this.extensibleIndexMap.put(new IndexKey(attrType, ImportIndexType.EX_SUBSTRING, 0), substring);
                            break;
                        }
                        if ((sharedIndexes = attrIndex.getExtensibleIndexes().get("shared")) == null) continue;
                        for (Index sharedIndex : sharedIndexes) {
                            String name = sharedIndex.getName();
                            if (!name.equalsIgnoreCase(indexName)) continue;
                            this.entryContainer.clearDatabase(sharedIndex);
                            ArrayList<Index> shared = new ArrayList<Index>();
                            int id = System.identityHashCode(sharedIndex);
                            Importer.this.idContainerMap.putIfAbsent(id, sharedIndex);
                            shared.add(sharedIndex);
                            this.extensibleIndexMap.put(new IndexKey(attrType, ImportIndexType.EX_SHARED, 0), shared);
                            continue block0;
                        }
                        continue;
                    }
                    this.clearAttributeIndexes(attrIndex, attrType);
                }
            }
        }

        private void clearAllIndexes() throws DatabaseException {
            for (Map.Entry<AttributeType, AttributeIndex> mapEntry : this.suffix.getAttrIndexMap().entrySet()) {
                AttributeType attributeType = mapEntry.getKey();
                AttributeIndex attributeIndex = mapEntry.getValue();
                this.clearAttributeIndexes(attributeIndex, attributeType);
            }
            for (VLVIndex vlvIndex : this.suffix.getEntryContainer().getVLVIndexes()) {
                this.entryContainer.clearDatabase(vlvIndex);
            }
            this.clearDN2IDIndexes();
            if (this.entryContainer.getDN2URI() != null) {
                this.clearDN2URI();
            }
        }

        private void clearVLVIndex(String name) throws DatabaseException {
            VLVIndex vlvIndex = this.entryContainer.getVLVIndex(name);
            this.entryContainer.clearDatabase(vlvIndex);
            this.vlvIndexes.add(vlvIndex);
        }

        private void clearDN2URI() throws DatabaseException {
            this.entryContainer.clearDatabase(this.entryContainer.getDN2URI());
            this.dn2uri = this.entryContainer.getDN2URI();
        }

        private void clearDN2IDIndexes() throws DatabaseException {
            this.entryContainer.clearDatabase(this.entryContainer.getDN2ID());
            this.entryContainer.clearDatabase(this.entryContainer.getID2Children());
            this.entryContainer.clearDatabase(this.entryContainer.getID2Subtree());
            this.dn2id = this.entryContainer.getDN2ID();
        }

        private void clearAttributeIndexes(AttributeIndex attrIndex, AttributeType attrType) throws DatabaseException {
            Map<String, Collection<Index>> extensibleMap;
            IndexKey indexKey;
            int id;
            Index partialAttrIndex;
            if (attrIndex.getSubstringIndex() != null) {
                partialAttrIndex = attrIndex.getSubstringIndex();
                id = System.identityHashCode(partialAttrIndex);
                Importer.this.idContainerMap.putIfAbsent(id, partialAttrIndex);
                this.entryContainer.clearDatabase(partialAttrIndex);
                indexKey = new IndexKey(attrType, ImportIndexType.SUBSTRING, partialAttrIndex.getIndexEntryLimit());
                this.indexMap.put(indexKey, partialAttrIndex);
            }
            if (attrIndex.getOrderingIndex() != null) {
                partialAttrIndex = attrIndex.getOrderingIndex();
                id = System.identityHashCode(partialAttrIndex);
                Importer.this.idContainerMap.putIfAbsent(id, partialAttrIndex);
                this.entryContainer.clearDatabase(partialAttrIndex);
                indexKey = new IndexKey(attrType, ImportIndexType.ORDERING, partialAttrIndex.getIndexEntryLimit());
                this.indexMap.put(indexKey, partialAttrIndex);
            }
            if (attrIndex.getEqualityIndex() != null) {
                partialAttrIndex = attrIndex.getEqualityIndex();
                id = System.identityHashCode(partialAttrIndex);
                Importer.this.idContainerMap.putIfAbsent(id, partialAttrIndex);
                this.entryContainer.clearDatabase(partialAttrIndex);
                indexKey = new IndexKey(attrType, ImportIndexType.EQUALITY, partialAttrIndex.getIndexEntryLimit());
                this.indexMap.put(indexKey, partialAttrIndex);
            }
            if (attrIndex.getPresenceIndex() != null) {
                partialAttrIndex = attrIndex.getPresenceIndex();
                id = System.identityHashCode(partialAttrIndex);
                Importer.this.idContainerMap.putIfAbsent(id, partialAttrIndex);
                this.entryContainer.clearDatabase(partialAttrIndex);
                indexKey = new IndexKey(attrType, ImportIndexType.PRESENCE, partialAttrIndex.getIndexEntryLimit());
                this.indexMap.put(indexKey, partialAttrIndex);
            }
            if (attrIndex.getApproximateIndex() != null) {
                partialAttrIndex = attrIndex.getApproximateIndex();
                id = System.identityHashCode(partialAttrIndex);
                Importer.this.idContainerMap.putIfAbsent(id, partialAttrIndex);
                this.entryContainer.clearDatabase(partialAttrIndex);
                indexKey = new IndexKey(attrType, ImportIndexType.APPROXIMATE, partialAttrIndex.getIndexEntryLimit());
                this.indexMap.put(indexKey, partialAttrIndex);
            }
            if (!(extensibleMap = attrIndex.getExtensibleIndexes()).isEmpty()) {
                Collection<Index> sharedIndexes;
                Collection<Index> subIndexes = attrIndex.getExtensibleIndexes().get("substring");
                if (subIndexes != null) {
                    for (Index subIndex : subIndexes) {
                        this.entryContainer.clearDatabase(subIndex);
                        int id2 = System.identityHashCode(subIndex);
                        Importer.this.idContainerMap.putIfAbsent(id2, subIndex);
                    }
                    this.extensibleIndexMap.put(new IndexKey(attrType, ImportIndexType.EX_SUBSTRING, 0), subIndexes);
                }
                if ((sharedIndexes = attrIndex.getExtensibleIndexes().get("shared")) != null) {
                    for (Index sharedIndex : sharedIndexes) {
                        this.entryContainer.clearDatabase(sharedIndex);
                        int id3 = System.identityHashCode(sharedIndex);
                        Importer.this.idContainerMap.putIfAbsent(id3, sharedIndex);
                    }
                    this.extensibleIndexMap.put(new IndexKey(attrType, ImportIndexType.EX_SHARED, 0), sharedIndexes);
                }
            }
        }

        private void processEntry(Entry entry, EntryID entryID) throws DatabaseException, ConfigException, DirectoryException, JebException, InterruptedException {
            if (this.dn2id != null) {
                this.processDN2ID(this.suffix, entry.getDN(), entryID);
            }
            if (this.dn2uri != null) {
                this.processDN2URI(this.suffix, null, entry);
            }
            this.processIndexes(entry, entryID);
            this.processExtensibleIndexes(entry, entryID);
            this.processVLVIndexes(entry, entryID);
        }

        private void processVLVIndexes(Entry entry, EntryID entryID) throws DatabaseException, JebException, DirectoryException {
            for (VLVIndex vlvIdx : this.suffix.getEntryContainer().getVLVIndexes()) {
                Transaction transaction = null;
                vlvIdx.addEntry(transaction, entryID, entry);
            }
        }

        private void processExtensibleIndexes(Entry entry, EntryID entryID) throws DatabaseException, DirectoryException, JebException, ConfigException, InterruptedException {
            for (Map.Entry<IndexKey, Collection<Index>> mapEntry : this.extensibleIndexMap.entrySet()) {
                IndexKey key = mapEntry.getKey();
                AttributeType attrType = key.getAttributeType();
                if (!entry.hasAttribute(attrType)) continue;
                Collection<Index> indexes = mapEntry.getValue();
                for (Index index : indexes) {
                    this.processAttribute(index, entry, entryID, key);
                }
            }
        }

        private void processIndexes(Entry entry, EntryID entryID) throws DatabaseException, DirectoryException, JebException, ConfigException, InterruptedException {
            for (Map.Entry<IndexKey, Index> mapEntry : this.indexMap.entrySet()) {
                IndexKey key = mapEntry.getKey();
                AttributeType attrType = key.getAttributeType();
                if (!entry.hasAttribute(attrType)) continue;
                ImportIndexType indexType = key.getIndexType();
                Index index = mapEntry.getValue();
                if (indexType == ImportIndexType.SUBSTRING) {
                    this.processAttribute(index, entry, entryID, new IndexKey(attrType, ImportIndexType.SUBSTRING, index.getIndexEntryLimit()));
                    continue;
                }
                this.processAttribute(index, entry, entryID, new IndexKey(attrType, indexType, index.getIndexEntryLimit()));
            }
        }

        public long getEntriesProcess() {
            return this.entriesProcessed.get();
        }

        public long getTotEntries() {
            return this.totalEntries;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class IndexManager
    implements Comparable<IndexManager> {
        private final File file;
        private RandomAccessFile rFile = null;
        private final List<Buffer> bufferList = new LinkedList<Buffer>();
        private long fileLength;
        private long bytesRead = 0L;
        private boolean done = false;
        private boolean started = false;
        private long totalDNS;
        private AtomicInteger keyCount = new AtomicInteger(0);
        private final String fileName;
        private final boolean isDN;
        private final int limit;

        IndexManager(String fileName, boolean isDN, int limit) {
            this.file = new File(Importer.this.tempDir, fileName);
            this.fileName = fileName;
            this.isDN = isDN;
            this.limit = limit;
        }

        void openIndexFile() throws FileNotFoundException {
            this.rFile = new RandomAccessFile(this.file, "r");
        }

        public FileChannel getChannel() {
            return this.rFile.getChannel();
        }

        public void addBuffer(Buffer o) {
            this.bufferList.add(o);
        }

        public List<Buffer> getBufferList() {
            return this.bufferList;
        }

        public File getFile() {
            return this.file;
        }

        public boolean deleteIndexFile() {
            return this.file.delete();
        }

        public void close() throws IOException {
            this.rFile.close();
        }

        public void setFileLength() {
            this.fileLength = this.file.length();
        }

        public void addBytesRead(int bytesRead) {
            this.bytesRead += (long)bytesRead;
        }

        public void setDone() {
            this.done = true;
        }

        public void setStarted() {
            this.started = true;
        }

        public void addTotDNCount(int delta) {
            this.totalDNS += (long)delta;
        }

        public long getDNCount() {
            return this.totalDNS;
        }

        public boolean isDN2ID() {
            return this.isDN;
        }

        public void printStats(long deltaTime) {
            if (!this.done && this.started) {
                float rate = 1000.0f * (float)this.keyCount.getAndSet(0) / (float)deltaTime;
                Message message = JebMessages.NOTE_JEB_IMPORT_LDIF_PHASE_TWO_REPORT.get(this.fileName, this.fileLength - this.bytesRead, Float.valueOf(rate));
                ErrorLogger.logError(message);
            }
        }

        public void incrementKeyCount() {
            this.keyCount.incrementAndGet();
        }

        public String getFileName() {
            return this.fileName;
        }

        public int getLimit() {
            return this.limit;
        }

        @Override
        public int compareTo(IndexManager mgr) {
            if (this.bufferList.size() == mgr.getBufferList().size()) {
                return 0;
            }
            if (this.bufferList.size() < mgr.getBufferList().size()) {
                return -1;
            }
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Buffer
    implements Comparable<Buffer> {
        private IndexManager indexMgr;
        private final long begin;
        private final long end;
        private final long id;
        private long offset;
        private ByteBuffer cache;
        private int limit;
        private ImportIDSet insertIDSet = null;
        private ImportIDSet deleteIDSet = null;
        private Integer indexID = null;
        private boolean doCount;
        private ByteBuffer keyBuf = ByteBuffer.allocate(128);

        public Buffer(long begin, long end, long id) {
            this.begin = begin;
            this.end = end;
            this.offset = 0L;
            this.id = id;
        }

        private void initializeCache(IndexManager indexMgr, ByteBuffer b, long cacheSize) throws IOException {
            this.indexMgr = indexMgr;
            this.cache = b == null ? ByteBuffer.allocate((int)cacheSize) : b;
            this.loadCache();
            this.cache.flip();
            this.keyBuf.flip();
        }

        private void loadCache() throws IOException {
            long bytesToRead;
            FileChannel fileChannel = this.indexMgr.getChannel();
            fileChannel.position(this.begin + this.offset);
            long leftToRead = this.end - (this.begin + this.offset);
            if (leftToRead < (long)this.cache.remaining()) {
                this.cache.limit((int)((long)this.cache.position() + leftToRead));
                bytesToRead = (int)leftToRead;
            } else {
                bytesToRead = Math.min(this.end - this.offset, (long)this.cache.remaining());
            }
            int bytesRead = 0;
            while ((long)bytesRead < bytesToRead) {
                bytesRead += fileChannel.read(this.cache);
            }
            this.offset += (long)bytesRead;
            this.indexMgr.addBytesRead(bytesRead);
        }

        public boolean hasMoreData() throws IOException {
            boolean ret;
            boolean bl = ret = this.begin + this.offset >= this.end;
            return this.cache.remaining() != 0 || !ret;
        }

        public int getKeyLen() {
            return this.keyBuf.limit();
        }

        public void getKey(ByteBuffer b) {
            this.keyBuf.get(b.array(), 0, this.keyBuf.limit());
            b.limit(this.keyBuf.limit());
        }

        ByteBuffer getKeyBuf() {
            return this.keyBuf;
        }

        public ImportIDSet getInsertIDSet() {
            return this.insertIDSet;
        }

        public ImportIDSet getDeleteIDSet() {
            return this.deleteIDSet;
        }

        public long getBufferID() {
            return this.id;
        }

        public Integer getIndexID() {
            if (this.indexID == null) {
                try {
                    this.getNextRecord();
                }
                catch (IOException ex) {
                    Message message = JebMessages.ERR_JEB_IO_ERROR.get(ex.getMessage());
                    ErrorLogger.logError(message);
                    ex.printStackTrace();
                    System.exit(1);
                }
            }
            return this.indexID;
        }

        public void getNextRecord() throws IOException {
            this.getNextIndexID();
            this.getContainerParameters();
            this.getNextKey();
            this.getNextIDSet(true);
            this.getNextIDSet(false);
        }

        private void getContainerParameters() {
            this.limit = 1;
            this.doCount = false;
            if (!this.indexMgr.isDN2ID()) {
                Index index = (Index)Importer.this.idContainerMap.get(this.indexID);
                this.limit = index.getIndexEntryLimit();
                this.doCount = index.getMaintainCount();
                if (this.insertIDSet == null) {
                    this.insertIDSet = new ImportIDSet(128, this.limit, this.doCount);
                    this.deleteIDSet = new ImportIDSet(128, this.limit, this.doCount);
                }
            } else if (this.insertIDSet == null) {
                this.insertIDSet = new ImportIDSet(1, this.limit, this.doCount);
                this.deleteIDSet = new ImportIDSet(1, this.limit, this.doCount);
            }
        }

        private int getInt() throws IOException {
            this.ensureData(4);
            return this.cache.getInt();
        }

        private void getNextIndexID() throws IOException, BufferUnderflowException {
            this.indexID = this.getInt();
        }

        private void getNextKey() throws IOException, BufferUnderflowException {
            this.ensureData(20);
            byte[] ba = this.cache.array();
            int p = this.cache.position();
            int len = PackedInteger.getReadIntLength((byte[])ba, (int)p);
            int keyLen = PackedInteger.readInt((byte[])ba, (int)p);
            this.cache.position(p + len);
            if (keyLen > this.keyBuf.capacity()) {
                this.keyBuf = ByteBuffer.allocate(keyLen);
            }
            this.ensureData(keyLen);
            this.keyBuf.clear();
            this.cache.get(this.keyBuf.array(), 0, keyLen);
            this.keyBuf.limit(keyLen);
        }

        private void getNextIDSet(boolean insert) throws IOException, BufferUnderflowException {
            this.ensureData(20);
            int p = this.cache.position();
            byte[] ba = this.cache.array();
            int len = PackedInteger.getReadIntLength((byte[])ba, (int)p);
            int keyCount = PackedInteger.readInt((byte[])ba, (int)p);
            this.cache.position(p += len);
            if (insert) {
                this.insertIDSet.clear(false);
            } else {
                this.deleteIDSet.clear(false);
            }
            for (int k = 0; k < keyCount; ++k) {
                if (this.ensureData(9)) {
                    p = this.cache.position();
                }
                len = PackedInteger.getReadLongLength((byte[])ba, (int)p);
                long l = PackedInteger.readLong((byte[])ba, (int)p);
                this.cache.position(p += len);
                if (insert) {
                    this.insertIDSet.addEntryID(l);
                    continue;
                }
                this.deleteIDSet.addEntryID(l);
            }
        }

        private boolean ensureData(int len) throws IOException {
            boolean ret = false;
            if (this.cache.remaining() == 0) {
                this.cache.clear();
                this.loadCache();
                this.cache.flip();
                ret = true;
            } else if (this.cache.remaining() < len) {
                this.cache.compact();
                this.loadCache();
                this.cache.flip();
                ret = true;
            }
            return ret;
        }

        private int compare(ByteBuffer cKey, Integer cIndexID) {
            int rc = 0;
            if (this.keyBuf.limit() == 0) {
                this.getIndexID();
            }
            int returnCode = (rc = this.indexMgr.isDN2ID() ? dnComparator.compare(this.keyBuf.array(), 0, this.keyBuf.limit(), cKey.array(), cKey.limit()) : indexComparator.compare(this.keyBuf.array(), 0, this.keyBuf.limit(), cKey.array(), cKey.limit())) != 0 ? 1 : (this.indexID.intValue() == cIndexID.intValue() ? 0 : 1);
            return returnCode;
        }

        @Override
        public int compareTo(Buffer o) {
            if (this.equals(o)) {
                return 0;
            }
            if (this.keyBuf.limit() == 0) {
                this.getIndexID();
            }
            if (o.getKeyBuf().limit() == 0) {
                o.getIndexID();
            }
            int returnCode = 0;
            byte[] oKey = o.getKeyBuf().array();
            int oLen = o.getKeyBuf().limit();
            returnCode = this.indexMgr.isDN2ID() ? dnComparator.compare(this.keyBuf.array(), 0, this.keyBuf.limit(), oKey, oLen) : indexComparator.compare(this.keyBuf.array(), 0, this.keyBuf.limit(), oKey, oLen);
            if (returnCode == 0) {
                returnCode = this.indexID.intValue() == o.getIndexID().intValue() ? (this.insertIDSet.isDefined() ? -1 : (o.getInsertIDSet().isDefined() ? 1 : (this.insertIDSet.size() == o.getInsertIDSet().size() ? (this.id > o.getBufferID() ? 1 : -1) : this.insertIDSet.size() - o.getInsertIDSet().size()))) : (this.indexID > o.getIndexID() ? 1 : -1);
            }
            return returnCode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SortTask
    implements Callable<Void> {
        private final IndexBuffer indexBuffer;

        public SortTask(IndexBuffer indexBuffer) {
            this.indexBuffer = indexBuffer;
        }

        @Override
        public Void call() throws Exception {
            if (Importer.this.importConfiguration != null && Importer.this.importConfiguration.isCancelled() || Importer.this.isPhaseOneCanceled) {
                Importer.this.isPhaseOneCanceled = true;
                return null;
            }
            this.indexBuffer.sort();
            if (Importer.this.indexKeyQueMap.containsKey(this.indexBuffer.getIndexKey())) {
                BlockingQueue q = (BlockingQueue)Importer.this.indexKeyQueMap.get(this.indexBuffer.getIndexKey());
                q.add(this.indexBuffer);
            } else {
                this.createIndexWriterTask(this.indexBuffer.getIndexKey());
                BlockingQueue q = (BlockingQueue)Importer.this.indexKeyQueMap.get(this.indexBuffer.getIndexKey());
                q.add(this.indexBuffer);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createIndexWriterTask(IndexKey indexKey) throws FileNotFoundException {
            boolean isDN = false;
            Object object = Importer.this.synObj;
            synchronized (object) {
                if (Importer.this.indexKeyQueMap.containsKey(indexKey)) {
                    return;
                }
                if (indexKey.getIndexType().equals((Object)ImportIndexType.DN)) {
                    isDN = true;
                }
                IndexManager indexMgr = new IndexManager(indexKey.getName(), isDN, indexKey.getEntryLimit());
                if (isDN) {
                    Importer.this.DNIndexMgrList.add(indexMgr);
                } else {
                    Importer.this.indexMgrList.add(indexMgr);
                }
                ArrayBlockingQueue<IndexBuffer> newQue = new ArrayBlockingQueue<IndexBuffer>(Importer.this.phaseOneBufferCount);
                ScratchFileWriterTask indexWriter = new ScratchFileWriterTask(newQue, indexMgr);
                Importer.this.scratchFileWriterList.add(indexWriter);
                Importer.this.scratchFileWriterFutures.add(Importer.this.scratchFileWriterService.submit(indexWriter));
                Importer.this.indexKeyQueMap.put(indexKey, newQue);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ScratchFileWriterTask
    implements Callable<Void> {
        private final int DRAIN_TO = 3;
        private final IndexManager indexMgr;
        private final BlockingQueue<IndexBuffer> queue;
        private final ByteArrayOutputStream insetByteStream = new ByteArrayOutputStream(2 * Importer.access$2700(Importer.this));
        private final ByteArrayOutputStream deleteByteStream = new ByteArrayOutputStream(2 * Importer.access$2700(Importer.this));
        private final byte[] tmpArray = new byte[8];
        private int insertKeyCount = 0;
        private int deleteKeyCount = 0;
        private final DataOutputStream dataStream;
        private long bufferCount = 0L;
        private final File file;
        private final SortedSet<IndexBuffer> indexSortedSet;
        private boolean poisonSeen = false;
        ByteBuffer keyBuf = ByteBuffer.allocate(128);

        public ScratchFileWriterTask(BlockingQueue<IndexBuffer> queue, IndexManager indexMgr) throws FileNotFoundException {
            this.queue = queue;
            this.file = indexMgr.getFile();
            this.indexMgr = indexMgr;
            BufferedOutputStream bufferedStream = new BufferedOutputStream(new FileOutputStream(this.file), 0x100000);
            this.dataStream = new DataOutputStream(bufferedStream);
            this.indexSortedSet = new TreeSet<IndexBuffer>();
        }

        @Override
        public Void call() throws Exception {
            long offset = 0L;
            LinkedList<IndexBuffer> l = new LinkedList<IndexBuffer>();
            try {
                while (true) {
                    long bufferLen;
                    IndexBuffer indexBuffer;
                    if ((indexBuffer = (IndexBuffer)this.queue.poll()) == null) {
                        continue;
                    }
                    long beginOffset = offset;
                    if (!this.queue.isEmpty()) {
                        this.queue.drainTo(l, 3);
                        l.add(indexBuffer);
                        bufferLen = this.writeIndexBuffers(l);
                        for (IndexBuffer id : l) {
                            if (id.isDiscard()) continue;
                            id.reset();
                            Importer.this.freeBufferQueue.add(id);
                        }
                        l.clear();
                    } else {
                        if (indexBuffer.isPoison()) {
                            break;
                        }
                        bufferLen = this.writeIndexBuffer(indexBuffer);
                        if (!indexBuffer.isDiscard()) {
                            indexBuffer.reset();
                            Importer.this.freeBufferQueue.add(indexBuffer);
                        }
                    }
                    this.indexMgr.addBuffer(new Buffer(beginOffset, offset += bufferLen, this.bufferCount));
                    ++this.bufferCount;
                    Importer.this.bufferCount.incrementAndGet();
                    if (this.poisonSeen) break;
                }
            }
            catch (Exception e) {
                Message message = JebMessages.ERR_JEB_IMPORT_LDIF_INDEX_FILEWRITER_ERR.get(this.file.getName(), e.getMessage());
                ErrorLogger.logError(message);
                Importer.this.isPhaseOneCanceled = true;
                throw e;
            }
            finally {
                this.dataStream.close();
                this.indexMgr.setFileLength();
            }
            return null;
        }

        private long writeIndexBuffer(IndexBuffer indexBuffer) throws IOException {
            int numberKeys = indexBuffer.getNumberKeys();
            indexBuffer.setPosition(-1);
            long bufferLen = 0L;
            this.insetByteStream.reset();
            this.insertKeyCount = 0;
            this.deleteByteStream.reset();
            this.deleteKeyCount = 0;
            for (int i = 0; i < numberKeys; ++i) {
                if (indexBuffer.getPosition() == -1) {
                    indexBuffer.setPosition(i);
                    if (indexBuffer.isInsert(i)) {
                        indexBuffer.writeID(this.insetByteStream, i);
                        ++this.insertKeyCount;
                        continue;
                    }
                    indexBuffer.writeID(this.deleteByteStream, i);
                    ++this.deleteKeyCount;
                    continue;
                }
                if (!indexBuffer.compare(i)) {
                    bufferLen += (long)this.writeRecord(indexBuffer);
                    indexBuffer.setPosition(i);
                    this.insetByteStream.reset();
                    this.insertKeyCount = 0;
                    this.deleteByteStream.reset();
                    this.deleteKeyCount = 0;
                }
                if (indexBuffer.isInsert(i)) {
                    if (this.insertKeyCount++ > this.indexMgr.getLimit()) continue;
                    indexBuffer.writeID(this.insetByteStream, i);
                    continue;
                }
                indexBuffer.writeID(this.deleteByteStream, i);
                ++this.deleteKeyCount;
            }
            if (indexBuffer.getPosition() != -1) {
                bufferLen += (long)this.writeRecord(indexBuffer);
            }
            return bufferLen;
        }

        private long writeIndexBuffers(List<IndexBuffer> buffers) throws IOException {
            long id = 0L;
            long bufferLen = 0L;
            this.insetByteStream.reset();
            this.insertKeyCount = 0;
            this.deleteByteStream.reset();
            this.deleteKeyCount = 0;
            for (IndexBuffer b : buffers) {
                if (b.isPoison()) {
                    this.poisonSeen = true;
                    continue;
                }
                b.setPosition(0);
                b.setID(id++);
                this.indexSortedSet.add(b);
            }
            byte[] saveKey = null;
            int saveIndexID = 0;
            while (!this.indexSortedSet.isEmpty()) {
                IndexBuffer b = this.indexSortedSet.first();
                this.indexSortedSet.remove(b);
                if (saveKey == null) {
                    saveKey = b.getKey();
                    saveIndexID = b.getIndexID();
                    if (b.isInsert(b.getPosition())) {
                        b.writeID(this.insetByteStream, b.getPosition());
                        ++this.insertKeyCount;
                    } else {
                        b.writeID(this.deleteByteStream, b.getPosition());
                        ++this.deleteKeyCount;
                    }
                } else if (!b.compare(saveKey, saveIndexID)) {
                    bufferLen += (long)this.writeRecord(saveKey, saveIndexID);
                    this.insetByteStream.reset();
                    this.deleteByteStream.reset();
                    this.insertKeyCount = 0;
                    this.deleteKeyCount = 0;
                    saveKey = b.getKey();
                    saveIndexID = b.getIndexID();
                    if (b.isInsert(b.getPosition())) {
                        b.writeID(this.insetByteStream, b.getPosition());
                        ++this.insertKeyCount;
                    } else {
                        b.writeID(this.deleteByteStream, b.getPosition());
                        ++this.deleteKeyCount;
                    }
                } else if (b.isInsert(b.getPosition())) {
                    if (this.insertKeyCount++ <= this.indexMgr.getLimit()) {
                        b.writeID(this.insetByteStream, b.getPosition());
                    }
                } else {
                    b.writeID(this.deleteByteStream, b.getPosition());
                    ++this.deleteKeyCount;
                }
                if (!b.hasMoreData()) continue;
                b.getNextRecord();
                this.indexSortedSet.add(b);
            }
            if (saveKey != null) {
                bufferLen += (long)this.writeRecord(saveKey, saveIndexID);
            }
            return bufferLen;
        }

        private int writeByteStreams() throws IOException {
            if (this.insertKeyCount > this.indexMgr.getLimit()) {
                this.insertKeyCount = 1;
                this.insetByteStream.reset();
                PackedInteger.writeInt((byte[])this.tmpArray, (int)0, (int)-1);
                this.insetByteStream.write(this.tmpArray, 0, 1);
            }
            int insertSize = PackedInteger.getWriteIntLength((int)this.insertKeyCount);
            PackedInteger.writeInt((byte[])this.tmpArray, (int)0, (int)this.insertKeyCount);
            this.dataStream.write(this.tmpArray, 0, insertSize);
            if (this.insetByteStream.size() > 0) {
                this.insetByteStream.writeTo(this.dataStream);
            }
            int deleteSize = PackedInteger.getWriteIntLength((int)this.deleteKeyCount);
            PackedInteger.writeInt((byte[])this.tmpArray, (int)0, (int)this.deleteKeyCount);
            this.dataStream.write(this.tmpArray, 0, deleteSize);
            if (this.deleteByteStream.size() > 0) {
                this.deleteByteStream.writeTo(this.dataStream);
            }
            return insertSize + deleteSize;
        }

        private int writeHeader(int indexID, int keySize) throws IOException {
            this.dataStream.writeInt(indexID);
            int packedSize = PackedInteger.getWriteIntLength((int)keySize);
            PackedInteger.writeInt((byte[])this.tmpArray, (int)0, (int)keySize);
            this.dataStream.write(this.tmpArray, 0, packedSize);
            return packedSize;
        }

        private int writeRecord(IndexBuffer b) throws IOException {
            int keySize = b.getKeySize();
            int packedSize = this.writeHeader(b.getIndexID(), keySize);
            b.writeKey(this.dataStream);
            return (packedSize += this.writeByteStreams()) + keySize + this.insetByteStream.size() + this.deleteByteStream.size() + 4;
        }

        private int writeRecord(byte[] k, int indexID) throws IOException {
            int packedSize = this.writeHeader(indexID, k.length);
            this.dataStream.write(k);
            return (packedSize += this.writeByteStreams()) + k.length + this.insetByteStream.size() + this.deleteByteStream.size() + 4;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class IndexDBWriteTask
    implements Callable<Void> {
        private final IndexManager indexMgr;
        private final DatabaseEntry dbKey;
        private final DatabaseEntry dbValue;
        private final int cacheSize;
        private final Map<Integer, DNState> dnStateMap = new HashMap<Integer, DNState>();
        private final Map<Integer, Index> indexMap = new HashMap<Integer, Index>();

        public IndexDBWriteTask(IndexManager indexMgr, int cacheSize) {
            this.indexMgr = indexMgr;
            this.dbKey = new DatabaseEntry();
            this.dbValue = new DatabaseEntry();
            this.cacheSize = cacheSize;
        }

        private SortedSet<Buffer> initializeBuffers() throws IOException {
            TreeSet<Buffer> bufferSet = new TreeSet<Buffer>();
            for (Buffer b : this.indexMgr.getBufferList()) {
                b.initializeCache(this.indexMgr, null, this.cacheSize);
                bufferSet.add(b);
            }
            this.indexMgr.getBufferList().clear();
            return bufferSet;
        }

        @Override
        public Void call() throws Exception {
            ByteBuffer cKey = null;
            ImportIDSet cInsertIDSet = new ImportIDSet();
            ImportIDSet cDeleteIDSet = new ImportIDSet();
            Thread.setDefaultUncaughtExceptionHandler(new DefaultExceptionHandler());
            this.indexMgr.setStarted();
            Message message = JebMessages.NOTE_JEB_IMPORT_LDIF_INDEX_STARTED.get(this.indexMgr.getFileName(), this.indexMgr.getBufferList().size());
            ErrorLogger.logError(message);
            Integer cIndexID = null;
            try {
                this.indexMgr.openIndexFile();
                SortedSet<Buffer> bufferSet = this.initializeBuffers();
                while (!bufferSet.isEmpty()) {
                    Buffer b = bufferSet.first();
                    bufferSet.remove(b);
                    if (cKey == null) {
                        cKey = ByteBuffer.allocate(128);
                        cIndexID = b.getIndexID();
                        cKey.clear();
                        if (b.getKeyLen() > cKey.capacity()) {
                            cKey = ByteBuffer.allocate(b.getKeyLen());
                        }
                        cKey.flip();
                        b.getKey(cKey);
                        cInsertIDSet.merge(b.getInsertIDSet());
                        cDeleteIDSet.merge(b.getDeleteIDSet());
                        cInsertIDSet.setKey(cKey);
                        cDeleteIDSet.setKey(cKey);
                    } else if (b.compare(cKey, cIndexID) != 0) {
                        this.addToDB(cInsertIDSet, cDeleteIDSet, cIndexID);
                        this.indexMgr.incrementKeyCount();
                        cIndexID = b.getIndexID();
                        cKey.clear();
                        if (b.getKeyLen() > cKey.capacity()) {
                            cKey = ByteBuffer.allocate(b.getKeyLen());
                        }
                        cKey.flip();
                        b.getKey(cKey);
                        cInsertIDSet.clear(true);
                        cDeleteIDSet.clear(true);
                        cInsertIDSet.merge(b.getInsertIDSet());
                        cDeleteIDSet.merge(b.getDeleteIDSet());
                        cInsertIDSet.setKey(cKey);
                        cDeleteIDSet.setKey(cKey);
                    } else {
                        cInsertIDSet.merge(b.getInsertIDSet());
                        cDeleteIDSet.merge(b.getDeleteIDSet());
                    }
                    if (!b.hasMoreData()) continue;
                    b.getNextRecord();
                    bufferSet.add(b);
                }
                if (cKey != null) {
                    this.addToDB(cInsertIDSet, cDeleteIDSet, cIndexID);
                }
                this.cleanUP();
            }
            catch (Exception e) {
                message = JebMessages.ERR_JEB_IMPORT_LDIF_INDEX_WRITE_DB_ERR.get(this.indexMgr.getFileName(), e.getMessage());
                ErrorLogger.logError(message);
                e.printStackTrace();
                throw e;
            }
            return null;
        }

        private void cleanUP() throws DatabaseException, DirectoryException, IOException {
            if (this.indexMgr.isDN2ID()) {
                for (DNState dnState : this.dnStateMap.values()) {
                    dnState.flush();
                }
                Message msg = JebMessages.NOTE_JEB_IMPORT_LDIF_DN_CLOSE.get(this.indexMgr.getDNCount());
                ErrorLogger.logError(msg);
            } else {
                for (Index index : this.indexMap.values()) {
                    index.closeCursor();
                }
                Message message = JebMessages.NOTE_JEB_IMPORT_LDIF_INDEX_CLOSE.get(this.indexMgr.getFileName());
                ErrorLogger.logError(message);
            }
            this.indexMgr.setDone();
            this.indexMgr.close();
            this.indexMgr.deleteIndexFile();
        }

        private void addToDB(ImportIDSet insertSet, ImportIDSet deleteSet, int indexID) throws InterruptedException, DatabaseException, DirectoryException {
            if (!this.indexMgr.isDN2ID()) {
                Index index;
                if (deleteSet.size() > 0 || !deleteSet.isDefined()) {
                    this.dbKey.setData(deleteSet.getKey().array(), 0, deleteSet.getKey().limit());
                    index = (Index)Importer.this.idContainerMap.get(indexID);
                    index.delete(this.dbKey, deleteSet, this.dbValue);
                    if (!this.indexMap.containsKey(indexID)) {
                        this.indexMap.put(indexID, index);
                    }
                }
                if (insertSet.size() > 0 || !insertSet.isDefined()) {
                    this.dbKey.setData(insertSet.getKey().array(), 0, insertSet.getKey().limit());
                    index = (Index)Importer.this.idContainerMap.get(indexID);
                    index.insert(this.dbKey, insertSet, this.dbValue);
                    if (!this.indexMap.containsKey(indexID)) {
                        this.indexMap.put(indexID, index);
                    }
                }
            } else {
                this.addDN2ID(insertSet, indexID);
            }
        }

        private void addDN2ID(ImportIDSet record, Integer indexID) throws DatabaseException, DirectoryException {
            DNState dnState;
            if (!this.dnStateMap.containsKey(indexID)) {
                dnState = new DNState((EntryContainer)Importer.this.idECMap.get(indexID));
                this.dnStateMap.put(indexID, dnState);
            } else {
                dnState = this.dnStateMap.get(indexID);
            }
            if (!dnState.checkParent(record)) {
                return;
            }
            dnState.writeToDB();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class DNState {
            private final int DN_STATE_CACHE_SIZE = 65536;
            private DN parentDN;
            private DN lastDN;
            private EntryID parentID;
            private EntryID lastID;
            private EntryID entryID;
            private final DatabaseEntry DNKey;
            private final DatabaseEntry DNValue;
            private final TreeMap<DN, EntryID> parentIDMap = new TreeMap();
            private final EntryContainer entryContainer;
            private final Map<byte[], ImportIDSet> id2childTree;
            private final Map<byte[], ImportIDSet> id2subtreeTree;
            private final int childLimit;
            private final int subTreeLimit;
            private final boolean childDoCount;
            private final boolean subTreeDoCount;

            DNState(EntryContainer entryContainer) {
                this.entryContainer = entryContainer;
                Comparator<byte[]> childComparator = entryContainer.getID2Children().getComparator();
                this.id2childTree = new TreeMap<byte[], ImportIDSet>(childComparator);
                this.childLimit = entryContainer.getID2Children().getIndexEntryLimit();
                this.childDoCount = entryContainer.getID2Children().getMaintainCount();
                Comparator<byte[]> subComparator = entryContainer.getID2Subtree().getComparator();
                this.subTreeLimit = entryContainer.getID2Subtree().getIndexEntryLimit();
                this.subTreeDoCount = entryContainer.getID2Subtree().getMaintainCount();
                this.id2subtreeTree = new TreeMap<byte[], ImportIDSet>(subComparator);
                this.DNKey = new DatabaseEntry();
                this.DNValue = new DatabaseEntry();
            }

            private boolean checkParent(ImportIDSet record) throws DirectoryException, DatabaseException {
                DN dn = DN.decode(new String(record.getKey().array(), 0, record.getKey().limit()));
                this.DNKey.setData(record.getKey().array(), 0, record.getKey().limit());
                byte[] v = record.toDatabase();
                long v1 = JebFormat.entryIDFromDatabase(v);
                this.DNValue.setData(v);
                this.entryID = new EntryID(v1);
                if (Importer.this.importConfiguration != null && Importer.this.importConfiguration.appendToExistingData()) {
                    this.parentDN = this.entryContainer.getParentWithinBase(dn);
                    if (this.parentDN != null) {
                        this.parentID = this.entryContainer.getDN2ID().get(null, this.parentDN, LockMode.DEFAULT);
                    }
                } else {
                    if (this.parentIDMap.isEmpty()) {
                        this.parentIDMap.put(dn, this.entryID);
                        return true;
                    }
                    if (this.lastDN != null && this.lastDN.isAncestorOf(dn)) {
                        this.parentIDMap.put(this.lastDN, this.lastID);
                        this.parentDN = this.lastDN;
                        this.parentID = this.lastID;
                        this.lastDN = dn;
                        this.lastID = this.entryID;
                        return true;
                    }
                    if (this.parentIDMap.lastKey().isAncestorOf(dn)) {
                        this.parentDN = this.parentIDMap.lastKey();
                        this.parentID = this.parentIDMap.get(this.parentDN);
                        this.lastDN = dn;
                        this.lastID = this.entryID;
                        return true;
                    }
                    DN newParentDN = this.entryContainer.getParentWithinBase(dn);
                    if (this.parentIDMap.containsKey(newParentDN)) {
                        EntryID newParentID = this.parentIDMap.get(newParentDN);
                        DN lastDN = this.parentIDMap.lastKey();
                        while (!newParentDN.equals(lastDN)) {
                            this.parentIDMap.remove(lastDN);
                            lastDN = this.parentIDMap.lastKey();
                        }
                        this.parentIDMap.put(dn, this.entryID);
                        this.parentDN = newParentDN;
                        this.parentID = newParentID;
                        lastDN = dn;
                        this.lastID = this.entryID;
                    } else {
                        Message message = JebMessages.NOTE_JEB_IMPORT_LDIF_DN_NO_PARENT.get(dn.toString());
                        Entry e = new Entry(dn, null, null, null);
                        Importer.this.reader.rejectEntry(e, message);
                        return false;
                    }
                }
                return true;
            }

            private void id2child(EntryID childID) throws DatabaseException, DirectoryException {
                ImportIDSet idSet;
                if (!this.id2childTree.containsKey(this.parentID.getDatabaseEntry().getData())) {
                    idSet = new ImportIDSet(1, this.childLimit, this.childDoCount);
                    this.id2childTree.put(this.parentID.getDatabaseEntry().getData(), idSet);
                } else {
                    idSet = this.id2childTree.get(this.parentID.getDatabaseEntry().getData());
                }
                idSet.addEntryID(childID);
                if (this.id2childTree.size() > 65536) {
                    this.flushMapToDB(this.id2childTree, this.entryContainer.getID2Children(), true);
                }
            }

            private EntryID getParentID(DN dn) throws DatabaseException {
                EntryID nodeID = Importer.this.importConfiguration != null && Importer.this.importConfiguration.appendToExistingData() ? this.entryContainer.getDN2ID().get(null, dn, LockMode.DEFAULT) : this.parentIDMap.get(dn);
                return nodeID;
            }

            private void id2SubTree(EntryID childID) throws DatabaseException, DirectoryException {
                ImportIDSet idSet;
                if (!this.id2subtreeTree.containsKey(this.parentID.getDatabaseEntry().getData())) {
                    idSet = new ImportIDSet(1, this.subTreeLimit, this.subTreeDoCount);
                    this.id2subtreeTree.put(this.parentID.getDatabaseEntry().getData(), idSet);
                } else {
                    idSet = this.id2subtreeTree.get(this.parentID.getDatabaseEntry().getData());
                }
                idSet.addEntryID(childID);
                DN dn = this.entryContainer.getParentWithinBase(this.parentDN);
                while (dn != null) {
                    EntryID nodeID = this.getParentID(dn);
                    if (!this.id2subtreeTree.containsKey(nodeID.getDatabaseEntry().getData())) {
                        idSet = new ImportIDSet(1, this.subTreeLimit, this.subTreeDoCount);
                        this.id2subtreeTree.put(nodeID.getDatabaseEntry().getData(), idSet);
                    } else {
                        idSet = this.id2subtreeTree.get(nodeID.getDatabaseEntry().getData());
                    }
                    idSet.addEntryID(childID);
                    dn = this.entryContainer.getParentWithinBase(dn);
                }
                if (this.id2subtreeTree.size() > 65536) {
                    this.flushMapToDB(this.id2subtreeTree, this.entryContainer.getID2Subtree(), true);
                }
            }

            public void writeToDB() throws DatabaseException, DirectoryException {
                this.entryContainer.getDN2ID().putRaw(null, this.DNKey, this.DNValue);
                IndexDBWriteTask.this.indexMgr.addTotDNCount(1);
                if (this.parentDN != null) {
                    this.id2child(this.entryID);
                    this.id2SubTree(this.entryID);
                }
            }

            private void flushMapToDB(Map<byte[], ImportIDSet> map, Index index, boolean clearMap) throws DatabaseException, DirectoryException {
                for (Map.Entry<byte[], ImportIDSet> e : map.entrySet()) {
                    byte[] key = e.getKey();
                    ImportIDSet idSet = e.getValue();
                    this.DNKey.setData(key);
                    index.insert(this.DNKey, idSet, this.DNValue);
                }
                index.closeCursor();
                if (clearMap) {
                    map.clear();
                }
            }

            public void flush() throws DatabaseException, DirectoryException {
                this.flushMapToDB(this.id2childTree, this.entryContainer.getID2Children(), false);
                this.flushMapToDB(this.id2subtreeTree, this.entryContainer.getID2Subtree(), false);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ImportTask
    implements Callable<Void> {
        private final Map<IndexKey, IndexBuffer> indexBufferMap = new HashMap<IndexKey, IndexBuffer>();
        private final Set<byte[]> insertKeySet = new HashSet<byte[]>();
        private final EntryInformation entryInfo = new EntryInformation();
        private DatabaseEntry keyEntry = new DatabaseEntry();
        private DatabaseEntry valEntry = new DatabaseEntry();

        private ImportTask() {
        }

        @Override
        public Void call() throws Exception {
            try {
                while (true) {
                    if (Importer.this.importConfiguration.isCancelled() || Importer.this.isPhaseOneCanceled) {
                        IndexBuffer indexBuffer = IndexBuffer.createIndexBuffer(0);
                        Importer.this.freeBufferQueue.add(indexBuffer);
                        return null;
                    }
                    Entry entry = Importer.this.reader.readEntry(Importer.this.dnSuffixMap, this.entryInfo);
                    if (entry == null) break;
                    EntryID entryID = this.entryInfo.getEntryID();
                    Suffix suffix = this.entryInfo.getSuffix();
                    this.processEntry(entry, entryID, suffix);
                }
                this.flushIndexBuffers();
            }
            catch (Exception e) {
                Message message = JebMessages.ERR_JEB_IMPORT_LDIF_IMPORT_TASK_ERR.get(e.getMessage());
                ErrorLogger.logError(message);
                Importer.this.isPhaseOneCanceled = true;
                throw e;
            }
            return null;
        }

        void processEntry(Entry entry, EntryID entryID, Suffix suffix) throws DatabaseException, ConfigException, DirectoryException, JebException, InterruptedException {
            DN entryDN = entry.getDN();
            if (!Importer.this.skipDNValidation && !this.dnSanityCheck(entryDN, entry, suffix)) {
                suffix.removePending(entryDN);
                return;
            }
            suffix.removePending(entryDN);
            this.processDN2ID(suffix, entryDN, entryID);
            this.processDN2URI(suffix, null, entry);
            this.processIndexes(suffix, entry, entryID);
            suffix.getID2Entry().put(null, entryID, entry);
            Importer.this.importCount.getAndIncrement();
        }

        boolean dnSanityCheck(DN entryDN, Entry entry, Suffix suffix) throws JebException, InterruptedException {
            DN parentDN;
            if (!Importer.this.clearedBackend) {
                EntryID id = suffix.getDN2ID().get(null, entryDN, LockMode.DEFAULT);
                if (id != null || !Importer.this.tmpEnv.insert(entryDN, this.keyEntry, this.valEntry)) {
                    Message message = JebMessages.WARN_JEB_IMPORT_ENTRY_EXISTS.get();
                    Importer.this.reader.rejectEntry(entry, message);
                    return false;
                }
            } else if (!Importer.this.tmpEnv.insert(entryDN, this.keyEntry, this.valEntry)) {
                Message message = JebMessages.WARN_JEB_IMPORT_ENTRY_EXISTS.get();
                Importer.this.reader.rejectEntry(entry, message);
                return false;
            }
            if ((parentDN = suffix.getEntryContainer().getParentWithinBase(entryDN)) != null && !suffix.isParentProcessed(parentDN, Importer.this.tmpEnv, Importer.this.clearedBackend)) {
                Message message = JebMessages.ERR_JEB_IMPORT_PARENT_NOT_FOUND.get(parentDN.toString());
                Importer.this.reader.rejectEntry(entry, message);
                return false;
            }
            return true;
        }

        void processIndexes(Suffix suffix, Entry entry, EntryID entryID) throws DatabaseException, DirectoryException, JebException, ConfigException, InterruptedException {
            for (Map.Entry<AttributeType, AttributeIndex> mapEntry : suffix.getAttrIndexMap().entrySet()) {
                Collection<Index> sharedIndexes;
                AttributeType attributeType = mapEntry.getKey();
                if (!entry.hasAttribute(attributeType)) continue;
                AttributeIndex attributeIndex = mapEntry.getValue();
                Index index = attributeIndex.getEqualityIndex();
                if (index != null) {
                    this.processAttribute(index, entry, entryID, new IndexKey(attributeType, ImportIndexType.EQUALITY, index.getIndexEntryLimit()));
                }
                if ((index = attributeIndex.getPresenceIndex()) != null) {
                    this.processAttribute(index, entry, entryID, new IndexKey(attributeType, ImportIndexType.PRESENCE, index.getIndexEntryLimit()));
                }
                if ((index = attributeIndex.getSubstringIndex()) != null) {
                    this.processAttribute(index, entry, entryID, new IndexKey(attributeType, ImportIndexType.SUBSTRING, index.getIndexEntryLimit()));
                }
                if ((index = attributeIndex.getOrderingIndex()) != null) {
                    this.processAttribute(index, entry, entryID, new IndexKey(attributeType, ImportIndexType.ORDERING, index.getIndexEntryLimit()));
                }
                if ((index = attributeIndex.getApproximateIndex()) != null) {
                    this.processAttribute(index, entry, entryID, new IndexKey(attributeType, ImportIndexType.APPROXIMATE, index.getIndexEntryLimit()));
                }
                for (VLVIndex vlvIdx : suffix.getEntryContainer().getVLVIndexes()) {
                    Transaction transaction = null;
                    vlvIdx.addEntry(transaction, entryID, entry);
                }
                Map<String, Collection<Index>> extensibleMap = attributeIndex.getExtensibleIndexes();
                if (extensibleMap.isEmpty()) continue;
                Collection<Index> subIndexes = attributeIndex.getExtensibleIndexes().get("substring");
                if (subIndexes != null) {
                    for (Index subIndex : subIndexes) {
                        this.processAttribute(subIndex, entry, entryID, new IndexKey(attributeType, ImportIndexType.EX_SUBSTRING, subIndex.getIndexEntryLimit()));
                    }
                }
                if ((sharedIndexes = attributeIndex.getExtensibleIndexes().get("shared")) == null) continue;
                for (Index sharedIndex : sharedIndexes) {
                    this.processAttribute(sharedIndex, entry, entryID, new IndexKey(attributeType, ImportIndexType.EX_SHARED, sharedIndex.getIndexEntryLimit()));
                }
            }
        }

        void processAttribute(Index index, Entry entry, EntryID entryID, IndexKey indexKey) throws DatabaseException, ConfigException, InterruptedException {
            this.insertKeySet.clear();
            index.indexer.indexEntry(entry, this.insertKeySet);
            for (byte[] key : this.insertKeySet) {
                this.processKey(index, key, entryID, indexComparator, indexKey, true);
            }
        }

        void flushIndexBuffers() throws InterruptedException, ExecutionException {
            Set<Map.Entry<IndexKey, IndexBuffer>> set = this.indexBufferMap.entrySet();
            Iterator<Map.Entry<IndexKey, IndexBuffer>> setIterator = set.iterator();
            while (setIterator.hasNext()) {
                Map.Entry<IndexKey, IndexBuffer> e = setIterator.next();
                IndexKey indexKey = e.getKey();
                IndexBuffer indexBuffer = e.getValue();
                setIterator.remove();
                ImportIndexType indexType = indexKey.getIndexType();
                if (indexType.equals((Object)ImportIndexType.DN)) {
                    indexBuffer.setComparator(dnComparator);
                } else {
                    indexBuffer.setComparator(indexComparator);
                }
                indexBuffer.setIndexKey(indexKey);
                indexBuffer.setDiscard();
                Future<Void> future = Importer.this.bufferSortService.submit(new SortTask(indexBuffer));
                future.get();
            }
        }

        int processKey(DatabaseContainer container, byte[] key, EntryID entryID, IndexBuffer.ComparatorBuffer<byte[]> comparator, IndexKey indexKey, boolean insert) throws ConfigException, InterruptedException {
            IndexBuffer indexBuffer;
            if (!this.indexBufferMap.containsKey(indexKey)) {
                indexBuffer = this.getNewIndexBuffer();
                this.indexBufferMap.put(indexKey, indexBuffer);
            } else {
                indexBuffer = this.indexBufferMap.get(indexKey);
            }
            if (!indexBuffer.isSpaceAvailable(key, entryID.longValue())) {
                indexBuffer.setComparator(comparator);
                indexBuffer.setIndexKey(indexKey);
                Importer.this.bufferSortService.submit(new SortTask(indexBuffer));
                indexBuffer = this.getNewIndexBuffer();
                this.indexBufferMap.remove(indexKey);
                this.indexBufferMap.put(indexKey, indexBuffer);
            }
            int id = System.identityHashCode(container);
            indexBuffer.add(key, entryID, id, insert);
            return id;
        }

        IndexBuffer getNewIndexBuffer() throws ConfigException, InterruptedException {
            IndexBuffer indexBuffer = (IndexBuffer)Importer.this.freeBufferQueue.take();
            if (indexBuffer == null) {
                Message message = Message.raw(Category.JEB, Severity.SEVERE_ERROR, "Index buffer processing error.", new Object[0]);
                throw new InterruptedException(message.toString());
            }
            if (indexBuffer.isPoison()) {
                Message message = Message.raw(Category.JEB, Severity.SEVERE_ERROR, "Cancel processing received.", new Object[0]);
                throw new InterruptedException(message.toString());
            }
            return indexBuffer;
        }

        void processDN2ID(Suffix suffix, DN dn, EntryID entryID) throws ConfigException, InterruptedException {
            DN2ID dn2id = suffix.getDN2ID();
            byte[] dnBytes = StaticUtils.getBytes(dn.toNormalizedString());
            int id = this.processKey(dn2id, dnBytes, entryID, dnComparator, new IndexKey(dnType, ImportIndexType.DN, 1), true);
            Importer.this.idECMap.putIfAbsent(id, suffix.getEntryContainer());
        }

        void processDN2URI(Suffix suffix, Entry oldEntry, Entry newEntry) throws DatabaseException {
            DN2URI dn2uri = suffix.getDN2URI();
            if (oldEntry != null) {
                dn2uri.replaceEntry(null, oldEntry, newEntry);
            } else {
                dn2uri.addEntry(null, newEntry);
            }
        }
    }

    private class AppendReplaceTask
    extends ImportTask {
        private final Set<byte[]> insertKeySet = new HashSet<byte[]>();
        private final Set<byte[]> deleteKeySet = new HashSet<byte[]>();
        private final EntryInformation entryInfo = new EntryInformation();
        private Entry oldEntry;
        private EntryID entryID;

        private AppendReplaceTask() {
        }

        public Void call() throws Exception {
            try {
                while (true) {
                    if (Importer.this.importConfiguration.isCancelled() || Importer.this.isPhaseOneCanceled) {
                        IndexBuffer indexBuffer = IndexBuffer.createIndexBuffer(0);
                        Importer.this.freeBufferQueue.add(indexBuffer);
                        return null;
                    }
                    this.oldEntry = null;
                    Entry entry = Importer.this.reader.readEntry(Importer.this.dnSuffixMap, this.entryInfo);
                    if (entry == null) break;
                    this.entryID = this.entryInfo.getEntryID();
                    Suffix suffix = this.entryInfo.getSuffix();
                    this.processEntry(entry, suffix);
                }
                this.flushIndexBuffers();
            }
            catch (Exception e) {
                Message message = JebMessages.ERR_JEB_IMPORT_LDIF_APPEND_REPLACE_TASK_ERR.get(e.getMessage());
                ErrorLogger.logError(message);
                Importer.this.isPhaseOneCanceled = true;
                throw e;
            }
            return null;
        }

        void processEntry(Entry entry, Suffix suffix) throws DatabaseException, ConfigException, DirectoryException, JebException, InterruptedException {
            DN entryDN = entry.getDN();
            DN2ID dn2id = suffix.getDN2ID();
            EntryID oldID = dn2id.get(null, entryDN, LockMode.DEFAULT);
            if (oldID != null) {
                this.oldEntry = suffix.getID2Entry().get(null, oldID, LockMode.DEFAULT);
            }
            if (this.oldEntry == null) {
                if (!Importer.this.skipDNValidation) {
                    if (!this.dnSanityCheck(entryDN, entry, suffix)) {
                        suffix.removePending(entryDN);
                        return;
                    }
                    suffix.removePending(entryDN);
                } else {
                    this.processDN2ID(suffix, entryDN, this.entryID);
                    suffix.removePending(entryDN);
                }
            } else {
                suffix.removePending(entryDN);
                this.entryID = oldID;
            }
            this.processDN2URI(suffix, this.oldEntry, entry);
            suffix.getID2Entry().put(null, this.entryID, entry);
            if (this.oldEntry == null) {
                this.processIndexes(suffix, entry, this.entryID);
            } else {
                this.processAllIndexes(suffix, entry, this.entryID);
            }
        }

        void processAllIndexes(Suffix suffix, Entry entry, EntryID entryID) throws DatabaseException, DirectoryException, JebException, ConfigException, InterruptedException {
            for (Map.Entry<AttributeType, AttributeIndex> mapEntry : suffix.getAttrIndexMap().entrySet()) {
                Collection<Index> sharedIndexes;
                AttributeType attributeType = mapEntry.getKey();
                AttributeIndex attributeIndex = mapEntry.getValue();
                Index index = attributeIndex.getEqualityIndex();
                if (index != null) {
                    this.processAttribute(index, entry, entryID, new IndexKey(attributeType, ImportIndexType.EQUALITY, index.getIndexEntryLimit()));
                }
                if ((index = attributeIndex.getPresenceIndex()) != null) {
                    this.processAttribute(index, entry, entryID, new IndexKey(attributeType, ImportIndexType.PRESENCE, index.getIndexEntryLimit()));
                }
                if ((index = attributeIndex.getSubstringIndex()) != null) {
                    this.processAttribute(index, entry, entryID, new IndexKey(attributeType, ImportIndexType.SUBSTRING, index.getIndexEntryLimit()));
                }
                if ((index = attributeIndex.getOrderingIndex()) != null) {
                    this.processAttribute(index, entry, entryID, new IndexKey(attributeType, ImportIndexType.ORDERING, index.getIndexEntryLimit()));
                }
                if ((index = attributeIndex.getApproximateIndex()) != null) {
                    this.processAttribute(index, entry, entryID, new IndexKey(attributeType, ImportIndexType.APPROXIMATE, index.getIndexEntryLimit()));
                }
                for (VLVIndex vlvIdx : suffix.getEntryContainer().getVLVIndexes()) {
                    Transaction transaction = null;
                    vlvIdx.addEntry(transaction, entryID, entry);
                }
                Map<String, Collection<Index>> extensibleMap = attributeIndex.getExtensibleIndexes();
                if (extensibleMap.isEmpty()) continue;
                Collection<Index> subIndexes = attributeIndex.getExtensibleIndexes().get("substring");
                if (subIndexes != null) {
                    for (Index subIndex : subIndexes) {
                        this.processAttribute(subIndex, entry, entryID, new IndexKey(attributeType, ImportIndexType.EX_SUBSTRING, subIndex.getIndexEntryLimit()));
                    }
                }
                if ((sharedIndexes = attributeIndex.getExtensibleIndexes().get("shared")) == null) continue;
                for (Index sharedIndex : sharedIndexes) {
                    this.processAttribute(sharedIndex, entry, entryID, new IndexKey(attributeType, ImportIndexType.EX_SHARED, sharedIndex.getIndexEntryLimit()));
                }
            }
        }

        void processAttribute(Index index, Entry entry, EntryID entryID, IndexKey indexKey) throws DatabaseException, ConfigException, InterruptedException {
            if (this.oldEntry != null) {
                this.deleteKeySet.clear();
                index.indexer.indexEntry(this.oldEntry, this.deleteKeySet);
                for (byte[] delKey : this.deleteKeySet) {
                    this.processKey(index, delKey, entryID, indexComparator, indexKey, false);
                }
            }
            this.insertKeySet.clear();
            index.indexer.indexEntry(entry, this.insertKeySet);
            for (byte[] key : this.insertKeySet) {
                this.processKey(index, key, entryID, indexComparator, indexKey, true);
            }
        }
    }

    private final class MigrateExistingTask
    extends ImportTask {
        private MigrateExistingTask() {
        }

        public Void call() throws Exception {
            for (Suffix suffix : Importer.this.dnSuffixMap.values()) {
                EntryContainer entryContainer = suffix.getSrcEntryContainer();
                if (entryContainer == null || suffix.getIncludeBranches().isEmpty()) continue;
                DatabaseEntry key = new DatabaseEntry();
                DatabaseEntry data = new DatabaseEntry();
                LockMode lockMode = LockMode.DEFAULT;
                Message message = JebMessages.NOTE_JEB_IMPORT_MIGRATION_START.get("existing", String.valueOf(suffix.getBaseDN()));
                ErrorLogger.logError(message);
                Cursor cursor = entryContainer.getDN2ID().openCursor(null, null);
                try {
                    OperationStatus status = cursor.getFirst(key, data, lockMode);
                    while (status == OperationStatus.SUCCESS && !Importer.this.importConfiguration.isCancelled() && !Importer.this.isPhaseOneCanceled) {
                        DN dn = DN.decode(ByteString.wrap(key.getData()));
                        if (!suffix.getIncludeBranches().contains(dn)) {
                            EntryID id = new EntryID(data);
                            Entry entry = entryContainer.getID2Entry().get(null, id, LockMode.DEFAULT);
                            this.processEntry(entry, Importer.this.rootContainer.getNextEntryID(), suffix);
                            Importer.this.migratedCount++;
                            status = cursor.getNext(key, data, lockMode);
                            continue;
                        }
                        byte[] begin = StaticUtils.getBytes("," + dn.toNormalizedString());
                        begin[0] = (byte)(begin[0] + 1);
                        key.setData(begin);
                        status = cursor.getSearchKeyRange(key, data, lockMode);
                    }
                    cursor.close();
                    this.flushIndexBuffers();
                }
                catch (Exception e) {
                    message = JebMessages.ERR_JEB_IMPORT_LDIF_MIGRATE_EXISTING_TASK_ERR.get(e.getMessage());
                    ErrorLogger.logError(message);
                    Importer.this.isPhaseOneCanceled = true;
                    throw e;
                }
            }
            return null;
        }
    }

    private final class MigrateExcludedTask
    extends ImportTask {
        private MigrateExcludedTask() {
        }

        public Void call() throws Exception {
            for (Suffix suffix : Importer.this.dnSuffixMap.values()) {
                EntryContainer entryContainer = suffix.getSrcEntryContainer();
                if (entryContainer == null || suffix.getExcludeBranches().isEmpty()) continue;
                DatabaseEntry key = new DatabaseEntry();
                DatabaseEntry data = new DatabaseEntry();
                LockMode lockMode = LockMode.DEFAULT;
                Message message = JebMessages.NOTE_JEB_IMPORT_MIGRATION_START.get("excluded", String.valueOf(suffix.getBaseDN()));
                ErrorLogger.logError(message);
                Cursor cursor = entryContainer.getDN2ID().openCursor(null, CursorConfig.READ_COMMITTED);
                Comparator<byte[]> comparator = entryContainer.getDN2ID().getComparator();
                try {
                    for (DN excludedDN : suffix.getExcludeBranches()) {
                        byte[] bytes = StaticUtils.getBytes(excludedDN.toNormalizedString());
                        key.setData(bytes);
                        OperationStatus status = cursor.getSearchKeyRange(key, data, lockMode);
                        if (status != OperationStatus.SUCCESS || !Arrays.equals(key.getData(), bytes)) continue;
                        byte[] end = StaticUtils.getBytes("," + excludedDN.toNormalizedString());
                        end[0] = (byte)(end[0] + 1);
                        while (status == OperationStatus.SUCCESS && comparator.compare(key.getData(), end) < 0 && !Importer.this.importConfiguration.isCancelled() && !Importer.this.isPhaseOneCanceled) {
                            EntryID id = new EntryID(data);
                            Entry entry = entryContainer.getID2Entry().get(null, id, LockMode.DEFAULT);
                            this.processEntry(entry, Importer.this.rootContainer.getNextEntryID(), suffix);
                            Importer.this.migratedCount++;
                            status = cursor.getNext(key, data, lockMode);
                        }
                    }
                    cursor.close();
                    this.flushIndexBuffers();
                }
                catch (Exception e) {
                    message = JebMessages.ERR_JEB_IMPORT_LDIF_MIGRATE_EXCLUDED_TASK_ERR.get(e.getMessage());
                    ErrorLogger.logError(message);
                    Importer.this.isPhaseOneCanceled = true;
                    throw e;
                }
            }
            return null;
        }
    }
}

