/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.messages.JebMessages;
import org.opends.messages.Message;
import org.opends.server.api.CompressedSchema;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.Attributes;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteSequenceReader;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ObjectClass;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JECompressedSchema
extends CompressedSchema {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final String DB_NAME_AD = "compressed_attributes";
    public static final String DB_NAME_OC = "compressed_object_classes";
    private AtomicInteger adCounter;
    private AtomicInteger ocCounter;
    private ConcurrentHashMap<ByteSequence, AttributeType> atDecodeMap;
    private ConcurrentHashMap<ByteSequence, Set<String>> aoDecodeMap;
    private ConcurrentHashMap<ByteSequence, Map<ObjectClass, String>> ocDecodeMap;
    private final ConcurrentHashMap<AttributeType, ConcurrentHashMap<Set<String>, ByteSequence>> adEncodeMap;
    private final ConcurrentHashMap<Map<ObjectClass, String>, ByteSequence> ocEncodeMap;
    private Database adDatabase;
    private Database ocDatabase;
    private Environment environment;
    private final ByteStringBuilder storeWriterBuffer;
    private final ASN1Writer storeWriter;

    public JECompressedSchema(Environment environment) throws DatabaseException, InitializationException {
        this.environment = environment;
        this.atDecodeMap = new ConcurrentHashMap();
        this.aoDecodeMap = new ConcurrentHashMap();
        this.ocDecodeMap = new ConcurrentHashMap();
        this.adEncodeMap = new ConcurrentHashMap();
        this.ocEncodeMap = new ConcurrentHashMap();
        this.adCounter = new AtomicInteger(1);
        this.ocCounter = new AtomicInteger(1);
        this.storeWriterBuffer = new ByteStringBuilder();
        this.storeWriter = ASN1.getWriter(this.storeWriterBuffer);
        this.load();
    }

    private void load() throws DatabaseException, InitializationException {
        String lowerName;
        DatabaseConfig dbConfig = new DatabaseConfig();
        if (this.environment.getConfig().getReadOnly()) {
            dbConfig.setReadOnly(true);
            dbConfig.setAllowCreate(false);
            dbConfig.setTransactional(false);
        } else if (!this.environment.getConfig().getTransactional()) {
            dbConfig.setAllowCreate(true);
            dbConfig.setTransactional(false);
            dbConfig.setDeferredWrite(true);
        } else {
            dbConfig.setAllowCreate(true);
            dbConfig.setTransactional(true);
        }
        this.adDatabase = this.environment.openDatabase(null, DB_NAME_AD, dbConfig);
        this.ocDatabase = this.environment.openDatabase(null, DB_NAME_OC, dbConfig);
        Cursor ocCursor = this.ocDatabase.openCursor(null, null);
        int highestToken = 0;
        try {
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry valueEntry = new DatabaseEntry();
            OperationStatus status = ocCursor.getFirst(keyEntry, valueEntry, LockMode.READ_UNCOMMITTED);
            while (status == OperationStatus.SUCCESS) {
                byte[] tokenBytes = keyEntry.getData();
                ByteString token = ByteString.wrap(tokenBytes);
                highestToken = Math.max(highestToken, this.decodeInt(tokenBytes));
                ASN1Reader reader = ASN1.getReader(valueEntry.getData());
                reader.readStartSequence();
                LinkedHashMap<ObjectClass, String> ocMap = new LinkedHashMap<ObjectClass, String>();
                while (reader.hasNextElement()) {
                    String ocName = reader.readOctetStringAsString();
                    lowerName = StaticUtils.toLowerCase(ocName);
                    ObjectClass oc = DirectoryServer.getObjectClass(lowerName, true);
                    ocMap.put(oc, ocName);
                }
                reader.readEndSequence();
                this.ocEncodeMap.put(ocMap, token);
                this.ocDecodeMap.put(token, ocMap);
                status = ocCursor.getNext(keyEntry, valueEntry, LockMode.READ_UNCOMMITTED);
            }
        }
        catch (ASN1Exception ae) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ae);
            }
            Message m = JebMessages.ERR_JEB_COMPSCHEMA_CANNOT_DECODE_OC_TOKEN.get(ae.getMessage());
            throw new InitializationException(m, (Throwable)ae);
        }
        finally {
            ocCursor.close();
        }
        this.ocCounter.set(highestToken + 1);
        Cursor adCursor = this.adDatabase.openCursor(null, null);
        highestToken = 0;
        try {
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry valueEntry = new DatabaseEntry();
            OperationStatus status = adCursor.getFirst(keyEntry, valueEntry, LockMode.READ_UNCOMMITTED);
            while (status == OperationStatus.SUCCESS) {
                byte[] tokenBytes = keyEntry.getData();
                ByteString token = ByteString.wrap(tokenBytes);
                highestToken = Math.max(highestToken, this.decodeInt(tokenBytes));
                ASN1Reader reader = ASN1.getReader(valueEntry.getData());
                reader.readStartSequence();
                String attrName = reader.readOctetStringAsString();
                lowerName = StaticUtils.toLowerCase(attrName);
                AttributeType attrType = DirectoryServer.getAttributeType(lowerName, true);
                LinkedHashSet<String> options = new LinkedHashSet<String>();
                while (reader.hasNextElement()) {
                    options.add(reader.readOctetStringAsString());
                }
                reader.readEndSequence();
                this.atDecodeMap.put(token, attrType);
                this.aoDecodeMap.put(token, options);
                ConcurrentHashMap<Set<String>, ByteSequence> map = this.adEncodeMap.get(attrType);
                if (map == null) {
                    map = new ConcurrentHashMap(1);
                    map.put(options, token);
                    this.adEncodeMap.put(attrType, map);
                } else {
                    map.put(options, token);
                }
                status = adCursor.getNext(keyEntry, valueEntry, LockMode.READ_UNCOMMITTED);
            }
        }
        catch (ASN1Exception ae) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ae);
            }
            Message m = JebMessages.ERR_JEB_COMPSCHEMA_CANNOT_DECODE_AD_TOKEN.get(ae.getMessage());
            throw new InitializationException(m, (Throwable)ae);
        }
        finally {
            adCursor.close();
        }
        this.adCounter.set(highestToken + 1);
    }

    public void close() {
        try {
            this.adDatabase.sync();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.adDatabase.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.ocDatabase.sync();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.ocDatabase.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.adDatabase = null;
        this.ocDatabase = null;
        this.environment = null;
        this.atDecodeMap = null;
        this.aoDecodeMap = null;
        this.ocDecodeMap = null;
        this.adCounter = null;
        this.ocCounter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeObjectClasses(ByteStringBuilder entryBuffer, Map<ObjectClass, String> objectClasses) throws DirectoryException {
        ByteSequence encodedClasses = this.ocEncodeMap.get(objectClasses);
        if (encodedClasses == null) {
            ConcurrentHashMap<Map<ObjectClass, String>, ByteSequence> concurrentHashMap = this.ocEncodeMap;
            synchronized (concurrentHashMap) {
                int setValue = this.ocCounter.getAndIncrement();
                byte[] tokenArray = this.encodeInt(setValue);
                encodedClasses = ByteString.wrap(tokenArray);
                this.storeObjectClass(tokenArray, objectClasses);
                this.ocEncodeMap.put(objectClasses, encodedClasses);
                this.ocDecodeMap.put(encodedClasses, objectClasses);
            }
        }
        entryBuffer.appendBERLength(encodedClasses.length());
        encodedClasses.copyTo(entryBuffer);
    }

    @Override
    public Map<ObjectClass, String> decodeObjectClasses(ByteSequenceReader entryBufferReader) throws DirectoryException {
        int tokenLength = entryBufferReader.getBERLength();
        ByteSequence byteArray = entryBufferReader.getByteSequence(tokenLength);
        Map<ObjectClass, String> ocMap = this.ocDecodeMap.get(byteArray);
        if (ocMap == null) {
            Message message = JebMessages.ERR_JEB_COMPSCHEMA_UNKNOWN_OC_TOKEN.get(byteArray.toByteString().toHex());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        return ocMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeObjectClass(byte[] token, Map<ObjectClass, String> objectClasses) throws DirectoryException {
        ASN1Writer aSN1Writer = this.storeWriter;
        synchronized (aSN1Writer) {
            try {
                this.storeWriterBuffer.clear();
                this.storeWriter.writeStartSequence();
                for (String ocName : objectClasses.values()) {
                    this.storeWriter.writeOctetString(ocName);
                }
                this.storeWriter.writeEndSequence();
                this.store(this.ocDatabase, token, this.storeWriterBuffer);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeAttribute(byte[] token, AttributeType attrType, Set<String> options) throws DirectoryException {
        ASN1Writer aSN1Writer = this.storeWriter;
        synchronized (aSN1Writer) {
            try {
                this.storeWriterBuffer.clear();
                this.storeWriter.writeStartSequence();
                this.storeWriter.writeOctetString(attrType.getNameOrOID());
                for (String option : options) {
                    this.storeWriter.writeOctetString(option);
                }
                this.storeWriter.writeEndSequence();
                this.store(this.adDatabase, token, this.storeWriterBuffer);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeAttribute(ByteStringBuilder entryBuffer, Attribute attribute) throws DirectoryException {
        AttributeType type = attribute.getAttributeType();
        Set<String> options = attribute.getOptions();
        ConcurrentHashMap<Set<String>, ByteSequence> map = this.adEncodeMap.get(type);
        if (map == null) {
            ByteString byteString;
            ConcurrentHashMap<AttributeType, ConcurrentHashMap<Set<String>, ByteSequence>> concurrentHashMap = this.adEncodeMap;
            synchronized (concurrentHashMap) {
                map = new ConcurrentHashMap(1);
                int intValue = this.adCounter.getAndIncrement();
                byte[] tokenArray = this.encodeInt(intValue);
                byteString = ByteString.wrap(tokenArray);
                map.put(options, byteString);
                this.storeAttribute(tokenArray, type, options);
                this.adEncodeMap.put(type, map);
                this.atDecodeMap.put(byteString, type);
                this.aoDecodeMap.put(byteString, options);
            }
            this.encodeAttribute(entryBuffer, byteString, attribute);
        } else {
            ByteSequence byteArray = map.get(options);
            if (byteArray == null) {
                ConcurrentHashMap<Set<String>, ByteSequence> concurrentHashMap = map;
                synchronized (concurrentHashMap) {
                    int intValue = this.adCounter.getAndIncrement();
                    byte[] tokenArray = this.encodeInt(intValue);
                    byteArray = ByteString.wrap(tokenArray);
                    map.put(options, byteArray);
                    this.storeAttribute(tokenArray, type, options);
                    this.atDecodeMap.put(byteArray, type);
                    this.aoDecodeMap.put(byteArray, options);
                }
            }
            this.encodeAttribute(entryBuffer, byteArray, attribute);
        }
    }

    private void encodeAttribute(ByteStringBuilder buffer, ByteSequence adArray, Attribute attribute) {
        buffer.appendBERLength(adArray.length());
        adArray.copyTo(buffer);
        buffer.appendBERLength(attribute.size());
        for (AttributeValue v : attribute) {
            buffer.appendBERLength(v.getValue().length());
            buffer.append(v.getValue());
        }
    }

    @Override
    public Attribute decodeAttribute(ByteSequenceReader entryBufferReader) throws DirectoryException {
        int adArrayLength = entryBufferReader.getBERLength();
        ByteSequence adArray = entryBufferReader.getByteSequence(adArrayLength);
        AttributeType attrType = this.atDecodeMap.get(adArray);
        Set<String> options = this.aoDecodeMap.get(adArray);
        if (attrType == null || options == null) {
            Message message = JebMessages.ERR_JEB_COMPSCHEMA_UNRECOGNIZED_AD_TOKEN.get(adArray.toByteString().toHex());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        int numValues = entryBufferReader.getBERLength();
        if (numValues == 1 && options.isEmpty()) {
            int valueLength = entryBufferReader.getBERLength();
            ByteString valueBytes = entryBufferReader.getByteSequence(valueLength).toByteString();
            return Attributes.create(attrType, AttributeValues.create(attrType, valueBytes));
        }
        AttributeBuilder builder = new AttributeBuilder(attrType);
        builder.setOptions(options);
        builder.setInitialCapacity(numValues);
        for (int i = 0; i < numValues; ++i) {
            int valueLength = entryBufferReader.getBERLength();
            ByteString valueBytes = entryBufferReader.getByteSequence(valueLength).toByteString();
            builder.add(AttributeValues.create(attrType, valueBytes));
        }
        return builder.toAttribute();
    }

    private void store(Database database, byte[] keyBytes, ByteStringBuilder valueBytes) throws DirectoryException {
        boolean successful = false;
        DatabaseEntry keyEntry = new DatabaseEntry(keyBytes);
        DatabaseEntry valueEntry = new DatabaseEntry(valueBytes.getBackingArray(), 0, valueBytes.length());
        for (int i = 0; i < 3; ++i) {
            try {
                OperationStatus status = database.putNoOverwrite(null, keyEntry, valueEntry);
                if (status != OperationStatus.SUCCESS) {
                    Message m = JebMessages.ERR_JEB_COMPSCHEMA_CANNOT_STORE_STATUS.get(status.toString());
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), m);
                }
                successful = true;
                break;
            }
            catch (LockConflictException ce) {
                continue;
            }
            catch (DatabaseException de) {
                Message m = JebMessages.ERR_JEB_COMPSCHEMA_CANNOT_STORE_EX.get(de.getMessage());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), m, de);
            }
        }
        if (!successful) {
            Message m = JebMessages.ERR_JEB_COMPSCHEMA_CANNOT_STORE_MULTIPLE_FAILURES.get();
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), m);
        }
    }

    private byte[] encodeInt(int intValue) {
        byte[] array = intValue <= 255 ? new byte[]{(byte)(intValue & 0xFF)} : (intValue <= 65535 ? new byte[]{(byte)(intValue >> 8 & 0xFF), (byte)(intValue & 0xFF)} : (intValue <= 0xFFFFFF ? new byte[]{(byte)(intValue >> 16 & 0xFF), (byte)(intValue >> 8 & 0xFF), (byte)(intValue & 0xFF)} : new byte[]{(byte)(intValue >> 24 & 0xFF), (byte)(intValue >> 16 & 0xFF), (byte)(intValue >> 8 & 0xFF), (byte)(intValue & 0xFF)}));
        return array;
    }

    private int decodeInt(byte[] byteArray) {
        int intValue = 0;
        for (byte b : byteArray) {
            intValue <<= 8;
            intValue |= b & 0xFF;
        }
        return intValue;
    }
}

