/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.Indexer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqualityIndexer
extends Indexer {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final Comparator<byte[]> comparator = new AttributeIndex.KeyComparator();
    private AttributeType attributeType;

    public EqualityIndexer(AttributeType attributeType) {
        this.attributeType = attributeType;
    }

    public String toString() {
        return this.attributeType.getNameOrOID() + ".equality";
    }

    @Override
    public Comparator<byte[]> getComparator() {
        return comparator;
    }

    @Override
    public void indexEntry(Entry entry, Set<byte[]> keys) {
        List<Attribute> attrList = entry.getAttribute(this.attributeType);
        if (attrList != null) {
            this.indexAttribute(attrList, keys);
        }
    }

    @Override
    public void replaceEntry(Entry oldEntry, Entry newEntry, Map<byte[], Boolean> modifiedKeys) {
        List<Attribute> newAttributes = newEntry.getAttribute(this.attributeType, true);
        List<Attribute> oldAttributes = oldEntry.getAttribute(this.attributeType, true);
        this.indexAttribute(oldAttributes, modifiedKeys, false);
        this.indexAttribute(newAttributes, modifiedKeys, true);
    }

    @Override
    public void modifyEntry(Entry oldEntry, Entry newEntry, List<Modification> mods, Map<byte[], Boolean> modifiedKeys) {
        List<Attribute> newAttributes = newEntry.getAttribute(this.attributeType, true);
        List<Attribute> oldAttributes = oldEntry.getAttribute(this.attributeType, true);
        this.indexAttribute(oldAttributes, modifiedKeys, false);
        this.indexAttribute(newAttributes, modifiedKeys, true);
    }

    private void indexAttribute(List<Attribute> attrList, Set<byte[]> keys) {
        if (attrList == null) {
            return;
        }
        for (Attribute attr : attrList) {
            if (attr.isVirtual()) continue;
            for (AttributeValue value : attr) {
                try {
                    byte[] keyBytes = value.getNormalizedValue().toByteArray();
                    keys.add(keyBytes);
                }
                catch (DirectoryException e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    private void indexAttribute(List<Attribute> attrList, Map<byte[], Boolean> modifiedKeys, Boolean insert) {
        if (attrList == null) {
            return;
        }
        for (Attribute attr : attrList) {
            if (attr.isVirtual()) continue;
            for (AttributeValue value : attr) {
                try {
                    byte[] keyBytes = value.getNormalizedValue().toByteArray();
                    Boolean cInsert = modifiedKeys.get(keyBytes);
                    if (cInsert == null) {
                        modifiedKeys.put(keyBytes, insert);
                        continue;
                    }
                    if (cInsert.equals(insert)) continue;
                    modifiedKeys.remove(keyBytes);
                }
                catch (DirectoryException e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }
}

