/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import java.util.List;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.SynchronizationProviderCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.Modification;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.types.SynchronizationProviderResult;
import org.opends.server.types.operation.PostOperationAddOperation;
import org.opends.server.types.operation.PostOperationDeleteOperation;
import org.opends.server.types.operation.PostOperationModifyDNOperation;
import org.opends.server.types.operation.PostOperationModifyOperation;
import org.opends.server.types.operation.PreOperationAddOperation;
import org.opends.server.types.operation.PreOperationDeleteOperation;
import org.opends.server.types.operation.PreOperationModifyDNOperation;
import org.opends.server.types.operation.PreOperationModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=true, mayInvoke=false)
public abstract class SynchronizationProvider<T extends SynchronizationProviderCfg> {
    public abstract void initializeSynchronizationProvider(T var1) throws ConfigException, InitializationException;

    public boolean isConfigurationAcceptable(SynchronizationProviderCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    public void completeSynchronizationProvider() {
    }

    public void finalizeSynchronizationProvider() {
    }

    public SynchronizationProviderResult handleConflictResolution(PreOperationAddOperation addOperation) throws DirectoryException {
        return new SynchronizationProviderResult.ContinueProcessing();
    }

    public abstract SynchronizationProviderResult doPreOperation(PreOperationAddOperation var1) throws DirectoryException;

    public abstract void doPostOperation(PostOperationAddOperation var1) throws DirectoryException;

    public SynchronizationProviderResult handleConflictResolution(PreOperationDeleteOperation deleteOperation) throws DirectoryException {
        return new SynchronizationProviderResult.ContinueProcessing();
    }

    public abstract SynchronizationProviderResult doPreOperation(PreOperationDeleteOperation var1) throws DirectoryException;

    public abstract void doPostOperation(PostOperationDeleteOperation var1) throws DirectoryException;

    public SynchronizationProviderResult handleConflictResolution(PreOperationModifyOperation modifyOperation) throws DirectoryException {
        return new SynchronizationProviderResult.ContinueProcessing();
    }

    public abstract SynchronizationProviderResult doPreOperation(PreOperationModifyOperation var1) throws DirectoryException;

    public abstract void doPostOperation(PostOperationModifyOperation var1) throws DirectoryException;

    public SynchronizationProviderResult handleConflictResolution(PreOperationModifyDNOperation modifyDNOperation) throws DirectoryException {
        return new SynchronizationProviderResult.ContinueProcessing();
    }

    public abstract SynchronizationProviderResult doPreOperation(PreOperationModifyDNOperation var1) throws DirectoryException;

    public abstract void doPostOperation(PostOperationModifyDNOperation var1) throws DirectoryException;

    public abstract void processSchemaChange(List<Modification> var1);
}

